/**
 *  @author Deepika Parmar
 */
Ext.define('Academia.controller.outcomebasededucation.ObeCorrelationPercentController', {
	extend : 'Academia.controller.base.BaseController',
	models : ['outcomeBasedEducation.OBECorrelationPercentGridModel'],
	
	stores : ['OBECorrelationLevelStore.OBECorrelationPercentGridStore'],
			  
	views : ['baselayout.contentarea.ContentPanel',
		'outcomebasededucation.ObeCorrelationPercentStructure','outcomebasededucation.ObeCorrelationPercentGrid',
		'outcomebasededucation.OBECorrelationFormWindow'],	
		
	refs : [{
		ref: 'contentPanel',
		selector: 'contentPanel'
	},{
		ref:'obecorrelationpercentgrid',
		selector:'obecorrelationpercentgrid'
	},{
		ref:'obecorrelationpercentstructure',
		selector:'obecorrelationpercentstructure'
	},{
		ref:'obecorrelationformwindow',
		selector: 'obecorrelationformwindow'
	}],
	 config: {
		 OBE_CORRELATION_RULES_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('OBE_CORRELATION_RULES_PRIVILEGES')
	  },
	init : function() {
		this.control({
			'obecorrelationpercentstructure': {
				  afterrender : function(structure){
   				   var $this = this;
   				   var grid = structure.down('grid');
   				   $this.getGridHeaderFreeze(grid,structure, false);
   			   }
			},
			'obecorrelationformwindow button[itemId=btnSaveObeCorrelationForm]':{
				click:this.saveObeCorrelationForm
			},
			'obecorrelationformwindow button[itemId=btnCancelObeCorrelationForm]':{
				click: function(button){
					this.getObecorrelationformwindow().close();
				}
			},
			'obecorrelationpercentgrid':{
				afterrender:function(grid){
					 this.doAccessControlValidation(grid, this.getOBE_CORRELATION_RULES_PERMISSION());
					 this.resetPageSetting(grid.getStore());
					 grid.getStore().load();
				}
			},
			'obecorrelationpercentgrid button[itemId=btnAdd]':{
				click: function(button){
					var me = this;
					var obecorrelationformwindow = Ext.widget('obecorrelationformwindow');
					obecorrelationformwindow.show();
				}
			},
			'obecorrelationpercentgrid button[itemId=btnEdit]':{
				click: function(){
					this.editObeCorrelationPercent(false)
				}
			},
			'obecorrelationpercentgrid button[itemId=btnView]': {
    			click: function() {
    				this.editObeCorrelationPercent(true);
    			}
    		},
			'obecorrelationpercentgrid button[itemId=btnDelete]':{
				click: function() {
    				this.deleteObeCorrelationPercent();
    			}
			},
			
    		/* 'attainmentlevelgrid button[itemId=btnSaveItemId]':{
		 			click: function(obj){
		 				this.examSaveManageAttainmentLevelrecord()
		 			}
				}*/
			});
		this.callParent(arguments);
	},
	saveObeCorrelationForm: function(button){
	    button.disable();
		var this$ = this,
		obeCorrelationFormWin= this$.getObecorrelationformwindow(),
    	grid = this$.getObecorrelationpercentgrid(),
    	jsonArray = [],
    	submitUrl, isUpdate = false,
    	obeCorrelationFormWinPanel = obeCorrelationFormWin.down('form'),
    	obeCorrelationFormWinPanelVal = obeCorrelationFormWinPanel.getForm().getFieldValues(),
    	obeCorrelationHiddenId = obeCorrelationFormWin.down('#hideCorrelationId');

    	if (obeCorrelationHiddenId.getSubmitValue() == null || obeCorrelationHiddenId.getSubmitValue() == "" || obeCorrelationHiddenId.getSubmitValue() === undefined) {
    		submitUrl = SERVERURL.PATH_OBE_CORRELATION_LEVEL_CREATE_UPDATE,
    		isUpdate = false;
    		var json = {
        			'levelName': obeCorrelationFormWinPanelVal.code,
        			'levelPercentage': obeCorrelationFormWinPanelVal.doubleValue
        	};
    		jsonArray.push(json);
    	} else {
    		submitUrl = SERVERURL.PATH_OBE_CORRELATION_LEVEL_CREATE_UPDATE,
    		isUpdate = true;
    		var json = {
    				 'id':obeCorrelationFormWinPanelVal.id,
        			'levelName': obeCorrelationFormWinPanelVal.code,
        			'levelPercentage': obeCorrelationFormWinPanelVal.doubleValue
        	};
    		jsonArray.push(json);
    	}
        	Ext.Ajax.request({
    		type: 'rest',
    		url: submitUrl,
    		jsonData: jsonArray,
    		method: 'POST',
    		success: function(form, action) {
				  if(form.responseText=="EXISTS"){
					 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('RECORD_IS_ALREADY_EXIST')); 
				  } else {
					 showSuccessMessage(getExaminationTranslation('SUCCESS'),getCommonTranslation('SUCCESS'));
				  }
    			 
    			  obeCorrelationFormWin.close();
 				  this$.resetPageSetting(grid.getStore());
 				  grid.getStore().load();
 				  grid.getSelectionModel().deselectAll();
    			
    		}
    	});
	},
	editObeCorrelationPercent :function(isView){
		 var me = this;
	        var grid = me.getObecorrelationpercentgrid(),
	        obeCorrelationFormWin= me.getObecorrelationformwindow();
	        if (grid.getSelectionModel().getCount() > 0) {
	            var records = grid.getSelectionModel().getSelection();
	            if (isEmpty(obeCorrelationFormWin)) {
	            	obeCorrelationFormWin = Ext.widget('obecorrelationformwindow');
	            }
	            obeCorrelationFormWin.show();
	            if (records != "" && records != null && records != undefined) {
	                var obeCorrelationFormWin = me.getObecorrelationformwindow();
	                var formPnl = obeCorrelationFormWin.down('form');
	                var rec = new Academia.model.outcomeBasedEducation.OBECorrelationPercentGridModel(
	                records[0].data);
	                formPnl.loadRecord(rec);
	                grid.getStore().reload();
	                if (isView) {
	                	obeCorrelationFormWin.down('#btnSaveObeCorrelationForm').setVisible(false);
	                    toggleReadOnlyFormItems(formPnl.getForm(), true);
	                }
	            }
	        } else {
	        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
	        }
	},
	deleteObeCorrelationPercent: function(){
		var grid = this.getObecorrelationpercentgrid();
    	var grdStore = grid.getStore();
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getCommonTranslation('ALERT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
    			if (btn == 'yes') {
    				if (grid.getSelectionModel().getCount() > 0) {
    					var records = grid.getSelectionModel().getSelection();
    					for (var count = 0; count < records.length; count++) {
    						var id = "";
    						if (records[count].get("id") != "" && records[count].get("id") != undefined && records[count].get("id") != null) {
    							id = records[count].get("id");
    						}
    						Ext.Ajax.request({
    							type: 'rest',
    							method: 'GET',
    							url: SERVERURL.PATH_OBE_CORRELATION_LEVEL_DELETE  + '?id=' + id,
    							headers: {
    								'Content-Type': 'application/json'
    							},
    							params: {
    								id: id
    							},
    							success: function(form, action) {
    								if (form.responseText == "false" || form.responseText == false) {
    									showWarningMessage(getCommonTranslation('ALERT'), getExaminationTranslation('CORRELATION_PERCENT_DEPENDENCY_EXIST_ON_DELETE'));
    								} else {
    									showSuccessMessage(getExaminationTranslation('SUCCESS'),getCommonTranslation('SUCCESS'));
    									grid.getStore().reload();
 									    grid.getSelectionModel().deselectAll();
    								}

    							},
    							failure: function(form, action) {
    								showWarningMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
    							}
    						});
    					}
    				}
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
	}
	
});