
/**
 * This controller is used for the faculty profile controller.
 * @author Sachin.Bangar
 */

Ext.define('Academia.controller.personinfo.faculty.FacultyListController', {
    extend: 'Academia.controller.personinfo.common.PersonCommonController',

    stores: ['personinfo.faculty.FacultyTypeStore','common.ProgramByAcAndLoIdStore','servicerequest.ServiceRequestCategory',
             'servicerequest.ServiceRequests','common.SelectNameComboStore','program.programbatchdetail.BatchStore',
             'admission.applications.admissionAndMidTermAdmission.PeriodComboStore','coursetransaction.sectionmanagement.CourseSectionCombo',
             'coursetransaction.sectionmanagement.SectionsStore','facilitiesresources.resourcebooking.departmentFilterStore',
             'common.StatusComboStore','coursetransaction.sectionmanagement.FacultyIdValueSmartSearch', 'coursetransaction.coursereading.CourseByPeriod',
             'personinfo.faculty.FacultySurveyStr','userGroup.UserGroupStore','user.EmployeeTypeStore','setup.templatemapping.TemplateName',
             'setup.templatemapping.TemplateNameList', 'importutility.ImportFaculty','importutility.ModuleName', 'common.AcademyLocationNameSeparated',
             'setup.templatemapping.TemplateNameListFacultyByCode','committee.committee.CommitteeStore','attendance.UserGroup','hostel.roomallocation.UserSmartSearchByUserType',
             'committee.committee.MessageTypeNotificationStore','messaging.MessagingTemplatesStore','messaging.StaticDocumentAttachmentGridStore',
             'committee.committee.CommitteeStore','common.DesignationTypeStore','securitysetup.LeaveCategorTypeStore','calendar.ActiveCalendarStore','calendar.StaffWorkHourStore',
             'calendar.ActiveStaffCalendarStore','calendar.StaffCalendarByIdStore','calendar.FacultyWorkHoursStore','calendar.StaffCalendarByCalendarIdStore',
             'coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch','criteriabuilder.userquicksearch.QuickSearchName','admission.applications.applicationBase.BulkDocumentGroupStore',
             'sgappointment.sgappointment.SGVisitorCategoryStore','sgappointment.sgappointment.SGParentGuardianStore','enquiry.EnquiryCodeSearchStore','common.CountryStore','coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
             'sgappointment.sgappointment.SGReasonForVisitStore','sgappointment.sgappointment.SGVisitStatus','hostel.roomallocation.UserSmartSearchByUserType','sgappointment.sgappointment.SGAppointmentFacultyGridStore',
             'messaging.SendMessageReportContactStore',
             'criteriabuilder.userquicksearch.QuickSearchPrintNameStore',
             'messaging.SendMessageReportRecipientStore',
             'messaging.SendMessageReportEventNameStore',
             'messaging.CommunicationHistoryReportList',
             'messaging.MessageTemplate',
             'Academia.store.messaging.MessageCategoryStore',
             'messaging.MessageSubCategoryStore',
             'Academia.store.messaging.MessageSearchConfigs',
             'messaging.CommunicationHistoryEmailStore',
             'messaging.CommunicationHistoryMobileStore',
             'admission.applications.applicantProfileBase.ApplicantSmartSearchStore',
             'facilitiesresources.resourcebooking.subdepartmentFilterStore','Academia.store.common.GenderTypeStore','kohalibrarytransation.AcademyLocationCategoryStore',
             'kohalibrarytransation.AcademyLocationBranchStore','servicerequest.ServiceRequestConfiguredCategoryStore',
             'messaging.SendMessageAttachedDocumentStore', 'enquiry.EnqIntermediateType', 'setup.templatemapping.DocumentRequesDGMListFaculty','feeandpayment.managebill.Student',
             'enquiry.EnqIntermediateType','election.election.ElectionVoterPoolCodeNameStore','user.UserAcademyLocationStore','sgappointment.sgappointment.SGAppointmentFlagIdStore','criteriabuilder.userquicksearch.UserImportTabStore'],
   
    views: ['criteriabuilder.grid.SearchResultGrid', 'personinfo.faculty.FacultyQuickSearchForm', 
            'personinfo.faculty.FacultyQuickSearchView', 'personinfo.faculty.FacultyListView',
            'personinfo.faculty.FacultyProfile', 'personinfo.faculty.CreateFacultyProfile',
            'servicerequest.FacultyRequestComboPanel','personinfo.common.PersonDetailsLinkPanel','personinfo.common.PersonInfoPanel','common.StatusCombo','personinfo.faculty.FacultyRaiseServiceRequestWindow',
            'personinfo.faculty.FacultySendSurvey','personinfo.faculty.FacultybulkPrintWidow', 
            'personinfo.faculty.uploaddownload.FacultyUploaddownloadStructure', 'personinfo.faculty.uploaddownload.FacultyUploadForm', 'personinfo.faculty.uploaddownload.FacultyDownloadForm',
            'importutility.ImportByModule.ImportListFaculty','personinfo.dashlet.FacultyInfoDashboardHomePage','committee.committee.CommitteeALWindow','personinfo.faculty.FacultySendMessages',
            'messaging.FacultyStaticDocumentAttachmentGrid','calendar.AssignWorkCalendarWindow','personinfo.faculty.StaffWorkHoursGrid','personinfo.faculty.WorkHourDetailsGrid',
            'calendar.EmployeeWorkHoursWindow','admission.applications.applicationBase.BulkDownloadDocumentWin','sgappointment.sgappointment.SGAppointmentForm','personinfo.faculty.FacultyAppointmentStructure',
            'personinfo.faculty.FacultyAppointmentStructureTab','personinfo.faculty.SGAppointmentFacultyDetailGrid',
            'messaging.report.CommunicationHistoryStructure',
			'messaging.report.CommunicationHistoryList', 'UploadOptionRadioGroup','kohalibrarytransaction.KohaStudentLibraryMappingWin',
			'kohalibrarytransaction.KohaFacultyLibraryMappingWin',
			'kohalibrarytransaction.KohaFacultyCategoryMappingWin','messaging.report.SendMessageAttachedDocumentWin','personinfo.faculty.FacultyRequestDocumentWidow',
			'personinfo.student.VoterPoolWindow','personinfo.faculty.EmployeeImportStructure','personinfo.faculty.EmployeeImportView'],
    models :['sgappointment.sgappointment.SGAppointmentModel', 'Academia.model.criteriabuilder.AdvancedSearchConfig',
             'messaging.CommunicationHistoryContactModel'],

    alias: "widget.facultylistcontroller",
    facultyProfile:'null',
    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    },{
    	ref : 'facultyQuickSearchForm',
    	selector : 'facultyquicksearchform[itemId=facultyQuickSearchForm]'
    }, {
        ref: 'raiseServiceRequestWindow',
        selector: 'facultyraiseservicerequestwindow'
    }, {
        ref: 'facultySearchResultGrid',
        selector: 'searchresultgrid[itemId=facultySearchResultGrid]'
    },
    {
        ref: 'searchResultGrid',
        selector: 'searchresultgrid[itemId=facultySearchResultGrid]'
    },{
    	ref:'facultyListView',
    	selector:'facultylistview'
    },{
    	ref:'facultyRequestComboPanel',
    	selector:'facultyrequestcombopanel'
    },{
    	ref:'facultyquicksearchview',
    	selector:'facultyquicksearchview'
    },/*{
    	ref :'sendMessageWindow',
    	selector : 'sendmessagewindow[itemId=facultyListSendMessageWindow]'
    },*/{
    	ref :'facultysendmessages',
    	selector : 'facultysendmessages[itemId=facultyListSendMessageWindows]'
    },{
    	ref :'facultyStaticDocumentAttachmentGrid',
    	selector : 'facultystaticdocumentattachmentgrid[itemId=facultystaticdocumentattachmentgridMessage]'
    },{
    	ref :'facultysendsurvey',
    	selector : 'facultysendsurvey'
    },{
    	ref :'facultySendsurvey',
    	selector : 'facultysendsurvey form'
    },{
    	ref :'facultybulkprintwidow',
    	selector : 'facultybulkprintwidow[itemId=facultyPrintIdWindow]'
    },{
    	ref :'facultybulkprintwidow',
    	selector : 'facultybulkprintwidow form'
    },{
    	ref:'importListFaculty',
    	selector:'importlistfaculty'
    },
    {
    	ref :'facultyinfodashboardhomepage',
    	selector : 'facultyinfodashboardhomepage'
    },
    {
    	ref :'facultyuploadform',
    	selector : 'facultyuploadform'
    },{
    	ref :'facultycommitteealwindow',
    	selector : 'committeealwindow [itemId=facultyMapCommitteeWindow]' 
    },{
    	ref :'assignworkcalendarwindow',
    	selector : 'assignworkcalendarwindow'
    },{
    	ref :'staffworkhoursgrid',
    	selector : 'staffworkhoursgrid' 
    },{
    	ref :'workhourdetailsgrid',
    	selector : 'workhourdetailsgrid' 
    },{
    	ref :'employeeworkhourswindow',
    	selector : 'employeeworkhourswindow' 
    },{
        ref: 'bulkdownloaddocumentwin',
        selector: 'bulkdownloaddocumentwin[itemId=employeebulkdownloaddocumentwin]'
    },{
    	ref: 'facultysgappointmentform',
    	selector: 'sgappointmentform[itemId=facultySGAppointmentFormItemId]'
    },{
    	ref: 'facultyappointmentstructure',
    	selector: 'facultyappointmentstructure'
    },{
    	ref: 'sgappointmentfacultydetailgrid',
    	selector: 'sgappointmentfacultydetailgrid[itemId=SGAppointmentFacultyDetailGridId]'
    },{
    	ref: 'facultyappointmentstructuretab',
    	selector: 'facultyappointmentstructuretab'
    },{
		ref : 'communicationhistorystructure',
		selector : 'communicationhistorystructure[itemId=facultycommunicationhistorystructureItemId]'
	}, {
    	ref : 'communicationhistorylist',
    	selector : 'communicationhistorylist'
	},{
		ref : 'facultyprofile',
		selector : 'facultyprofile'
	},{
		ref : 'uploadoptionradiogroup',
		selector : 'uploadoptionradiogroup[itemId=employeeUpdateUploadOptionRadioGroupItemId]'
	},{
		ref: 'kohafacultylibrarymappingwin',
		selector: 'kohafacultylibrarymappingwin'
	},{
		ref: 'kohafacultycategorymappingwin',
		selector: 'kohafacultycategorymappingwin'
	},{
    	ref : 'sendmessageattacheddocumentwin',
    	selector : 'sendmessageattacheddocumentwin[itemId=facultysendmessageattacheddocumentwin]'
    },{
    	ref :'facultyrequestdocumentwidow',
    	selector : 'facultyrequestdocumentwidow[itemId=facultyrequestdocumentId]'
    },{
		ref: 'voterpoolwindow',
		selector: 'voterpoolwindow[itemId=facultyvoterpoolwindow]'
	},{
		ref:'facultydownloadform',
		selector:'facultydownloadform'
	},{
		ref:'employeeImportStructure',
		selector:'employeeImportStructure'
	}],
    config: {
    	FACULTY_LIST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_LIST_PRIVILEGES'),
    	STUDENT_MY_DASHBOARD_PERMISSIONS:  Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_MY_DASHBOARD_PRIVILEGES'),
    	FACULTY_WORK_HOURS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_WORK_HOURS_PRIVILEGES'),
    	EMPLOYEE_MANAGE_APPOINTMENT_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_MANAGE_APPOINTMENT_PRIVILEGES'),
    	MANAGE_APPOINTMENT_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_APPOINTMENT_PRIVILEGES'),
    	CORE_ERP_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LOADER_PRIVILEGES'),
    	FACULTY_PROFILE_COMMUNICATION_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_COMMUNICATION_HISTORY_PRIVILEGES'),
    	requestType: 'FACULTY_REQUEST'
    },
    init: function(application) {
    	this.control({
    		'facultyquicksearchview':{
    			render : function(){
    				this.customzingViewForFacultyPortal();
    			},
    			afterrender : function(structure){					
    				var grid = structure.down('searchresultgrid');
    				this.getCBGridHeaderFreeze(grid,structure);
    			}
    		},
    		/*'studentlistview':{
        		activate: function() {
        			var $this=this;
        		  if($this.getCurrentLoggedPortalId() == 3){
        			  $this.customzingViewForStudentPortal();
        		  }else{
        			  $this.loadGridAndSearchUsers(); 
        		  }
                }
        	},*/
        	'kohafacultylibrarymappingwin customcombobox[itemId=library]':{
				render: function(cmb){
					var store = cmb.getStore();
					store.getProxy().extraParams = {
						academyLocationId: this.getCurrentAcademyLocation()
					};
					store.load();
				}
			},
			'kohafacultycategorymappingwin customcombobox[itemId=category]':{
				render: function(cmb){
					var store = cmb.getStore();
					store.getProxy().extraParams = {
						academyLocationId: this.getCurrentAcademyLocation()
					};
					store.load();
				}
			},
        	'facultylistview':{
        		afterrender: function(structure) {
        			var $this=this;
        			if($this.getCurrentLoggedPortalId() == 3 || $this.getCurrentLoggedPortalId() == 7){
        				$this.customzingViewForFacultyPortal();
        			}else{
        				var formLayout = $this.getFacultyQuickSearchForm();
        				var multiBrandCampusId = formLayout.down('#empMultiBrandCampusItemId');
        				var ALComboStore = multiBrandCampusId.getStore();
        				ALComboStore.load({
        					callback: function(records, operation, success) {
        						if (success) {
        							multiBrandCampusId.select(multiBrandCampusId.getStore().collect(multiBrandCampusId.valueField));
        							//$this.loadGridAndSearchUsers(); 	
        						}
        					}   
        				});			
        			}
        			var grid = structure.down('searchresultgrid');
        			this.getCBGridHeaderFreeze(grid,structure,true);
        		},
        		beforerender:function(structure){
        			this.disableImportEmployeeUpdate(structure, this.getFACULTY_LIST_PERMISSIONS());
        		},
        		/*afterrender : function(structure){					
        			var grid = structure.down('searchresultgrid');
        			this.getCBGridHeaderFreeze(grid,structure,true);
        		}*/
        	},
        	'facultyquicksearchview form[itemId=facultyQuickSearchForm] combo[itemId=selectedNameField]': {
        		change: this.changeNameFieldConfig
            },
            'facultyquicksearchview form[itemId=facultyQuickSearchForm] button[itemId=searchButtonId]': {
                click: function() {
                	this.loadGridAndSearchUsers(); 	 			
                }
            },
            
            'facultyquicksearchview form[itemId=facultyQuickSearchForm] customcombobox#userGroupType' : {
	        	  select: function(obj, record, eOpts) {
	        		    var userGroupName = record[0].get("userGroupName");
	        		    this.hideOrShowFacultyEmployeeType(userGroupName);
	        	  }
	        },
	        'facultyquicksearchview form[itemId=facultyQuickSearchForm] combo[itemId=cmbDepartment]' : {
	        	select: function(obj, record) {
	        		this.getEmployeeSubDepartment(record[0].get("id"));
	        	}
	        },
            'facultyraiseservicerequestwindow facultyrequestcombopanel button[itemId=raiseButtonId]': {
 	            click: function(btn) {
 	            	var serviceRequestCategoryCombo = btn.up('form').down('#serviceRequestCategoryCombo').getValue();
 	            	var serviceRequestCombo = btn.up('form').down('#serviceRequestCombo').valueModels[0];
 	            	this.openServiceRequestTab(this.getRequestType(),serviceRequestCategoryCombo,serviceRequestCombo);  
 	            	 btn.up('form').up('window').close();
 	            }
 	        },
 	        
 	       'facultyraiseservicerequestwindow facultyrequestcombopanel button[itemId=cancelButtonId]': {
	            click: function(btn) {
	            	 btn.up('form').up('window').close();
	            }
	        },
	        'facultyraiseservicerequestwindow facultyrequestcombopanel[itemId=facultyRequestComboPanel]': {
 	            render: function(form) {
	            	var serviceRequestCategoryCombo = form.down('#serviceRequestCategoryCombo');
	            	var academyLocationId = this.getCurrentAcademyLocation();
                   	var store = serviceRequestCategoryCombo.getStore();
                   	store.proxy.extraParams = {
                   			serviceRequestCategory : 'FACULTY_REQUEST',
                   			academyLocationId:academyLocationId
  					};
                   	store.load();
	            }
 	        },
            'facultyquicksearchview form[itemId=facultyQuickSearchForm] button[itemId=resetButtonId]': {
                click: function(){
                	this.resetFacultySearchForm();
                }
            },
            'facultyquicksearchview searchresultgrid[itemId=facultySearchResultGrid]': {
                cellclick: this.cellClickFacultySearchResultGrid,
                render: function(grid) {
                	this.gridRenderFunction(grid); 		
                	this.genericCBGridAccessControlValidation(grid, this.getFACULTY_LIST_PERMISSIONS());
                this.disableMoreActionPivileges(grid, this.getFACULTY_LIST_PERMISSIONS());
  					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
  			   		viewButton.setVisible(false);
	    		},
	    		afterrender:function(grid){
					var me=this;
					me.addDataGridConfigButton(grid,me.getFACULTY_LIST_PERMISSIONS());
				},
	    		selectionchange: function(column, selected,eOpts ){
                	this.disableExtraButton(column,selected);                	
                }
            },  
            'advancedsearchquerybuilder[itemId=facultyListAdvanceSearch] searchresultgrid[itemId=userAdvSearchResultGrid]': {
            	cellclick: this.cellClickFacultySearchResultGrid,
                /*render: function(grid) {
                	this.gridRenderFunction(grid);
                	this.genericCBGridAccessControlValidation(grid, this.getFACULTY_LIST_PERMISSIONS());
  					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
  			   		viewButton.setVisible(false);
	    		}*/
            },
            /*'facultylistview advancedsearchquerybuilder': {
                render: function(panel) {
                    var comboPanel = Ext.widget('facultyrequestcombopanel');
                    panel.add(comboPanel);
                }
            },*/
            
            'facultyraiseservicerequestwindow combo[itemId=serviceRequestCategoryCombo]':{
            	select:function(combo,records) {
            		var value = records[0].get('value');
            		this.loadOnComboChange(value);
                }
            },
            
            'facultyrequestcombopanel combo[itemId=serviceRequestCategoryCombo]':{
            	select:function(combo,records) {
            		var value = records[0].get('value');
            		this.loadOnComboChange(value);
                }
            },
            // comment out this function by swapnil bcz request was submiting on select request_sub_type 
            'facultyrequestcombopanel combo[itemId=serviceRequestCombo]':{
            	select:function(combo,records) {
            		var value = records[0];
        			var requestGroup = combo.up('panel').down('#serviceRequestCategoryCombo').getValue();
        			//this.openServiceRequestTab(this.getRequestType(),requestGroup,value);
                }
            },
            'facultyraiseservicerequestwindow combo#serviceRequestCombo':{
            	select:function(combo,records) {
//            		var value = records[0];
//            		var requestGroup = combo.up('panel').down('#serviceRequestCategoryCombo').getValue();
//            		this.openServiceRequestTab(this.getRequestType(),requestGroup,value);
            //		combo.up('panel').down("#raiseButtonId").setDisabled(false);

            	}
            },
            
            'searchresultgrid[itemId=facultySearchResultGrid] menuitem[itemId=raiseRequestButtonItemId]': {
	            click: function(obj) {
	            	var grid = this.getSearchResultGrid();
	            	if (grid.getSelectionModel().getCount() > 0) {
	            		this.openRaiseRequestWindow();
	            	} else {
	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	            	}  
	            }
	        },
	        
	        
	        'searchresultgrid[itemId=facultySearchResultGrid] menuitem[itemId=assignEmployeeCommitteeBtn]': {
	            click: function(obj) {
	            	var grid = this.getSearchResultGrid();
	            	if (grid.getSelectionModel().getCount() > 0) {
	            		this.openAssignFacultyCommitteeWindow();
	            	} else {
	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	            	}  
	            }
	        },
	        'searchresultgrid[itemId=facultySearchResultGrid] menuitem[itemId=kohafacultycategorymappingBtn]': {
         	   click: function(obj) {
         		   var grid = this.getSearchResultGrid();
         		   if (grid.getSelectionModel().getCount() > 0) {
         			   var this$ = this;
         			   var window = this$.getKohafacultycategorymappingwin();
         			   if(!window){
         				   window = Ext.widget('kohafacultycategorymappingwin');
         			   }
         			   window.show();
         		   } else {
         			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
         		   }  
         	   }
            },'searchresultgrid[itemId=facultySearchResultGrid] menuitem[itemId=kohafacultylibrarymappingBtn]': {
         	   click: function(obj) {
        		   var grid = this.getSearchResultGrid();
        		   if (grid.getSelectionModel().getCount() > 0) {
        			   var this$ = this;
        			   var window = this$.getKohafacultylibrarymappingwin();
        			   if(!window){
        				   window = Ext.widget('kohafacultylibrarymappingwin');
        			   }
        			   window.show();
        		   } else {
        			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        		   }  
        	   }
           }
            ,'kohafacultycategorymappingwin button#saveBtn': {
         	   click: function(obj) {
         		   this.saveFacultyCategoryDetails(obj);
         	   }
            },
            'kohafacultylibrarymappingwin button#saveBtn': {
         	   click: function(obj) {
         		   this.saveFacultyLibraryDetails(obj);
         	   }
            },
	        'searchresultgrid[itemId=facultySearchResultGrid] menuitem[itemId=assignEmployeeWorkCalendarBtn]': {
	            click: function(obj) {
	            	var grid = this.getSearchResultGrid();
	            	if (grid.getSelectionModel().getCount() > 0) {
	            		this.openAssignCalendarWindow();
	            	} else {
	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	            	}  
	            }
	        },
	        
	        'assignworkcalendarwindow[itemId=assignworkcalendarwindowItemId] button#btnSaveEmployeeCalendar': {
	        	click: function(button) {
	        		var grid = this.getSearchResultGrid();
	        	//	var record=grid.getSelectionModel().getSelection()[0];
	        		var record=grid.getSelectionModel().getSelection();
	        		this.saveAssignWorkCalendar(record);
	        	}
	        },
            
	        'assignworkcalendarwindow[itemId=assignworkcalendarwindowItemId] button#btnCancel': {
	        	click: function(button) {
	        		 this.getAssignworkcalendarwindow().close();
	        	}
	        },
	        
	        'committeealwindow[itemId=facultyMapCommitteeWindow] button#submitBtn': {
	        	click: function(button) {
	        		var grid = this.getSearchResultGrid();
	        		button.up('window').persistCommitteeMaping(button,grid);
    			}
	        },'facultysendmessages[itemId=facultyListSendMessageWindows] radiogroup[itemId=messageType]':{
    			change : function(val,nV,oV){
    				this.selectFacultySectionMessageType(val,nV,oV);
    			}
    		},
    		'facultysendmessages[itemId=facultyListSendMessageWindows] customcombobox[itemId=msgTempletId]':{
    			select : function(obj,rec){
    				this.selectFacultyMessageTemp(obj,rec);
    			}
    		},
    		'facultysendmessages[itemId=facultyListSendMessageWindows] button[itemId=adhocMsgSubmitBtn]':{
    			click: function(obj) {
    				var grid = this.getSearchResultGrid();
    				var facultysendmessage = this.getFacultysendmessages();
    				var formPnl = obj.up('form');
   	        		var isMySelfChecked = false;
   	        		var fldValues = formPnl.getForm().getFieldValues();
   	        		isMySelfChecked = fldValues.recieverType;
   	        		var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
    				facultysendmessage.sendMessage(obj,grid,isMySelfChecked,currentlyLoggedInUserId);
    			}
    		},'facultysendmessages[itemId=facultyListSendMessageWindows]  filefield[itemId=staticUploadFileField]': {
	            change: function(fileField, value, eOpts){
	            	var this$ = this;
	            	this$.uploadFacultyStaticDocumentFileMessage(fileField, value, eOpts);
	            }
            },
            'facultystaticdocumentattachmentgrid[itemId=facultystaticdocumentattachmentgridMessage] actioncolumn': {
            	click : function(view, rowIndex, colIndex, item, e, record, row){
            		this.deleteFacultyStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
            	}
            },'facultysendmessages[itemId=facultyListSendMessageWindows]': {
    			render: function(grid){
	            	var this$ = this;
	            	var docGrid = grid.down('#facultystaticdocumentattachmentgridMessage');
	            	docGrid.getStore().removeAll();
	            	docGrid.getStore().sync();
	            	var itemIdPrivilegeNameArray = [{"#adhocMessage" : "ADHOC_MESSAGE" , "#messageTemplate" : "MESSAGE_TEMPLATE", "radioGroupItemId" : "#messageType", "defaultButtonItemId" : "#adhocMessage" }];
  	        		this$.disableRadioGroupAndOtherPivileges(grid, this$.getFACULTY_LIST_PERMISSIONS(), itemIdPrivilegeNameArray);
	            }            
            },'facultysendmessages[itemId=facultyListSendMessageWindows] radiogroup#sendingPriority': {
            	change: function( radio, newValue, oldValue, eOpts) {
            		this.loadFacultyScheduleField(radio, newValue, oldValue);
            	}
            },
            /*V2D-13247*/
            'facultysendmessages[itemId=facultyListSendMessageWindows] textarea[itemId=smsDiscription]':{
            	change : function(val,nV,oV){
            		var facultySendMessages = this.getFacultysendmessages();
            		var academyLocId = this.getCurrentAcademyLocation();
            		var smsTextField = facultySendMessages.down('#smsDiscription');
            		var smsTextFieldDiscription = facultySendMessages.down('#smsDiscriptionNotice');
            		var maxLength = localStorage.getItem('maxLength');
            		var newValue = maxLength - smsTextField.getValue().length;
            		smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');
            	}
            },
            'facultysendmessages[itemId=facultyListSendMessageWindows] textarea[itemId=pushNotificationDiscription]':{
  	        	change : function(val,nV,oV){
  	        		var facultySendMessages = this.getFacultysendmessages();
  	        		var pushTextField = facultySendMessages.down('#pushNotificationDiscription');
  	        		var pushTextFieldDiscription = facultySendMessages.down('#pushNotificationDiscriptionNotice');
  	        		var maxLength = 1000;
  	        		var newValue = maxLength - pushTextField.getValue().length;
  	        		pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
  	        	}
  	        },
	        
	        'searchresultgrid[itemId=facultySearchResultGrid] button[itemId=sendMessageBtn]': {
	          /*  click: function(obj) {
                	var grid = this.getSearchResultGrid();
	            	if (grid.getSelectionModel().getCount() > 0) {
	            		var this$ = this;
	                	var window = this$.getSendMessageWindow();
	                	if(!window){
	                		window = Ext.widget('sendmessagewindow',{
	                			itemId:'facultyListSendMessageWindow'
	                		});
	                		window.down('#msgRecipientTypeItemId').setValue(RECIPIENT_TYPES_COSTANTS.FACULTY);
	                	}
	                	window.show();
	            	} else {
	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	            	}  
	            }*/
	        	click: this.openFacultySendMessage
	        },
	        'searchresultgrid[itemId=facultySearchResultGrid] menuitem[itemId=sendSurveyBtn]': {
	            click: function(obj) {
                	var grid = this.getSearchResultGrid();
	            	if (grid.getSelectionModel().getCount() > 0) {
	            		var this$ = this;
	                	var window = this$.getFacultysendsurvey();
	                	if(!window){
	                		window = Ext.widget('facultysendsurvey');
//	                		window.down('#msgRecipientTypeItemId').setValue(RECIPIENT_TYPES_COSTANTS.FACULTY);
	                	}
	                	window.show();
	            	} else {
	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	            	}  
	            }
	        },
	        'facultysendsurvey button#saveBtn': {
	        	click: function(button) {
	        		this.sendSurveyDetails();
    			}
	        },
	        /*'sendmessagewindow[itemId=facultyListSendMessageWindow] button#adhocMsgSubmitBtn': {
	        	click: function(button) {
	        		var grid = this.getSearchResultGrid();
	        		button.up('window').sendMessage(button,grid);
    			}
	        },*/
	        
	        'facultybulkprintwidow[itemId=facultyPrintIdWindow] button#btnPrint':{
	        	click: function(button) {
	        		var grid = this.getSearchResultGrid();
	        		this.exportFacultyIdCardJRXML('pdf',grid, button);
    			}
	        },
	       'facultyrequestdocumentwidow[itemId=facultyrequestdocumentId] button#btnrequest':{
	        	click: function(button) {
	        		var grid = this.getSearchResultGrid();
	        		this.documentRequestFaculty(button);
    			}
	        },
	        /*'sendmessagewindow[itemId=facultyListSendMessageWindow] combo#selectTemplate': {
	        	render: function(combo) {
	        		var store = combo.getStore();
	        		var msgRecipientTypeId = combo.up('window').down('#msgRecipientTypeItemId').getValue();
	        		 store.on('beforeload', function(store, operation) {
	                     store.proxy.extraParams = {
	                    		 msgRecipientTypeId :msgRecipientTypeId
	                     };
	                 });
    			},
    			select :function(combo,records){
    				var msgCategoryId = combo.up('window').down('#msgCategoryId');
    				var msgSubCategoryId = combo.up('window').down('#msgSubCategoryId');
    				msgCategoryId.setValue(records[0].data.msgCategoryId);
    				msgSubCategoryId.setValue(records[0].data.msgSubCategoryId);
    			}
	        },*/
	        
            
            
            'facultyquicksearchview[itemId=facultyQuickSearch] combo[itemId=program]': {
            	afterrender : function(combo){
                   	var academyLocationId = this.getCurrentAcademyLocation();
                   	var store = combo.getStore();
                   	store.proxy.extraParams = {
  							 academyLocationId : academyLocationId
  					};
            	},
              	 select: function(programCombo, records) {
                   	var this$ = this;
                   	var basicFacultytSearchForm=this.getFacultyQuickSearchForm();
                   	var batchCombo = basicFacultytSearchForm.down('#batch');
                   	this$.loadDependentCombo(batchCombo, programCombo.getValue(), 'id');
              	 },
                   
               },
               
               'facultyquicksearchview[itemId=facultyQuickSearch] combo[itemId=batch]': {
                	 select: function(batchCombo) {
                		 var this$ = this;
                		 var basicFacultytSearchForm=this.getFacultyQuickSearchForm();
                		 var periodCombo = basicFacultytSearchForm.down('#period');
                		 this$.loadDependentCombo(periodCombo, batchCombo.getValue(), 'id');
                     }
                 },
                 
                 'facultyquicksearchview[itemId=facultyQuickSearch] combo[itemId=period]': {
                   	 select: function(periodCombo) {
                   		var this$ = this;
                   		var basicFacultytSearchForm=this.getFacultyQuickSearchForm();
                   		var sectionCombo = basicFacultytSearchForm.down('#section');
                   		this$.loadDependentCombo(sectionCombo, periodCombo.getValue(), 'periodId');
                        	             	                	
                   	 }
                 },
                    
                  'facultyquicksearchview[itemId=facultyQuickSearch] combo[itemId=section]': {
                      	 select: function(sectionCombo) {
                      		var this$ = this;
                       		var basicFacultytSearchForm=this.getFacultyQuickSearchForm();
                       		var courseCombo = basicFacultytSearchForm.down('#course');
                       		var periodCombo = basicFacultytSearchForm.down('#period');
                       		this$.loadDependentCombo(courseCombo, periodCombo.getValue(), 'periodId');
                      		            	                	
                       }
                   },               
	               'searchresultgrid[itemId=facultySearchResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	    	            click: function() {
	    	                this.exportFacultyList(SERVERURL.PDFEXPORT,'pdf',false);
	    	            }
	    	        },
	    	        'searchresultgrid[itemId=facultySearchResultGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	    	            click: function() {
	    	                this.exportFacultyList(SERVERURL.PDFEXPORT,'pdf',true);
	    	            }
	    	        },
	    	        'searchresultgrid[itemId=facultySearchResultGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	    	            click: function() {
	    	                this.exportFacultyList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
	    	            }
	    	        },
	    	        'searchresultgrid[itemId=facultySearchResultGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	    	            click: function() {
	    	                this.exportFacultyList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
	    	            }
	    	        },
	    	        'facultyrequestcombopanel[itemId=facultyRequestComboPanel] button[itemId=clearBtn]': {
	                       click: function(btn) {
	                           this.onClickClearRequestTypeCombo(btn);
	                       }
	                },
	                'searchresultgrid[itemId=facultySearchResultGrid] button[itemId=printCardBtn]': {
        	            click: function(obj) {
        	            	var grid = this.getFacultySearchResultGrid();
        	            	if (grid.getSelectionModel().getCount() > 0) {
        	            		this.showFacultyBulkPrintWin();
        	            	} else {
        	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	            	}
        	            }
        	        },
        	        'searchresultgrid[itemId=facultySearchResultGrid] menuitem[itemId=documentRequest]': {
        	            click: function(obj) {
        	            	var grid = this.getFacultySearchResultGrid();
        	            	this.showFacultyRequestDocumentWin();
        	            	
        	            }
        	        },
        	       
        	        'facultyuploaddownloadstructure radiogroup[itemId=importDownloadgroupId]':{
        	 			   change: this.facultyDownloadUploadFormChange
        	 		},
        	 		'facultydownloadform button[itemId=resetBtn]':{
        	 			click:function(obj){
    	 				   var $this = this;
    	 				   var form =obj.up('facultydownloadform').getForm();
    	 				   form.reset();
        	 			}  
        	 		},
        	 		'facultydownloadform button[itemId=downoladBtnId]':{
        	 			click:function(obj){
        	 				var $this = this;
        	 				var form =obj.up('facultydownloadform').getForm();
        	 				var deparmentalId = obj.up('facultydownloadform').down('#deparmentalId');
        	 				var templateTypeFacultyId = obj.up('facultydownloadform').down('#templateTypeFacultyId');
        	 				var csvForm = Ext.create('Ext.form.Panel'); 
        	 				var academyLocationStr;
        	 				var deptStr;
        	 		    	var values = form.getValues();
        	 		    	var aL = values.academyLocation;
        	 		    	var alArray=[];
        	 		    	if(aL !=undefined && aL.length > 0) {
        	 		    		for(var i in aL) {
        	 		    			if(Ext.isObject(aL[0])) {
        	 		    				alArray.push(aL[i].get("id"));
        	 		    			} else {
        	 		    				alArray.push(aL[i]);
        	 		    			}
        	 		    		}
        	 		    		academyLocationStr= alArray.join();
        	 		    	} else {
        	 		    		academyLocationStr = null;
        	 		    	}	
        	 		    	var departId= [];
        	 		    	var departVal =deparmentalId.getValue();
        	 		    	if(departVal !=undefined && departVal.length > 0) {
        	 		    		for(var i in departVal) {
        	 		    			if(Ext.isObject(departVal[0])) {
        	 		    				departId.push(departVal[i].get("id"));
        	 		    			} else {
        	 		    				departId.push(departVal[i]);
        	 		    			}
        	 		    		}
        	 		    	}
        	 		    	if(templateTypeFacultyId.getValue() == 'IMPORT_BULK_EMPLOYEE_OTHER_DETAILS'){
        	 		    		csvForm.getForm().submit({
            	 					target: '_blank',
            	 					method:'POST',
            	 					params :{
            	 						access_token : Ext.Ajax.defaultHeaders.access_token,
            	 						academyLocationIds : academyLocationStr,
            	 						deptIds:departId.join()
            	 					},
            	 					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
            	 					url: SERVERURL.DOWNLOAD_TEMPLATE_USER_OTHER_DETAILS,
            	 					standardSubmit :true
            	 				});
        	 		    	}else{
        	 		    		csvForm.getForm().submit({
            	 					target: '_blank',
            	 					method:'POST',
            	 					params :{
            	 						access_token : Ext.Ajax.defaultHeaders.access_token,
            	 						academyLocationIds : academyLocationStr
            	 					},
            	 					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
            	 					url: SERVERURL.DOWNLOAD_TEMPLATE_EMPLOYEE_PROFILE_UPDATE,
            	 					standardSubmit :true
            	 				});
        	 		    	}
        	 				
        	 			}  
        	 		},
        	 		'facultyuploadform button[itemId=uploadId]':{
        	 			   click:function(obj){
        	 				  obj.setDisabled(true);
        	 				   var $this=this;
        	 				   var importWin=obj.up('facultyuploadform');
        	 				   var grdStore;
        	 				   var form=obj.up('facultyuploadform');
        	 				   var templateTypeFacultyUploadId = form.down('#templateTypeFacultyUploadId')
        	 				   submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
        	 				   $this.getHashOfFile(form);
        	 				   setTimeout(function() {
	        	 				   form.getForm().submit({
	        	 					   method : 'POST',
	        	 					   url : submitUrl,
	        	 					   success : function(form, action){
	        	 						   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	        	 					   },
	        	 					   failure: function(form, action) {
	          		   					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
	        	 					   }
	        	 				   });
        	 				   },1000);
        	 				   Ext.defer(function() {
        	 					   var grid = $this.getImportListFaculty();
        	 					   var form  = $this.getUploadoptionradiogroup();
        	 					   var isUploadAll = form.items.items[0].getValue().isUploadAll;
        	 					   $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,templateTypeFacultyUploadId.getValue());
        	 					 /*grid.getStore().getProxy().extraParams = {
        	 						   moduleName:getCommonTranslation('IMPORT_BULK_EMPLOYEESS_UPLOAD')
        	 					   };
        	 					   grid.getStore().load();*/
        	 				   }, 2000, this);
        	 			   }  
        	 		   },
        	 		   'facultyuploadform button[itemId=resetBtn]':{
        	 			   click:function(obj){
        	 				   var $this = this;
        	 				   var form =obj.up('facultyuploadform').getForm();
        	 				   var moduleName = obj.up('facultyuploadform').down('#moduleName')
        	 				  form.reset();
        	 				  moduleName.getStore().data.items.forEach(function(rec){
        						 if(rec.data.value=='Bulk Employee Update'){
        							 moduleName.setValue(rec.data.id);
        							 moduleName.setReadOnly(true);
        						 }
        	 				 	});
        	 				   form.isValid();
        	 			   }
        	 		   },
        	 		   'facultyuploadform uploadoptionradiogroup[itemId=employeeUpdateUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
        	 			   change: function( radioGroup, newValue, oldValue, eOpts){
        	 				  var grid = this.getImportListFaculty();
      					      var isUploadAll = newValue.isUploadAll,
      					    form = this.getFacultyuploadform(),
      					  templateTypeFacultyUploadId = form.down('#templateTypeFacultyUploadId');
        	 				  this.onChangeUploadOptionRadioGroup(isUploadAll, grid,templateTypeFacultyUploadId.getValue());
        	 			   }
        	 		   },
        	 		  'importlistfaculty':{
        				   afterrender:function(cmp){
                      		 var me = this,
                      		 form = me.getFacultyuploadform(),
                      		isUploadAll = form.getForm().getValues().isUploadAll,
                      		moduleName = form.down('#moduleName');
                      		me.onChangeUploadOptionRadioGroup(isUploadAll, cmp,'IMPORT_BULK_EMPLOYEESS_UPLOAD');
                      		moduleName.getStore().load({
                      				callback: function(records, options, success) {
                      					 for(var i in records){
                   							 if(records[i].data.value=='Bulk Employee Update'){
                   								moduleName.setValue(records[i].data.id);
                   								moduleName.setReadOnly(true);
                   							 }
                   						 }
                      					}
                      			    });
                      	 },
        				   cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
        					   if (e.target.tagName == 'A') {
        						   var fileType=null;
        						   if(cellIndex==1){
        							   fileType='successFile';
        						   }else if(cellIndex==6){
        							   fileType='errorFile';
        						   }else if(cellIndex==7){
        							   fileType='logFile';
        						   }
        						   var documentId = record.get("id");
        						   if (!isNullOrEmpty(documentId)) {
        							   this.getFacultyDownloadFile(documentId,fileType);
        						   }
        					   }
        				   }
        			   },
        			   'importlistfaculty button[itemId=btnForce]':{
        				   click: function(obj) {
        					   var grid = this.getImportListFaculty();
        					   if (grid.getSelectionModel().getCount() > 0) {
        						   if(grid.getSelectionModel().getCount() > 1){
        							   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
        						   }else{
        							   var this$ = this;
        							   var id = grid.getSelectionModel().selectionStart.data.id;
        							   console.log(id);
        							   var urlAppend="?jobName="+id;
        							   var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
        							   Ext.Ajax.request({
        								   url: submitURL,
        								   method: 'GET',
        								   success: function(response) {
        									   if(response.responseText==="JOB_STATUS_NOT_PENDING"){
        										   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
        									   }else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
        										   //console.log("Manual trigger hit");
        										   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
        									   }else if(response.responseText==="SUCCESS"){
        										   //console.log("Manual trigger hit");
        										   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
        										   grid.getStore().reload();
        									   }
        								   }
        							   });
        						   }
        					   } else {
        						   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        					   }  
        				   }
        			   },
         			   'facultyinfodashboardhomepage #printBtn' : {
         				   click:  function(button){
         					   this.printFacultyProfile();
         				   }
         			   },
         			   
         			  'facultyinfodashboardhomepage' : {
        				   render:  function(panel){
        					   this.disableMyDashboardPivileges(panel,this.getSTUDENT_MY_DASHBOARD_PERMISSIONS());
        				   }
        			   },
        			   'staffworkhoursgrid[itemId=facultyWorkHoursGrid]': {
        				   render: function(grid){
        					   var this$ = this;
        					   var personProfile = this$.getContentPanelActiveTab();
        					   var userId=personProfile.getUserId();
        					   var grid = personProfile.down('staffworkhoursgrid');
        					   var store = grid.getStore();
        					   store.proxy.extraParams = {
        							   id : userId
        					   };
        					   this$.resetPageSetting(store);
        					   store.load();
        					   this$.doAccessControlValidation(grid, this$.getFACULTY_WORK_HOURS_PERMISSIONS()); 
        					   var portalId = this.getCurrentLoggedPortalId();
                               if(portalId==2){
                              	 grid.down('#btnEdit').setVisible(false);
                              	 grid.down('#btnAdd').setVisible(false); 
                              	 
                               }
        				   },
        				   cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
            				   var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;

            				   if(columnName == "calendarName"){
            					   if(e.target.tagName=='A'){
            						   this.workHourDetailsByCalendar(grid,record);
            					   }
            				   }
            			   }
        			   },
        			   'staffworkhoursgrid[itemId=facultyWorkHoursGrid] button[itemId=btnEdit]' : {
            			   click : this.editEmployeeCalendar
            		   },
        			   'staffworkhoursgrid[itemId=facultyWorkHoursGrid] button[itemId=btnAdd]' : {
        				   click:  function(button){
        					   this.openAssignCalendarWindow();
         				   }
            		   },
            		   'workhourdetailsgrid': {
            			   render: function(grid){
            				   var this$ = this;
            				   var personProfile = this$.getContentPanelActiveTab();
            				   var userId = personProfile.getUserId();
            				   var store = grid.getStore();
            				   store.proxy.extraParams = {
            						   id : userId
            				   };
            				   store.load({
            					   callback: function(records, operation, success) {
            						   if (!isNullOrEmpty(records) && records.length > 0) {
            							   this$.toggleGridSummaryRow(grid,true);
            						   } else {
            							   this$.toggleGridSummaryRow(grid,false);
            						   }
            					   }
            				   });
            			   }
            		   },
        		        
        		        'searchresultgrid[itemId=facultySearchResultGrid] menuitem[itemId=bulkDownloadDocId]': {
            	            click: function(obj) {
            	            	var grid = this.getSearchResultGrid();
            	 				   if (grid.getSelectionModel().getCount() > 0) {
            	 					   var bulkDocDownloadItemId ="employeebulkdownloaddocumentwin";
            	 					   var bulkDocDownloadWin = Ext.widget('bulkdownloaddocumentwin', {
            	 						   itemId: bulkDocDownloadItemId
            	 					   });

            	 					   var formWindowTab = this.getBulkdownloaddocumentwin();
            	 					   
            	 					   var applicationDocumentsId = formWindowTab.down("#applicationDocumentsId");
            	 					   var applicationDocumentsIdStore = applicationDocumentsId.getStore();

            	 					   applicationDocumentsIdStore.getProxy().extraParams = {
            	 						   personType:'EMPLOYEE',
            	 						   isApplicableForEmployee: true
            	 					   };
            	 					   
            	 					   var userName = formWindowTab.down("#user_name");
            	 					   var userNameStore = userName.getStore();
            	 					   var userId = this.getCurrentlyLoggedInUser().id;
            	 					   userNameStore.load({
            	 						   callback: function(records, operation, success) {
            	 							   if (success) {
            	 								  for(var i in records) {
            		 								   	if(records[i].data.id == userId){
            		 								   	userName.setValue(records[i].data.id);
            		 								   	}
            	 								   }
            	 							   }
            	 						   }	   
            	 					   });
            	 					  bulkDocDownloadWin.show();
            	 					  
            	 				   } else {
            	 					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            	 				   }
            	            }
        		        },
        		        'bulkdownloaddocumentwin[itemId=employeebulkdownloaddocumentwin] button[itemId=bulkDocCancel]': {	 			  
        		 			   click:function(obj){
        		 				   obj.up('window').close();
        		 			   }
        		 		   },
        		 		   
        		 		  /*Reset Bulk document win*/
        		 		   'bulkdownloaddocumentwin[itemId=employeebulkdownloaddocumentwin] button[itemId=submitBtn]': {	 			  
        		 			   click: function(obj) {
        		 				  this.sendEmployeeBulkDocumentGenerateDetail(obj);
        		 			   }	 			  
        		 		   },
        		 		   /*Add Appointment*/
        		 		   'searchresultgrid[itemId=facultySearchResultGrid] menuitem[itemId=facAppointmentItemId]': {
        		 			   click: function(){
        		 				   this.openMangeAppointmentGrid();
        		 			   }
        		 		   },
        		 		   'sgappointmentform[itemId=facultySGAppointmentFormItemId] button[itemId=submitBtn]':{
        		 			   click: this.saveSGAppointmentRecord
        		 		   },
        		 		   'sgappointmentfacultydetailgrid[itemId=SGAppointmentFacultyDetailGridId]':{
        		 			   render: function(grid){
        		 				   var this$ = this;
        		 				   var gridStore = grid.getStore();
        		 				   var portalId = this$.getCurrentLoggedPortalId();
        		 				   if(portalId == 2){
        		 					   this$.doAccessControlValidation(grid, this$.getEMPLOYEE_MANAGE_APPOINTMENT_PERMISSIONS());
        		 					   facultyId = this$.getCurrentlyLoggedInUser().id;
        		 					   gridStore.getProxy().extraParams={
        		 						   staffId:facultyId,
        		 					   };
        		 					   gridStore.loadPage(1);

        		 				   }else{
        		 					   this$.doAccessControlValidation(grid, this$.getMANAGE_APPOINTMENT_PERMISSIONS());
        		 					   var facResultGrid = this$.getFacultySearchResultGrid();
        		 					   var gridrecord = facResultGrid.selModel.getSelection();        		 				   
        		 					   if(gridrecord.length>0){
        		 						   var selectedRecordId = gridrecord[0].data.ID;
        		 						   gridStore.getProxy().extraParams={
        		 							   staffId:selectedRecordId,
        		 						   };
        		 						   gridStore.loadPage(1);
        		 					   } 
        		 				   }
        		 			   }
        		 		   },
        		 		   'sgappointmentfacultydetailgrid[itemId=SGAppointmentFacultyDetailGridId] button[itemId=btnAdd]':{
        		 			   click: function(){
        		 				   this.addSGAppointmentEmployeeDetailRecord('ADD');
        		 				   this.setEntrybyValuebydefault();
        		 				   this.setVisitStatusByDefault();
        		 			   }
        		 		   },
        		 		   'sgappointmentfacultydetailgrid[itemId=SGAppointmentFacultyDetailGridId] button[itemId=btnEdit]':{
        		 			   click: function(obj,record){
        		 				   var $this=this;
        		 				   var grid = $this.getSgappointmentfacultydetailgrid();
        		 				   if (grid.getSelectionModel().getCount() > 0) {
        		 					   var record=grid.getSelectionModel().getSelection()[0];
        		 					   if(!isNullOrEmpty(record.data.isRescheduleAppointment) && record.data.isRescheduleAppointment == true){
        		 						   showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("RESCHEDULE_APPOINTMENT_CANT_BE_EDITED"));
        		 						   return;
        		 					   }else{
        		 						   this.editAppointmentFacultyRecord(obj,record);
        		 					   }
        		 				   }
        		 			   }
        		 		   },
        		 		   'sgappointmentfacultydetailgrid[itemId=SGAppointmentFacultyDetailGridId] button[itemId=btnView]':{
        		 			   click: function(obj,record){
        		 				   this.viewFacultySGAppointmentDetailRecord(obj,record);
        		 			   }
        		 		   },
        		 		   'sgappointmentfacultydetailgrid[itemId=SGAppointmentFacultyDetailGridId] button[itemId=btnDelete]':{
        		 			   click: this.deleteFacultySGAppointmentDetailRecord
        		 		   },
        		 		  'sgappointmentform[itemId=facultySGAppointmentFormItemId] button[itemId=viewCalendar]':{
        		 			   click : this.openViewCalendarFacultyWin
        		 		  },
        		 		 'sgappointmentform[itemId=facultySGAppointmentFormItemId] customcombobox[itemId=viewStatusID]': {
                			 select : function(obj, record){
                				 var sgForm=this.getFacultysgappointmentform();
                				 var recVal = record[0].data.value;
                				 var rescheduleAppointmentFld = sgForm.down('#rescheduleAppointmentFld');
                				 var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
                				 var rescheduleAppointmentTimeId = sgForm.down('#rescheduleAppointmentTimeId');
                				 var chkRescheduleAppointment = sgForm.down('#chkRescheduleAppointment');
                				 if(recVal == "Rescheduled"){
                					 rescheduleAppointmentFld.setVisible(true);
                					 this.setAllowBlank(rescheduleAppointmentDateId,false);
                					 rescheduleAppointmentDateId.reset();
                					 chkRescheduleAppointment.setValue(true);
                				 }
                				 else{
                					 rescheduleAppointmentFld.setVisible(false);
                					 this.setAllowBlank(rescheduleAppointmentDateId,true);
                					 rescheduleAppointmentDateId.reset();
                				 }
                				 rescheduleAppointmentTimeId.reset();
                				 sgForm.getForm().checkValidity();
                			 }
                		 },
                         'sgappointmentform[itemId=facultySGAppointmentFormItemId] checkboxfield[itemId=chkRescheduleAppointment]': {  
                        	 change : function(cmp, currentValue, oldValue, eOpts){
                        		 var sgForm=this.getFacultysgappointmentform();
                        		 var dateTimeRescheduleAppointmentItemId = sgForm.down('#dateTimeRescheduleAppointmentItemId');
                        		 var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
                        		 var rescheduleAppointmentTimeId = sgForm.down('#rescheduleAppointmentTimeId');
                        		 if (currentValue == true) {
                        			 dateTimeRescheduleAppointmentItemId.setVisible(true);
                        			 this.setAllowBlank(rescheduleAppointmentDateId,false);
                        			 rescheduleAppointmentDateId.reset();
                        		 }
                        		 else{
                        			 dateTimeRescheduleAppointmentItemId.setVisible(false);
                        			 this.setAllowBlank(rescheduleAppointmentDateId,true);
                        			 rescheduleAppointmentDateId.reset();
                        		 }
                        		 rescheduleAppointmentTimeId.reset();
                        		 sgForm.getForm().checkValidity();
                        	 }
                         },
                         ////////////////////////////////////////////////////////
                         
                         
                         'sgappointmentform[itemId=facultySGAppointmentFormItemId] filefield[itemId=documentUploadFile]' : {
	                			change: function(DocFile, value, eOpts) {
	                				value = value.replace('C:\\fakepath\\', '');
	                				var newValue = value.replace(/ +/g, " ").split(' ').join('_');
	                				DocFile.setRawValue(newValue);
	                				var file = DocFile.fileInputEl.dom.files[0];
	                				var form = DocFile.up().up();
	                				 var documentUploadFile = form.down('#documentUploadFile');
	                                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
	                                    if (!isNullOrEmpty(extension)) { 
                                         if (!((extension == "png" || extension == "jpeg" || extension == "jpg" || extension == "pdf" ||  extension == "xlsx" || extension == "docx" || extension == "pptx") && (file.size / 1024) <= 10000)) {
                                         	DocFile.reset();
                                             showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation('UPLOAD_IMAGE_SIGNATURE'));
                                         }
                                         var documentUploadFile = form.down('#documentUploadFile');
                                         documentUploadFile.setVisible(true);
                                        // docDetails.setValue(getPersonModuleTranslation('SIGNATURE_IMAGE_FIELD_MESSAGE'));
                                     } 
	                                    else {
	                                        if ($this.isValidFileExtension(extension)) {
	                                            if (file.size / 1024 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT_FOR_STUDENT_DOCUMENT) {
	                                            	documentUploadFile.setVisible(false);
	                                            	DocFile.reset();
	                                                showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_EXTENDED_ERROR_MSG'));
	                                            } else {
	                                                var form = DocFile.up().up();
	                                                var documentUploadFile = form.down('#documentUploadFile');
	                                                documentUploadFile.setVisible(true);
	                                                var docDetails = form.down('#docDetails');
	                                                docDetails.setValue("Type: " + extension + " Size: " + (file.size / 1024).toFixed(2) + ' KBs');
	                                            }
	                                        } else {
	                                        	documentUploadFile.setVisible(false);
	                                        	DocFile.reset();
	                                            showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
	                                        }
	                                    }
	                                    
	                			}
	                		},
	                 		
                         
        		 		  'scheduledetails[itemId=facultyScheduleDetails] radiogroup[itemId=viewCalendarId]': {
        		 			  change: function(obj,rec) {
        		 				  if(rec.isViewCalendar){
        		 					  this.sendCalendarEventsFacultyRequest('FACULTY', '#personViewCalendar', SERVERURL.RESOURCE_BOOKING_GET_FACULTY_CALENDAR_DATA);	
        		 				  }else{
        		 					  this.sendCalendarEventsFacultyRequest('FACULTY', '#personViewCalendar', SERVERURL.FACULTY_EVENT_DETAILS);
        		 				  }
        		 			  }
        		 		  },
        		 		  'sgappointmentform[itemId=facultySGAppointmentFormItemId] button[itemId=resetBtnForm]':{
        		 			  click: function(){
        		 				  var $this=this;
        		 				  var form = $this.getFacultysgappointmentform();
        		 				  this.resetFacultySGAppointment(form);
        		 				  this.setEntrybyValuebydefault();
        		 				  this.setVisitStatusByDefault();
        		 				  form.getForm().findField('bookingDate').setValue(new Date());
        		 				  
        		 				  
        		 			  }
        		 		  },
        		 		  /////////////////////////////////////////////////
        		 		 'sgappointmentform[itemId=facultySGAppointmentFormItemId] displayfield[itemId=pathId]':{  
                			   afterrender: function(fld){
                				   fld.el.on("click", function(){
                    				   var documentId= Ext.getCmp(this.id).documentId;
                    				   if(!isNullOrEmpty(documentId)){
                                           Ext.Ajax.request({
                                               type: 'rest',
                                               url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
                                               method: 'GET',
                                               callback : function(opt, success, response){
                                                   if(response.responseText == 'true') {
                                                       var csvForm = Ext.create('Ext.form.Panel'); 
                                                       csvForm.getForm().submit({
                                                           target: '_blank',
                                                           method:'GET',
                                                           params :{
                                                               access_token : Ext.Ajax.defaultHeaders.access_token
                                                           },
                                                           headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
                                                           url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
                                                           standardSubmit :true
                                                       });
                                                   } else {
                                                       showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
                                                   }
                                               }
                                           });
                                       }
                    				   
                    				   
                    			   });
                			   }
                		   },
        		 		  'communicationhistorystructure[itemId=facultycommunicationhistorystructureItemId]' : {
        		 			  render : function(structure) {
        		 				  var facultyProfile = this.getFacultyprofile();
        		 				  
        		 				  if (facultyProfile.personInfo.lastName != null){
        		 				 var printName= facultyProfile.personInfo.firstName + " " + facultyProfile.personInfo.lastName;
        		 				 }else {
        		 			       var printName = facultyProfile.personInfo.firstName;
        		 				  }	 
        		 				  var recipientName = structure.down('customcombobox#recipientName');
        		 				  recipientName.getStore().load({
        		 					  callback : function(records,operation,success) {
        		 						  recipientName.setValue(printName);
        		 						  var contactId = structure.down('customcombobox#contactId');
        		 						  var personId = facultyProfile.personInfo.id;
        		 						  var contactIdValue=null;
        		 						  recipientName.setReadOnly(true);
        		 						  contactId.getStore().getProxy().extraParams = {
        		 							  id: personId,
        		 							  isEmail:true
        		 						  };

        		 						  contactId.getStore().load({
        		 							  callback : function(records,operation,success) {
        		 								 var contactIdComboStore=structure.down("#contactId").getStore();
        										 var storeValue = contactIdComboStore.data.items;
        										 
        										 if(storeValue.length>0){
        											 contactIdValue = storeValue[0].data.emailId;
        											 for(var recordInt=1;recordInt<storeValue.length;recordInt++){
        												 contactIdValue=contactIdValue+","+storeValue[recordInt].data.emailId;
        											 }
        											 //contactId=contactIdValue;
        											 var mobileId = structure.down('customcombobox#mobileId');
        											 mobileId.getStore().getProxy().extraParams = {
        												 id: personId,
        												 isEmail:false
        											 };
        											 mobileId.getStore().load();
        											 var commHistoryStore = structure.down('communicationhistorylist').getStore();
        											 commHistoryStore.getProxy().extraParams = {
        												 contact : contactIdValue ,
        												 recipientName : recipientName.getValue(),
        												 deliveryModeId : 1
        											 };
        											 commHistoryStore.load();
        										 }
        		 							  }
        		 						  });
        		 					  }
        		 				  });
        		 			  }
							},
							'communicationhistorystructure[itemId=facultycommunicationhistorystructureItemId] customcombobox[itemId=recipientName]' : {
					 			 render : function(combo) {
					 				var contentPanel=this.getContentPanel();
					 				var personId=contentPanel.getActiveTab().personId;
					 				//var studentProfile = this.getStudentprofile();
					 				//var personId = studentProfile.personInfo.id;
					 				combo.getStore().getProxy().api.read = SERVERURL.SEND_MESSAGE_REPORT_RECIPIENTNAME;
					 				combo.getStore().getProxy().extraParams = {
					 					  personId: personId
									};
					 			//	combo.getStore().sorters.clear();
					 				combo.getStore().load();
					 				
					 				var structure = combo.up('communicationhistorystructure');
				 	 				//var contactId = structure.down('customcombobox#contactId');
				 	 				
				 	 				setTimeout(function(){
				 	 					
				 	 					var contactId = structure.down('customcombobox#contactId');
				 	 					contactId.getStore().getProxy().api.read = SERVERURL.PATH_FIND_PERSON_CONTACT_DETAIL_BY_PERSON_ID;
				 						contactId.getStore().getProxy().extraParams = {
					 						id: personId,
					 						isEmail:true,
				 						};
				 						contactId.getStore().load();
				 						
				 						var mobileId = structure.down('customcombobox#mobileId');
				 						mobileId.getStore().getProxy().api.read = SERVERURL.PATH_FIND_PERSON_CONTACT_DETAIL_BY_PERSON_ID;
				 						mobileId.getStore().getProxy().extraParams = {
				 							id: personId,
				 							isEmail:false,
				 						};
				 						mobileId.getStore().load();
				 						
				 	 				},500);
									
					 			 }
					 		  },
							 'communicationhistorystructure[itemId=facultycommunicationhistorystructureItemId] button[itemId=resetButtonId]': {
								 click: function(){                	
									 var form = this.getCommunicationhistorystructure();  
									 var grid =  this.getCommunicationhistorylist();
									 var sendMessage = form.down("#sendmessageId").reset();
									 //var recipient=form.down("#recipientName").reset();
									 var contactId=form.down("#contactId").reset();
									 var sentbyName=form.down("#sentby").reset();
									 var eventNameCode=form.down("#eventName").reset();
									 var eventDateForm=form.down("#eventDateForm").reset();
									 var eventDateTill=form.down("#eventDateTill").reset();
									 var mobileId=form.down("#mobileId").reset();
									 grid.down("#exportMessageSentReportItemId").setDisabled(true);
									 var facultyProfile = this.getFacultyprofile();
									 var printName = facultyProfile.personInfo.firstName;
									 var contactId = form.down('customcombobox#contactId');
									 var personId = facultyProfile.personInfo.id;
									 var contactIdValue=null;
									/* contactId.getStore().getProxy().extraParams = {
										 id: personId
									 };*/
										 var contactIdComboStore=form.down("#contactId").getStore();
										 var storeValue = contactIdComboStore.data.items;
										 contactIdValue = storeValue[0].data.emailId;
										 for(var recordInt=1;recordInt<storeValue.length;recordInt++){
											 contactIdValue=contactIdValue+","+storeValue[recordInt].data.emailId;
										 }
										 contactId=contactIdValue;
									 var commHistoryStore = form.down('communicationhistorylist').getStore();
									 commHistoryStore.getProxy().extraParams = {
										 contact : contactId ,
										 recipientName : printName,
										 deliveryModeId : 1
									 };
									 commHistoryStore.load();
								 }
					            },
							'communicationhistorystructure[itemId=facultycommunicationhistorystructureItemId] radiogroup[itemId=sendmessageId]': {
				            	change: function(obj,value){                	
				                	var form = this.getCommunicationhistorystructure(); 
				                	 var grid =  this.getCommunicationhistorylist();
				                	var contactField=form.down("#contactId");
				        			var mobileField=form.down("#mobileId");
				        			grid.down("#exportMessageSentReportItemId").setDisabled(true);
				            		if(value.sendMessage===2){              			
				                		//var recipient=form.down("#recipientName").reset();
				                		var contactId=form.down("#contactId").reset();
				                		var sentbyName=form.down("#sentby").reset();
				                		var eventNameCode=form.down("#eventName").reset();
				                		var eventDateForm=form.down("#eventDateForm").reset();
				                		var eventDateTill=form.down("#eventDateTill").reset();
				                		var mobileNO=form.down("#mobileId").reset();
				                		
				            			contactField.setVisible(false);
				            			mobileField.setVisible(true);   
					            	
				            		}else{
				                	//	var recipient=form.down("#recipientName").reset();
				                		var contactId=form.down("#contactId").reset();
				                		var sentbyName=form.down("#sentby").reset();
				                		var eventNameCode=form.down("#eventName").reset();
				                		var eventDateForm=form.down("#eventDateForm").reset();
				                		var eventDateTill=form.down("#eventDateTill").reset();
				            			contactField.setVisible(true);
				            			mobileField.setVisible(false);            			
				            		}                	
				                }
				            },
				            'communicationhistorystructure[itemId=facultycommunicationhistorystructureItemId] button[itemId=searchButtonId]':{
				            	click : function(obj){
				            		var form = this.getCommunicationhistorystructure();
				            		var grid =  this.getCommunicationhistorylist();
				            		var sendMessage = form.down("#sendmessageId").getValue();
				            		//console.log(sendMessage);
				            		var recipient=form.down("#recipientName").getValue();
				            		var contactId=null;
				            		var contactIdValue=null;
				            		var sentbyName=form.down("#sentby").getValue();
				            		var eventNameCode=form.down("#eventName").getValue();
				            		var eventDateForm=form.down("#eventDateForm").getValue();
				            		var eventDateTill=form.down("#eventDateTill").getValue();
				            		var messageId=form.down("#sendmessageId").getValue();
				            		var facultyProfile = this.getFacultyprofile();
				            		if(eventDateForm != null){
				            			eventDateForm= new Date(eventDateForm);
				            			eventDateForm = Ext.Date.format(eventDateForm, 'Y-m-d');
				                          }
				                    if(eventDateTill != null){
				                    	eventDateTill= new Date(eventDateTill);
				                    	eventDateTill = Ext.Date.format(eventDateTill, 'Y-m-d');
				                          }
				            		if(messageId.sendMessage==1){
				            			contactId=form.down("#contactId").getValue();
				            			if(contactId==null){
				            				var contactIdComboStore=form.down("#contactId").getStore();
				            				var storeValue = contactIdComboStore.data.items;
				            				contactIdValue = storeValue[0].data.emailId;
        		                    		for(var recordInt=1;recordInt<storeValue.length;recordInt++){
        		                    			contactIdValue=contactIdValue+","+storeValue[recordInt].data.emailId;
        		                    		}
        		                    		contactId=contactIdValue;
        		                    		}
				            		}else{
				            			contactId=form.down("#mobileId").getValue();
				            			if(contactId==null){
				            				var contactIdComboStore=form.down("#mobileId").getStore();
				            				var storeValue = contactIdComboStore.data.items;
				            				contactIdValue = storeValue[0].data.mobileNumber;
        		                    		for(var recordInt=1;recordInt<storeValue.length;recordInt++){
        		                    			contactIdValue=contactIdValue+","+storeValue[recordInt].data.mobileNumber;
        		                    		}
        		                    		contactId=contactIdValue;
        		                    		}
				            		}
				            		var store = grid.getStore();
				            		store.getProxy().extraParams = {
				            			deliveryModeId: sendMessage.sendMessage,
				            			recipientName: recipient,
				            			contact:contactId,
				            			sentBy:sentbyName,
				            			eventName:eventNameCode,
				            			fromDate:eventDateForm,
				            			toDate:eventDateTill
				            		}
				            		store.load();
				            	}
				            },
				            'communicationhistorystructure[itemId=facultycommunicationhistorystructureItemId] communicationhistorylist':{
				            	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				            		var messageTemplate = record.get('msgContent');
				            		var $this =this;
				            		if (e.target.tagName == 'A') {
				            			/*var win = new Ext.Window({
				            				title: getMessagingModuleTranslation('MESSAGE_CONTENT'),
				            				frame: true,
				            				height : 500,
				            				minWidth:200,
				            				autoScroll:true,
				            				modal:true,
				            				html: messageTemplate,
				            			});*/
				            			//win.show();
				            			var dataIndex = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;

				            			if(dataIndex == "attachedDocument"){
				            				$this.openAttachedDocumentLink(record);
				            			}
				            			else{
				            				$this.openSendMessageReportLink(record);	
				            			}
				            			
				            			
				            		}
				            	},
				            	render: function(grid){
			        				var $this = this;
			        				var itemIdPrivilegeNameArray = [{"#exportMessageSentReportItemId" : "EXPORT_REPORTS"}];
			        				this.disableRadioGroupAndOtherPivileges(grid, this.getFACULTY_PROFILE_COMMUNICATION_HISTORY_PERMISSIONS(),itemIdPrivilegeNameArray);
			        				var exportReport=grid.down("#exportMessageSentReportItemId");
			        				exportReport.setDisabled(true);
			        			}
				            },
				            'communicationhistorystructure[itemId=facultycommunicationhistorystructureItemId] button[itemId=exportMessageSentReportItemId]':{
				            	click: function(){
				            		this.exportXlsMsgSentReport();
				            		
				            	}
				            },'communicationhistorystructure[itemId=facultycommunicationhistorystructureItemId] datefield[itemId=eventDateForm]':{
				            	select : function(field, value, eOpts){
				            		this.facultyCheckSelectDate();

				            	}
				            },
				            'communicationhistorystructure[itemId=facultycommunicationhistorystructureItemId] datefield[itemId=eventDateTill]':{
				            	select : function(field, value, eOpts){
				            		this.facultyCheckSelectDate();

				            	}
				            },
				            'sendmessageattacheddocumentwin[itemId=facultysendmessageattacheddocumentwin] grid[itemId=sendMessageDocumentGridItemId]': {
		    	               	cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
		    	                       var $this = this;
		    	                       var grid = $this.getSendmessageattacheddocumentwin().down('#sendMessageDocumentGridItemId');
		    	                       var columnName = grid.columnManager.columns[cellIndex].dataIndex;
		    	                       if (columnName == "name") {
		    	                           if (e.target.tagName == 'A') {
		    	                               var documentId = record.get("id");
		    	                               if (!isNullOrEmpty(documentId)) {
		    	                               	var isWhetherSysMsgEvent = false;
		    	                               	var gridMessageList = $this.getCommunicationhistorylist();
		    	                               	if(gridMessageList.getSelectionModel().getCount()>0){
		    	                               		var recordList = gridMessageList.getSelectionModel().getSelection();
		    	                               		var eventName = recordList[0].get('eventName');
		    	                               		if(!isNullOrEmpty(eventName)){
		    	                               			isWhetherSysMsgEvent = true;
		    	                               		}
		    	                               	}
		    	                                   $this.downloadAttachedDocumentFile(documentId,isWhetherSysMsgEvent);
		    	                               }
		    	                           }
		    	                       }
		    	                   }
		    	               },
		    	               'sgappointmentform[itemId=facultySGAppointmentFormItemId] combo#reasonForVisitID':{
		    	            	   select : function(obj,record){
                    				   var userGroupName = record[0].get("code");
               	        		    this.enableOrDisableAdditionalReasonFaculty(userGroupName);
                    			   }
	        		 		  },
	        		 		  'sgappointmentform[itemId=facultySGAppointmentFormItemId] datefield[itemId=appointmentId]': {
	        		 			  change: function(obj,record) {
	        		 				  var sgForm=this.getFacultysgappointmentform();
	        		 				  var isAppointeeItemId=sgForm.down("#isAppointeeItemId");
	        		 				  var currentDate = Ext.Date.format(new Date() ,'Y-m-d');
	        		 				  var appointmentDate = Ext.Date.format(record ,'Y-m-d');
	        		 				  if(obj.itemId == 'appointmentId'){
	        		 					  if(currentDate>appointmentDate){
	        		 						  isAppointeeItemId.setValue({isAppointee:false});
	        		 					  }else{
	        		 						  isAppointeeItemId.setValue({isAppointee:true});
	        		 					  }
	        		 				  }
	        		 			  }
	        		 		  },
	        		 		 'searchresultgrid[itemId=facultySearchResultGrid] menuitem[itemId=employeeElctionVoterPoolBtn]': {
	                      	   click: function(obj) {
	                      		   var grid = this.getSearchResultGrid();
	                      		   if (grid.getSelectionModel().getCount() > 0) {
	                      			   var this$ = this;
	                      			   var window = this$.getVoterpoolwindow();
	                      			   if(!window){
	                    				   window =Ext.widget('voterpoolwindow',{
	                     		    			itemId:'facultyvoterpoolwindow'
	                     		    		});
	                   			   }
	                      			   window.show();
	                      			   
	                      			   var form = window.down('form');
	                     				var  voterPoolField = form.down("#voterPoolItemId");
	                     				
	                     				var store = voterPoolField.getStore();
	                     				
	                     				
	                     				store.getProxy().extraParams={
	                     			    	votingPool: 'STAFF_USERS'
	                     				};
	                     			
	                     			store.load();
	                     	    
	                      		   } else {
	                      			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                      		   }  
	                      	   }
	                         },
	                         'facultyquicksearchform multiselectcombofield[itemId=empMultiBrandCampusItemId]': {
	                			 render: function(obj){
	                				 var $this = this;
	                				 var formLayout = $this.getFacultyQuickSearchForm();
	                				 var academyLocationId = this.getCurrentAcademyLocation();
	                				 var multiBrandCampusId = formLayout.down('#empMultiBrandCampusItemId');
	                				 var ALComboStore = multiBrandCampusId.getStore();
	                				 ALComboStore.load({
	                					 callback: function(records, operation, success) {
	                						 if (success) {
	                							 multiBrandCampusId.select(multiBrandCampusId.getStore().collect(multiBrandCampusId.valueField));
	                							 setTimeout(function(){
	                								 $this.loadOtherFieldsOnChangeAcademyLocation(obj,multiBrandCampusId.getStore().collect(multiBrandCampusId.valueField));
	                										$this.getFacultyQuickSearchForm().down('#searchButtonId').setDisabled(false);
	    		    			            		},300);
	                						 }
	                					 }   
	                				 });
	                			 },
	                			 change : function(obj,record) { 
	    							 var $this = this;
	    							 var formLayout = $this.getFacultyQuickSearchForm();
	    							 setTimeout(function(){
        								 $this.loadOtherFieldsOnChangeAcademyLocation(obj,record);
        								 if($this.getFacultyQuickSearchForm().isValid()){
               								$this.getFacultyQuickSearchForm().down('#searchButtonId').setDisabled(false);
               							}else{
               								$this.getFacultyQuickSearchForm().down('#searchButtonId').setDisabled(true);
               							}
	    			            		},300);
	    						 }
	                		 },
	                         'voterpoolwindow[itemId=facultyvoterpoolwindow] button[itemId=saveBtn]': {
	                      	   click: function(obj) {
	                      		   this.saveElectionVoterPoolEmployee(obj);
	                      	   }
	                         },
	                        'facultysendmessages' :{
	                        	afterrender:function(form){
	                        		 var me = this;
	             					me.saveDFRInfo(me.getCurrentAcademyLocation(),form);
	                        	 }
	                         }, 'sgappointmentform[itemId=facultySGAppointmentFormItemId] radiogroup[itemId=flagRelatedRadio]':{
	                               change: function(cb, nv, ov){
	                                   var $this = this;
	                                   var form = $this.getFacultysgappointmentform();
	                                   var flagId = form.down("#flagUserId");
	                                   flagId.reset();
	                                   if(nv.isRelatedToFlag ==  true){
	                                       flagId.setVisible(true);
	                                       flagId.setDisabled(false)
	                                   }
	                                   else{
	                                      flagId.setVisible(false)
	                                      flagId.setDisabled(true);
	                                   }
	                                   form.isValid();
	                               }
	                           },
	                           "sgappointmentform[itemId=facultySGAppointmentFormItemId]":{
	                        	   afterrender:function(cmp){
	                        		   cmp.down('#flagRadioFld').setVisible(false);
	                        	   }
	                           },
	                           'facultydownloadform customcombobox[itemId=templateTypeFacultyId]':{
	                        	   change:function(cmp){
	                        		   var me = this,
	                        		   form = me.getFacultydownloadform(),
	                        		   deparmentalId = form.down('#deparmentalId'),
	                        		   academyLocationId = form.down('#academyLocationId');
	                        		   deparmentalId.reset();
	                        		   if(cmp.getValue()== 'IMPORT_BULK_EMPLOYEE_OTHER_DETAILS'){
	                        			   if(academyLocationId.getValue() && academyLocationId.getValue().length && academyLocationId.getValue()[0]){
	                        				   deparmentalId.setDisabled(false);
	                        			   }
	                        			   deparmentalId.setVisible(true);
	                        		   }else{
	                        			   deparmentalId.setDisabled(true);
	                        			   deparmentalId.setVisible(false);
	                        		   }
	                        		   
	                        	   }
	                           },
	                           'facultydownloadform multiselectcombofield[itemId=academyLocationId]':{
	                        	   change:function(cmp){
	                        		   var me = this,
	                        		   form = me.getFacultydownloadform(),
	                        		   deparmentalId = form.down('#deparmentalId'),
	                        		   templateTypeFacultyId = form.down('#templateTypeFacultyId');
	                        		   deparmentalId.reset();
	                        		   if(templateTypeFacultyId.getValue()== 'IMPORT_BULK_EMPLOYEE_OTHER_DETAILS'){
	                        			   if(cmp.getValue()  && cmp.getValue().length){
	                        				   deparmentalId.setDisabled(false);
	                        			   }else{
	                        				   deparmentalId.setDisabled(true);
	                        			   }
	                        			   deparmentalId.setVisible(true);
	                        		   }else{
	                        			   deparmentalId.setDisabled(true);
	                        			   deparmentalId.setVisible(false);
	                        		   }
	                        		   if(cmp.getValue()  && cmp.getValue().length && cmp.getValue()[0].data){
	                        			   deparmentalId.getStore().getProxy().extraParams={
		                        			   academyLocationIds:Ext.pluck(Ext.pluck(cmp.getValue(),'data'),'id').join()
		                        		   }
	                        			   deparmentalId.getStore().load();
	                        		   }else{
	                        			   deparmentalId.getStore().getProxy().extraParams={
		                        			   academyLocationIds:cmp.getValue().join()
		                        		   }
	                        			   deparmentalId.getStore().load();
	                        		   }
	                        		   
	                        		   
	                        	   }
	                           },
	                           'facultyuploadform customcombobox[itemId=templateTypeFacultyUploadId]':{
	                        	   change:function(cmp, newVal){
	                          		 var me = this,
	                          		 grid = me.getImportListFaculty(),
	                          		 form = me.getFacultyuploadform(),
	                          		isUploadAll = form.getForm().getValues().isUploadAll,
	                          		 moduleNamePostGradutaion = form.down('#moduleName');
	                          		 if(newVal){
	                          			 me.onChangeUploadOptionRadioGroup(isUploadAll, grid, newVal);
	                          			 moduleNamePostGradutaion.getStore().data.items.forEach(function(rec){
	                          				 if(newVal=='IMPORT_BULK_EMPLOYEESS_UPLOAD'){
	                          					 if(rec.data.value=='Bulk Employee Update'){
	                              					 moduleNamePostGradutaion.setValue(rec.data.id);
	                    								moduleNamePostGradutaion.setReadOnly(true);
	                              				 }
	                          				 }else if(newVal=='IMPORT_BULK_EMPLOYEE_OTHER_DETAILS'){
	                          					 if(rec.data.value=='Bulk Employee Other Details'){
	                              					 moduleNamePostGradutaion.setValue(rec.data.id);
	                    								moduleNamePostGradutaion.setReadOnly(true);
	                              				 }
	                          				 }
	                          			 });
	                          		 }
	                          		 
	                          	 
	                        	   }
	                           },
	                           'employeeImportStructure treepanel[itemId=customImportEmployeePanelId]':{
	                        	   itemclick:this.getOpenEmployeeReportStructure
	                           }
	        		 		  
        });
        
    },
    saveDFRInfo: function(academyLocationId,form) {
    	var templateId = form.down('#templatedItemId');
    	templateId.setVisible(false);
    	templateId.setFieldLabel(getMessagingModuleTranslation('TEMPLATE_ID'))
        Ext.Ajax.request({
            url: SERVERURL.COMMON_FORM_FIELD_INFO,
            method: 'GET',
            async: false,
            params: {
            	screenName: 'facultysendmessages',
                academyLocationId:academyLocationId,
                languageCode:'en'
            },
            success: function(res, action) {
    			var response = Ext.decode(res.responseText);
    			if( Object.keys(response).length > 0 ){
    				var records=response.facultysendmessages;
    				for(i in records){
    					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='templatedItemId'){
    						    var defaultValue = records[i].defaultValue;
    						    if(!isNullOrEmpty(defaultValue)){
    						    	templateId.setValue(defaultValue);
    						    	form.defaultValue =defaultValue;
    						    }
    							if(records[i].isVisible==false ){
    								form.templateIdVisble =false;
    							}if(records[i].isMandatory == true ){
    								form.templateIdMandatory= true
    							}if(records[i].isVisible==true){
    								form.templateIdVisble =true;
    							}if(records[i].isMandatory == false ){
    								form.templateIdMandatory= false
    							}
    						}
    					}
    				}
    			
    		}
        });
    
    },
    getEmployeeSubDepartment: function(parentId, recId) {
		if(parentId){
		    var subDepartmentCombo = this.getFacultyQuickSearchForm().down("#subDepartmentId");
		    subDepartmentCombo.reset();
		    subDepartmentCombo.enable();
		    var store = subDepartmentCombo.getStore();
		    store.getProxy().extraParams = {
		        parentId: parentId
		    };
		    store.load({
		        callback: function(records, operation, success) {
		            if (recId && success) {
		                subDepartmentCombo.setValue(recId);
		            }
		        }
		    });
		}
	},
    getFacultyDownloadFile : function(documentId,fileType){
 	   if(!isNullOrEmpty(documentId)){
 		   var csvForm = Ext.create('Ext.form.Panel'); 
 		   csvForm.getForm().submit({
 			   target: '_blank',
 			   method:'POST',
 			   params :{
 				   access_token : Ext.Ajax.defaultHeaders.access_token
 			   },
 			   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
 			   url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
 			   standardSubmit :true
 		   });
 	   }
    },
    facultyDownloadUploadFormChange : function(cb, nv, ov){
		var $this = this;
		var structure = cb.up('facultyuploaddownloadstructure');
		var downloadTemplateForm = structure.down('facultydownloadform');
		var uploadTemplateForm = structure.down('facultyuploadform');
		var grid = $this.getImportListFaculty();
		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
			uploadTemplateForm.hide();
			downloadTemplateForm.show();
			grid.setVisible(false);
		}else{
			$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
			var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
			uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
				isUploadAll: false
			});
			downloadTemplateForm.hide();
			uploadTemplateForm.show();
			grid.setVisible(true);
			uploadTemplateForm.down("#uploadFileField").reset();
		}
	},
	
	 saveElectionVoterPoolEmployee:function(obj){
	    	var $this = this;
	    	var grid = $this.getSearchResultGrid();

	    	var form = $this.getVoterpoolwindow();
	    	
	    	 
	    	var studentStatusCSMCombo = form.down('#voterPoolItemId');

	    	var jsonData = [];
	    	var departmentIdjsonData = [];
	    	var selected = grid.selModel.getSelection();
	    	if( selected.length > 0){
	    		for( var i = 0; i < selected.length; i++) {
	    			json = {
		   					
		   					"department":$this.getIdValueJson(selected[i].raw.DEPT_ID),
		   					"person":$this.getIdValueJson(selected[i].data.PERSON_ID),
		   					"electionId":studentStatusCSMCombo.value
		   					
		   			};
	    			jsonData.push(json);
	    			
	    		}
	    	}
	    	var requestJSON = {};
	    	requestJSON = jsonData;
	    	
	    	
	    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    	submitUrl = SERVERURL.PATH_ELECTION_VOTER_FIND_POOL_ADD;	
	    	Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
	    	Ext.Ajax.request({
	    		type : 'rest',
	    		url : submitUrl,
	    		jsonData : requestJSON,
	    		method : 'POST',
	    		success : function(form, action) {
	    		//	var data = Ext.JSON.decode(form.responseText);
	    			showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('SUCCESS'));
	    			grid.getStore().reload();
	    			obj.up('window').close();
	    			Ext.getBody().unmask();
	    		}
	    	});
	    },
    customzingViewForFacultyPortal :function(){
    	//TODO
    	/**
    	 * Changes required only if the logged in portal is Faculty
    	 */
    	if(this.getCurrentLoggedPortalId() == 2){
    		var this$ = this;
    		
    		var structure = this$.getFacultyquicksearchview();
    		structure.setAutoScroll(false);
    		
    		var searchForm = this$.getFacultyQuickSearchForm();
    		
    		searchForm.hide();

    		var ResultGrid = this.getFacultySearchResultGrid();
            ResultGrid.hide();
            
            var comboPanel = structure.down('facultyrequestcombopanel');
            comboPanel.setVisible(true);
    		comboPanel.down('combo#serviceRequestCombo').setVisible(false);
    		comboPanel.down('button#raiseButtonId').setVisible(false);
    		comboPanel.down('button#cancelButtonId').setVisible(false);
            
            var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
            resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.FACULTY_LIST_VIEWCODE);
            
            var values = new Object();
            var searchcriteria = new Array();

            values.configCode = CONSTANTS.CB.FACULTY_LIST_BASIC_CONFIGCODE;

            var facultyId = this$.getCurrentlyLoggedInUser().id;
            var facultyIdObj = this$.getJsonObject('USER_ID' , facultyId);
            this$.pushJsonObjectInArray(null, searchcriteria);

            values.searchCriterias = searchcriteria;
            var jsonFormatFormData = values;
            ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    	}
    
    },
    
    /**
     * Method to load the next combo based on the selection of
     * the previous combo value.
     * 
     * @param {Object}
     *            dependentCombo is the reference of the next
     *            dropdown which should be populated with
     *            values.
     * @param {Object}
     *            selectedRecord is the record of the previous
     *            dropdown which is selected.
     * @param {Object}
     *            parameter is the value that should be attached
     *            in the url.
     * @param {Object}
     *            extraParameter (optional) If there is any
     *            extra parameter to be sent for loading the
     *            dependent dropdown.
     * @param {Object}
     *            extraParamValue (optional) The value of the
     *            extraParam that is sent for loading the store.
     */
    loadDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
    	var this$ = this;
    	this$.resetOtherDropdowns(dependentCombo);
        dependentCombo.clearValue();
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = comboValue;
        if(!isNullOrEmpty(id)){
        	var url = store.getProxy().proxyConfig.api.read;
            if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                url = url.concat('?' + parameter + '=' + id);
            } else {
                url = url.concat('?' + parameter + '=' + id);
                url = url.concat('&' + extraParameter + '=' + extraParamValue);
            }
            store.getProxy().api.read = url;
            store.reload();
        }
    },

    /**
     * code to reset other dropdowns based on the selection of
     * any dropdown which is previous in the hierarchy. eg: if
     * all the dropdowns are loaded and the Academy is changed
     * then subsequent dropdowns should be changed accordingly,
     * so their value is cleared and reset and reloaded.
     * 
     * @param: {Object} combo The reference of the dropdown
     *         which is the dependent/next combo.
     */
    resetOtherDropdowns: function(combo) {
    	var basicFacultytSearchForm=this.getFacultyQuickSearchForm();
        /*switch (combo.name) {
        case 'PROGRAM_NAME':
            break;
        case 'BATCH_NAME':
            this.clearCombo(combo, false);
            periodCombo = basicFacultytSearchForm.down('combo[name=PERIOD_NAME]');
            this.clearCombo(periodCombo, true);
            sectionCombo = basicFacultytSearchForm.down('combo[name=SECTION_NAME]');
            this.clearCombo(sectionCombo, true);
            courseCombo = basicFacultytSearchForm.down('combo[name=COURSE_NAME]');
            this.clearCombo(courseCombo, true);
            break;
        case 'PERIOD_NAME':
            this.clearCombo(combo, false);
            sectionCombo = basicFacultytSearchForm.down('combo[name=SECTION_NAME]');
            this.clearCombo(sectionCombo, true);
            courseCombo = basicFacultytSearchForm.down('combo[name=COURSE_NAME]');
            this.clearCombo(courseCombo, true);
            break;
        case 'SECTION_NAME':
            this.clearCombo(combo, false);
            courseCombo = basicFacultytSearchForm.down('combo[name=COURSE_NAME]');
            this.clearCombo(courseCombo, true);
            break;
        case 'COURSE_NAME':
            this.clearCombo(combo, false);
            break;
        }*/
    },

    /**
     * function to clear the combo store, clear its existing
     * value and remove all the records from the store.
     * 
     * @param {Object}
     *            the reference of the combo whose store should
     *            be cleared.
     */
    clearCombo: function(combo, isDisabled) {
        combo.clearValue();
        combo.store.removeAll();
        combo.setDisabled(isDisabled);
    },
    
    
    resetFacultySearchForm: function(){
    	var this$ = this;
    	var form = this$.getFacultyQuickSearchForm();
    	form.getForm().reset();
    	form.down("#subDepartmentId").setDisabled(true);
    	form.down("#facultyTypeId").setVisible(false);
    	form.down("#employeeTypeId").setVisible(false);
    	/*this$.clearCombo(form.down('#batch'), true);
    	this$.clearCombo(form.down('#period'), true);
    	this$.clearCombo(form.down('#section'), true);
    	this$.clearCombo(form.down('#course'), true);*/
      
       var fnpMultiBrandCampusNameField = form.down('#empMultiBrandCampusItemId');
  	   fnpMultiBrandCampusNameField.reset();
  	   var ALComboStore = fnpMultiBrandCampusNameField.getStore();
  	   ALComboStore.load({
  		   callback: function(records, operation, success) {
  			   if (success) {
  				   fnpMultiBrandCampusNameField.select(fnpMultiBrandCampusNameField.getStore().collect(fnpMultiBrandCampusNameField.valueField));
  			   }
  		   }   
  	   });
    	
    },
    
    loadGridAndSearchUsers: function(model, records) {
        var searchForm = this.getFacultyQuickSearchForm();
        var jsonFormatFormData = this.createJsonFormat(searchForm, records);
        var resultGrid = this.getFacultySearchResultGrid();
        var searchResultForm = searchForm.getForm();
        var statusField =searchResultForm.findField('STATUS').getValue();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.FACULTY_LIST_VIEWCODE);
       // var resetButton = resultGrid.down('#raiseRequestButtonItemId');
        //var sendMessageBtn = resultGrid.down('#sendSurveyBtn');
        resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        if(this.getCurrentLoggedPortalId() == 2) {
        	var searchResultColumns=resultGrid.getStore().proxy.reader.getFields();
        	Ext.each(searchResultColumns, function(columnModel) {
        		if(columnModel.whetherHyperlink) {
        			columnModel.whetherHyperlink=false;
        		}
        	});
        }
        if(statusField == false){
        	resultGrid.down('#raiseRequestButtonItemId').setVisible(false);	
        	resultGrid.down('#sendMessageBtn').setVisible(false);
        	resultGrid.down('#sendSurveyBtn').setVisible(false);
        	resultGrid.down('#printCardBtn').setVisible(false);
        	resultGrid.down('#assignEmployeeCommitteeBtn').setVisible(false);
        	resultGrid.down('#assignEmployeeWorkCalendarBtn').setVisible(false);
        	resultGrid.down('#bulkDownloadDocId').setVisible(false);
        	resultGrid.down('#facAppointmentItemId').setVisible(false);
		}else{
			resultGrid.down('#raiseRequestButtonItemId').setVisible(true);	
	    	resultGrid.down('#sendMessageBtn').setVisible(true);
	    	resultGrid.down('#sendSurveyBtn').setVisible(true);
	    	resultGrid.down('#printCardBtn').setVisible(true);
	    	resultGrid.down('#assignEmployeeCommitteeBtn').setVisible(true);
	    	resultGrid.down('#assignEmployeeWorkCalendarBtn').setVisible(true);
	    	resultGrid.down('#bulkDownloadDocId').setVisible(true);
	    	resultGrid.down('#facAppointmentItemId').setVisible(true);
	    		
		}
        var raiseRequestButtonItemId = resultGrid.down('#raiseRequestButtonItemId');
    	var appointmentButtonItemId = resultGrid.down('#facAppointmentItemId');
    	var documentRequest = grid.down('#documentRequest');
    	
    	if(!isNullOrEmpty(raiseRequestButtonItemId)){
    		raiseRequestButtonItemId.setDisabled(true);
    	}
    	if(!isNullOrEmpty(appointmentButtonItemId)){
    		appointmentButtonItemId.setDisabled(true);
    	}
    	if(!isNullOrEmpty(documentRequest)){
    		documentRequest.setDisabled(true);
    	}
    },
    gridRenderFunction:function(grid){
		grid.addButtonToolbar();
		var butonstoolbar=grid.down('#functionButtonsToolbar');
		
		butonstoolbar.insert(1,{
			 	xtype : 'button',
		        itemId:'sendMessageBtn',
		        text : getCommonTranslation('SEND_MESSAGE'),
		        tooltip :getCommonTranslation('SEND_MESSAGE')
	    });
		butonstoolbar.insert(2,{
		 	xtype : 'button',
	        itemId:'printCardBtn',
	        text : getCommonTranslation('PRINT_ID_CARD'),
	        tooltip :getCommonTranslation('PRINT_ID_CARD')
		});
		
		butonstoolbar.insert(3,{
    		xtype : 'splitbutton',
    		itemId:'spBtnMoreActions',
    		text : getCommonTranslation('MOREACTIONS'),
    		menu:[{
    			text:getCommonTranslation('RAISE_REQUEST'),
    			itemId:'raiseRequestButtonItemId',
    			tooltip :getCommonTranslation('RAISE_REQUEST')
    		},{
    			text:getCommonTranslation('MAP_COMMITTEE'),
    			itemId:'assignEmployeeCommitteeBtn',
    			tooltip :getCommonTranslation('MAP_COMMITTEE')
    		},{
    			text:getCommonTranslation('BULK_DOWNLOAD_DOC'),
    			itemId:'bulkDownloadDocId',
    			tooltip :getCommonTranslation('BULK_DOWNLOAD_DOC')
    		},{
    			text:getCommonTranslation('SEND_SURVEY'),
    			itemId:'sendSurveyBtn',
    			tooltip :getCommonTranslation('SEND_SURVEY')
    		},{
    			text:getCommonTranslation('ASSIGN_WORK_CALENDAR'),
    			itemId:'assignEmployeeWorkCalendarBtn',
    			tooltip :getCommonTranslation('ASSIGN_WORK_CALENDAR')
    		},{
    			text:getCommonTranslation('SG_APPOINTMENT'),
    			itemId:'facAppointmentItemId',
    			tooltip :getCommonTranslation('SG_APPOINTMENT')
    		},{
    			text:getCommonTranslation('ADD_LIBRARY'),
    			itemId:'kohafacultylibrarymappingBtn',
    			tooltip :getCommonTranslation('ADD_LIBRARY')
    		},{
    			text:getCommonTranslation('ADD_PATRON_CATEGORY'),
    			itemId:'kohafacultycategorymappingBtn',
    			tooltip :getCommonTranslation('ADD_PATRON_CATEGORY')
    		},{
				text:getCommonTranslation('ADD_VOTER_POOL'),
				itemId:'employeeElctionVoterPoolBtn',
				tooltip :getCommonTranslation('ADD_VOTER_POOL')
			},{
				text:getCommonTranslation('REQUEST_DOCUMENTS'),
				itemId:'documentRequest',
				tooltip :getCommonTranslation('REQUEST_DOCUMENTS')
			}],
    		listeners: {click: function() {this.showMenu();}}
    	});
		/*butonstoolbar.insert(4,{
		 	xtype : 'button',
	        itemId:'documentRequest',
	        text : getCommonTranslation('REQUEST_DOCUMENTS'),
	        tooltip :getCommonTranslation('REQUEST_DOCUMENTS'),
	        disabled: true
		});*/
		
    },
    exportFacultyList : function(exportUrl,filetype,whetherAll) {
    	var quickSearchForm=this.getFacultyQuickSearchForm();	
    	var searchResultGrid = this.getFacultySearchResultGrid();
    	var pagingtoolbaroptions = this.getFacultySearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
    	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
    	var reportTitle=getCommonTranslation('FACULTY_LIST');
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	},
	createSearchCriteriaString: function(searchForm) {
    	var me=this;
        var formValues = new Array();
        formValues = searchForm.getValues();        
        var searchCriteriaString="";
        for (var key in formValues) {
        	var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
            }
        }
        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
        return searchCriteriaString;
    },
    createJsonFormat: function(searchForm) {

    	var me=this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.FACULTY_LIST_BASIC_CONFIGCODE;
        var userType = searchForm.down('#userGroupType').getRawValue();
        formValues = searchForm.getValues();        
        
    	if(userType == getCommonTranslation('OTHER_EMPLOYEE')){
    		delete formValues.FACULTY_TYPE;
	    } else if(userType == getCommonTranslation('FACULTY')) {
	    	delete formValues.EMPLOYEE_TYPE;
	    } else {
	    	delete formValues.FACULTY_TYPE;
	    	delete formValues.EMPLOYEE_TYPE;
	    }
        
        for (var key in formValues) {
            var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField' && key !== 'JOINING_DATE_FROM' &&
            		key!== 'JOINING_DATE_TO' && key!== 'EXIT_DATE_FROM' && key!== 'EXIT_DATE_TO' && key!=='empMultiBrandCampusName'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
            }
        }
        if(!isNullOrEmpty(formValues.JOINING_DATE_FROM)){
        	var keyValueJsonObject = me.getJsonObject( "JOINING_DATE_FROM" , formValues.JOINING_DATE_FROM);
	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        }
        if(!isNullOrEmpty(formValues.JOINING_DATE_TO)){
        	var keyValueJsonObject = me.getJsonObject( "JOINING_DATE_TO" , formValues.JOINING_DATE_TO);
	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        }
        if(!isNullOrEmpty(formValues.EXIT_DATE_FROM)){
        	var keyValueJsonObject = me.getJsonObject( "EXIT_DATE_FROM" , formValues.EXIT_DATE_FROM, formValues.EXIT_DATE_TO);
	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        }
        if(!isNullOrEmpty(formValues.EXIT_DATE_TO)){
        	var keyValueJsonObject = me.getJsonObject( "EXIT_DATE_TO" , formValues.EXIT_DATE_TO);
	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        }
        
        if(!isNullOrEmpty(formValues.empMultiBrandCampusName)){
        	var studentStatusCSMComboArr = formValues.empMultiBrandCampusName;
        	var studentStatusCSMArr = [];
        	for(i in studentStatusCSMComboArr){
        		if( !isNullOrEmpty(studentStatusCSMComboArr[i].data) && studentStatusCSMComboArr[i].data!=undefined ){
        			var studentStatusCSMId = studentStatusCSMComboArr[i].data.id;
        			studentStatusCSMArr.push(studentStatusCSMId);
        		}
        		else{
        			if(!isNullOrEmpty(studentStatusCSMComboArr)){
        				var studentStatusCSMId = studentStatusCSMComboArr[i];
        				studentStatusCSMArr.push(studentStatusCSMId);
        			}
        		}
        	}
        	if( studentStatusCSMArr.length != 0 ){
        		var studentStatusCSMObj = {
                        "paramCode": 'ACADEMY_LOCATION_IDS',
                        "paramValues": studentStatusCSMArr
                    };
        		me.pushJsonObjectInArray(studentStatusCSMObj,searchcriteria);
        	}
       }
        
        if(this.getCurrentLoggedPortalId() == 2){
        	var this$ = this;
        	var facultyId = this$.getCurrentlyLoggedInUser().id;
        	var facultyIdObj = this$.getJsonObject('FACULTY_ID' , facultyId);
        	this$.pushJsonObjectInArray(facultyIdObj, searchcriteria);
        }
        values.searchCriterias = searchcriteria;
        return values;
        
    },
    getJsonObject: function(key, value, additionalValue) {
        if (!isNullOrEmpty(value) && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (!isNullOrEmpty(value) && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },
    cellClickFacultySearchResultGrid: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    	var this$ = this;
    	//var searchResultGrid = this.getFacultySearchResultGrid();
    	var columnName = view.getGridColumns()[cellIndex].dataIndex;
        if (columnName == "FACULTY_ID") {
        	if (e.target.tagName == 'A') {
        	var xType = '', tabTitle = '';
        	facultyProfile=record;
        	tabTitle = record.get('FACULTY_ID');
        	if(isNullOrEmpty(tabTitle)){
        		tabTitle = record.get('USER_ID');
        	}
            var userId = record.get('ID');
            var personId = record.get('PERSON_ID');
            var whetherActivated =record.get('WHETHER_ACTIVATED');
            var userGroupName = record.get('USER_GROUP_NAME');
            var whetherFaculty = record.get('WHETHER_FACULTY');
            xType = 'facultyprofile';
            if(userGroupName == 'Faculty') {
	            //if(!isNullOrEmpty(whetherActivated) && whetherActivated){
	            	xType = 'facultyprofile';
	            /*}else{
	            	xType = 'createfacultyprofile';
	            }*/
            } 
            this$.addContentPanelTab(tabTitle, xType, userId, personId, null, null,null,null);
            
            var tabPanel = this.getTabReferenceByTabTitle(tabTitle);
            var detailsLink = tabPanel.down('#facultyPersonDetailsLinkPanel');
            
            //** For Non Faculty employee user */
            
            if(!whetherFaculty) {
	            var courseExc = detailsLink.down('#COURSE_EXECUTION');
	            var store = courseExc.items.items[0].getStore();
	            
	            //*** Remove Course Interest for non faculty ***/
	            
	            var rec = store.getAt(5);
				store.remove(rec);
	            
	            rec = store.getAt(3);
				store.remove(rec);
				
				rec = store.getAt(0);
				store.remove(rec);
				
				var requestPanel = detailsLink.down('#REQUESTS');
				store = requestPanel.items.items[0].getStore();
				rec = store.getAt(3);
				store.remove(rec);
				rec = store.getAt(1);
				store.remove(rec);
				
				
				detailsLink.personType = 'OTHER_EMPLOYEE';
            }
            
            if(!isNullOrEmpty(detailsLink)){
            	var employeeLinkPanelObject = detailsLink.getFacultyProfileLink();
                this.loadPanellinkForEmployee(tabPanel, employeeLinkPanelObject);        	
            }
        }    
      }
    },
    
    loadFacultyListGridStore : function(){
    	var this$ = this;
    	var form = this$.getFacultyQuickSearchForm();
    	if(form){
    		var searchButton = form.down('#searchButtonId');
        	searchButton.fireEvent('click');
    	}
    },

    loadOnComboChange:function(value) {
    	var this$ = this;
    	var portalId = this$.getCurrentLoggedPortalId();
    	var window = this$.getRaiseServiceRequestWindow();

    	if(portalId == 2){
    		var requestType = this.getRequestType();
    		var structure = this$.getFacultyquicksearchview();
    		var comboPanel = structure.down('facultyrequestcombopanel');
    		var combo = comboPanel.down('combo#serviceRequestCombo');
    		if(value ==='TRANSFER' || value ==='EXAM_RELATED') {
    			combo.setVisible(true);
    			combo.setDisabled(false);
    			this.loadComboStore(value,requestType,this.getCurrentAcademyLocation());
    		} else {
    			combo.setVisible(false);
    			combo.setDisabled(true);
    			this.openServiceRequestTab(requestType,value);   		
    		}
    	}else{
    	var comboPanel = window.down('facultyrequestcombopanel');
    	var combo = comboPanel.down('combo#serviceRequestCombo');
    	var requestType = this.getRequestType();
    	combo.clearValue();
    	if(value ==='TRANSFER') {
    		combo.setDisabled(false);
			comboPanel.down("#raiseButtonId").setDisabled(true);
    		this.loadComboStore(value,requestType,this.getCurrentAcademyLocation());
    	} else {
    		combo.setDisabled(true);
			comboPanel.down("#raiseButtonId").setDisabled(false);
    	}
    }
    },
    
    loadComboStore:function(serviceRequestGroup,serviceRequestCategory,academyLocationId) {    	
	var this$ = this;
	var store=null;
	var portalId = this$.getCurrentLoggedPortalId();
	
	if(portalId==2){
		store = this$.getFacultyRequestComboPanel().down('combo#serviceRequestCombo').getStore();
	}else{
		var window = this$.getRaiseServiceRequestWindow();
		store = window.down('combo#serviceRequestCombo').getStore();
	}
	store.load({
		params:{
    		serviceRequestGroup:serviceRequestGroup,
    		serviceRequestCategory:serviceRequestCategory,
    		academyLocationId:academyLocationId
		}	
	});

    },
    
    /**
     * Open Raise service request window
     */
    openRaiseRequestWindow:function(){
    	var this$ = this;
    	var window = this$.getRaiseServiceRequestWindow();
    	if(!window){
    		window = Ext.widget('facultyraiseservicerequestwindow');
    	}
    	window.show();
    },
    
    /**
     * This method is use to open the service request tab for the student
     * @param requestType Type of the request
     * @param requestGroup 
     */
    openServiceRequestTab:function(requestType,requestGroup,otherRequestType) {
    	
    	var portalId = this.getCurrentLoggedPortalId();
    	/**
    	 * for faculty portal login , portalId=2
    	 */
    	
    	if(portalId==2){
    		var facultyDetail = this.getCurrentlyLoggedInUserWithPersonId();
    		var record = this.getSearchResultGrid().getStore().getAt(0);
    		var personId = facultyDetail.personId;
			var facultyId = facultyDetail.id;
			var serviceRequestController = Academia.app.getController('Academia.controller.servicerequest.ServiceRequestBaseController');
			serviceRequestController.getRequestPanel(requestType,requestGroup,facultyId,personId,otherRequestType,record);
    		
    	}else{
    		var grid = this.getFacultyListView().down('grid');
    		if(grid.getSelectionModel().getCount() == 1){	
    			var record = grid.getSelectionModel().getSelection()[0];
    			var personId = record.get('PERSON_ID');
    			var facultyId = record.get('ID');
    			var serviceRequestController = Academia.app.getController('Academia.controller.servicerequest.ServiceRequestBaseController');
    			serviceRequestController.getRequestPanel(requestType,requestGroup,facultyId,personId,otherRequestType,record);
    		} else {
    			showInfoMessage(getServiceRequestTranslation('SERVICE_REQUEST'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    		}   	
    	}
    },
    
    //******************Disable raise request button**********************************
    disableMoreActionPivileges: function(grid,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	buttonsToolBar = grid.query('toolbar')[0];
    	var raiseRequest = grid.down('#raiseRequestButtonItemId');
    	raiseRequest.setVisible(false);
    	var sendMessageBtn = grid.down('#sendMessageBtn');
    	sendMessageBtn.setVisible(false);
    	var sendSurveyBtn = grid.down('#sendSurveyBtn');
    	sendSurveyBtn.setVisible(false);
    	var printCardBtn = grid.down('#printCardBtn');
    	printCardBtn.setVisible(false);
    	var assignEmployeeCommitteeBtn = grid.down('#assignEmployeeCommitteeBtn');
    	var assignEmployeeCalendarBtn = grid.down('#assignEmployeeWorkCalendarBtn');
    	assignEmployeeCalendarBtn.setVisible(false);
    	assignEmployeeCommitteeBtn.setVisible(false);
    	var kohafacultylibrarymappingBtn = grid.down('#kohafacultylibrarymappingBtn');
    	var kohafacultycategorymappingBtn = grid.down('#kohafacultycategorymappingBtn');
    	var spBtnMoreActionsBtn = grid.down('#spBtnMoreActions');
    	kohafacultylibrarymappingBtn.setVisible(false);
    	kohafacultycategorymappingBtn.setVisible(false);
    	spBtnMoreActionsBtn.setVisible(false);
    	var documentRequest = grid.down('#documentRequest');
    	documentRequest.setVisible(false);
    	documentRequest.setDisabled(true);
    	var bulkDownloadDocIdBtn = grid.down('#bulkDownloadDocId');
    	bulkDownloadDocIdBtn.setVisible(false);
    	
    	var facultyAppointmentIdBtn = grid.down('#facAppointmentItemId');
    	facultyAppointmentIdBtn.setVisible(false);
    	facultyAppointmentIdBtn.setDisabled(true);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'RAISEREQUEST') {
        		var button = buttonsToolBar.query('#raiseRequestButtonItemId')[0];
        		if(!isNullOrEmpty(button)){
        			raiseRequest.setVisible(true);
        		}        		
        	}
    		if (privilege === 'SENDMESSAGE') {
        		var button = buttonsToolBar.query('#sendMessageBtn')[0];
        		if(!isNullOrEmpty(button)){
        			sendMessageBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'SENDSURVEY') {
        		var button = buttonsToolBar.query('#sendSurveyBtn')[0];
        		if(!isNullOrEmpty(button)){
        			sendSurveyBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'PRINT') {
        		var button = buttonsToolBar.query('#printCardBtn')[0];
        		if(!isNullOrEmpty(button)){
        			printCardBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'DOCUMENT_REQUEST') {
        		var button = buttonsToolBar.query('#documentRequest')[0];
        		if(!isNullOrEmpty(button)){
        			documentRequest.setVisible(true);
        		}        		
        	}
    		if (privilege === 'ADD_COMMITTEE') {
        		var button = buttonsToolBar.query('#assignEmployeeCommitteeBtn')[0];
        		if(!isNullOrEmpty(button)){
        			assignEmployeeCommitteeBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'ASSIGN_WORK_CALENDAR') {
        		var button = buttonsToolBar.query('#assignEmployeeWorkCalendarBtn')[0];
        		if(!isNullOrEmpty(button)){
        			assignEmployeeCalendarBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'BULK_APPLICATION_DOCUMENT_DOWNLOAD') {
        		var button = buttonsToolBar.query('#bulkDownloadDocId')[0];
        		if(!isNullOrEmpty(button)){
        			bulkDownloadDocIdBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'APPOINTMENT') {
        		var button = buttonsToolBar.query('#facAppointmentItemId')[0];
        		if(!isNullOrEmpty(button)){
        			facultyAppointmentIdBtn.setVisible(true);
        		}        		
        	}
        	if (privilege === 'MOREACTION') {
        		var button = buttonsToolBar.query('#spBtnMoreActions')[0];
        		if(!isNullOrEmpty(button)){
        			spBtnMoreActionsBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'ADD_LIBRARY') {
        		var button = buttonsToolBar.query('#kohafacultylibrarymappingBtn')[0];
        		if(!isNullOrEmpty(button)){
        			kohafacultylibrarymappingBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'ADD_PATRON_CATEGORY') {
        		var button = buttonsToolBar.query('#kohafacultycategorymappingBtn')[0];
        		if(!isNullOrEmpty(button)){
        			kohafacultycategorymappingBtn.setVisible(true);
        		}        		
        	}
    	});
    },
    
    /**
     * This is used to disable extra buttons on serach result grid
     */
    disableExtraButton:function(column,selected) {
    	var grid = this.getSearchResultGrid();
    	var raiseRequestButtonItemId = grid.down('#raiseRequestButtonItemId');
    	var appointmentButtonItemId = grid.down('#facAppointmentItemId');
    	var documentRequest = grid.down('#documentRequest');
    	if(selected.length== 1){ // enable
    		raiseRequestButtonItemId.setDisabled(false);
    		appointmentButtonItemId.setDisabled(false);
    		documentRequest.setDisabled(false);
    	}else if(selected.length>1){
    		documentRequest.setDisabled(false);
    	}else{  // disable
    		raiseRequestButtonItemId.setDisabled(true);
    		appointmentButtonItemId.setDisabled(true);
    		documentRequest.setDisabled(true);
    	}
    },
    sendSurveyDetails:function(){
    	var $this = this;
    	var grid = $this.getSearchResultGrid();
//    	var records = grid.getSelectionModel().getSelection()[0];
//    	console.log('record',records);
   
    	var form = $this.getFacultySendsurvey().getForm();
    	var surveyId = form.findField('survey').getValue();
    	var surveyUrl = form.findField('survey').getRawValue();

    	var jsonData = [];
    	var selected = grid.selModel.getSelection();
    	if( selected.length > 0){
    		
    		for( var i = 0; i < selected.length; i++) {
    			jsonData.push({
    				"id":selected[i].data.ID,
    				"surveyMaster" : $this.getIdValueJson(surveyId),
//  				"userId":selected[i].data.ID,
    				"surveyUrl" : surveyUrl, //+ '&userId=' + selected[i].data.ID,
    				"applicant": null,
    				"student": null,
    				"enquiry": null,
    				"user" : $this.getIdValueJson(selected[i].data.ID),
    				"userType":"FACULTY"

    			});
    		}
    	}
    	submitUrl = SERVERURL.SEND_SURVEY;
 		Ext.Ajax.request({
 			type : 'rest',
 			url : submitUrl,
 			jsonData : jsonData,
 			method : 'POST',
 			success : function(form, action) {
 				showSuccessMessage(getCommonTranslation('SEND_SURVEY'),getCommonTranslation('SUCCESS'));
 				grid.getStore().reload();
 				$this.getFacultysendsurvey().close();
 			}
 		});
    },
    getIdValueJson: function(id, value,code) {
    	if (id) return {
    		id: id,
    		value: value,
    		code: code
    	};
    },
    
    showFacultyBulkPrintWin:function(){
    	var $this = this;
    	var formWindow = $this.getFacultybulkprintwidow();
    	if (!formWindow) {
    		formWindow = Ext.widget('facultybulkprintwidow',{
    			itemId:'facultyPrintIdWindow'
    		});
    		Ext.widget('facultybulkprintwidow');
    		formWindow = $this.getFacultybulkprintwidow();
    	}
    	formWindow.show();
    	
    	var form = formWindow.down('form');
		var  templateNameField = form.down("#templateNameFaculty");
		
		var store = templateNameField.getStore();
		
		var academyLocationId=$this.getCurrentAcademyLocation();
		store.getProxy().extraParams={
	    	academyLocationId:academyLocationId,
	    	reportType:'Employee ID Card'
		};
		store.load();
    },
		
		showFacultyRequestDocumentWin:function(){
	    	var $this = this;
	    	var formWindow = $this.getFacultyrequestdocumentwidow();
	    	if (!formWindow) {
	    		formWindow = Ext.widget('facultyrequestdocumentwidow',{
	    			itemId:'facultyrequestdocumentId'
	    		});
	    		Ext.widget('facultyrequestdocumentwidow');
	    		formWindow = $this.getFacultyrequestdocumentwidow();
	    	}
	    	formWindow.show();
	    	
	    	var form = formWindow.down('form');
			var  templateNameField = form.down("#DocummentGroupFaculty");
			
			var store = templateNameField.getStore();
			
			var academyLocationId=$this.getCurrentAcademyLocation();
			store.getProxy().extraParams={
		    	academyLocationId:academyLocationId,
		    	applicableTo: 'EMPLOYEE'
			};
		/*store.on('load', function(){
			for(var i=store.data.items.length-1; i>= 0;i--){
				if(!(store.data.items[i].data.code == 'Employee Id Card')){
					var rec = store.getAt(i);
					store.remove(rec);
				}
			}
		});*/
		
		store.load();
    },
    
    exportFacultyIdCardJRXML: function(fileType,grid, button) {
    	var studentId=0;
    	var admissionId=0;
    	if (grid.getSelectionModel().getCount() > 0) {
    		var record = grid.getSelectionModel().getSelection();
    		var employeetemp=[];
    		var formWindow = Ext.widget('facultybulkprintwidow',{
    			itemId:'facultyPrintIdWindow'
    		});
    		for(var i in record){
    			employeetemp.push(record[i].get("ID"));
    		}
    		employeeId=employeetemp.join();
    		
    		user=this.getCurrentlyLoggedInUser();
    		// code to identify jasper
//    		var form = formWindow.down('form').getForm();
    		var templateName = this.getFacultybulkprintwidow().down('#templateNameFaculty').getValue();
//  		var code ="ID_CARD_BACK";
    		var reportParams =new Object();
    		reportParams.userId=user.code;
    		reportParams.ids=String(employeeId); // convert int into string
    		
    		var reportTitle=getFeeAndPaymentCommonTranslation('ID_CARD');
    		var exportUrl = SERVERURL.EMPLOYEE_ID_CARD_PDF;
    		this.exportJRXMLReport(templateName,reportParams,reportTitle,fileType,exportUrl);
    		this.getFacultybulkprintwidow().close();
    	} else {
    		showWarningMessage(getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    documentRequestFaculty: function(button) {
    	var grid = this.getSearchResultGrid();
    	var records=grid.getSelectionModel().getSelection();

    	var studentId=0;
    	var admissionId=0;
    	var	formWindow = Ext.widget('facultyrequestdocumentwidow',{
    		itemId:'facultyrequestdocumentId'
    	});
    	var academyLocationId=this.getCurrentAcademyLocation();

    	var empListArrays = [];
    	for(var i in records) {
    		empListArrays.push(records[i].data.PERSON_ID);
    	}
    	var personIds = empListArrays.join(',');

    	var documentGroupMasterId = this.getFacultyrequestdocumentwidow().down('#DocummentGroupFaculty').getValue();

    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	Ext.Ajax.request({
    		type : 'rest',
    		url : SERVERURL.PATH_PRDGM_MAKE_REQUEST_FOR_DOCUMENT,
    		method : 'POST',
    		//async: false,
    		params: {
    			documentGroupMasterId: documentGroupMasterId,
    			academyLocationId: academyLocationId,
    			personIds:personIds
    		},
    		headers: {
    			'Content-Type': 'application/json'
    		},
    		success : function(form, action) {
    			Ext.getBody().unmask();
    			showSuccessMessage(getCommonTranslation('REQUEST_DOCUMENTS'),getExaminationTranslation('SUCCESS'));

    		}
    	});
    	this.getFacultyrequestdocumentwidow().close();
    },
    printFacultyProfile :function(){
		   var $this = this;
		   user=$this.getCurrentlyLoggedInUser();
		   var code ="EmployeeSummaryReport";
		   var grid = $this.getSearchResultGrid();
		   var contentPanel=$this.getContentPanel();
		   var employeeId=contentPanel.getActiveTab().userId;
		   var employeePersonId=contentPanel.getActiveTab().personId;
		   
		   var reportParams =new Object();
		   var title= contentPanel.getActiveTab().title+"-"+ new Date().getTime();
		   reportParams.reportTitle=title;
		   reportParams.userId=user.code;
		   reportParams.employeeId=employeeId;
		   reportParams.employeePersonId = employeePersonId;
		   reportParams.academyLocationId = $this.getCurrentAcademyLocation();
		   reportParams.code = code;
	
		   $$this = Academia.app.getController('Academia.controller.personinfo.faculty.FacultyPersonalController');
		   var returnJson = new Object();
		   returnJson = $$this.getAllPermissions();
		   reportParams.isPersonalDetails = returnJson.map.isPersonalDetails;
		   reportParams.isAddress = returnJson.map.isAddress;
		   reportParams.isEducation = returnJson.map.isEducation;
		   reportParams.isWorkExp = returnJson.map.isWorkExp;
		   reportParams.isResearch = returnJson.map.isResearch;
		   reportParams.isSeminar = returnJson.map.isSeminar;
		   reportParams.isTraining = returnJson.map.isTraining;
		   reportParams.isPatent = returnJson.map.isPatent;
		   reportParams.isPNC = returnJson.map.isPNC;           
		   reportParams.isMedical = returnJson.map.isMedical;
		   reportParams.isVaccination = returnJson.map.isVaccination;
		   reportParams.isExtracurricularActivity = returnJson.map.isExtracurricularActivity;
		   reportParams.isCompetitive = returnJson.map.isCompetitive;
		   reportParams.isService = returnJson.map.isService;
		   reportParams.isDocument = returnJson.map.isDocument;
		   reportParams.isDisciplinaryAction = returnJson.map.isDisciplinaryAction;
		   reportParams.isPositiveIncident = returnJson.map.isPositiveIncident;
		   reportParams.isBilling = returnJson.map.isBilling;
		   reportParams.isReceipt = returnJson.map.isReceipt;
		   reportParams.isRefund = returnJson.map.isRefund;
		   
		   var exportUrl = SERVERURL.PATH_PRINT_EMPLOYEE;
		   $this.exportJRXMLReport(code,reportParams,title,'.pdf',exportUrl);

    }, disableMyDashboardPivileges: function(panel,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var profilePrintButton = panel.down('#printBtn');
    	
    	profilePrintButton.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'PROFILE_PRINT') {
        		if(!isNullOrEmpty(profilePrintButton)){
        			profilePrintButton.setVisible(true);
        		}        		
        	}
    	});
    },
    
    openAssignFacultyCommitteeWindow: function() {
    	var $this = this;
    	var formWindow = $this.getFacultycommitteealwindow();
			if(!formWindow){
				formWindow = Ext.widget('committeealwindow',{
        			itemId:'facultyMapCommitteeWindow'
        		});
			formWindow.setHeight(180);
			formWindow.setWidth(320);
			formWindow.setTitle(getCommonTranslation("COMMITTEE"));
		}
		formWindow.down('#mapCommitteeWindowId').show();
		var committeeStore = formWindow.down('#committeeItemId').getStore();
		committeeStore.getProxy().extraParams = {
			academyLocationIds:$this.getCurrentAcademyLocation(),
			isStudentFaculty:true
		};
		committeeStore.load();

		formWindow.show();
    },
    
    openAssignCalendarWindow: function() {
    	var $this = this;
    	var formWindow = $this.getAssignworkcalendarwindow();
    	if(!formWindow){
    		formWindow = Ext.widget('assignworkcalendarwindow',{
    			itemId:'assignworkcalendarwindowItemId'
    		});
    		formWindow.setHeight(180);
    		formWindow.setWidth(780);
    	}
    	var calendarStore = formWindow.down('#calendarId').getStore();
    	calendarStore.load();
    	formWindow.show();
    },saveFacultyLibraryDetails:function(obj){
    	var $this = this;
    	var grid = $this.getSearchResultGrid();

    	var form = $this.getKohafacultylibrarymappingwin();
    	var libraryId = form.down('#library');
        	var arrayOfData = form.down('#library').getStore().data.items;
        var academyLocKohaBranchId = null;
    	for(var i = 0; i < arrayOfData.length ; i++)
		{
			if(arrayOfData[i].data.id === libraryId.value)
			{
				academyLocKohaBranchId = arrayOfData[i].data.academicTermId;
			}
		}
    	var jsonData = [];
    	var selected = grid.selModel.getSelection();
    	if( selected.length > 0){

    		for( var i = 0; i < selected.length; i++) {
    			jsonData.push({
    				"id":selected[i].data.ID,
    				"student": $this.getIdValueJson(selected[i].data.ID),
    				"libraryId":libraryId.value,
    				"userType":"STAFF",
    				"academyLocKohaBranchId":academyLocKohaBranchId
    			});
    		}
    	}
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	checkMappingUrl = SERVERURL.MAP_LIBRARY_WITH_STUDENT_AND_EMPLOYEE;		
    	submitUrl = SERVERURL.MAP_LIBRARIES;
    	//Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
    	Ext.Ajax.request({
    		type : 'rest',
    		url : checkMappingUrl,
    		jsonData : jsonData,
    		method : 'POST',
    		success : function(form, action) {
    			if(form.responseText=="DEPENDENCY_EXISTS"){
    				showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('LIBRARY_EMPLOYEE_ALREADY_MAPPED_MESSAGE'), function(btn, text) {
    					if (btn == 'yes') {
    						Ext.Ajax.request({
    							type : 'rest',
    							url : submitUrl,
    							jsonData : jsonData,
    							method : 'POST',
    							success : function(form, action) {
    								showSuccessMessage(getCommonTranslation('FACULTY_MAPPED'),getCommonTranslation('LIBRARY_EMPLOYEE_MAPPED_SUCCESS_MESSAGE'));

    							}
    						});
    					}
    				});
    			}else{
    				Ext.Ajax.request({
    					type : 'rest',
    					url : submitUrl,
    					jsonData : jsonData,
    					method : 'POST',
    					success : function(form, action) {
    						showSuccessMessage(getCommonTranslation('FACULTY_MAPPED'),getCommonTranslation('LIBRARY_EMPLOYEE_MAPPED_SUCCESS_MESSAGE'));

    					}
    				});
    			}
    			grid.getStore().reload();
//  			$this.getStudentsendsurvey().close();
    			obj.up('window').close();
    		}
    	});
    	Ext.getBody().unmask();
    }
    ,saveFacultyCategoryDetails:function(obj){
    	var $this = this;
    	var grid = $this.getSearchResultGrid();

    	var form = $this.getKohafacultycategorymappingwin();
    	var categoryId = form.down('#category');
            	var arrayOfData = form.down('#category').getStore().data.items;
    	var academyLocKohaCategoriesId = null;
    	for(var i = 0; i < arrayOfData.length ; i++)
		{
			if(arrayOfData[i].data.id === categoryId.value)
			{
				academyLocKohaCategoriesId = arrayOfData[i].data.academicTermId;
			}
		}
    	var jsonData = [];
    	var selected = grid.selModel.getSelection();
    	if( selected.length > 0){

    		for( var i = 0; i < selected.length; i++) {
    			jsonData.push({
    				"id":selected[i].data.ID,
    				"student": $this.getIdValueJson(selected[i].data.ID),
    				"categoryId":categoryId.value,
    				"userType":"STAFF",
    				"academyLocKohaCategoriesId":academyLocKohaCategoriesId
    			});
    		}
    	}
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	checkMappingUrl = SERVERURL.MAP_CATEGORY_WITH_STUDENT_AND_EMPLOYEE;
    	submitUrl = SERVERURL.MAP_CATEGORIES;	
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
    	Ext.Ajax.request({
    		type : 'rest',
    		url : checkMappingUrl,
    		jsonData : jsonData,
    		method : 'POST',
    		success : function(form, action) {
    			if(form.responseText=="DEPENDENCY_EXISTS"){
    				showConfirmMessage(getCommonTranslation('MAP_PATRON_CATEGORY'),getCommonTranslation('CATEGORY_EMPLOYEE_ALREADY_MAPPED_MESSAGE'), function(btn, text) {
    					if (btn == 'yes') {
    						Ext.Ajax.request({
    							type : 'rest',
    							url : submitUrl,
    							jsonData : jsonData,
    							method : 'POST',
    							success : function(form, action) {
    								showSuccessMessage(getCommonTranslation('FACULTY_MAPPED'),getCommonTranslation('CATEGORY_EMPLOYEE_MAPPED_SUCCESS_MESSAGE'));

    							}
    						});
    					}
    				});
    			}else{
    				Ext.Ajax.request({
    					type : 'rest',
    					url : submitUrl,
    					jsonData : jsonData,
    					method : 'POST',
    					success : function(form, action) {
    						showSuccessMessage(getCommonTranslation('FACULTY_MAPPED'),getCommonTranslation('CATEGORY_EMPLOYEE_MAPPED_SUCCESS_MESSAGE'));

    					}
    				});
    			}
    			grid.getStore().reload();
//  			$this.getStudentsendsurvey().close();
    			obj.up('window').close();
    		}
    	});
    	Ext.getBody().unmask();
    },
    
    saveAssignWorkCalendar: function(record) {
    	var $this = this;
    	var formWindow = $this.getAssignworkcalendarwindow();
    	var form = formWindow.down('#assignworkcalendar');
    	var formValues = form.form.getValues();
    	//var grid = $this.getStaffworkhoursgrid();
    	var grid = this.getContentPanel().getActiveTab().down('staffworkhoursgrid');
    	var startDate = formWindow.down('#startDate').getValue();
    	var endDate = formWindow.down('#endDate').getValue();
    	//var status=formWindow.down('#status').getValue();
    	var id = formWindow.down('#id').getValue();
    	var assignCalendarId = formWindow.down('#assignCalendarId').getValue();
    	var calendarId = formWindow.down('#calendarId').getValue();
    	var staffId;
    	if(this.getContentPanel().getActiveTab().xtype == 'facultyprofile') {
    		staffId = this.getContentPanel().getActiveTab().userId;
    	}
    	var submitUrl, isUpdate = false;
    	var validateCalendar = true;
    	var isUpdateCalendar = null;
    	if (isNullOrEmpty(id)) {
    	    submitUrl = SERVERURL.STAFF_CALENDAR_CREATE;
    	    isUpdate = false;
    	    var calendarValue = {
    	        id: calendarId
    	    };
    	    isUpdateCalendar = false;
    	} else {
    	    submitUrl = SERVERURL.STAFF_CALENDAR_UPDATE;
    	    isUpdate = true;
    	    var calendarValue = {
    	        id: assignCalendarId
    	    };
    	    isUpdateCalendar = true;
    	}
    	var staffValue = {
    	    id: staffId
    	};
    	
    	// TO DO
        var configureArray = [];
        var calendarFormformData = new Academia.model.calendar.StaffCalendarGridModel();
        if (isUpdate) {
            calendarFormformData.set("id", id);
            calendarFormformData.set("calendarId", assignCalendarId);
            calendarFormformData.set("staffId", staffId);
            calendarFormformData.set("startDate", startDate);
            calendarFormformData.set("endDate", endDate);
            configureArray.push(calendarFormformData.data);
        } else {
        	if(!isNullOrEmpty(record) && record.length > 0) {
        		for(var i=0; i < record.length; i++ ) {
        			calendarFormformData = new Academia.model.calendar.StaffCalendarGridModel();
        			calendarFormformData.set("id", id);
                    calendarFormformData.set("calendarId", calendarId);
                    calendarFormformData.set("staffId", record[i].data.ID);
                    calendarFormformData.set("startDate", startDate);
                    calendarFormformData.set("endDate", endDate);
                    configureArray.push(calendarFormformData.data);
        		}
        	} else if(this.getContentPanel().getActiveTab().xtype == 'facultyprofile') {
        		calendarFormformData.set("id", id);
                calendarFormformData.set("calendarId", calendarId);
                calendarFormformData.set("staffId", staffId);
                calendarFormformData.set("startDate", startDate);
                calendarFormformData.set("endDate", endDate);
                configureArray.push(calendarFormformData.data);
        	}
        }
        // calendarFormformData.set("status",status);
       // var formData = Ext.encode(calendarFormformData.data);
        configureArray = Ext.encode(configureArray);
        Ext.getBody().mask();
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: configureArray,
            method: 'POST',
            success: function(frm, action) {
                Ext.getBody().unmask();
                if (isUpdate) {
                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('UPDATED_STAFF_CALENDAR_SUCCESSFULLY'));
                    formWindow.close();
                    grid.getStore().load();
                    grid.getSelectionModel().deselectAll();
                } else {
                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('ASSIGN_CALENDAR_SUCCESSFULLY'));
                    formWindow.close();
                   if(!isNullOrEmpty(grid)) {
                    grid.getStore().load();
                    grid.getSelectionModel().deselectAll();
                   }else if(!isNullOrEmpty($this.getSearchResultGrid())) {
                	   $this.getSearchResultGrid().getSelectionModel().deselectAll();
                   }
                }
            }
        });
        
    	/*Ext.Ajax.request({
    	    url: SERVERURL.FIND_ALL_EXISTING_CALENDAR_DATE,
    	    method: 'GET',
    	    async: false,
    	    params: {
    	        id: id,
    	        calendarId: calendarValue,
    	        startDate: startDate,
    	        endDate: endDate,
    	        staffId: staffId,
    	        isUpdateCalendar: isUpdateCalendar,
    	    },
    	    success: function(response) {
    	        if (response.responseText === "EXIST") {
    	            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('EMPLOYEE_CALENDAR_ALREADY_EXISTS'));
    	            validateCalendar = false;
    	        } else if (response.responseText === "SUCCESS") {

    	            var calendarFormformData = new Academia.model.calendar.StaffCalendarGridModel();
    	            if (isUpdate) {
    	                calendarFormformData.set("id", id);
    	                calendarFormformData.set("calendarId", assignCalendarId);
    	                calendarFormformData.set("staffId", staffId);
    	                calendarFormformData.set("startDate", startDate);
    	                calendarFormformData.set("endDate", endDate);
    	            } else {
    	                calendarFormformData.set("id", id);
    	                calendarFormformData.set("calendarId", calendarId);
    	                calendarFormformData.set("staffId", staffId);
    	                calendarFormformData.set("startDate", startDate);
    	                calendarFormformData.set("endDate", endDate);
    	            }
    	            // calendarFormformData.set("status",status);
    	            var formData = Ext.encode(calendarFormformData.data);
    	            Ext.getBody().mask();
    	            Ext.Ajax.request({
    	                type: 'rest',
    	                url: submitUrl,
    	                jsonData: formData,
    	                method: 'POST',
    	                success: function(frm, action) {
    	                    Ext.getBody().unmask();
    	                    if (isUpdate) {
    	                        showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('UPDATED_STAFF_CALENDAR_SUCCESSFULLY'));
    	                        formWindow.close();
    	                        grid.getStore().load();
                                grid.getSelectionModel().deselectAll();
    	                    } else {
    	                        showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('ASSIGN_CALENDAR_SUCCESSFULLY'));
    	                        formWindow.close();
    	                        grid.getStore().load();
                                grid.getSelectionModel().deselectAll();
    	                        //grid.getStore().load(); 
    	                    }
    	                }
    	            });
    	        }
    	    }
    	});*/
    },
    
    openFacultySendMessage:function(obj){

    	var grid = this.getSearchResultGrid();
    	//var gridMSG = this.getStaticDocumentAttachmentGrid();
    	if(grid.getSelectionModel().getCount()>0) {

    		var $this=this;
    		var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    		var structure = Ext.widget('facultysendmessages',{
    			itemId:'facultyListSendMessageWindows'
    		});
    		var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
    		/**
    		 * This is to remove tab from content panel and open same tab again
    		 */
    		var getcontroller=this.getController('menu.CoreERPNavigationController');
    		var getTab=getcontroller.getTab(tabName);
    		if(getTab!=null){
    			contentPanel.remove(getTab, true);
    		}
    		var formWindowTab = $this.getFacultysendmessages();
    		formWindowTab.down("#selectTemplate").allowBlank=true;
    		formWindowTab.down("#selectTemplate").setVisible(false);
    		formWindowTab.down("#messageName").allowBlank=true;   
    		formWindowTab.down("#messageName").setVisible(false);
    		var templateStore = formWindowTab.down('#selectTemplate').getStore();
    		templateStore.getProxy().extraParams={
    			msgRecipientTypeId:8
    		};
    		templateStore.load();

    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		Ext.Ajax.request({
    			method : "GET",
    			type : 'rest',
    			url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=FacultyTemplatebe539740-692d-4ae1-bc17-338c4002874d',
    			headers : {
    				'Content-Type' : 'application/json'
    			},
    			success : function(form,action) {
    				var data = Ext.JSON.decode(form.responseText);
    				formWindowTab.down("#id").setValue(data.id);
    				formWindowTab.down("#code").setValue(data.code);
    				formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
    				formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
    				formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
    				Ext.getBody().unmask();

    				//grid.getStore().reload();
    				//showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
    			}

    		});
    		openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);
    		/*if (!formWindow) {
    				Ext.widget('facultysendmessages');
    				formWindow = $this.getfacultysendmessages();
    			}
    			formWindow.show(;*/

    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    selectFacultySectionMessageType : function(val,nV,oV){

     	 var $this =  this;
     	 var formWin = $this.getFacultysendmessages();
     	 formWin.down("#templatedItemId").hide();
 		 formWin.down("#templatedItemId").allowBlank=true;
     	 //var value = nV.1;
     	 if(nV.messageType==2){
     		 formWin.down("#messageId").hide();
     		 formWin.down("#selectTemplate").allowBlank=true;
     		 formWin.down("#selectTemplate").setVisible(false);     		 
     		 formWin.down("#messageName").allowBlank=true;   
     		 formWin.down("#messageName").setVisible(false);
     		 formWin.down("#msgTempletId").setVisible(true);
     		 formWin.down("#msgTempletId").allowBlank=false;
     		 formWin.down("#msgTempletId").reset();
     		 formWin.down("#subject").setVisible(true);
     		 formWin.down("#subject").allowBlank=false;
     		 formWin.down("#subject").reset();
     		 formWin.down("#discriptionId").setVisible(true);
     		 formWin.down("#discriptionId").reset();
     		 formWin.down('#smsDiscription').reset();
     		 formWin.down('#smsDiscription').hide();
     		 formWin.down('#smsDiscriptionNotice').hide();
     		 formWin.down('#pushNotificationDiscription').hide();
     		 formWin.down('#pushNotificationDiscriptionNotice').hide();
     		 formWin.down('#fldSendToContainer').show();
     	 }else{
     		 formWin.down("#msgTempletId").allowBlank=true;
     		 formWin.down("#msgTempletId").setVisible(false);     		
     		 formWin.down("#messageId").setVisible(true);
     		 formWin.down("#selectTemplate").setVisible(true);     		
     		 formWin.down("#messageName").setVisible(true);
     		 formWin.down("#messageName").reset();
     		 formWin.down("#subject").allowBlank=true;
     		 formWin.down("#subject").setVisible(false);
     		 formWin.down("#discriptionId").setVisible(false);
     		 formWin.down("#messageName").allowBlank=false;  
     		 formWin.down("#selectTemplate").allowBlank=false;
     		 formWin.down("#selectTemplate").reset();
     		 formWin.down("#facultyDocumentMessageAttachmentGrid").setVisible(false);
     		 formWin.down("#staticUploadFileField").setVisible(false);
     		 formWin.down('#smsDiscription').reset();
     		 formWin.down('#smsDiscription').hide();
     		 formWin.down('#smsDiscriptionNotice').hide();
     		 formWin.down('#pushNotificationDiscription').hide();
	      	 formWin.down('#pushNotificationDiscriptionNotice').hide();
     		 var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
     		 formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
     		 formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
     		 formWin.down('#fldSendToContainer').hide();
     	 }
     	formWin.getForm().checkValidity();
      },
      selectFacultyMessageTemp: function(obj,rec){
      	var $this =  this;
      	 var formWin = $this.getFacultysendmessages();
      	 var subject = formWin.down('#subject');
      	 var smsDiscription = formWin.down('#smsDiscription');
 		 var smsDiscriptionNotice = formWin.down('#smsDiscriptionNotice');
 		 var pushNotificationDiscription = formWin.down('#pushNotificationDiscription');
 		 var pushNotificationDiscriptionNotice = formWin.down('#pushNotificationDiscriptionNotice');
 		 formWin.down("#templatedItemId").hide();
 		 formWin.down("#templatedItemId").reset();
 		 if(formWin.defaultValue){
 			formWin.down("#templatedItemId").setValue(formWin.defaultValue)
 		 }
 		 formWin.down("#templatedItemId").allowBlank=true;
      	 if(rec[0].data.value == "SMS")
      	 {
      		 if(formWin.templateIdVisble){
      			 formWin.down("#templatedItemId").show();
      		 }else{
      			 formWin.down("#templatedItemId").allowBlank=true;
      			 formWin.down("#templatedItemId").hide();
      			 
      		 }if(formWin.templateIdMandatory){
      			 if(formWin.templateIdVisble){
      				 formWin.down("#templatedItemId").allowBlank=false;
      				 formWin.down("#templatedItemId").setFieldLabel(getMessagingModuleTranslation('TEMPLATE_ID') +':<span class="required" style="color:red"> *</span>')

      			 }else{
      				formWin.down("#templatedItemId").allowBlank=true;
      			 }
      		 }else{
      			 formWin.down("#templatedItemId").allowBlank=true;
      		 }
      		 formWin.down("#subject").setVisible(false);
      		 formWin.down("#subject").allowBlank=true;
      		
      		 formWin.down("#staticUploadFileField").hide();
      		 formWin.down("#facultyDocumentMessageAttachmentGrid").hide();
      		 formWin.down('#discriptionId').reset();
      		 formWin.down('#discriptionId').hide();	       		 
      		 subject.reset();
      		 smsDiscription.show();
      		 smsDiscriptionNotice.show();
      		 pushNotificationDiscription.hide();
      		 pushNotificationDiscriptionNotice.hide();
      		 pushNotificationDiscription.reset();
      	 }else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION_ONLY" || rec[0].data.value == "Push Notification Only")
      	 {
      		 formWin.down('#discriptionId').reset();
      		 formWin.down('#smsDiscription').reset();
      		 formWin.down('#smsDiscription').hide();
      		 formWin.down('#smsDiscriptionNotice').hide();
      		 formWin.down("#staticUploadFileField").hide();
      		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
      		 formWin.down("#facultyDocumentMessageAttachmentGrid").hide()
      		 subject.reset();
      		 subject.show();
       		 this.setAllowBlank(subject,false);
       		 //formWin.down("#subject").allowBlank=false;
       		 formWin.down('#discriptionId').show();
       		 pushNotificationDiscription.hide();
       		 pushNotificationDiscriptionNotice.hide();
       		 pushNotificationDiscription.reset(); 		
      	 }
      	 /*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
      		 subject.show();
      		 formWin.down("#staticUploadFileField").hide();
      		 this.setAllowBlank(subject,false);
      		 formWin.down("#facultyDocumentMessageAttachmentGrid").hide();
      		 formWin.down('#discriptionId').reset();
      		 formWin.down('#discriptionId').hide();
      		 subject.reset();
      		 smsDiscription.reset();
      		 smsDiscription.hide();
      		 smsDiscriptionNotice.hide();
      		 pushNotificationDiscription.reset();
      		 pushNotificationDiscription.show();
      		 pushNotificationDiscriptionNotice.show();
      		 pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
      		 //formWin.down('#smsDiscription')
      	 }*/
      	 else
      	 {
      		 formWin.down('#discriptionId').reset();
      		 formWin.down('#smsDiscription').reset();
      		 formWin.down('#smsDiscription').hide();
      		 formWin.down('#smsDiscriptionNotice').hide();
      		 formWin.down("#staticUploadFileField").show();
      		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
      		 formWin.down("#facultyDocumentMessageAttachmentGrid").show()
      		 subject.reset();
      		 subject.show();
       		 this.setAllowBlank(subject,false);
       		 //formWin.down("#subject").allowBlank=false;
       		 formWin.down('#discriptionId').show();
       		 pushNotificationDiscription.hide();
       		 pushNotificationDiscriptionNotice.hide();
       		 pushNotificationDiscription.reset(); 		
      	 }
      	 formWin.getForm().checkValidity();
      	 
      },
      /**
       * upload static document file for Student
       */
      uploadFacultyStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
   	   var this$ = this;
   	   var setupForm = fileField.up('facultysendmessages');
   	   var grid = setupForm.down('#facultystaticdocumentattachmentgridMessage');
   	   fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
   	   var file = fileField.fileInputEl.dom.files[0];
   	   var fileSizeLimit = '5';
	   var url = SERVERURL.FILE_PRIORITY;
	   Ext.Ajax.request({
			type: 'rest',
			url: url+'?type=emailFileSize',
			method: 'GET',
			success : function(response, action){
				var responseData = Ext.JSON.decode(response.responseText);
				if(responseData.length>0 && responseData[0].value!=undefined && !isNullOrEmpty(responseData[0].value))
				{
					fileSizeLimit=responseData[0].value;
				}
	   if((file.size / 1048576) <=  fileSizeLimit ){
   		   if(!isNullOrEmpty(fileUploadPath)){
   			   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
   			   if (this$.isValidFileExtensionForMessaging(extension)) {
   				   var entityId = 'faculty';
   				   var module = 'messaging';
   				   var entityType = 'template';
   				   var documentType = 'DOCUMENT';
   				   var isTransient = true;
   				   this$.saveStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
   					   if(success){
   						   var path = Ext.JSON.decode(action.response.responseText).path;
   						   var user = this$.getCurrentlyLoggedInUser();
   						   var store = grid.getStore();
   						   var documentStatus = "SUBMITTED";
   						   var documentType = null;
   						   if(!isNullOrEmpty(path)){
   							   store.add({
   								   id: '',
   								   name: fileUploadPath,
   								   path: path ,
   								   createdBy : {
   									   id :user.id,
   									   value : user.value,
   									   code : user.code
   								   },
   								   status : documentStatus,
   								   documentType : documentType,
   								   templateConfigDocId: '',
   								   submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

   							   });
   							   this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
   							   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
   						   }

   						   fileField.reset();
   					   }

   				   }, isTransient);
   			   }else{
   				   fileField.reset();
   				   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
   			   }
   		   }   		   
   	   }else{
   		   fileField.reset();
   		   showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getCommonTranslation('ATTACHMENT_LIMIT_EXCEEDS')+' '+fileSizeLimit+' MB');
   	   }
       }
	   });
      },

      /**
       * Add value to grid
       */
      loadGridWithFileNameMessage:function(grid,value,store){
   	   grid.bindStore(store);
      },
      /**
       * Remove entry from grid
       */
      deleteFacultyStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
   	   var grid = view.up('#facultystaticdocumentattachmentgridMessage');
   	   var panel = this.getContentPanel().getActiveTab();
   	   var tabTitle = panel.title;
   	   var store = grid.getStore();
   	   var templateConfigDocId = record.get('templateConfigDocId');
   	   var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
   	   if(!(tabTitle == viewTitle)){
   		   if(!isNullOrEmpty(templateConfigDocId)){
   			   showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
   				   if (btn == 'yes') {
   					   Ext.Ajax.request({
   						   type: 'rest',
   						   url: SERVERURL.STATIC_DOC_DELETE,
   						   method: 'DELETE',
   						   params: {
   							   templateConfigDocId : templateConfigDocId
   						   },
   						   headers: {
   							   'Content-Type': 'application/json'
   						   },
   						   success: function(form, action) {
   							   store.remove(record);
   							   showSuccessMessage(getPersonModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
   						   }
   					   });
   				   }
   			   });

   		   }else{
   			   store.remove(record);
   			   showSuccessMessage(getPersonModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
   		   }
   	   }else{
   		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
   	   }

      },
      /**
       * save document file. It's external call method
       * @param entityId : person id, It's mandatory. 
       * @param module : module name, for student module 'student', It's mandatory.
       * @param entityType : entity type, It's mandatory.
       * @param documentType : document type, It's mandatory.
       * @param isTransient : true or false (send json back to module controller or not)
       * @param callBackFunction : callback function return in module controller. It's mandatory.
       */
      saveStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
      	var submitUrl = '';
      	var templateTab = this.getContentPanel();
      	var formWin =  this.getFacultysendmessages();
      	var form = formWin.down('#msgDetailsForm');
      	var id = form.down('#document_hidden_field');
          if (isNullOrEmpty(id.getSubmitValue())) {
              submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
          }
          var data = new Object();
          if(!isNullOrEmpty(entityId)){
          	data.entityId = entityId;
          }else{
          	data.entityId = null;
          }
          if(!isNullOrEmpty(module)){
          	data.module = module;
          }else{
          	data.module = null;
          }
          if(!isNullOrEmpty(entityType)){
          	data.entityType = entityType;
          }else{
          	data.entityType = null;
          }
          form.getForm().setValues(data);
          form.getForm().submit({
          	method : 'POST',
          	url : submitUrl,
          	success : function(form, action){
          		callBackFunction(true, action, isTransient);
          		
          	}
          });
      },
      /**
       * This method is to enable schedule field
       */
      loadFacultyScheduleField : function(radio,newValue, oldValue){
      	var adhocMessageForm = radio.up('form');
      	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
      	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
      	var radioValue = radio.getValue().sendingPriority;
      	
      	if(radioValue=='IMMEDIATE'){
      		scheduleDateField.setVisible(false);
      		scheduleDateField.setDisabled(true);
      		scheduleTimeField.setVisible(false);
      		scheduleTimeField.setDisabled(true);    		
      	}
      	else if(radioValue=='SCHEDULE'){
      		scheduleDateField.setVisible(true);
      		scheduleDateField.setDisabled(false);
      		scheduleTimeField.setVisible(true);
      		scheduleTimeField.setDisabled(false);
      	}
      },
    
    
    /******
     * User whether faculty hide/show functionality by user group
     */
    
    hideOrShowFacultyEmployeeType:function(userGroupName) {
    	//var form = this.getWinUserBasicDetails();
	    var form = this.getFacultyquicksearchview();
    	if(userGroupName == getCommonTranslation('OTHER_EMPLOYEE')){
	    	
	    	form.down('#employeeTypeId').setVisible(true);
	    	form.down('#employeeTypeId').reset();
	    	form.down('#facultyTypeId').setVisible(false);
	    	
	    } else if(userGroupName == getCommonTranslation('FACULTY')) {
	    	
	    	form.down('#facultyTypeId').setVisible(true);
	    	form.down('#facultyTypeId').reset();
	    	form.down('#employeeTypeId').setVisible(false);
	    	
	    } else {
	    	
	    	form.down('#employeeTypeId').setVisible(false);
	    	form.down('#facultyTypeId').setVisible(false);
	    	
	    }
    },
    
    disableImportEmployeeUpdate: function(structure, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        var employeeImportTab = false;
        var employeeBulkDocumentDownloadStatusTab = false;
        
        for (var i = 0; i < permissionList.length; i++) {
            if (permissionList[i] === "IMPORT_BULK_EMPLOYEE_UPDATE") {
                employeeImportTab = true;
            }
            if (permissionList[i] === "BULK_APPLICATION_DOCUMENT_DOWNLOAD") {
            	employeeBulkDocumentDownloadStatusTab = true;
            }
        }

        this.showEmployeeUpdateTab(employeeImportTab,employeeBulkDocumentDownloadStatusTab, structure);
    },

    showEmployeeUpdateTab: function(employeeImportTab,employeeBulkDocumentDownloadStatusTab, structure) {
        var panelItem = new Array();
        var $this = this;
        var newcont = structure.items.items.length;
        var insertPosition = newcont + 1;
        panelItem.push({
        	xtype: 'tabpanel',
        	itemId: 'allVisibleTP',
        	plain: true,
        	style:{overflow:'hidden !important',marginRight:'5px !important',marginLeft:'0px !important',marginTop:'0px !important'},
        	bodyStyle: {
        		margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
        	},
        	frame: false,
        	border: false,
        	defaults: {
        		labelAlign: 'top'
        	},
        	tabbar: {
        		cls: 'SearchTabPanelWithRightTabs',
        		componentCls: 'searchTabComponent'
        	},
        	items: [{
        		xtype: 'facultyquicksearchview',
        		itemId: 'facultyQuickSearch',
        		title: getCommonTranslation('SEARCH'),
        		tabCls: 'right-tab',
            	listeners: {
    				activate: function(me, eOpts){
    					var  contentPanelMain = $this.getContentPanel().getActiveTab();
    					if(!isNullOrEmpty(contentPanelMain)){
    						contentPanelMain.scrollBy(0,1);
    						contentPanelMain.scrollBy(0,-1);
    					}
    				}
    			}
        	}, {
        		xtype: 'advancedsearchquerybuilder',
        		itemId: 'facultyListAdvanceSearch',
        		searchConfigCode: CONSTANTS.CB.FACULTY_LIST_CONFIGCODE,
        		searchResultViewCode: CONSTANTS.CB.FACULTY_LIST_VIEWCODE,
        		permissionMapKey: "FACULTY_LIST_PRIVILEGES",
        		gridTitle: getCommonTranslation("EMPLOYEE_LIST"),
        		tabCls: 'right-tab'
        	}]
        });

        var insertAt = panelItem["0"].items.length;
        var arrayImport = [];
        if (employeeImportTab) {
        /*	panelItem["0"].items[insertAt] = {
        			xtype: 'facultyuploaddownloadstructure',
        			title: getCommonTranslation('IMPORT_EMPLOYEES')

        	};
        	
        	insertAt = insertAt + 1;*/
        	arrayImport.push({
        		name:getCommonTranslation('IMPORT_EMPLOYEES'),
        		value:'facultyuploaddownloadstructure'
        	});
        }
        if (employeeBulkDocumentDownloadStatusTab) {
        	/*panelItem["0"].items[insertAt] = {
        			xtype: 'employeebulkdownloadstatusstructure',
        			itemId: 'employeebulkdownloadstatusstructureId',
        			title: getCommonTranslation('BULK_DOCUMENT_DOWNLOAD_STATUS')

        	};
        	insertAt = insertAt + 1;*/
        	arrayImport.push({
        		name:getCommonTranslation('BULK_DOCUMENT_DOWNLOAD_STATUS'),
        		value:'employeebulkdownloadstatusstructure'
        	});
        }
        if (arrayImport.length){
        	panelItem["0"].items[insertAt] = {
        			xtype: 'employeeImportView',
        			title: getAdmissionTranslation('IMPORT')

        	};
        	insertAt = insertAt + 1;
        }

        structure.insert(insertPosition, panelItem);
        var customImportUserPanelId = structure.down('#customImportEmployeePanelId');
        var reportParantNode = customImportUserPanelId.getStore().tree.root;
        if (reportParantNode.hasChildNodes()) {
     	   reportParantNode.removeAll();
 	   }
        arrayImport.forEach(function(rec){
     	   reportParantNode.appendChild({
 				text: rec.name,
 				reportXtype:  rec.value,
 				reportXtypeItemId: rec.value,
 				leaf: true
 			});
        });
    },
    
    workHourDetailsByCalendar: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    	var this$ = this;
    	var frmWin=this$.getEmployeeworkhourswindow();
    	  if(!frmWin){
   		   Ext.widget('employeeworkhourswindow');
   		   frmWin = this.getEmployeeworkhourswindow();
   		 /* frmWin.setHeight(80);
    	  frmWin.setWidth(780);*/
   	   }
    	  frmWin.show();
    	  
    	  var gridStaffWorkHour = this$.getContentPanel().getActiveTab().down('staffworkhoursgrid');
    	  var record=gridStaffWorkHour.getSelectionModel().getSelection()[0];
    	  //var record=this$.getStaffworkhoursgrid().getSelectionModel().getSelection()[0];
    	  var employeeGrid=this$.getEmployeeworkhourswindow();
    	  var grid=employeeGrid.down('#employeeWorkHourId');
    	  
    	  grid.getStore().getProxy().api.read = SERVERURL.FIND_WORK_HOUR_BY_CALENDAR_ID; //URL - :rest/applicationProgram/findOfferLetterAccepted
    	  this$.resetPageSetting(grid.getStore());
    	  grid.getStore().load({
              params: {
            	  calendarId : record.data.calendarId,
    			  staffId:record.data.staffId
              },
           
    		   callback: function(record, operation, success) {
    			   if (record.length > 0) {
    				   this$.toggleGridSummaryRow(grid,true);
    			   }else{
    				   this$.toggleGridSummaryRow(grid,false);
    			   }
    		   }
    	   
          });          	
    	 
    	  var weekday=frmWin.down('#weekday');
    	  var startTime=frmWin.down('#startTime');
    	  var endTime=frmWin.down('#endTime');
    	  var lateComingAllowedTill=frmWin.down('#lateComingAllowedTill');
    	  var earlyGoingAllowedAfter=frmWin.down('#earlyGoingAllowedAfter');
    	  var totalHours=frmWin.down('#totalHours');
    	  var minHoursOfFullDay=frmWin.down('#minHoursOfFullDay');
    	  var minHoursOfHalfDay=frmWin.down('#minHoursOfHalfDay');
    },
    
  //************* edit Employee Calendar details records********************
    editEmployeeCalendar:function(){
 	   var $this = this;	  
 	   //var grid = $this.getStaffworkhoursgrid();
 	  var grid = $this.getContentPanel().getActiveTab().down('staffworkhoursgrid');
 	   if (grid.getSelectionModel().getCount() > 0) {
 		   var formWindow = $this.getAssignworkcalendarwindow();
 		   if (!formWindow) {
 			   formWindow = Ext.widget('assignworkcalendarwindow',{
 				   itemId:'assignworkcalendarwindowItemId'
 			   });
 			   formWindow = $this.getAssignworkcalendarwindow();
 		   }
 		   formWindow.show();
 		   var form = $this.getAssignworkcalendarwindow();
 		   var record = grid.getSelectionModel().getSelection()[0];
 		   form.down('#startDate').setValue(record.data.startDate);
 		   form.down('#endDate').setValue(record.data.endDate);
 		   var calendarId=form.down('#calendarId').getValue();
 		   var calendarStore = form.down('#calendarId');
 		   form.down('#id').setValue(record.data.id);
 		   form.down('#assignCalendarId').setValue(record.data.calendarId);
 		  // calendarStore.setRawValue(record.data.calendarName);
 		  // calendarStore.setReadOnly(true);
 		  calendarStore.getStore().load({
 			   callback: function(records, operation, success) {
 				   calendarStore.setRawValue(record.data.calendarName);
 				   calendarStore.setReadOnly(true);
 			   }
 		   }); 
 		   form.setTitle(getCommonTranslation('EDIT_EMPLOYEE_CALENDAR'));
 	   }
 	   else{
 		   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
 	   }
    },
    
    /*Save Request Document Generate Student*/
       sendEmployeeBulkDocumentGenerateDetail:function(obj){
       	var $this = this;
       	var grid = $this.getSearchResultGrid();
       	var bulkWin = $this.getBulkdownloaddocumentwin();
       	var bulkWinForm = bulkWin.down('form');
       	
       	var userId = bulkWin.down('#user_name').getValue();
       	var fileNameFormat = bulkWin.down('#fileNameFormat').getValue().fileNameFormat;
       	var folderStructure = bulkWin.down('#folderStructure').getValue().folderStructure;
      
       	var selected = grid.selModel.getSelection();
       	var applicationIdArray = []; 
       	var applicationCodeArray = [];
       	var documentIdCodeArray = [];
       	if( selected.length > 0){
       		for( var i = 0; i < selected.length; i++) {
       			var applicant = new Object();
       			applicant.code = selected[i].data.FACULTY_ID;
       			applicant.value = selected[i].data.FULL_NAME;
       			applicant.id = selected[i].data.PERSON_ID;
    			
       			applicationIdArray.push(applicant);
       		}
       	var documentIds = bulkWin.down('#applicationDocumentsId').getValue();

       	if(documentIds.length > 0) {
       		for( var i = 0; i < documentIds.length; i++) {
       			var document = new Object();
    			document.code = documentIds[i].data.documentName;
    			document.value = documentIds[i].data.documentType;
    			document.id = documentIds[i].data.id;
    			documentIdCodeArray.push(document);	
       		}	
       	}		
       		var formData = {
       			"applicationIds":applicationIdArray,
			    "documentIds":documentIdCodeArray,
       			"fileNameFormate":fileNameFormat,
       			"folderStructureBy":folderStructure,
       			"userId":userId,
       			"requestFor":"EMPLOYEE",
       		};  	        		
       		
       	}
       	submitUrl = SERVERURL.PATH_SAVE_BULK_DOCUMENT_DOWNLOAD;
    		Ext.Ajax.request({
    			type : 'rest',
    			url : submitUrl,
    			jsonData : formData,
    			method : 'POST',
    			success : function(form, action) {
    				//obj.up('window').close();
    			}
    		});
    		obj.up('window').close();
   	     	showSuccessMessage(getCommonTranslation('ENQUIRY_SUCCESS'),getCommonTranslation('BULK_DOCUMENT_DOWNLOAD_REQUEST'));
       },
       
       openMangeAppointmentGrid:function(){
    	   var me = this;
    	   var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    	   var structure = Ext.widget('facultyappointmentstructuretab');
    	   
    	   var tabName = getServiceRequestTranslation('SG_MANAGE_APPOINTMENTS');
    	   /**
    	    * This is to remove tab from content panel and open same tab again
    	    */
    	   var getcontroller=this.getController('menu.CoreERPNavigationController');
    	   var getTab=getcontroller.getTab(tabName);
    	   if(getTab!=null){
    		   contentPanel.remove(getTab, true);
    	   }
    	   openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_EIGHT);
    	   
    	   var empId = structure.down('#appointment_empId');
    	   var empCode = structure.down('#appointment_empCode');
    	   var primaryEmail = structure.down('#appointment_empEmailId');
    	   var mobileNo = structure.down('#appointment_empMobileNo')
    	   var countryCode = structure.down('#appointment_empCountryCode')
    	   var facResultGrid = me.getFacultySearchResultGrid();
    	   if(Ext.isDefined(facResultGrid)){
    		   var gridrecord = facResultGrid.selModel.getSelection(); 
    		   if(gridrecord[0] != null){
    			   empId.setValue(gridrecord[0].data.ID);
    			   empCode.setValue(gridrecord[0].data.FACULTY_ID);
    			   primaryEmail.setValue(gridrecord[0].data.EMAIL_ID);
    			   countryCode.setValue(gridrecord[0].data.MOBILE_COUNTRY_CODE);
    			   var cellNo = gridrecord[0].data.MOBILE_NUMBER;
    			   
    			   var mobileNoData = null;
				   if(!isNullOrEmpty(cellNo)){
					   var mobileNoArray = cellNo.split('-');
					   mobileNoData = mobileNoArray[1];
					   mobileNo.setValue(mobileNoData);
				   }
    		   }    		   
    	   }
       },
       
       /*added for appointment tab on Employee detail*/
       addSGAppointmentEmployeeDetailRecord:function(openView, submitPortal){
    	   var me = this;
    	   var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    	   var structure = Ext.widget('sgappointmentform', {
				itemId : 'facultySGAppointmentFormItemId'
			});
    	   
    	   var tabName = getServiceRequestTranslation('SG_APPOINTMENT');
    	   var manageAppointmentTab = me.getFacultyappointmentstructuretab();
    	   /**
    	    * This is to remove tab from content panel and open same tab again
    	    */
    	   var getcontroller=this.getController('menu.CoreERPNavigationController');
    	   var getTab=getcontroller.getTab(tabName);
    	   if(getTab!=null){
    		   contentPanel.remove(getTab, true);
    	   }
    	   openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);

    	   var visitorCategoryIDCombo =Ext.ComponentQuery.query("#visitorCategoryID")[0];
    	   var visitorCategoryIDComboStore = visitorCategoryIDCombo.getStore();
    	   visitorCategoryIDComboStore.load({
    		   /*callback:function(operation,success) {
       			visitorCategoryIDCombo.setValue(3);
       			var sgForm=me.getSgappointmentform();
       			sgForm.down("#appointeeNameId").setVisible(false);
       			sgForm.down("#leadId").setVisible(true);
       		}*/
    		   callback:function(record){
    			   for(var i in record) {
    				   if(record[i].data.id == 4) {
    					   visitorCategoryIDCombo.setValue(record[i].data.id);
    					   visitorCategoryIDCombo.resetOriginalValue();
    					   visitorCategoryIDCombo.setReadOnly(true);
    					   visitorCategoryIDCombo.setVisible(false);
    					   var sgForm=me.getFacultysgappointmentform();
    					   var facResultGrid = me.getFacultySearchResultGrid();
    					   sgForm.down("#appointeeNameId").setVisible(false);
    					   sgForm.down("#studentItemId").setVisible(false);
    					   sgForm.down("#bookingId").allowBlank=true;
    					   var facCombo = sgForm.down("#facAppointmentId");
    					   facCombo.setVisible(true);
    					   var appointeeNameField=sgForm.down('#appointeeNameId');
    					   var parentGuardian=sgForm.down("#appointeeNameParentId");
    					   var leadNameField=sgForm.down("#leadId");
    					   leadNameField.setVisible(false);
    					   var reasonForVisitID = sgForm.down("#reasonForVisitID");
    					   var visitCatId = record[i].data.id;
     	    			   var reasonForVisitStore=reasonForVisitID.getStore();
     	    			   reasonForVisitStore.getProxy().extraParams = {
     	    				  id : visitCatId,
     	    				};
     	    			   reasonForVisitStore.load();
      					   var studentNameField = sgForm.down("#studentItemId");
    					   var facPortalId = me.getCurrentLoggedPortalId();
    					   var staffInfo = null;
    					   var appointeeEmailField = sgForm.down("#appointeeEmailItemId");
    					   var mobileNoField = sgForm.down("#mobileNo");
    					   var cellCountryCodeField = sgForm.down("#cellCountryCode");
    					   var entryByField = sgForm.down("#entryById");
    					   var entryByNameItem = sgForm.down("#entryByNameItemId");
    					   var applicantCombo = sgForm.down('#applicantNameId');
    					   applicantCombo.setVisible(false);
    					   appointeeEmailField.setReadOnly(true);
    					   mobileNoField.setReadOnly(true);
    					   cellCountryCodeField.setReadOnly(true);
    					   var reasonForVisitIDComboStore = reasonForVisitID.getStore();
    					   /*reasonForVisitIDComboStore.load({
    						   callback:function(record){
    							   reasonForVisitID.setValue(reasonForVisitID.getStore().data.items[0].data.id);
    							   //reasonForVisitID.resetOriginalValue();
    						   }
    					   });*/

    					   appointeeNameField.allowBlank = true;
    					   parentGuardian.allowBlank = true;
    					   leadNameField.allowBlank = true;
    					   studentNameField.allowBlank = true;
    					   applicantCombo.allowBlank = true;
    					   
    					   if(openView == 'ADD'){
    						   var submitPortalData = sgForm.down("#submitPortalId")
    						   submitPortalData.setValue(facPortalId);
    					   }

    					   if(facPortalId == 2){
    						   var staffId = me.getCurrentlyLoggedInUser().id; 
        					   var submitUrl = SERVERURL.SG_PATH_FIND_STAFF_INFO_BY_USERID;
    						   Ext.Ajax.request({
    				    		   type : 'rest',
    				    		   url : submitUrl,
    				    		   params: {
    				    			   userId: staffId,
    				               },
    				    		  /// jsonData : formData,
    				    		   method : 'GET',
    				    		   async: false,
    				    		   success : function(frm, action) {
    				    			   var data = Ext.JSON.decode(frm.responseText);
    				    			   staffInfo = data;
    				    		   }
    				    	   });
    					   }

    					   var facStore = facCombo.getStore();
    					   var cellCountryCodeStore = cellCountryCodeField.getStore();
    					   var countryCode,mobileNo,primaryEmail,selectedRecordId,selectedReordCode;
    					   if(facPortalId == 2){
    						   if(staffInfo != null){
    							   primaryEmail = staffInfo.emailId;
    							   mobileNo = staffInfo.mobileNumber;
    							   countryCode = staffInfo.mobileCountryCode;
    							   selectedRecordId = staffInfo.id;
    							   selectedReordCode = staffInfo.code;

    							   appointeeEmailField.setValue(primaryEmail);
    							   mobileNoField.setValue(mobileNo);
    							   facCombo.setReadOnly(true);
    							   facStore.getProxy().extraParams = {
    								   //academyLocationIds:locations.join(),	//me.getCurrentAcademyLocation(),
    								   codeOrName: selectedReordCode
    							   }; 
    						   }
    						 
    						   
    					   }else{
        					   primaryEmail = manageAppointmentTab.down('#appointment_empEmailId').getValue();
        			    	   mobileNo = manageAppointmentTab.down('#appointment_empMobileNo').getValue();
        			    	   countryCode = manageAppointmentTab.down('#appointment_empCountryCode').getValue()
        					   selectedRecordId = manageAppointmentTab.down('#appointment_empId').getValue();
        					   selectedReordCode = manageAppointmentTab.down('#appointment_empCode').getValue();
        					   
        					   appointeeEmailField.setValue(primaryEmail);
        					   mobileNoField.setValue(mobileNo);
        					   facCombo.setReadOnly(true);
        					   facStore.getProxy().extraParams = {
        						   codeOrName: selectedReordCode
        					   }; 
    					   }
    					   
    					   /*for show hide fuctionality for entry by*/
    					   if(facPortalId == 2){
    						   var entryByNameItem = sgForm.down("#entryByNameItemId");
      						   var entryByItem = sgForm.down("#entryById");
    						   if(submitPortal == 2){
      							   entryByNameItem.setVisible(true);
      							   entryByItem.setVisible(false);
      							   entryByItem.allowBlank = true;
      						   }else{
      							   if(openView == 'ADD'){
      								   entryByNameItem.setVisible(true);
      								   entryByNameItem.setReadOnly(true);
      								   entryByItem.setVisible(false);
      								   entryByItem.allowBlank = true; 
      							   }else{

      								   entryByNameItem.setVisible(false);
      								   entryByNameItem.setReadOnly(true);
      								   entryByItem.setVisible(true);
      								   entryByItem.allowBlank = true; 
      							   }  
      						   }
    					   }else{
      						   var entryByNameItem = sgForm.down("#entryByNameItemId");
      						   var entryByItem = sgForm.down("#entryById");

      						   if(submitPortal == 2){
      							 entryByNameItem.setVisible(true);
	                			 entryByNameItem.setReadOnly(true);
	                			 entryByItem.setVisible(false);
	                			 entryByItem.allowBlank = true;
      						   }else{
          						   entryByNameItem.setVisible(false);
          						   entryByItem.setVisible(true);
          						   entryByItem.allowBlank = true;
      						   }
    					   }
    					   var flagRelatedId = sgForm.down("#flagUserId");
    					   appointeeEmailField.resetOriginalValue();
    					   mobileNoField.resetOriginalValue();
    					   facStore.load({
    						   callback:function(record){
    							   for(var i in record){
    								   if(record[i].data.id == selectedRecordId){
    									   flagRelatedId.getStore().getProxy().extraParams = {
	                                          	   studentId: record[i].data.id
	                							 };
    									   facCombo.setValue(record[i].data.id);
    									   entryByNameItem.setValue(record[i].data.codeValue);
    									   facCombo.resetOriginalValue();
    									   entryByNameItem.resetOriginalValue();
    									   break;
    								   }
    							   }    	    					
    						   }

    					   });
    					   
    					   cellCountryCodeStore.load({
    						   callback:function(record){
    							   for(var i in record){
    								   if(record[i].data.isdCode == countryCode){
    									   cellCountryCodeField.setValue(record[i].data.isdCode);
    									   cellCountryCodeField.resetOriginalValue();
    									   break;
    								   }
    							   }    	    					
    						   }
    					   }); 
    					   var newMandatoryFields = ['facAppointmentId'];
                           Ext.Ajax.request({
   	                		url: SERVERURL.COMMON_FORM_FIELD_INFO,
   	                		method: 'GET',
   	                		async: false,
   	                		params: {
   	                			academyLocationId:me.getCurrentAcademyLocation(),
   	                			languageCode:'en'
   	                		},
   	                		success: function(response) {
   	                			var json = JSON.parse(response.responseText);
   	                			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
   	                			fieldInfo.set("formFieldsInfo", json);
   	                			if( !isNullOrEmpty(json) ){
   	                				if( !isNullOrEmpty(json.sgappointmentform) ){
   	                					var sgappointmentformDFRConfig = json.sgappointmentform;
   	                					for( i in sgappointmentformDFRConfig){
   	                						var fieldConfig = sgappointmentformDFRConfig[i];
   	                						if( newMandatoryFields.includes(fieldConfig.formFieldId) ){
   	                							if( fieldConfig.isVisible ){
   	                								var currentField = sgForm.down("#"+fieldConfig.formFieldId);
   	                								currentField.setVisible(true);
   	                							}else{
   	                								var currentField = sgForm.down("#"+fieldConfig.formFieldId);
   	                								currentField.setVisible(false);
   	                							}
   	                						}
   	                					}
   	                				}
   	                			}
   	                		}
   	                	});
    				   };
    			   }
    		   }
    	   })
       },

       setEntrybyValuebydefault : function() {
       	var userId=this.getCurrentlyLoggedInUser();
       	var sgForm=this.getFacultysgappointmentform();
       	var entryByField = sgForm.down("#entryById");
       	entryByField.store.load({
       		callback : function(operation,success) {
       			if (success) {
       				entryByField.setValue(userId.id);
       			}
       		} 
       	});
       },
       
       setVisitStatusByDefault: function(){
    	   var sgForm=this.getFacultysgappointmentform();
    	   var viewStatusID = sgForm.down("#viewStatusID");
		   var viewStatusIDStore = viewStatusID.getStore();
		   viewStatusID.setReadOnly(true);
		   viewStatusIDStore.load({
			   callback:function(records,operation,success){
				   var rec = viewStatusIDStore.findRecord('code','Booked');
				   if(!isNullOrEmpty(rec)){
					   var idVal = rec.get('id');
					   viewStatusID.setValue(idVal);
				   }
			   }
		   });  
       },
       getDocumentController : function() {
     		var this$ = this;
     		return this$.getController('Academia.controller.document.DocumentController');
     	},
       saveSGAppointmentRecord: function(){
    	   // Create required json to Save
    	   var $this = this;
    	   var sgForm=$this.getFacultysgappointmentform();
    	   var parentStore=sgForm.down("#appointeeNameParentId").getStore();
    	   var sgFormValues=sgForm.getValues();
    	   var submitUrl,isUpdate = false;
    	   var contentPanel = $this.getContentPanel();
    	   var tabName = getServiceRequestTranslation('SG_APPOINTMENT');
    	   //var grid = this.getSgappointmentgrid();
    	   var sgDetailGrid = $this.getSgappointmentfacultydetailgrid();
    	   var getcontroller=$this.getController('menu.CoreERPNavigationController');
    	   var portalId = $this.getCurrentLoggedPortalId();
    	   var submitPortalData = sgForm.down("#submitPortalId").getValue();
    	   var getTab=getcontroller.getTab(tabName);
    	   if (isNullOrEmpty(sgFormValues.id)) {
    		   submitUrl = SERVERURL.SG_APPOINTMENT_SAVE;
    		   isUpdate = false;
    	   } else {
    		   submitUrl =SERVERURL.SG_APPOINTMENT_UPDATE;
    		   isUpdate = true;
    	   }
    	   var visitorCategory={
    			   id:sgFormValues.visitorCategory
    	   };
    	   /*var entryBy={
    			   id:sgFormValues.entryBy
    	   };*/
    	   var appointeeName;
    	   if(sgFormValues.visitorCategory==1){
    		   var str=sgForm.down('#appointeeNameParentId').getRawValue();
			   var appointee=str.split("-");
			   appointeeName=appointee[0];
    	   }else if(sgFormValues.visitorCategory==2){                        		   
    		   var str=sgForm.down('#leadId').getRawValue();
    		   appointeeName=str;
    	   }else if (sgFormValues.visitorCategory == 3) {
               var str = sgForm.down('#studentItemId').getRawValue();
               appointeeName = str;
           }else if(sgFormValues.visitorCategory==4){                        		   
    		   var str=sgForm.down('#facAppointmentId').getRawValue();
    		   appointeeName=str;
    	   }else{
    		   appointeeName=sgFormValues.appointeeName;	                        		  
    	   }
    	   var personId={
    			   id:sgFormValues.appointeeNameParent	   
    	   };
    	   var academyLocationId={
    			   id:this.getCurrentAcademyLocation()
    	   };
    	   var enquiryId={
    			   id:sgFormValues.leadId	   
    	   };
    	   var visitStatusId={
    			   id:sgFormValues.viewStatusID	   
    	   };
    	   var reasonForVisitId={
    			   id:sgFormValues.reasonForVisitID	   
    	   };
    	   var student = {
    			   id : sgFormValues.studentId
    	   };
    	   var staff={
    			   id:sgFormValues.facAppointmentId	   
    	   };
    	   var appointmentFormData=new Academia.model.sgappointment.sgappointment.SGAppointmentModel();
    	   var chkRescheduleAppointment = sgForm.getForm().findField('isRescheduleAppointment');
    	   if(chkRescheduleAppointment.getValue()){
    		   appointmentFormData.set("isRescheduleAppointment",chkRescheduleAppointment.getValue());
    		   appointmentFormData.set("rescheduleDate",sgFormValues.rescheduleDate);
    		   if(!isNullOrEmpty(sgFormValues.rescheduleTime)){
    			   appointmentFormData.set("rescheduleTime",sgFormValues.rescheduleTime); 
    		   }else{
    			   delete appointmentFormData.data.rescheduleTime;
    		   }
    	   }
    	   appointmentFormData.set("id",sgFormValues.id);
    	   appointmentFormData.set("visitorCategory",visitorCategory);
    	   appointmentFormData.set("bookingId",sgFormValues.bookingId);
    	   appointmentFormData.set("appointeeName",appointeeName);
    	   appointmentFormData.set("academyLocation",academyLocationId);
    	   appointmentFormData.set("flagUserId",sgFormValues.flagUserId);
    	   appointmentFormData.set("isRelatedToFlag",sgFormValues.isRelatedToFlag);
    	   
    	   var enqIntermediateStage = sgForm.getForm().findField('enqIntermediateStage');
    	   if( !isNullOrEmpty(enqIntermediateStage.getValue()) ){
    		   var enqIntermediateStage={
    				   id:enqIntermediateStage.getValue()  
    		   };
    		   appointmentFormData.set("enqIntermediateType",enqIntermediateStage);
    	   }else{
    	   appointmentFormData.set("enqIntermediateType",null); 
    	   }
    	   delete appointmentFormData.data.enqIntermediateStage;
      	   if(isNullOrEmpty(appointmentFormData.data.enqIntermediateType)) {
      		 delete appointmentFormData.data.enqIntermediateType;
      	   }
    	   var countryCode=sgFormValues.mobileCountryCode;
    	   var mobileNo=sgFormValues.appointeeContactNo;
    	   var mobileNoWithCode;
    	   if(isNullOrEmpty(countryCode) && isNullOrEmpty(mobileNo) ){
    		   mobileNoWithCode=null;
    	   }else{
    		   mobileNoWithCode=countryCode +'-'+ mobileNo;
    	   }
    	   
    	   /*change for entry by*/ 
    	   var entryBy;
    	   if(submitPortalData == 1){
    		   if(isNullOrEmpty(sgFormValues.entryBy)){
    			   var userId=this.getCurrentlyLoggedInUser();
    			   entryBy = {
    					   id: userId.id
    			   };
    		   } else{
    			   entryBy = {
    					   id: sgFormValues.entryBy
    			   };
    		   }
    	   }
    	   if(submitPortalData == 2){
    		   entryBy = {
    				   id: this.getCurrentlyLoggedInUser().id
    		   }
    	   }
    	   appointmentFormData.set("appointeeContactNo",mobileNoWithCode);
    	   appointmentFormData.set("bookingDate",sgFormValues.bookingDate);
    	   appointmentFormData.set("appointmentDate",sgFormValues.appointmentDate);
    	   appointmentFormData.set("appointeeEmailId",sgFormValues.appointeeEmailId);
    	   var persontoMeetValue=sgForm.getForm().findField('personToMeet').getRawValue();
    	   appointmentFormData.set("personToMeet",persontoMeetValue);
    	   appointmentFormData.set("isAppointeeAppointment",sgFormValues.isAppointee);
    	   appointmentFormData.set("visitTime",sgFormValues.visitTime);
    	   appointmentFormData.set("expectedOutTime",sgFormValues.expectedOutTime);
    	   appointmentFormData.set("reasonToVisit",sgFormValues.reasonToVisit);
    	   appointmentFormData.set("entryBy",entryBy);
    	   appointmentFormData.set("additionalReasonToVisit",sgFormValues.additionalReasonToVisit);
    	   
    	   appointmentFormData.set("submitPortalId", submitPortalData);
    	   if(!isNullOrEmpty(visitStatusId.id)){
    		   appointmentFormData.set("sgVisitStatus",visitStatusId);   
    	   }else{
    		   appointmentFormData.set("sgVisitStatus",null); 
    	   }
    	   if(!isNullOrEmpty(reasonForVisitId.id)){
    		   appointmentFormData.set("sgReasonForVisit",reasonForVisitId);   
    	   }else{
    		   appointmentFormData.set("sgReasonForVisit",null); 
    	   }	                        	   
    	   appointmentFormData.set("customData",sgFormValues.customData);
 			  	  
    	   if(sgFormValues.visitorCategory==1){//base category
    		   appointmentFormData.set("person",personId);
    		   delete appointmentFormData.data.enquiry;
    		   delete appointmentFormData.data.staff;
    		   delete appointmentFormData.data.student;
    		   delete appointmentFormData.data.application;
    	   }else if(sgFormValues.visitorCategory==2){
    		   appointmentFormData.set("enquiry",enquiryId);
    		   delete appointmentFormData.data.person;
    		   delete appointmentFormData.data.staff;
    		   delete appointmentFormData.data.student;
    		   delete appointmentFormData.data.application;
    	   } else if (sgFormValues.visitorCategory == 3) {
               appointmentFormData.set("student", student);
               delete appointmentFormData.data.person;
               delete appointmentFormData.data.enquiry;
               delete appointmentFormData.data.staff;
               delete appointmentFormData.data.application;
           }else if(sgFormValues.visitorCategory==4){
    		   appointmentFormData.set("staff",staff);
    		   delete appointmentFormData.data.person;
    		   delete appointmentFormData.data.enquiry;
    		   delete appointmentFormData.data.student;
    		   delete appointmentFormData.data.application;
    		    delete appointmentFormData.data.program;
    		    delete appointmentFormData.data.batch;
    		    delete appointmentFormData.data.progBatchSeatConfig;
    	   }else{
    		   delete appointmentFormData.data.person;
    		   delete appointmentFormData.data.enquiry;
    		   delete appointmentFormData.data.staff;
    		   delete appointmentFormData.data.student;
    		   delete appointmentFormData.data.application;
    	   }

    	   if(Ext.isDefined(appointmentFormData.data.entryByName)){
    		   delete appointmentFormData.data.entryByName;
    	   }
    	   if(Ext.isDefined(appointmentFormData.data.personToMeetId)){
    		   delete appointmentFormData.data.personToMeetId;
    	   }
    	 /*  var formData = Ext.encode(appointmentFormData.data);
    	   Ext.getBody().mask();
    	   Ext.Ajax.request({
    		   type : 'rest',
    		   url : submitUrl,
    		   jsonData : formData,
    		   method : 'POST',
    		   success : function(frm, action) {
    			   Ext.getBody().unmask();
    			   sgForm.getForm().reset();
    			   if (isUpdate) {
    				   showSuccessMessage(getServiceRequestTranslation('SG_UPDATE_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_UPDATED_SUCCESSFULLY'));
    				   if(getTab!=null){
    					   contentPanel.remove(getTab, true);
    				   }
    				   if(sgDetailGrid!=undefined){
    					   sgDetailGrid.getStore().load();
    					   sgDetailGrid.getSelectionModel().deselectAll();
    				   }

    			   }else{
    				   showSuccessMessage(getServiceRequestTranslation('SG_ADD_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_CREATED_SUCCESSFULLY'));
    				   if(getTab!=null){
    					   contentPanel.remove(getTab, true);
    				   }
    				   if(sgDetailGrid!=undefined){
    					   sgDetailGrid.getStore().load();
    					   sgDetailGrid.getSelectionModel().deselectAll();
    					   
    				   }


    			   }
    		   }
    	   }); */
    	   /////////////////////////////////////////////////
    	   var data = new Object();

           data.entityId = null;
           data.module = 'SGAPPOINTMENT';
           data.entityType = 'DOCUMENT';
           var uplaodUrl = SERVERURL.DOCUMENT_FILE_ADD;
           var imageField=sgForm.down('#documentUploadFile');
           if(!isNullOrEmpty(imageField.getValue())){
	           sgForm.getForm().submit({
	               method: 'POST',
	               async:false,
	               url: uplaodUrl,
	               success: function(form1, action) {
	                   var responseData = Ext.decode(action.response.responseText);
	                   var path = responseData.path;
	
	                   var formData = new Object();
	                   formData.type ='NEW_DOCUMENT';
	                   formData.name = path;
	                     formData.documentName=path;
	               
	
	                   $this.getDocumentController().saveDocumentFormValue(false, 'NEW_DOCUMENT', false, formData, path, function(success, response, isCallBackTransient){
	                       if(success){
	                           var documentId = Ext.decode(response.responseText);
	                           var saveJson = new Object();
	                           var document = new Object();
	                           document.id = documentId;
	                           appointmentFormData.set("documentId",documentId);
	                           
	                           var formData = Ext.encode(appointmentFormData.data);
	                           Ext.getBody().mask();
	                           Ext.Ajax.request({
	                        	   type: 'rest',
	                        	   url: submitUrl,
	                        	   jsonData: formData,
	                        	   method: 'POST',
	                        	   success: function(frm, action) {
	                        		   Ext.getBody().unmask();
	                        		   sgForm.getForm().reset();
	                        		   if (isUpdate) {
	                        			   showSuccessMessage(getServiceRequestTranslation('SG_UPDATE_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_UPDATED_SUCCESSFULLY'));
	                        			   if (getTab != null) {
	                        				   contentPanel.remove(getTab, true);
	                        			   }
	                        			   if (sgDetailGrid != undefined) {
	                        				   sgDetailGrid.getStore().reload();
	                        				   sgDetailGrid.getSelectionModel().deselectAll();
	                        			   } else if (sgDetailGrid != undefined) {
	                        				   sgDetailGrid.getStore().load();
	                        				   sgDetailGrid.getSelectionModel().deselectAll();
	                        			   }
	                        		   } else {
	                        			   showSuccessMessage(getServiceRequestTranslation('SG_ADD_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_CREATED_SUCCESSFULLY'));
	                        			   if (getTab != null) {
	                        				   contentPanel.remove(getTab, true);
	                        			   }
	                        			   if (sgDetailGrid != undefined) {
	                        				   sgDetailGrid.getStore().load();
	                        				   sgDetailGrid.getSelectionModel().deselectAll();
	                        			   }
	                        		   }
	                        	   }
	                           });
	                       }
	                   });
	               }
	           });
           } else {
        	   var formData = Ext.encode(appointmentFormData.data);
        	   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
               Ext.Ajax.request({
                   type: 'rest',
                   url: submitUrl,
                   jsonData: formData,
                   method: 'POST',
                   success: function(frm, action) {
                       Ext.getBody().unmask();
                       sgForm.getForm().reset();
                       if (isUpdate) {
                           showSuccessMessage(getServiceRequestTranslation('SG_UPDATE_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_UPDATED_SUCCESSFULLY'));
                           if (getTab != null) {
                               contentPanel.remove(getTab, true);
                           }
                           if (sgDetailGrid != undefined) {
                           	sgDetailGrid.getStore().reload();
                           	sgDetailGrid.getSelectionModel().deselectAll();
                           } else if (sgDetailGrid != undefined) {
                               sgDetailGrid.getStore().load();
                               sgDetailGrid.getSelectionModel().deselectAll();
                           }
                       } else {
                           showSuccessMessage(getServiceRequestTranslation('SG_ADD_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_CREATED_SUCCESSFULLY'));
                           if (getTab != null) {
                               contentPanel.remove(getTab, true);
                           }
                           if (sgDetailGrid != undefined) {
                           	sgDetailGrid.getStore().load();
                           	sgDetailGrid.getSelectionModel().deselectAll();
                           }
                           
                       }
                   }
               });
           }
       },
       
       editAppointmentFacultyRecord:function(){

    	   var $this=this;
    	   var grid = $this.getSgappointmentfacultydetailgrid();
    	   if (grid.getSelectionModel().getCount() > 0) {
    		   var record=grid.getSelectionModel().getSelection()[0];
    		   var submitPortalRecord = record.data.submitPortalId;
    		   this.addSGAppointmentEmployeeDetailRecord('EDIT',submitPortalRecord);
    		   var sgForm=this.getFacultysgappointmentform();
    		   var portalId = $this.getCurrentLoggedPortalId();
    		   var dataModel=new Academia.model.sgappointment.sgappointment.SGAppointmentModel(record.data);
    		   sgForm.loadRecord(dataModel);
    		   if(!isNullOrEmpty(record.raw.document) && !isNullOrEmpty(record.raw.document.path) && record.raw.document.path!='file'){
                   sgForm.down("#pathId").documentId = record.raw.document.encryptedDocId;
                   sgForm.down("#pathId").setValue('<a href="#">' + record.raw.document.path + '</a>');
                   }else{
                     sgForm.down("#pathId").documentId = null;
                      sgForm.down("#pathId").setValue(null);
                  }

    		   sgForm.down("#visitTimeId").setValue(timeRender(record.data.visitTime));
    		   sgForm.down("#outTimeId").setValue(timeRender(record.data.expectedOutTime));
    		   sgForm.down("#bookingDateId").setValue(dateRender(record.data.bookingDate));
    		   sgForm.down("#appointmentId").setValue(dateRender(record.data.appointmentDate));
    		   sgForm.down("#bookingId").setReadOnly(true);
    		   sgForm.down("#flagUserId").getStore().getProxy().extraParams={
	      			 studentId:record.data.userId
	      		 }
    		  		 sgForm.down("#flagUserId").getStore().load({
    	      				 callback:function(rec){
    	      					 sgForm.down("#flagUserId").setValue(record.data.flagUserId);
    	      				 }
    	      			 });
    		   var isAppointeeItemId =  sgForm.down("#isAppointeeItemId");
       		   isAppointeeItemId.setValue({isAppointee:record.data.isAppointeeAppointment});
       		 /*  Ext.defer(function(){
       			 sgForm.down("#flagRelated").setValue(record.data.visitTime);
       		   },500)*/
    		   
    		  /* for entry by hide and show*/
    		   if(!isNullOrEmpty(submitPortalRecord)){
    			   sgForm.down("#submitPortalId").setValue(submitPortalRecord);
    		   }else{
    			   sgForm.down("#submitPortalId").setValue(1);
    		   }
    		   var visitorCategory=sgForm.down("#visitorCategoryID");
    		   if(record.data.visitorCategory != null){
    			   visitorCategory.store.load({
    				   callback : function(records,operation,success) {
    					   if (success) {
    						   visitorCategory.setValue(record.data.visitorCategory.id);
    					   }
    				   }
    			   });
    		   }
    		   var entryByField = sgForm.down("#entryById");
    		   if(portalId == 2){
    			   entryByField.setReadOnly(true);  
    		   }else{
    			   entryByField.setReadOnly(false);   
    		   }
    		   //entryByField.setReadOnly(true);
    		   /*for entry by hide and show*/
    		   var entryByNameItem = sgForm.down("#entryByNameItemId");
    		   if(record.data.submitPortalId == 2){
    			   entryByNameItem.setVisible(true);
    			   entryByNameItem.setReadOnly(true);
    			   entryByField.setVisible(false);
    			   entryByField.allowBlank = true;
    			   entryByNameItem.setValue(record.data.appointeeName);
    		   }else{
    			   entryByNameItem.setVisible(false);
    			   // entryByNameItem.setReadOnly(false);
    			   entryByField.setVisible(true);
    			   entryByField.allowBlank = true;
    			   
    			   if(record.data.entryBy != null){
    				   entryByField.store.getProxy().extraParam = {
    					   academyLocationIds:this.getCurrentAcademyLocation()
    				   }
    				   entryByField.store.load({
    					   callback : function(records,operation,success) {
    						   if (success) {
    							   entryByField.setValue(record.data.entryBy.id);
    						   }
    					   }
    				   });
    			   }
    		   }
    		   
    		   var personToMeetId = sgForm.down("#personToMeetId");
    		   if(record.data.personToMeet != null){
    			   personToMeetId.store.getProxy().extraParam = {
    				   academyLocationIds:this.getCurrentAcademyLocation()
    			   }
    			   personToMeetId.store.load({
    				   callback : function(records,operation,success) {
    					   if (success) {
    						   //personToMeetId.setRawValue(record.data.personToMeet);
    						   if(!isNullOrEmpty(record.data.personToMeetId)){
    							   personToMeetId.setValue(record.data.personToMeetId.id);
    						   }
    					   }
    				   }
    			   });
    		   }
    		   var appointeeNameField=sgForm.getForm().findField('appointeeName');
    		   var leadNameField=sgForm.down("#leadId");
    		   var parentGuardian=sgForm.down("#appointeeNameParentId");
    		   var empNameField = sgForm.down('#facAppointmentId');
    		   var studentNameField = sgForm.down('#studentItemId');
    		   if(record.data.visitorCategory.id == 1){
    			   leadNameField.allowBlank = true;
    			   parentGuardian.store.load({
    				   callback : function(records,operation,success) {
    					   if (success) {
    						   parentGuardian.setValue(record.data.person.id);
    					   }
    				   }
    			   });
    			   parentGuardian.setVisible(true);
    			   appointeeNameField.setVisible(false);
    			   appointeeNameField.allowBlank = true;
    		   }/*else if(record.data.visitorCategory.id == 2){
    			   leadNameField.store.load({
    				   callback : function(records,operation,success) {
    					   if (success) {
    						   leadNameField.setValue(record.data.enquiry.id);
    					   }
    				   }
    			   });
    			   leadNameField.setVisible(true);
    			   leadNameField.setReadOnly(true);
    			   appointeeNameField.setVisible(false);
    			   appointeeNameField.allowBlank = true;
    			   parentGuardian.setVisible(false);
    			   parentGuardian.allowBlank = true;
    			   visitorCategory.setReadOnly(true);
    		   }*/else if(record.data.visitorCategory.id == 3){
    			   studentNameField.store.load({
    				   callback : function(records,operation,success) {
    					   if (success) {
    						   studentNameField.setValue(record.data.student.id);
    					   }
    				   }
    			   });
    			   studentNameField.setVisible(true);
    			   studentNameField.allowBlank = false;
    			   studentNameField.setReadOnly(true);
    			   leadNameField.setVisible(false);
    			   leadNameField.setReadOnly(true);
    			   leadNameField.allowBlank = true;
    			   appointeeNameField.setVisible(false);
    			   appointeeNameField.allowBlank = true;
    			   parentGuardian.setVisible(false);
    			   parentGuardian.allowBlank = true;
    			   visitorCategory.setReadOnly(true);
    			   empNameField.setVisible(false);
    			   empNameField.setReadOnly(true);
    			   empNameField.allowBlank = true;
    		   }else if(record.data.visitorCategory.id == 4){
    			   /*empNameField.getStore().load({
    				   callback : function(records,operation,success) {
    					   if (success) {
    						   empNameField.setValue(record.data.enquiry.id);
    					   }
    				   }
    			   });*/
    			   empNameField.setVisible(true);
    			   empNameField.setReadOnly(true);
    			   leadNameField.setVisible(false);
    			   leadNameField.setReadOnly(false);
    			   leadNameField.allowBlank = true;
    			   appointeeNameField.setVisible(false);
    			   appointeeNameField.allowBlank = true;
    			   parentGuardian.setVisible(false);
    			   parentGuardian.allowBlank = true;
    			   visitorCategory.setReadOnly(true);
    		   }else{
    			   parentGuardian.allowBlank = true;
    			   leadNameField.allowBlank = true;
    			   empNameField.allowBlank = true;
    			   visitorCategory.setReadOnly(false);
    		   }

    		   var mobileField = sgForm.down("#mobileNo");
    		   var countryCodeField=sgForm.down("#cellCountryCode");
    		   var str=record.data.appointeeContactNo;
    		   var spiltMobileNo;
    		   if(str!=null){
    			   spiltMobileNo =str.split("-");
    		   }
    		   if(record.data.appointeeContactNo != null){
    			   if(spiltMobileNo.length == 2){
    				   countryCodeField.setValue(spiltMobileNo[0]);
    				   mobileField.setValue(spiltMobileNo[1]);
    			   }
    		   }

    		   /*added for visit status and reason to visit*/
    		   var visitStatusCombo=sgForm.down("#viewStatusID");
    		   var reasonForVisitCombo=sgForm.down("#reasonForVisitID");

    		   if(record.data.sgReasonForVisit != null){
    			   var userGroupName = record.data.sgReasonForVisit.code;
	        	this.enableOrDisableAdditionalReasonFaculty(userGroupName);
   			 
    			   reasonForVisitCombo.store.load({
    				   callback : function(records,operation,success) {
    					   if (success) {
    						   reasonForVisitCombo.setValue(record.data.sgReasonForVisit.id);
    					   }
    				   }
    			   });
    		   }

    		   if(record.data.sgVisitStatus != null){
    			   visitStatusCombo.store.load({
    				   callback : function(records,operation,success) {
    					   if (success) {
    						   visitStatusCombo.setValue(record.data.sgVisitStatus.id);
    					   }
    				   }
    			   });
    		   }

    		   sgForm.down('#resetBtnForm').setVisible(false);
    		   var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
    		   var rescheduleAppointmentTimeId = sgForm.down('#rescheduleAppointmentTimeId');
    		   this.setAllowBlank(rescheduleAppointmentDateId,true);
    		   if(!isNullOrEmpty(record.data.sgVisitStatus) && record.data.sgVisitStatus.code == "Completed"){
    			   sgForm.down('#submitBtn').setVisible(false);
    			   //var viewStatusID = sgForm.down('#viewStatusID');
    			   sgForm = sgForm.getForm();
    			   //viewStatusID.setReadOnly(true);
    			   toggleReadOnlyFormItems(sgForm, true);
    		   }
    		   else if(!isNullOrEmpty(record.data.sgVisitStatus) && record.data.sgVisitStatus.code == "Rescheduled"){
    			   var dateTimeRescheduleAppointmentItemId = sgForm.down('#dateTimeRescheduleAppointmentItemId');
    			   var rescheduleAppointmentFld = sgForm.down('#rescheduleAppointmentFld');
    			   if(!isNullOrEmpty(record.data.isRescheduleAppointment) && record.data.isRescheduleAppointment){
    				   dateTimeRescheduleAppointmentItemId.setVisible(true);
    				   var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
    				   rescheduleAppointmentDateId.setValue(dateRender(record.data.rescheduleDate));
    				   if(!isNullOrEmpty(record.data.rescheduleTime)){
    					   sgForm.down("#rescheduleAppointmentTimeId").setValue(timeRender(record.data.rescheduleTime));
    				   }
    			   }
    			   else{
    				   dateTimeRescheduleAppointmentItemId.setVisible(false);
    				   rescheduleAppointmentDateId.reset();
    				   rescheduleAppointmentTimeId.reset();
    			   }
    			   rescheduleAppointmentFld.setVisible(true);
    		   }
    		   else{
    			   rescheduleAppointmentDateId.reset();
    			   rescheduleAppointmentTimeId.reset();
    		   }
    		   
    		   var enqIntermediateStage = sgForm.down("#enqIntermediateStage");
    		   // var enqIntermediateStage = sgForm.getForm().findField('enqIntermediateStage');
    		   if (record.data.enqIntermediateType != null) {
    			   enqIntermediateStage.store.load({
    				   callback: function(records, operation, success) {
    					   if (success) {
    						   enqIntermediateStage.setValue(record.data.enqIntermediateType.id);
    					   }
    				   }
    			   });
    		   }

    	   }else {
    		   showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
    	   }
       },

       viewFacultySGAppointmentDetailRecord:function(){
    	   var $this=this;
    	   $this.editAppointmentFacultyRecord();
    	   var sgForm=$this.getFacultysgappointmentform();
    	   var grid = $this.getSgappointmentfacultydetailgrid();
    	   sgForm.down('#submitBtn').setVisible(false);
    	   sgForm.down('#resetBtnForm').setVisible(false);
    	   sgForm = sgForm.getForm();
    	   toggleReadOnlyFormItems(sgForm, true);
    	   //$this.resetPageSetting(grid.getStore());
		   grid.getStore().reload();
    	   
       },

       deleteFacultySGAppointmentDetailRecord:function(){
    	   var $this=this;
    	   var grid = $this.getSgappointmentfacultydetailgrid();
    	   if (grid.getSelectionModel().getCount() > 0) {
    		   showConfirmMessage(getServiceRequestTranslation('SG_APPOINTMENT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
    			   if (btn == 'yes') {
    				   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				   var records = grid.getSelectionModel().getSelection();
    				   var id = records[0].get("id");
    				   Ext.Ajax.request({
    					   method : "DELETE",
    					   type : 'rest',
    					   url : SERVERURL.SG_APPOINTMENT_DELETE+'?id='+ id,
    					   headers : {
    						   'Content-Type' : 'application/json'
    					   },
    					   success : function(form,action) {
    						   Ext.getBody().unmask();
    						   showSuccessMessage(getServiceRequestTranslation('SG_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_DELETE_SUCCESS_MSG'));
    						   $this.resetPageSetting(grid.getStore());
    						   grid.getStore().reload();
    					   }

    				   });
    			   }
    		   });
    	   }else {
    		   showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
    	   }
       },
       
       openViewCalendarFacultyWin:function(){
    	   var $this =this;
    	  /* var formWindow = $this.getScheduledetails();
    	   if (!formWindow) {
    		   Ext.widget('scheduledetails');
    		   formWindow = $this.getScheduledetails();
    	   }
    	   formWindow.show();*/
    	   var contentpanel = this.getContentPanel();
    	   var scheduledetails = Ext.widget('scheduledetails');
    	   var tabName = getServiceRequestTranslation('VIEW_CALENDAR');

    	   /**
    	    * This is to remove tab from content panel and open same tab again
    	    */
    	   var getcontroller=this.getController('menu.CoreERPNavigationController');
    	   var getTab=getcontroller.getTab(tabName);
    	   if(getTab!=null){
    		   contentPanel.remove(getTab, true);
    	   }
    	   openTab(contentpanel, tabName, scheduledetails,CONSTANTS.MENU_COLOR_THREE);	
    	   var sgForm=$this.getFacultysgappointmentform();
    	   //var personToMeetId=sgForm.down("#personToMeetId").getValue();
    	   var id=sgForm.down("#id").getValue();
    	   var personToMeetId;
    	   var appointmentDateId=sgForm.down("#appointmentId").getValue();
    	   if(isNullOrEmpty(id)){
         	   personToMeetId=sgForm.down("#personToMeetId").getStore().data.items[0].data.id;
    	   }else{
    		  var facultyName= sgForm.down("#personToMeetId").getValue();
    		  var records=sgForm.down("#personToMeetId").getStore().data.items;
    		  for(var i in sgForm.down("#personToMeetId").getStore().data.items){
					 if(records[i].data.value==facultyName){
						 personToMeetId=records[i].data.id;
					 }
				 }
    	   }
    	  
    	   var personProfile = this.getContentPanelActiveTab();
           var calendar = personProfile.down('#personViewCalendar');
           var params = new Object();
           calendar.eventStore.getProxy().actionMethods.read = 'GET';
           params.facultyId = personToMeetId;
           calendar.eventStore.removeAll();
           calendar.eventStore.getProxy().url = SERVERURL.RESOURCE_BOOKING_GET_FACULTY_CALENDAR_DATA;
           calendar.eventStore.getProxy().extraParams = params;
           calendar.eventStore.load();
       },
       
       sendCalendarEventsFacultyRequest: function(personId, calenderItemId, submitURL) {
    	   var this$ = this;
    	   var sgForm=this$.getFacultysgappointmentform();
    	   if (!isNullOrEmpty(sgForm) && Ext.isDefined(sgForm)) {
    	   var id=sgForm.down("#id").getValue();
    	   var personToMeetId = null;
    	   var appointmentDateId=sgForm.down("#appointmentId").getValue();
    	   if(isNullOrEmpty(id)){
    		   personToMeetId=sgForm.down("#personToMeetId").getStore().data.items[0].data.id;
    	   }else{
    		   var facultyName= sgForm.down("#personToMeetId").getValue();
    		   var records=sgForm.down("#personToMeetId").getStore().data.items;
    		   for(var i in sgForm.down("#personToMeetId").getStore().data.items){
    			   if(records[i].data.value==facultyName){
    				   personToMeetId=records[i].data.id;
    			   }
    		   }
    	   }
    	   var personProfile = this.getContentPanelActiveTab();
    	   var calendar = personProfile.down(calenderItemId);
    	   var params = new Object();
    	   calendar.eventStore.getProxy().actionMethods.read = 'GET';
    	   params.facultyId = personToMeetId;
    	   calendar.eventStore.removeAll();
    	   calendar.eventStore.getProxy().url = submitURL;
    	   calendar.eventStore.getProxy().extraParams = params;
    	   calendar.eventStore.load();
    	  }
    	   
       },
       resetFacultySGAppointment:function(form){
    	   var bookingId = form.down('#bookingId');
    	   var vistrCategory = form.down('#visitorCategoryID');

    	   /*  var leadNameField=form.down("#leadId");
    	   var parentGuardian=form.down("#appointeeNameParentId");
    	   var empNameField = form.down('#facAppointmentId');
    	   var studentNameField=form.down("#studentItemId");*/

    	   var mobileField = form.down("#mobileNo");
    	   var countryCodeField=form.down("#cellCountryCode");
    	   var appointeeEmailItemId=form.down("#appointeeEmailItemId");
    	   var submitPortalId=form.down("#submitPortalId");

    	   if(vistrCategory.getValue() == 4){
    		   mobileField.resetOriginalValue();
    		   appointeeEmailItemId.resetOriginalValue();
    		   countryCodeField.resetOriginalValue();
    		   submitPortalId.resetOriginalValue();
    	   }
    	   form.getForm().reset();
       },
       loadPanellinkForEmployee: function(tabPanel, employeeLinkPanelObject) {
    	   var this$ = this;
    	   var persondetailslinkpanel = tabPanel.down('persondetailslinkpanel');
    	   var personType = persondetailslinkpanel.personType;
    	   var permissionMap = this$.buildLinkDetailsMapObj(tabPanel, employeeLinkPanelObject, 'PERSONAL_INFORMATION', personType);
    	   var i=permissionMap.length-1;
    	   var p = employeeLinkPanelObject.PERSONAL_INFORMATION;
    	   while(i>=0) {
    		   links = p[i];
    		   var detailsLink = persondetailslinkpanel.down('#PERSONAL_INFORMATION');
    		   this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, employeeLinkPanelObject);
    		   i--;
    	   }

    	   permissionMap = this$.buildLinkDetailsMapObj(tabPanel, employeeLinkPanelObject, 'PAST_HISTORY', personType);
    	   i=permissionMap.length-1;
    	   p = employeeLinkPanelObject.PAST_HISTORY;
    	   while(i>=0) {
    		   links = p[i];
    		   var detailsLink = persondetailslinkpanel.down('#PAST_HISTORY');
    		   if(links != undefined){
    			   this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, employeeLinkPanelObject);
    		   }
    		   i--;
    	   }

    	   permissionMap = this$.buildLinkDetailsMapObj(tabPanel, employeeLinkPanelObject, 'COURSE_EXECUTION', personType);
    	   i=permissionMap.length-1;
    	   p = employeeLinkPanelObject.COURSE_EXECUTION;
    	   if(personType == 'OTHER_EMPLOYEE'){
    		   p.splice(5, 1);
        	   p.splice(3, 1);
        	   p.splice(0, 1);
    	   }
    	   while(i>=0) {
    		   links = p[i];
    		   var detailsLink = persondetailslinkpanel.down('#COURSE_EXECUTION');
    		   var mapVal = permissionMap.get(links.tabPanelTitle);
    		   if(!isNullOrEmpty(mapVal)){
    			   this$.hideLinksByprivileges(detailsLink,mapVal, i, employeeLinkPanelObject);   
    		   }
    		   i--;
    	   }
    	   
    	   permissionMap = this$.buildLinkDetailsMapObj(tabPanel, employeeLinkPanelObject, 'SERVICES_COMMUNITIES', personType);
    	   i=permissionMap.length-1;
    	   p = employeeLinkPanelObject.SERVICES_COMMUNITIES;
    	   while(i>=0) {
    		   links = p[i];
    		   var detailsLink = persondetailslinkpanel.down('#SERVICES_COMMUNITIES');
    		   this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, employeeLinkPanelObject);
    		   i--;
    	   }
    	   
    	   permissionMap = this$.buildLinkDetailsMapObj(tabPanel, employeeLinkPanelObject, 'REQUESTS', personType);
    	   i=permissionMap.length-1;
    	   p = employeeLinkPanelObject.REQUESTS;
    	   if(personType == 'OTHER_EMPLOYEE'){
    		   p.splice(3, 1);
    		   p.splice(1, 1);
    	   }
    	   while(i>=0) {
    		   links = p[i];
    		   var detailsLink = persondetailslinkpanel.down('#REQUESTS');
    		   var mapVal = permissionMap.get(links.tabPanelTitle);
    		   if(!isNullOrEmpty(mapVal)){
    			   this$.hideLinksByprivileges(detailsLink,mapVal, i, employeeLinkPanelObject);   
    		   }
    		   i--;
    	   }

    	   permissionMap = this$.buildLinkDetailsMapObj(tabPanel, employeeLinkPanelObject, 'PAYMENT_REFUND_HISTORY', personType);
    	   i=permissionMap.length-1;
    	   p = employeeLinkPanelObject.PAYMENT_REFUND_HISTORY;
    	   while(i>=0) {
    		   links = p[i];
    		   var detailsLink = persondetailslinkpanel.down('#PAYMENT_REFUND_HISTORY');
    		   this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, employeeLinkPanelObject);
    		   i--;
    	   }
    	   
    	   permissionMap = this$.buildLinkDetailsMapObj(tabPanel, employeeLinkPanelObject, 'HR_PROFILE', personType);
    	   i=permissionMap.length-1;
    	   p = employeeLinkPanelObject.HR_PROFILE;
    	   while(i>=0) {
    		   links = p[i];
    		   var detailsLink = persondetailslinkpanel.down('#HR_PROFILE');
    		   this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, employeeLinkPanelObject);
    		   i--;
    	   }

    	   permissionMap = this$.buildLinkDetailsMapObj(tabPanel, employeeLinkPanelObject, 'DISCIPLINARY_ACTIVITY', personType);
    	   i=permissionMap.length-1;
    	   p = employeeLinkPanelObject.DISCIPLINARY_ACTIVITY;
    	   while(i>=0) {
    		   links = p[i];
    		   var detailsLink = persondetailslinkpanel.down('#DISCIPLINARY_ACTIVITY');
    		   this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, employeeLinkPanelObject);
    		   i--;
    	   }

    	   permissionMap = this$.buildLinkDetailsMapObj(tabPanel, employeeLinkPanelObject, 'DOCUMENT_HISTORY', personType);
    	   i=permissionMap.length-1;
    	   p = employeeLinkPanelObject.DOCUMENT_HISTORY;
    	   while(i>=0) {
    		   links = p[i];
    		   var detailsLink = persondetailslinkpanel.down('#DOCUMENT_HISTORY');
    		   this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, employeeLinkPanelObject);
    		   i--;
    	   }
    	    permissionMap = this$.buildLinkDetailsMapObj(tabPanel, employeeLinkPanelObject, 'LIBRARY_DETAILS');
    	   		i=permissionMap.length-1;
    	   p = employeeLinkPanelObject.LIBRARY_DETAILS;
    	   			while(i>=0) {
    	   					links = p[i];
    	   					var detailsLink = persondetailslinkpanel.down('#LIBRARY_DETAILS');
    	   			this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, employeeLinkPanelObject);
    	   				i--;
    	   }
       },
       hideLinksByprivileges: function(detailsLink, privilegesMap, i, employeeLinkPanelObject) {
	    	var associatedAcadLocationIds = new Array();
	    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);
			var store = detailsLink.items.items[0].getStore();
			var flag = true;
			Ext.each(permissionList, function(privilege) {
	    		if (privilege == 'VIEW') {
	    			 flag=false;
	        	}
	    	});
			
			if(flag){
				var rec = store.getAt(i);
				if (rec) {
					store.remove(rec);
				}
			}
			if(store.getCount() == 0){
				detailsLink.setVisible(false);
			}
			return flag;
	    },
	    buildLinkDetailsMapObj: function(tabPanel, employeeLinkPanelObject, linkPanelId, personType) {
	    	var persondetailslinkpanel = tabPanel.down('persondetailslinkpanel');
	    	var facultyPersonalController  = this.getController('Academia.controller.personinfo.faculty.FacultyPersonalController');
	    	var facultyPastHistoryController  = this.getController('Academia.controller.personinfo.faculty.FacultyPastHistoryController');
	    	var facultyCourseExecutionController  = this.getController('Academia.controller.personinfo.faculty.FacultyCourseExecutionController');
	    	var biometricmachineintegrationcontroller =  this.getController('Academia.controller.hrm.BiometricMachineIntegrationController');
	    	var facultyServiceController = this.getController('Academia.controller.personinfo.faculty.FacultyServiceController');
	    	var facultyRequestController  = this.getController('Academia.controller.personinfo.faculty.FacultyRequestActionController');
	    	var facultyPaymentController = this.getController('Academia.controller.personinfo.faculty.FacultyPaymentRefundController');
	    	var facultyDisiplinaryController = this.getController('Academia.controller.personinfo.faculty.FacultyDisciplinaryController');
	    	var facultyDocumentController = this.getController('Academia.controller.personinfo.faculty.FacultyDocumentController');
	    	var facultyExaminationDutyChartController = this.getController('Academia.controller.examinationcenters.dutychart.ExaminationDutyChartController');
	    	var sgstudentlibraryissuedbooktransactioncontroller =  this.getController('Academia.controller.kohaLibraryTransalation.SGStudentLibraryIssuedBookTransactionController');
	    	
	    	var permissionMap = new Ext.util.HashMap();
	    	var portalId = this.getCurrentLoggedPortalId();
	    	var arrayVar = new Array();
	    	if(linkPanelId=='PERSONAL_INFORMATION') {
	    		permissionMap.add('PERSONAL_DETAILS',facultyPersonalController.getEMPLOYEE_PROFILE_PERSONAL_INFORMATION_PERMISSION());
    			permissionMap.add('ADDRESSES',facultyPersonalController.getEMPLOYEE_PROFILE_ADDRESS_PERMISSION());
    			permissionMap.add('FAMILY_DETAILS',facultyPersonalController.getEMPLOYEE_PROFILE_FAMILY_DETAILS_PERMISSION());
    			permissionMap.add('IDENTITY_DETAILS',facultyPersonalController.getFACULTY_IDENTITY_CARD_PERMISSION());
    			permissionMap.add('OTHER_INFORMATION',facultyPersonalController.getFACULTY_OTHER_DETAILS_PERMISSION());
    			permissionMap.add('SSO_DETAILS', facultyPersonalController.getFACULTY_SSO_DETAILS_PERMISSION());
                permissionMap.add('EMPLOYEES_ADDITIONAL_DETAILS', facultyPersonalController.getFACULTY_EMP_ADDITIONAL_DETAILS_PERMISSION());
	    	} 
	    	else if(linkPanelId=='PAST_HISTORY') {
	    		permissionMap.add('EDUCATION',facultyPastHistoryController.getFACULTY_PROFILE_EDUCATION_PERMISSIONS());
    			permissionMap.add('WORK_EXPERIENCE',facultyPastHistoryController.getFACULTY_PROFILE_WORK_EXPERIENCE_PERMISSIONS());
    			permissionMap.add('MEDICAL_HISTORY',facultyPastHistoryController.getFACULTY_PROFILE_MEDICAL_PERMISSIONS());
    			permissionMap.add('VACCINATION',facultyPastHistoryController.getFACULTY_PROFILE_VACCINATION_PERMISSIONS());
    			permissionMap.add('EXTRA_CURRICULUM',facultyPastHistoryController.getFACULTY_PROFILE_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS());
    			permissionMap.add('RESEARCH_TYPE',facultyPastHistoryController.getFACULTY_PROFILE_RESEARCH_DETAILS_PERMISSIONS());
    			permissionMap.add('SEMINAR_DETAILS',facultyPastHistoryController.getFACULTY_PROFILE_SEMINAR_DETAILS_PERMISSIONS());
    			permissionMap.add('INSURANCE_HISTORY',facultyPastHistoryController.getFACULTY_PROFILE_INSURANCE_HISTORY_PERMISSIONS());
    			permissionMap.add('PHYSICAL_CHARACTERISTICS',facultyPastHistoryController.getFACULTY_PHYSICAL_CHARACTERISTICS_PERMISSIONS());
    			permissionMap.add('PATENT_DETAILS',facultyPastHistoryController.getFACULTY_PROFILE_PATENT_DETAILS_PERMISSIONS());
    			permissionMap.add('TRAINING_DETAILS',facultyPastHistoryController.getFACULTY_PROFILE_TRAINING_PERMISSIONS());
    			permissionMap.add('HOSTEL_DETAILS',facultyPastHistoryController.getFACULTY_PROFILE_HOSTEL_DETAILS_PERMISSIONS());
    			permissionMap.add('TRANSPORT_DETAILS',facultyPastHistoryController.getFACULTY_PROFILE_TRANSPORT_DETAILS_PERMISSIONS());
    			permissionMap.add('COMPETITIVE_EXAM',facultyPastHistoryController.getFACULTY_PROFILE_COMPETITIVE_EXAM_PERMISSIONS());
    			permissionMap.add('CHURCH_INFORMATION_DETAILS',facultyPastHistoryController.getFACULTY_PROFILE_CHURCH_INFORMATION_PERMISSIONS());
    			permissionMap.add('FACULTY_NON_ACADEMIC_ACHIEVEMENTS',facultyPastHistoryController.getFACULTY_PROFILE_NON_ACADEMIC_ACHIEVEMENTS_PERMISSIONS());
    			permissionMap.add('COMMUNICATION_HISTORY',this.getFACULTY_PROFILE_COMMUNICATION_HISTORY_PERMISSIONS());
    			permissionMap.add('REFERENCES',facultyPastHistoryController.getFACULTY_PROFILE_EMPLOYEE_REFERENCES_PERMISSIONS());
    			permissionMap.add('QUALIFICATION_DETAILS',facultyPastHistoryController.getFACULTY_QUALIFICATION_DETAILS_PERMISSIONS());
    			
	    	} 
	    	else if(linkPanelId=='COURSE_EXECUTION') {
	    		if(personType != 'OTHER_EMPLOYEE'){
	    			permissionMap.add('SCHEDULE',facultyCourseExecutionController.getFACULTY_PROFILE_SCHEDULE_PERMISSIONS());
		    		permissionMap.add('ATTENDANCE',facultyCourseExecutionController.getFACULTY_PROFILE_ATTENDANCE_PERMISSIONS());
		    		permissionMap.add('BIOMETRIC_MACHINE_DETAILS',biometricmachineintegrationcontroller.getEMPLOYEE_BM_DETAILS_PERMISSIONS());
		    		permissionMap.add('PROGRAM_COURSES',facultyCourseExecutionController.getFACULTY_PROFILE_PROGRAM_COURSE_PERMISSIONS());
		    		permissionMap.add('DEVELOPMENT_PLAN',facultyCourseExecutionController.getFACULTY_DEVELOPMENT_GOAL_PERMISSIONS());
		    		permissionMap.add('COURSE_INTERESTS',facultyCourseExecutionController.getFACULTY_COURSE_INTEREST_PERMISSIONS());
		    		permissionMap.add('FACULTY_EXAMINATION_DUTY',facultyExaminationDutyChartController.getFACULTY_PROFILE_EXAMINATION_DUTY_PERMISSIONS());
	    		} else{
		    		permissionMap.add('ATTENDANCE',facultyCourseExecutionController.getFACULTY_PROFILE_ATTENDANCE_PERMISSIONS());
		    		permissionMap.add('BIOMETRIC_MACHINE_DETAILS',biometricmachineintegrationcontroller.getEMPLOYEE_BM_DETAILS_PERMISSIONS());
		    		permissionMap.add('DEVELOPMENT_PLAN',facultyCourseExecutionController.getFACULTY_DEVELOPMENT_GOAL_PERMISSIONS());
		    		permissionMap.add('FACULTY_EXAMINATION_DUTY',facultyExaminationDutyChartController.getFACULTY_PROFILE_EXAMINATION_DUTY_PERMISSIONS());
	    		}
	    	} 
	    	else if(linkPanelId=='SERVICES_COMMUNITIES') {
	    		permissionMap.add('SERVICES_HISTORY',facultyServiceController.getFACULTY_PROFILE_SERVICES_HISTORY_PERMISSIONS());
    			permissionMap.add('SERVICE_OPT_IN_OUT',facultyServiceController.getFACULTY_PROFILE_SERVICE_OPT_PERMISSIONS());
    			permissionMap.add('COMMUNITIES_HISTORY',facultyServiceController.getFACULTY_PROFILE_COMMUNITIES_HISTORY_PERMISSIONS());
    			permissionMap.add('COMMUNITIES_OPT_IN_OUT',facultyServiceController.getFACULTY_PROFILE_COMMUNITIES_OPT_PERMISSIONS());
	    	} 
	    	else if(linkPanelId=='REQUESTS') {
	    		if(personType != 'OTHER_EMPLOYEE'){
	    			permissionMap.add('REQUEST_RAISED_HISTORY',facultyRequestController.getFACULTY_PROFILE_REQUEST_RAISED_HISTORY_PERMISSIONS());
		    		permissionMap.add('REQUEST_EXECUTED_HISTORY',facultyRequestController.getFACULTY_PROFILE_REQUEST_EXECUTED_HISTORY_PERMISSIONS());
		    		permissionMap.add('REQUEST_PENDING_DESCISION',facultyRequestController.getFACULTY_PROFILE_REQUEST_PENDING_DESCISION_PERMISSIONS());
		    		permissionMap.add('REQUEST_PENDING_ACTION',facultyRequestController.getFACULTY_PROFILE_REQUEST_PENDING_ACTION_PERMISSIONS());
	    		} else{
	    			permissionMap.add('REQUEST_RAISED_HISTORY',facultyRequestController.getFACULTY_PROFILE_REQUEST_RAISED_HISTORY_PERMISSIONS());
	    			permissionMap.add('REQUEST_PENDING_DESCISION',facultyRequestController.getFACULTY_PROFILE_REQUEST_PENDING_DESCISION_PERMISSIONS());
	    		}
	    	} 
	    	else if(linkPanelId=='PAYMENT_REFUND_HISTORY') {
	    		permissionMap.add('BILLS',facultyPaymentController.getFACULTY_PROFILE_PENDING_BILLS_PERMISSIONS());
    			permissionMap.add('RECEIPTS',facultyPaymentController.getFACULTY_PROFILE_PAYMENT_RECIEVED_PERMISSIONS());
    			permissionMap.add('PAYMENT_MADE_HISTORY',facultyPaymentController.getFACULTY_PROFILE_PAYMENT_MADE_HISTORY_PERMISSIONS());
    			permissionMap.add('POST_DATED_CHEQUES',facultyPaymentController.getFACULTY_PROFILE_POST_DATED_CHEQUES_PERMISSIONS());
	    	} 
	    	else if(linkPanelId=='HR_PROFILE') {
	    		permissionMap.add('WORK_HOURS',this.getFACULTY_WORK_HOURS_PERMISSIONS());
	    	} 
	    	else if(linkPanelId=='DISCIPLINARY_ACTIVITY') {
	    		permissionMap.add('DISCIPLINARY_ACTIONS',facultyDisiplinaryController.getFACULTY_PROFILE_DISCIPLINARY_ACTIONS_PERMISSIONS());
    			permissionMap.add('POSITIVE_INCIDENTS',facultyDisiplinaryController.getFACULTY_PROFILE_POSITIVE_INCIDENTS_PERMISSIONS());
	    	} 
	    	else if(linkPanelId=='DOCUMENT_HISTORY') {
	    		permissionMap.add('DOC_ONLINE_DOCUMENTS', facultyDocumentController.getFACULTY_ONLINE_DOCUMENTS_PERMISSIONS());
	    		permissionMap.add('DOC_PHYSICAL_DOCUMENTS', facultyDocumentController.getFACULTY_PHYSICAL_DOCUMENTS_PERMISSIONS());
	    	}  else if(linkPanelId == 'LIBRARY_DETAILS'){
	    		 var portalId = this.getCurrentLoggedPortalId();
				 if (portalId == 2 || portalId == 1) {
					 permissionMap.add('CURRENTLY_ISSUED_EMPLOYEE_BOOKS', sgstudentlibraryissuedbooktransactioncontroller.getCORE_ERP_BOOK_ISSUED_EMPLOYEE_HISTORY());
					 permissionMap.add('LIBRARY_CIRCULATION_EMPLOYEE_HISTORY', sgstudentlibraryissuedbooktransactioncontroller.getCORE_ERP_BOOK_CIRCULATION_EMPLOYEE_HISTORY());
					 permissionMap.add('LIBRARY_RESERVED_EMPLOYEE_HISTORY', sgstudentlibraryissuedbooktransactioncontroller.getCORE_ERP_BOOK_RESERVED_EMPLOYEE_HISTORY());
					 permissionMap.add('LIBRARY_FEE_DETATILS_EMPLOYEE_HISTORY', sgstudentlibraryissuedbooktransactioncontroller.getCORE_ERP_LIBRARY_DUE_EMPLOYEE_FEES());
				 }
	    	} 
	    	return permissionMap;
	    },
		openSendMessageReportLink: function(record){
			var id = record.get('msgRcpntLogId');
			if(!isNullOrEmpty(id)){
				Ext.Ajax.request({
					type: 'rest',
					url: SERVERURL.PATH_FIND_MSG_CONTENT_BY_MSG_RCPNTLOG_ID,													 
					method: 'GET',
					async: false,
					headers: {
						'Content-Type': 'application/json'
					},
					params: {
						id: id
					},
					success: function(response, form, action) {
						responseObject = eval("(" + response.responseText + ")"); //make object of response text
						var msgContent = responseObject.msgContent;

						var win = new Ext.Window({
							title: getMessagingModuleTranslation('MESSAGE_CONTENT'),
							frame: true,
							height : 500,
							minWidth:200,
							autoScroll:true,
							modal:true,
							html: msgContent,
						});
						win.show();

					},
					failure: function(form, action) {
						//showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
					}
				});
			}
		},
		openAttachedDocumentLink: function(record){
			var $this = this;
			var id = record.get('msgRcpntLogId');
			if(!isNullOrEmpty(id)){
				var isWhetherSysMsgEvent = false;
				var eventName = record.get('eventName');
				if(!isNullOrEmpty(eventName)){
					isWhetherSysMsgEvent = true;
				}

				var formWindow = $this.getSendmessageattacheddocumentwin();
				if (!formWindow) {
					formWindow = Ext.widget('sendmessageattacheddocumentwin',{
	        			itemId:'facultysendmessageattacheddocumentwin'
	        		});
					}
				formWindow.show();
				var documentGrid = formWindow.down('#sendMessageDocumentGridItemId');
				documentGrid.getStore().getProxy().extraParams = {
					id: id,
					whetherSysMsgEvent:isWhetherSysMsgEvent
				};
				documentGrid.getStore().load();
			}
		},
		downloadAttachedDocumentFile : function(documentId,isWhetherSysMsgEvent){
	    	if(!isNullOrEmpty(documentId)){
	    		var csvForm = Ext.create('Ext.form.Panel'); 
		    	csvForm.getForm().submit({
			    	target: '_blank',
			    	method:'GET',
			    	params :{
			    		access_token : Ext.Ajax.defaultHeaders.access_token,
			    		id: documentId,
						whetherSysMsgEvent:isWhetherSysMsgEvent
			    	},
			    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
			    	url: SERVERURL.PATH_DOWNLOAD_MSG_DOCUMENTS,
			    	standardSubmit :true
		    	});
	    	}
	    },
	    facultyCheckSelectDate:function(){
	    	//var form = this.getCommunicationhistorystructure();
			//var grid =  this.getCommunicationhistorylist();
	    	 var personProfile = this.getContentPanelActiveTab();
			var form = personProfile.down('communicationhistorystructure');
	    	var grid = personProfile.down('communicationhistorylist');
			
			var eventDateForm=form.down("#eventDateForm").getValue();
			var eventDateTill=form.down("#eventDateTill").getValue();
			var exportReport=grid.down("#exportMessageSentReportItemId");
			if(!isNullOrEmpty(eventDateForm) && !isNullOrEmpty(eventDateTill))
				exportReport.setDisabled(false);
			else
				exportReport.setDisabled(true);
	    },
	    loadOtherFieldsOnChangeAcademyLocation:function(obj,record){
	    	var $this = this;
	    	var form = $this.getFacultyQuickSearchForm();
	    	var department= form.down('#cmbDepartment');
	    	var committee= form.down('#committeeItemId');
	    	var emp = form.down('#facultyCodeItemId');
	    	department.reset();
	    	committee.reset();
	    	emp.reset();
	    	if(obj.hidden!=true){
	    		var alids=[];
	    		if(record.length>0){
	    			for (var i in record) {
	    				if(Ext.isObject(record[i])){
	    					alids.push(record[i].get('id'));
	    				}
	    				else{
	    					alids.push(record[i]);	
	    				}
	    			}
	    		}else{
	    			alids = $this.getCurrentAcademyLocation();
	    		}  
	    	}else{
	    		alids = $this.getCurrentAcademyLocation(); 
	    	}
	    	if(isArray(alids)){
	    		alidsValue =  alids.join(); 
	    	}else{
	    		alidsValue = alids;
	    	}
	    	var departmentStore = department.getStore();
	    	departmentStore.getProxy().extraParams = {
	    		academyLocationList: alidsValue
	    	};
	    	departmentStore.load();

	    	var committeeStore = committee.getStore();
	    	committeeStore.getProxy().extraParams = {
	    		academyLocationIds: alidsValue,
	    		name:'%%%'
	    	};
	    	committeeStore.load();

	    	var empStore = emp.getStore();
	    	empStore.getProxy().extraParams = {
	    		academyLocationIds: alidsValue,
	    		nameOrCode:'%%%'
	    	};
	    	empStore.load();
	    },
	    exportXlsMsgSentReport : function() {
			var $this = this;
	    	var form = $this.getCommunicationhistorystructure();
	    	var grid =  this.getCommunicationhistorylist();
	    	form=form.down('form');
			var values = form.getValues();
			var dt = new Date();
	    	var dateString = Ext.Date.format(dt, 'YmdHis'); 
			var reportTitle = "Message Sent Report"+"_"+dateString;
			var code = 'MESSAGE_SENT_EXCEL_EXPORT_REPORT';
			var reportHeader = "Message Sent Report";
		
			
			
			var sendMessage = form.down("#sendmessageId").getValue();
			//console.log(sendMessage);
			var recipient=form.down("#recipientName").getValue();
			var contactId=null;
			var sentbyName=form.down("#sentby").getValue();
			var eventNameCode=form.down("#eventName").getValue();
			var eventDateForm=form.down("#eventDateForm").getValue();
			var eventDateTill=form.down("#eventDateTill").getValue();
			var messageId=form.down("#sendmessageId").getValue();
			//var status=form.down("#statusComboMsgSendReport").getValue();
			if(messageId.sendMessage==1){
				contactId=form.down("#contactId").getValue();
			}else{
				contactId=form.down("#mobileId").getValue();
			}
			if(recipient!=null){
			if(grid.getSelectionModel()!=null){
				recipient=	grid.getSelectionModel().getStore().data.items[0].raw.recipientFullName
			}
			}
		
			var reportParams = new Object();
			reportParams.fromDate = eventDateForm;
			reportParams.toDate = eventDateTill;
			reportParams.contactList = contactId;
			reportParams.sentBy = sentbyName;
			reportParams.eventName=eventNameCode;
			reportParams.recipientName=recipient;
			reportParams.deliveryModeId=sendMessage.sendMessage;
			reportParams.headerName = reportHeader;
			reportParams.status = status;
			$this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.MSG_SENT_EXCEL_REPORT);
		},
		enableOrDisableAdditionalReasonFaculty:function(userGroupName) {
           	
     	   var form = this.getActiveTabfromContentPanel().down('sgappointmentform');
     	   
        	if(userGroupName == 'Other'){
    	    	
    	    	form.down('#additionalReasonToVisitItemId').setDisabled(false);
    	    	form.down('#additionalReasonToVisitItemId').allowBlank = false;
    	    } 
        	else{ form.down('#additionalReasonToVisitItemId').setDisabled(true);
	    	form.down('#additionalReasonToVisitItemId').allowBlank = true;
	    	form.down('#additionalReasonToVisitItemId').reset();
        	}
        		
        	
        	var valid = form.isValid();
        	if(!valid) {
        		form.down('#submitBtn').setDisabled(true);
        	}
        },
        getOpenEmployeeReportStructure:function(treePanel, record, item,index){
    		var $this = this;
			var containpanel = $this.getEmployeeImportStructure();
			var treePanel = containpanel.down('#customImportEmployeePanelId');
			var tabDetail = record.data;
			var structure = Ext.widget(tabDetail.reportXtype);
			var tabstructure = containpanel.down('#employeeImportTabpanelIds');

			if (!isNullOrEmpty(tabDetail.text)
					&& !isNullOrEmpty(tabDetail.reportXtype)
					&& !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
				treePanel.toggleCollapse();
				openTab(tabstructure, tabDetail.text,structure);
				treePanel.getSelectionModel().deselectAll();
			}
    	}
});
