/*
 * This controller is used for faculty service information actions.   
 */
Ext.define('Academia.controller.personinfo.faculty.FacultyServiceController', {
    extend: 'Academia.controller.personinfo.common.PersonServiceController',

    alias: "widget.facultyservicecontroller",

    refs: [{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'serviceOptForm',
        selector: 'serviceoptform[itemId=facultyServiceOptForm]'

    }, {
        ref: 'communityOptForm',
        selector: 'communityoptform[itemId=facultyCommunityOptForm]'

    }],
    config: {
    	FACULTY_SERVICES_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_SERVICES_HISTORY_PRIVILEGES'),
    	FACULTY_SERVICE_OPT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_SERVICE_OPT_PRIVILEGES'),
    	FACULTY_COMMUNITIES_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_COMMUNITIES_HISTORY_PRIVILEGES'),
    	FACULTY_COMMUNITIES_OPT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_COMMUNITIES_OPT_PRIVILEGES'),
    	FACULTY_PROFILE_SERVICES_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_SERVICES_HISTORY_PRIVILEGES'),
    	FACULTY_PROFILE_SERVICE_OPT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_SERVICE_OPT_PRIVILEGES'),
    	FACULTY_PROFILE_COMMUNITIES_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_COMMUNITIES_HISTORY_PRIVILEGES'),
    	FACULTY_PROFILE_COMMUNITIES_OPT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_COMMUNITIES_OPT_PRIVILEGES')
    },
    init: function(application) {
        this.control({
        	
        	
        	'communityoptgrid[itemId=facultyCommunityHistoryGrid]': {
                render: function(grid) {                	                	
            		this.loadGridStore('#facultyCommunityHistoryGrid', SERVERURL.PERSON_COMMUNITY_HISTORY_GRIDDATA);
            		grid.setTitle(getPersonModuleTranslation('COMMUNITY_HISTORY'));
                    grid.down('#btnAdd').hide();
                    grid.down('#btnEdit').hide();
                    grid.down('#btnDelete').hide();
                    var portalId = this.getCurrentLoggedPortalId();
                    if(portalId == 1){
                    	this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_COMMUNITIES_HISTORY_PERMISSIONS());
                    }
                    else if(portalId == 2){
                    	this.doAccessControlValidation(grid, this.getFACULTY_COMMUNITIES_HISTORY_PERMISSIONS());
                    }
                }
            },
            'communityoptgrid[itemId=facultyCommunityHistoryGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewCommunityOptFormWindow('COMMUNITIES', 'facultyCommunityOptForm', '#facultyCommunityHistoryGrid',getPersonModuleTranslation('COMMUNITY_HISTORY'));
                }
            },
            'communityoptform[itemId=facultyCommunityOptForm] button[itemId=communityOptCancelButtonId]': {
                click: function(){
                	this.closePersonCommonWindow();
                } 
            },
        	        	
        	/**
        	 * Communities Opt In/ Opt Out Details
        	 */
            
            'communityoptgrid[itemId=facultyCommunityOptGrid]': {
                render: function(grid) {                	                	
            		this.loadGridStore('#facultyCommunityOptGrid', SERVERURL.PERSON_COMMUNITY_OPT_GRIDDATA);
            		var portalId = this.getCurrentLoggedPortalId();
                    if(portalId == 1){
                    	this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_COMMUNITIES_OPT_PERMISSIONS());
                    }
                    else if(portalId == 2){
                    	this.doAccessControlValidation(grid, this.getFACULTY_COMMUNITIES_OPT_PERMISSIONS());
                    }
                }
            },
            'communityoptform[itemId=facultyCommunityOptForm]': {
                afterrender: function(form) {                	                	
            		if(form){
            			var optOutRadioBtn=form.down("#optOutRadioBtn");
            			optOutRadioBtn.setDisabled(true);
            			
            			var facultyProfileView = this.getActiveTabfromContentPanel();
            			var storeComm = form.down('[name=community]').getStore();
            			storeComm.getProxy().setExtraParam('userId',facultyProfileView.getUserId());
            			//optOutRadioBtn.setVisible(false);
            		}
                }
            },
            'communityoptgrid[itemId=facultyCommunityOptGrid] button[itemId=btnAdd]': {
                click:function(){
                	this.showPersonCommonWindow('COMMUNITIES', 'facultyCommunityOptForm');
                }             	
            },
            'communityoptgrid[itemId=facultyCommunityOptGrid] button[itemId=btnEdit]': {
                click: function(){                	
                	this.editCommunityOptFormWindow('COMMUNITIES', 'facultyCommunityOptForm', '#facultyCommunityOptGrid',getPersonModuleTranslation('COMMUNITY_OPT_IN_OUT'));                	                	
                }
            },
            'communityoptgrid[itemId=facultyCommunityOptGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewCommunityOptFormWindow('COMMUNITIES', 'facultyCommunityOptForm', '#facultyCommunityOptGrid',getPersonModuleTranslation('COMMUNITY_OPT_IN_OUT'));
                }
            },
            'communityoptgrid[itemId=facultyCommunityOptGrid] button[itemId=btnDelete]': {
                click: function(){                	            		                 	 
                    this.deleteCommunityOptRecord('#facultyCommunityOptGrid', SERVERURL.COMMUNITY_OPT_DELETE);
                } 
            },
            'communityoptform[itemId=facultyCommunityOptForm] button[itemId=submitButtonId]': {
                click:function(){
                	this.saveCommunityOpt('#facultyCommunityOptGrid', SERVERURL.COMMUNITY_OPT_ADD, SERVERURL.COMMUNITY_OPT_UPDATE);
                } 
            },
            'communityoptform[itemId=facultyCommunityOptForm] button[itemId=communityOptCancelButtonId]': {
                click: function(){
                	this.closePersonCommonWindow();
                } 
            },
            
            
            'serviceoptgrid[itemId=facultyServiceHistoryGrid]': {
                render: function(grid) {                	                	
            		this.loadGridStore('#facultyServiceHistoryGrid', SERVERURL.PERSON_SERVICE_HISTORY_GRIDDATA);
            		grid.setTitle(getPersonModuleTranslation('SERVICE_HISTORY'));
            		grid.down('#btnAdd').hide();
                    grid.down('#btnEdit').hide();
                    grid.down('#btnDelete').hide();
                    var portalId = this.getCurrentLoggedPortalId();
                    if(portalId == 1){
                    	this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_SERVICES_HISTORY_PERMISSIONS());
                    }
                    else if(portalId == 2){
                    	this.doAccessControlValidation(grid, this.getFACULTY_SERVICES_HISTORY_PERMISSIONS());
                    }
                },
                afterrender : function(grid){
                if(this.getCurrentLoggedPortalId() == 2){
                    grid.columns[4].hide();
                    }
                }
            },
            'serviceoptgrid[itemId=facultyServiceHistoryGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewServiceOptFormWindow('SERVICES_OPT_IN_OUT', 'facultyServiceOptForm', '#facultyServiceHistoryGrid',getPersonModuleTranslation('SERVICES_OPT_IN_OUT'));
                }
            },
            'serviceoptform[itemId=facultyServiceOptForm] button[itemId=cancelButtonId]': {
                click: function(){
                	this.closePersonCommonWindow();
                } 
            },
            	
        	/**
             *  Service Opt In/ Opt Out
             */

            'serviceoptgrid[itemId=facultyServiceOptGrid]': {
            	render: function(grid) {
                	this.loadGridStore('#facultyServiceOptGrid', SERVERURL.PERSON_SERVICE_OPT_GRIDDATA);
                	var portalId = this.getCurrentLoggedPortalId();
                    if(portalId == 1){
                    	this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_SERVICE_OPT_PERMISSIONS());
                    }
                    else if(portalId == 2){
                    	this.doAccessControlValidation(grid, this.getFACULTY_SERVICE_OPT_PERMISSIONS());
                    }
            	},
                afterrender : function(grid) {
                	if(this.getCurrentLoggedPortalId() == 2){
                		grid.columns[4].hide();
                	}
                	var gridColumns;
                    if (!isNullOrEmpty(grid)) {
                        gridColumns = grid.columns;
                    }
                    for (i in gridColumns) {
                        var gridColumn = gridColumns[i];
                        if (gridColumn.dataIndex == "amountToBePaid") {
                            gridColumn.hide();
                        } else if (gridColumn.dataIndex == "feePlan") {
                            gridColumn.hide();
                        }
                    }
                }
            },
            'serviceoptform[itemId=facultyServiceOptForm]': {
            	afterrender: function(form) {                	                	
            		if(form){
            			/*var optOutRadioBtn=form.down("#optOutRadioBtn");
            			optOutRadioBtn.setDisabled(true);*/
            			//optOutRadioBtn.setVisible(false);
            			/**
            			 * Type of service its is "FACULTY".
            			 */
            			var billedUserTypeHiddenField=form.down("#billedUserTypeHiddenField");
            			billedUserTypeHiddenField.setValue("FACULTY");
            			/**
            			 * Hide fields in the case of faculty service opt in and opt out.
            			 */
            			form.down("#feePlanComboField").disable();
            			form.down("#feePlanComboField").setVisible(false);
            			form.down("#feePlanComboField").allowBlank=false;
            			
            			form.down("#feePlanRuleComboField").disable();
            			form.down("#feePlanRuleComboField").setVisible(false);
            			form.down("#feePlanRuleComboField").allowBlank=false;
            			
            			form.down("#feePlanRuleStageComboField").disable();
            			form.down("#feePlanRuleStageComboField").setVisible(false);
            			form.down("#feePlanRuleStageComboField").allowBlank=false;
            			
            			form.down("#amountPaidComboField").disable();
            			form.down("#amountPaidComboField").setVisible(false);
            			form.down("#amountPaidComboField").allowBlank=false;
            		}
                }
            },
            'serviceoptgrid[itemId=facultyServiceOptGrid] button[itemId=btnAdd]': {
                click:function(){
                	this.showPersonCommonWindow('SERVICES_OPT_IN_OUT', 'facultyServiceOptForm');
                }	
            },
            'serviceoptgrid[itemId=facultyServiceOptGrid] button[itemId=btnEdit]': {
                click: function(){
                	this.editServiceOptFormWindow('SERVICES_OPT_IN_OUT', 'facultyServiceOptForm', '#facultyServiceOptGrid',getPersonModuleTranslation('SERVICES_OPT_IN_OUT'));                	
                }
            },
            'serviceoptgrid[itemId=facultyServiceOptGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewServiceOptFormWindow('SERVICES_OPT_IN_OUT', 'facultyServiceOptForm', '#facultyServiceOptGrid',getPersonModuleTranslation('SERVICES_OPT_IN_OUT'));
                }
            },
            'serviceoptgrid[itemId=facultyServiceOptGrid] button[itemId=btnDelete]': {
            	click:function(){            		        		 
                    this.deleteServiceOptRecord('#facultyServiceOptGrid', SERVERURL.SERVICE_HISTORY_DELETE);
                } 
            },
            'serviceoptform[itemId=facultyServiceOptForm] combo[itemId=serviceNameComboField]': {
                render: function(combo){
                	this.loadServiceOptNameOnProgramBatchSeatType(combo,'FACULTY');
                } 
            },
            'serviceoptform[itemId=facultyServiceOptForm] button[itemId=submitButtonId]': {
            	click:function(){            		 
            		this.saveServiceOpt('#facultyServiceOptGrid', SERVERURL.SERVICE_OPT_ADD, SERVERURL.SERVICE_OPT_UPDATE);
                } 
            },
            /**
             * This functionality is not required.
             */
           /* 'serviceoptform[itemId=facultyServiceOptForm] nestedJsonCombo[itemId=serviceNameComboField]': {
                change: function(combo, record, index){
                	this.getFeePlanForSelectedService(combo, SERVERURL.GET_FEE_PLAN_ON_SELECTION_SERVICE);
                } 
            },*/
            'serviceoptform[itemId=facultyServiceOptForm] button[itemId=cancelButtonId]': {
            	click:function(){
            		this.closePersonCommonWindow();
                }
            },
            'serviceoptform[itemId=facultyServiceOptForm] radiogroup#serviceOptRadioGroup': {
            	change:function(radio, newValue, oldValue, eOpts){                	
                	this.hideShowEndDateField(radio,newValue,oldValue);
                }
            },
            
            'communityoptform[itemId=facultyCommunityOptForm] radiogroup#communityOptRadioGroup': {
            	change:function(radio, newValue, oldValue, eOpts){                	
                	this.hideShowEndDateField(radio,newValue,oldValue);
                }
            }
        	
        });
    }
    

});
