/**
 * This controller is used for student document information actions.   
 */
Ext.define('Academia.controller.personinfo.student.StudentDocumentController', {
    extend: 'Academia.controller.personinfo.common.PersonCommonController',

    models: ['personinfo.common.documents.DocumentModel'],

    stores: ['personinfo.common.documents.DocumentStore','common.DocumentTypeStore',
             'examinationcenters.evaluationgrouplisting.documentsubmit.DocumentNameByEvalGroup',
             'common.LiveSearchCombos','document.DocumentModeSubmissionStore','document.DocumentModeSubmissionStore',
             'document.DocumentStatusStore','student.studentprofile.StudentProfileOnlineDocumentStore',
             'student.studentprofile.StudentProfilePhysicalDocumentStore','common.DocumentStatusCSMStore'],

    views: ['personinfo.common.documents.DocumentGrid', 'document.DocumentFormWindow', 
            'document.SimpleDocumentForm', 'document.ExtendedDocumentForm','common.NestedJsonCombo',
            'common.LiveSearchCombo',
			'student.studentprofile.StudentOnlineDocumentGrid',
			'personinfo.common.documents.OnlineDocumentFormWin',
			'personinfo.common.documents.PhysicalDocumentFormWin',
			'student.studentprofile.StudentPhysicalDocumentGrid',
			'personinfo.common.documents.DocumentRemarkFormWin',
			'document.DocumentPreviewWindow'],

    alias: "widget.studentdocumentcontroller",

    refs: [{
        ref: 'studentDocumentGrid',
        selector: 'documentgrid[itemId=studentDocumentGrid]'
    },{
        ref: 'studentOnlineDocumentGrid',
        selector: 'studentonlinedocumentgrid[itemId=studentOnlineDocumentGridItemId]'
    },{
        ref: 'studentPhysicalDocumentGrid',
        selector: 'studentphysicaldocumentgrid[itemId=studentPhysicalDocumentGridItemId]'
    },{
        ref: 'studentonlinedocumentformwin',
        selector: 'onlinedocumentformwin[itemId=studentOnlineDocumentFormWin]'
    },{
        ref: 'studentphysicaldocumentformwin',
        selector: 'physicaldocumentformwin[itemId=studentPhysicalDocumentFormWin]'
    },{
        ref: 'studentonlinedocumentremarkformwin',
        selector: 'documentremarkformwin[itemId=studentOnlineDocumentRemarkWin]'
    },{
        ref: 'studentphysicaldocumentremarkformwin',
        selector: 'documentremarkformwin[itemId=studentPhysicalDocumentRemarkWin]'
    },{
        ref: 'studentportalonlinedocumentformwin',
        selector: 'onlinedocumentformwin[itemId=studentPortalOnlineDocumentFormWin]'
    },{
        ref: 'parentportalonlinedocumentformwin',
        selector: 'onlinedocumentformwin[itemId=parentPortalOnlineDocumentFormWin]'
    },{
    	ref: 'documentpreviewwindow',
    	selector: 'documentpreviewwindow'
    }],
    config: {
    	STUDENT_DOCUMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_DOCUMENTS_PRIVILEGES'),
    	STUDENT_ONLINE_DOCUMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_ONLINE_DOCUMENT_PRIVILEGES'),
    	STUDENT_PHYSICAL_DOCUMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PHYSICAL_DOCUMENT_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_DOCUMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_DOCUMENTS_PRIVILEGES'),
    	PARENT_PORTAL_STUDENT_DOCUMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_DOCUMENTS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_PROFILE_ONLINE_DOCUMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_PROFILE_ONLINE_DOCUMENTS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_PROFILE_PHYSICAL_DOCUMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_PROFILE_PHYSICAL_DOCUMENTS_PRIVILEGES')
    },
    init: function(application) {
        this.control({
            /*Documents Details*/
        	'onlinedocumentformwin[itemId=studentOnlineDocumentFormWin]': {
        	    render: function(formWin) {
        	        var this$ = this;
        	        var formPnl = formWin.down('form');
        	        var itemIdPrivilegeNameArray = [{"#predifinedocument": "PREDEFINED_DOCUMENTS","#othersItemId": "OTHERS","radioGroupItemId": "#documentType","defaultButtonItemId": "#predifinedocument"}];
        	        if (portalId == 2) {
        	            this$.disableRadioGroupAndOtherPivileges(formPnl, this$.getFACULTY_PORTAL_STUDENT_PROFILE_ONLINE_DOCUMENTS_PERMISSIONS(), itemIdPrivilegeNameArray);
        	        }else if (portalId == 3) {
        	            this$.disableRadioGroupAndOtherPivileges(formPnl, this$.getSTUDENT_PORTAL_STUDENT_DOCUMENTS_PERMISSIONS(), itemIdPrivilegeNameArray);
        	        }else if (portalId == 7) {
        	            this$.disableRadioGroupAndOtherPivileges(formPnl, this$.getPARENT_PORTAL_STUDENT_DOCUMENTS_PERMISSIONS(), itemIdPrivilegeNameArray);
        	        }else if (portalId == 1){

        	        	var onlineDocRadiobtnMap=this$.getSTUDENT_ONLINE_DOCUMENTS_PERMISSIONS();
        	        	var associatedAcadLocationIds = new Array();
        	        	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        	        	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,
        	        			onlineDocRadiobtnMap);
        	        	var predifinedocument =formPnl.down("#predifinedocument");
        	        	var othersItemId =formPnl.down("#othersItemId");
        	        	var feePayerItemId =formPnl.down("#feePayerItemId");
        	        	var documentTypeRadioGroup =formPnl.down("#documentType");
        	        	predifinedocument.setVisible(false);
        	        	othersItemId.setVisible(false);
        	        	feePayerItemId.setVisible(false);
        	        	var availablePermissions = 0;

        	        	if (Ext.Array.contains(permissionList, 'PREDEFINED_DOCUMENTS')) {
        	        		availablePermissions++;
        	        	}
        	        	if (Ext.Array.contains(permissionList, 'OTHERS')) {
        	        		availablePermissions++;
        	        	}
        	        	if (Ext.Array.contains(permissionList, 'FEE_PAYER_DOCUMENT')) {
        	        		availablePermissions++;
        	        	}
        	        	if (availablePermissions < 2) {
        	        		documentTypeRadioGroup.setVisible(false);
        	        		var submitButton= formPnl.down('#documentFormSubmitButtonId');
        	        		submitButton.setVisible(false);
        	        	} else {
        	        		documentTypeRadioGroup.setVisible(true);
        	        	}
        	        	predifinedocument.setVisible(Ext.Array.contains(permissionList, 'PREDEFINED_DOCUMENTS'));

        	        	othersItemId.setVisible(Ext.Array.contains(permissionList, 'OTHERS'));

        	        	feePayerItemId.setVisible(Ext.Array.contains(permissionList, 'FEE_PAYER_DOCUMENT'));
        	        	//this$.disableRadioGroupAndOtherPivileges(formPnl, this$.getSTUDENT_ONLINE_DOCUMENTS_PERMISSIONS(), itemIdPrivilegeNameArray);
        	        }
        	    }
        	},

        	'physicaldocumentformwin[itemId=studentPhysicalDocumentFormWin]': {
        	    render: function(formWin) {
        	        var this$ = this;
        	        var formPnl = formWin.down('form');
        	        var itemIdPrivilegeNameArray = [{"#preDefined": "PREDEFINED_DOCUMENTS","#otherItemId": "OTHERS","radioGroupItemId": "#documentType","defaultButtonItemId": "#preDefined" }];
        	        if (portalId == 2) {
        	            this$.disableRadioGroupAndOtherPivileges(formPnl, this$.getFACULTY_PORTAL_STUDENT_PROFILE_PHYSICAL_DOCUMENTS_PERMISSIONS(), itemIdPrivilegeNameArray);
        	        }else if (portalId == 3) {
        	            this$.disableRadioGroupAndOtherPivileges(formPnl, this$.getSTUDENT_PORTAL_STUDENT_DOCUMENTS_PERMISSIONS(), itemIdPrivilegeNameArray);
        	        }else if (portalId == 7) {
        	            this$.disableRadioGroupAndOtherPivileges(formPnl, this$.getPARENT_PORTAL_STUDENT_DOCUMENTS_PERMISSIONS(), itemIdPrivilegeNameArray);
        	        }else if (portalId == 1){
        	        	this$.disableRadioGroupAndOtherPivileges(formPnl, this$.getSTUDENT_PHYSICAL_DOCUMENTS_PERMISSIONS(), itemIdPrivilegeNameArray);
        	        }
        	        
        	       /* if(portalId ==1){
                 	   var documentStatusCSM = formWin.down('#documentStatus');
                 	   documentStatusCSM.getStore().load({
                		   callback: function(records, operation, success) {
                			  for(var i in records){
                				  if(records[i].data.code =="SUBMITTED"){
                					documentStatusCSM.setValue(records[i].data.id);
                				  }
                			  }
                		  } 
        			  });
                }*/
        	    }
        	},
               'documentgrid[itemId=studentDocumentGrid]': {
                render: function(grid) {
                    this.loadGridStore('#studentDocumentGrid', SERVERURL.STUDENT_DOCUMENT_GRID_DATA);
                    if(portalId == 3 || portalId == 7){
    					grid.down('toolbar').down('#btnAdd').setVisible(true);
    					grid.down('toolbar').down('#btnEdit').setVisible(true);
    				}
                    grid.columns[7].setVisible(false);
                    //grid.columns[7].hide();//programName
                    grid.columns[8].setVisible(false);//BatchName
                    grid.columns[9].setVisible(false);//SeatType
                    var portalId = this.getCurrentLoggedPortalId();
                    if(portalId == 7){
                    	this.doAccessControlValidation(grid, this.getPARENT_PORTAL_STUDENT_DOCUMENTS_PERMISSIONS());
                    }else if(portalId == 3){
                    	this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_DOCUMENTS_PERMISSIONS());
                    }else{
                    	this.doAccessControlValidation(grid, this.getSTUDENT_DOCUMENTS_PERMISSIONS());
                    }
    				grid.down('toolbar').down('#uploadDocumentBtn').setVisible(false);
                },
                cellclick: this.cellClickStudentDocumentGrid
            },
            'documentgrid[itemId=studentDocumentGrid] button[itemId=btnAdd]': {
            	click: function(){
            		var personProfile = this.getContentPanelActiveTab();
            		var grid = personProfile.down('#studentDocumentGrid');
            		grid.getSelectionModel().deselectAll();
            		if(portalId == 3 || portalId == 7){
            			this.showStudentPortalOnlineDocumentFormWindow();
            		}else{
            			this.showDocumentFormWindow();
            		}

            	}
            },
            'documentgrid[itemId=studentDocumentGrid] button[itemId=btnEdit]': {
            	click: function(){
            		var isView = false;
            		this.editDocumentFormWindow(isView);
            	}
            },
            'documentgrid[itemId=studentDocumentGrid] button[itemId=btnView]': {
            	click: function(){
            		var isView = true;
            		this.editDocumentFormWindow(isView);
            	}
            },
            'documentgrid[itemId=studentDocumentGrid] button[itemId=btnDelete]': {
            	click: function(){
            		this.deleteDocumentRecord();
            	}
            },
            'documentformwindow[itemId=studentDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] button[itemId=documentFormSubmitButtonId]': {
            	click: function(){
            		this.saveStudentDocumentForm();
            	}
            },
            'documentformwindow[itemId=studentDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] button[itemId=documentCancelButtonId]': {
            	click: function(){
            		this.closeDocumentFormWindow();
            	}
            },
            'documentformwindow[itemId=studentDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] #fileDisplayField': {
                render: function(component) {
                	var me = this;
	                component.getEl().on('click', function(e) {
	                	me.downloadStudentDocumentFile();
	                });
                }
            },
            'documentformwindow[itemId=studentDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] filefield[itemId=uploadFileField]': {
                change: function(fileField, value, eOpts) {
                    if (!isNullOrEmpty(value)) {
                        var $this = this;
                        value = value.replace('C:\\fakepath\\', '');
                        var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                        fileField.setRawValue(newValue);
                        var file = fileField.fileInputEl.dom.files[0];
                        var form = fileField.up().up();
                        var fileInfoContainer = form.down('#fileInfoContainer');
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        var docDetails = form.down('#docDetails');
                        var docType = form.down('#documentTypeCombo');
                        if (docType.getRawValue() == 'Signature') {
                            if (!isNullOrEmpty(extension)) {
                                if (!((extension == "png" || extension == "jpeg" || extension == "jpg") && (file.size / 1024) <= 50)) {
                                    fileField.reset();
                                    showWarningMessage(getCommonTranslation("ALERT"), getPersonModuleTranslation('SIGNATURE_IMAGE_ALERT_MESSAGE'));
                                }
                                var fileInfoContainer = form.down('#fileInfoContainer');
                                fileInfoContainer.setVisible(true);
                                docDetails.setValue(getPersonModuleTranslation('SIGNATURE_IMAGE_FIELD_MESSAGE'));
                            }
                        } else {
                            if ($this.isValidFileExtension(extension)) {
                                if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                    fileInfoContainer.setVisible(false);
                                    fileField.reset();
                                    showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                                } else {
                                    var form = fileField.up().up();
                                    var fileInfoContainer = form.down('#fileInfoContainer');
                                    fileInfoContainer.setVisible(true);
                                    var docDetails = form.down('#docDetails');
                                    docDetails.setValue("Type: " + extension + " Size: " + (file.size / 1024).toFixed(2) + ' KBs');
                                }
                            } else {
                                fileInfoContainer.setVisible(false);
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
                            }
                        }
                    }
                }
            },
            'documentformwindow[itemId=studentDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] nestedJsonCombo#documentTypeCombo': {
                select: function(obj, record) {
                    var form = obj.up().up();
                    var uploadBtn = form.down('#uploadFileField');
                    var docType = form.down('#documentTypeCombo');
                    var docDetails = form.down('#docDetails');
                    if (docType.getRawValue() == 'Signature') {
                        var fileInfoContainer = form.down('#fileInfoContainer');
                        fileInfoContainer.setVisible(true);
                        docDetails.setValue(getPersonModuleTranslation('SIGNATURE_IMAGE_FIELD_MESSAGE'));
                    } else {
                        docDetails.reset();
                    }
                    uploadBtn.reset();
                }
            },
            'studentonlinedocumentgrid[itemId=studentOnlineDocumentGridItemId] button[itemId=btnAdd]': {
            	click: function() {
            		var grid = this.getStudentOnlineDocumentGrid();
            		grid.getSelectionModel().deselectAll();
            		this.showStudentOnlineDocumentFormWindow();
            	}
            },
            'studentphysicaldocumentgrid[itemId=studentPhysicalDocumentGridItemId] button[itemId=btnAdd]': {
            	click: function() {
            		var grid = this.getStudentPhysicalDocumentGrid();
            		grid.getSelectionModel().deselectAll();
            		this.showStudentPhysicalDocumentFormWindow();
            		
            	}
            },
            'studentonlinedocumentgrid[itemId=studentOnlineDocumentGridItemId] button[itemId=btnDelete]': {
            	click: function() {
            		this.deleteStudentDocumentRecord(true);
            	}
            },
        	'studentonlinedocumentgrid[itemId=studentOnlineDocumentGridItemId] button[itemId=btnEdit]': {
        	    click: function() {
        	        var formWin = this.getStudentonlinedocumentformwin();
        	        if (!formWin) {
        	            Ext.widget('onlinedocumentformwin', {
        	                itemId: 'studentOnlineDocumentFormWin'
        	            });
        	            formWin = this.getStudentonlinedocumentformwin();
        	        }

        	        formWin.down('#uploadFileField').allowBlank = true;
        	        this.editStudentOnlineDocumentFormWindow();
        	    }
        	},
        	'studentphysicaldocumentgrid[itemId=studentPhysicalDocumentGridItemId] button[itemId=btnDelete]': {
        		click: function() {
        			this.deleteStudentDocumentRecord(false);
        		}
        	},
        	'studentphysicaldocumentgrid[itemId=studentPhysicalDocumentGridItemId] button[itemId=btnEdit]': {
        	    click: function() {
        	        var formWin = this.getStudentphysicaldocumentformwin();
        	        if (!formWin) {
        	            Ext.widget('physicaldocumentformwin', {
        	                itemId: 'studentPhysicalDocumentFormWin'
        	            });
        	            formWin = this.getStudentphysicaldocumentformwin();
        	        }
        	        this.editStudentPhysicalDocumentFormWindow();
        	    }
        	},
            'onlinedocumentformwin[itemId=studentOnlineDocumentFormWin] radiogroup[itemId=documentType]': {
            	change: function(radioField, newValue, oldValue, eOpts) {
            		var formWin = this.getStudentonlinedocumentformwin();
            		this.onChangeStudentPredefinedRadioGroup(formWin, newValue, 'ONLINE');
            	}
            },
            'physicaldocumentformwin[itemId=studentPhysicalDocumentFormWin] radiogroup[itemId=documentType]': {
            	change: function(radioField, newValue, oldValue, eOpts) {
            		var formWin = this.getStudentphysicaldocumentformwin();
            		this.onChangeStudentPredefinedRadioGroup(formWin, newValue, 'PHYSICAL');
            	}
            },
            'onlinedocumentformwin[itemId=studentOnlineDocumentFormWin] button[itemId=documentCancelButtonId]': {
            	click: function() {
            		var formWindow = this.getStudentonlinedocumentformwin();
            		formWindow.close();
            	}
            },
            'physicaldocumentformwin[itemId=studentPhysicalDocumentFormWin] button[itemId=documentCancelButtonId]': {
            	click: function() {
            		var formWindow = this.getStudentphysicaldocumentformwin();
            		formWindow.close();
            	}
            },
            'studentonlinedocumentgrid[itemId=studentOnlineDocumentGridItemId]': {
            	afterrender: function(grid) {
            		 //this.loadGridStore('#studentDocumentGrid', SERVERURL.STUDENT_DOCUMENT_GRID_DATA);
            		 grid.down('#btnEdit').setDisabled(false);
                     grid.down('#btnDelete').setDisabled(false);
            		var portalId = this.getCurrentLoggedPortalId();
            		if(portalId == 3){
            			this.loadStudentDocumentGridStore(grid);
                    	this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_DOCUMENTS_PERMISSIONS());
                    	if(Ext.isDefined(Ext.ComponentQuery.query('studentonlinedocumentgrid'))){
                    		var getGrid = Ext.ComponentQuery.query('studentonlinedocumentgrid')[0];
                        	Ext.each(getGrid.columns, function(currentColumn){
    						 
                        		
                        		if(currentColumn.dataIndex=="returnedDate")
    						   {
    							   currentColumn.setVisible(false);
    						   }
    						   if(currentColumn.dataIndex=="inspectionDate")
    						   {
    							   currentColumn.setVisible(false);
    						   }
    						   if(currentColumn.dataIndex=="programName")
    						   {
    							   currentColumn.setVisible(false);
    						   }
    						   if(currentColumn.dataIndex=="seatType")
    						   {
    							   currentColumn.setVisible(false);
    						   }
    						   if(currentColumn.dataIndex=="remark")
    						   {
    							   currentColumn.setVisible(false);
    						   }
    					   }
                        	
                        	);
                        	getGrid.getView().refresh();
                    	}
                   
                    } else if(portalId == 7){
                    	this.loadStudentDocumentGridStore(grid);
                    	this.doAccessControlValidation(grid, this.getPARENT_PORTAL_STUDENT_DOCUMENTS_PERMISSIONS());
                    	if(Ext.isDefined(Ext.ComponentQuery.query('studentonlinedocumentgrid'))){
                    		var getGrid = Ext.ComponentQuery.query('studentonlinedocumentgrid')[0];
                        	Ext.each(getGrid.columns, function(currentColumn){
    						 
                        		
                        		if(currentColumn.dataIndex=="returnedDate")
    						   {
    							   currentColumn.setVisible(false);
    						   }
    						   if(currentColumn.dataIndex=="inspectionDate")
    						   {
    							   currentColumn.setVisible(false);
    						   }
    						   if(currentColumn.dataIndex=="programName")
    						   {
    							   currentColumn.setVisible(false);
    						   }
    						   if(currentColumn.dataIndex=="seatType")
    						   {
    							   currentColumn.setVisible(false);
    						   }
    						   if(currentColumn.dataIndex=="remark")
    						   {
    							   currentColumn.setVisible(false);
    						   }
    					   }
                        	
                        	);
                        	getGrid.getView().refresh();
                    	}
                    } else if(portalId == 2){
                    	this.loadStudentDocumentGridStore(grid, true);
            			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_PROFILE_ONLINE_DOCUMENTS_PERMISSIONS());
            		} else {
            			this.loadStudentDocumentGridStore(grid, true);
            			this.doAccessControlValidation(grid, this.getSTUDENT_ONLINE_DOCUMENTS_PERMISSIONS());
            		}
            	},selectionchange:function(view,record){
                    var $this = this;
                    var personProfile = $this.getContentPanelActiveTab();
                    var grid = personProfile.down('#studentOnlineDocumentGridItemId');
                     if(record.length > 0){
                           record.forEach(function(obj){
                             var fileName = obj.data.documentName
                               if(fileName.indexOf("AttestationCertificateStudentJourney") != -1){
                                   grid.down('#btnEdit').setDisabled(true);
                                   grid.down('#btnDelete').setDisabled(true);
                               }
                           });        
                       }else{
                           grid.down('#btnEdit').setDisabled(false);
                           grid.down('#btnDelete').setDisabled(false);
                       }     
                },
            	cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
            		var $this = this;
            		 var cellDataIndex =View.ownerCt.columnManager.columns[ColIdx].dataIndex;
            		 if(e.target.tagName == "A" &&(cellDataIndex == "previewDoc") ){
            			var previewWindow = $this.getDocumentpreviewwindow();
						if (!previewWindow) {
							Ext.widget('documentpreviewwindow', {
								documentRecord: record,
								width: '100%',
								height: Ext.getBody().getHeight(),
								itemId: 'stuDocPreviewWindow'
							});
							previewWindow = $this.getDocumentpreviewwindow();
						}

						previewWindow.show();
            		} else if (e.target.tagName == 'A') {

            			var personProfile = $this.getContentPanelActiveTab();
            			var grid = personProfile.down('#studentOnlineDocumentGridItemId');
            			if (grid.getSelectionModel().getCount() > 0) {
            				if (grid.getSelectionModel().getCount() > 1) {
            					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
            				}else
            				{
            					var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
            					var record = grid.getSelectionModel().getSelection()[0];
            					if (columnName == 'remark') {
            						var formWindow = $this.getStudentonlinedocumentremarkformwin();
            						if (!formWindow) {

            							Ext.widget('documentremarkformwin', {
            								itemId: 'studentOnlineDocumentRemarkWin'
            							});
            							formWindow = $this.getStudentonlinedocumentremarkformwin();
            						}

            						formWindow.show();
            						var remark = record.get("remark");
            						var documentRemarkArea = formWindow.down('#documentRemarkItemId');
            						documentRemarkArea.setValue(remark);

            					}else if (columnName == "documentType" && record.get('isElectronic')) {
            						var this$ = this;
            						var documentId = record.get("documentId");
            						var isRegistrationDoc = record.get('isRegistrationDoc');
									var fileName = record.get("documentName");
		            		
									if(fileName.indexOf("AttestationCertificateStudentJourney") != -1){
										var csvForm = Ext.create('Ext.form.Panel'); 
					        	    	csvForm.getForm().submit({
					        		    	target: '_blank',
					        		    	method:'GET',
					        		    	params :{
					        		    		access_token : Ext.Ajax.defaultHeaders.access_token,
												documentId:documentId
					        		    	},
					        		    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
					        		    	url: SERVERURL.PATH_DOWNLOAD_ATTESTATION_STATEMENT_FROM_STUDENT_PROFILE,
					        		    	standardSubmit :true
					        	    	});
									}else if(!isNullOrEmpty(documentId)){
            							if (e.target.tagName == 'A') {
            								this$.getDocumentController().downloadDocumentFile(documentId);
            							}
            						}else if(!isNullOrEmpty(isRegistrationDoc) && isRegistrationDoc){
            							var documentId = record.get("id");
            							var isWhetherSysMsgEvent = true;
            							 this$.getAdhocMessagingEventController().downloadAttachedDocumentFile(documentId,isWhetherSysMsgEvent);
            						}

            					}

            				} 

            			}else
            			{
            				showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            			}

            		}
            		/*var grid = this.getStudentOnlineDocumentGrid();

        	        	if(grid.getSelectionModel().getCount() > 1) {
        	        		grid.down('#btnEdit').setDisabled(true);
        	        		//showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
        	        	} else {
        	        		grid.down('#btnEdit').setDisabled(false);
        	        	}*/

            	},
            	
 			   select :function($this, record, index){
 				  var personProfile = this.getContentPanelActiveTab();
                  var grid = personProfile.down('#studentOnlineDocumentGridItemId');
				   this.getCheckedDocumentGrid($this, record, index, 'select',grid);
			   },
			   deselect :function($this, record, index){
				   var personProfile = this.getContentPanelActiveTab();
                   var grid = personProfile.down('#studentOnlineDocumentGridItemId');
				   this.getCheckedDocumentGrid($this, record, index, 'deselct',grid);
			   }
            },
            'documentpreviewwindow[itemId=stuDocPreviewWindow]':{
            	afterrender: function(win){
            		var me = this;
            		var documentRecord = win.documentRecord;
            		var documentId = documentRecord.data.documentId;
            		var id = documentRecord.data.id;
            		var fileExtension = documentRecord.data.path.split('.').pop();
            		var fileName = documentRecord.data.documentName;
            		win.setTitle(documentRecord.data.documentName);
					var url=SERVERURL.PATH_GET_BASE64_DOCUMENT_BY_DOCUMENTID;
					if(fileName.indexOf("AttestationCertificateStudentJourney") != -1){
						url=SERVERURL.PATH_BASE_64_ATTESTATION_STATEMENT_ON_STUDENT_PROFILE;
					}
            		if(!isNullOrEmpty(documentId) && documentId){
            				Ext.Ajax.request({
            					type: 'rest',
            					url: url,
            					params:{
            						documentId:documentId,
                    			},
            					method: 'GET',
            					success: function(res, action) {
            						var responseTxt = res.responseText;
            						if(responseTxt != ''){
                						if(fileExtension.toUpperCase() == "PDF"){
                							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<iframe width='100%' height='100%' src='data:application/pdf;base64, " + encodeURI(responseTxt) + "'></iframe>";
                						}
                						else{
                							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<img src='data:image/"+fileExtension.toLowerCase()+";base64," + encodeURI(responseTxt) + "' />";
                						}
            						}
            						else{
            							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "Document Not Found";
            						}
            					}
            				});
            		}else if(!isNullOrEmpty(id) && id){
        				Ext.Ajax.request({
        					type: 'rest',
        					url: SERVERURL.PATH_GET_BASE64_DYNAMIC_DOCUMENT_BY_ID + id,
        					method: 'GET',
        					success: function(res, action) {
        						var responseTxt = res.responseText;
        						if(responseTxt != ''){
            						if(fileExtension.toUpperCase() == "PDF"){
            							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<iframe width='100%' height='100%' src='data:application/pdf;base64, " + encodeURI(responseTxt) + "'></iframe>";
            						}
            						else{
            							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<img src='data:image/"+fileExtension.toLowerCase()+";base64," + encodeURI(responseTxt) + "' />";
            						}
        						}
        						else{
        							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "Document Not Found";
        						}
        					}
        				});
        		     }
            	}
            },
            'studentphysicaldocumentgrid[itemId=studentPhysicalDocumentGridItemId]': {
            	render: function(grid) {
            		this.loadStudentDocumentGridStore(grid, false);
            		var portalId = this.getCurrentLoggedPortalId();
            		if(portalId == 2){
            			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_PROFILE_PHYSICAL_DOCUMENTS_PERMISSIONS());
            		}else {
            			this.doAccessControlValidation(grid, this.getSTUDENT_PHYSICAL_DOCUMENTS_PERMISSIONS());
            		}
            	},
            	cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
            		if (e.target.tagName == 'A') {
            			var $this = this;
            			var personProfile = $this.getContentPanelActiveTab();
                        var grid = personProfile.down('#studentPhysicalDocumentGridItemId');
            			if (grid.getSelectionModel().getCount() > 0) {
            				if (grid.getSelectionModel().getCount() > 1) {
            					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
            				}else
            				{
            					var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
            					var record = grid.getSelectionModel().getSelection()[0];
            					if (columnName == 'remark') {
            						var formWindow = $this.getStudentphysicaldocumentremarkformwin();
            						if (!formWindow) {
            							 Ext.widget('documentremarkformwin', {
                							 itemId: 'studentPhysicalDocumentRemarkWin'
                						 });	
            						}
            						formWindow = $this.getStudentphysicaldocumentremarkformwin();
            						formWindow.show();
            						var remark = record.get("remark");
            						var documentRemarkArea = formWindow.down('#documentRemarkItemId');
            						documentRemarkArea.setValue(remark);

            					}
            				}
            			}else
            			{
            				showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            			}
            		}
        	    },
  			   select :function($this, record, index){
  				 var personProfile = this.getContentPanelActiveTab();
                 var grid = personProfile.down('#studentPhysicalDocumentGridItemId');
 				   this.getCheckedDocumentGrid($this, record, index, 'select',grid);
 			   },
 			   deselect :function($this, record, index){
 				  var personProfile = this.getContentPanelActiveTab();
                  var grid = personProfile.down('#studentPhysicalDocumentGridItemId');
 				   this.getCheckedDocumentGrid($this, record, index, 'deselct',grid);
 			   }
            },
            'onlinedocumentformwin[itemId=studentOnlineDocumentFormWin] filefield[itemId=uploadFileField]': {
                change: function(fileField, value, eOpts) {
                    if (!isNullOrEmpty(value)) {
                        var $this = this;
                        value = value.replace('C:\\fakepath\\', '');
                        var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                        fileField.setRawValue(newValue);
                        var file = fileField.fileInputEl.dom.files[0];
                        var form = fileField.up().up();
                        var fileInfoContainer = form.down('#fileInfoContainer');
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        var docDetails = form.down('#docDetails');
                        var docType = form.down('#documentTypeCombo');
                        if (docType.getRawValue() == 'Signature') {
                            if (!isNullOrEmpty(extension)) {
                                if (!((extension == "png" || extension == "jpeg" || extension == "jpg") && (file.size / 1024) <= 50)) {
                                    fileField.reset();
                                    showWarningMessage(getCommonTranslation("ALERT"), getPersonModuleTranslation('SIGNATURE_IMAGE_ALERT_MESSAGE'));
                                }
                                var fileInfoContainer = form.down('#fileInfoContainer');
                                fileInfoContainer.setVisible(true);
                                docDetails.setValue(getPersonModuleTranslation('SIGNATURE_IMAGE_FIELD_MESSAGE'));
                            }
                        } else {
                            if ($this.isValidFileExtension(extension)) {
                                if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT_FOR_STUDENT_DOCUMENT) {
                                    fileInfoContainer.setVisible(false);
                                    fileField.reset();
                                    showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_EXTENDED_ERROR_MSG'));
                                } else {
                                    var form = fileField.up().up();
                                    var fileInfoContainer = form.down('#fileInfoContainer');
                                    fileInfoContainer.setVisible(true);
                                    var docDetails = form.down('#docDetails');
                                    docDetails.setValue("Type: " + extension + " Size: " + (file.size / 1024).toFixed(2) + ' KBs');
                                }
                            } else {
                                fileInfoContainer.setVisible(false);
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
                            }
                        }
                    }
                }
            },
            'onlinedocumentformwin[itemId=studentOnlineDocumentFormWin] button[itemId=documentFormSubmitButtonId]': {
            	click: function() {
            		this.saveOnlineStudentDocumentFormData(true);
            	}
            },
            'physicaldocumentformwin[itemId=studentPhysicalDocumentFormWin] button[itemId=documentFormSubmitButtonId]': {
            	click: function() {
            		this.savePhysicalStudentDocumentFormData(false);
            	}
            },
        	'onlinedocumentformwin[itemId=studentOnlineDocumentFormWin] radiogroup[itemId=inspectionDoneRadioGroupField]': {
        	    change: function(radioField, newValue, oldValue, eOpts) {
        	        var formWindow = this.getStudentonlinedocumentformwin();
        	        var form = formWindow.down('#onlineDocumentFormItemId');
        	        this.studentOnSelectionIsInspectionDone(form);
        	    }
        	},
        	'documentremarkformwin[itemId=studentOnlineDocumentRemarkWin] button[itemId=cancelBtnRemarkItemId]': {
        	    click: function() {
        	        var formWindow = this.getStudentonlinedocumentremarkformwin();
        	        formWindow.close();
        	    }
        	},
        	'documentremarkformwin[itemId=studentPhysicalDocumentRemarkWin] button[itemId=cancelBtnRemarkItemId]': {
        	    click: function() {
        	        var formWindow = this.getStudentphysicaldocumentremarkformwin();
        	        formWindow.close();
        	    }
        	},
        	'physicaldocumentformwin[itemId=studentPhysicalDocumentFormWin] radiogroup[itemId=inspectionDoneRadioGroupField]': {
        	    change: function(radioField, newValue, oldValue, eOpts) {
        	        var formWindow = this.getStudentphysicaldocumentformwin();
        	        var form = formWindow.down('#physicalDocumentFormItemId');
        	        this.studentOnSelectionIsInspectionDone(form);
        	    }
        	},
        	'physicaldocumentformwin[itemId=studentPhysicalDocumentFormWin] radiogroup[itemId=returnableRadioGroup]': {
        	    change: function(radioField, newValue, oldValue, eOpts) {
        	        var this$ = this;
        	        var formWindow = this.getStudentphysicaldocumentformwin();
        	        var form = formWindow.down('#physicalDocumentFormItemId');
        	        var isReturnableYesField = form.down('#isReturnableYesField');
        	        var returnDateField = form.down('#returnDateField');
        	        var returnByField = form.down('#returnByField');
        	        if (isReturnableYesField.getValue() == true) {
        	        	returnDateField.setDisabled(false);
        	        	returnByField.setDisabled(false);

        	        	var returnByStore=returnByField.getStore();
        	        	returnByStore.load({
        	        		scope:this,
        	        		callback: function(rec, callback){
        	        			var currentUserId = this$.getCurrentlyLoggedInUser().id;
        	        			var preValue = returnByField.getValue();
        	        			if(isNullOrEmpty(preValue)){
        	        				returnByField.setValue(currentUserId);
        	        			}
        	        			var preDateValue = returnDateField.getValue();
        	        			if(isNullOrEmpty(preDateValue)){
        	        				returnDateField.setValue(new Date());
        	        			}
        	        			returnDateField.setMaxValue(new Date());
        	        		}
        	        	});


        	        } else {
        	            returnDateField.setValue('');
        	            returnByField.clearValue();
        	            returnDateField.setDisabled(true);
        	            returnByField.setDisabled(true);
        	        }
        	        this$.studentChangeStatus(form);
        	    }
        	},
        	'onlinedocumentformwin[itemId=studentOnlineDocumentFormWin] nestedJsonCombo[itemId=documentTypeCombo]': {
        		render: function(combo) {
        			var store = combo.getStore();
        			store.getProxy().extraParams = {
        				isApplicableForStudent: true
        			 };
        			 store.load();
        		}
        	},
        	'physicaldocumentformwin[itemId=studentPhysicalDocumentFormWin] nestedJsonCombo[itemId=documentTypeCombo]': {
        		render: function(combo) {
        			var store = combo.getStore();
        			store.getProxy().extraParams = {
        				isApplicableForStudent: true
        			 };
        			 store.load();
        		}
        	},
            'onlinedocumentformwin[itemId=studentPortalOnlineDocumentFormWin] button[itemId=documentFormSubmitButtonId]': {
            	click: function() {
            		this.saveOnlineStudentPortalDocumentFormData(true);
            	}
            },
            'onlinedocumentformwin[itemId=studentPortalOnlineDocumentFormWin] radiogroup[itemId=documentType]': {
            	change: function(radioField, newValue, oldValue, eOpts) {
            		var formWin = this.getStudentportalonlinedocumentformwin();
            		this.onChangeStudentPortalPredefinedRadioGroup(formWin, newValue, 'ONLINE');
            	}
            },
            'onlinedocumentformwin[itemId=parentPortalOnlineDocumentFormWin] radiogroup[itemId=documentType]': {
            	change: function(radioField, newValue, oldValue, eOpts) {
            		var formWin = this.getStudentportalonlinedocumentformwin();
            		this.onChangeStudentPortalPredefinedRadioGroup(formWin, newValue, 'ONLINE');
            	}
            },
            'onlinedocumentformwin[itemId=studentPortalOnlineDocumentFormWin] button[itemId=documentCancelButtonId]': {
            	click: function() {
            		var formWindow = this.getStudentportalonlinedocumentformwin();
            		formWindow.close();
            	}
            },
            'onlinedocumentformwin[itemId=studentPortalOnlineDocumentFormWin] nestedJsonCombo[itemId=documentTypeCombo]': {
            	render: function(combo) {
        			var store = combo.getStore();
        			store.getProxy().extraParams = {
        				isApplicableForStudent: true
        			 };
        			 store.load();
        		}
            }
        });
    },
    /**
     * load student document grid
     * @param gridItemId
     * @param url
     */
    loadGridStore: function(gridItemId, url) {
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	var studentId = personProfile.getUserId();
    	var admissionId = personProfile.getAdmissionId();
    	var studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
    	if(isNullOrEmpty(admissionId)) {
    		admissionId = studentInfo.admissionDetails[0].id;
    	}
    	var grid = personProfile.down(gridItemId);
    	if (grid) {
    		var store = grid.getStore();
    		var params = {
    				studentId: studentId,
    				admissionId : admissionId
    		};
    		store.getProxy().api.read = url;
    		store.getProxy().extraParams = params;
    		store.load();
    	}
    	 var portalId = this$.getCurrentLoggedPortalId();
         if(portalId == 3 || portalId == 7){
         	grid.down('#inspectionDateItem').setVisible(true);
         }else{
         	grid.down('#inspectionDateItem').setVisible(true);
             grid.down('#returnedDateItem').setVisible(true);
         }
    },
    /**
     * Get document controller
     */
    getDocumentController : function(){
    	var this$ = this;
    	return this$.getController('Academia.controller.document.DocumentController');
    },
    getAdhocMessagingEventController : function(){
    	this$ = this;
    	return this$.getController('Academia.controller.messaging.AdhocMessagingEventController');
    },
    /**
     * Cell click download file
     * @param grid
     * @param td
     * @param cellIndex
     * @param record
     * @param tr
     * @param rowIndex
     * @param e
     * @param eOpts
     */
    cellClickStudentDocumentGrid : function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
        var documentGrid = this.getStudentDocumentGrid();
        var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

        if (columnName == "documentType" && record.get('isElectronic')) {
            var this$ = this;
            var documentId = record.get("documentId");
            if(!isNullOrEmpty(documentId)){
            	if (e.target.tagName == 'A') {
            		this$.getDocumentController().downloadDocumentFile(documentId);
            	}
            }
            
        }
    },
    /** 
     * Download student doc file 
     */
    downloadStudentDocumentFile : function(){
    	var this$ = this;
    	var documentGrid = this$.getStudentDocumentGrid();
    	var record = documentGrid.getSelectionModel().getSelection()[0];
    	var docId = record.get("documentId");
    	if(!isNullOrEmpty(docId)){
        	this$.getDocumentController().downloadDocumentFile(docId);
        }
    },
    /**
     * Show document form 
     */
    showDocumentFormWindow : function(){
    	var this$ = this;
    	this$.getDocumentController().showDocumentFormWindow('studentDocumentForm', 'EXT_DOCUMENT',445);
    	form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
    	Ext.apply(form, {
    		isEditable: false
    	});
    	var modeSubmissionStore=form.down('#modeOfSubmission').getStore();
		modeSubmissionStore.on('load', function(){
			for(var i=0; i< modeSubmissionStore.data.items.length;i++){
				if(modeSubmissionStore.data.items[i].data.value == 'Online'){
					modeSubmissionStore.removeAt(i);
				} 
			}
		});
    	var portalId = this.getCurrentLoggedPortalId();
    	form.down('#modeOfSubmission').setDisabled(true);
    	form.down('#documentTypeRadioGroup').setVisible(true);
    	form.down('#responsibleUserField').setDisabled(true);
    	form.down('#uploadFileField').setDisabled(false);
    	form.down('#uploadFileField').setVisible(true);
    	form.down('#inspectionRequiredRadioGroupField').setDisabled(true);
    	form.down('#inspectionRequiredRadioGroupField').setVisible(false);
    	form.down('#inspectionDoneRadioGroupField').setDisabled(true);
    	form.down('#inspectionDoneRadioGroupField').setVisible(false);
    	form.down('#inspectionDateField').setVisible(false);
    	form.down('#inspectionDoneByField').setVisible(false);
    	form.down('#returnableRadioGroup').setVisible(false);
    	form.down('#returnDateField').setVisible(false);
    	form.down('#returnByField').setVisible(false);
    	form.down('#modeOfReturnField').setVisible(false);
    	form.down('#returnedToUserField').setVisible(false);
    	form.down('#lastDateSubmissionId').setVisible(false);
    	if(portalId==3){
    		form.down('#physicalField').setDisabled(true);
    		form.down('#lastDateSubmissionId').setVisible(false);
    	}
    	form.down('#inspectionDateField').setMaxValue(new Date());
		form.down('#returnDateField').setMaxValue(new Date());
		form.down('#inspectionDoneByField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
		form.down('#returnByField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
		form.down('#responsibleUserField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
    },
    /**
     * Close document form 
     */
    closeDocumentFormWindow : function(){
    	var this$ = this;
    	this$.getDocumentController().closeDocumentFormWindow();
    },
    /**
     * Edit document form
     * @param isView
     */
    editDocumentFormWindow : function(isView){
    	var this$ = this;
    	var form = null;
    	var portalId = this.getCurrentLoggedPortalId();
    	var personProfile = this$.getContentPanelActiveTab();
    	var grid = personProfile.down('#studentDocumentGrid');

    	if (grid.getSelectionModel().getCount() > 0) {
    		var records = grid.getSelectionModel().getSelection()[0];
    		if(!isEmpty(records)){
    			if(portalId != 3 || (portalId == 3 && records.get('isElectronic'))){
    				var documentId = records.get("documentId");
    				if (isNullOrEmpty(documentId)) {
    					this$.getDocumentController().showDocumentFormWindow('studentDocumentForm', 'EXT_DOCUMENT');
    					form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
    					form.down('#documentTypeCombo').setValue(records.get('documentType'));
    				}else {
    					this$.getDocumentController().editDocumentFormWindow('studentDocumentForm', 'EXT_DOCUMENT', documentId, isView);
    					form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
    					form.down('#documentTypeRadioGroup').setReadOnly(true);
    				}
    				Ext.apply(form, {
    					isEditable: true
    				});
    				if (isView) {
    					form.down('#documentFormSubmitButtonId').setVisible(false);
    					form = form.getForm();
    					toggleReadOnlyFormItems(form, true);
    				}else{
    					form.down('#documentTypeCombo').setReadOnly(true);
    				}
    				form.down('#lastDateSubmissionId').setVisible(false)
    				if(records.get('isElectronic')){
    					form.down('#modeOfSubmission').setDisabled(false);
    					form.down('#modeOfSubmission').setValue('ONLINE');
    					form.down('#modeOfSubmission').setReadOnly(true);
    					form.down('#modeOfSubmission').allowBlank=true;
    					form.down('#documentTypeRadioGroup').setVisible(false);
    					form.down('#responsibleUserField').setVisible(false);
    					form.down('#uploadFileField').setDisabled(false);
    					form.down('#uploadFileField').setVisible(true);
    					form.down('#uploadFileField').allowBlank=true;
    					form.down('#inspectionRequiredRadioGroupField').setDisabled(true);
    					form.down('#inspectionRequiredRadioGroupField').setVisible(false);
    					form.down('#inspectionDoneRadioGroupField').setDisabled(false);
    					form.down('#inspectionDoneRadioGroupField').setVisible(true);
    					form.down('#inspectionDateField').setVisible(true);
    					form.down('#inspectionDoneByField').setVisible(true);
    					form.down('#returnableRadioGroup').setVisible(false);
    					form.down('#returnDateField').setVisible(false);
    					form.down('#returnByField').setVisible(false);
    					form.down('#modeOfReturnField').setVisible(false);
    					form.down('#returnedToUserField').setVisible(false);
    					form.down('#lastDateSubmissionId').setVisible(false);
    					if(portalId=3){
    						form.down('#inspectionDoneRadioGroupField').setVisible(false);
    						form.down('#inspectionDateField').setVisible(false);
    						form.down('#inspectionDoneByField').setVisible(false);
    					}
    				}else{
    					form.down('#modeOfSubmission').setDisabled(false);
    					var modeSubmissionStore=form.down('#modeOfSubmission').getStore();
    					modeSubmissionStore.on('load', function(){
    						for(var i=0; i< modeSubmissionStore.data.items.length;i++){
    							if(modeSubmissionStore.data.items[i].data.value == 'Online'){
    								modeSubmissionStore.removeAt(i);
    							} 
    						}
    					});
    					form.down('#documentTypeRadioGroup').setVisible(false);
    					form.down('#responsibleUserField').setDisabled(false);
    					form.down('#responsibleUserField').setVisible(true);
    					form.down('#uploadFileField').setDisabled(true);
    					form.down('#uploadFileField').setVisible(false);
    					form.down('#inspectionRequiredRadioGroupField').setDisabled(true);
    					form.down('#inspectionRequiredRadioGroupField').setVisible(false);
    					form.down('#inspectionDoneRadioGroupField').setDisabled(false);
    					form.down('#inspectionDoneRadioGroupField').setVisible(true);
    					form.down('#inspectionDateField').setVisible(true);
    					form.down('#inspectionDoneByField').setVisible(true);
    					form.down('#returnableRadioGroup').setDisabled(false);
    					form.down('#returnableRadioGroup').setVisible(true);
    					form.down('#returnDateField').setVisible(true);
    					form.down('#returnByField').setVisible(true);
    					form.down('#modeOfReturnField').setDisabled(true);
    					form.down('#returnedToUserField').setDisabled(true);
    					form.down('#modeOfReturnField').allowBlank=true;
    					form.down('#returnedToUserField').allowBlank=true;
    					form.down('#modeOfReturnField').setVisible(false);
    					form.down('#returnedToUserField').setVisible(false);
    					form.down('#lastDateSubmissionId').setVisible(false);
    				}
    				if(portalId == 1){
        				form.down('#documentStatus').setReadOnly(false);
        			}
    				form.down('#inspectionDateField').setMaxValue(new Date());
    				form.down('#returnDateField').setMaxValue(new Date());
    				form.down('#inspectionDoneByField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
    				form.down('#returnByField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
    				form.down('#responsibleUserField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
    			}else{
    				showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'),getPersonModuleTranslation('PHYSICALLY_DOCUMENT_NOT_UPDATED'));
    			}
    		}
    	} else {
    		showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}

    },
    /**
     * Delete document form
     */
    deleteDocumentRecord : function(){
    	var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down('#studentDocumentGrid');

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection()[0];
                        var id = "";
                        if (!isNullOrEmpty(records.get("id"))) {
                        	id = records.get("id");
                        	documentId = records.get("documentId");
                        	Ext.Ajax.request({
                                type: 'rest',
                                url: SERVERURL.STUDENT_DOCUMENT_DELETE,
                                method: 'DELETE',
                                params: {
                                    id: id
                                },
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                success: function(form, action) {
                                	grid.getStore().reload();
                                    showSuccessMessage(getPersonModuleTranslation('SUCCESS'), getPersonModuleTranslation('DOCUMENT_DELETE_SUCCESS'));
                                    
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * Save document form 
     */
    saveStudentDocumentForm: function(){
    	var this$ = this;
    	var successMsg, submitUrl;
    	var personProfile = this$.getContentPanelActiveTab();
    	var grid = personProfile.down('#studentDocumentGrid');
    	var studentId = personProfile.getUserId();
    	var admissionId = personProfile.getAdmissionId();
    	if(isNullOrEmpty(admissionId)) {
    		var studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
    		admissionId = studentInfo.admissionDetails[0].id;
    	}
    	var isTransient = false;
    	var module = 'student';
    	var entityId = studentId;
    	var entityType = 'student';
    	var doctype='EXT_DOCUMENT';
    	var uploadBtn=form.down('#uploadFileField');
    	var records =grid.getSelectionModel().getSelection()[0];
    	this$.applyWindowMask(); 
    	if(!isNullOrEmpty(records)){
    		if(!uploadBtn.isVisible() && !records.get('isElectronic')){
    			var isPhysicalFile=form.down('#physicalField');
    			isPhysicalFile.setValue(true);
    		}
    		form.down('#modeOfReturnField').setDisabled(true);
    		form.down('#returnedToUserField').setDisabled(true);
    		form.down('#modeOfReturnField').allowBlank=true;
    		form.down('#returnedToUserField').allowBlank=true;
    		form.down('#modeOfReturnField').setVisible(false);
    		form.down('#returnedToUserField').setVisible(false);
    		if(records.get('isElectronic')){
    			var formData = null;
    			var editedPath=form.down('#uploadFileField');
    			var path=null;
    			var fileField = form.down('#fileDisplayField');
    			formData = form.getValues();
    			if(isNullOrEmpty(editedPath.getValue())){//edit online document without file
    				Ext.Ajax.request({
    					type: 'rest',
    					url: SERVERURL.DOCUMENT_FORM_FIND_BY + records.get("documentId"),
    					method: 'GET',
    					success: function(res, action) {
    						var data = Ext.decode(res.responseText);
    						if(!isEmpty(data)){
    							if(!isNullOrEmpty(data.path)){
    								path=data.path;
    							}
    						}
    					}
    				});
    				this$.getDocumentController().saveDocumentFormValue(isTransient, doctype, true, formData, path, function(success, response, isCallBackTransient){
    					this$.hideWindowMask();
    					if(success){
    						var documentJson = new Object();
    						if(isCallBackTransient == false){
    							var form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
    							var id = form.down('#document_hidden_field');
    							if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
    								submitUrl = SERVERURL.STUDENT_DOCUMENT_SAVE;
    								successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
    							}else{
    								submitUrl = SERVERURL.STUDENT_DOCUMENT_UPDATE;
    								successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
    								if (grid.getSelectionModel().getCount() > 0) {
    									var records = grid.getSelectionModel().getSelection()[0];
    									documentJson.id = records.get("id");
    								}
    							}
    							var documentId = Ext.JSON.decode(response.responseText);
    							var student = new Object();
    							var document = new Object();
    							var admission = new Object();

    							student.id = studentId;
    							admission.id = admissionId;
    							document.id = documentId;
    							documentJson.student = student;
    							documentJson.document = document;
    							documentJson.admission = admission;
    							var docType = form.down('#documentTypeCombo').getValue();
    							var documentStatus = form.down('#documentStatus').getValue();
    							documentJson.documentType = {
    									id: docType
    							};
    							documentJson.documentStatusCSM = {
    									id: documentStatus
    							};
    							//documentJson.status = documentStatus;
    							Ext.Ajax.request({
    								type: 'rest',
    								url: submitUrl,
    								jsonData: documentJson,
    								method: 'POST',
    								success : function(){
    									this$.getDocumentController().closeDocumentFormWindow();
    									grid.getStore().reload();
    									grid.getSelectionModel().deselectAll();
    									showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
    								}
    							});

    						}
    					}

    				}, isTransient);
    			}else{//edit document with file 
    				this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'EXT_DOCUMENT', function(success, response, isCallBackTransient){
    					this$.hideWindowMask();
    					if(success){
    						var documentJson = new Object();
    						if(isCallBackTransient == false){
    							var form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
    							var id = form.down('#document_hidden_field');
    							if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
    								submitUrl = SERVERURL.STUDENT_DOCUMENT_SAVE;
    								successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
    							}else{
    								submitUrl = SERVERURL.STUDENT_DOCUMENT_UPDATE;
    								successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
    								if (grid.getSelectionModel().getCount() > 0) {
    									var records = grid.getSelectionModel().getSelection()[0];
    									documentJson.id = records.get("id");
    								}
    							}
    							var documentId = Ext.JSON.decode(response.responseText);
    							var student = new Object();
    							var document = new Object();
    							var admission = new Object();

    							student.id = studentId;
    							admission.id = admissionId;
    							document.id = documentId;
    							documentJson.student = student;
    							documentJson.document = document;
    							documentJson.admission = admission;
    							var docType = form.down('#documentTypeCombo').getValue();
    							var documentStatus = form.down('#documentStatus').getValue();
    							documentJson.documentType = {
    									id: docType
    							};
    							documentJson.documentStatusCSM = {
    									id: documentStatus
    							};
    							//documentJson.status = documentStatus;
    							Ext.Ajax.request({
    								type: 'rest',
    								url: submitUrl,
    								jsonData: documentJson,
    								method: 'POST',
    								success : function(){
    									this$.getDocumentController().closeDocumentFormWindow();
    									grid.getStore().reload();
    									grid.getSelectionModel().deselectAll();
    									showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
    								}
    							});

    						}
    					}

    				}, isTransient);
    			}
    		}else{//edit off line Document
    			this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'EXT_DOCUMENT', function(success, response, isCallBackTransient){
    				this$.hideWindowMask();
    				if(success){
    					var documentJson = new Object();
    					if(isCallBackTransient == false){
    						var form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
    						var id = form.down('#document_hidden_field');
    						if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
    							submitUrl = SERVERURL.STUDENT_DOCUMENT_SAVE;
    							successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
    						}else{
    							submitUrl = SERVERURL.STUDENT_DOCUMENT_UPDATE;
    							successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
    							if (grid.getSelectionModel().getCount() > 0) {
    								var records = grid.getSelectionModel().getSelection()[0];
    								documentJson.id = records.get("id");
    							}
    						}
    						var documentId = Ext.JSON.decode(response.responseText);
    						var student = new Object();
    						var document = new Object();
    						var admission = new Object();

    						student.id = studentId;
    						admission.id = admissionId;
    						document.id = documentId;
    						documentJson.student = student;
    						documentJson.document = document;
    						documentJson.admission = admission;
    						var docType = form.down('#documentTypeCombo').getValue();
    						var documentStatus = form.down('#documentStatus').getValue();
    						documentJson.documentType = {
    								id: docType
    						};
    						documentJson.documentStatusCSM = {
									id: documentStatus
							};
    						//documentJson.status = documentStatus;
    						Ext.Ajax.request({
    							type: 'rest',
    							url: submitUrl,
    							jsonData: documentJson,
    							method: 'POST',
    							success : function(){
    								this$.getDocumentController().closeDocumentFormWindow();
    								grid.getStore().reload();
    								grid.getSelectionModel().deselectAll();
    								showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
    							}
    						});

    					}
    				}

    			}, isTransient);
    		}
    	}else{//add document
    		if(!uploadBtn.isDisabled()){
    			form.down('#modeOfSubmission').setDisabled(false);
    			form.down('#modeOfSubmission').setVisible(true);
    			form.down('#modeOfSubmission').setValue('ONLINE');
    		}
    		this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'EXT_DOCUMENT', function(success, response, isCallBackTransient){
    			this$.hideWindowMask();
    			if(success){
    				var documentJson = new Object();
    				if(isCallBackTransient == false){
    					var form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
    					var id = form.down('#document_hidden_field');
    					if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
    						submitUrl = SERVERURL.STUDENT_DOCUMENT_SAVE;
    						successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
    					}else{
    						submitUrl = SERVERURL.STUDENT_DOCUMENT_UPDATE;
    						successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
    						if (grid.getSelectionModel().getCount() > 0) {
    							var records = grid.getSelectionModel().getSelection()[0];
    							documentJson.id = records.get("id");
    						}
    					}
    					var documentId = Ext.JSON.decode(response.responseText);
    					var student = new Object();
    					var document = new Object();
    					var admission = new Object();

    					student.id = studentId;
    					admission.id = admissionId;
    					document.id = documentId;
    					documentJson.student = student;
    					documentJson.document = document;
    					documentJson.admission = admission;
    					var docType = form.down('#documentTypeCombo').getValue();
    					var documentStatus = form.down('#documentStatus').getValue();
    					documentJson.documentType = {
    							id: docType
    					};
    					documentJson.documentStatusCSM = {
								id: documentStatus
						};
    					//documentJson.status = documentStatus;
    					Ext.Ajax.request({
    						type: 'rest',
    						url: submitUrl,
    						jsonData: documentJson,
    						method: 'POST',
    						success : function(response, action){
    							if (response.responseText == '0') {
    								form.down('#docDetails').setValue('');
    								showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('DOCUMENT_ALREADY_EXISTS'));
    							} else {
	    							this$.getDocumentController().closeDocumentFormWindow();
	    							grid.getStore().reload();
	    							grid.getSelectionModel().deselectAll();
	    							showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
    							}
    						}
    					});

    				}
    			}

    		}, isTransient);
    	}
    },
    showStudentOnlineDocumentFormWindow : function(){
		 var $this = this;
		 var formWindow = $this.getStudentonlinedocumentformwin();
		 if (!formWindow) {
			 Ext.widget('onlinedocumentformwin',{
				 itemId : 'studentOnlineDocumentFormWin'
			 });
			 formWindow = $this.getStudentonlinedocumentformwin();
		 }
		 
		 formWindow.show();
		 var feePayer= formWindow.down('#feePayerItemId');
		 feePayer.setVisible(false);
		 var documentName = formWindow.down('#documentNameItemId');
		 documentName.allowBlank = true;
		 var documentStatusCSM = formWindow.down('#documentStatus');
  	   	 documentStatusCSM.getStore().load({
  	   		 callback: function(records, operation, success) {
  	   			 for(var i in records){
  	   				 if(records[i].data.code =="SUBMITTED"){
  	   					 documentStatusCSM.setValue(records[i].data.id);
  	   				 }
  	   			 }
  	   		 } 
		});
	 },
	 showStudentPhysicalDocumentFormWindow : function(){
		 var $this = this;
		 var formWindow = $this.getStudentphysicaldocumentformwin();
		 if (!formWindow) {
			 Ext.widget('physicaldocumentformwin',{
				 itemId : 'studentPhysicalDocumentFormWin'
			 });
			 var formWindow = $this.getStudentphysicaldocumentformwin();
		 }
		 var modeSubmissionStore=formWindow.down('#modeOfSubmission').getStore();
		 modeSubmissionStore.on('load', function(){
			 for(var i=0; i< modeSubmissionStore.data.items.length;i++){
				 if(modeSubmissionStore.data.items[i].data.value == 'Online'){
					 modeSubmissionStore.removeAt(i);
				 } 
			 }
		 });
		 formWindow.down('#responsibleUserField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
		 var form = formWindow.down('#physicalDocumentFormItemId');
		 Ext.apply(form, {
			 isEditable: false
		 });
		 formWindow.show();
		 var documentName = formWindow.down('#documentNameItemId');
		 documentName.allowBlank = true;
		 var documentNote = formWindow.down('#documentNoteId');
		 documentNote.setVisible(false);
		 var documentStatusCSM = formWindow.down('#documentStatus');
    	   documentStatusCSM.getStore().load({
   		   callback: function(records, operation, success) {
   			  for(var i in records){
   				  if(records[i].data.code =="SUBMITTED"){
   					documentStatusCSM.setValue(records[i].data.id);
   				  }
   			  }
   		  } 
			  });
	 },
	 onChangeStudentPredefinedRadioGroup : function(formWin, newValue, formType) { // formType(ONLINE, PHYSICAL)
		 
	     	var store = formWin.down('#documentTypeCombo').getStore();
	     	var documentTypeCombo = formWin.down('#documentTypeCombo');
	     	var documentName = formWin.down('#documentNameItemId');
	     	var remarkItemId = formWin.down('#remarkItemId');
	     	if (formType == 'ONLINE') {
	     		formWin.down('#uploadFileField').reset();
	     		formWin.down('#docDetails').setValue('');
	     	}
	     	if (formType == 'PHYSICAL') {
	     		formWin.down('#responsibleUserField').reset();
	         	formWin.down('#modeOfSubmission').reset();
	     	}
	     	if(newValue.isPreDefined == false){
	     		documentTypeCombo.reset();
	     		documentName.reset();
	     		store.removeAll();
	     		documentTypeCombo.setVisible(false);
	     		documentName.setVisible(true);
	     		documentTypeCombo.allowBlank = true;
	     		documentName.allowBlank = false;
	     	} else {
	     		documentTypeCombo.reset();
	     		documentName.reset();
	     		store.load();
	     		documentTypeCombo.setVisible(true);
	     		documentName.setVisible(false);
	     		documentTypeCombo.allowBlank = false;
	     		documentName.allowBlank = true;
	     	}
	     	remarkItemId.reset();
		 },
			
		 loadStudentDocumentGridStore:function(grid, isElectronic) {
			 var this$ = this;
			 var personProfile = this$.getContentPanelActiveTab();
			 var studentId = personProfile.getUserId();
			 var portalId = this.getCurrentLoggedPortalId();
			 var personInfo =  personProfile.getPersonInfo();
			 var emailId = personInfo.emailId;
			 if( portalId == 7 )
				 {
				 studentId=localStorage.getItem("parentStudentId");
				 }
			 var admissionId = personProfile.getAdmissionId();
			 if(isNullOrEmpty(admissionId)) {
				 this$.getUserInfo(studentId); 
				 var studentInfo = this$.getCurrentlyLoggedInUserInfoForPortal();
				 admissionId = studentInfo.admissionDetails[0].id;
			 }
			 var store = grid.getStore();
			 this$.resetPageSetting(store);
			 
     		if(portalId == 3 || portalId == 7 ){
     			store.getProxy().extraParams = {
      				 studentId: studentId,
      				 admissionId : admissionId,
      				 emailId: emailId
      			 };
     		} else {
     			store.getProxy().extraParams = {
   				 studentId: studentId,
   				 admissionId : admissionId,
   				 isElectronic: isElectronic,
   				 emailId: emailId
   			 };
     		}
			 store.load();
		 },  
		 getUserInfo: function(studentId)
		 {
			 Ext.Ajax.request({
				 type: 'rest',
				 url: SERVERURL.BATCH_ID_BY_STUDENT_ID+'?studentId='+studentId,
				 method: 'GET',
				 async: false,
				 success: function(res, action) {
					 var data = Ext.decode(res.responseText);
					 var portalInfo = Academia.model.authentication.PortalInfoModel;
					 portalInfo.set('admissionDetails',data[0].admissionDetails);
					 portalInfo.set('student',data[0].student);
					 portalInfo.set('userAacademyLocations',data[0].userAacademyLocations);
					 portalInfo.set('programBatchDetails',data[0].programBatchDetails);
					 studentPortalInfo = { 
							 admissionDetails: portalInfo.get('admissionDetails'),
							 student:portalInfo.get('student'),
							 userAacademyLocations:portalInfo.get('userAacademyLocations'),
							 programBatchDetails:portalInfo.get('programBatchDetails')
					 };
				 }
			 });
		 },
		 /**
		     * Save document form 
		     */
		 saveOnlineStudentDocumentFormData: function(isElectronic){
			    var this$ = this;
		    	var successMsg, submitUrl;
		    	var personProfile = this$.getContentPanelActiveTab();
		    	var admissionId = personProfile.getAdmissionId();
		    	if(isNullOrEmpty(admissionId)) {
		    		var studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
		    		admissionId = studentInfo.admissionDetails[0].id;
		    	}
		    	var studentId = personProfile.getUserId();
		    	var personProfile = this.getContentPanelActiveTab();
                var grid = personProfile.down('#studentOnlineDocumentGridItemId');
		    	//var grid = this$.getStudentOnlineDocumentGrid();
		    	var isTransient = false;
		    	var module = 'student';
		    	var entityId = studentId;
		    	var entityType = 'student';
		    	var formWin = this$.getStudentonlinedocumentformwin();
		    	var form = formWin.down('#onlineDocumentFormItemId');
		    	var uploadBtn=formWin.down('#uploadFileField');
		    	var records =grid.getSelectionModel().getSelection()[0];
		    	if(!isNullOrEmpty(records)){
		    		var formData = null;
	    			var editedPath=form.down('#uploadFileField');
	    			var path=null;
	    			var fileField = form.down('#fileDisplayField');
	    			formData = form.getValues();    
	    			if(isNullOrEmpty(editedPath.getValue())){
	    				Ext.Ajax.request({
	    					type: 'rest',
	    					url: SERVERURL.DOCUMENT_FORM_FIND_BY + records.get("documentId"),
	    					method: 'GET',
	    					success: function(res, action) {
	    						var data = Ext.decode(res.responseText);
	    						if(!isEmpty(data)){
	    							if(!isNullOrEmpty(data.path)){
	    								path=data.path;
	    							}
	    						}
	    					}
	    				});
	    				
	    				this$.getDocumentController().saveDocumentFormValue(isTransient, 'ONLINE_DOC_FORM', true, formData, path, function(success, response, isCallBackTransient){
	    					this$.hideWindowMask();
	    					if(success){
	    						var documentJson = new Object();
	    						if(isCallBackTransient == false){
	    							var formWin = this$.getStudentonlinedocumentformwin();
	    			    	    	var form = formWin.down('#onlineDocumentFormItemId');
	    							var id = form.down('#document_hidden_field');
	    							if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
	    								submitUrl = SERVERURL.STUDENT_DOCUMENT_SAVE;
	    								successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
	    							}else{
	    								submitUrl = SERVERURL.STUDENT_DOCUMENT_UPDATE;
	    								successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
	    								if (grid.getSelectionModel().getCount() > 0) {
	    									var records = grid.getSelectionModel().getSelection()[0];
	    									documentJson.id = records.get("id");
	    								}

	    							}
	    							var documentId = Ext.JSON.decode(response.responseText);
	    							var student = new Object();
	    							var document = new Object();
	    							var admission = new Object();

	    							student.id = studentId;
	    							document.id = documentId;
	    							admission.id = admissionId;
	    							documentJson.student = student;
	    							documentJson.document = document;
	    							documentJson.admission = admission;
	    							var docType = form.down('#documentTypeCombo').getValue();
	    							var documentStatus = form.down('#documentStatus').getValue();
	    							var documentStatusCode="SUBMITTED";
			    					if(!isNullOrEmpty(documentStatus)){
			    						documentStatusCode=form.down('#documentStatus').store.getAt(form.down('#documentStatus').getStore().findExact('id',documentStatus)).get('code');
			    					}
	    							if(!isNullOrEmpty(docType)){
	    								documentJson.documentType = {
	        									id: docType
	        							};
	    							}
	    							if(!isNullOrEmpty(documentStatus)){
	    							documentJson.documentStatusCSM = {
	    									id: documentStatus,
	    									code:documentStatusCode
	    							};
	    						}
	    							Ext.Ajax.request({
	    								type: 'rest',
	    								url: submitUrl,
	    								jsonData: documentJson,
	    								method: 'POST',
	    								success : function(){
	    									this$.getStudentonlinedocumentformwin().close();
	    									grid.getStore().reload();
	    									grid.getSelectionModel().deselectAll();
	    									showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
	    								}
	    							});


	    						}
	    					}

	    				}, isTransient);

	    			} else {
	    				//edit document with file
	    				/*if(!isNullOrEmpty(records.data.documentType.id))
    					{
    					var otherDocTypeId = records.data.documentType.id;
    					}*/
	    				this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'ONLINE_DOC_FORM', function(success, response, isCallBackTransient){

	    					if(success){
	    						var documentJson = new Object();
	    						if(isCallBackTransient == false){
	    							var formWin = this$.getStudentonlinedocumentformwin();
	    			    	    	var form = formWin.down('#onlineDocumentFormItemId');
	    			    	    	var id = form.down('#document_hidden_field');
	    							if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
	    								submitUrl = SERVERURL.STUDENT_DOCUMENT_SAVE;
	    								successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
	    							}else{
	    								submitUrl = SERVERURL.STUDENT_DOCUMENT_UPDATE;
	    								successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
	    								if (grid.getSelectionModel().getCount() > 0) {
	    									var records = grid.getSelectionModel().getSelection()[0];
	    									documentJson.id = records.get("id");
	    								}

	    							}
	    							var documentId = Ext.JSON.decode(response.responseText);
	    							var student = new Object();
	    							var document = new Object();
	    							var admission = new Object();

	    							student.id = studentId;
			    					admission.id = admissionId;
			    					document.id = documentId;
			    					documentJson.student = student;
			    					documentJson.document = document;
			    					documentJson.isElectronic = true;
			    					documentJson.admission = admission;
	    							
	    							var docType = form.down('#documentTypeCombo').getValue();
	    							var documentStatus = form.down('#documentStatus').getValue();
	    							var documentStatusCode="SUBMITTED";
			    					if(!isNullOrEmpty(documentStatus)){
			    						documentStatusCode=form.down('#documentStatus').store.getAt(form.down('#documentStatus').getStore().findExact('id',documentStatus)).get('code');
			    					}
	    							if(!isNullOrEmpty(docType)){
	    								documentJson.documentType = {
	        									id: docType
	        							};
	    							}
	    							if(!isNullOrEmpty(documentStatus)){
	    							documentJson.documentStatusCSM = {
	    									id: documentStatus,
	    									code:documentStatusCode
	    							};
	    						}
	    							Ext.Ajax.request({
	    								type: 'rest',
	    								url: submitUrl,
	    								jsonData: documentJson,
	    								method: 'POST',
	    								success : function(){
	    									this$.getStudentonlinedocumentformwin().close();
	    									grid.getStore().reload();
	    									grid.getSelectionModel().deselectAll();
	    									showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
	    								}
	    							});
	    						}
	    					}
	    				}, isTransient/*,otherDocTypeId*/);
	    			
	    			}
		    	}else {
		    		/*var docTypeValue = formWin.down('#documentType');
		    		var ispredefinedCheck = docTypeValue.getValue();
		    		if(ispredefinedCheck.isPreDefined == false)
		    		{
		    			getDocTypeUrl = SERVERURL.CREATE_DOCUMENT_TYPE;
		    			var docType = new Object();
		    			var docName = formWin.down('#documentNameItemId').getValue();
		    			docType = {
		    					code:docName
		    			};
		    			var otherDocTypeId;
		    			Ext.Ajax.request({
		    				type: 'rest',
		    				url: getDocTypeUrl,
		    				jsonData: docType,
		    				async:false,
		    				method: 'POST',
		    				success : function(response){
		    					var documentTypeCombo = formWin.down('#documentTypeCombo');
		    					otherDocTypeId =response.responseText;
		    					documentTypeCombo.setValue(otherDocTypeId);
		    				}
		    			});
		    		}

*/
		    		this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'ONLINE_DOC_FORM', function(success, response, isCallBackTransient){
		    			if(success){
		    				var documentJson = new Object();
		    				if(isCallBackTransient == false){
		    					var formWin = this$.getStudentonlinedocumentformwin();
		    					var form = formWin.down('#onlineDocumentFormItemId');
		    					var id = form.down('#document_hidden_field');
		    					if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
		    						submitUrl = SERVERURL.STUDENT_DOCUMENT_SAVE;
		    						successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
		    					}else{
		    						submitUrl = SERVERURL.STUDENT_DOCUMENT_UPDATE;
		    						successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
		    						if (grid.getSelectionModel().getCount() > 0) {
		    							var records = grid.getSelectionModel().getSelection()[0];
		    							documentJson.id = records.get("id");
		    						}

		    					}
		    					var documentId = Ext.JSON.decode(response.responseText);
		    					var student = new Object();
		    					var document = new Object();
		    					var admission = new Object();

		    					student.id = studentId;
		    					admission.id = admissionId;
		    					document.id = documentId;
		    					documentJson.student = student;
		    					documentJson.document = document;
		    					documentJson.isElectronic = true;
		    					documentJson.admission = admission;
		    					var docType = form.down('#documentTypeCombo').getValue();
		    					var documentStatus = form.down('#documentStatus').getValue();
		    					var documentStatusCode="SUBMITTED";
		    					if(!isNullOrEmpty(documentStatus)){
		    						documentStatusCode=form.down('#documentStatus').store.getAt(form.down('#documentStatus').getStore().findExact('id',documentStatus)).get('code');
		    					}
		    					
		    					if(!isNullOrEmpty(docType)) {
		    						documentJson.documentType = {
		    								id: docType
		    						};
		    					}/*else{
		    						documentJson.documentType = {
		    								id: otherDocTypeId
		    						};
		    					}*/
		    					if(!isNullOrEmpty(documentStatus)){
	    							documentJson.documentStatusCSM = {
	    									id: documentStatus,
	    									code:documentStatusCode
	    							};
	    						}
		    					Ext.Ajax.request({
		    						type: 'rest',
		    						url: submitUrl,
		    						jsonData: documentJson,
		    						method: 'POST',
		    						success : function(response, action) {
		    							if (response.responseText == '0') {
		    								form.down('#docDetails').setValue('');
		    								showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('DOCUMENT_ALREADY_EXISTS'));
		    							} else {
		    								this$.getStudentonlinedocumentformwin().close();
		    								grid.getStore().reload();
		    								grid.getSelectionModel().deselectAll();
		    								showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
		    							}
		    						}
		    					});
		    				}
		    			}
		    		}, isTransient);
		    	}
		 },
		 editStudentOnlineDocumentFormWindow : function() {
			 var this$ = this;
			 var form = null;
			 var personProfile = this$.getContentPanelActiveTab();
             var grid = personProfile.down('#studentOnlineDocumentGridItemId');
             var portalId = this.getCurrentLoggedPortalId();
             var isRegDoc = false;

			// var grid=this.getStudentOnlineDocumentGrid();
			 if (grid.getSelectionModel().getCount() > 0) {
				 var records = grid.getSelectionModel().getSelection()[0];
				 
				 if(!isEmpty(records)){	
					 var isRegistrationDoc = records.get('isRegistrationDoc');
		     		 if(!isNullOrEmpty(isRegistrationDoc) && isRegistrationDoc){
		     				isRegDoc = true;
		     		 }
		     		 if(isRegDoc){
		     			showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getCommonTranslation('PLEASE_DO_NOT_SELECT_REGISTRATION_LETTER'));
		     		 }else{
					     if((portalId == 3 || portalId == 7) && records.raw.whetherRestrictUpdateDocument) {
							    var status = records.get("documentStatusCSM").value;
							     showWarningMessage(getCommonTranslation('ALERT'), status + " " +"Document can not be edited" );
						     }
			                 else {	
						     if((portalId == 3 || portalId == 7) && (!records.get('isElectronic'))){
								 showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'),getPersonModuleTranslation('PHYSICALLY_DOCUMENT_NOT_UPDATED'));
							 } else {

								 var documentId = records.get("documentId");
								 var documentStatus = records.get("documentStatusCSM");
								 var isPreDefined = records.get("isPreDefined");
								 var isFeePayerDocument = records.get("isFeePayerDocument");
								 var formWindow = this$.getStudentonlinedocumentformwin();
					             if (!formWindow) {
					            	  Ext.widget('onlinedocumentformwin',{
					                   	itemId : 'studentOnlineDocumentFormWin'
					                   });
					                 formWindow = this$.getStudentonlinedocumentformwin();
					             }
					             if (isNullOrEmpty(documentId)) {
					            	 formWindow.down('#documentTypeCombo').setValue(records.get('documentType'));
					             }else {
					            	 Ext.Ajax.request({
					                     type: 'rest',
					                     url: SERVERURL.DOCUMENT_FORM_FIND_BY + documentId,
					                     method: 'GET',
					                     success: function(res, action) {
					                     	var data = Ext.decode(res.responseText);
					                     	if(!isEmpty(data)){
					                     		var form = formWindow.down('#onlineDocumentFormItemId');
					                     		this$.setStudentOPDocumentFormValue(form, data);
					                     		
					                     	}
					                     }
					                     
					                 });
					             }
					             formWindow.show();
					             if(isFeePayerDocument){
					            	 formWindow.down('#documentType').setReadOnly(true);
					            	 formWindow.down('#documentTypeCombo').setReadOnly(true);
					            	 formWindow.down('#documentNameItemId').allowBlank = true;
					            	 formWindow.down('#documentType').setValue({isPreDefined:'feePayer'});
					            	 var associatedAcadLocationIds = new Array();
			                        associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
			                        var permissionList = Academia.utilities.accessControl.AccessControlManager
		                        	.checkFeaturePrivelages(associatedAcadLocationIds, this.getSTUDENT_ONLINE_DOCUMENTS_PERMISSIONS());
			                        var submitButton= formWindow.down('#documentFormSubmitButtonId');
			                        submitButton.setVisible(false);
			                        Ext.each(permissionList, function(privilege) {
		                        		if (privilege === 'FEE_PAYER_DOCUMENT') {
		                        			if(!isNullOrEmpty(submitButton)){
		                        				submitButton.setVisible(true);
		                        			}        		
		                        		}
		                        	});
					             }
								 else if(isPreDefined){
									 /*formWindow.down('#documentType').setValue(records.get('isPreDefined'));*/
								     formWindow.down('#documentType').setReadOnly(true);
									/* formWindow.down('#documentTypeCombo').setValue(records.get('documentType'));*/
									 formWindow.down('#documentTypeCombo').setReadOnly(true);
									 formWindow.down('#documentNameItemId').allowBlank = true;
								 }
								 else{
									 formWindow.down('#documentType').setValue({isPreDefined:records.get('isPreDefined')});
								     formWindow.down('#documentType').setReadOnly(true);
									 var documentName = formWindow.down('#documentNameItemId');
									 documentName.setVisible(true);
									 documentName.setValue(records.get('documentName'));
									 documentName.setReadOnly(true);
									 var documentTypeCombo = formWindow.down('#documentTypeCombo');
									 documentTypeCombo.setVisible(false);
									 formWindow.down('#documentType').setValue({isPreDefined:records.get('isPreDefined')});
								     formWindow.down('#documentType').setReadOnly(true);
								 }
								 var portalId = this$.getCurrentLoggedPortalId();
						    	 if(portalId==1) {
							    	 formWindow.down('#documentStatus').setReadOnly(false);
						    	 }
								/* formWindow.down('#remarkItemId').setValue(records.get('remark'));*/
								
				 				formWindow.down('#inspectionDoneByField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
							 }
						     }
			                 }
		     		 }

			 }else {
				 if(isRegDoc){
         			showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getCommonTranslation('PLEASE_DO_NOT_SELECT_REGISTRATION_LETTER'));
         		}else{
				 showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
         		}
			 }

		 },
	     savePhysicalStudentDocumentFormData: function(){  
	 		var this$ = this;
	     	var successMsg, submitUrl;
	     	var personProfile = this$.getContentPanelActiveTab();
	     	var studentId = personProfile.getUserId();
	     	var admissionId = personProfile.getAdmissionId();
	    	if(isNullOrEmpty(admissionId)) {
	    		var studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	    		admissionId = studentInfo.admissionDetails[0].id;
	    	}
            var grid = personProfile.down('#studentPhysicalDocumentGridItemId');
	     	var isTransient = false;
	     	var module = 'student';
	     	var entityId = studentId;
	     	var entityType = 'student';
	     	var formWin = this$.getStudentphysicaldocumentformwin();
	     	var form = formWin.down('#physicalDocumentFormItemId');
	     	var records =grid.getSelectionModel().getSelection()[0];
	     	
	    	var docTypeValue = formWin.down('#documentType');
    		var ispredefinedCheck = docTypeValue.getValue();
    		/*if(ispredefinedCheck.isPreDefined == false)
    		{
    			getDocTypeUrl = SERVERURL.CREATE_DOCUMENT_TYPE;
    			var docType = new Object();
    			var docName = formWin.down('#documentNameItemId').getValue();
    			docType = {
    					code:docName
    			};
    			var otherDocTypeId;
    			Ext.Ajax.request({
    				type: 'rest',
    				url: getDocTypeUrl,
    				jsonData: docType,
    				async:false,
    				method: 'POST',
    				success : function(response){
    					var documentTypeCombo = formWin.down('#documentTypeCombo');
    					otherDocTypeId =response.responseText;
    					documentTypeCombo.setValue(otherDocTypeId);
    				}
    			});
    		}*/
	     	
	 	    	this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'PHYSICAL_DOC_FORM', function(success, response, isCallBackTransient){
	  			if(success){
	  				var documentJson = new Object();
	  				if(isCallBackTransient == false){
	  					var formWin = this$.getStudentphysicaldocumentformwin();
	  	    	    	var form = formWin.down('#physicalDocumentFormItemId');
	  					var id = form.down('#document_hidden_field');
	  					if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
	  						submitUrl = SERVERURL.STUDENT_DOCUMENT_SAVE;
	  						successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
	  					}else{
	  						submitUrl = SERVERURL.STUDENT_DOCUMENT_UPDATE;
	  						successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
	  						if (grid.getSelectionModel().getCount() > 0) {
	  							var records = grid.getSelectionModel().getSelection()[0];
	  							documentJson.id = records.get("id");
	  						}

	  					}
	  					var documentId = Ext.JSON.decode(response.responseText);
	  					var student = new Object();
	  					var document = new Object();
	  					var admission = new Object();

	  					student.id = studentId;
	  					admission.id = admissionId;
	  					document.id = documentId;
	  					documentJson.student = student;
	  					documentJson.document = document;
	  					documentJson.isElectronic = false;
	  					documentJson.admission = admission;
	  					var docType = form.down('#documentTypeCombo').getValue();
	  					var documentStatus = form.down('#documentStatus').getValue();
	  					if(!isNullOrEmpty(docType)) {
    						documentJson.documentType = {
    								id: docType
    						};
    					}/*else{
    						documentJson.documentType = {
    								id: otherDocTypeId
    						};
    					}*/
	  					if(!isNullOrEmpty(documentStatus)){
							documentJson.documentStatusCSM = {
									id: documentStatus
							};
						}
	  					//documentJson.status = documentStatus;
	  					Ext.Ajax.request({
	  						type: 'rest',
	  						url: submitUrl,
	  						jsonData: documentJson,
	  						method: 'POST',
	  						success : function(response, action){
	  							if (response.responseText == '0') {
	 								showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('DOCUMENT_ALREADY_EXISTS'));
	 							} else {
	 								this$.getStudentphysicaldocumentformwin().close();
	 	 							grid.getStore().reload();
	 	 							grid.getSelectionModel().deselectAll();
	 	 							showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
	 							}
	  						}
	  					});
	  				}
	  			}
	  		}, isTransient/*,otherDocTypeId*/);
	 	 },
	 	 editStudentPhysicalDocumentFormWindow : function() {
	 		 var this$ = this;
	 		 var form = null;
	 		var personProfile = this$.getContentPanelActiveTab();
            var grid = personProfile.down('#studentPhysicalDocumentGridItemId');
	 		 //var grid=this.getStudentPhysicalDocumentGrid();
	 		 if (grid.getSelectionModel().getCount() > 0) {
	 			 var records = grid.getSelectionModel().getSelection()[0];
	 			 if(!isEmpty(records)){
	 				 var documentId = records.get("documentId");
	 				 var isPreDefined = records.get("isPreDefined");
	 				 var formWindow = this$.getStudentphysicaldocumentformwin();
	 				 var form = formWindow.down('#physicalDocumentFormItemId');
	 				 if (!formWindow) {
	 					 Ext.widget('physicaldocumentformwin',{
	 						 itemId : 'studentPhysicalDocumentFormWin'
	 					 });
	 					 formWindow = this$.getStudentphysicaldocumentformwin();
	 				 }
	 				 if (isNullOrEmpty(documentId)) {
	 					 formWindow.down('#documentTypeCombo').setValue(records.get('documentType'));
	 				 }else {
	 					 Ext.Ajax.request({
	 						 type: 'rest',
	 						 url: SERVERURL.DOCUMENT_FORM_FIND_BY + documentId,
	 						 method: 'GET',
	 						 success: function(res, action) {
	 							 var data = Ext.decode(res.responseText);
	 							 if(!isEmpty(data)){
	 								 var form = formWindow.down('#physicalDocumentFormItemId');
	 								 this$.setStudentOPDocumentFormValue(form, data);
	 							 }
	 						 }

	 					 });
	 				 }
	 				 var modeSubmissionStore=formWindow.down('#modeOfSubmission').getStore();
	 				 modeSubmissionStore.on('load', function(){
	 					 for(var i=0; i< modeSubmissionStore.data.items.length;i++){
	 						 if(modeSubmissionStore.data.items[i].data.value == 'Online'){
	 							 modeSubmissionStore.removeAt(i);
	 						 } 
	 					 }
	 				 });
	 				 formWindow.show();
	 				 if(isPreDefined){
	 					 /*formWindow.down('#documentType').setValue(records.get('isPreDefined'));*/
	 					 formWindow.down('#documentType').setReadOnly(true);
	 					 /* formWindow.down('#documentTypeCombo').setValue(records.get('documentType'));*/
	 					 formWindow.down('#documentTypeCombo').setReadOnly(true);
	 					 formWindow.down('#documentNameItemId').allowBlank = true;
	 				 }else{
	 					 formWindow.down('#documentType').setValue({isPreDefined:records.get('isPreDefined')});
	 					 formWindow.down('#documentType').setReadOnly(true);
	 					 var documentName = formWindow.down('#documentNameItemId');
	 					 documentName.setVisible(true);
	 					 documentName.setValue(records.get('documentName'));
	 					 documentName.setReadOnly(true);
	 					 var documentTypeCombo = formWindow.down('#documentTypeCombo');
	 					 documentTypeCombo.setVisible(false);
	 					 formWindow.down('#documentType').setValue({isPreDefined:records.get('isPreDefined')});
	 					 formWindow.down('#documentType').setReadOnly(true);
	 				 } 
	 				 form.down('#returnByField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
	 				 form.down('#responsibleUserField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
	 				 form.down('#inspectionDoneByField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
	 				 form.down('#documentStatus').setReadOnly(false);
	 				 form.down('#returnableRadioGroup').setVisible(true);
	 				 form.down('#returnDateField').setVisible(true);
	 				 form.down('#returnByField').setVisible(true);
	 				 form.down('#returnDateField').setMaxValue(new Date());
	 				 
					 var documentNote = formWindow.down('#documentNoteId');
					 documentNote.setVisible(false);
					 
	 				 form.getForm().findField('isReturnable').setValue({isReturnable:records.get('isReturnable')});
	 				 if(records.get('isReturnable')){
	 					 form.down('#returnableRadioGroup').setDisabled(false);
	 					 form.down('#returnDateField').setDisabled(false);
	 					 form.down('#returnByField').setDisabled(false);
	 				 }
	 			 }
	 		 }else {
	 			 showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	 		 }
	 	 },
	 	 setStudentOPDocumentFormValue : function(form, data){
		    	var this$ = this;
		    	var filePath = '';
		    	var uploadFileField = form.down('#uploadFileField');
		    	if(!isNullOrEmpty(data.path)){
		    		filePath = data.path;
		    		var filePathArray = new Array();
		    		if(filePath.indexOf('/') !=-1){
		    			filePathArray = filePath.split("/");
		    		}else if(filePath.indexOf('\\')){
		    			filePathArray = filePath.split("\\");
		    		}
		    		var length = filePathArray.length;
		    		if(length > 0){
		    			var fileName = "";
		    			filePath = filePathArray[length - 1];
		    			fileName = filePath;
		    			if(filePath.length > 30) {
		    				filePath = filePath.substring(0,29)+"...";
		    			}else{
		    				fileName = filePath;
		    			}
		    			filePath = '<a href="#" title="'+fileName+'">'+filePath+'</a>';
		    			
		    		}else{
		    			filePath = '';
		    		}
		    	}
		    	var fileDisplayField = Ext.create('Ext.Component',{
		            itemId: 'fileDisplayField',
		            width : 226,
		            autoEl: {
		                tag: 'a',
		                href: '#',
		                html: filePath
		            }
		        });
		    	
		    		form.getForm().setValues(data);
		    		if(!isNullOrEmpty(data.inspectionDoneBy)){
		    			localStorage.setItem('inspectionDoneBy',data.inspectionDoneBy.id);
		    		}
		    		
		    		form.down('#documentStatus').getStore().load();
		    		if(!isNullOrEmpty(data.documentStatusCSM)){
		    			form.down('#documentStatus').setValue(data.documentStatusCSM.id);
		    		}
		    		
		    		if(!isNullOrEmpty(data.documentType)) {
		    			form.down('#documentTypeCombo').setValue(data.documentType.id);
		    		}
		    		if(!isNullOrEmpty(data.returnedDate))
		    		{
		    			form.getForm().findField('returnedDate').setValue(dateRender(data.returnedDate));
		    		}
		    		form.getForm().findField('submissionDate').setValue(dateRender(data.submissionDate));
		    		form.getForm().findField('inspectionDate').setValue(dateRender(data.inspectionDate));
		    		form.getForm().findField('isInspectionDone').setValue({isInspectionDone:data.isInspectionDone});
		    		
		    		var portalId = this.getCurrentLoggedPortalId();
		    		if(portalId != 7 && portalId != 3 ) {
		    			form.down('#inspectionDoneRadioGroupField').setVisible(true);
			    		form.down('#inspectionDateField').setVisible(true);
			    		form.down('#inspectionDoneByField').setVisible(true);
			   // 		form.down('#inspectionDateField').setMaxValue(new Date());
		    		}
		    		form.down('#inspectionDateField').setMinValue(dateRender(data.submissionDate));
		    		//form.down('#returnDateField').setMinValue(dateRender(data.submissionDate));
		    		
		    		if(data.isInspectionDone){
		    			form.down('#inspectionDoneRadioGroupField').setDisabled(false);
		    			form.down('#inspectionDateField').setDisabled(false);
		    			form.down('#inspectionDoneByField').setDisabled(false);
		    			var inspectionDoneByField = form.down('#inspectionDoneByField');
		    			var inspectionDateField = form.getForm().findField('inspectionDate');
		    			var inspectStore=inspectionDoneByField.getStore();
		    			inspectStore.getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
		    			inspectStore.load({
		    				scope:this,
		    				callback: function(rec, callback){
		    					var preValue = data.inspectionDoneBy;
		    					if(!isNullOrEmpty(preValue)){
		    						inspectionDoneByField.setValue(preValue.id);
		    					}
		    					var preDateValue = data.inspectionDate;
		    					if(!isNullOrEmpty(preDateValue)){
		    						inspectionDateField.setValue(dateRender(preDateValue));
		    					}
		    				//	inspectionDateField.setMaxValue(new Date());
		    				}
		    			});
		    		}
		    		
		    		if(data.isReturnable){
		    			if(!isNullOrEmpty(data.returnedDate))
		    			{
		    				form.getForm().findField('returnedDate').setValue(dateRender(data.returnedDate));
		    			}
		    			if(!isNullOrEmpty(data.returnedBy))
		    			{
		    				var returnByField = form.down('#returnByField');
		    				var returnDateField = form.down('#returnDateField');
		    				var returnByStore=returnByField.getStore();
		    				returnByStore.load({
		    					scope:this,
		    					callback: function(rec, callback){
		    						var preValue = data.returnedBy;
		    						if(!isNullOrEmpty(preValue)){
		    							returnByField.setValue(preValue.id);
		    						}
		    						var preDateValue = data.returnedDate;
		    						if(!isNullOrEmpty(preDateValue)){
		    							returnDateField.setValue(dateRender(preDateValue));
		    						}
		    						returnDateField.setMaxValue(new Date());
		    					}
		    				});
		    			}
		    		}
		    		this$.loadFieldByDFR(form);
		 },
		 /**
	      * Delete Student document form
	      */
	     deleteStudentDocumentRecord : function(isOnlineFlag){
	     	var this$ = this;
	     	
	     	 if(isOnlineFlag == true) {
	     		var personProfile = this.getContentPanelActiveTab();
                var grid = personProfile.down('#studentOnlineDocumentGridItemId');
				// grid = this$.getStudentOnlineDocumentGrid();
			 } else {
				 //grid = this$.getdentPhysicalDocumentGrid();
				 var personProfile = this.getContentPanelActiveTab();
	             var grid = personProfile.down('#studentPhysicalDocumentGridItemId');
				 
			 }

	         if (grid.getSelectionModel().getCount() > 0) {
	             showConfirmMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	                 if (btn == 'yes') {
	                     if (grid.getSelectionModel().getCount() > 0) {
	                    	 var gridModel = grid.getSelectionModel().getSelection();
	                    		var id = [];
	                    		var isRegDoc = false;
	                    		gridModel.forEach(function(obj){
	                    			var isRegistrationDoc = obj.get('isRegistrationDoc');
	                    			if(!isNullOrEmpty(isRegistrationDoc) && isRegistrationDoc){
	                    				isRegDoc = true;
	                    			}{
		                    			id.push(obj.get('id'));
	                    			}
	                    		});
	                    		if(isRegDoc){
	                    			showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getCommonTranslation('PLEASE_DO_NOT_SELECT_REGISTRATION_LETTER'));
	                    		}else{
	                    			var delId = id.join();
		                         	Ext.Ajax.request({
		                                 type: 'rest',
		                                 url: SERVERURL.PATH_STUDENT_DELETE_DOCUMENT+'?studentDocumentIDs='+delId,
		                                 method: 'DELETE',
		                                 headers: {
		                                     'Content-Type': 'application/json'
		                                 },
		                                 success: function(form, action) {
		                                	this$.loadStudentDocumentGridStore(grid, isOnlineFlag);
		                                	grid.getSelectionModel().deselectAll();
		                                 	grid.getStore().reload();
		                                    showSuccessMessage(getPersonModuleTranslation('SUCCESS'), getPersonModuleTranslation('DOCUMENT_DELETE_SUCCESS'));
		                                     
		                                 }
		                             });
	                    		}
	                    		
	                     }
	                 }
	             });
	         } else {
	             showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	         }
	     },
	     /*
			 * On change of radio button Inspection Done  
			 */
	     studentOnSelectionIsInspectionDone : function(form){
				var this$ = this;
				var isInspectionDoneYesField = form.down('#isInspectionDoneYesField');
				if(isInspectionDoneYesField.getValue() == true){
					this$.studentShowHideInspectedField(false, form);
				}else{
					this$.studentShowHideInspectedField(true, form);
				}
				this$.studentChangeStatus(form);
		    },
		    studentChangeStatus:function(form){
		    	 var documentStatusCSM = form.down('#documentStatus');
				var values=form.getForm().getValues();
				var documentStatusCSM = form.down('#documentStatus');
				if(values.isReturnable==true){
					documentStatusCSM.getStore().load({
			 			   callback: function(records, operation, success) {
			 				  for(var i in records){
			 					  if(records[i].data.code =="RETURNED"){
			 						documentStatusCSM.setValue(records[i].data.id);
			 					  }
			 				  }
			 			  } 
			 		  });
				}else if(values.isInspectionRequired==true && values.isInspectionDone==false){
					documentStatusCSM.getStore().load({
			 			   callback: function(records, operation, success) {
			 				  for(var i in records){
			 					  if(records[i].data.code =="INSPECTED_PENDING"){
			 						documentStatusCSM.setValue(records[i].data.id);
			 					  }
			 				  }
			 			  } 
			 		  });
				}else{
					documentStatusCSM.getStore().load({
			 			   callback: function(records, operation, success) {
			 				  for(var i in records){
			 					  if(records[i].data.code =="SUBMITTED"){
			 						documentStatusCSM.setValue(records[i].data.id);
			 					  }
			 				  }
			 			  } 
			 		  });
				}
				form.getForm().checkValidity();
			},
		    studentShowHideInspectedField : function(isDisabled, form){
		    	var this$ = this;
		    	var inspectionDateField = form.down('#inspectionDateField'); 
		        var inspectionDoneByField = form.down('#inspectionDoneByField');
		        if(isDisabled){
		        	inspectionDateField.setValue('');
		        	inspectionDoneByField.clearValue();
		        }
		        else{
		        	var inspectStore=inspectionDoneByField.getStore();
					inspectStore.load({
		    			scope:this,
						callback: function(rec, callback){
							var currentUserId = this$.getCurrentlyLoggedInUser().id;
							var preValue = inspectionDoneByField.getValue();
							if(isNullOrEmpty(preValue)){
								inspectionDoneByField.setValue(currentUserId);
							}
							inspectionDoneByField.setValue(localStorage.getItem('inspectionDoneBy'));
							var preDateValue = inspectionDateField.getValue();
							if(isNullOrEmpty(preDateValue)){
								inspectionDateField.setValue(new Date());
							}
				//			inspectionDateField.setMaxValue(new Date());
						}
					});
		        }
		        inspectionDateField.setDisabled(isDisabled);
		        inspectionDoneByField.setDisabled(isDisabled);
		    },
		    getCheckedDocumentGrid: function(selmodel, record, index, action,grid){
         	   var $this = this;
         	   if(action == 'select'){
         		   if(selmodel.selected.length >1){
         			   grid.down('#btnEdit').setDisabled(true);
         		   }
         		   
         	   } else {
         		   if(selmodel.selected.length == 1){
         			   grid.down('#btnEdit').setDisabled(false);
         		   }
         		   
         	   }
            },
            showStudentPortalOnlineDocumentFormWindow : function(portalId){
            	var $this = this;
            	var formWindow = $this.getStudentportalonlinedocumentformwin();
            	if (!formWindow) {
            		Ext.widget('onlinedocumentformwin',{
            			itemId : 'studentPortalOnlineDocumentFormWin'
            		});
            		formWindow = $this.getStudentportalonlinedocumentformwin();
            	} 
            	formWindow.show();
            	var documentName = formWindow.down('#documentNameItemId');
            	documentName.allowBlank = true;
            },    
       	 /**
		     * Save STUDENT PORTAL document form 
		     */
		 saveOnlineStudentPortalDocumentFormData: function(isElectronic){
			    var this$ = this;
		    	var successMsg, submitUrl;
		    	var personProfile = this$.getContentPanelActiveTab();
		    	var admissionId = personProfile.getAdmissionId();
		    	if(isNullOrEmpty(admissionId)) {
		    		var studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
		    		admissionId = studentInfo.admissionDetails[0].id;
		    	}
		    	var studentId = personProfile.getUserId();
		    	var personProfile = this.getContentPanelActiveTab();
                var grid = personProfile.down('#studentDocumentGrid');
		    	//var grid = this$.getStudentOnlineDocumentGrid();
		    	var isTransient = false;
		    	var module = 'student';
		    	var entityId = studentId;
		    	var entityType = 'student';
		    	var formWin = this$.getStudentportalonlinedocumentformwin();
		    	var form = formWin.down('#onlineDocumentFormItemId');
		    	var uploadBtn=formWin.down('#uploadFileField');
		    	var records =grid.getSelectionModel().getSelection()[0];
		    	if(!isNullOrEmpty(records)){
		    		var formData = null;
	    			var editedPath=form.down('#uploadFileField');
	    			var path=null;
	    			var fileField = form.down('#fileDisplayField');
	    			formData = form.getValues();    
	    			if(isNullOrEmpty(editedPath.getValue())){
	    				Ext.Ajax.request({
	    					type: 'rest',
	    					url: SERVERURL.DOCUMENT_FORM_FIND_BY + records.get("documentId"),
	    					method: 'GET',
	    					success: function(res, action) {
	    						var data = Ext.decode(res.responseText);
	    						if(!isEmpty(data)){
	    							if(!isNullOrEmpty(data.path)){
	    								path=data.path;
	    							}
	    						}
	    					}
	    				});
	    				
	    				this$.getDocumentController().saveDocumentFormValue(isTransient, 'ONLINE_DOC_FORM', true, formData, path, function(success, response, isCallBackTransient){
	    					this$.hideWindowMask();
	    					if(success){
	    						var documentJson = new Object();
	    						if(isCallBackTransient == false){
	    							var formWin = this$.getStudentportalonlinedocumentformwin();
	    			    	    	var form = formWin.down('#onlineDocumentFormItemId');
	    							var id = form.down('#document_hidden_field');
	    							if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
	    								submitUrl = SERVERURL.STUDENT_DOCUMENT_SAVE;
	    								successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
	    							}else{
	    								submitUrl = SERVERURL.STUDENT_DOCUMENT_UPDATE;
	    								successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
	    								if (grid.getSelectionModel().getCount() > 0) {
	    									var records = grid.getSelectionModel().getSelection()[0];
	    									documentJson.id = records.get("id");
	    								}

	    							}
	    							var documentId = Ext.JSON.decode(response.responseText);
	    							var student = new Object();
	    							var document = new Object();
	    							var admission = new Object();

	    							student.id = studentId;
	    							document.id = documentId;
	    							admission.id = admissionId;
	    							documentJson.student = student;
	    							documentJson.document = document;
	    							documentJson.admission = admission;
	    							var docType = form.down('#documentTypeCombo').getValue();
	    							var documentStatus = form.down('#documentStatus').getValue();
	    							if(!isNullOrEmpty(docType)){
	    								documentJson.documentType = {
	        									id: docType
	        							};
	    							}
	    							if(!isNullOrEmpty(documentStatus)){
	    							documentJson.documentStatusCSM = {
	    									id: documentStatus
	    							};
	    						}
	    							//documentJson.status = documentStatus;
	    							Ext.Ajax.request({
	    								type: 'rest',
	    								url: submitUrl,
	    								jsonData: documentJson,
	    								method: 'POST',
	    								success : function(){
	    									this$.getStudentportalonlinedocumentformwin().close();
	    									grid.getStore().reload();
	    									grid.getSelectionModel().deselectAll();
	    									showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
	    								}
	    							});


	    						}
	    					}

	    				}, isTransient);

	    			} else {
	    				//edit document with file
	    				/*if(!isNullOrEmpty(records.data.documentType.id))
 					{
 					var otherDocTypeId = records.data.documentType.id;
 					}*/
	    				this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'ONLINE_DOC_FORM', function(success, response, isCallBackTransient){

	    					if(success){
	    						var documentJson = new Object();
	    						if(isCallBackTransient == false){
	    							var formWin = this$.getStudentportalonlinedocumentformwin();
	    			    	    	var form = formWin.down('#onlineDocumentFormItemId');
	    			    	    	var id = form.down('#document_hidden_field');
	    							if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
	    								submitUrl = SERVERURL.STUDENT_DOCUMENT_SAVE;
	    								successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
	    							}else{
	    								submitUrl = SERVERURL.STUDENT_DOCUMENT_UPDATE;
	    								successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
	    								if (grid.getSelectionModel().getCount() > 0) {
	    									var records = grid.getSelectionModel().getSelection()[0];
	    									documentJson.id = records.get("id");
	    								}

	    							}
	    							var documentId = Ext.JSON.decode(response.responseText);
	    							var student = new Object();
	    							var document = new Object();
	    							var admission = new Object();

	    							student.id = studentId;
			    					admission.id = admissionId;
			    					document.id = documentId;
			    					documentJson.student = student;
			    					documentJson.document = document;
			    					documentJson.isElectronic = true;
			    					documentJson.admission = admission;
	    							
	    							var docType = form.down('#documentTypeCombo').getValue();
	    							var documentStatus = form.down('#documentStatus').getValue();
	    							if(!isNullOrEmpty(docType)){
	    								documentJson.documentType = {
	        									id: docType
	        							};
	    							}
	    							if(!isNullOrEmpty(documentStatus)){
		    							documentJson.documentStatusCSM = {
		    									id: documentStatus
		    							};
		    						}
	    							//documentJson.status = documentStatus;
	    							Ext.Ajax.request({
	    								type: 'rest',
	    								url: submitUrl,
	    								jsonData: documentJson,
	    								method: 'POST',
	    								success : function(){
	    									this$.getStudentportalonlinedocumentformwin().close();
	    									grid.getStore().reload();
	    									grid.getSelectionModel().deselectAll();
	    									showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
	    								}
	    							});
	    						}
	    					}
	    				}, isTransient/*,otherDocTypeId*/);
	    			
	    			}
		    	}else {
		    		var docTypeValue = formWin.down('#documentType');
		    		/*var ispredefinedCheck = docTypeValue.getValue();
		    		if(ispredefinedCheck.isPreDefined == false)
		    		{
		    			getDocTypeUrl = SERVERURL.CREATE_DOCUMENT_TYPE;
		    			var docType = new Object();
		    			var docName = formWin.down('#documentNameItemId').getValue();
		    			docType = {
		    					code:docName
		    			};
		    			var otherDocTypeId;
		    			Ext.Ajax.request({
		    				type: 'rest',
		    				url: getDocTypeUrl,
		    				jsonData: docType,
		    				async:false,
		    				method: 'POST',
		    				success : function(response){
		    					var documentTypeCombo = formWin.down('#documentTypeCombo');
		    					otherDocTypeId =response.responseText;
		    					documentTypeCombo.setValue(otherDocTypeId);
		    				}
		    			});
		    		}
*/

		    		this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'ONLINE_DOC_FORM', function(success, response, isCallBackTransient){
		    			if(success){
		    				var documentJson = new Object();
		    				if(isCallBackTransient == false){
		    					var formWin = this$.getStudentportalonlinedocumentformwin();
		    					var form = formWin.down('#onlineDocumentFormItemId');
		    					var id = form.down('#document_hidden_field');
		    					if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
		    						submitUrl = SERVERURL.STUDENT_DOCUMENT_SAVE;
		    						successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
		    					}else{
		    						submitUrl = SERVERURL.STUDENT_DOCUMENT_UPDATE;
		    						successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
		    						if (grid.getSelectionModel().getCount() > 0) {
		    							var records = grid.getSelectionModel().getSelection()[0];
		    							documentJson.id = records.get("id");
		    						}

		    					}
		    					var documentId = Ext.JSON.decode(response.responseText);
		    					var student = new Object();
		    					var document = new Object();
		    					var admission = new Object();

		    					student.id = studentId;
		    					admission.id = admissionId;
		    					document.id = documentId;
		    					documentJson.student = student;
		    					documentJson.document = document;
		    					documentJson.isElectronic = true;
		    					documentJson.admission = admission;
		    					var docType = form.down('#documentTypeCombo').getValue();
		    					var documentStatus = form.down('#documentStatus').getValue();
		    					if(!isNullOrEmpty(docType)) {
		    						documentJson.documentType = {
		    								id: docType
		    						};
		    					}/*else{
		    						documentJson.documentType = {
		    								id: otherDocTypeId
		    						};
		    					}*/
		    					if(!isNullOrEmpty(documentStatus)){
	    							documentJson.documentStatusCSM = {
	    									id: documentStatus
	    							};
	    						}
		    					//documentJson.status = documentStatus;
		    					Ext.Ajax.request({
		    						type: 'rest',
		    						url: submitUrl,
		    						jsonData: documentJson,
		    						method: 'POST',
		    						success : function(response, action) {
		    							if (response.responseText == '0') {
		    								form.down('#docDetails').setValue('');
		    								showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('DOCUMENT_ALREADY_EXISTS'));
		    							} else {
		    								this$.getStudentportalonlinedocumentformwin().close();
		    								grid.getStore().reload();
		    								grid.getSelectionModel().deselectAll();
		    								showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
		    							}
		    						}
		    					});
		    				}
		    			}
		    		}, isTransient/*,otherDocTypeId*/);
		    	}
		 },
		 onChangeStudentPortalPredefinedRadioGroup : function(formWin, newValue, formType) { // formType(ONLINE, PHYSICAL)
			 
		     	var store = formWin.down('#documentTypeCombo').getStore();
		     	var documentTypeCombo = formWin.down('#documentTypeCombo');
		     	var documentName = formWin.down('#documentNameItemId');
		     	var remarkItemId = formWin.down('#remarkItemId');
		     	if (formType == 'ONLINE') {
		     		formWin.down('#uploadFileField').reset();
		     		formWin.down('#docDetails').setValue('');
		     	}
		     	if(newValue.isPreDefined == false){
		     		documentTypeCombo.reset();
		     		documentName.reset();
		     		store.removeAll();
		     		documentTypeCombo.setVisible(false);
		     		documentName.setVisible(true);
		     		documentTypeCombo.allowBlank = true;
		     		documentName.allowBlank = false;
		     	} else {
		     		documentTypeCombo.reset();
		     		documentName.reset();
		     		store.load();
		     		documentTypeCombo.setVisible(true);
		     		documentName.setVisible(false);
		     		documentTypeCombo.allowBlank = false;
		     		documentName.allowBlank = true;
		     	}
		     	remarkItemId.reset();
			 },
			 
			 loadFieldByDFR : function(form) {
				 var $this = this;
				 var isInspectionRadioGroupNotVisible = false;
				 var inspectionDoneField = form.down('#inspectionDoneRadioGroupField');
				 var inspectionDateField = form.down('#inspectionDateField');
				 var inspectionDoneByField = form.down('#inspectionDoneByField');
				 inspectionDoneField.setVisible(false);
				 inspectionDateField.setVisible(false);
				 inspectionDoneByField.setVisible(false);
				 Ext.Ajax.request({
					 type: 'rest',
					 async: false,
					 url: SERVERURL.COMMON_FORM_FIELD_INFO,
					 params: {
						 screenName: 'extendeddocumentform',
						 academyLocationId: $this.getCurrentAcademyLocation(),
						 languageCode:'en'
					 },
					 method: 'GET',
					 success: function(res, action) {
						 var response = Ext.decode(res.responseText);
						 if( Object.keys(response).length > 0 ){
							 var records=response.extendeddocumentform;
							 for(i in records){  
								 if(records[i].formFieldInputType=='radiogroup' && records[i].formFieldId=='inspectionDoneRadioGroupField' && records[i].isVisible==true){
									 inspectionDoneField.setVisible(true);
								 }
								 if(records[i].formFieldInputType=='datefield' && records[i].formFieldId=='inspectionDateField' && records[i].isVisible==true){
									 inspectionDateField.setVisible(true);
								 }
								 if(records[i].formFieldInputType=='livesearchcombo' && records[i].formFieldId=='inspectionDoneByField' && records[i].isVisible==true){
									 inspectionDoneByField.setVisible(true);
								 }
								 if(records[i].formFieldInputType=='radiogroup' && records[i].formFieldId=='inspectionDoneRadioGroupField' && records[i].isVisible==false){
									 isInspectionRadioGroupNotVisible = true;
								 }

							 }
						 }else{
							 if(inspectionDoneField!=null){
								 inspectionDoneField.setVisible(true);
							 }

							 if(inspectionDateField!=null){
								 inspectionDateField.setVisible(true);
							 }

							 if(inspectionDoneByField!=null){
								 inspectionDoneByField.setVisible(true);
							 }
						 }
					 }
				 });

				 if (isInspectionRadioGroupNotVisible) {
					 inspectionDoneField.items.items[0].setValue(true);
				 }
			 }
});
