/**
 * @author Vishal Joshi
 * 
 */
Ext.define('Academia.controller.placement.placementjob.PlacementJobController', {
	extend: 'Academia.controller.base.BaseController',
	// un-comment the model code if required.
	models : ['placement.placementjob.PlacementJobGridModel','placement.placementjob.PlacementJobModel',
	          'placement.placementjob.PlacementJobLocationModel'],
	stores : ['placement.placementjob.PlacementJobGridStore',
	          'placement.placementcampus.placementCampusCoordinatorStore',
	          'common.StatusComboStore','admission.admissionCycle.SelectionProcesses','admission.admissionCycle.SelectionProcessesStore',
	          'placement.placementjob.PlacementJobLocationStore','placement.placementjob.PlacementJobLocationSalaryRangeStore',
	          'examinationcenters.evaluation.evaluationPlanHeirarchy.DroolCalculationData',
	          'placement.placementcampus.PlacementCampusProgramPeriodALStore','placement.placementcampus.PlacementJobPostingROStore','placement.placementjob.PlacementJobLocationDesignationStore',
	          'placement.placementcampus.PlacementCampusStore','placement.placementjob.PlacementJobLocationListStore',
	          'course.CourseStageStore','course.PlacementSelectionStageStore','placement.placementjob.JobPostingDocumentStore'],
	views : ['placement.placementjob.PlacementJobTabStructure','placement.placementjob.PlacementJobLocationGrid',
	         'placement.placementjob.PlacementJobStructure','placement.placementjob.PlacementJobFilter',
	         'placement.placementjob.PlacementJobGrid','placement.placementjob.PlacementJobForm','baselayout.contentarea.ContentPanel', 
	         'placement.placementjob.PlacementJobLocationStructure','placement.placementjob.PlacementJobLocationDetailForm',
	         'placement.placementjob.ConfigureStageJobPostingWin', 'placement.placementjob.JobPostingDocumentGrid',
	         'placement.placementjob.JobPostingDocumentWin', 'placement.placementjob.JobPostingDocumentWinGrid'],
	config:{
		PLACEMENT_JOB_POSTING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PLACEMENT_JOB_POSTING_PRIVILEGES'),
	},	         
	refs : [
	        {
	        	ref : 'placementjobstructure',
	        	selector : 'placementjobstructure'
	        },{
	        	ref : 'placementjoblocationstructure',
	        	selector : 'placementjoblocationstructure'
	        },{
	        	ref : 'placementjobfilter',
	        	selector : 'placementjobfilter'
	        },{
	        	ref : 'placementjobLocationGrid',
	        	selector : 'placementjoblocationgrid'
	        },{
	        	ref: 'placementjobgrid',
	        	selector: 'placementjobgrid'
	        },{
	        	ref: 'contentpanel',
	        	selector: 'contentpanel'
	        },{
	        	ref: 'placementjobform',
	        	selector: 'placementjobform'
	        },{
	        	ref: 'placementjoblocationdetailform',
	        	selector: 'placementjoblocationdetailform'
	        },{
	        	ref : 'configureStageJobPostingWin',
	        	selector: 'configurestagejobpostingwin'
	        },{
	        	ref: 'jobpostingdocumentgrid',
	        	selector: 'jobpostingdocumentgrid'
	        },{
	        	ref: 'jobpostingdocumentwin',
	        	selector: 'jobpostingdocumentwin'
	        },{
	        	ref: 'jobpostingdocumentwingrid',
	        	selector: 'jobpostingdocumentwingrid'
	        }],
	        init : function() {
	        	this.control({
	        		'placementjobfilter button[itemId=searchBtn]': {
	        			click: this.loadPlacementJobGrid
	        		},
	        		'placementjobfilter button[itemId=resetBtn]': {
	        			click: this.resetPlacementJobFilter
	        		},
	        		'placementjobgrid' : {
	        			render: function(grid) {
	        	    		//this.doAccessControlValidation(grid, this.getPLACEMENT_JOB_POSTING_PERMISSIONS());
	        	    		// this.disableJobLocationsPivileges(grid, this.getPLACEMENT_JOB_POSTING_PERMISSIONS());
	        	    	},
	        			cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
	        				var $this = this;
		                    if (e.target.tagName == 'A') {
		                    	var placementJobGrid = this.getPlacementjobgrid();
		                    	if(placementJobGrid.getSelectionModel().getSelection()[0].data.jobPostingDocuments.length == 1) {
		                    		$this.getDocumentController().downloadDocumentFile(placementJobGrid.getSelectionModel().getSelection()[0].data.jobPostingDocuments[0].document.encryptedDocId);
		                    	} else {
		                            var formWindow = $this.getJobpostingdocumentwin();
		                            if (!formWindow) {
		                                Ext.widget('jobpostingdocumentwin');
		                                formWindow = $this.getJobpostingdocumentwin();
		                            }
		                            formWindow.show();
		                            var documentGrid = $this.getJobpostingdocumentwingrid();
		                            documentGrid.getStore().getProxy().extraParams = {
		                                placementJobId: record.data.id
		                            };
		                            documentGrid.getStore().load();
		                    	}
	                        }
		                }
	        		},
	        		'placementjobgrid button[itemId=btnDelete]':{
	        			click: this.deletePlacementJobRecord
	        		},
	        		'placementjoblocationdetailform button[itemId=addFilterBtn]':{
	        			click: function(obj){
	        				this.addMultipleDesignationPosSalaryfilter(obj);
	        			}
	        		},
	        		'placementjobgrid menuitem[itemId=btnJobLocations]':{
	        			click : function(){
         				   var $this = this;
         				   var grid = $this.getPlacementjobgrid();
         				  var filterGrid = $this.getPlacementjobgrid();
                   	      var record = filterGrid.getSelectionModel().getSelection()[0];

         				   if (grid.getSelectionModel().getCount() > 0) {
         					  this.ShowPlacementJobLocation();
         				   }else
         				   {
         					   showWarningMessage(getPlacementTranslation('JOB_LOCATIONS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
         				   }
         			   }
	        		},
	        		'placementjobgrid menuitem[itemId=btnConfigureStage]':{
	        			click : function(){
	        				var $this = this;
	        				var grid = $this.getPlacementjobgrid();
	        				var filterGrid = $this.getPlacementjobgrid();
	        				var record = filterGrid.getSelectionModel().getSelection()[0];
	        				if (grid.getSelectionModel().getCount() > 0) {
	        					this.ShowConfigureStageWindow(record);
	        				}else
	        				{
	        					showWarningMessage(getPlacementTranslation('JOB_LOCATIONS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	        				}
	        			}
	        		},
	        		'placementjobgrid button[itemId=btnAdd]':{
	        			click: this.addPlacementJobRecord
	        		},
	        		'placementjobgrid button[itemId=btnEdit]':{
	        			click: this.editPlacementJobRecord
	        		},
	        		'placementjoblocationgrid button[itemId=btnAdd]':{
	        			click: this.addPlacementJobLocationRecord
	        		},
	        		'placementjoblocationgrid button[itemId=btnView]':{
	        			click: this.viewPlacementJobLocationRecord
	        		},
	        		'placementjoblocationgrid button[itemId=btnEdit]':{
	        			click: this.editPlacementJobLocationRecord
	        		},
	        		'placementjoblocationgrid button[itemId=btnDelete]':{
	        			click: this.deletePlacementJobLocationRecord
	        		},
	        		'placementjobgrid button[itemId=btnView]':{
	        			click: this.viewPlacementJobRecord
	        		},
	        		'placementjobform button[itemId=submitBtn]':{
	        			click: this.savePlacementJobRecord
	        		},
	        		'placementjobform button[itemId=resetBtn]':{
	        			click: this.resetPlacementJobRecord
	        		},
	        		'placementjobform customcombobox[itemId=selectionStageCombo]':{
	        			select:function(obj,rec){
	        				var onSelectStageRadio = this.getPlacementjobform().down('#onSelectStage');
	        				onSelectStageRadio.setDisabled(false);
	        			}
	        		},
	        		'placementjobform customcombobox[itemId=placementcampusItemId]':{
	        			 select:function(obj,rec){
 	        				var data=rec[0].data.id;  
 	        				var jobForm=obj.up('form');
 	        				var jobFormField=jobForm.down('#academyLocation');
 	        				jobFormField.setDisabled(false);
 	        				jobFormField.reset();
 	        				jobFormField.getStore().getProxy().extraParams={
 	        					placementCampusId:data
 	        				};
 	        				jobFormField.getStore().load();
      							  var placementCampusdroolsRule =  jobForm.down('#eligibilityRule');
      							  placementCampusdroolsRule.reset();
      							   if(!isNullOrEmpty(rec[0].data.secondId)){
      								   var droolId=rec[0].data.secondId;
                 					  
                 					   placementCampusdroolsRule.getStore().load({
                 						   callback: function(records, operation, success) {
                 							   for(var i in records){
                 								   if(droolId==records[i].data.id){
                 									   placementCampusdroolsRule.setValue(records[i].data.id);
                 									   placementCampusdroolsRule.setReadOnly(true);
                 								   }
                 							   }

                 						   }
                 					   });
                 				   }else{
                 					   placementCampusdroolsRule.setReadOnly(true);
                 				   }
 	        			}
	        		},
	        		'configurestagejobpostingwin combo[itemId=selectionStage]':{
	        			 select:function(obj,rec){
	        				 var form = obj.up('form');
	        				var filterGrid = this.getPlacementjobgrid();
	        	      	    var record = filterGrid.getSelectionModel().getSelection()[0];
	        	      	    var selectionStageId=rec[0].get('id'); 
	        	      	    var placementJobId = record.get('id');
	        				
		        		   Ext.Ajax.request({method: "GET",type: 'rest',
		        			   url: SERVERURL.PLACEMENT_SELECTION_STAGE_LOAD+'?selectionProcessStageId='
		        			   +selectionStageId+'&placementJobId='+placementJobId+'&limit=-1&page=1&start=0',
		        			   success: function(response, action) {
		        				   var data = Ext.decode(response.responseText);
		                		   form.down("#minimumSeats").setValue(data.rows[0].minSeat);
		                		   form.down("#maximumSeats").setValue(data.rows[0].maxSeat);
		                		   form.down("#entryCriteria").setValue(data.rows[0].entryRule);
		                		   form.down("#exitCriteria").setValue(data.rows[0].exitRule);
		                		   form.down("#entryRuleDescription").setValue(data.rows[0].entryRuleDescription);
		                		   form.down("#exitRuleDescription").setValue(data.rows[0].exitRuleDescription);
		                		   form.down("#startDate").setValue(dateRender(data.rows[0].startDate));
		                		   form.down("#endDate").setValue(dateRender(data.rows[0].endDate));
		                		   form.getForm().findField("id").setValue(data.rows[0].id);
		                    	 }
		        		   });
	        			}
	        		},
	        		'placementjobform customcombobox[itemId=eligibilityRule]':{
	        			 select:function(obj,rec){
	        				var data=rec[0].data.id;  
	        				var jobForm=obj.up('form');
	        				var eligibilityRuleField=jobForm.down('#eligibilityRule');
	        				eligibilityRuleField.getStore().getProxy().extraParams={
	        					moduleName:'PLACEMENT'
	        				};
	        				eligibilityRuleField.getStore().load();
	        			}
	        		},
	        	    'placementjobform': {
	        	    	render: function(form) {
	        	    		var eligibilityRuleField=form.down('#eligibilityRule');
	        				eligibilityRuleField.getStore().getProxy().extraParams={
	        					moduleName:'PLACEMENT'
	        				};	
	        	    	}
	        	    },
	        		
	        		'placementjobform customcombobox[itemId=campusCoordinator]':{
	        			render: function(obj) {
         				   var $this = this;
         				   var form = $this.getPlacementjobform().getForm();
         				   var store = form.findField('coordinator').getStore();
         				   store.getProxy().extraParams={
         					   roleName:'FACULTY',
 	        					academyLocationId:this.getCurrentAcademyLocation()
         				   }
         			   }
	        		},
	        		'placementjobform button#jobPostingDocumentUploadId': {
	                    click: function() {
	                        this.getDocumentController().showDocumentFormWindow('placementjobformItemId', 'DOCUMENT');
	                    }
	                },
	                'documentformwindow[itemId=placementjobformItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId': {
	                    click: function() {
	                        var $this = this;
	                        var isTransient = true;
	                        var module = 'placement';
	                        var entityId;
	                        var entityType = 'itemdocument';
	                        var entryType = $this.getPlacementjobform().getForm().getValues().entryType;
	                        var documentGrid = $this.getJobpostingdocumentgrid();
	                        var documentModel = new Academia.model.placement.placementjob.JobPostingDocumentModel();
	                        
	                        $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient) {
	                            
	                            documentModel.set("documentName", response.name);
	                            documentModel.set("path", response.path);
	                            documentModel.set("type", response.type);
	                            documentModel.set("documentName", response.name);
	                            documentModel.set("isNewRecord", true);
	                            documentModel.set("createdBy", $this.getIdValueJson(response.createdBy.id, response.createdBy.value));

	                            var store = documentGrid.getStore();
	                            store.add(documentModel);
	                            if (documentGrid.isHidden() && store.data.items.length > 0) {
	                                documentGrid.setVisible(true);
	                            }
	                            Ext.apply(documentGrid, {
	                                code: null,
	                                setCode: function(code) {
	                                    documentGrid.code = code;
	                                },
	                                getCode: function() {
	                                    return documentGrid.code;
	                                }
	                            });
	                            documentGrid.setCode(documentModel);
	                            $this.getDocumentController().closeDocumentFormWindow();
	                        }, isTransient);
	                    }
	                },
	                'documentformwindow[itemId=fdadditementryformItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId': {
	                    click: function() {
	                        this.getDocumentController().closeDocumentFormWindow();
	                    }
	                },
	                'jobpostingdocumentgrid button#btnDelete': {
	                    click: function() {
	                        this.deleteDocumentFromGrid();
	                    }
	                },
	                'jobpostingdocumentgrid': {
	                    cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	                        var $this = this;
	                        var documentGrid = $this.getJobpostingdocumentgrid();
	                        var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

	                        if (columnName == "documentName") {
	                            if (e.target.tagName == 'A') {
	                                var documentId = record.data.document.encryptedDocId;
	                                if (!isNullOrEmpty(documentId)) {
	                                    $this.getDocumentController().downloadDocumentFile(documentId);
	                                }
	                            }
	                        }
	                    }
	                },
	                'jobpostingdocumentwingrid button[itemId=btnDownloadDispatchForms]':{
	    				click:function(obj){
	    					this.downloadAllDescriptionDocumentFormsZip();
	    				}
	    			},
	    			'jobpostingdocumentwingrid button[itemId=btnDelete]':{
	    				click:function(obj){
	    					this.deleteMultipleJobPostingDocument();
	    				}
	    			},
	    			'jobpostingdocumentwingrid':{
	    				cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
	    					var $this = this;
	    					if (e.target.tagName == 'A' && Ext.isDefined(Ext.ComponentQuery.query("placementjobgrid")[0])) {
	    						var grid=$this.getJobpostingdocumentwingrid();
	    						if (grid.getSelectionModel().getCount() > 0) {
	    							var documentId = grid.getSelectionModel().getSelection()[0].data.document.encryptedDocId;
	    							$this.getDocumentController().downloadDocumentFile(documentId);
	    						}
	    					}
	    				}
	    			},
	        		'placementjoblocationdetailform customcombobox[itemId=campusCoordinator]':{
	        			render: function(obj) {
	         				   var $this = this;
	         				   var form = $this.getPlacementjoblocationdetailform().getForm();
	         				   var store = form.findField('coordinatorId').getStore();
	         				   store.getProxy().extraParams={
	         					   roleName:'FACULTY',
	 	        					academyLocationId:this.getCurrentAcademyLocation()
	         				   }
	         			   }
		        		},
	        		  'placementjoblocationdetailform button[itemId=SubmitBtn]':{
	        			  click : function(){
	        				  this.savePlacementJobLocationDetailsRecord();
	        			  }
	        	    },
	        		  'placementjoblocationdetailform button[itemId=resetBtn]':{
	        			  click: this.resetPlacementJobLocationForm
	        	    },
	        	    'configurestagejobpostingwin button[itemId=CancelBtn]':{
	        	    	click : function(obj){
	        	    		obj.up('window').close();
	        	    	}
	        	    },
	        	    'configurestagejobpostingwin button[itemId=SubmitBtn]':{
	        	    	click : this.saveConfigureStage
	        	    }
	        	});
	        },
	        
	        /**
	 	    * Add multiple Job Location Detail filter in panel
	 	    */
	    addMultipleDesignationPosSalaryfilter:function(obj){
	 	   	   var $this = this;
	 	   	   var stopContiner = $this.getPlacementjoblocationdetailform().down('#jobDetailContainerId');
	 	   	  // var timeFieldsCount = stopContiner.items.length;
	 	   	   var panelItem = new Array();
	 	   	   var fieldContainer=obj.up('fieldcontainer');
	 	   	   var newcont=stopContiner.items.items.length;
	 		   var insertPosition=newcont+1;
	 	   	   panelItem.push({
	 				xtype : 'fieldcontainer',
	 				width: '100%',
	 				layout : 'hbox',
	 				defaults: {
	 					labelAlign: 'top'
	 				},
	 				items : [{
	 					xtype: 'customcombobox',
		                name: 'designation',
		                itemId: 'designation1',
//		                fieldLabel: getPlacementTranslation('PLACEMENT_JOB_DESIGNATION'),
		                editable: true,
		                valueField: 'id',
		                displayField: 'value',
		                store: 'placement.placementjob.PlacementJobLocationDesignationStore',
//		                allowBlank:false
		              
	 				},{
	 					xtype: 'numberfield',
						itemId: 'noOfPosition1',
//						 fieldLabel: getPlacementTranslation('PLACEMENT_JOB_NO_OF_POSITIONS'),
						labelAlign: 'top',
						width: 130,
						name: 'noOfPosition',
						minValue: 0,
	                    allowDecimals:false,
//	                    allowBlank: false,
			        	hideTrigger:true,
			        	mouseWheelEnabled:false
	 				},{
	 					xtype: 'customcombobox',
		                itemId:'salaryPackage1',
		                disabled:false,
		                editable: true,
		                displayField: 'value',
		                valueField: 'id',
		                store: 'placement.placementjob.PlacementJobLocationSalaryRangeStore',
		                queryMode: 'local',
//		                allowBlank:true,
//		                fieldLabel: getPlacementTranslation('PLACEMENT_JOB_LOCATION_SALARY_PACKAGE'),
		                name: 'salaryPackage'
		              
	 				},{
	 					xtype: 'button',
	 					itemId: 'delFilterBtn',
	 					cls: 'CustomBodyBtnReject',
	 					glyph: ICONGLYPH.DELETEGLYPH,
	 					tooltip: getCommonTranslation('DELETE'),
	 					listeners:{
	 						click:function(obj){
	 						   var container = obj.up('fieldcontainer');
	 	   					   var panelContiner = $this.getPlacementjoblocationdetailform().down('#jobDetailContainerId');
	 	   					   panelContiner.remove(container);
	 					}}
	 				},{
	 					xtype: 'button',
	 					itemId: 'addFilterBtn',
	 					cls: 'CustomBodyBtnSettings',
	 					text: getCommonTranslation('ADDBUTTONTEXT'),
	 					tooltip: getCommonTranslation('ADD')
	 				  }]
	 				});
	 	     	stopContiner.insert(insertPosition,panelItem);
	 	     	stopContiner.doLayout();
	 	      },

	        loadPlacementJobGrid:function(){
	        	var $this=this;
	        	var form = $this.getPlacementjobfilter();
	        	var recruitingOrgnizationId = form.down("#academyLocation").getValue();
	        	var jobLocationId = form.down("#jobLocation").getValue();
	        	var placementCampusId = form.down("#placementcampusItemId").getValue();
	        	var status = form.down("#statusItemId").getValue();
	        	var grid = $this.getPlacementjobgrid();
	        	var store =  grid.getStore();

	        	store.getProxy().extraParams = {
	        		recruitingOrgnizationId: recruitingOrgnizationId,
	        		jobLocationId: jobLocationId,
	        		placementCampusId: placementCampusId,
	        		status: status
          	   };
	        	$this.resetPageSetting(store);
	        	store.load();
	        	/*pdf & excel report header filter*/
	        	grid.config.searchFilterForm = $this.getPlacementjobfilter();
	        },
	        resetPlacementJobRecord:function(){
         	   var form = this.getPlacementjobform().getForm().reset();
         	   var documentGrid = this.getJobpostingdocumentgrid();
	            var docStore = documentGrid.getStore();
	            if (docStore) {
	            	docStore.removeAll();
	            }
            },
	        ShowPlacementJobLocation:function(){
	        	
	           var $this=this;
           	   var tabName = getPlacementTranslation('JOB_LOCATIONS');
           	   var contentPanel = this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
           	   var structure = Ext.widget('placementjoblocationstructure');
           	   /**
           	    * This is to remove tab from content panel and open same tab again
           	    */
           	   var getcontroller=this.getController('menu.CoreERPNavigationController');
           	   var getTab=getcontroller.getTab(tabName);
           	   var $this=this;
           	   var filterGrid = $this.getPlacementjobgrid();
      	       var record = filterGrid.getSelectionModel().getSelection()[0];
           	   
           	   var grid = $this.getPlacementjobLocationGrid();
           	   grid.getStore().getProxy().extraParams={
           		  placementJobId:record.data.id
           	   };
           	   grid.getStore().load();
           	   if(getTab!=null){
           		   contentPanel.remove(getTab, true);
           	   }
           	   openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
	        }, 
	        resetPlacementJobFilter:function(){
	        	var $this=this;
	        	var filter = $this.getPlacementjobfilter().getForm();
	        	filter.reset();
	        },
	        deletePlacementJobLocationRecord:function(){
	        	var $this=this;
	        	var grid = $this.getPlacementjobLocationGrid();
	        	if (grid.getSelectionModel().getCount() > 0) {
	        		showConfirmMessage(getPlacementTranslation('PLACEMENT_JOB_LOCATION_DETAILS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	        			if (btn == 'yes') {
	        				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        				var records = grid.getSelectionModel().getSelection();
	        				var id = records[0].get("id");
	        				Ext.Ajax.request({
	        					method : "DELETE",
	        					type : 'rest',
	        					url : SERVERURL.PATH_PLACEMENT_JOB_LOCATION_DELETE+'?id='+ id,
	        					headers : {
	        						'Content-Type' : 'application/json'
	        					},
	        					success : function(form,action) {
	        						Ext.getBody().unmask();
	        						grid.getStore().reload();
	        						showSuccessMessage(getPlacementTranslation('PLACEMENT_JOB_LOCATION_DETAILS'),getPlacementTranslation('PATH_PLACEMENT_JOB_LOCATION_DELETED_SUCCESSFULLY'));
	        					}

	        				});
	        			}
	        		});
	        	}else {
	        		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	        	}
	        	
	        },resetPlacementJobLocationForm:function(){
		        this.getPlacementjoblocationdetailform().reset(); 
	        },
	        deletePlacementJobRecord:function(){
	        	var $this=this;
	        	var grid = $this.getPlacementjobgrid();
	        	if (grid.getSelectionModel().getCount() > 0) {
	        		showConfirmMessage(getPlacementTranslation('PATH_PLACEMENT_JOB'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	        			if (btn == 'yes') {
	        				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        				var records = grid.getSelectionModel().getSelection();
	        				var id = records[0].get("id");
	        				Ext.Ajax.request({
	        					method : "DELETE",
	        					type : 'rest',
	        					url : SERVERURL.PATH_PLACEMENT_JOB_DELETE+'?id='+ id,
	        					headers : {
	        						'Content-Type' : 'application/json'
	        					},
	        					success : function(form,action) {
	        						Ext.getBody().unmask();
	        						grid.getStore().reload();
	        						showSuccessMessage(getPlacementTranslation('PATH_PLACEMENT_JOB'),getPlacementTranslation('PATH_PLACEMENT_JOB__DEL_SUCCESS_MSG'));
	        					},
							 /*   failure: function(form, action) {

									Ext.getBody()
											.unmask();
									grid.getStore()
											.reload();
											showWarningMessage(
											getCommonTranslation('ALERT'),
											"PlacementJob"+getPlacementTranslation('RECORD_IS_IN_USE'));
							    }
*/
	        				});
	        			}
	        		});
	        	}else {
	        		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	        	}
	        },
	        addPlacementJobRecord:function(){
	        	var contentPanel = this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
	        	var structure = Ext.widget('placementjobform');
	        	var tabName = getPlacementTranslation('PLACEMENT_JOB_DETAILS');
	        	/**
	        	 * This is to remove tab from content panel and open same tab again
	        	 */
	        	var getcontroller=this.getController('menu.CoreERPNavigationController');
	        	var getTab=getcontroller.getTab(tabName);
	        	if(getTab!=null){
	        		contentPanel.remove(getTab, true);
	        	}
	        	var documentGrid = this.getJobpostingdocumentgrid();
	            var docStore = documentGrid.getStore();
	            if (docStore) {
	            	docStore.removeAll();
	            }
	        	openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);		
	        },
	        addPlacementJobLocationRecord:function(){
	        	var contentPanel = this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
	        	var structure = Ext.widget('placementjoblocationdetailform');
	        	var tabName = getPlacementTranslation('PLACEMENT_JOB_LOCATION_DETAILS');
	        	/**
	        	 * This is to remove tab from content panel and open same tab again
	        	 */
	        	var getcontroller=this.getController('menu.CoreERPNavigationController');
	        	var getTab=getcontroller.getTab(tabName);
	        	if(getTab!=null){
	        		contentPanel.remove(getTab, true);
	        	}
	        	openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
	        	
	        	var filterGrid = this.getPlacementjobgrid();
	        	var record = filterGrid.getSelectionModel().getSelection()[0];

	        	var placementJobLocationForm = this.getPlacementjoblocationdetailform();
	        	placementJobLocationForm.getForm().findField('placementJobId').setValue(record.data.id);


	        },
	        viewPlacementJobLocationRecord:function(){
	        	var $this = this;
	        	$this.editPlacementJobLocationRecord();
	        	var form =  $this.getPlacementjoblocationdetailform();
	        	var Placementjoblocationdetailform = form.getForm();
	        	$this.toggleReadOnlyFormItems(Placementjoblocationdetailform,true);
	        	form.down('#SubmitBtn').setVisible(false);
	        	form.down('#resetBtn').setVisible(false);
	        },
	        viewPlacementJobRecord:function(){
	        	var $this = this;
	        	$this.editPlacementJobRecord();
	        	var form =  $this.getPlacementjobform();
	        	var Placementjobform = form.getForm();
	        	$this.toggleReadOnlyFormItems(Placementjobform,true);
	        	var grid=$this.getJobpostingdocumentgrid();
	        	grid.down('#btnDelete').setVisible(false);
	        	form.down('#submitBtn').setVisible(false);
	        	form.down('#jobPostingDocumentUploadId').setVisible(false);
	        },
	        editPlacementJobLocationRecord:function(){
	        	 var $this = this;
	        	   var grid = $this.getPlacementjobLocationGrid();
	        	   if (grid.getSelectionModel().getCount() > 0) {
	        		   $this.addPlacementJobLocationRecord();
	        		   var form = $this.getPlacementjoblocationdetailform();
	        		   var record = grid.getSelectionModel().getSelection()[0];
	        		   var id = record.get("id");
	        		   var editUrl = SERVERURL.PLACEMENT_JOB_LOCATION_FINDBYID;
	        		   Ext.Ajax.request({
	        			   method: "GET",
	        			   type: 'rest',
	        			   url: editUrl,
	        			   params: {
	        				   id: id
	        			   },
	        			   success: function(f, action) {
	        				   var data = Ext.decode(f.responseText);
	        				   
	        				   form.down('#addFilterBtn').setVisible(false);
	        				   form.down('#resetBtn').setVisible(false);
	        				   
	        				   var plcamentJobLocationID =  form.getForm().findField("id");

	        				   plcamentJobLocationID.setValue(data.id);
	        				   
	        				   if(data.placementJobLocationMasterId){
	        					   var placementJobAcademyLocation =  form.down("#academyLocation");
	        					   placementJobAcademyLocation.getStore().load({
	        						   callback: function(records, operation, success) {
	        							   placementJobAcademyLocation.setValue(data.placementJobLocationMasterId);
	        						   }
	        					   });
	        				   }
	      				     
	        				   if(data.coordinatorId){
	        					   var placementJobCampusCoordinator =  form.down("#campusCoordinator");
	        					   placementJobCampusCoordinator.getStore().load({
	        						   callback: function(records, operation, success) {
	        							   placementJobCampusCoordinator.setValue(data.coordinatorId);
	        						   }
	        					   });
	        				   }
	      				   
	      				   if(data.placementDesignationId){
	      					   var placementJobDesignation =  form.down("#designation");
	      					   placementJobDesignation.getStore().load({
	      						   callback: function(records, operation, success) {
	      							   placementJobDesignation.setValue(data.placementDesignationId);
	      						   }
	      					   });
	      				   }
	      				 
	      				if(data.noOfPosition){
	      					   var placementJobnoOfPosition =  form.down("#noOfPosition");

	          			 placementJobnoOfPosition.setValue(data.noOfPosition);
	          					 
	    				     }
	      				if(data.salaryPackageId){
	      					   var placementJobsalaryPackage =  form.down("#salaryPackage");
	      					 placementJobsalaryPackage.getStore().load({
	          					   callback: function(records, operation, success) {
	          						 placementJobsalaryPackage.setValue(data.salaryPackageId);
	          					   }
	          				   });
	    				     }
	      					// form.down("#academyLocation").setValue(dataModel.data.academyLocationName.value);
	                    	 }
	        		   });
	        	   }else{
	        		   showWarningMessage(getPlacementTranslation('JOB_LOCATIONS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	        	   }
	        	
	        },
	        editPlacementJobRecord:function(){
         	   var $this = this;
        	   var grid = $this.getPlacementjobgrid();

        	   if (grid.getSelectionModel().getCount() > 0) {
        		   
        		   $this.addPlacementJobRecord();
        		   var form = this.getPlacementjobform();
        		   var record = grid.getSelectionModel().getSelection()[0];
        		   var id = record.get("id");
        		   var editUrl = SERVERURL.PLACEMENT_JOB_FINDBYID;
        		   Ext.Ajax.request({
        			   method: "GET",
        			   type: 'rest',
        			   url: editUrl,
        			   params: {
        				   id: id
        			   },
        			   success: function(f, action) {
        				   var data = Ext.JSON.decode(f.responseText);
       				       var dataModel =  new Academia.model.placement.placementjob.PlacementJobGridModel(data);
      				       form.loadRecord(dataModel);
      				     form.down('#resetBtn').setVisible(false);
      				    var documentGrid = $this.getJobpostingdocumentgrid();
      		            var docStore = documentGrid.getStore();
      	                docStore.getProxy().extraParams = {
      	                	placementJobId: dataModel.data.id
      	                };
      	                docStore.load();
      				     if(data.placementCampusId){
        					   var placementcampusItemId =  form.down("#placementcampusItemId");
        					   placementcampusItemId.getStore().load({
            					   callback: function(records, operation, success) {
            						   placementcampusItemId.setValue(data.placementCampusId);
            					   }
            				   });
      				     }
      				     
      				   // form.down("#onSelectStage").setValue(data.whetherSelectionInBatches[0].id);
      				    var onSelectStage=form.down('#onSelectStage');
      				       onSelectStage.setDisabled(false);
      				    if(data.whetherSelectionInBatches){
      				    	onSelectStage.items.items[0].setValue(true);
      				    	onSelectStage.items.items[1].setValue(false);
      				    }else{
      				    	onSelectStage.items.items[0].setValue(false);
      				    	onSelectStage.items.items[1].setValue(true);
      				    }
      				     if(data.academyLocationId){
      					   var academyLocation =  form.down("#academyLocation");
      					   academyLocation.getStore().load({
          					   callback: function(records, operation, success) {
          						   academyLocation.setValue(data.academyLocationId);
          						   academyLocation.setDisabled(false);
          					   }
          				   });
      				     } 
      					 if(data.coordinatorId){
        					   var campusCoordinator =  form.down("#campusCoordinator");
        					   campusCoordinator.getStore().load({
            					   callback: function(records, operation, success) {
            						   campusCoordinator.setValue(data.coordinatorId);
            					   }
            				   });
      					 } 
      					if(data.slctnProcessId){
       					   var selectionStageCombo =  form.down("#selectionStageCombo");
       					selectionStageCombo.getStore().load({
           					   callback: function(records, operation, success) {
           						selectionStageCombo.setValue(data.slctnProcessId);
           					   }
           				   });
      					} 
      			   var editUrl = SERVERURL.PLACEMENT_CAMPUS_FINDBYID;
           		   Ext.Ajax.request({
           			   method: "GET",
           			   type: 'rest',
           			   url: editUrl,
           			   params: {
           				   id: data.placementCampusId
           			   },
           			   success: function(f, action) {
           				   var data = Ext.JSON.decode(f.responseText);
           				   
        				   if(!isNullOrEmpty(data.droolId)){
        					   var eligibilityRule =  form.down("#eligibilityRule");
         						eligibilityRule.getStore().load({
         							callback: function(records, operation, success) {
         								for(var i in records){
         									if(records[i].data.id == data.droolId)
         									{
         										eligibilityRule.setValue(records[i].data.id);
         										eligibilityRule.setReadOnly(true);

         									}
         								}

         							}
         						});
        				   }
           				   
           			   }})
      				/*	if(data.droolsRule){
      						var eligibilityRule =  form.down("#eligibilityRule");
      						eligibilityRule.getStore().load({
      							callback: function(records, operation, success) {
      								for(var i in records){
      									if(records[i].data.id == data.droolsRule)
      									{
      										eligibilityRule.setValue(records[i].data.id);
      										eligibilityRule.setReadOnly(true);

      									}
      								}

      							}
      						});
       				     } */
      					if(!isNullOrEmpty(data.dateFrom)) {
      						  form.down("#startDate").setValue(dateRender(data.dateFrom));
      					}
      					if(!isNullOrEmpty(data.dateTo)) {
      						 form.down("#endDate").setValue(dateRender(data.dateTo));;
      					}
                    		// form.down("#academyLocation").setValue(dataModel.data.academyLocationName.value);
                    	 }
        		   });
        	   }else{
        		   showWarningMessage(getPlacementTranslation('JOB_LOCATIONS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        	   }
           },
           savePlacementJobLocationDetailsRecord:function(){
        	   var $this = this;
        	   var jobLocJsonData = this.getPlacementJobLocationsJson();
			   var jobLocationDetailform = this.getPlacementjoblocationdetailform();	  
        	   var grid = this.getPlacementjobLocationGrid();
        	   var value = jobLocationDetailform.getValues();
        	   var placementjobLocationmodel = new Academia.model.placement.placementjob.PlacementJobLocationModel();
        	   if(!isNullOrEmpty(value.id)){
        		   jobLocJsonData = this.editPlacementJobLocationsJson();
        		   submitUrl = SERVERURL.PATH_PLACEMENT_JOB_LOCATION_DETAILS_UPDATE; 
        		   message = getPlacementTranslation('PATH_PLACEMENT_JOB_LOCATION_UPDATED_SUCCESSFULLY')
        	   }
        	   else{
        		   submitUrl = SERVERURL.PATH_PLACEMENT_JOB_LOCATION_DETAILS_SAVE; 
        		   message = getPlacementTranslation('PATH_PLACEMENT_JOB_LOCATION_CREATED_SUCCESSFULLY')
        	   }
        	    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        	Ext.Ajax.request({
	        		type : 'rest',
	        		url : submitUrl,
	        		jsonData : jobLocJsonData,
	        		method : 'POST',
	        		success : function(frm, action) {
	        			Ext.getBody().unmask();
						grid.getStore().reload();
						var tabName = getPlacementTranslation('PLACEMENT_JOB_LOCATION_DETAILS');
			        	var getcontroller=$this.getController('menu.CoreERPNavigationController');
			        	var getTab=getcontroller.getTab(tabName);
			        	if(getTab!=null){
			        		contentPanel.remove(getTab, true);
			        	}
	        			showSuccessMessage(getPlacementTranslation('PLACEMENT_JOB_LOCATION_DETAILS'), message);
	        		}
	        	});
        	   
           },
	        savePlacementJobRecord: function(){
	        	
	           var $this = this;
         	   var placementjobform = $this.getPlacementjobform();
         	   var grid = $this.getPlacementjobgrid();
         	   var form = placementjobform.getForm();
         	   var value = form.getValues();
         	   var placementjobmodel = new Academia.model.placement.placementjob.PlacementJobModel();
               var drool =form.findField("eligibilityRule");
         	   placementjobmodel.set("jobTitle",value.jobTitle);
         	   placementjobmodel.set("placementCampusId",value.placementCampus);
         	   placementjobmodel.set("academyLocationId",value.academyLocation);
         	   placementjobmodel.set("coordinatorId",value.coordinator);
         	   placementjobmodel.set("slctnProcessId",value.selectionStageCombo);
         	   placementjobmodel.set("dateFrom",value.dateFrom);
         	   placementjobmodel.set("dateTo",value.dateTo);
         	   placementjobmodel.set("description",value.description);
         	   //placementjobmodel.set("droolsRule",value.eligibilityRule);
         	 // placementjobmodel.set("droolsRule",drool.getRawValue());
         	   placementjobmodel.set("whetherSelectionInBatches",value.selectRadio);
         	  var documentGrid = $this.getJobpostingdocumentgrid();
              var docStore = documentGrid.getStore();
              var docArray = [];
              try {
                  if (!isNullOrEmpty(documentGrid.getCode()) && documentGrid.getCode() != undefined) {
                    //  docStore.add(documentGrid.getCode());
                      if (docStore.data.items != null && docStore.data.items.length > 0) {
                          Ext.each(docStore.data.items, function(val) {
                              if (val.data.isNewRecord != undefined && val.data.isNewRecord) {
                                  var newData = {
                                      "name": val.data.documentName,
                                      "path": val.data.path,
                                      "type": "DOCUMENT",
                                      "createdBy": $this.getIdValueJson(val.data.createdBy.id, val.data.createdBy.value),
                                      "submissionDate": new Date().getTime()
                                  };
                                      docArray.push(newData);
                              }
                          });
                      }
                      var arr = [];
                      docStore.add(arr);
                  }
              } catch (err) {

              }
            	  placementjobmodel.set("documents", docArray);

         	   // API call to save PlacementJob
         	   if(!isNullOrEmpty(value.id)){
         		   submitUrl = SERVERURL.PATH_PLACEMENT_JOB_UPDATE; 
         		   placementjobmodel.set("id",grid.getSelectionModel().getSelection()[0].data.id);
         		   message = getPlacementTranslation('PATH_PLACEMENT_JOB_UPDATED_SUCCESSFULLY')
         	   }
         	   else{
         		   submitUrl = SERVERURL.PATH_PLACEMENT_JOB_SAVE; 
         		   message = getPlacementTranslation('PATH_PLACEMENT_JOB_CREATED_SUCCESSFULLY');
         	   }

         	   // Create required json to Save
	        	var json = this.createJson();
	        	var formData = Ext.encode(placementjobmodel.data);
	        	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        	Ext.Ajax.request({
	        		type : 'rest',
	        		url : submitUrl,
	        		jsonData : formData,
	        		method : 'POST',
	        		success : function(frm, action) {
	        			Ext.getBody().unmask();
	        			grid.getSelectionModel().deselectAll(true);
						grid.getStore().reload();
						var documentGrid = $this.getJobpostingdocumentgrid();
			            var docStore = documentGrid.getStore();
			            if (docStore) {
			            	docStore.removeAll();
			            }
						if(isNullOrEmpty(value.id)){
         				   form.reset();
         			   }
						var tabName = getPlacementTranslation('PLACEMENT_JOB_DETAILS');
			        	var getcontroller=$this.getController('menu.CoreERPNavigationController');
			        	var getTab=getcontroller.getTab(tabName);
			        	if(getTab!=null){
			        		contentPanel.remove(getTab, true);
			        	}
						
	        			showSuccessMessage(getPlacementTranslation('PATH_PLACEMENT_JOB'), message);
	        		}
	        	});

	        },
	        createJson: function(){
	        	// Create required json to Save
	        	var json= "";
	        	return json;	
	        },
	        
	      //******************Disable reset password button**********************************
	        disableJobLocationsPivileges: function(grid,permissionsMap) {
	        	
	        	var associatedAcadLocationIds = new Array();
	        	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	    		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	    		
	    		var jobLocationsBtn = grid.down('#btnJobLocations');
	        	jobLocationsBtn.setVisible(false);
	        	
	        	Ext.each(permissionList, function(privilege) {
	        		if (privilege === 'JOBLOCATIONS') {
	            		var button = buttonsToolBar.query('#btnJobLocations')[0];
	            		if(!isNullOrEmpty(button)){
	            			jobLocationsBtn.setVisible(true);
	            		}        		
	            	}
	        	});	
	        },
	        
	        /**
		     * Save program batch filter data
		     */
		    getPlacementJobLocationsJson:function(){
		    	/**
		    	 * Json for stop
		    	 */
		    	var $this = this;
	            var joblocationdetailform=$this.getPlacementjoblocationdetailform();
		    	var pbpsContiner = joblocationdetailform.down('#jobDetailContainerId');
		    	var academyLocation = joblocationdetailform.down('#academyLocation').getValue();
		    	var campusCoordinator = joblocationdetailform.down('#campusCoordinator').getValue();
		    	var placementJobId=joblocationdetailform.getForm().findField('placementJobId').getValue();
		    	var pbpsFieldsCount = pbpsContiner.items.length;
		    	var pbpsArray=new Array();
		    	var endJson=null;
		    	var fieldSequence=1;
		    		for(var j=0; j<pbpsContiner.items.length; j++){
		    			var pbpsPanelContainer=pbpsContiner.items.items[j];
		    				pbpsArray.push({
		    					"placementJobLocationMasterId": academyLocation,
		    					"coordinatorId":campusCoordinator,
		    					"placementDesignationId":pbpsPanelContainer.items.items[0].getValue(),
		    					"noOfPosition":pbpsPanelContainer.items.items[1].getValue(),
		    					"salaryPackageId": pbpsPanelContainer.items.items[2].getValue(),
		    					"placementJobId":placementJobId
		    				});
		    	}
		    	var obj = new Object();
		    	obj.placement = pbpsArray;
		    	return Ext.encode(pbpsArray);	
		    },
		    
		    
		    editPlacementJobLocationsJson:function(){
		    	/**
		    	 * Json for stop
		    	 */
		    	var $this = this;
	            var form = this.getPlacementjoblocationdetailform();
	            var placementJobId=form.getForm().findField('placementJobId').getValue();
	            var jsonData = form.getValues();
		    	jsonData.placementJobId=placementJobId;
	            return Ext.encode(jsonData);	
		    },
		    
		    ShowConfigureStageWindow:function(record){
		    	var frmWin = this.getConfigureStageJobPostingWin();
		    	if(!frmWin){
		    		Ext.widget('configurestagejobpostingwin');
		    		frmWin = this.getConfigureStageJobPostingWin();
		    	}
		    	frmWin.show();
		    	
		    	var selectionStageStore = frmWin.down('#selectionStage').getStore();
		    	selectionStageStore.getProxy().extraParams={
		    		selectionProcessId : record.data.slctnProcess.id
		    	}
		    	selectionStageStore.load();
		    }, 
		    getDocumentController: function() {
		        var this$ = this;
		        return this$.getController('Academia.controller.document.DocumentController');
		    },
		    getIdValueJson: function(id, value) {
		        if (id)
		            return {
		                id: id,
		                value: value
		            };
		    },
		    deleteDocumentFromGrid: function() {
            	var $this = this;
            	var grid;
            	var serverURL;
            	grid =  $this.getJobpostingdocumentgrid();
            	  serverURL = SERVERURL.PLACEMENT_JOB_POSTING_DOCUMENT_DELETE;
            	if (grid.getSelectionModel().getCount() > 0) {
            		showConfirmMessage(getPlacementTranslation('PLACEMENT_JOB_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
            			if (btn == 'yes') {
            				var store = grid.getStore();
            				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            				var record = grid.getSelectionModel().getSelection()[0];
            				var id = record.get("id");
            				if (!isNullOrEmpty(id)) {
            					Ext.Ajax.request({
            						method: "DELETE",
            						type: 'rest',
            						url: serverURL + '?id=' + id,
            						headers: {
            							'Content-Type': 'application/json'
            						},
            						success: function(form, action) {
            							Ext.getBody().unmask();
            							store.reload();
            							showSuccessMessage(getServiceRequestTranslation('FD_ITEM_ENTRY'), getServiceRequestTranslation('FD_ITEM_ENTRY_DOCUMENT_SUCCESS_DELETE_MSG'));
            						}
            					});
            				} else {
            					if (record) {
            						store.remove(record);
            					}
            					Ext.getBody().unmask();
            				}
            			}
            		});
            	} else {
            		showWarningMessage(getPlacementTranslation('PLACEMENT_JOB_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
            	}
            },
		    saveConfigureStage : function(){
		    	var $this = this;
		    	var grid = $this.getPlacementjobgrid();
		    	var record = grid.getSelectionModel().getSelection()[0];
		    	var form = this.getConfigureStageJobPostingWin();
		    	var getForm = form.down('form').getForm();;
		    	var jsonData=getForm.getValues();
		    	jsonData.placementJob={id:record.get('id')};
		    	var submitJson =  Ext.encode(jsonData);
		    		
		    	Ext.Ajax.request({type : 'rest',
		    		url : SERVERURL.PLACEMENT_SELECTION_STAGE_SAVE,
		    		jsonData : submitJson,
		    		method : 'POST',
		    		success : function(frm, action) {
		    			showSuccessMessage(getPlacementTranslation('PATH_PLACEMENT_JOB'),getPlacementTranslation('PATH_PLACEMENT_JOB_CONFIGSUCCESS_MSG'));
		    			form.close();
		    		}
		    	});
		    },
		    
		    downloadAllDescriptionDocumentFormsZip:function(){
				 var $this=this;
				 var grid=$this.getJobpostingdocumentwingrid();
				 if (grid.getSelectionModel().getCount() > 0) {
					 //courseGrid.getSelectionModel().deselectAll();
					 var records = grid.getSelectionModel().getSelection();
					 var saveModel=[];  

					 var zipName = "JobDescriptionDocuments"+records[0].data.document.path;
					 for(var i in records){
						 if(!isNullOrEmpty(records[i].data.document)) {
							 saveModel.push(records[i].data.document.path);
						 }
					 }
					 showConfirmMessage(getPlacementTranslation('JOB_DESCRIPTION_DOCUMENTS'),getPlacementTranslation('JOB_DESCRIPTION_DOCUMENTS_ALERT'),function(btn, text) {
						 if (btn == 'yes') {
							 var directoryType = CONSTANTS.DIRECTORY_TYPE_BASEDIR;
							 $this.getDocumentController().downloadMultipleDocumentFile(saveModel, zipName, directoryType);
						 }});
				 }else {
					 showWarningMessage(getPlacementTranslation('JOB_DESCRIPTION_DOCUMENTS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				 }
			 },
			 
			 deleteMultipleJobPostingDocument : function() {
				 var $this=this;
				 var grid=$this.getJobpostingdocumentwingrid();
				 var jobPostingDocumentIds = [];
				 if (grid.getSelectionModel().getCount() > 0) {
					 var records = grid.getSelectionModel().getSelection();
					 for(var i in records ){
						 jobPostingDocumentIds.push(records[i].get('id'));
					 }
					 showConfirmMessage(getPlacementTranslation('JOB_DESCRIPTION_DOCUMENTS'),getPlacementTranslation('JOB_DESCRIPTION_DOCUMENTS_DELETE_ALERT'),function(btn, text) {
						 if (btn == 'yes') {
							 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	   							Ext.Ajax.request({
	   	    		    			method: 'POST',
	   	    		    			type: 'rest',
	   	    		    			url: SERVERURL.PATH_DELETE_MULTIPLE_JOB_POSTING_DOCUMENTS,
	   	    		    			headers: {
	   	    		    				'Content-Type': 'application/json'
	   	    		    			},
	   	    		    			params : {
	   	    		    				jobPostingDocumentIds : jobPostingDocumentIds.join()
	   	    		    			},
	   	    		    			success: function(form, action) {
	   	    		    				var JPDWinGridStore = grid.getStore();
	   	    		    				$this.resetPageSetting(JPDWinGridStore);
	   	    		    				grid.getSelectionModel().deselectAll(true);
	   	    		    				var placementJobGrid = $this.getPlacementjobgrid();
	   	    		    				placementJobGrid.getSelectionModel().deselectAll(true);
	   	    		    				placementJobGrid.getStore().reload();
	   	    		            		grid.getStore().reload();
	   	    		    				Ext.getBody().unmask();
	   	    		    				showSuccessMessage(getPlacementTranslation('JOB_DESCRIPTION_DOCUMENTS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
	   	    		    			}
	   	    		    		});
						 }
						 });
				 } else {
	            		showWarningMessage(getPlacementTranslation('JOB_DESCRIPTION_DOCUMENTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	            	}
			 }
});

