/**
 * @author Trupti.Paoneker
 * This controller is use to handle functionality for Quota Overrides controller. 
 */
Ext.define('Academia.controller.reports.admission.QuotaOverridesReportController', {
    extend: 'Academia.controller.base.BaseController',

    stores: ['common.ProgramByAcAndLoIdStore', 'program.programbatchdetail.BatchStore', 'organization.academylocations.AcademyStore', 'organization.academylocations.LocationStore'],

    views: ['Academia.view.criteriabuilder.grid.SearchResultGrid', 'reports.admission.QuotaOverridesReportQuickSearchForm', 'reports.admission.QuotaOverridesReportQuickSearchView', 'reports.admission.QuotaOverridesReportView'],

    alias: "widget.quotaoverridesreportcontroller",

    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    }, {
        ref: 'quotaOverridesReportQuickSearch',
        selector: 'quotaoverridesreportquicksearchform'
    }, {
        ref: 'quotaOverridesReportResultGrid',
        selector: 'searchresultgrid[itemId=quotaOverridesReportResultGrid]'
    }, {
        ref: 'quotaOverridesReportView',
        selector: 'quotaoverridesreportview'
    }],

    init: function(application) {
        this.control({
            'quotaoverridesreportquicksearchform button[itemId=quotaOverridesReportQuickSearchFormSearchButtonId]': {
                click: this.loadGridAndSearchUsers
            }
        });

    },

    loadGridAndSearchUsers: function(model, records) {
        var masterForm = this.getQuotaOverridesReportQuickSearch();
        var jsonFormatFormData = this.createJsonFormat(masterForm, records);
        var resultGrid = this.getQuotaOverridesReportResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.QUOTA_OVERRIDE_REPORT_VIEWCODE);
        resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);

    },
    loadCombo: function(combo) {
        var store = combo.getStore();
        store.load();

    },
    createJsonFormat: function(MasterForm) {
        var me = this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.QUOTA_OVERRIDE_REPORT_BASIC_CONFIGCODE;
        formValues = MasterForm.getValues();

        for (var key in formValues) {
            var value = formValues[key];
            if (!isNullOrEmpty(value) && value !== 'All' && key !== 'selectedNameField') {
                var keyValueJsonObject = me.getJsonObject(key, value);
                me.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
            }
        }

        values.searchCriterias = searchcriteria;
        return values;

    },
    getJsonObject: function(key, value, additionalValue) {
        if (value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    }

});