Ext.define('Academia.controller.reports.studyplanreport.StudyPlanReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores: [
		'common.AcademyLocationNameSeparated',
		'program.ProgramSortedSequenceWiseStore',
		'program.programbatchdetail.BatchStore',
		'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
		'coursetransaction.studentenrollment.studentenrollmentdetail.StudentIdByAdmissionCodeBySmartSearch'
		],
		model: [],
		views: [
			'studyplanreport.StudyPlanReportStructure',
			'studyplanreport.StydyPlanReportFilter',
			'studyplanreport.StudyPlanReportGrid',
			'studyplanreport.StudyPlanReportTabStructure'
			],
			config: {
			},
			refs: [{
				ref: 'stydyPlanReportFilter',
				selector: 'stydyPlanReportFilter'
			},{
				ref: 'studyPlanReportStructure',
				selector: 'studyPlanReportStructure'
			},{
				ref: 'studyPlanReportGrid',
				selector: 'studyPlanReportGrid'
			},{
				ref: 'studyPlanReportTabStructure',
				selector: 'studyPlanReportTabStructure'
			}],
			init: function(application) {
				this.control({
					'stydyPlanReportFilter customcombobox#programId' : {
						change : function(obj, record) {
							var form = this.getStydyPlanReportFilter();
							var programfilter=form.down("#programId");
							if((programfilter.value)>0){
								form.down("#batchId").clearValue();
								form.down("#batchId").setDisabled(false);
								var batchStore = form.down('#batchId').getStore();
								batchStore.getProxy().extraParams = {
									id:record
								};
								batchStore.load();
							}
						}
					},
					'stydyPlanReportFilter customcombobox#batchId' : {
						change : function(obj, record) {
							var form = this.getStydyPlanReportFilter();
							var programfilter=form.down("#batchId");
							if((programfilter.value)>0){
								form.down("#period").clearValue();
								form.down("#period").setDisabled(false);
								var periodStore = form.down('#period').getStore();
								periodStore.getProxy().extraParams = {
									id: record
								};
								periodStore.load();
							}
						}
					},
					'stydyPlanReportFilter customcombobox#academyLocationId' : {
						change : function(obj, record) {
							var form = this.getStydyPlanReportFilter();
							if(record){
								form.down("#admissionId").clearValue();
								form.down("#admissionId").setDisabled(false);
								var admissionId = form.down('#admissionId').getStore();
								admissionId.getProxy().extraParams = {
									academyLocationId: record
								};
							}
						}
					},
					'stydyPlanReportFilter button#btnReset' : {
						click : function(obj, record) {
							var form = this.getStydyPlanReportFilter();
							form.getForm().reset();
						}
					},

					'stydyPlanReportFilter button#btnSearch': {
						click: function () {
							var me = this,
							form = me.getStydyPlanReportFilter(),
							formValues = form.getForm().getValues(),
							container = form.up(),
							oldGrid = container.down('grid'),
							programIdsArr = [],
							periodField = form.down('#periodIds');

							Ext.each(formValues.periodIds, function (rec) {
								if (rec) {
									programIdsArr.push(rec.data.id);
								}
							});

							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							formValues.periodIds = programIdsArr.join();
							Ext.Ajax.request({
								url: SERVERURL.PATH_STUDY_PLAN_REPORT,
								params: formValues,
								method: 'GET',
								success: function (resp) {
									var response = Ext.decode(resp.responseText);
									
									if(!response.groups.length){
										showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('TM_NO_DATA_AVAILABLE'));
										Ext.getBody().unmask();
										return
									}
									
//									var columns = me.buildStudyPlanColumns(response);
									var data = me.buildFlatData(response);
									var containerWidth = container.getWidth() || Ext.getBody().getViewSize().width;
									var columns = me.buildStudyPlanColumns(response, containerWidth);
									var fieldMap = {};

									// collect keys from ALL records
									Ext.each(data, function (rec) {
										Ext.Object.each(rec, function (key) {
											fieldMap[key] = true;
										});
									});

									var store = Ext.create('Ext.data.Store', {
										fields: Ext.Object.getKeys(fieldMap),
										data: data
									});
									

									// 🔥 DESTROY OLD GRID
									if(oldGrid) container.remove(oldGrid, true);

									// 🔥 CREATE NEW GRID (NO reconfigure)
									var newGrid = Ext.create('Ext.grid.Panel', {
										store: store,
										columns: columns,
										width: '100%',
										autoScroll: true,
										sortableColumns: false,
										columnLines: false,
										rowLines: true,   // keep rowLines, we'll override via CSS
										cls: 'grouped-column-grid-cls',

										viewConfig: {
											getRowClass: function (rec) {
												if (rec.get('isTotalRow')) return 'row-total';
												if (rec.get('isMainGroup')) return 'row-main-group';
												if (rec.get('isSubGroup')) return 'row-sub-group';
											}
										}

									});
									container.add(newGrid);
									Ext.getBody().unmask();
								}
							});
						}
					},

				});
			},



			componentColumn: function (sem, comp) {
				return {
					text: comp,
					width: 60,
					align: 'center',
					cls: 'vertical-header',
					dataIndex: sem + '_' + comp
				};
			},

			calculateVariantWidth: function (response, containerWidth) {

				var FIXED_LEFT_WIDTH = 0;
				var FIXED_RIGHT_WIDTH = 0;
				var MIN_VARIANT_WIDTH = 60;

				// LEFT columns width
				Ext.each(response.columns, function (col) {
					if (col.key.indexOf('Semester') !== 0 && col.key !== 'courseCredit') {
						FIXED_LEFT_WIDTH += col.width || 120;
					}
				});

				// RIGHT (credit)
				Ext.each(response.columns, function (col) {
					if (col.key === 'courseCredit') {
						FIXED_RIGHT_WIDTH += col.width || 90;
					}
				});

				// Count total variants
				var totalVariants = 0;
				Ext.each(response.subcolumns, function (semObj) {
					Ext.Object.each(semObj, function (sem, variants) {
						totalVariants += variants.length;
					});
				});

				var availableWidth =
					containerWidth - FIXED_LEFT_WIDTH - FIXED_RIGHT_WIDTH - 30;

				if (availableWidth <= 0 || totalVariants === 0) {
					return MIN_VARIANT_WIDTH;
				}

				return Math.max(
						MIN_VARIANT_WIDTH,
						Math.floor(availableWidth / totalVariants)
				);
			},

			buildFlatData: function (response) {

				var data = [];

				/* =========================
				 * COLLECT ALL SEM + VARIANT KEYS
				 * ========================= */
				var allVariantKeys = [];

				Ext.each(response.subcolumns, function (semObj) {
					Ext.Object.each(semObj, function (semName, variants) {
						var semKey = semName.replace(/\s+/g, '');
						Ext.each(variants, function (v) {
							allVariantKeys.push(semKey + '_' + v.component);
						});
					});
				});

				/* =========================
				 * BUILD DATA
				 * ========================= */
				Ext.each(response.groups, function (group) {

					/* 🔹 MAIN GROUP ROW */
					var mainRow = {
							courseCode:
								group.title === 'ADDITIONAL_COURSES'
									? getProgramandcourseTranslation('ADDITIONAL_COURSES')
											: group.title,
											courseName: '',
											courseCredit: group.parentCourseGroupMaxCredit,
											isMainGroup: true
					};


					Ext.each(allVariantKeys, function (k) {
						mainRow[k] = '';
					});

					data.push(mainRow);

					Ext.each(group.children, function (child) {

						/* 🔹 SUB GROUP ROW */
						var subRow = {
								courseCode: child.title,
								courseName: '',
								courseCredit: child.childCourseGroupMaxCredit, // ✅ HERE
								isSubGroup: true
						};

						Ext.each(allVariantKeys, function (k) {
							subRow[k] = '';
						});

						data.push(subRow);

						/* =========================
						 * MERGE COURSES BY courseCode
						 * ========================= */
						var courseMap = {};

						Ext.each(child.rows, function (row) {

							if (!courseMap[row.courseCode]) {

								courseMap[row.courseCode] = {
										courseCode: row.courseCode,
										courseName: row.courseName,
										assignedFaculty: row.assignedFaculty || '',
										courseCredit: row.courseCredit, // ✅ SAME VALUE FOR ALL COMPONENTS
								};

								Ext.each(allVariantKeys, function (k) {
									courseMap[row.courseCode][k] = '';
								});
							}

							// fill semester + component values
							Ext.Object.each(row.semesterValues, function (sem, val) {
								var semKey = sem.replace(/\s+/g, '');
								courseMap[row.courseCode][semKey + '_' + row.component] = val;
							});
						});

						Ext.Object.each(courseMap, function (_, rec) {
							data.push(rec);
						});
					});
				});
				
				/* =========================
				 * TOTAL ROW (LAST ROW)
				 * ========================= */
				var totalCredit = 0;

				Ext.each(response.groups, function (group) {
				    if (Ext.isNumber(group.parentCourseGroupMaxCredit)) {
				        totalCredit += group.parentCourseGroupMaxCredit;
				    }
				});

				var totalRow = {
				    courseCode: getCommonTranslation('TOTAL'), // 🔥 TRANSLATED TITLE
				    courseName: '',
				    assignedFaculty: '',
				    courseCredit: totalCredit,
				    isTotalRow: true
				};

				// Empty all variant columns
				Ext.each(allVariantKeys, function (k) {
				    totalRow[k] = '';
				});

				data.push(totalRow);


				return data;
			},

			buildStudyPlanColumns: function (response, containerWidth) {

				var me = this;
				var variantWidth = me.calculateVariantWidth(response, containerWidth);

				var leftColumns = [];
				var rightColumn = null;

				/* =========================
				 * 1️⃣ LEFT COLUMNS (TRANSLATED)
				 * ========================= */
				Ext.each(response.columns, function (col) {

					// Skip semester data columns
					if (col.key.indexOf('Semester') === 0) {
						return;
					}

					/* CREDIT → RIGHT SIDE */
					if (col.key === 'courseCredit') {
						rightColumn = {
								text: me.getColumnTitle('courseCredit', col.title),
								dataIndex: col.key,
								width: col.width || 90,
								align: 'center',

								renderer: function (value, meta, rec) {

								    if (rec.get('isTotalRow')) {
								        meta.style =
								            'font-weight:700;' +
								            'border-top:2px solid #666;';
								        return value;
								    }

								    if (rec.get('isMainGroup')) {
								        meta.style = 'font-weight:600;';
								        return value;
								    }

								    if (rec.get('isSubGroup')) {
								        meta.style = 'font-size:12px;color:#666;';
								        return value;
								    }

								    return value;
								}

						};

						return;
					}

					leftColumns.push({
						text: me.getColumnTitle(col.key, col.title),
						dataIndex: col.key,
						width: col.width || 120,

						renderer: function (value, meta, rec, rowIdx, colIdx) {

						    /* =========================
						     * TOTAL ROW
						     * ========================= */
						    if (rec.get('isTotalRow')) {
						        meta.style = 'font-weight:700;';
						        return value;
						    }

						    /* =========================
						     * MAIN GROUP
						     * ========================= */
						    if (rec.get('isMainGroup')) {
						        if (colIdx === 0) {
						            meta.style = 'font-weight:600;';
						            return rec.get('courseCode');
						        }
						        return '';
						    }

						    /* =========================
						     * SUB GROUP
						     * ========================= */
						    if (rec.get('isSubGroup')) {
						        if (colIdx === 1) {
						            meta.style =
						                'text-align:right;' +
						                'padding-right:16px;' +
						                'font-size:12px;' +
						                'color:#666;';
						            return rec.get('courseCode');
						        }
						        return '';
						    }
						    
						    /* =========================
						     * TOTAL ROW
						     * ========================= */
						    if (rec.get('isTotalRow')) {
						        if (colIdx === 0) {
						            meta.style = 'font-weight:700;';
						            return rec.get('courseCode'); // TOTAL
						        }
						        return '';
						    }


						    return value;
						}

					});
				});

				/* =========================
				 * 2️⃣ SEMESTER → VARIANTS
				 * (NO TRANSLATION BY DESIGN)
				 * ========================= */
				var semesterColumns = [];

				Ext.each(response.subcolumns, function (semObj) {

					Ext.Object.each(semObj, function (semName, variants) {

						var semKey = semName.replace(/\s+/g, '');

						var semGroup = {
								text: semName, // ❌ NOT TRANSLATED
								align: 'center',
								cls: 'semester-name-header',
								columns: []
						};

						Ext.each(variants, function (v) {
							semGroup.columns.push({
								text: v.component, // ❌ NOT TRANSLATED
								width: variantWidth,
								minWidth: 60,
								align: 'center',
								cls: 'variant-header vertical-header',
								dataIndex: semKey + '_' + v.component
							});
						});

						semesterColumns.push(semGroup);
					});
				});

				/* =========================
				 * 3️⃣ TOP SEMESTER HEADER (TRANSLATED)
				 * ========================= */
				var columns = leftColumns;

				if (semesterColumns.length) {
					columns.push({
						text: me.getColumnTitle('semester', 'SEMESTER'),
						align: 'center',
						cls: 'semester-top-header',
						columns: semesterColumns
					});
				}

				/* =========================
				 * 4️⃣ CREDIT COLUMN (RIGHT)
				 * ========================= */
				if (rightColumn) {
					columns.push(rightColumn);
				}

				return columns;
			},

			getColumnTitle: function (key, fallback) {
				var translations = {
						courseCode: getProgramandcourseTranslation('CODE'),
						courseName: getProgramandcourseTranslation('COURSE'),
						assignedFaculty: getProgramandcourseTranslation('ASSIGNED_FACULTY'),
						courseCredit: getProgramandcourseTranslation('CREDIT'),
						semester: getProgramandcourseTranslation('SEMESTER')
				};

				return translations[key] || fallback;
			},

});