/**
 * This controller is used for survey report controller
 * @author Rajkumar.Patidar
 */
Ext.define('Academia.controller.reports.survey.SurveyReportController', {
    extend: 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',
    stores: ['reports.survey.SurveyReportTreeStore','reports.survey.ClosedSurveyStore',
             'reports.survey.ClosedSurveyStore','reports.survey.InactiveSurveyStore',
             'reports.survey.ActiveSurveyStore','reports.survey.ParticipantStore',
             'reports.survey.ParticipantDetailGridStore'],
    views: ['reports.survey.SurveyReportViewStructure','feeandpayment.reports.StudentFeeReportTabPanel',
            'reports.survey.InactiveSurveyReport','reports.survey.ActiveSurveyReport','reports.survey.ClosedSurveyReport',
            'reports.survey.ParticipantInfoWindow','reports.survey.ActiveSurveyReportStructure',
            'reports.survey.InactiveSurveyReportStructure','reports.survey.ClosedSurveyReportStructure',
            'reports.survey.ParticipantDetailStructure','reports.survey.ParticipantDetailGrid'],
    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    },{
    	ref:'surveyReportViewStructure',
    	selector:'surveyreportviewstructure'
    },{
    	ref: 'surveyReportTabStructure',
    	selector: 'studentfeereporttabpanel[itemId=surveyReportTabStructure]'
    },{
 	    ref: 'surveyReportOrganizationUnit',
 	    selector: 'organizationunit[itemId=surveyReportOrganizationUnit]'
    },{
    	ref:'activeSurveyReport',
    	selector:'activesurveyreport'
    },{
    	ref:'inactiveSurveyReport',
    	selector:'inactivesurveyreport'
    },{
    	ref:'closedSurveyReport',
    	selector:'closedsurveyreport'
    },{
    	ref:'participantInfoWindow',
    	selector:'participantinfowindow'
    },{
        ref: 'organizationunit',
        selector: 'organizationunit'
    },{
    	ref:'participantdetailstructure',
    	selector:'participantdetailstructure'
    },{
    	ref:'participantdetailgrid',
    	selector:'participantdetailgrid'
    }],
    config: {
    	STUDENT_UNASSIGNEDREQUEST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_UNASSIGNEDREQUEST_PRIVILEGES'),
    	STUDENT_FOLLOWUPSCHEDULED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_FOLLOWUPSCHEDULED_PRIVILEGES'),
    	STUDENTDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENTDASHBOARD_PRIVILEGES'),
    	SURVEY_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SURVEY_REPORT_PRIVILEGES')

    },
    init: function(application) {
        this.control({
        	'organizationunit[itemId=surveyReportOrganizationUnit] radiogroup[itemId=organizationRadioUnitId]': {
    			change:function(obj,record){
    				this.organizationUnitChange(obj,record);
    			},
    			render:function(obj){
    				var permission = this.getSTUDENTDASHBOARD_PERMISSIONS();
  		  			this.organizationUnitChange(obj,null,permission);
    			}
    		},
    		'organizationunit[itemId=surveyReportOrganizationUnit] button[itemId=resetBtn]': {
    			click:function(obj,record){ 
    				this.resetOrganizationunit(obj);
    			}
    		},
        	'surveyreportviewstructure panel[itemId=surveyReportView] treepanel[itemId=surveyReportTreePanelItemId]': {
        		itemclick : this.getCreateTabStructureReports
       	     },
       	     'activesurveyreport' :{
       	    	 render:function(grid){
       	    		this.doAccessControlValidation(grid, this.getSURVEY_REPORT_PERMISSIONS());
       	    	 },
       	    	 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
       	    		 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
       	    		 if(columnName=='linkToSeeParticipantList'){
       	    			 if(e.target.tagName=='A'){
       	    				 //this.getParticipantInfoList(record);
       	    				 this.openParticipantInfoTab(record);
       	    			 }
       	    		 }
       	    	 }
       	     },
       	     'inactivesurveyreport' :{
       	    	render:function(grid){
       	    		this.doAccessControlValidation(grid, this.getSURVEY_REPORT_PERMISSIONS());
       	    	 },
       	    	 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
       	    		 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
       	    		 if(columnName=='linkToSeeParticipantList'){
       	    			 if(e.target.tagName=='A'){
       	    				this.getParticipantInfoList(record);
       	    			 }
       	    		 }
       	    	 }
       	     },
       	     'closedsurveyreport' :{
       	    	render:function(grid){
       	    		this.doAccessControlValidation(grid, this.getSURVEY_REPORT_PERMISSIONS());
       	    	 },
       	    	 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
       	    		 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
       	    		 if(columnName=='linkToSeeParticipantList'){
       	    			 if(e.target.tagName=='A'){
       	    				this.getParticipantInfoList(record);
       	    			 }
       	    		 }
       	    	 }
       	     }
        });
    },
	    
    /**
     * open reports
     */
    getCreateTabStructureReports : function( treePanel, record, item, index, e, eOpts ) {
		var $this = this;
		var surveyReportView = $this.getSurveyReportViewStructure();
		var treeTab = surveyReportView.down('#surveyReportTreePanelItemId');
		var surveyReportTabStructure = $this.getSurveyReportTabStructure();
		var tabDetail = record.data;
		var structure = Ext.widget(tabDetail.reportXtype);
		var tabs = surveyReportTabStructure.items.items;
		var tabName = tabDetail.text;
		
		if(!isNullOrEmpty(tabName) && !isNullOrEmpty(tabDetail.reportXtype) && !isNullOrEmpty(tabDetail.reportXtypeItemId)){
			treeTab.toggleCollapse();
			if (surveyReportTabStructure != undefined) {
				var newTab = surveyReportTabStructure.items.findBy(function(tab) {
					return tab.title === tabName;
				});
				if (!newTab) {
					var newTab = surveyReportTabStructure.add({
						title : tabName,
						closable : true,
						xtype : tabDetail.reportXtype,
					}).show();
				}
				surveyReportTabStructure.setActiveTab(newTab);
				surveyReportTabStructure.doLayout();
				treePanel.getSelectionModel().deselectAll();
				$this.getLoadSurveyReports(tabDetail.reportXtype);
			}
		}
    },
	
	/**
	 * get load current AL or Common AL 
	 */
	getAcademyLocationIds : function(){
		 var organizationUnit = this.getSurveyReportOrganizationUnit();
    	 var organizationUnitForm = organizationUnit.getForm();
    	 var academyLocation = organizationUnitForm.getValues();
    	 var academyLocationId = null;
    	 if (isEmpty(academyLocation["multiselectAcademyLocation"])) {
    		 academyLocationId = this.getCurrentAcademyLocation();
    	 } else {
    		 academyLocationId = academyLocation.multiselectAcademyLocation;
    	 }
    	 var ALId = academyLocationId.join();
    	 return ALId;
	},
	
	/**
	 * load reports
	 */
	getLoadSurveyReports : function(reportXtype){
		var $this = this;
		var ALId = $this.getAcademyLocationIds();
		
		
		/* var multiData;
	     var multiArrayData=[];
	     for(var i in multiselectTopics){
	         if(Ext.isObject(multiselectTopics[0])){
	        	 multiTopicsData = multiselectTopics[i].get("id");
	        	 multiTopicsArrayData.push(multiTopicsData);
	         }else{
	        	 multiTopicsData = multiselectTopics[i];
	        	 multiTopicsArrayData.push(multiTopicsData);
	         }
	     }*/
		
		switch(reportXtype) {
		case 'activesurveyreportstructure':
			var grid = $this.getActiveSurveyReport();
			var store = grid.getStore();
			store.getProxy().extraParams={
				academyLocationIds : ALId
			}
			store.load();
			break;
			
		case 'inactivesurveyreportstructure':
			var grid = $this.getInactiveSurveyReport();
			var store = grid.getStore();
			store.getProxy().extraParams={
				academyLocationIds : ALId
			}
			store.load();
			break;
			
		case 'closedsurveyreportstructure':
			var grid = $this.getClosedSurveyReport();
			var store = grid.getStore();
			store.getProxy().extraParams={
				academyLocationIds : ALId
			}
			store.load();
			break;
		}
	},
	
	/**
	 * get participant info based on survey Id
	 *  
	 */
	getParticipantInfoList : function(record){
		var surveyMasterId = record.get("surveyMasterId");
		var formWindow = this.getParticipantInfoWindow();
		if (!formWindow) {
			Ext.widget('participantinfowindow');
			formWindow = this.getParticipantInfoWindow();
		}
		formWindow.show();

		var store = formWindow.down("#participantGrid").getStore();
		store.getProxy().extraParams = {
			surveyMasterId: surveyMasterId
		};
		store.load();
	},
	getAcademyLocationIds: function(){

    	var organizationUnitForm = this.getOrganizationunit().getForm();
    	var academyLocation;
    	var values = organizationUnitForm.getValues();
    	var aL = values.academyLocation;
    	var mAL = values.multiselectAcademyLocation;

    	var alArray=[];
    	var mALArray=[];

    	if(aL !=undefined && aL.length > 0){
    		for(var i in aL){
    			if(Ext.isObject(aL[0])){
    				alArray.push(aL[i].get("id"));
    			}else{
    				alArray.push(aL[i]);
    			}
    		}
    		academyLocation= alArray.join();

    	}else if(mAL !=undefined && mAL.length > 0){
    		for(var i in mAL){
    			if(Ext.isObject(mAL[0])){
    				mALArray.push(mAL[i].get("id"));
    			}else{
    				mALArray.push(mAL[i]);
    			}
    		}
    		academyLocation= mALArray.join();
    	}else{
    		academyLocation = this.getCurrentAcademyLocation();
    	}
    	return academyLocation;
    },
    
    openParticipantInfoTab:function(record){
    	var $this = this;
    	var surveyReportTabStructure = $this.getSurveyReportTabStructure();
    	//var tabDetail = record.data;
    	var tabName = getCommonTranslation('PARTICIPANT_DETAIL');

    	if (surveyReportTabStructure != undefined) {
    		var newTab = surveyReportTabStructure.items.findBy(function(tab) {
    			return tab.title === tabName;
    		});
    		if (!newTab) {
    			var newTab = surveyReportTabStructure.add({
    				title : tabName,
    				closable : true,
    				xtype : 'participantdetailstructure',
    			}).show();
    		}
    		var surveyMasterId = record.get("surveyMasterId");
    		var store = $this.getParticipantdetailgrid().getStore();
    		store.getProxy().extraParams = {
    			surveyMasterId: surveyMasterId
    		};
    		store.loadPage(1);
    		surveyReportTabStructure.setActiveTab(newTab);
    		surveyReportTabStructure.doLayout();
    	}
    }
});
