/**
 * @author Dharmendra.prajapti
 *  
 */
Ext.define('Academia.controller.setup.templatemapping.TemplateMappingController', {
	extend:'Academia.controller.base.BaseController',
    views:  ['setup.templatemapping.TemplateMappingSearch','setup.templatemapping.TemplateMappingStructure',
             'setup.templatemapping.AddTemplateMapping','setup.templatemapping.PreviewTemplate',
             'Academia.view.setup.translationmapping.TranslationMappingStructure',
             'Academia.view.setup.translationmapping.TranslationMappingSearch',
             'Academia.view.setup.translationmapping.TranslationMappingGrid'],
    models:['setup.templatemapping.TemplateMapping'],         
    stores: ['setup.templatemapping.TemplateType','setup.templatemapping.TemplateName','common.AcademyLocationNameSeparated',
    	'setup.translationmapping.TranslationMappingStore'],
    config : {
    	REPORT_TEMPLATE_MAPPING_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('REPORT_TEMPLATE_MAPPING'),
    	REPORT_TRANSLATION_MAPPING_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('REPORT_TRANSLATION_MAPPING')
    },  
    refs:   [{
    	ref : 'templatemappingsearch',
    	selector : 'templatemappingsearch'
    },{
    	ref : 'addtemplatemapping',
    	selector : 'addtemplatemapping'
    },{
    	ref: 'contentPanel',
    	selector: 'contentPanel'
    },{
    	ref: 'searchresultgrid',
    	selector: 'searchresultgrid[itemId=templatemappinggridId]'
    },{
    	ref: 'previewtemplate',
    	selector: 'previewtemplate'
    },{
    	ref: 'previewTemplate',
    	selector: 'previewtemplate form'
    },{
    	ref: 'uploadtemplatewin',
    	selector: 'uploadtemplatewin'
    },{
    	ref: 'uploadTemplatewin',
    	selector: 'uploadtemplatewin form'
    },{
    	ref: 'translationmappingsearch',
    	selector: 'translationmappingsearch'
    },{
    	ref: 'translationmappinggrid',
    	selector: 'translationmappinggrid'
    },{
    	ref: 'translationmappingstructure',
    	selector: 'translationmappingstructure'
    }],

    init: function(application) {
    	this.control({
    		'searchresultgrid[itemId=templatemappinggridId] button[itemId=searchResultGridBtnAdd]': {
    			click : this.showAddTemplatingMapping
    		},
    		'searchresultgrid[itemId=templatemappinggridId] button[itemId=searchResultGridBtnEdit]': {
    			click: this.editAddTemplatingMapping
    		},
    		'searchresultgrid[itemId=templatemappinggridId] button[itemId=searchResultGridBtnDelete]': {
    			click: this.deleteAddTemplatingMapping
    		},
    		'searchresultgrid[itemId=templatemappinggridId] button[itemId=searchResultGridBtnView]': {
    			click :  this.viewAddTemplatingMapping
    		},
    		'templatemappingsearch customcombobox#templateType' : {
    			select : function(obj, record) {
    				var from = obj.up('form');
    				var reportTypeId = record[0].get("id");
    				var  templateNameField = from.down("#templateName");
    				templateNameField.setDisabled(false);
    				var store = templateNameField.getStore();

    				store.getProxy().extraParams = {
    					reportTypeId: reportTypeId
    				};
    				store.load();
    			}
    		},
    		'translationmappingsearch customcombobox#templateTypeTranslation' : {
    			select : function(obj, record) {
    				var from = obj.up('form');
    				var reportTypeId = record[0].get("id");
    				var  templateNameField = from.down("#templateNameTranslation");
    				templateNameField.setDisabled(false);
    				templateNameField.clearValue();
    				var store = templateNameField.getStore();

    				store.getProxy().extraParams = {
    					reportTypeId: reportTypeId
    				};
    				store.load();
    			}
    		},
    		'addtemplatemapping customcombobox#templateType' : {
    			select : function(obj, record) {
    				var from = obj.up('form');
    				var reportTypeId = record[0].get("id");
    				var  templateNameField = from.down("#templateName");
    				templateNameField.setDisabled(false);
    				var store = templateNameField.getStore();

    				store.getProxy().extraParams = {
    					reportTypeId: reportTypeId
    				};
    				store.load();
    			}
    		},
    		'addtemplatemapping filefield[itemId=primaryPhotoUploadForm]': {
    			change : function(fileField, value, eOpts) {
        	        this.onSelectUploadFileField(fileField, value, eOpts);
        	    }
    		},
    		'addtemplatemapping filefield[itemId=secondaryPhotoUploadForm]': {
    			change : function(fileField, value, eOpts) {
        	        this.onSelectUploadFileField(fileField, value, eOpts);
        	    }
    		},
    		'addtemplatemapping filefield[itemId=footerPhotoUploadForm]': {
    			change : function(fileField, value, eOpts) {
        	        this.onSelectUploadFileField(fileField, value, eOpts);
        	    }
    		},
    		'addtemplatemapping filefield[itemId=waterMarkPhotoUploadForm]': {
    			change : function(fileField, value, eOpts) {
        	        this.onSelectUploadFileField(fileField, value, eOpts);
        	    }
    		},
    		'addtemplatemapping customcombobox#templateName' : {
    			select : function(obj, record) {
    				var templateCode = record[0].get("code");
    				var frm = obj.up('form');
    				var form = frm.getForm();
    				frm.down('#previewTemplateBtn').setDisabled(false);
    				if (!isNullOrEmpty(templateCode)) {
    					form.findField('templateCode').setValue(templateCode);
    				}

    			}
    		},
    		'templatemappingsearch button[itemId=searchBtn]' : {
    			click : this.loadTemplateMappingData
    		},
    		'templatemappingsearch button[itemId=resetBtn]' : {
    			click : function(obj){
    				obj.up('form').getForm().reset();
    				obj.up('form').down('#academyLocationId').clearAllDataFn();
    			}
    		},
    		'translationmappingstructure': {
    			afterrender : function(structure){
    				var grid = structure.down('translationmappinggrid');
    				grid.getStore().removeAll();
    				this.getGridHeaderFreezeWithoutPaginationCustomized(grid,structure,true);
    			}
    		},
    		'translationmappingsearch button[itemId=searchBtnTranslation]' : {
    			click : this.loadTranslationMappingData
    		},
    		'translationmappingsearch button[itemId=resetBtnTranslation]' : {
    			click : function(obj){
    				obj.up('form').getForm().reset();
    				obj.up('form').down('#templateNameTranslation').setDisabled(true);
    			}
    		},
    		'translationmappinggrid button[itemId=btnSaveGrid]' : {
    			click : function(obj){
					var $this = this;
    				var mappingGrid = obj.up('grid');
    				if(mappingGrid.getSelectionModel().getCount() > 0){
    					var selectedRecords = mappingGrid.getSelectionModel().getSelection();
    					var selected = [];
    					Ext.each(selectedRecords,function(currentRecord){
    						var WSReportTemplateTranslations = {};
    						WSReportTemplateTranslations['id'] = currentRecord.get('id');
    						WSReportTemplateTranslations['keyValue'] = currentRecord.get('keyValue');
    						WSReportTemplateTranslations['defaultValue'] = currentRecord.get('defaultValue');
    						WSReportTemplateTranslations['customValue'] = isNullOrEmpty(currentRecord.get('customValue'))?null:currentRecord.get('customValue');
    						WSReportTemplateTranslations['reportTemplateId'] = currentRecord.get('reportTemplateId');
    						selected.push(WSReportTemplateTranslations);
    					});
    					
    					Ext.Ajax.request({
    						type: 'rest',
    						url: SERVERURL.PATH_UPDATE_REPORT_TRANSLATION_MAPPING_GRID_DATA,
    						jsonData : selected,
    						method: 'POST',
    						headers : {
								'Content-Type' : 'application/json'
							},
    						success : function(response){
    							if(response.responseText=="true"){
    								showSuccessMessage(getCommonTranslation('REPORT_TRANSLATION_MAPPING'),getCommonTranslation('SUCCESS'));
    								mappingGrid.getStore().load();
    								mappingGrid.getSelectionModel().deselectAll();
    							}
    						}
    					});
    				}
    				else {
    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    				}
    			}
    		},
    		'translationmappinggrid button[itemId=btnResetGrid]' : {
    			click : function(obj){
    				var mappingGrid = obj.up('grid');
    				if(mappingGrid.getSelectionModel().getCount() > 0){
    					var selectedRecords = mappingGrid.getSelectionModel().getSelection();
    					Ext.each(selectedRecords,function(currentRecord){
    						/*if(currentRecord.raw.customValue != currentRecord.get('customValue')){
    							currentRecord.set('customValue',"");
    						}*/
    						if(!isNullOrEmpty(currentRecord.get('customValue'))){
    							currentRecord.set('customValue',"");
    						}
    					});
    				}
    				else {
    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    				}
    			}
    		},
    		'translationmappinggrid textfield[itemId=translationLocalSearchText]':{
    			keyup: function( me, e, eOpts ){
    				var grid = me.up('grid');
    				var store = grid.getStore();
    				store.clearFilter();
    				var count = 0;
    				if(!isNullOrEmpty(me.getValue())){
    					var reg = new RegExp('^' + me.getValue(), 'i');
    					store.filter(new Ext.util.Filter({
    						filterFn: function (object) {
    							var match = false;
    							Ext.Object.each(object.data, function (property, value) {
    								match = match || reg.test(String(value));
    							});
    							if(match == true){
									count++;
								}
    							return match;
    						}
    					}));
    				}
    				if(count==0){
    					store.load();
    				}else{
    	 				var gridDom = grid.el ? grid.el.dom : null;
    	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ count;	
    				}
    			}
    		},
    		'searchresultgrid[itemId=templatemappinggridId]':{
    			render:function(grid){
    				var permissionsMap = new Ext.util.HashMap();
    				this.gridRenderFunction(grid);
    				permissionsMap = this.getREPORT_TEMPLATE_MAPPING_PERMISSION();
    				this.genericCBGridAccessControlValidation(grid,permissionsMap);

    			}	 
    		},
    		'addtemplatemapping button[itemId=previewTemplateBtn]': {
    			click: function() {
    				this.previewTemplateFunction();
    			}
    		},

    		'addtemplatemapping  button[itemId=saveBtn]': {
//    			click: this.saveUpdateTemplate
    			click:this.uploadlogo
    		},
    		'addtemplatemapping  button[itemId=cancelBtn]': {
    			click: function(){    				
    				var $this =this;
    				var contentpanel = $this.getContentPanel();
    				//var addtemplatemapping = Ext.widget('addtemplatemapping');
    				var tabName = getCommonTranslation('ADD_TEMPLATE_MAPPING');    				
    				var getcontroller=$this.getController('menu.CoreERPNavigationController');
    		    	var getTab=getcontroller.getTab(tabName);
    		    	contentpanel.remove(getTab, true);
    				
    			}
    		},
    		'previewtemplate  button[itemId=cancelBtn]': {
    			click: function(){
    				this.getPreviewtemplate().close();
    			}
    		}
    	});
    },
    loadTemplateMappingData : function(model, records) {
    	var quickSearchForm = this.getTemplatemappingsearch();
		var jsonFormatFormData = this.createJsonFormat(quickSearchForm,records);
		var searchResultGrid = this.getSearchresultgrid();
		var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
    	resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.REPORT_TEMPLATE_LIST_VIEW_CODE);
    	searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	},
    loadTranslationMappingData : function(model, records) {
    	var quickSearchForm = this.getTranslationmappingsearch();
		var searchResultGrid = this.getTranslationmappinggrid();
		
		var reportTemplateId = quickSearchForm.getValues().templateNameTranslation;
		var gridStore = searchResultGrid.getStore();
		gridStore.clearFilter();
		searchResultGrid.down('#translationLocalSearchText').setValue('');
		gridStore.removeAll();
		gridStore.getProxy().extraParams = {
			reportTemplateId: reportTemplateId
		};
		gridStore.load();
	},
	createJsonFormat:function(quickSearchForm, record){			
		var value = quickSearchForm.getForm().getValues();
		var templateName = value.templateName;
		
		var al;
		var academyLocationData=[];

		if(value.academyLocation !="" && value.academyLocation !=null){
			for(var i in value.academyLocation){
				if(Ext.isObject(value.academyLocation[i])&& !isNullOrEmpty(value.academyLocation[i])){
					al = value.academyLocation[i].get("id");
					academyLocationData.push(al);
				}else{
					if(!isNullOrEmpty(value.academyLocation[i])){
					al = value.academyLocation[i];
					academyLocationData.push(al);
					}
				}
			}
		}	
		
		var values = new Object();
		values.configCode = CONSTANTS.CB.REPORT_TEMPLATE_LIST_CONFIG_CODE;
		var searchcriteria = new Array();
		if(academyLocationData != ""){
			searchcriteria.push({paramCode:"ACADEMY_LOCATION_IDS", paramValues:academyLocationData});
		}
		if(value.templateType != ""){
			searchcriteria.push({paramCode:"REPORT_TYPE_ID", paramValues:[value.templateType]});
		}
		if(templateName != ""){
			searchcriteria.push({paramCode:"TEMPLATE_NAME", paramValues:[templateName]});
		}
		values.searchCriterias=searchcriteria;
		return values;
	},
	
	showAddTemplatingMapping:function(){
		var $this =this;
		var contentpanel = this.getContentPanel();
		var addtemplatemapping = Ext.widget('addtemplatemapping');
		var tabName = getCommonTranslation('ADD_TEMPLATE_MAPPING');
		
		 var getcontroller=$this.getController('menu.CoreERPNavigationController');
    	 var getTab=getcontroller.getTab(tabName);
    	 if(getTab!=null){
    		 contentpanel.remove(getTab, true);
    	 }
    	 
		openTab(contentpanel, tabName, addtemplatemapping,CONSTANTS.MENU_COLOR_THIRTEEN);	
	},
	/**
	 * Upload and download logo
	 */
//	uploadlogo:function(photoFileImage,profileImage,form){
	uploadlogo:function(){
		var $this = this;
		var form = $this.getAddtemplatemapping();
		$this.saveTemplatePhotoUpload(form, null, SERVERURL.TEMPLATE_MULTIPLE_UPLOAD, SERVERURL.TEMPLATE_DOWNLOAD_DOC, function(success){
			if(success){
				console.log('SUCCESS');
//				$this.saveUpdateTemplate();
			}
		});
	},
	saveTemplatePhotoUpload : function(form,personId, uplaodUrl, downloadUrl, callback){
		var this$ = this;
		var photoFileImage = form.down('#primaryPhotoUploadForm');
		var secondaryFileImage = form.down('#secondaryPhotoUploadForm');
		var footerFileImage = form.down('#footerPhotoUploadForm');
		var waterMarkFileImage = form.down('#waterMarkPhotoUploadForm');
		
		var fileUploadPath = photoFileImage.getValue();
		var secondaryUploadPath = secondaryFileImage.getValue();
		var footerUploadPath = footerFileImage.getValue();
		var waterMarkUploadPath = waterMarkFileImage.getValue();
		
		
		if( !isNullOrEmpty(fileUploadPath) || !isNullOrEmpty(secondaryUploadPath) ||
				!isNullOrEmpty(footerUploadPath) || !isNullOrEmpty(waterMarkUploadPath)){
			
			var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
			var extension1 = secondaryUploadPath.substring(secondaryUploadPath.lastIndexOf('.') + 1).toLowerCase();
			var extension2 = footerUploadPath.substring(footerUploadPath.lastIndexOf('.') + 1).toLowerCase();
			var extension3 = waterMarkUploadPath.substring(waterMarkUploadPath.lastIndexOf('.') + 1).toLowerCase();
			
			if ((extension == "gif" ||extension1 == "gif" || extension2 == "gif" ||  extension3 == "gif")||
				(extension == "png" || extension1 == "png"|| extension2 == "png" || extension3 == "png")||	
				(extension == "bmp" || extension1 == "bmp"|| extension2 == "bmp" || extension3 == "bmp")||	 
				(extension == "jpeg"|| extension1 == "jpeg"|| extension2 == "jpeg" || extension3 == "jpeg")||		 
				(extension == "jpg"|| extension1 == "jpg"|| extension2 == "jpg" || extension3 == "jpg")) {
				
				//create invisible temp form and submit 
				form.getForm().submit({
					method : 'POST',
					url : uplaodUrl,
					success : function(form1, action){
						callback(true);
						var form = this$.getAddtemplatemapping();
						var responseData = Ext.decode(action.response.responseText);
						if(responseData.LIST.length > 0){
							for(var i in responseData.LIST){
							
								if(!isNullOrEmpty(responseData.LIST[i].headerImagePrimary)){
									form.getForm().findField('headerImagePrimary1').setValue(responseData.LIST[i].headerImagePrimary);
								}else if(!isNullOrEmpty(responseData.LIST[i].headerImageSecondary)){
									form.getForm().findField('headerImageSecondary1').setValue(responseData.LIST[i].headerImageSecondary);
								}else if(!isNullOrEmpty(responseData.LIST[i].footerImageFileDetail)){
									form.getForm().findField('footerImageFileDetail1').setValue(responseData.LIST[i].footerImageFileDetail);
								}else if(!isNullOrEmpty(responseData.LIST[i].watermarkImageFileDetail)){
									form.getForm().findField('watermarkImageFileDetail1').setValue(responseData.LIST[i].watermarkImageFileDetail);
								}
//								var path = responseData[i].headerImagePrimary;
//								var form = this$.getAddtemplatemapping();
//								form.getForm().findField('logo').setValue(path);
							}
							this$.saveUpdateTemplate();
							form.getForm().findField('headerImagePrimary1').reset();
							form.getForm().findField('headerImageSecondary1').reset();
							form.getForm().findField('footerImageFileDetail1').reset();
							form.getForm().findField('watermarkImageFileDetail1').reset();
							
						}
//						this$.saveUpdateTemplate();
//						showSuccessMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('PHOTO_UPLOAD_SUCCESS'));
						//this$.setTemplateUploadedPhotoToPersonProfile(downloadUrl,path,profileImage);
					},
					failure: function(form, action) {
			            var  msg = getCommonTranslation('UPLOAD_FILE_TYPE_IS_INVALID');
                        showWarningMessage(getCommonTranslation('ALERT'), msg);
				       
				    }
				});
			}else{
				photoFileImage.reset();
				
				showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
			}
		}else{
			this$.saveUpdateTemplate();
			form.getForm().findField('headerImagePrimary1').reset();
			form.getForm().findField('headerImageSecondary1').reset();
			form.getForm().findField('footerImageFileDetail1').reset();
			form.getForm().findField('watermarkImageFileDetail1').reset();
		}

	},
	// download and show logo
	    setTemplateUploadedPhotoToPersonProfile : function(downloadUrl,path,prfileImage){
	    	var $this = this;
//	    	var form = $this.getAddtemplatemapping();
	    	Ext.Ajax.request({
	    		type: 'rest',
	    		binary: true,
	    		url: downloadUrl+'?path='+path,
	    		method: 'GET',
	    		success : function(response){
	    			if(response.responseBytes.length>0){
	    				var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
//	    				var a=form.down("#profile_image");
//	    				var a=prfileImage.down("#profile_image");
//	    				console.log('a',a);
	    				if(!isNullOrEmpty(blob) && blob != undefined){
	    					var url = window.URL.createObjectURL(blob);
	    					
	    					prfileImage.setSrc(url);
	    					
//		    				console.log('a.getEl()',a.getEl());
////		    				console.log('dom',a.getEl().dom);
//		    				console.log('src',a.getEl().dom.src);
//		    				a.getEl().dom.src=url;
	    				}/*else{
	    					a.setUI(' ');
	    				}*/
	    				
	    			}
	    		}

	    	});
	    },
	    setTemplateUploadedPhotoToPersonProfile1 : function(downloadUrl,path,prfileImage){
	    	var $this = this;
//	    	var form = $this.getAddtemplatemapping();
	    	Ext.Ajax.request({
	    		type: 'rest',
	    		binary: true,
	    		url: downloadUrl+'?path='+path,
	    		method: 'GET',
	    		success : function(response){
	    			if(response.responseBytes.length>0){
	    				var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
//	    				var a=form.down("#profile_image");
//	    				var a=prfileImage.down("#profile_image");
//	    				console.log('a',a);
	    				if(!isNullOrEmpty(blob) && blob != undefined){
	    					var url = window.URL.createObjectURL(blob);
	    					
	    					prfileImage.setSrc(url);
	    					
//		    				console.log('a.getEl()',a.getEl());
////		    				console.log('dom',a.getEl().dom);
//		    				console.log('src',a.getEl().dom.src);
//		    				a.getEl().dom.src=url;
	    				}/*else{
	    					a.setUI(' ');
	    				}*/
	    				
	    			}
	    		}

	    	});
	    },
	    /**
		 * Save and update template mapping data 
		 */
	    saveUpdateTemplate:function(){
	    	var $this = this;
	    	var form = $this.getAddtemplatemapping().getForm();
	    	var values = form.getValues();
	    	console.log('values',values);
	    	var templateCode = form.findField('templateCode').getValue();
	    	var headerImagePrimary = form.findField('headerImagePrimary1').getValue();
	    	var headerImageSecondary = form.findField('headerImageSecondary1').getValue();
	    	var footerImageFileDetail = form.findField('footerImageFileDetail1').getValue();
	    	var watermarkImageFileDetail = form.findField('watermarkImageFileDetail1').getValue();

	    	var al;
	    	var academyLocationData =[];
	    	if(values.academyLocation !="" && values.academyLocation !=null){
	    		for(var i in values.academyLocation){
	    			if(Ext.isObject(values.academyLocation[0])){
	    				al = values.academyLocation[i].get("id");
	    				academyLocationData.push(al);
	    			}else{
	    				al = values.academyLocation[i];
	    				academyLocationData.push(al);
	    			}
	    		}
	    	}	
	    	var templateName = this.getIdValueJson(values.templateName);

	    	var templateMapping =new  Academia.model.setup.templatemapping.TemplateMapping();
	    	templateMapping.set("academyLocation",null);
	    	templateMapping.set("reportTemplate",templateName);
	    	templateMapping.set("templateCode",templateCode);
	    	templateMapping.set("repeatHeaderOnAllPages",values.repeatHeader);
	    	templateMapping.set("repeatFooterOnAllPages",values.repeatFooter);
	    	templateMapping.set("primaryHeaderLogo",headerImagePrimary);
	    	templateMapping.set("secondaryHeaderLogo",headerImageSecondary);
	    	templateMapping.set("footerLogo",footerImageFileDetail);
	    	templateMapping.set("watermarkImage",watermarkImageFileDetail);
	    	
	    	
	    	if(values.id > 0){
	    	templateMapping.set("academyLocation",this.getIdValueJson(values.academyLocation));
	    	}else{
	    	templateMapping.set("academyLocationIds",academyLocationData);
	    	}

	    	var submitUrl;
	    	if (form.findField('id').getSubmitValue() == null
	    			|| form.findField('id').getSubmitValue() == "") {
	    		templateMapping.set("version", null);
	    		submitUrl = SERVERURL.TEMPLATE_SAVE;
	    	} else {
	    		templateMapping.set("id", values.id);
	    		templateMapping.set("version", values.version);
	    		delete templateMapping.data.academyLocationIds;
	    		submitUrl = SERVERURL.TEMPLATE_UPDATE;
	    	}
	    	var formData = Ext.encode(templateMapping.data);
	    	Ext.Ajax.request({
	    		type : 'rest',
	    		url : submitUrl,
	    		jsonData : formData,
	    		method : 'POST',
	    		success : function(form1, action) {
	    			if(form1.responseText == 'SUCCESS'){
	    				showSuccessMessage(getCommonTranslation('ADD_TEMPLATE_MAPPING'),getCommonTranslation('SUCCESS'));
		    			$this.resetTemplateMapping();	
	    			}else if(form1.responseText == 'NOT_UNIQUE'){
	    				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('REPORT_TEMPLATE_NOT_UNIQUE'));	    				
	    			}
	    			
	    			//$this.loadCourseReadingGrid();
	    		}
	    	});
	    },
	editAddTemplatingMapping:function(){
    	var $this = this;
        var grid = $this .getSearchresultgrid();
        if (grid.getSelectionModel().getCount() > 0) {
        	$this .showAddTemplatingMapping();
            var records = grid.getSelectionModel().getSelection();
            if (records != undefined && records != "" && records != null) {
            	var id = records[0].data.REPORT_TEMPLATE_CONFG_ID;
				Ext.Ajax.request({
							type : 'rest',
							url : SERVERURL.TEMPLATE_FIND_BY_ID,
							params : {
								id : id
							},
							method : 'GET',
							success : function(response) {
								var form = $this.getAddtemplatemapping().getForm();
								var data = Ext.decode(response.responseText);
								var templateMapping =new  Academia.model.setup.templatemapping.TemplateMapping(data);
								form.loadRecord(templateMapping);
								
								form.findField('templateType').setReadOnly(true);
								form.findField('templateName').setReadOnly(true);
								
								$this.getAddtemplatemapping().down('#previewTemplateBtn').setDisabled(false);
								
								if(!isNullOrEmpty(data.version)){
									form.findField('version').setValue(data.version);	
								}

								form.findField('repeatHeader').setValue(data.repeatHeaderOnAllPages);
								form.findField('repeatFooter').setValue(data.repeatFooterOnAllPages);

								var templateForm = $this.getAddtemplatemapping();

								var templateType = templateForm.down('#templateType');
								var templateStore = templateType.getStore();
								templateStore.load({
									callback : function(records,operation,success) {
										if (success) {
											templateType.setValue(data.reportType.id);
										}
									}
								});


								var templateName = templateForm.down('#templateName');
								var templateNameStore = templateType.getStore();
								templateNameStore.load({
									params:{
										reportTypeId: data.reportType.id
									},
									callback : function(records,operation,success) {
										if (success) {
											templateName.setValue(data.reportTemplate.id);
											templateName.setDisabled(false);
										}
									}
								});

								var academyLocation = templateForm.down('#academyLocationId');
								var academyLocationStore = templateType.getStore();
								academyLocationStore.load({
									callback : function(records,operation,success) {
										if (success) {
											academyLocation.setValue(data.academyLocation.id);
											academyLocation.setReadOnly(true);
											academyLocation.addCls('multiBrandCampusCls');
										}
									}
								});

								var downloadUrl = SERVERURL.TEMPLATE_DOWNLOAD_MULTIPLE_DOC;
								
								if(!isNullOrEmpty(data.primaryHeaderLogo)){
									var primaryImage = templateForm.down("#Primary_image");
									primaryImage.setVisible(true);
									$this.setTemplateUploadedPhotoToPersonProfile(downloadUrl,data.primaryHeaderLogo,primaryImage);
								} 
								
								if(!isNullOrEmpty(data.secondaryHeaderLogo)){
									var secondaryImage = templateForm.down("#secondary_image");
									secondaryImage.setVisible(true);
									$this.setTemplateUploadedPhotoToPersonProfile1(downloadUrl,data.secondaryHeaderLogo,secondaryImage);
								}
								
								if(!isNullOrEmpty(data.footerLogo)){
									var footerImage = templateForm.down("#footer_image");
									footerImage.setVisible(true);
									$this.setTemplateUploadedPhotoToPersonProfile(downloadUrl,data.footerLogo,footerImage);
								}
								
								if(!isNullOrEmpty(data.watermarkImage)){
									var waterMartkImage = templateForm.down("#waterMark_image");
									waterMartkImage.setVisible(true);
									$this.setTemplateUploadedPhotoToPersonProfile(downloadUrl,data.watermarkImage,waterMartkImage);
								}
									
								
								
//								var resetButton =Ext.ComponentQuery.query('button#cancelBtn')[0];
//								resetButton.setVisible(false);
							}
						});
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
	},
	deleteAddTemplatingMapping:function(){
        var grid = this .getSearchresultgrid();
        if (grid.getSelectionModel().getCount() > 0) {
        	showConfirmMessage(getCommonTranslation('ADD_TEMPLATE_MAPPING'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var record = grid.getSelectionModel().getSelection()[0];
                    var id = record.get("REPORT_TEMPLATE_CONFG_ID");
                    
                    Ext.Ajax.request({
                        method: "GET",
                        type: 'rest',
                        url: SERVERURL.TEMPLATE_DELETE + '?id=' + id ,
                    	headers : {
							'Content-Type' : 'application/json'
						},
                      /*  params: {
                            id: id
                        },*/
                        success: function(form, action) {
                        	showSuccessMessage(getCommonTranslation('ADD_TEMPLATE_MAPPING'),getCommonTranslation('SUCCESS'));
                        	grid.getStore().reload();
                        }
                    });
                }
            });
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    
	},
	/**
	 * Template Mapping view mode
	 */
	viewAddTemplatingMapping:function(){
        this.editAddTemplatingMapping();
        var form = this.getAddtemplatemapping();
        if (form) {
            form.down('#saveBtn').setVisible(false);
            form.down('#cancelBtn').setVisible(false);
            var templatePhotoUploadForm = form.down('#templatePhotoUploadForm');
            if(!isNullOrEmpty(templatePhotoUploadForm)){
            	form.down('#templatePhotoUploadForm').setVisible(false);
            }
            var alFld = form.down('#academyLocationId');
            form = form.getForm();
            toggleReadOnlyFormItems(form, true);
            alFld.addCls('multiBrandCampusCls');
        }
	},
	/**
	 *  Reset Template Mapping 
	 */
	resetTemplateMapping:function(){
		var $this = this ;
		var form = $this.getAddtemplatemapping();
		form.getForm().reset();
		form.down('#Primary_image').setVisible(false);
		form.down('#secondary_image').setVisible(false);
		form.down('#footer_image').setVisible(false);
		form.down('#waterMark_image').setVisible(false);
		/*$this.getAddtemplatemapping().down('#previewTemplateBtn').setDisabled(true);
		$this.getAddtemplatemapping().down('#profile_image').setSrc('');*/
	},
	
	/**
	 *  On click of preview button
	 */
	previewTemplateFunction:function(){
		var $this = this;
		var form = $this.getAddtemplatemapping().getForm();
		var templateId = form.findField('templateName').getValue();

		if(!isNullOrEmpty(templateId)){

			var formWindow = $this.getPreviewtemplate();
			if (!formWindow) {
				Ext.widget('previewtemplate');
				formWindow = $this.getPreviewtemplate();
			}
			formWindow.show();

			var previewForm = $this.getPreviewtemplate();

			var url = SERVERURL.TEMPLATE_PREVIEW;
			Ext.Ajax.request({
				type: 'rest',
				binary: true,
				url: url+'?id='+templateId,
				method: 'GET',
				success : function(response){
					if(response.responseBytes.length>0){
						var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
						if(!isNullOrEmpty(blob) && blob != undefined){
							var url = window.URL.createObjectURL(blob);
							var a=previewForm.down("#profile_image");
							a.getEl().dom.src=url;
						}

					}
				}

			});
		}
},
	
	// toolbar for buttons
gridRenderFunction:function(grid){
	grid.addButtonToolbar();
},
getIdValueJson : function(id, value, code) {
	if (id)
		return {
		id : id,
		value : value,
		code : code
	};
},
openUpolad1:function(){

	var $this = this;
	var formWindow = $this.getUploadtemplatewin();
	if (!formWindow) {
		Ext.widget('uploadtemplatewin');
		formWindow = $this.getUploadtemplatewin();
	}
	formWindow.show();

},
onSelectUploadFileField : function(fileField, value, eOpts){
    if (!isNullOrEmpty(value)) {
        var $this = this;
        value = value.replace('C:\\fakepath\\', '');
        var newValue = value.replace(/ +/g, " ").split(' ').join('_');
        fileField.setRawValue(newValue);
    }
}
});
