/**
 * @author Hareesh Soni
 */
Ext.define('Academia.controller.student.studentIdentityDocumentReport.StudentIdentityDocumentReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['program.ProgramCodeOrNameSmartSearch','personinfo.common.personalinfo.IdentityTypeStore','feeandpayment.managebill.Student','common.ProgramForBillStoreFeePayment','student.report.serviceOptInReport.ServiceOptInReportServiceNameStore','student.report.serviceOptInReport.ServiceOptInReportSeatTypeStore','feeandpayment.finance.FinanceBlokedStudFilterStudentByALStore',
	         'student.report.serviceOptInReport.ServiceOptInReportProgramStore','student.report.serviceOptInReport.ServiceOptInReportBatchStore',
	         'student.report.studentIdentityDocumentReport.StudentIdentityDocumentReportGridStore','student.report.studentIdentityDocumentReport.PeriodNameSearchStore'],
	         views: ['student.studentIdentityDocumentReport.StudentIdentityDocumentReportTabStructure',
	                 'student.studentIdentityDocumentReport.StudentIdentityDocumentReportStructure','student.studentIdentityDocumentReport.StudentIdentityDocumentReportGrid',
	                 'student.studentIdentityDocumentReport.StudentIdentityDocumentReportFilter'],
	                 config : {
	                	 STUDENT_IDENTITY_DOCUMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_IDENTITY_DOCUMENT_REPORTS_PRIVILEGES')
	                 },
	                 refs: [{
	                	 ref: 'studentidentitydocumentreportfilter',
	                	 selector: 'studentidentitydocumentreportfilter'
	                 },{
	                	 ref: 'StudentIdentityDocumentReportGrid',
	                	 selector: 'contentpanel'
	                 },{
	                	 ref: 'studentidentitydocumentreportgrid',
	                	 selector: 'studentidentitydocumentreportgrid'
	                 }],
	            	
	                 init: function(application) {
	                	 this.control({
	                		/* 'studentidentitydocumentreportfilter combo#identityDocumentTypeId': {
	                			 select: function(obj, record){
	                				 var identityDocumentTypeId = record[0].get("id");
	        	                	 var form = obj.up('form');
	        	                	 var programId = form.down('#programId');
	        	                	 var batchId = form.down('#batchId');
	        	                	 var periodId = form.down('#periodId');
	        	                	 programId.reset();
	        	                	 programId.setDisabled(false);
	        	                	 batchId.reset();
	        	                	 periodId.reset();
	        	                	 batchId.setDisabled(true);
	        	                	 periodId.setDisabled(true);
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	        	                	 programId.reset();
	                			 }
	                		 },*/
	                		 'studentidentitydocumentreportfilter combo#programId': {
	                			 select: function(obj, record){
	                				 this.studentIdentityDocumentReportProgSelect(obj, record)
	                			 },
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 /*store.getProxy().extraParams = {
	                					 academyLocationIds: academyLocationId
	                				 };*/
	                				 store.load();
	                			 }
	                		 },
	                		 'studentidentitydocumentreportfilter combo#batchId':{
	                			 select: function(obj, record){
	                				 this.studentIdentityDocumentReportBatchSelect(obj, record)
	                			 }
	                		 },
	                		 'studentidentitydocumentreportfilter button[itemId=searchBtn]' : {
	                			 click : function(form) {
	                				 var grid = this.getStudentidentitydocumentreportgrid();
	                				 var store = grid.getStore();
	                				 var form = this.getStudentidentitydocumentreportfilter();
	                				 form.down('#searchBtn').setDisabled(true);
	                				 var values = form.getForm().getValues();
	                				 store.getProxy().extraParams = {
	                					 identityDocTypeId : values.identityDocumentType,
	                					 academicTermId: values.ACADEMIC_TERM_ID,
	                					 studentId: values.STUDENT_ID,
	                					 programGroupId : values.PROGRAM_GROUP_ID,
	                					 programId : values.programName,
	                					 batchId : values.BATCH_NAME,
	                					 periodId: values.PERIOD_NAME,
	                					 sectionId: values.SECTION_ID,
	                					 issuingFromDate: values.issuingFromDate,
	                					 issuingToDate: values.issuingToDate,
	                					 validityFromDate: values.validityFromDate,
	                					 validityToDate: values.validityToDate,
	                				 }
	                				 store.load({
		               					 callback: function(records, operation, success) {
		               						form.down('#searchBtn').setDisabled(false); 
		               					 }	   
		                               });
	                				 grid.config.searchFilterForm = this.getStudentidentitydocumentreportfilter();
	                			 }
	                		 },
	                		 'studentidentitydocumentreportfilter button[itemId=resetBtn]' : {
	                			 click : function(obj) {
	                				 var form = obj.up('form');
	                				 form.getForm().reset();
	                				 var programCombo = form.down('#programId');
	                				 var batchCombo = form.down('#batchId');
	                				 var periodCombo = form.down('#periodId');
	                				 var sectionCombo = form.down('#section');
	                				 var programGroupCombo = form.down('#Program_Group');
	                				 batchCombo.reset(); 
	                				 periodCombo.reset();
	                				 sectionCombo.reset();
	                				 batchCombo.setDisabled(true); 
	                				 periodCombo.setDisabled(true);
	                				 sectionCombo.setDisabled(true);
	                				 batchCombo.setReadOnly(false); 
	                				 periodCombo.setReadOnly(false); 
	                				 sectionCombo.setReadOnly(false); 
	                				 programCombo.setReadOnly(false); 
	                				 programGroupCombo.setReadOnly(false); 
	                				 var programStore = programCombo.getStore();
	                				 programStore.getProxy().extraParams = {
	                					 qry: ""
	                				 };
	                				 programStore.load();
	                				 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				 var wheatherSchool = alinfomodel.get('wheatherSchool');

	                				 if(form.down('#issuingFromDateId')){
	                					 form.down('#issuingFromDateId').setMinValue(false);
	                					 form.down('#issuingFromDateId').setMaxValue(false);
	                				 }

	                				 if(form.down('#issuingToDateId')){
	                					 form.down('#issuingToDateId').setMinValue(false);
	                					 form.down('#issuingToDateId').setMaxValue(false);
	                				 }

	                				 if(form.down('#validityFromDateId')){
	                					 form.down('#validityFromDateId').setMinValue(false);
	                					 form.down('#validityFromDateId').setMaxValue(false);
	                				 }

	                				 if(form.down('#validityToDateId')){
	                					 form.down('#validityToDateId').setMinValue(false);
	                					 form.down('#validityToDateId').setMaxValue(false);
	                				 }
	                				 var academyLocationId = this.getCurrentAcademyLocation();
	                				 var academicTermCombo = form.down('#academicTerm');
	                				 var academicTermComboStore = academicTermCombo.getStore();
	                				 academicTermComboStore.load({
	                					 callback: function(records, operation, success) {
	                						 for(var i in records){
	                							 if(records[i].data.whetherCurrentAcademicTerm==true){
	                								 academicTermCombo.setValue(records[i].data.id);
	                							 }
	                						 }
	                					 }	   

	                				 });
	                			 }
	                		 },
	                         'studentidentitydocumentreportgrid': {
	                        	 render : function(grid) {
	             					this.doAccessControlValidation(grid, this.getSTUDENT_IDENTITY_DOCUMENT_PERMISSIONS());
	             					var alinfomodel = Academia.model.authentication.ALInfoModel;
	             		    		var wheatherSchool = alinfomodel.get('wheatherSchool');
	             				},
	             				cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	             	 				  if (e.target.tagName == 'A') {
	             	 					  var documentId = record.data.encryptedDocumentId;
	             	 					  if (!isNullOrEmpty(documentId)) {
	             	 						this.getDocumentController().downloadDocumentFile(documentId);
	             	 						//this.getDownloadFileForDocument(documentId);
	             	 					  }
	             	 				  }
	             	 			  }
	                         },
	                         'studentidentitydocumentreportfilter' : {
	                        	 render : function(form) {
	                        		 var identityDocumentTypeId = form.down('#identityDocumentTypeId');
	                        		 var store = identityDocumentTypeId.getStore();
	                        		 var academyLocationId=this.getCurrentAcademyLocation();
	                        		 store.getProxy().extraParams = {
	                        			 academyLocationId: academyLocationId
	                        		 };
	                        		 store.load();

	                        		 var periodId = form.down('#periodId');
	                        		 
	                        		 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                        		 var whetherSchool = alinfomodel.get('wheatherSchool');
	                        		 var period = form.down('#periodId');
	                        		 if(whetherSchool){
	                        			 period.setVisible(false);
	                        		 }

	                        		 var academyLocationId = this.getCurrentAcademyLocation();
	                        		 var program = form.down('#programId');
	                        		 var arr = [];
	                        		 arr.push(academyLocationId);
	                        		 program.reset();
	                        		 /*program.getStore().getProxy().extraParams={
                						academyLocationIds:arr.join()
                					};*/
	                        		 program.getStore().load();
	                        	 }
	                         },
	                         
	                         'studentidentitydocumentreporttabstructure':{
	                        	 render:function(studentidentitydocumentreporttabstructure){
	                        		 this.enableTabforidentityDocumentReportPanel(studentidentitydocumentreporttabstructure);
	                        	 },
	                        	 afterrender:function(structure)
	                        	 {
	                        		 var grid=structure.down('studentidentitydocumentreportgrid');
	                        		 this.getGridHeaderFreeze(grid,structure,true);
	                        	 }
	                         },
		                       'studentidentitydocumentreportfilter customcombobox[itemId=academicTerm]': {
		                    	   render: function(combo) {
		                               var academyLocationId = this.getCurrentAcademyLocation();
		                               combo.getStore().proxy.extraParams = {
		                                       academyLocationId: academyLocationId
		                               };
		                               combo.getStore().load({
		               					 callback: function(records, operation, success) {
		               						 for(var i in records){
		               							 if(records[i].data.whetherCurrentAcademicTerm==true){
		               								 combo.setValue(records[i].data.id);
		               							 }
		               						 }
		               					 }	   
		               				  
		                               });
		                           },
		                           change: function(combo,value){
		                        	   var form = combo.up('form');
		                        	   var programGroup = form.down("#Program_Group");
		                        	   var program = form.down("#programId");
		                        	   var batchId = form.down('#batchId');
		                        	   var period = form.down('#periodId');
		                        	   var section = form.down('#section');
		                        	   var studentField = form.down('#studentId');
		                        	   
		                        	   var academyLocationIds = this.getCurrentAcademyLocation();
		                        	   program.reset();
		                        	   batchId.reset();
		                        	   period.reset();
		                        	   section.reset();
		                        	   programGroup.reset();
		                        	   studentField.reset();
		                        	   batchId.setDisabled(true);
		                        	   program.setReadOnly(false);
		                        	   period.setDisabled(true);
		                        	   section.setDisabled(true);
		                        	   batchId.setReadOnly(false);
		                        	   period.setReadOnly(false);
		                        	   section.setReadOnly(false);
		                        	   programGroup.setReadOnly(false);
		                        	   
		                        	   var academyLocationId = this.getCurrentAcademyLocation();
		                        	   var studentFieldStore = studentField.getStore();
		                        	   studentFieldStore.getProxy().extraParams ={
		                        		   academyLocationId:academyLocationIds,
		                        		   isCommunityReportScreen :true,
		                        		   academicTermId:value
		                        	   };
		                        	   studentFieldStore.load();

		                        	   var programGroupStore = programGroup.getStore();
		                        	   programGroupStore.getProxy().extraParams ={
		                        		   academyLocationId:academyLocationIds,
		                        		   isCommunityReportScreen :true,
		                        		   academicTermId:value
		                        	   };
		                        	   programGroupStore.load();
		                        	   
		                        	   var programStore = program.getStore();
		                        	   programStore.getProxy().extraParams ={
		                        		   academyLocationId:academyLocationIds,
		                        		   isCommunityReportScreen :true,
		                        		   academicTermId:value
		                        	   };
		                        	   programStore.load();
		                           }
		                       },
		                       'studentidentitydocumentreportfilter customcombobox[itemId=Program_Group]': {
		                          	render: function(combo) {
		                                var academyLocationId = this.getCurrentAcademyLocation();
		                                combo.getStore().proxy.extraParams = {
		                                        academyLocationId: academyLocationId
		                                };
		                            },
		                            select: function(obj,record) {
		                         	   var form = obj.up('form');
		                         	   var programGroupId=record[0].getId();
		                         	   var academyLocationIds=this.getCurrentAcademyLocation();
		             				   var program = form.down("#programId");
		                        	   var batchId = form.down('#batchId');
		                        	   var period = form.down('#periodId');
		                        	   var section = form.down('#section');
		             				   var academicTerm = form.down('#academicTerm');
		             				   program.reset();
		             				   batchId.reset();
		             				   period.reset();
		             				   section.reset();
		             				   batchId.setDisabled(true);
		             				   period.setDisabled(true);
		             				   section.setDisabled(true);
		             				   batchId.setReadOnly(false);
		             				   period.setReadOnly(false);
		             				   section.setReadOnly(false);
		             				   program.setReadOnly(false);
		                         	   var programStore = program.getStore();
		                         	   programStore.getProxy().extraParams ={
		                         		   academyLocationId:academyLocationIds,
		                         		   programGroupId:programGroupId,
		                                    isCommunityReportScreen :true,
		                                    academicTermId:academicTerm.getValue()
		                         	   };
		                         	   programStore.load({
		               					 callback: function(records, operation, success) {
		               						 if(records.length==1){
		               							 program.setValue(records[0].get('id'));
		               							 program.setReadOnly(true);											

		               							 var programId = records[0].get("id");
		               							 if(programId > 0){	    	        					  
		               								 var batchIdStore = batchId.getStore();
		               								 batchIdStore.getProxy().extraParams = {
		               								   id: programId,
		               			                       isCommunityReportScreen :true,
		               			                       academicTermId:academicTerm.getValue()
		               								 };
		               								 batchIdStore.load({
		               									 callback: function(records, operation, success) {
		               										 if(records.length==1){
		               											 batchId.setValue(records[0].get('id'));
		               											 batchId.setDisabled(false);
		               											 batchId.setReadOnly(true);
		               											 var batchIdVal = records[0].get('id');
		               											 if(batchIdVal > 0){	  
		               												 var periodStore = period.getStore();
		               												period.setDisabled(false);
		               												periodStore.getProxy().extraParams = {
		               												   id: batchIdVal,
		               							                       isCommunityReportScreen :true,
		               							                       academicTermId:academicTerm.getValue()
		               												 };
		               												periodStore.load({
		               													 callback: function(records, operation, success) {
		               														 if(records.length==1){
		               															period.setValue(records[0].get('id'));
		               															period.setDisabled(false);
		               															period.setReadOnly(true);
		               															var periodIdVal = records[0].get('id');
		               															if(periodIdVal> 0){	  
		               				  												var sectionStore = section.getStore();
		               				  												section.setDisabled(false);
		               				  											    sectionStore.getProxy().extraParams = {
		               				  											    	batchIds: batchIdVal,
		               				  							                         isCommunityReportScreen :true,
		               				  						                             academicTermId:academicTerm.getValue()
		               				  												 };
		               				  											    sectionStore.load({
		               				  													 callback: function(records, operation, success) {
		               				  														 if(records.length==1){
		               				  															section.setValue(records[0].get('id'));
		               				  															section.setDisabled(false);
		               				  															section.setReadOnly(true);
		               				  														 }
		               				  													 }
		               				  												 });
		               				  											 }
		               														 }else{
		             				  												var sectionStore = section.getStore();
		             				  												section.setDisabled(false);
		             				  											    sectionStore.getProxy().extraParams = {
		             				  											    	batchIds: batchIdVal,
		             				  							                         isCommunityReportScreen :true,
		             				  						                             academicTermId:academicTerm.getValue()
		             				  												 };
		             				  											    sectionStore.load({
		             				  													 callback: function(records, operation, success) {
		             				  														 if(records.length==1){
		             				  															section.setValue(records[0].get('id'));
		             				  															section.setDisabled(false);
		             				  															section.setReadOnly(true);
		             				  														 }
		             				  													 }
		             				  												 });
		             				  											 
		               														 }
		               													 }
		               												 });
		               											 }
		               										 }
		               									 }
		               								 });
		               							 }
		               						 }	
		               					 }
		                         	   });
		                            }
		                        },
		                        'studentidentitydocumentreportfilter customcombobox[itemId=studentId]': {
		                     	   render: function(combo) {
		                                var academyLocationId = this.getCurrentAcademyLocation();
		                                combo.getStore().proxy.extraParams = {
		                                        academyLocationId: academyLocationId,
		                                        isCommunityReportScreen:true
		                                };
		                                combo.getStore().load();
		                            },   
		                            select: function(obj,record) {
		                            	var form = obj.up('form');
		                            	var studentId=record[0].data.admissionID;
		                            	var academyLocationIds=this.getCurrentAcademyLocation();
		                            	var programGroup = form.down("#Program_Group");
		                            	var program = form.down("#programId");
		                            	var batchId = form.down('#batchId');
		                            	var period = form.down('#periodId');
		                            	var section = form.down('#section');
		                            	var academicTerm = form.down('#academicTerm');
		                            	programGroup.reset();
		                            	program.reset();
		                            	batchId.reset();
		                            	period.reset();
		                            	section.reset();
		                            	batchId.setDisabled(true);
		                            	period.setDisabled(true);
		                            	section.setDisabled(true);
		                            	batchId.setReadOnly(false);
		                            	period.setReadOnly(false);
		                            	section.setReadOnly(false);
		                            	programGroup.setReadOnly(false);
		                            	program.setReadOnly(false);
		                            	var programGroupStore = programGroup.getStore();
		                            	programGroupStore.getProxy().extraParams ={
		                            		academyLocationId:academyLocationIds,
		                            		admissionId:studentId,
		                            		isCommunityReportScreen :true,
		                            		academicTermId:academicTerm.getValue()
		                            	};
		                            	programGroupStore.load({
		                            		callback: function(records, operation, success) {
		                            			if(records.length==1){
		                            				programGroup.setValue(records[0].get('id'));
		                            				programGroup.setReadOnly(true);											

		                            				var programGroupId = records[0].get("id");
		                            				if(programGroupId > 0){	    	        					  
		                            					var programStore = program.getStore();
		                            					programStore.getProxy().extraParams = {
		                            						admissionId: studentId,
		                            						academyLocationId:academyLocationIds,
		                            						isCommunityReportScreen :true,
		                            						academicTermId:academicTerm.getValue()
		                            					};
		                            					programStore.load({
		                            						callback: function(records, operation, success) {
		                            							if(records.length==1){
		                            								program.setValue(records[0].get('id'));
		                            								program.setReadOnly(true);											

		                            								var programId = records[0].get("id");
		                            								if(programId > 0){	    	        					  
		                            									var batchIdStore = batchId.getStore();
		                            									batchId.setDisabled(false);
		                            									batchIdStore.getProxy().extraParams = {
		                            										id: programId,
		                            										admissionId: studentId,
		                            										isCommunityReportScreen :true,
		                            										academicTermId:academicTerm.getValue()
		                            									};
		                            									batchIdStore.load({
		                            										callback: function(records, operation, success) {
		                            											if(records.length==1){
		                            												batchId.setValue(records[0].get('id'));
		                            												batchId.setDisabled(false);
		                            												batchId.setReadOnly(true);
		                            												var batchIdVal = records[0].get('id');
		                            												if(batchIdVal > 0){	  
		                            													var periodStore = period.getStore();
		                            													period.setDisabled(false);
		                            													periodStore.getProxy().extraParams = {
		                            														id: batchIdVal,
		                            														admissionId: studentId,
		                            														isCommunityReportScreen :true,
		                            														academicTermId:academicTerm.getValue()
		                            													};
		                            													periodStore.load({
		                            														callback: function(records, operation, success) {
		                            															if(records.length==1){
		                            																period.setValue(records[0].get('id'));
		                            																period.setDisabled(false);
		                            																period.setReadOnly(true);
		                            																var periodIdVal = records[0].get('id');
		                            																if(periodIdVal> 0){	  
		                            																	var sectionStore = section.getStore();
		                            																	section.setDisabled(false);
		                            																	sectionStore.getProxy().extraParams = {
		                            																		batchIds: batchIdVal,
		                            																		admissionId: studentId,
		                            																		isCommunityReportScreen :true,
		                            																		academicTermId:academicTerm.getValue()
		                            																	};
		                            																	sectionStore.load({
		                            																		callback: function(records, operation, success) {
		                            																			if(records.length==1){
		                            																				section.setValue(records[0].get('id'));
		                            																				section.setDisabled(false);
		                            																				section.setReadOnly(true);
		                            																			}
		                            																		}
		                            																	});
		                            																}
		                            															}
		                            														}
		                            													});
		                            												}
		                            											}
		                            										}
		                            									});
		                            								}
		                            							}	
		                            						}
		                            					});
		                            				}
		                            			}	
		                            		}
		                            	});
		                            }
		                           },
		                           'studentidentitydocumentreportfilter customcombobox[itemId=periodId]': {
		                           	select : function(obj, record) {
		                   				var academyLocationIds = this.getCurrentAcademyLocation();
		                   				var form = obj.up('form');
		                   				var section = form.down('#section');
		                   				var academicTerm = form.down('#academicTerm');
		                   				var batchId = form.down('#batchId');
		                   				section.reset();
		                   				section.setReadOnly(false);
		                   				var periodIdVal = record[0].get('id');
		                   				if(periodIdVal > 0){	  
		                   					var sectionIdStore = section.getStore();
		                   					section.setDisabled(false);
		                   					sectionIdStore.getProxy().extraParams = {
		                   						batchIds: batchId.getValue(),
		               	                        isCommunityReportScreen :true,
		               	                        academicTermId:academicTerm.getValue()
		                   					};
		                   					sectionIdStore.load({
		               							callback: function(records, operation, success) {
		               								if(records.length==1){
		               									section.setValue(records[0].get('id'));
		               									section.setDisabled(false);
		               									section.setReadOnly(true);
		               								}
		               							}
		               						});
		                   				}
		                   			}
		                           }
	                	 });
	                 },
	                 
	                 enableTabforidentityDocumentReportPanel:function(studentidentitydocumentreporttabstructure)
	                 {
	                	 this.showTabforidentityDocumentReportPanel(studentidentitydocumentreporttabstructure);
	                 },
	                 
	                 showTabforidentityDocumentReportPanel : function(studentidentitydocumentreporttabstructure) {
					  	   var panelItem = new Array();
					  	   var $this = this;
					  	   var newcont=studentidentitydocumentreporttabstructure.items.items.length;
					  	   var insertPosition=newcont+1;
					  		   panelItem.push({
					  			   xtype:'tabpanel',
					  			   itemId:'allVisibleTP',
					  			   plain: true,
					  			   style:{overflow:'hidden !important',margin:'0!important'},
					  			   bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
					  			   frame: false,
					  			   border:false,
					  			   defaults: {
					  				   labelAlign: 'top'
					  			   },
					  			   items:[{
					  					xtype : 'studentidentitydocumentreportstructure',
					  					itemId : 'studentidentitydocumentreportstructure',
					  					title : getCommonTranslation('SEARCH'),
					  					tabCls : 'right-tab'
					  				}, {
					  					xtype: 'advancedsearchquerybuilder',
					  					searchConfigCode: CONSTANTS.CB.STUDENT_IDENTITY_DOCUMENT_LIST_CONFIGCODE,
					  					searchResultViewCode: CONSTANTS.CB.STUDENT_IDENTITY_DOCUMENT_LIST_VIEWCODE,
					  					gridTitle: getCommonTranslation('STUDENT_IDENTITY_DOCUMENT_REPORT'),
					  					tabCls: 'right-tab'
					  			    }]
					  		   });

					  		 studentidentitydocumentreporttabstructure.insert(insertPosition,panelItem);
					     },
	                 studentIdentityDocumentReportProgSelect : function(obj, record) {
	 					var academyLocationIds = this.getCurrentAcademyLocation();
						var form = obj.up('form');
						var program = form.down("#programId");
						var batchId = form.down('#batchId');
						var period = form.down('#periodId');
						var section = form.down('#section');
						var academicTerm = form.down('#academicTerm');
						batchId.reset();
						period.reset();
						section.reset();
						batchId.setDisabled(true);
						period.setDisabled(true);
						section.setDisabled(true);
						batchId.setReadOnly(false);
						period.setReadOnly(false);
						section.setReadOnly(false);
						var programId = record[0].get("id");
						var batchIdStore = batchId.getStore();
						batchId.setDisabled(false);
						batchIdStore.getProxy().extraParams = {
							id: programId,
	                        isCommunityReportScreen :true,
	                        academicTermId:academicTerm.getValue()
						};
						batchIdStore.load({
							callback: function(records, operation, success) {
								if(records.length==1){
									batchId.setValue(records[0].get('id'));
									batchId.setDisabled(false);
									batchId.setReadOnly(true);
									var batchIdVal = records[0].get('id');
									if(batchIdVal > 0){	  
										var periodStore = period.getStore();
										period.setDisabled(false);
										periodStore.getProxy().extraParams = {
											id: batchIdVal,
					                        isCommunityReportScreen :true,
					                        academicTermId:academicTerm.getValue()
										};
										periodStore.load({
											callback: function(records, operation, success) {
												if(records.length==1){
													period.setValue(records[0].get('id'));
													period.setDisabled(false);
													period.setReadOnly(true);
													var periodIdVal = records[0].get('id');
													if(periodIdVal> 0){	  
														var sectionStore = section.getStore();
														section.setDisabled(false);
														sectionStore.getProxy().extraParams = {
															batchIds: batchIdVal,
									                        isCommunityReportScreen :true,
									                        academicTermId:academicTerm.getValue()
														};
														sectionStore.load({
															callback: function(records, operation, success) {
																if(records.length==1){
																	section.setValue(records[0].get('id'));
																	section.setDisabled(false);
																	section.setReadOnly(true);
																}
															}
														});
													}
												}else{
													var sectionStore = section.getStore();
													section.setDisabled(false);
													sectionStore.getProxy().extraParams = {
														batchIds: batchIdVal,
								                        isCommunityReportScreen :true,
								                        academicTermId:academicTerm.getValue()
													};
													sectionStore.load({
														callback: function(records, operation, success) {
															if(records.length==1){
																section.setValue(records[0].get('id'));
																section.setDisabled(false);
																section.setReadOnly(true);
															}
														}
													});
												
												}
											}
										});
									}
								}
							}
						});
					},
	                 studentIdentityDocumentReportBatchSelect : function(obj, record){
	     				var academyLocationIds = this.getCurrentAcademyLocation();
	    				var form = obj.up('form');
	    				var program = form.down('#programId');
	    				var batchId = form.down('#batchId');
	    				var periodId = form.down('#periodId');
	    				var section = form.down('#section');
	    				var academicTerm = form.down('#academicTerm');
	    				periodId.reset();
	    				periodId.setReadOnly(false);
	    				section.reset();
	    				section.setReadOnly(false);
	    				var batchIdVal = record[0].get('id');
	    				if(batchIdVal > 0){	  
	    					var periodIdStore = periodId.getStore();
	    					periodId.setDisabled(false);
	    					periodIdStore.getProxy().extraParams = {
	    						id: batchIdVal,
	                            isCommunityReportScreen :true,
	                            academicTermId:academicTerm.getValue()
	    					};
	    					periodIdStore.load({
	    						callback: function(records, operation, success) {
	    							if(records.length==1){
	    								periodId.setValue(records[0].get('id'));
	    								periodId.setDisabled(false);
	    								periodId.setReadOnly(true);
	    								var periodIdVal = records[0].get('id');
	    								if(periodIdVal> 0){	  
	    									var sectionStore = section.getStore();
	    									section.setDisabled(false);
	    									sectionStore.getProxy().extraParams = {
	    										batchIds: batchIdVal,
	    				                        isCommunityReportScreen :true,
	    				                        academicTermId:academicTerm.getValue()	
	    									};
	    									sectionStore.load({
	    										callback: function(records, operation, success) {
	    											if(records.length==1){
	    												section.setValue(records[0].get('id'));
	    												section.setDisabled(false);
	    												section.setReadOnly(true);
	    											}
	    										}
	    									});
	    								}
	    							}else{
	    								var sectionStore = section.getStore();
	    								section.setDisabled(false);
	    								sectionStore.getProxy().extraParams = {
	    									batchIds: batchIdVal,
	    			                        isCommunityReportScreen :true,
	    			                        academicTermId:academicTerm.getValue()
	    								};
	    								sectionStore.load({
	    									callback: function(records, operation, success) {
	    										if(records.length==1){
	    											section.setValue(records[0].get('id'));
	    											section.setDisabled(false);
	    											section.setReadOnly(true);
	    										}
	    									}
	    								});
	    							
	    							}
	    						}
	    					});
	    				}
	    			},
	    			getDocumentController : function() {
	    				var this$ = this;
	    				return this$.getController('Academia.controller.document.DocumentController');
	    			}
	                 
});
