/*
 * @author Raghavendra.Soni   
 */
Ext.define('Academia.controller.survey.sendSurvey.SendSurveyController', {
	extend: 'Academia.controller.base.BaseController',
    stores: [],
    views: [
    	'survey.sendSurvey.SendSurveyStructure',
    	'survey.sendSurvey.SendSurveyFilter',
    	'survey.sendSurvey.SendSurveyGrid',
    	'survey.sendSurvey.SendSurveyFilterTwo',
    	'survey.sendSurvey.SendSurveyGridTwo',
    	'survey.sendSurvey.CreateSurveyWindow',
    	'survey.sendSurvey.ActivateSurveyWindow',
    	'survey.sendSurvey.SendSurveyPBSFilter',
    	'survey.sendSurvey.SendSurveyPBSGrid',
    	'survey.sendSurvey.SendSurveyPBSFilterTwo',
    	'survey.sendSurvey.SendSurveyPBSGridTwo',
    	'survey.sendSurvey.CreateSurveyPBSWindow',
    	'survey.sendSurvey.ActivateSurveyPBSWindow',
    	'survey.sendSurvey.SendSurveyAdHocGrid',
    	'survey.sendSurvey.SendSurveyCourseLevelStructure',
    	'survey.sendSurvey.SendSurveyPBSLevelStructure'
    ],
    refs: [{
        ref: 'contentPanel',
        selector: 'contentPanel'
    },{
        ref: 'sendsurveystructure',
        selector: 'sendsurveystructure'
    },{
        ref: 'sendsurveyfilter',
        selector: 'sendsurveyfilter'
    },{
        ref: 'sendsurveygrid',
        selector: 'sendsurveygrid'
    },{
        ref: 'sendsurveyfiltertwo',
        selector: 'sendsurveyfiltertwo'
    },{
    	ref: 'sendsurveygridtwo',
    	selector: 'sendsurveygridtwo'
    },{
    	ref: 'createsurveywindow',
    	selector: 'createsurveywindow'
    },{
    	ref: 'activatesurveywindow',
    	selector: 'activatesurveywindow'
    },{
    	ref: 'sendsurveypbsfilter',
    	selector: 'sendsurveypbsfilter'
    },{
    	ref: 'sendsurveypbsgrid',
    	selector: 'sendsurveypbsgrid'
    },{
    	ref: 'sendsurveypbsfiltertwo',
    	selector: 'sendsurveypbsfiltertwo'
    },{
    	ref: 'sendsurveypbsgridtwo',
    	selector: 'sendsurveypbsgridtwo'
    },{
    	ref: 'createsurveypbswindow',
    	selector: 'createsurveypbswindow'
    },{
    	ref: 'activatesurveypbswindow',
    	selector: 'activatesurveypbswindow'
    },{
    	ref: 'sendsurveyadhocgrid',
    	selector: 'sendsurveyadhocgrid'
    },{
    	ref: 'sendsurveycourselevelstructure',
    	selector: 'sendsurveycourselevelstructure'
    },{
    	ref: 'sendsurveypbslevelstructure',
    	selector: 'sendsurveypbslevelstructure'
    }],
    config: {
    	SEND_SURVEY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SEND_SURVEY_PRIVILEGES')
    },
    init: function(application) {    
        this.control({
        	
        	/* 01 --- START HERE --- Send Survey Structure Related Code ---*/
        	'sendsurveystructure form[itemId=surveyTypeMainFilterForm] [itemId=surveyTypeMainFilterCombo]': {
                change: function(combo, records, eOpts){
                	var me = this;
                	var value = combo.getValue();
                	var structure = combo.up('sendsurveystructure')
                	
                	var option1Pnl = structure.down('#option1Pnl');
                	
                	var option2Pnl = structure.down('#option2Pnl');
                	
                	var option3Pnl = structure.down('#option3Pnl');
                	
                	option1Pnl.hide();
                	
                	option2Pnl.hide();
                	
                	option3Pnl.hide();
                	
                	if(value == "AD_HOC"){
                		option1Pnl.show();
                	}
                	else if(value == "COURSE_LEVEL"){
                		option2Pnl.show();
                	}
                	else if(value == "PBS"){
                		option3Pnl.show();
                	}
                }
            },
            /* 01 --- END HERE --- Send Survey Structure Related Code ---*/
            
            /* 02 --- START HERE --- ADHOC - Send Survey Tab ---*/
            'sendsurveystructure form[itemId=adHocSurveySendForm] button[itemId=optionOneSendSurveyBtn]': {
                click: function(btn) {
                    var form = btn.up('form'); // Get the form panel
                    var surveyListComboField = form.down('#surveyListComboItemId'); // Survey combo field
                    var studentsCodesField = form.down('#studentsCodesField'); // Student codes field
                    var employeeCodesField = form.down('#employeeCodesField'); // Employee codes field
                    var applicantCodesField = form.down('#applicantCodesField'); // Applicant codes field

                    var surveyId = surveyListComboField.getValue(); // Get the selected survey ID
                    var surveyName = surveyListComboField.getDisplayValue(); // Get the survey name

                    // Get values from the three fields
                    var studentsCodes = studentsCodesField.getValue(); // Get student codes value
                    var employeeCodes = employeeCodesField.getValue(); // Get employee codes value
                    var applicantCodes = applicantCodesField.getValue(); // Get applicant codes value

                    // Check if at least one of the fields is filled
                    if (!studentsCodes.trim() && !employeeCodes.trim() && !applicantCodes.trim()) {
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ATLEAST_ONE_SHOULD_BE_NON_EMPTY_MSG'));
                        return; // Exit if no field is filled
                    }

                    // Build the idsObject in the same format as before
                    var idsObject = {
                        studentCodes: studentsCodes.trim() ? studentsCodes : "", // If student codes are filled, use them
                        employeeCodes: employeeCodes.trim() ? employeeCodes : "", // If employee codes are filled, use them
                        applicantCodes: applicantCodes.trim() ? applicantCodes : "" // If applicant codes are filled, use them
                    };

                    // Make sure at least one of the fields has a non-empty value
                    if (!idsObject.studentCodes && !idsObject.employeeCodes && !idsObject.applicantCodes) {
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ATLEAST_ONE_SHOULD_BE_NON_EMPTY_MSG'));
                        return; // Exit if no valid codes
                    }
                    
                    var surveyListComboFieldStore = surveyListComboField.getStore();
                    var surveyListComboFieldRecord = surveyListComboFieldStore.getAt(surveyListComboFieldStore.findExact(surveyListComboField.valueField, surveyListComboField.getValue()));
                    var isAnonymized = surveyListComboFieldRecord ? surveyListComboFieldRecord.raw.isAnonymized : null;  // Safely check if record exists

                    // Set result to false if isAnonymized is null or false, otherwise true
                    var isAnonymous = (isAnonymized === true);  // result will be true if isAnonymized is true, false otherwise

                    // Make the AJAX request to submit the survey data
                    Ext.Ajax.request({
                        url: SERVERURL.PATH_CREATE_ADHOC_SURVEY, // Server URL
                        method: 'POST', // POST method
                        jsonData: { // Send the data in JSON format
                            surveyId: surveyId,
                            idsObject: idsObject,
                            surveyName: surveyName,
                            isAnonymized: isAnonymous,
                            expires: surveyListComboFieldRecord.data.expires,
                            startdate: surveyListComboFieldRecord.data.startdate
                        },
                        success: function(response, opts) {
                            Ext.getBody().unmask(); // Unmask the body when the request completes
                            showSuccessMessage(getCommonTranslation('CREATE_NEW_SURVEY'), getCommonTranslation('SUCCESS')); // Show success message
                        }
                    });
                }
            },
            /* 02 --- END HERE --- ADHOC - Send Survey Tab ---*/
            
            /* 03 --- START HERE --- ADHOC - Search Tab ---*/
            'sendsurveystructure form[itemId=adHocFilterForm] button[itemId=resetAdhocBtn]':{
            	click: function(btn){
            		var form = btn.up('form');
            		
            		var adHocSurveyUserTypeRadioGroupItemId = form.down('#adHocSurveyUserTypeRadioGroupItemId');
            		var surveyNameAdhocItemId = form.down('#surveyNameAdhocItemId');
            		
            		adHocSurveyUserTypeRadioGroupItemId.reset();
            		surveyNameAdhocItemId.reset();
            	}
            },
            
            'sendsurveystructure form[itemId=adHocFilterForm] button[itemId=searchAdhocBtn]':{
            	click: function(btn){
            		var form = btn.up('form');
            		var sendsurveystructure = form.up('sendsurveystructure');
            		var sendsurveyadhocgrid = sendsurveystructure.down('sendsurveyadhocgrid');
            		
            		var adHocSurveyUserTypeRadioGroupItemId = form.down('#adHocSurveyUserTypeRadioGroupItemId');
            		var surveyNameAdhocItemId = form.down('#surveyNameAdhocItemId');
            		
            		var userType = adHocSurveyUserTypeRadioGroupItemId.getValue();
            		var surveyId = surveyNameAdhocItemId.getValue();
            		
            		
            		if(userType.adHocSurveyUserTypeRadio == "student"){
            			sendsurveyadhocgrid.getStore().getProxy().extraParams = {
            				studentUserGroupId:3,
            				surveyId: surveyId
            			}
            		}
            		else if(userType.adHocSurveyUserTypeRadio == "employee"){
            			sendsurveyadhocgrid.getStore().getProxy().extraParams = {
            				employeeGroupId:1,
            				surveyId: surveyId
            			}
            		}
            		else{
            			sendsurveyadhocgrid.getStore().getProxy().extraParams = {
            				applicantGroupId: 7,
            				surveyId: surveyId
            			}
            		}

            		sendsurveyadhocgrid.getStore().load();
            	}
            },
            /* 03 --- END HERE --- ADHOC - Search Tab ---*/
            
            /* 04 --- START HERE --- Course Level - Create/Copy Tab ---*/
            'sendsurveyfilter combo[itemId=academyLocation]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfilter');
            		
            		var academyLocationField = filterForm.down('#academyLocation');
            		var academicTermField = filterForm.down('#academicTerm');
            		var programField = filterForm.down('#programId');
            		var batchField = filterForm.down('#batchId');
            		var periodField = filterForm.down('#periodId');
            		var courseField = filterForm.down('#courseId');
            		var courseVariantField = filterForm.down('#courseVariantId');
            		var facultyField = filterForm.down('#facultyItemId');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemId');
            		var surveyNameField = filterForm.down('#surveyNameItemId');
            		
            		academicTermField.reset();
            		programField.reset();
            		batchField.reset();
            		periodField.reset();
            		courseField.reset();
            		courseVariantField.reset();
            		facultyField.reset();
            		surveyTemplateField.reset();
            		surveyNameField.reset();
            		
            		programField.setDisabled(true);
            		batchField.setDisabled(true);
            		periodField.setDisabled(true);
            		courseField.setDisabled(true);
            		courseVariantField.setDisabled(true);
            		facultyField.setDisabled(true);
            	}
            },
            
            'sendsurveyfilter combo[itemId=academicTerm]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfilter');
            		
            		var academyLocationField = filterForm.down('#academyLocation');
            		var academicTermField = filterForm.down('#academicTerm');
            		var programField = filterForm.down('#programId');
            		var batchField = filterForm.down('#batchId');
            		var periodField = filterForm.down('#periodId');
            		var courseField = filterForm.down('#courseId');
            		var courseVariantField = filterForm.down('#courseVariantId');
            		var facultyField = filterForm.down('#facultyItemId');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemId');
            		var surveyNameField = filterForm.down('#surveyNameItemId');

            		programField.reset();
            		batchField.reset();
            		periodField.reset();
            		courseField.reset();
            		courseVariantField.reset();
            		facultyField.reset();
            		surveyTemplateField.reset();
            		surveyNameField.reset();
            		
            		programField.setDisabled(true);
            		batchField.setDisabled(true);
            		periodField.setDisabled(true);
            		courseField.setDisabled(true);
            		courseVariantField.setDisabled(true);
            		facultyField.setDisabled(true);
            		
            		programField.getStore().getProxy().extraParams = {
            			academyLocationIds: academyLocationField.getValue(),
            			academicTermId:academicTermField.getValue()
            		};
            		
            		programField.getStore().load({
            			callback: function(records, operation, success){
            				if (success) {
            					programField.setDisabled(false);
            					if(records.length == 1){
            						programField.setValue(records[0].data.id);
            						programField.fireEvent('select', programField);
            					}
            					else{
                					//---Enable Course Field too
                					courseField.getStore().getProxy().extraParams = {
                            			academyLocationIds: academyLocationField.getValue(),
                            			academicTermId: academicTermField.getValue()
                            		};
                            		
                            		courseField.getStore().load({
                            			callback: function(records, operation, success){
                            				if (success) {
                            					courseField.setDisabled(false);
                            					if(records.length == 1){
                            						courseField.setValue(records[0].data.id);
                            						courseField.fireEvent('select', courseField);
                            					}
                            				}
                            			}
                            		});
            					}
            				}
            			}
            		});
            	}
            },
            
            'sendsurveyfilter combo[itemId=programId]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfilter');
            		
            		var academyLocationField = filterForm.down('#academyLocation');
            		var academicTermField = filterForm.down('#academicTerm');
            		var programField = filterForm.down('#programId');
            		var batchField = filterForm.down('#batchId');
            		var periodField = filterForm.down('#periodId');
            		var courseField = filterForm.down('#courseId');
            		var courseVariantField = filterForm.down('#courseVariantId');
            		var facultyField = filterForm.down('#facultyItemId');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemId');
            		var surveyNameField = filterForm.down('#surveyNameItemId');
            		
            		batchField.reset();
            		periodField.reset();
            		courseField.reset();
            		courseVariantField.reset();
            		facultyField.reset();
            		surveyTemplateField.reset();
            		surveyNameField.reset();
            		
            		batchField.setDisabled(true);
            		periodField.setDisabled(true);
            		courseField.setDisabled(true);
            		courseVariantField.setDisabled(true);
            		facultyField.setDisabled(true);
            		
            		batchField.getStore().getProxy().extraParams = {
            			academyLocationIds: academyLocationField.getValue(),
            			academicTermId: academicTermField.getValue(),
            			programIds: programField.getValue()
            		};
            		
            		batchField.getStore().load({
            			callback: function(records, operation, success){
            				if (success) {
            					batchField.setDisabled(false);
            					if(records.length == 1){
            						batchField.setValue(records[0].data.id);
            						batchField.fireEvent('select', batchField);
            					}
            					else{
                					//---Enable Course Field too
                					courseField.getStore().getProxy().extraParams = {
                            			academyLocationIds: academyLocationField.getValue(),
                            			academicTermId: academicTermField.getValue(),
                            			programId: programField.getValue()
                            		};
                            		
                            		courseField.getStore().load({
                            			callback: function(records, operation, success){
                            				if (success) {
                            					courseField.setDisabled(false);
                            					if(records.length == 1){
                            						courseField.setValue(records[0].data.id);
                            						courseField.fireEvent('select', courseField);
                            					}
                            				}
                            			}
                            		});
            					}
            				}
            			}
            		});
            	}
            },
            
            'sendsurveyfilter combo[itemId=batchId]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfilter');
            		
            		var academyLocationField = filterForm.down('#academyLocation');
            		var academicTermField = filterForm.down('#academicTerm');
            		var programField = filterForm.down('#programId');
            		var batchField = filterForm.down('#batchId');
            		var periodField = filterForm.down('#periodId');
            		var courseField = filterForm.down('#courseId');
            		var courseVariantField = filterForm.down('#courseVariantId');
            		var facultyField = filterForm.down('#facultyItemId');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemId');
            		var surveyNameField = filterForm.down('#surveyNameItemId');
            		
            		periodField.reset();
            		courseField.reset();
            		courseVariantField.reset();
            		facultyField.reset();
            		surveyTemplateField.reset();
            		surveyNameField.reset();
            		
            		periodField.setDisabled(true);
            		courseField.setDisabled(true);
            		courseVariantField.setDisabled(true);
            		facultyField.setDisabled(true);
            		
            		periodField.getStore().getProxy().extraParams = {
            			academyLocationIds: academyLocationField.getValue(),
            			academicTermId: academicTermField.getValue(),
            			batchIds: batchField.getValue()
            		};
            		
            		periodField.getStore().load({
            			callback: function(records, operation, success){
            				if (success) {
            					periodField.setDisabled(false);
            					if(records.length == 1){
            						periodField.setValue(records[0].data.id);
            						periodField.fireEvent('select', periodField);
            					}
            					else{
                					//---Enable Course Field too
                					courseField.getStore().getProxy().extraParams = {
                            			academyLocationIds: academyLocationField.getValue(),
                            			academicTermId: academicTermField.getValue(),
                            			programId: programField.getValue(),
                            			batchId: batchField.getValue()
                            		};
                            		
                            		courseField.getStore().load({
                            			callback: function(records, operation, success){
                            				if (success) {
                            					courseField.setDisabled(false);
                            					if(records.length == 1){
                            						courseField.setValue(records[0].data.id);
                            						courseField.fireEvent('select', courseField);
                            					}
                            				}
                            			}
                            		});
            					}
            				}
            			}
            		});
            	}
            },
            
            'sendsurveyfilter combo[itemId=periodId]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfilter');
            		
            		var academyLocationField = filterForm.down('#academyLocation');
            		var academicTermField = filterForm.down('#academicTerm');
            		var programField = filterForm.down('#programId');
            		var batchField = filterForm.down('#batchId');
            		var periodField = filterForm.down('#periodId');
            		var courseField = filterForm.down('#courseId');
            		var courseVariantField = filterForm.down('#courseVariantId');
            		var facultyField = filterForm.down('#facultyItemId');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemId');
            		var surveyNameField = filterForm.down('#surveyNameItemId');
            		
            		courseField.reset();
            		courseVariantField.reset();
            		facultyField.reset();
            		surveyTemplateField.reset();
            		surveyNameField.reset();
            		
            		courseField.setDisabled(true);
            		courseVariantField.setDisabled(true);
            		facultyField.setDisabled(true);
            		
            		courseField.getStore().getProxy().extraParams = {
            			academyLocationIds: academyLocationField.getValue(),
            			academicTermId: academicTermField.getValue(),
            			programId: programField.getValue(),
            			batchId: batchField.getValue(),
            			periodId: periodField.getValue()
            		};
            		
            		courseField.getStore().load({
            			callback: function(records, operation, success){
            				if (success) {
            					courseField.setDisabled(false);
            					if(records.length == 1){
            						courseField.setValue(records[0].data.id);
            						courseField.fireEvent('select', courseField);
            					}
            				}
            			}
            		});
            	}
            },
            
            'sendsurveyfilter combo[itemId=courseId]':{
            	change: function(field){
            		var me = this;
            		field.fireEvent('select', field);
            	},
            	beforeselect: function(field){
            		var me = this;
            	},
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfilter');
            		
            		var academyLocationField = filterForm.down('#academyLocation');
            		var academicTermField = filterForm.down('#academicTerm');
            		var programField = filterForm.down('#programId');
            		var batchField = filterForm.down('#batchId');
            		var periodField = filterForm.down('#periodId');
            		var courseField = filterForm.down('#courseId');
            		var courseVariantField = filterForm.down('#courseVariantId');
            		var facultyField = filterForm.down('#facultyItemId');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemId');
            		var surveyNameField = filterForm.down('#surveyNameItemId');
            		
            		courseVariantField.reset();
            		facultyField.reset();
            		surveyTemplateField.reset();
            		surveyNameField.reset();
            		
            		courseVariantField.setDisabled(true);
            		facultyField.setDisabled(true);
            		
            		var courseId = courseField.getValue();
            		if(!isNullOrEmpty(courseField.getValue())){
            			if(Ext.isArray(courseField.getValue()) && courseField.getValue().length){
            				var courseListArray = courseField.getValue();
            				if(!isNullOrEmpty(courseListArray[0])){
            					if(Ext.isObject(courseField.getValue()[0])){
            						courseId = Ext.Array.pluck(Ext.Array.pluck(courseField.getValue(),'data'),'id').join();
            					}
            					else{
            						courseId = courseField.getValue().join();
            					}
            				}
            				else{
            					return false;
            				}
            			}
                		else if(!Ext.isNumber(courseField.getValue())){
                			return false;
                		}
            		}
            		else{
            			return false;
            		}
            		
            		courseVariantField.getStore().getProxy().extraParams = {
            			courseId: courseId,
            			batchId:batchField.getValue(),
    					programId:programField.getValue(),
    					periodId:periodField.getValue()
            		};
            		
            		courseVariantField.getStore().load({
            			callback: function(records, operation, success){
            				if (success) {
            					courseVariantField.setDisabled(false);
            					if(records.length == 1){
            						courseVariantField.setValue(records[0].data.id);
            						courseVariantField.fireEvent('select', courseVariantField);
            					}
            				}
            			}
            		});
            	}
            },
            
            'sendsurveyfilter combo[itemId=courseVariantId]':{
            	change: function(field){
            		var me = this;
            		field.fireEvent('select', field);
            	},
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfilter');
            		
            		var academyLocationField = filterForm.down('#academyLocation');
            		var academicTermField = filterForm.down('#academicTerm');
            		var programField = filterForm.down('#programId');
            		var batchField = filterForm.down('#batchId');
            		var periodField = filterForm.down('#periodId');
            		var courseField = filterForm.down('#courseId');
            		var courseVariantField = filterForm.down('#courseVariantId');
            		var facultyField = filterForm.down('#facultyItemId');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemId');
            		var surveyNameField = filterForm.down('#surveyNameItemId');

            		facultyField.reset();
            		surveyTemplateField.reset();
            		surveyNameField.reset();
            		
            		facultyField.setDisabled(true);
            		
            		var courseId = courseField.getValue();
            		if(!isNullOrEmpty(courseField.getValue())){
            			if(Ext.isArray(courseField.getValue()) && courseField.getValue().length){
            				var courseListArray = courseField.getValue();
            				if(!isNullOrEmpty(courseListArray[0])){
            					if(Ext.isObject(courseField.getValue()[0])){
            						courseId = Ext.Array.pluck(Ext.Array.pluck(courseField.getValue(),'data'),'id').join();
            					}
            					else{
            						courseId = courseField.getValue().join();
            					}
            				}
            				else{
            					return false;
            				}
            			}
                		else if(!Ext.isNumber(courseField.getValue())){
                			return false;
                		}
            		}
            		else{
            			return false;
            		}
            		
            		var courseVariantId = courseVariantField.getValue();
            		if(!isNullOrEmpty(courseVariantField.getValue())){
            			if(Ext.isArray(courseVariantField.getValue()) && courseVariantField.getValue().length){
            				var courseListArray = courseVariantField.getValue();
            				if(!isNullOrEmpty(courseListArray[0])){
            					if(Ext.isObject(courseVariantField.getValue()[0])){
            						courseVariantId = Ext.Array.pluck(Ext.Array.pluck(courseVariantField.getValue(),'data'),'id').join();
            					}
            					else{
            						courseVariantId = courseVariantField.getValue().join();
            					}
            				}
            				else{
            					return false;
            				}
            			}
                		else if(!Ext.isNumber(courseVariantField.getValue())){
                			return false;
                		}
            		}
            		else{
            			return false;
            		}
            		
            		//fetching sectionId from courseVariantId;
            		var sectionIdsArray = [];
            		if(!isNullOrEmpty(courseVariantId) && typeof courseVariantId == "number"){
            			courseVariantId = courseVariantId.toString();
            		}
            		Ext.each(courseVariantId.split(","), function(currentCourseVariantId){
            			var recordIdx = courseVariantField.getStore().findExact(courseVariantField.valueField, parseInt(currentCourseVariantId));
            			if(recordIdx != -1){
            				var sectionId = courseVariantField.getStore().getAt(recordIdx).data.sectionId;
            				sectionIdsArray.push(sectionId);
            			}
            		});
            		
            		facultyField.getStore().getProxy().extraParams = {
						academyLocationIds : academyLocationField.getValue(),
						academicTermId : academicTermField.getValue(),
						programId : programField.getValue(),
						batchId : batchField.getValue(),
						periodId : periodField.getValue(),
						courseId : courseId,
						sectionId : sectionIdsArray.join()
					};
            		facultyField.getStore().load({
						callback: function(records, operation, success) {
							if (success) {
								facultyField.setDisabled(false);
            					if(records.length == 1){
            						facultyField.setValue(records[0].data.id);
            						facultyField.fireEvent('select', facultyField);
            					}
							}
						}
					});
            	}
            },
            
            'sendsurveyfilter combo[itemId=facultyItemId]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfilter');
            		
            		var academyLocationField = filterForm.down('#academyLocation');
            		var academicTermField = filterForm.down('#academicTerm');
            		var programField = filterForm.down('#programId');
            		var batchField = filterForm.down('#batchId');
            		var periodField = filterForm.down('#periodId');
            		var courseField = filterForm.down('#courseId');
            		var courseVariantField = filterForm.down('#courseVariantId');
            		var facultyField = filterForm.down('#facultyItemId');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemId');
            		var surveyNameField = filterForm.down('#surveyNameItemId');
            	}
            },
            
            'sendsurveyfilter combo[itemId=surveyTemplateItemId]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfilter');
            		
            		var academyLocationField = filterForm.down('#academyLocation');
            		var academicTermField = filterForm.down('#academicTerm');
            		var programField = filterForm.down('#programId');
            		var batchField = filterForm.down('#batchId');
            		var periodField = filterForm.down('#periodId');
            		var courseField = filterForm.down('#courseId');
            		var courseVariantField = filterForm.down('#courseVariantId');
            		var facultyField = filterForm.down('#facultyItemId');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemId');
            		var surveyNameField = filterForm.down('#surveyNameItemId');
            	}
            },
            
            'sendsurveyfilter combo[itemId=surveyNameItemId]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfilter');
            		
            		var academyLocationField = filterForm.down('#academyLocation');
            		var academicTermField = filterForm.down('#academicTerm');
            		var programField = filterForm.down('#programId');
            		var batchField = filterForm.down('#batchId');
            		var periodField = filterForm.down('#periodId');
            		var courseField = filterForm.down('#courseId');
            		var courseVariantField = filterForm.down('#courseVariantId');
            		var facultyField = filterForm.down('#facultyItemId');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemId');
            		var surveyNameField = filterForm.down('#surveyNameItemId');
            	}
            },
            
            'sendsurveyfilter button[itemId=searchBtn]':{
            	click: function(btn){
            		var me = this;
            		
            		var structure = btn.up('sendsurveystructure');
            		
            		var filterForm = btn.up('sendsurveyfilter');
            		var sendSurveyGrid = structure.down('sendsurveygrid');
            		
            		var sendSurveyGridStore = sendSurveyGrid.getStore();
            		
            		var academyLocationField = filterForm.down('#academyLocation');
            		var academicTermField = filterForm.down('#academicTerm');
            		var programField = filterForm.down('#programId');
            		var batchField = filterForm.down('#batchId');
            		var periodField = filterForm.down('#periodId');
            		var courseField = filterForm.down('#courseId');
            		var courseVariantField = filterForm.down('#courseVariantId');
            		var facultyField = filterForm.down('#facultyItemId');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemId');
            		var surveyNameField = filterForm.down('#surveyNameItemId');
            		var whetherAnonymousCourseLevelField = filterForm.down('#whetherAnonymousCourseLevelItemId'); // Getting the combobox field
            		
            		var courseId = courseField.getValue();
            		if(!isNullOrEmpty(courseField.getValue())){
            			if(Ext.isArray(courseField.getValue()) && courseField.getValue().length){
            				var courseListArray = courseField.getValue();
            				if(!isNullOrEmpty(courseListArray[0])){
            					if(Ext.isObject(courseField.getValue()[0])){
            						courseId = Ext.Array.pluck(Ext.Array.pluck(courseField.getValue(),'data'),'id').join();
            					}
            					else{
            						courseId = courseField.getValue().join();
            					}
            				}
            			}
            		}
            		
            		var courseVariantId = courseVariantField.getValue();
            		if(!isNullOrEmpty(courseVariantField.getValue())){
            			if(Ext.isArray(courseVariantField.getValue()) && courseVariantField.getValue().length){
            				var courseListArray = courseVariantField.getValue();
            				if(!isNullOrEmpty(courseListArray[0])){
            					if(Ext.isObject(courseVariantField.getValue()[0])){
            						courseVariantId = Ext.Array.pluck(Ext.Array.pluck(courseVariantField.getValue(),'data'),'id').join();
            					}
            					else{
            						courseVariantId = courseVariantField.getValue().join();
            					}
            				}
            			}
            		}
            		
            		// Get the value from the "whetherAnonymousCourseLevelItemId" combobox
            		var anonymityValue = whetherAnonymousCourseLevelField.getValue();  // This should return 'Y', 'N', or null

            		// Map 'Y' to true, 'N' to false, and leave null as null
            		if (anonymityValue === 'Y') {
            		    anonymityValue = true;
            		} else if (anonymityValue === 'N') {
            		    anonymityValue = false;
            		} else {
            		    anonymityValue = null;
            		}
            		
            		sendSurveyGridStore.getProxy().extraParams = {
            			academyLocationId: academyLocationField.getValue(),
            			academicTerm: academicTermField.getValue(),
            			programId: programField.getValue(),
            			batchId: batchField.getValue(),
            			periodId: periodField.getValue(),
            			courseId: courseId,
            			courseVariantId: courseVariantId,
            			facultyId: facultyField.getValue(),
            			surveyId:surveyNameField.getValue()
            		};
            		
            		if(anonymityValue != null){
            			sendSurveyGridStore.getProxy().extraParams.isAnonymized = anonymityValue;
            		}
            		
            		sendSurveyGridStore.load();
            	}
            },
            
            'sendsurveyfilter button[itemId=resetBtn]':{
            	click: function(btn){
            		var me = this;
            		
            		var filterForm = btn.up('sendsurveyfilter');
            		
            		var academyLocationField = filterForm.down('#academyLocation');
            		var academicTermField = filterForm.down('#academicTerm');
            		var programField = filterForm.down('#programId');
            		var batchField = filterForm.down('#batchId');
            		var periodField = filterForm.down('#periodId');
            		var courseField = filterForm.down('#courseId');
            		var courseVariantField = filterForm.down('#courseVariantId');
            		var facultyField = filterForm.down('#facultyItemId');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemId');
            		var surveyNameField = filterForm.down('#surveyNameItemId');
            		var whetherAnonymousCourseLevelField = filterForm.down('#whetherAnonymousCourseLevelItemId'); // Getting the combobox field
            		
            		
            		academyLocationField.reset();
            		academicTermField.reset();
            		programField.reset();
            		batchField.reset();
            		periodField.reset();
            		courseField.reset();
            		courseVariantField.reset();
            		facultyField.reset();
            		surveyTemplateField.reset();
            		surveyNameField.reset();
            		whetherAnonymousCourseLevelField.reset();
            		
            		programField.setDisabled(true);
            		batchField.setDisabled(true);
            		periodField.setDisabled(true);
            		courseField.setDisabled(true);
            		courseVariantField.setDisabled(true);
            		facultyField.setDisabled(true);
            	}
            },
            
            'sendsurveygrid button[itemId=createNewSurveyBtn]':{
            	click: function(btn){
            		var me = this;
            		
            		var grid = me.getSendsurveygrid();
        			if(grid.getSelectionModel().getCount()>0){
            			var createsurveywindow = this.getCreatesurveywindow();
            			if(isNullOrEmpty(createsurveywindow)){
            				createsurveywindow = Ext.widget('createsurveywindow');
            			}
            			createsurveywindow.show(); 
        			} else {
        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        			}
            	}
            },
            
            'createsurveywindow button[itemId=createSurveyCreateBtn]':{
            	click: function(btn){
            		var me = this;
            		btn.setDisabled(true);
            		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            		
            		var grid = this.getSendsurveygrid();
            		var selectedRecords = grid.getSelectionModel().getSelection();
            		var win = btn.up('window');
            		
					var	submitUrl=SERVERURL.PATH_COPY_SURVEY;
					
					var submitValue = [];
					Ext.each(selectedRecords, function(currentRecord){
						var selectedRecord = currentRecord.data;
						var academyLocationObj = {};
						var courseObj = {};
						var courseVarientObj = {};
						var programObj = {};
						var batchObj = {};
						var periodObj = {};
						var facultyObj = {};
						var academicTermObj = {};
						
						if(!isNullOrEmpty(selectedRecord.academyLocationId)){
							academyLocationObj = {
								"id": selectedRecord.academyLocationId,
								"code": selectedRecord.academyLocationName,
								"value":""
							};
						}
						if(!isNullOrEmpty(selectedRecord.courseId)){
							courseObj = {
								"id": selectedRecord.courseId,
								"code": selectedRecord.courseName,
								"value":""
							};
						}
						if(!isNullOrEmpty(selectedRecord.courseVariantId)){
							courseVarientObj = {
								"id": selectedRecord.courseVariantId,
								"code": selectedRecord.courseVariantName,
								"value":""
							};
						}
						if(!isNullOrEmpty(selectedRecord.programId)){
							programObj = {
								"id": selectedRecord.programId,
								"code": selectedRecord.programName,
								"value":""
							};
						}
						if(!isNullOrEmpty(selectedRecord.batchId)){
							batchObj = {
								"id": selectedRecord.batchId,
								"code": selectedRecord.batchName
							};
						}
						if(!isNullOrEmpty(selectedRecord.periodId)){
							periodObj = {
								"id": selectedRecord.periodId,
								"code": selectedRecord.periodName,
								"value":""
							};
						}
						if(!isNullOrEmpty(selectedRecord.facultyId)){
							facultyObj = {
								"id": selectedRecord.facultyId,
								"code": selectedRecord.facultyName,
								"value":""
							};
						}
						if(!isNullOrEmpty(selectedRecord.academicTermId)){
							academicTermObj = {
								"id": selectedRecord.academicTermId,
								"code": selectedRecord.academicTermName,
								"value":""
							};
						}
						
						if(win.down('#includePeriodCheckBoxItemId').getValue() && win.down('#includeFacultyCheckBoxItemId').getValue()){
							var finalSurveyName = win.down('#surveyNamePrefixItemId').getValue()+" - "+selectedRecord.courseName+" | "+selectedRecord.programName+" | "+selectedRecord.batchName+" | "+selectedRecord.periodName+" | "+selectedRecord.sectionName+" | "+selectedRecord.facultyName;
						}
						else if(win.down('#includePeriodCheckBoxItemId').getValue() && !win.down('#includeFacultyCheckBoxItemId').getValue()){
							var finalSurveyName = win.down('#surveyNamePrefixItemId').getValue()+" - "+selectedRecord.courseName+" | "+selectedRecord.programName+" | "+selectedRecord.batchName+" | "+selectedRecord.periodName+" | "+selectedRecord.sectionName;
						}
						else if(!win.down('#includePeriodCheckBoxItemId').getValue() && win.down('#includeFacultyCheckBoxItemId').getValue()){
							var finalSurveyName = win.down('#surveyNamePrefixItemId').getValue()+" - "+selectedRecord.courseName+" | "+selectedRecord.programName+" | "+selectedRecord.batchName+" | "+selectedRecord.sectionName+" | "+selectedRecord.facultyName;
						}
						else{
							var finalSurveyName = win.down('#surveyNamePrefixItemId').getValue()+" - "+selectedRecord.courseName+" | "+selectedRecord.programName+" | "+selectedRecord.batchName+" | "+selectedRecord.sectionName;
						}
						
						var surveyField = win.down('#copyFromSurveyItemId');
						
						try{
							var isAnonymized = surveyField.store.getAt(surveyField.store.findExact(surveyField.valueField,surveyField.getValue())).raw.isAnonymized;
						}
						catch(e){
							var isAnonymized = false;
						}
						
						submitValue.push({
					        "surveyId": win.down('#copyFromSurveyItemId').getValue(),
					        "surveyName": finalSurveyName,
					        "academyLocationId": academyLocationObj,
					        "courseId": courseObj,
					        "courseVarientId": courseVarientObj,
					        "programId": programObj,
					        "batchId": batchObj,
					        "periodId": periodObj,
					        "facultyId": facultyObj,
					        "academicTermId": academicTermObj,
					        "isAnonymized": isAnonymized
					    });
					})
					
					
					
		  			Ext.Ajax.request({
  						type : 'rest',
  						url : submitUrl,
  						jsonData : submitValue,
  						method : 'POST',
  						success : function(form, action) {
  							Ext.getBody().unmask();
  							showSuccessMessage(getCommonTranslation('CREATE_NEW_SURVEY'),getCommonTranslation('SUCCESS'));
  							grid.getStore().reload();
  							win.close();
  							grid.up('tabpanel').setActiveTab(1);
  						}
		  			});
            	}
            },
            
            'createsurveywindow button[itemId=createSurveyCancelBtn]':{
            	click: function(btn){
            		var me = this;
            		var win = btn.up('window');
            		win.close();
            	}
            },
            
            'sendsurveygrid':{
        		afterrender: function(grid){
        			this.applySendSurveyGridPivileges(grid, this.getSEND_SURVEY_PERMISSIONS());
        		},
        		cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
        			var me = this;
        			var grid = this.getSendsurveygrid();
        			var columnName = grid.columnManager.columns[ColIdx].dataIndex;

        			if (columnName == 'surveyRemaining' && e.target.tagName == 'A') {
        				me.openSurveyRemainingWindow(grid, record);
        			}
        		},
        		selectionchange:function(view,records){
        			var grid = this.getSendsurveygrid()
        			var createNewSurveyBtn =grid.down('#createNewSurveyBtn');
        			if (records.length >= 1) {
        				createNewSurveyBtn.enable();
        	        } else {
        	            createNewSurveyBtn.disable();
        	        }
        		}
        	},
            /* 04 --- END HERE --- Course Level - Create/Copy Tab ---*/
            
        	
        	
        	
        	
            /* 05 --- START HERE --- Course Level - Send Survey Tab ---*/
        	'sendsurveyfiltertwo combo[itemId=academyLocationtwo]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfiltertwo');
            		
            		var academyLocationField = filterForm.down('#academyLocationtwo');
            		var academicTermField = filterForm.down('#academicTermtwo');
            		var programField = filterForm.down('#programIdtwo');
            		var batchField = filterForm.down('#batchIdtwo');
            		var periodField = filterForm.down('#periodIdtwo');
            		var courseField = filterForm.down('#courseIdtwo');
            		var courseVariantField = filterForm.down('#courseVariantIdtwo');
            		var facultyField = filterForm.down('#facultyItemIdtwo');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemIdtwo');
            		var surveyNameField = filterForm.down('#surveyNameItemIdtwo');
            		
            		academicTermField.reset();
            		programField.reset();
            		batchField.reset();
            		periodField.reset();
            		courseField.reset();
            		courseVariantField.reset();
            		facultyField.reset();
            		surveyTemplateField.reset();
            		surveyNameField.reset();
            		
            		programField.setDisabled(true);
            		batchField.setDisabled(true);
            		periodField.setDisabled(true);
            		courseField.setDisabled(true);
            		courseVariantField.setDisabled(true);
            		facultyField.setDisabled(true);
            	}
            },
            
            'sendsurveyfiltertwo combo[itemId=academicTermtwo]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfiltertwo');
            		
            		var academyLocationField = filterForm.down('#academyLocationtwo');
            		var academicTermField = filterForm.down('#academicTermtwo');
            		var programField = filterForm.down('#programIdtwo');
            		var batchField = filterForm.down('#batchIdtwo');
            		var periodField = filterForm.down('#periodIdtwo');
            		var courseField = filterForm.down('#courseIdtwo');
            		var courseVariantField = filterForm.down('#courseVariantIdtwo');
            		var facultyField = filterForm.down('#facultyItemIdtwo');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemIdtwo');
            		var surveyNameField = filterForm.down('#surveyNameItemIdtwo');

            		programField.reset();
            		batchField.reset();
            		periodField.reset();
            		courseField.reset();
            		courseVariantField.reset();
            		facultyField.reset();
            		surveyTemplateField.reset();
            		surveyNameField.reset();
            		
            		programField.setDisabled(true);
            		batchField.setDisabled(true);
            		periodField.setDisabled(true);
            		courseField.setDisabled(true);
            		courseVariantField.setDisabled(true);
            		facultyField.setDisabled(true);
            		
            		programField.getStore().getProxy().extraParams = {
            			academyLocationIds: academyLocationField.getValue(),
            			academicTermId:academicTermField.getValue()
            		};
            		
            		programField.getStore().load({
            			callback: function(records, operation, success){
            				if (success) {
            					programField.setDisabled(false);
            					if(records.length == 1){
            						programField.setValue(records[0].data.id);
            						programField.fireEvent('select', programField);
            					}
            					else{
                					//---Enable Course Field too
                					courseField.getStore().getProxy().extraParams = {
                            			academyLocationIds: academyLocationField.getValue(),
                            			academicTermId: academicTermField.getValue()
                            		};
                            		
                            		courseField.getStore().load({
                            			callback: function(records, operation, success){
                            				if (success) {
                            					courseField.setDisabled(false);
                            					if(records.length == 1){
                            						courseField.setValue(records[0].data.id);
                            						courseField.fireEvent('select', courseField);
                            					}
                            				}
                            			}
                            		});
            					}
            				}
            			}
            		});
            	}
            },
            
            'sendsurveyfiltertwo combo[itemId=programIdtwo]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfiltertwo');
            		
            		var academyLocationField = filterForm.down('#academyLocationtwo');
            		var academicTermField = filterForm.down('#academicTermtwo');
            		var programField = filterForm.down('#programIdtwo');
            		var batchField = filterForm.down('#batchIdtwo');
            		var periodField = filterForm.down('#periodIdtwo');
            		var courseField = filterForm.down('#courseIdtwo');
            		var courseVariantField = filterForm.down('#courseVariantIdtwo');
            		var facultyField = filterForm.down('#facultyItemIdtwo');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemIdtwo');
            		var surveyNameField = filterForm.down('#surveyNameItemIdtwo');
            		
            		batchField.reset();
            		periodField.reset();
            		courseField.reset();
            		courseVariantField.reset();
            		facultyField.reset();
            		surveyTemplateField.reset();
            		surveyNameField.reset();
            		
            		batchField.setDisabled(true);
            		periodField.setDisabled(true);
            		courseField.setDisabled(true);
            		courseVariantField.setDisabled(true);
            		facultyField.setDisabled(true);
            		
            		
            		var programIds = programField.getValue();
            		if(!isNullOrEmpty(programField.getValue())){
            			if(Ext.isArray(programField.getValue()) && programField.getValue().length){
            				var programListArray = programField.getValue();
            				if(!isNullOrEmpty(programListArray[0])){
            					if(Ext.isObject(programField.getValue()[0])){
            						programIds = Ext.Array.pluck(Ext.Array.pluck(programField.getValue(),'data'),'id').join();
            					}
            					else{
            						programIds = programField.getValue().join();
            					}
            				}
            			}
            		}
            		
            		batchField.getStore().getProxy().extraParams = {
            			academyLocationIds: academyLocationField.getValue(),
            			academicTermId: academicTermField.getValue(),
            			programIds: programIds
            		};
            		
            		batchField.getStore().load({
            			callback: function(records, operation, success){
            				if (success) {
            					batchField.setDisabled(false);
            					if(records.length == 1){
            						batchField.setValue(records[0].data.id);
            						batchField.fireEvent('select', batchField);
            					}
            					else{
                					//---Enable Course Field too
                					courseField.getStore().getProxy().extraParams = {
                            			academyLocationIds: academyLocationField.getValue(),
                            			academicTermId: academicTermField.getValue(),
                            			programIds: programIds
                            		};
                            		
                            		courseField.getStore().load({
                            			callback: function(records, operation, success){
                            				if (success) {
                            					courseField.setDisabled(false);
                            					if(records.length == 1){
                            						courseField.setValue(records[0].data.id);
                            						courseField.fireEvent('select', courseField);
                            					}
                            				}
                            			}
                            		});
            					}
            				}
            			}
            		});
            	}
            },
            
            'sendsurveyfiltertwo combo[itemId=batchIdtwo]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfiltertwo');
            		
            		var academyLocationField = filterForm.down('#academyLocationtwo');
            		var academicTermField = filterForm.down('#academicTermtwo');
            		var programField = filterForm.down('#programIdtwo');
            		var batchField = filterForm.down('#batchIdtwo');
            		var periodField = filterForm.down('#periodIdtwo');
            		var courseField = filterForm.down('#courseIdtwo');
            		var courseVariantField = filterForm.down('#courseVariantIdtwo');
            		var facultyField = filterForm.down('#facultyItemIdtwo');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemIdtwo');
            		var surveyNameField = filterForm.down('#surveyNameItemIdtwo');
            		
            		periodField.reset();
            		courseField.reset();
            		courseVariantField.reset();
            		facultyField.reset();
            		surveyTemplateField.reset();
            		surveyNameField.reset();
            		
            		periodField.setDisabled(true);
            		courseField.setDisabled(true);
            		courseVariantField.setDisabled(true);
            		facultyField.setDisabled(true);
            		
            		var programIds = programField.getValue();
            		if(!isNullOrEmpty(programField.getValue())){
            			if(Ext.isArray(programField.getValue()) && programField.getValue().length){
            				var programListArray = programField.getValue();
            				if(!isNullOrEmpty(programListArray[0])){
            					if(Ext.isObject(programField.getValue()[0])){
            						programIds = Ext.Array.pluck(Ext.Array.pluck(programField.getValue(),'data'),'id').join();
            					}
            					else{
            						programIds = programField.getValue().join();
            					}
            				}
            			}
            		}
            		
            		periodField.getStore().getProxy().extraParams = {
            			academyLocationIds: academyLocationField.getValue(),
            			academicTermId: academicTermField.getValue(),
            			batchIds: batchField.getValue()
            		};
            		
            		periodField.getStore().load({
            			callback: function(records, operation, success){
            				if (success) {
            					periodField.setDisabled(false);
            					if(records.length == 1){
            						periodField.setValue(records[0].data.id);
            						periodField.fireEvent('select', periodField);
            					}
            					else{
                					//---Enable Course Field too
                					courseField.getStore().getProxy().extraParams = {
                            			academyLocationIds: academyLocationField.getValue(),
                            			academicTermId: academicTermField.getValue(),
                            			programIds: programIds,
                            			batchId: batchField.getValue()
                            		};
                            		
                            		courseField.getStore().load({
                            			callback: function(records, operation, success){
                            				if (success) {
                            					courseField.setDisabled(false);
                            					if(records.length == 1){
                            						courseField.setValue(records[0].data.id);
                            						courseField.fireEvent('select', courseField);
                            					}
                            				}
                            			}
                            		});
            					}
            				}
            			}
            		});
            	}
            },
            
            'sendsurveyfiltertwo combo[itemId=periodIdtwo]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfiltertwo');
            		
            		var academyLocationField = filterForm.down('#academyLocationtwo');
            		var academicTermField = filterForm.down('#academicTermtwo');
            		var programField = filterForm.down('#programIdtwo');
            		var batchField = filterForm.down('#batchIdtwo');
            		var periodField = filterForm.down('#periodIdtwo');
            		var courseField = filterForm.down('#courseIdtwo');
            		var courseVariantField = filterForm.down('#courseVariantIdtwo');
            		var facultyField = filterForm.down('#facultyItemIdtwo');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemIdtwo');
            		var surveyNameField = filterForm.down('#surveyNameItemIdtwo');
            		
            		courseField.reset();
            		courseVariantField.reset();
            		facultyField.reset();
            		surveyTemplateField.reset();
            		surveyNameField.reset();
            		
            		courseField.setDisabled(true);
            		courseVariantField.setDisabled(true);
            		facultyField.setDisabled(true);
            		
            		var programIds = programField.getValue();
            		if(!isNullOrEmpty(programField.getValue())){
            			if(Ext.isArray(programField.getValue()) && programField.getValue().length){
            				var programListArray = programField.getValue();
            				if(!isNullOrEmpty(programListArray[0])){
            					if(Ext.isObject(programField.getValue()[0])){
            						programIds = Ext.Array.pluck(Ext.Array.pluck(programField.getValue(),'data'),'id').join();
            					}
            					else{
            						programIds = programField.getValue().join();
            					}
            				}
            			}
            		}
            		
            		courseField.getStore().getProxy().extraParams = {
            			academyLocationIds: academyLocationField.getValue(),
            			academicTermId: academicTermField.getValue(),
            			programIds: programIds,
            			batchId: batchField.getValue(),
            			periodId: periodField.getValue()
            		};
            		
            		courseField.getStore().load({
            			callback: function(records, operation, success){
            				if (success) {
            					courseField.setDisabled(false);
            					if(records.length == 1){
            						courseField.setValue(records[0].data.id);
            						courseField.fireEvent('select', courseField);
            					}
            				}
            			}
            		});
            	}
            },
            
            'sendsurveyfiltertwo combo[itemId=courseIdtwo]':{
            	change: function(field){
            		var me = this;
            		field.fireEvent('select', field);
            	},
            	beforeselect: function(field){
            		var me = this;
            	},
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfiltertwo');
            		
            		var academyLocationField = filterForm.down('#academyLocationtwo');
            		var academicTermField = filterForm.down('#academicTermtwo');
            		var programField = filterForm.down('#programIdtwo');
            		var batchField = filterForm.down('#batchIdtwo');
            		var periodField = filterForm.down('#periodIdtwo');
            		var courseField = filterForm.down('#courseIdtwo');
            		var courseVariantField = filterForm.down('#courseVariantIdtwo');
            		var facultyField = filterForm.down('#facultyItemIdtwo');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemIdtwo');
            		var surveyNameField = filterForm.down('#surveyNameItemIdtwo');
            		
            		courseVariantField.reset();
            		facultyField.reset();
            		surveyTemplateField.reset();
            		surveyNameField.reset();
            		
            		courseVariantField.setDisabled(true);
            		facultyField.setDisabled(true);
            		
            		var programIds = programField.getValue();
            		if(!isNullOrEmpty(programField.getValue())){
            			if(Ext.isArray(programField.getValue()) && programField.getValue().length){
            				var programListArray = programField.getValue();
            				if(!isNullOrEmpty(programListArray[0])){
            					if(Ext.isObject(programField.getValue()[0])){
            						programIds = Ext.Array.pluck(Ext.Array.pluck(programField.getValue(),'data'),'id').join();
            					}
            					else{
            						programIds = programField.getValue().join();
            					}
            				}
            			}
            		}
            		
            		var courseId = courseField.getValue();
            		if(!isNullOrEmpty(courseField.getValue())){
            			if(Ext.isArray(courseField.getValue()) && courseField.getValue().length){
            				var courseListArray = courseField.getValue();
            				if(!isNullOrEmpty(courseListArray[0])){
            					if(Ext.isObject(courseField.getValue()[0])){
            						courseId = Ext.Array.pluck(Ext.Array.pluck(courseField.getValue(),'data'),'id').join();
            					}
            					else{
            						courseId = courseField.getValue().join();
            					}
            				}
            				else{
            					return false;
            				}
            			}
                		else if(!Ext.isNumber(courseField.getValue())){
                			return false;
                		}
            		}
            		else{
            			return false;
            		}
            		
            		courseVariantField.getStore().getProxy().extraParams = {
            			courseId: courseId,
            			batchId:batchField.getValue(),
            			programIds:programIds,
    					periodId:periodField.getValue()
            		};
            		
            		courseVariantField.getStore().load({
            			callback: function(records, operation, success){
            				if (success) {
            					courseVariantField.setDisabled(false);
            					if(records.length == 1){
            						courseVariantField.setValue(records[0].data.id);
            						courseVariantField.fireEvent('select', courseVariantField);
            					}
            				}
            			}
            		});
            	}
            },
            
            'sendsurveyfiltertwo combo[itemId=courseVariantIdtwo]':{
            	change: function(field){
            		var me = this;
            		field.fireEvent('select', field);
            	},
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfiltertwo');
            		
            		var academyLocationField = filterForm.down('#academyLocationtwo');
            		var academicTermField = filterForm.down('#academicTermtwo');
            		var programField = filterForm.down('#programIdtwo');
            		var batchField = filterForm.down('#batchIdtwo');
            		var periodField = filterForm.down('#periodIdtwo');
            		var courseField = filterForm.down('#courseIdtwo');
            		var courseVariantField = filterForm.down('#courseVariantIdtwo');
            		var facultyField = filterForm.down('#facultyItemIdtwo');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemIdtwo');
            		var surveyNameField = filterForm.down('#surveyNameItemIdtwo');

            		facultyField.reset();
            		surveyTemplateField.reset();
            		surveyNameField.reset();
            		
            		facultyField.setDisabled(true);
            		
            		var courseId = courseField.getValue();
            		if(!isNullOrEmpty(courseField.getValue())){
            			if(Ext.isArray(courseField.getValue()) && courseField.getValue().length){
            				var courseListArray = courseField.getValue();
            				if(!isNullOrEmpty(courseListArray[0])){
            					if(Ext.isObject(courseField.getValue()[0])){
            						courseId = Ext.Array.pluck(Ext.Array.pluck(courseField.getValue(),'data'),'id').join();
            					}
            					else{
            						courseId = courseField.getValue().join();
            					}
            				}
            				else{
            					return false;
            				}
            			}
                		else if(!Ext.isNumber(courseField.getValue())){
                			return false;
                		}
            		}
            		else{
            			return false;
            		}
            		
            		var courseVariantId = courseVariantField.getValue();
            		if(!isNullOrEmpty(courseVariantField.getValue())){
            			if(Ext.isArray(courseVariantField.getValue()) && courseVariantField.getValue().length){
            				var courseListArray = courseVariantField.getValue();
            				if(!isNullOrEmpty(courseListArray[0])){
            					if(Ext.isObject(courseVariantField.getValue()[0])){
            						courseVariantId = Ext.Array.pluck(Ext.Array.pluck(courseVariantField.getValue(),'data'),'id').join();
            					}
            					else{
            						courseVariantId = courseVariantField.getValue().join();
            					}
            				}
            				else{
            					return false;
            				}
            			}
                		else if(!Ext.isNumber(courseVariantField.getValue())){
                			return false;
                		}
            		}
            		else{
            			return false;
            		}
            		
            		//fetching sectionId from courseVariantId;
            		var sectionIdsArray = [];
            		if(!isNullOrEmpty(courseVariantId) && typeof courseVariantId == "number"){
            			courseVariantId = courseVariantId.toString();
            		}
            		Ext.each(courseVariantId.split(","), function(currentCourseVariantId){
            			var recordIdx = courseVariantField.getStore().findExact(courseVariantField.valueField, parseInt(currentCourseVariantId));
            			if(recordIdx != -1){
            				var sectionId = courseVariantField.getStore().getAt(recordIdx).data.sectionId;
            				sectionIdsArray.push(sectionId);
            			}
            		});
            		
            		
            		var programIds = programField.getValue();
            		if(!isNullOrEmpty(programField.getValue())){
            			if(Ext.isArray(programField.getValue()) && programField.getValue().length){
            				var programListArray = programField.getValue();
            				if(!isNullOrEmpty(programListArray[0])){
            					if(Ext.isObject(programField.getValue()[0])){
            						programIds = Ext.Array.pluck(Ext.Array.pluck(programField.getValue(),'data'),'id').join();
            					}
            					else{
            						programIds = programField.getValue().join();
            					}
            				}
            			}
            		}
            		
            		facultyField.getStore().getProxy().extraParams = {
						academyLocationIds : academyLocationField.getValue(),
						academicTermId : academicTermField.getValue(),
						programIds : programIds,
						batchId : batchField.getValue(),
						periodId : periodField.getValue(),
						courseId : courseId,
						sectionId : sectionIdsArray.join()
					};
            		facultyField.getStore().load({
						callback: function(records, operation, success) {
							if (success) {
								facultyField.setDisabled(false);
            					if(records.length == 1){
            						facultyField.setValue(records[0].data.id);
            						facultyField.fireEvent('select', facultyField);
            					}
							}
						}
					});
            	}
            },
            
            'sendsurveyfiltertwo combo[itemId=facultyItemIdtwo]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfiltertwo');
            		
            		var academyLocationField = filterForm.down('#academyLocationtwo');
            		var academicTermField = filterForm.down('#academicTermtwo');
            		var programField = filterForm.down('#programIdtwo');
            		var batchField = filterForm.down('#batchIdtwo');
            		var periodField = filterForm.down('#periodIdtwo');
            		var courseField = filterForm.down('#courseIdtwo');
            		var courseVariantField = filterForm.down('#courseVariantIdtwo');
            		var facultyField = filterForm.down('#facultyItemIdtwo');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemIdtwo');
            		var surveyNameField = filterForm.down('#surveyNameItemIdtwo');
            	}
            },
            
            'sendsurveyfiltertwo combo[itemId=surveyTemplateItemIdtwo]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfiltertwo');
            		
            		var academyLocationField = filterForm.down('#academyLocationtwo');
            		var academicTermField = filterForm.down('#academicTermtwo');
            		var programField = filterForm.down('#programIdtwo');
            		var batchField = filterForm.down('#batchIdtwo');
            		var periodField = filterForm.down('#periodIdtwo');
            		var courseField = filterForm.down('#courseIdtwo');
            		var courseVariantField = filterForm.down('#courseVariantIdtwo');
            		var facultyField = filterForm.down('#facultyItemId');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemIdtwo');
            		var surveyNameField = filterForm.down('#surveyNameItemIdtwo');
            	}
            },
            
            'sendsurveyfiltertwo combo[itemId=surveyNameItemIdtwo]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveyfiltertwo');
            		
            		var academyLocationField = filterForm.down('#academyLocationtwo');
            		var academicTermField = filterForm.down('#academicTermtwo');
            		var programField = filterForm.down('#programIdtwo');
            		var batchField = filterForm.down('#batchIdtwo');
            		var periodField = filterForm.down('#periodIdtwo');
            		var courseField = filterForm.down('#courseIdtwo');
            		var courseVariantField = filterForm.down('#courseVariantIdtwo');
            		var facultyField = filterForm.down('#facultyItemIdtwo');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemIdtwo');
            		var surveyNameField = filterForm.down('#surveyNameItemIdtwo');
            	}
            },
            
            'sendsurveyfiltertwo button[itemId=searchBtntwo]':{
            	click: function(btn){
            		var me = this;
            		
            		var structure = btn.up('sendsurveystructure');
            		
            		var filterForm = btn.up('sendsurveyfiltertwo');
            		var sendSurveyGrid = structure.down('sendsurveygridtwo');
            		
            		var sendSurveyGridStore = sendSurveyGrid.getStore();
            		
            		var academyLocationField = filterForm.down('#academyLocationtwo');
            		var academicTermField = filterForm.down('#academicTermtwo');
            		var programField = filterForm.down('#programIdtwo');
            		var batchField = filterForm.down('#batchIdtwo');
            		var periodField = filterForm.down('#periodIdtwo');
            		var courseField = filterForm.down('#courseIdtwo');
            		var courseVariantField = filterForm.down('#courseVariantIdtwo');
            		var facultyField = filterForm.down('#facultyItemIdtwo');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemIdtwo');
            		var surveyNameField = filterForm.down('#surveyNameItemIdtwo');
            		var whetherAnonymousCourseLevelField = filterForm.down('#whetherAnonymousCourseLevelItemIdtwo'); // Getting the combobox field
            		
            		var courseId = courseField.getValue();
            		if(!isNullOrEmpty(courseField.getValue())){
            			if(Ext.isArray(courseField.getValue()) && courseField.getValue().length){
            				var courseListArray = courseField.getValue();
            				if(!isNullOrEmpty(courseListArray[0])){
            					if(Ext.isObject(courseField.getValue()[0])){
            						courseId = Ext.Array.pluck(Ext.Array.pluck(courseField.getValue(),'data'),'id').join();
            					}
            					else{
            						courseId = courseField.getValue().join();
            					}
            				}
            			}
            		}
            		
            		var courseVariantId = courseVariantField.getValue();
            		if(!isNullOrEmpty(courseVariantField.getValue())){
            			if(Ext.isArray(courseVariantField.getValue()) && courseVariantField.getValue().length){
            				var courseListArray = courseVariantField.getValue();
            				if(!isNullOrEmpty(courseListArray[0])){
            					if(Ext.isObject(courseVariantField.getValue()[0])){
            						courseVariantId = Ext.Array.pluck(Ext.Array.pluck(courseVariantField.getValue(),'data'),'id').join();
            					}
            					else{
            						courseVariantId = courseVariantField.getValue().join();
            					}
            				}
            			}
            		}
            		
            		// Get the value from the "whetherAnonymousCourseLevelItemId" combobox
            		var anonymityValue = whetherAnonymousCourseLevelField.getValue();  // This should return 'Y', 'N', or null

            		// Map 'Y' to true, 'N' to false, and leave null as null
            		if (anonymityValue === 'Y') {
            		    anonymityValue = true;
            		} else if (anonymityValue === 'N') {
            		    anonymityValue = false;
            		} else {
            		    anonymityValue = null;
            		}
            		
            		var programIds = programField.getValue();
            		if(!isNullOrEmpty(programField.getValue())){
            			if(Ext.isArray(programField.getValue()) && programField.getValue().length){
            				var programListArray = programField.getValue();
            				if(!isNullOrEmpty(programListArray[0])){
            					if(Ext.isObject(programField.getValue()[0])){
            						programIds = Ext.Array.pluck(Ext.Array.pluck(programField.getValue(),'data'),'id').join();
            					}
            					else{
            						programIds = programField.getValue().join();
            					}
            				}
            			}
            		}
            		
            		
            		sendSurveyGridStore.getProxy().extraParams = {
            			academyLocationId: academyLocationField.getValue(),
            			academicTerm: academicTermField.getValue(),
            			programIds: programIds,
            			batchId: batchField.getValue(),
            			periodId: periodField.getValue(),
            			courseId: courseId,
            			courseVariantId: courseVariantId,
            			facultyId: facultyField.getValue(),
            			surveyId:surveyNameField.getValue()
            		};
            		
            		if(anonymityValue != null){
            			sendSurveyGridStore.getProxy().extraParams.isAnonymized = anonymityValue;
            		}
            		
            		sendSurveyGridStore.load();
            	}
            },
            
            'sendsurveyfiltertwo button[itemId=resetBtntwo]':{
            	click: function(btn){
            		var me = this;
            		
            		var filterForm = btn.up('sendsurveyfiltertwo');
            		
            		var academyLocationField = filterForm.down('#academyLocationtwo');
            		var academicTermField = filterForm.down('#academicTermtwo');
            		var programField = filterForm.down('#programIdtwo');
            		var batchField = filterForm.down('#batchIdtwo');
            		var periodField = filterForm.down('#periodIdtwo');
            		var courseField = filterForm.down('#courseIdtwo');
            		var courseVariantField = filterForm.down('#courseVariantIdtwo');
            		var facultyField = filterForm.down('#facultyItemIdtwo');
            		var surveyTemplateField = filterForm.down('#surveyTemplateItemIdtwo');
            		var surveyNameField = filterForm.down('#surveyNameItemIdtwo');
            		var whetherAnonymousCourseLevelField = filterForm.down('#whetherAnonymousCourseLevelItemIdtwo'); // Getting the combobox field
            		
            		
            		academyLocationField.reset();
            		academicTermField.reset();
            		programField.reset();
            		batchField.reset();
            		periodField.reset();
            		courseField.reset();
            		courseVariantField.reset();
            		facultyField.reset();
            		surveyTemplateField.reset();
            		surveyNameField.reset();
            		whetherAnonymousCourseLevelField.reset();
            		
            		programField.setDisabled(true);
            		batchField.setDisabled(true);
            		periodField.setDisabled(true);
            		courseField.setDisabled(true);
            		courseVariantField.setDisabled(true);
            		facultyField.setDisabled(true);
            	}
            },
            
            'sendsurveygridtwo button[itemId=activateSurveyBtn]':{
            	click: function(btn){
            		var me = this;
            		
            		var grid = me.getSendsurveygridtwo();
        			if(grid.getSelectionModel().getCount()>0){
            			var activatesurveywindow = this.getActivatesurveywindow();
            			if(isNullOrEmpty(activatesurveywindow)){
            				activatesurveywindow = Ext.widget('activatesurveywindow');
            			}
            			activatesurveywindow.show(); 
        			} else {
        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        			}
            	}
            },
            
            'sendsurveygridtwo button[itemId=getParticipantsBtn]':{ //it is now add participants
            	click: function(btn){
            		var me = this;
            		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            		
            		var grid = this.getSendsurveygridtwo();
            		var selectedRecord = grid.getSelectionModel().getSelection();
            		var win = btn.up('window');
            		
            		var isAnonymized = selectedRecord[0].get('isAnonymized') === null ? false : selectedRecord[0].get('isAnonymized');
            		
            		var submitValue = [];
            		Ext.each(selectedRecord, function(currentRecord){
            			submitValue.push({
            				"academiaLimeSurveyId": currentRecord.data.academiaLimeSurveyId,
                			"surveyId": currentRecord.data.surveyId,
                			"academyLocationId": currentRecord.data.academyLocationId,
                			"periodId": currentRecord.data.periodId,
                			"courseVariantId": currentRecord.data.courseVariantId,
                			"sectionId": currentRecord.data.sectionId,
                			"facultyId":currentRecord.data.facultyId
            			});
            		});
            		
            		if(isAnonymized == false){
    					var	submitUrl=SERVERURL.PATH_SURVEY_ADD_PARTICIPANTS;
            		}
            		else{
            			var	submitUrl=SERVERURL.PATH_SURVEY_ADD_PARTICIPANTS_ANONYMIZED;
            		}
					
		  			Ext.Ajax.request({
  						type : 'rest',
  						url : submitUrl,
  						jsonData : submitValue,
  						method : 'POST',
  						success : function(form, action) {
  							Ext.getBody().unmask();
  							showSuccessMessage(getExaminationTranslation('ADD_PARTICIPANTS'),getCommonTranslation('SUCCESS'));
  							grid.getStore().reload();
  						}
		  			});
            	}
            },
            
            'sendsurveygridtwo button[itemId=sendSurveyBtn]':{
            	click: function(btn) {
                    var me = this;
                    
                    // Show confirmation message with 'Send Now' and 'Schedule'
                    Ext.MessageBox.confirm({
                        title: getCommonTranslation('CONFIRM_SEND_SURVEY'), // Title
                        msg: getCommonTranslation('MSG_SEND_SURVEY_CONFIRMATION'), // Message
                        cls: 'warningMessageBox commonMsgBoxCls', // Custom CSS classes
                        buttons: Ext.Msg.YESNO, // Yes/No buttons
                        icon: Ext.Msg.WARNING, // Warning icon
                        buttonText: {
                            yes: getCommonTranslation('SEND'),  // Custom button text for Yes
                            no: getCommonTranslation('SCHEDULE')    // Custom button text for No
                        },
                        callback: function(btn) {
                            if (btn === 'yes') { // User clicked "Send Now"
                                me.sendCourseSurveyNow(btn);
                            } else if (btn === 'no') { // User clicked "Schedule"
                                me.scheduleCourseSurvey(btn);
                            }
                        }
                    });
                }
            },
            
            'activatesurveywindow button[itemId=activateSurveyWinBtn]':{
            	click: function(btn){
            		var me = this;
            		btn.setDisabled(true);
            		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            		
            		var grid = this.getSendsurveygridtwo();
            		var selectedRecord = grid.getSelectionModel().getSelection();
            		var win = btn.up('window');
            		
            		var isAnonymized = selectedRecord[0].get('isAnonymized') === null ? false : selectedRecord[0].get('isAnonymized');
            		
            		var fromDate = win.down('#fromdate').getValue();
            		var toDate = win.down('#todate').getValue();
            		
            		if(isAnonymized == false){
    					var	submitUrl=SERVERURL.PATH_ACTIVATE_SURVEY;
            		}
            		else{
            			var	submitUrl=SERVERURL.PATH_ACTIVATE_SURVEY_ANONYMIZED;
            		}
					
					var submitValue = {
							"academiaSurveyIds": Ext.Array.pluck(Ext.Array.pluck(selectedRecord,'data'),'academiaLimeSurveyId'),
							"surveyStartDate":Ext.Date.format(fromDate, 'Y-m-d') + ' 00:00:00',
							"surveyEndDate":Ext.Date.format(toDate, 'Y-m-d') + ' 23:59:59',   
					};
					
		  			Ext.Ajax.request({
  						type : 'rest',
  						url : submitUrl,
  						jsonData : submitValue,
  						method : 'POST',
  						success : function(form, action) {
  							Ext.getBody().unmask();
  							showSuccessMessage(getExaminationTranslation('ACTIVATE_SURVEY'),getCommonTranslation('SUCCESS'));
  							grid.getStore().reload();
  							win.close();
  						}
		  			});
            	}
            },
            
            'activatesurveywindow button[itemId=activateSurveyWinCancelBtn]':{
            	click: function(btn){
            		var me = this;
            		var win = btn.up('window');
            		win.close();
            	}
            },
            
            'sendsurveygridtwo':{
        		afterrender: function(grid){
        			this.applySendSurveyGridPivileges(grid, this.getSEND_SURVEY_PERMISSIONS());
        		},
        		cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
        			var me = this;
        			var grid = this.getSendsurveygridtwo();
        			var columnName = grid.columnManager.columns[ColIdx].dataIndex;

        			if (columnName == 'surveyRemaining' && e.target.tagName == 'A') {
        				me.openSurveyRemainingWindow(grid, record);
        			}
        		},
        		selectionchange:function(view,records){
        			var grid = this.getSendsurveygridtwo();
        			var activateSurveyBtn =grid.down('#activateSurveyBtn');
        			var getParticipantsBtn =grid.down('#getParticipantsBtn');
        			var sendSurveyBtn =grid.down('#sendSurveyBtn');
        			if (records.length >= 1) {
        				// Check if all surveyStatus is "CREATED"
    	                var allCreated = Ext.Array.every(records, function (rec) {
    	                    return rec.get('surveyStatus') === getCommonTranslation("CREATED");
    	                });

    	                // Check if all surveyStatus is "ACTIVE"
    	                var allActiveAndSurveyRemaining = Ext.Array.every(records, function (rec) {
    	                    return rec.get('surveyStatus') === getCommonTranslation("ACTIVE") && rec.get('totalParticipant') != rec.get('totalSurveyEnrolled');
    	                });

    	                // Check if all surveyStatus is "ACTIVE" and totalParticipant > 0
    	                var allParticipantsReady = Ext.Array.every(records, function (rec) {
    	                    return rec.get('surveyStatus') === getCommonTranslation("ACTIVE") && rec.get('totalParticipant') > 0;
    	                });
    	                
    	                // Determine if all selected records have isAnonymized as either true or false (not mixed)
    	                var isAllSelectedAnymizedSame = true; // Assume it's true initially
    	                var firstIsAnonymized = null;

    	                Ext.Array.each(records, function (rec) {
    	                    var isAnonymized = rec.get('isAnonymized') === null ? false : rec.get('isAnonymized');  // Treat null as false

    	                    if (firstIsAnonymized === null) {
    	                        firstIsAnonymized = isAnonymized; // Set the first value
    	                    } else if (firstIsAnonymized !== isAnonymized) {
    	                        isAllSelectedAnymizedSame = false; // Set to false if there's any mismatch
    	                        return false; // Exit early since the condition is violated
    	                    }
    	                });
    	                
    	                // V2D-477568 - Check if all selected records have totalEmailSent === 0 and surveyStatus === "INACTIVE"
    	                var allInactiveAndNoEmailSent = true;
    	                Ext.each(records, function(rec) {
    	                    if (rec.get('surveyStatus') !== getCommonTranslation("INACTIVE") || rec.get('totalEmailSent') !== 0) {
    	                        allInactiveAndNoEmailSent = false;
    	                        return false; // Exit early
    	                    }
    	                });

    	                // Enable/disable buttons based on conditions
    	                if (allCreated && isAllSelectedAnymizedSame) {
    	                    activateSurveyBtn.enable();
    	                } 
    	                else if (allInactiveAndNoEmailSent && isAllSelectedAnymizedSame) {
    	                    // If all are INACTIVE and totalEmailSent is 0, enable the activate button
    	                    activateSurveyBtn.enable();
    	                } 
    	                else {
    	                    activateSurveyBtn.disable();
    	                }

    	                if (allActiveAndSurveyRemaining && isAllSelectedAnymizedSame) {
    	                    getParticipantsBtn.enable();
    	                } else {
    	                    getParticipantsBtn.disable();
    	                }

    	                if (allParticipantsReady && isAllSelectedAnymizedSame) {
    	                    sendSurveyBtn.enable();
    	                } else {
    	                    sendSurveyBtn.disable();
    	                }
        	        } else {
        	            // Disable all buttons if no records are selected
        	            activateSurveyBtn.disable();
        	            getParticipantsBtn.disable();
        	            sendSurveyBtn.disable();
        	        }
        		}
        	},
            /* 05 --- END HERE --- Course Level - Send Survey Tab ---*/
        	
        	
        	
        	
            
            /* 06 --- START HERE --- PBS Level - Create/Copy Tab ---*/
            'sendsurveypbsfilter combo[itemId=academyLocationPBS]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveypbsfilter');

            		var surveyNameField = filterForm.down('#surveyNamePBSItemId');
            		var academyLocationField = filterForm.down('#academyLocationPBS');
            		var programField = filterForm.down('#programIdPBS');
            		var batchField = filterForm.down('#batchIdPBS');
            		var periodField = filterForm.down('#periodIdPBS');
            		var sectionField = filterForm.down('#sectionIdPBS');
            		
            		programField.reset();
            		batchField.reset();
            		periodField.reset();
            		sectionField.reset();
            		
            		programField.setDisabled(true);
            		batchField.setDisabled(true);
            		periodField.setDisabled(true);
            		sectionField.setDisabled(true);
            		
            		programField.getStore().getProxy().extraParams = {
            			academyLocationIds: academyLocationField.getValue()
            		};
					filterForm.isValid();
            		
            		programField.getStore().load({
            			callback: function(records, operation, success){
            				if (success) {
            					programField.setDisabled(false);
            					if(records.length == 1){
            						programField.setValue(records[0].data.id);
            						programField.fireEvent('select', programField);
            					}
            					filterForm.isValid();
            				}
            			}
            		});
            	}
            },
            
            'sendsurveypbsfilter combo[itemId=programIdPBS]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveypbsfilter');
            		
            		var surveyNameField = filterForm.down('#surveyNamePBSItemId');
            		var academyLocationField = filterForm.down('#academyLocationPBS');
            		var programField = filterForm.down('#programIdPBS');
            		var batchField = filterForm.down('#batchIdPBS');
            		var periodField = filterForm.down('#periodIdPBS');
            		var sectionField = filterForm.down('#sectionIdPBS');
            		
            		batchField.reset();
            		periodField.reset();
            		sectionField.reset();
            		
            		batchField.setDisabled(true);
            		periodField.setDisabled(true);
            		sectionField.setDisabled(true);
					filterForm.isValid();
            		
            		batchField.getStore().getProxy().extraParams = {
            			academyLocationIds: academyLocationField.getValue(),
            			programIds: programField.getValue()
            		};
            		
            		batchField.getStore().load({
            			callback: function(records, operation, success){
            				if (success) {
            					batchField.setDisabled(false);
            					if(records.length == 1){
            						batchField.setValue(records[0].data.id);
            						batchField.fireEvent('select', batchField);
            					}
            					filterForm.isValid();
            				}
            			}
            		});
            	}
            },
            
            'sendsurveypbsfilter combo[itemId=batchIdPBS]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveypbsfilter');
            		
            		var surveyNameField = filterForm.down('#surveyNamePBSItemId');
            		var academyLocationField = filterForm.down('#academyLocationPBS');
            		var programField = filterForm.down('#programIdPBS');
            		var batchField = filterForm.down('#batchIdPBS');
            		var periodField = filterForm.down('#periodIdPBS');
            		var sectionField = filterForm.down('#sectionIdPBS');
            
            		periodField.reset();
            		sectionField.reset();
            		
            		periodField.setDisabled(true);
            		sectionField.setDisabled(true);
					filterForm.isValid();
            		
            		periodField.getStore().getProxy().extraParams = {
            			academyLocationIds: academyLocationField.getValue(),
            			batchIds: batchField.getValue()
            		};
            		
            		periodField.getStore().load({
            			callback: function(records, operation, success){
            				if (success) {
            					periodField.setDisabled(false);
            					if(records.length == 1){
            						periodField.setValue(records[0].data.id);
            						periodField.fireEvent('select', periodField);
            					}
            					filterForm.isValid();
            				}
            			}
            		});
            	}
            },
            
            'sendsurveypbsfilter combo[itemId=periodIdPBS]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveypbsfilter');
            		
            		var surveyNameField = filterForm.down('#surveyNamePBSItemId');
            		var academyLocationField = filterForm.down('#academyLocationPBS');
            		var programField = filterForm.down('#programIdPBS');
            		var batchField = filterForm.down('#batchIdPBS');
            		var periodField = filterForm.down('#periodIdPBS');
            		var sectionField = filterForm.down('#sectionIdPBS');
            		
            		sectionField.reset();
            		
            		sectionField.setDisabled(true);
            		
					filterForm.isValid();
            		
            		sectionField.getStore().getProxy().extraParams = {
            			academyLocationIds: academyLocationField.getValue(),
            			programId: programField.getValue(),
            			batchId: batchField.getValue(),
            			periodId: periodField.getValue()
            		};
            		
            		sectionField.getStore().load({
            			callback: function(records, operation, success){
            				if (success) {
            					sectionField.setDisabled(false);
            					if(records.length == 1){
            						sectionField.setValue(records[0].data.id);
            					}
            					filterForm.isValid();
            				}
            			}
            		});
            	}
            },
            
            'sendsurveypbsfilter button[itemId=searchPBSBtn]':{
            	click: function(btn){
            		var me = this;
            		
            		var structure = btn.up('sendsurveystructure');
            		
            		var filterForm = btn.up('sendsurveypbsfilter');
            		var sendSurveyPBSGrid = structure.down('sendsurveypbsgrid');
            		
            		var sendSurveyPBSGridStore = sendSurveyPBSGrid.getStore();
            		
            		var surveyNameField = filterForm.down('#surveyNamePBSItemId');
            		var academyLocationField = filterForm.down('#academyLocationPBS');
            		var programField = filterForm.down('#programIdPBS');
            		var batchField = filterForm.down('#batchIdPBS');
            		var periodField = filterForm.down('#periodIdPBS');
            		var sectionField = filterForm.down('#sectionIdPBS');
            		var whetherAnonymousPBSLevelField = filterForm.down('#whetherAnonymousPBSLevelItemId'); // Getting the combobox field
            		
            		// Get the value from the "whetherAnonymousPBSLevelItemId" combobox
            		var anonymityValue = whetherAnonymousPBSLevelField.getValue();  // This should return 'Y', 'N', or null

            		// Map 'Y' to true, 'N' to false, and leave null as null
            		if (anonymityValue === 'Y') {
            		    anonymityValue = true;
            		} else if (anonymityValue === 'N') {
            		    anonymityValue = false;
            		} else {
            		    anonymityValue = null;
            		}
            		
            		sendSurveyPBSGridStore.getProxy().extraParams = {
            			academyLocationId: academyLocationField.getValue(),
            			programId: programField.getValue(),
            			batchId: batchField.getValue(),
            			periodId: periodField.getValue(),
            			sectionId: sectionField.getValue(),
            			surveyId:surveyNameField.getValue()
            		};
            		
            		if(anonymityValue != null){
            			sendSurveyPBSGridStore.getProxy().extraParams.isAnonymized = anonymityValue;
            		}
            		
            		sendSurveyPBSGridStore.load();
            	}
            },
            
            'sendsurveypbsfilter button[itemId=resetPBSBtn]':{
            	click: function(btn){
            		var me = this;
            		
            		var filterForm = btn.up('sendsurveypbsfilter');
            		
            		var surveyNameField = filterForm.down('#surveyNamePBSItemId');
            		var academyLocationField = filterForm.down('#academyLocationPBS');
            		var programField = filterForm.down('#programIdPBS');
            		var batchField = filterForm.down('#batchIdPBS');
            		var periodField = filterForm.down('#periodIdPBS');
            		var sectionField = filterForm.down('#sectionIdPBS');
            		var whetherAnonymousPBSLevelField = filterForm.down('#whetherAnonymousPBSLevelItemId'); // Getting the combobox field
            		
            		surveyNameField.reset();
            		academyLocationField.reset();
            		programField.reset();
            		batchField.reset();
            		periodField.reset();
            		sectionField.reset();
            		whetherAnonymousPBSLevelField.reset();
            		
            		programField.setDisabled(true);
            		batchField.setDisabled(true);
            		periodField.setDisabled(true);
            		sectionField.setDisabled(true);
            	}
            },
            
            'sendsurveypbsgrid button[itemId=createNewSurveyPBSBtn]':{
            	click: function(btn){
            		var me = this;
            		
            		var grid = me.getSendsurveypbsgrid();
        			if(grid.getSelectionModel().getCount()>0){
            			var createsurveypbswindow = this.getCreatesurveypbswindow();
            			if(isNullOrEmpty(createsurveypbswindow)){
            				createsurveypbswindow = Ext.widget('createsurveypbswindow');
            			}
            			createsurveypbswindow.show(); 
        			} else {
        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        			}
            	}
            },
            
            'createsurveypbswindow button[itemId=createSurveyCreatePBSBtn]':{
            	click: function(btn){
            		var me = this;
            		btn.setDisabled(true);
            		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            		
            		var grid = this.getSendsurveypbsgrid();
            		var selectedRecords = grid.getSelectionModel().getSelection();
            		var win = btn.up('window');
            		
					var	submitUrl=SERVERURL.PATH_COPY_SURVEY_PBS;
					
					var submitValue = [];
					Ext.each(selectedRecords, function(currentRecord){
						var selectedRecord = currentRecord.data;
						var alObject = {};
						var programObject = {};
						var batchObject =  {};
						var periodObject = {};
						var facultyObject = {};
						var academicTermObject = {};
						var sectionObject = {};
						if(!isNullOrEmpty(selectedRecord.academyLocationId)){
							alObject = {
									"id": selectedRecord.academyLocationId,
									"code": selectedRecord.academyLocationName,
									"value":""
							};
						}
						if(!isNullOrEmpty(selectedRecord.programId)){
							programObject = {
									"id": selectedRecord.programId,
									"code": selectedRecord.programName,
									"value":""
							};
						}
						if(!isNullOrEmpty(selectedRecord.batchId)){
							batchObject = {
									"id": selectedRecord.batchId,
									"code": selectedRecord.batchName
							};
						}
						if(!isNullOrEmpty(selectedRecord.periodId)){
							periodObject = {
									"id": selectedRecord.periodId,
									"code": selectedRecord.periodName,
									"value":""
							};
						}
						if(!isNullOrEmpty(selectedRecord.facultyId)){
							facultyObject = {
									"id": selectedRecord.facultyId,
									"code": selectedRecord.facultyName,
									"value":""
							};
						}
						if(!isNullOrEmpty(selectedRecord.academicTermId)){
							academicTermObject = {
									"id": selectedRecord.academicTermId,
									"code": selectedRecord.academicTermName,
									"value":""
							};
						}
						if(!isNullOrEmpty(selectedRecord.sectionId)){
							sectionObject = {
									"id": selectedRecord.sectionId,
									"code": selectedRecord.sectionName,
									"value":""
							};
						}
						
						
						if(win.down('#includePeriodCheckBoxPBSItemId').getValue() && win.down('#includeFacultyCheckBoxPBSItemId').getValue()){
							var finalSurveyName = win.down('#surveyNamePrefixPBSItemId').getValue()+" - "+selectedRecord.programName+" | "+selectedRecord.batchName+" | "+selectedRecord.periodName+" | "+selectedRecord.sectionName+" | "+selectedRecord.facultyName;
						}
						else if(win.down('#includePeriodCheckBoxPBSItemId').getValue() && !win.down('#includeFacultyCheckBoxPBSItemId').getValue()){
							var finalSurveyName = win.down('#surveyNamePrefixPBSItemId').getValue()+" - "+selectedRecord.programName+" | "+selectedRecord.batchName+" | "+selectedRecord.periodName+" | "+selectedRecord.sectionName;
						}
						else if(!win.down('#includePeriodCheckBoxPBSItemId').getValue() && win.down('#includeFacultyCheckBoxPBSItemId').getValue()){
							var finalSurveyName = win.down('#surveyNamePrefixPBSItemId').getValue()+" - "+selectedRecord.programName+" | "+selectedRecord.batchName+" | "+selectedRecord.sectionName+" | "+selectedRecord.facultyName;
						}
						else{
							var finalSurveyName = win.down('#surveyNamePrefixPBSItemId').getValue()+" - "+selectedRecord.programName+" | "+selectedRecord.batchName+" | "+selectedRecord.sectionName;
						}
						
						
						var surveyField = win.down('#copyFromSurveyPBSItemId');
						
						try{
							var isAnonymized = surveyField.store.getAt(surveyField.store.findExact(surveyField.valueField,surveyField.getValue())).raw.isAnonymized;
						}
						catch(e){
							var isAnonymized = false;
						}
						
						var recordToPush = {
						        "surveyId": win.down('#copyFromSurveyPBSItemId').getValue(),
						        "surveyName": finalSurveyName,
						        "academyLocationId": alObject,
						        "programId": programObject,
						        "batchId": batchObject,
						        "periodId": periodObject,
						        "facultyId": facultyObject,
						        "sectionId": sectionObject,
						        "isAnonymized":isAnonymized
						    };
						submitValue.push(recordToPush);
					})
					
					
					
		  			Ext.Ajax.request({
  						type : 'rest',
  						url : submitUrl,
  						jsonData : submitValue,
  						method : 'POST',
  						success : function(form, action) {
  							Ext.getBody().unmask();
  							showSuccessMessage(getCommonTranslation('CREATE_NEW_SURVEY'),getCommonTranslation('SUCCESS'));
  							grid.getStore().reload();
  							win.close();
  							grid.up('tabpanel').setActiveTab(1);
  						}
		  			});
            	}
            },
            
            'createsurveypbswindow button[itemId=createSurveyCancelPBSBtn]':{
            	click: function(btn){
            		var me = this;
            		var win = btn.up('window');
            		win.close();
            	}
            },
            
            'sendsurveypbsgrid':{
        		afterrender: function(grid){
        			this.applySendSurveyPBSGridPivileges(grid, this.getSEND_SURVEY_PERMISSIONS());
        		},
        		cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
        			var me = this;
        			var grid = this.getSendsurveypbsgrid();
        			var columnName = grid.columnManager.columns[ColIdx].dataIndex;

        			if (columnName == 'surveyRemaining' && e.target.tagName == 'A') {
        				me.openSurveyRemainingWindow(grid, record);
        			}
        		},
        		selectionchange:function(view,records){
        			var grid = this.getSendsurveypbsgrid()
        			var createNewSurveyBtn =grid.down('#createNewSurveyPBSBtn');
        			if (records.length >= 1) {
        				createNewSurveyBtn.enable();
        	        } else {
        	            // Disable all buttons if no records are selected
        	            createNewSurveyBtn.disable();
        	        }
        		}
        	},
            /* 06 --- END HERE --- PBS Level - Create/Copy Tab ---*/
        	
        	
        	
        	
            
            /* 07 --- START HERE --- PBS Level - Send Survey Tab ---*/
        	'sendsurveypbsfiltertwo combo[itemId=academyLocationPBStwo]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveypbsfiltertwo');

            		var surveyNameField = filterForm.down('#surveyNamePBSItemIdtwo');
            		var academyLocationField = filterForm.down('#academyLocationPBStwo');
            		var programField = filterForm.down('#programIdPBStwo');
            		var batchField = filterForm.down('#batchIdPBStwo');
            		var periodField = filterForm.down('#periodIdPBStwo');
            		var sectionField = filterForm.down('#sectionIdPBStwo');
            		
            		programField.reset();
            		batchField.reset();
            		periodField.reset();
            		sectionField.reset();
            		
            		programField.setDisabled(true);
            		batchField.setDisabled(true);
            		periodField.setDisabled(true);
            		sectionField.setDisabled(true);
            		
            		programField.getStore().getProxy().extraParams = {
            			academyLocationIds: academyLocationField.getValue()
            		};
					filterForm.isValid();
            		
            		programField.getStore().load({
            			callback: function(records, operation, success){
            				if (success) {
            					programField.setDisabled(false);
            					if(records.length == 1){
            						programField.setValue(records[0].data.id);
            						programField.fireEvent('select', programField);
            					}
            					filterForm.isValid();
            				}
            			}
            		});
            	}
            },
            
            'sendsurveypbsfiltertwo combo[itemId=programIdPBStwo]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveypbsfiltertwo');
            		
            		var surveyNameField = filterForm.down('#surveyNamePBSItemIdtwo');
            		var academyLocationField = filterForm.down('#academyLocationPBStwo');
            		var programField = filterForm.down('#programIdPBStwo');
            		var batchField = filterForm.down('#batchIdPBStwo');
            		var periodField = filterForm.down('#periodIdPBStwo');
            		var sectionField = filterForm.down('#sectionIdPBStwo');
            		
            		batchField.reset();
            		periodField.reset();
            		sectionField.reset();
            		
            		batchField.setDisabled(true);
            		periodField.setDisabled(true);
            		sectionField.setDisabled(true);
					filterForm.isValid();
            		
            		batchField.getStore().getProxy().extraParams = {
            			academyLocationIds: academyLocationField.getValue(),
            			programIds: programField.getValue()
            		};
            		
            		batchField.getStore().load({
            			callback: function(records, operation, success){
            				if (success) {
            					batchField.setDisabled(false);
            					if(records.length == 1){
            						batchField.setValue(records[0].data.id);
            						batchField.fireEvent('select', batchField);
            					}
            					filterForm.isValid();
            				}
            			}
            		});
            	}
            },
            
            'sendsurveypbsfiltertwo combo[itemId=batchIdPBStwo]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveypbsfiltertwo');
            		
            		var surveyNameField = filterForm.down('#surveyNamePBSItemIdtwo');
            		var academyLocationField = filterForm.down('#academyLocationPBStwo');
            		var programField = filterForm.down('#programIdPBStwo');
            		var batchField = filterForm.down('#batchIdPBStwo');
            		var periodField = filterForm.down('#periodIdPBStwo');
            		var sectionField = filterForm.down('#sectionIdPBStwo');
            
            		periodField.reset();
            		sectionField.reset();
            		
            		periodField.setDisabled(true);
            		sectionField.setDisabled(true);
					filterForm.isValid();
            		
            		periodField.getStore().getProxy().extraParams = {
            			academyLocationIds: academyLocationField.getValue(),
            			batchIds: batchField.getValue()
            		};
            		
            		periodField.getStore().load({
            			callback: function(records, operation, success){
            				if (success) {
            					periodField.setDisabled(false);
            					if(records.length == 1){
            						periodField.setValue(records[0].data.id);
            						periodField.fireEvent('select', periodField);
            					}
            					filterForm.isValid();
            				}
            			}
            		});
            	}
            },
            
            'sendsurveypbsfiltertwo combo[itemId=periodIdPBStwo]':{
            	select: function(field){
            		var me = this;
            		
            		var filterForm = field.up('sendsurveypbsfiltertwo');
            		
            		var surveyNameField = filterForm.down('#surveyNamePBSItemIdtwo');
            		var academyLocationField = filterForm.down('#academyLocationPBStwo');
            		var programField = filterForm.down('#programIdPBStwo');
            		var batchField = filterForm.down('#batchIdPBStwo');
            		var periodField = filterForm.down('#periodIdPBStwo');
            		var sectionField = filterForm.down('#sectionIdPBStwo');
            		
            		sectionField.reset();
            		
            		sectionField.setDisabled(true);
            		
					filterForm.isValid();
            		
            		sectionField.getStore().getProxy().extraParams = {
            			academyLocationIds: academyLocationField.getValue(),
            			programId: programField.getValue(),
            			batchId: batchField.getValue(),
            			periodId: periodField.getValue()
            		};
            		
            		sectionField.getStore().load({
            			callback: function(records, operation, success){
            				if (success) {
            					sectionField.setDisabled(false);
            					if(records.length == 1){
            						sectionField.setValue(records[0].data.id);
            					}
            					filterForm.isValid();
            				}
            			}
            		});
            	}
            },
            
            'sendsurveypbsfiltertwo button[itemId=searchPBSBtntwo]':{
            	click: function(btn){
            		var me = this;
            		
            		var structure = btn.up('sendsurveystructure');
            		
            		var filterForm = btn.up('sendsurveypbsfiltertwo');
            		var sendSurveyPBSGrid = structure.down('sendsurveypbsgridtwo');
            		
            		var sendSurveyPBSGridStore = sendSurveyPBSGrid.getStore();
            		
            		var surveyNameField = filterForm.down('#surveyNamePBSItemIdtwo');
            		var academyLocationField = filterForm.down('#academyLocationPBStwo');
            		var programField = filterForm.down('#programIdPBStwo');
            		var batchField = filterForm.down('#batchIdPBStwo');
            		var periodField = filterForm.down('#periodIdPBStwo');
            		var sectionField = filterForm.down('#sectionIdPBStwo');
            		var whetherAnonymousPBSLevelField = filterForm.down('#whetherAnonymousPBSLevelItemIdtwo'); // Getting the combobox field
            		
            		// Get the value from the "whetherAnonymousPBSLevelItemId" combobox
            		var anonymityValue = whetherAnonymousPBSLevelField.getValue();  // This should return 'Y', 'N', or null

            		// Map 'Y' to true, 'N' to false, and leave null as null
            		if (anonymityValue === 'Y') {
            		    anonymityValue = true;
            		} else if (anonymityValue === 'N') {
            		    anonymityValue = false;
            		} else {
            		    anonymityValue = null;
            		}
            		
            		var sectionId = sectionField.getValue();
            		if(!isNullOrEmpty(sectionField.getValue())){
            			if(Ext.isArray(sectionField.getValue()) && sectionField.getValue().length){
            				var sectionListArray = sectionField.getValue();
            				if(!isNullOrEmpty(sectionListArray[0])){
            					if(Ext.isObject(sectionField.getValue()[0])){
            						sectionId = Ext.Array.pluck(Ext.Array.pluck(sectionField.getValue(),'data'),'sectionId').join();
            					}
            					else{
            						sectionId = sectionField.getValue().join();
            					}
            				}
            			}
            		}
            		
            		sendSurveyPBSGridStore.getProxy().extraParams = {
            			academyLocationId: academyLocationField.getValue(),
            			programId: programField.getValue(),
            			batchId: batchField.getValue(),
            			periodId: periodField.getValue(),
            			sectionId: sectionId,
            			surveyId:surveyNameField.getValue()
            		};
            		
            		if(anonymityValue != null){
            			sendSurveyPBSGridStore.getProxy().extraParams.isAnonymized = anonymityValue;
            		}
            		
            		sendSurveyPBSGridStore.load();
            	}
            },
            
            'sendsurveypbsfiltertwo button[itemId=resetPBSBtntwo]':{
            	click: function(btn){
            		var me = this;
            		
            		var filterForm = btn.up('sendsurveypbsfiltertwo');
            		
            		var surveyNameField = filterForm.down('#surveyNamePBSItemIdtwo');
            		var academyLocationField = filterForm.down('#academyLocationPBStwo');
            		var programField = filterForm.down('#programIdPBStwo');
            		var batchField = filterForm.down('#batchIdPBStwo');
            		var periodField = filterForm.down('#periodIdPBStwo');
            		var sectionField = filterForm.down('#sectionIdPBStwo');
            		var whetherAnonymousPBSLevelField = filterForm.down('#whetherAnonymousPBSLevelItemIdtwo'); // Getting the combobox field
            		
            		surveyNameField.reset();
            		academyLocationField.reset();
            		programField.reset();
            		batchField.reset();
            		periodField.reset();
            		sectionField.reset();
            		whetherAnonymousPBSLevelField.reset();
            		
            		programField.setDisabled(true);
            		batchField.setDisabled(true);
            		periodField.setDisabled(true);
            		sectionField.setDisabled(true);
            	}
            },
            
            'sendsurveypbsgridtwo button[itemId=activateSurveyPBSBtn]':{
            	click: function(btn){
            		var me = this;
            		
            		var grid = me.getSendsurveypbsgridtwo();
        			if(grid.getSelectionModel().getCount()>0){
            			var activatesurveypbswindow = this.getActivatesurveypbswindow();
            			if(isNullOrEmpty(activatesurveypbswindow)){
            				activatesurveypbswindow = Ext.widget('activatesurveypbswindow');
            			}
            			activatesurveypbswindow.show(); 
        			} else {
        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        			}
            	}
            },
            
            'activatesurveypbswindow button[itemId=activateSurveyWinPBSBtn]':{
            	click: function(btn){
            		var me = this;
            		btn.setDisabled(true);
            		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            		
            		var grid = this.getSendsurveypbsgridtwo();
            		var selectedRecord = grid.getSelectionModel().getSelection();
            		var win = btn.up('window');
            		
            		var isAnonymized = selectedRecord[0].get('isAnonymized') === null ? false : selectedRecord[0].get('isAnonymized');
            		
            		var fromDate = win.down('#fromdatePBS').getValue();
            		var toDate = win.down('#todatePBS').getValue();
            		
            		if(isAnonymized == false){
    					var	submitUrl=SERVERURL.PATH_ACTIVATE_SURVEY;
            		}
            		else{
            			var	submitUrl=SERVERURL.PATH_ACTIVATE_SURVEY_ANONYMIZED;
            		}
					
					var submitValue = {
							"academiaSurveyIds": Ext.Array.pluck(Ext.Array.pluck(selectedRecord,'data'),'academiaLimeSurveyId'),
							"surveyStartDate":Ext.Date.format(fromDate, 'Y-m-d') + ' 00:00:00',
							"surveyEndDate":Ext.Date.format(toDate, 'Y-m-d') + ' 23:59:59',   
					};
					
		  			Ext.Ajax.request({
  						type : 'rest',
  						url : submitUrl,
  						jsonData : submitValue,
  						method : 'POST',
  						success : function(form, action) {
  							Ext.getBody().unmask();
  							showSuccessMessage(getExaminationTranslation('ACTIVATE_SURVEY'),getCommonTranslation('SUCCESS'));
  							grid.getStore().reload();
  							win.close();
  						}
		  			});
            	}
            },
            
            'activatesurveypbswindow button[itemId=activateSurveyWinCancelPBSBtn]':{
            	click: function(btn){
            		var me = this;
            		var win = btn.up('window');
            		win.close();
            	}
            },       
            
            'sendsurveypbsgridtwo button[itemId=getParticipantsPBSBtn]':{ //it is now add participants
            	click: function(btn){
            		var me = this;
            		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            		
            		var grid = this.getSendsurveypbsgridtwo();
            		var selectedRecord = grid.getSelectionModel().getSelection();
            		var win = btn.up('window');
            		
            		var isAnonymized = selectedRecord[0].get('isAnonymized') === null ? false : selectedRecord[0].get('isAnonymized');
            		
            		var submitValue = [];
            		Ext.each(selectedRecord, function(currentRecord){
            			submitValue.push({
            				"academiaLimeSurveyId": currentRecord.data.academiaLimeSurveyId,
                			"surveyId": currentRecord.data.surveyId,
                			"academyLocationId": currentRecord.data.academyLocationId,
                			"periodId": currentRecord.data.periodId,
                			"courseVariantId": currentRecord.data.courseVariantId,
                			"sectionId": currentRecord.data.sectionId,
                			"facultyId":currentRecord.data.facultyId,
                			"programId":currentRecord.data.programId,
                			"batchId":currentRecord.data.batchId
            			});
            		});
            		
            		if(isAnonymized == false){
    					var	submitUrl=SERVERURL.PATH_SURVEY_ADD_PARTICIPANTS_PBS;
            		}
            		else{
            			var	submitUrl=SERVERURL.PATH_SURVEY_ADD_PARTICIPANTS_PBS_ANONYMIZED;
            		}
					
		  			Ext.Ajax.request({
  						type : 'rest',
  						url : submitUrl,
  						jsonData : submitValue,
  						method : 'POST',
  						success : function(form, action) {
  							Ext.getBody().unmask();
  							showSuccessMessage(getExaminationTranslation('ADD_PARTICIPANTS'),getCommonTranslation('SUCCESS'));
  							grid.getStore().reload();
  						}
		  			});
            	}
            },
            
            'sendsurveypbsgridtwo button[itemId=sendSurveyPBSBtn]':{
            	click: function(btn) {
                    var me = this;
                    
                    // Show confirmation message with 'Send Now' and 'Schedule'
                    Ext.MessageBox.confirm({
                        title: getCommonTranslation('CONFIRM_SEND_SURVEY'), // Title
                        msg: getCommonTranslation('MSG_SEND_SURVEY_CONFIRMATION'), // Message
                        cls: 'warningMessageBox commonMsgBoxCls', // Custom CSS classes
                        buttons: Ext.Msg.YESNO, // Yes/No buttons
                        icon: Ext.Msg.WARNING, // Warning icon
                        buttonText: {
                            yes: getCommonTranslation('SEND'),  // Custom button text for Yes
                            no: getCommonTranslation('SCHEDULE')    // Custom button text for No
                        },
                        callback: function(btn) {
                            if (btn === 'yes') { // User clicked "Send Now"
                                me.sendPBSSurveyNow(btn);
                            } else if (btn === 'no') { // User clicked "Schedule"
                                me.schedulePBSSurvey(btn);
                            }
                        }
                    });
                }
            },
            
            'sendsurveypbsgridtwo':{
        		afterrender: function(grid){
        			this.applySendSurveyPBSGridPivileges(grid, this.getSEND_SURVEY_PERMISSIONS());
        		},
        		cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
        			var me = this;
        			var grid = this.getSendsurveypbsgridtwo();
        			var columnName = grid.columnManager.columns[ColIdx].dataIndex;

        			if (columnName == 'surveyRemaining' && e.target.tagName == 'A') {
        				me.openSurveyRemainingWindow(grid, record);
        			}
        		},
        		selectionchange:function(view,records){
        			var grid = this.getSendsurveypbsgridtwo()
        			var activateSurveyBtn =grid.down('#activateSurveyPBSBtn');
        			var getParticipantsBtn =grid.down('#getParticipantsPBSBtn');
        			var sendSurveyBtn =grid.down('#sendSurveyPBSBtn');
        			if (records.length >= 1) {
        				// Check if all surveyStatus is "CREATED"
    	                var allCreated = Ext.Array.every(records, function (rec) {
    	                    return rec.get('surveyStatus') === getCommonTranslation("CREATED");
    	                });

    	                // Check if all surveyStatus is "ACTIVE"
    	                var allActiveAndSurveyRemaining = Ext.Array.every(records, function (rec) {
    	                    return rec.get('surveyStatus') === getCommonTranslation("ACTIVE") && rec.get('totalParticipant') != rec.get('totalSurveyEnrolled');
    	                });

    	                // Check if all surveyStatus is "ACTIVE" and totalParticipant > 0
    	                var allParticipantsReady = Ext.Array.every(records, function (rec) {
    	                    return rec.get('surveyStatus') === getCommonTranslation("ACTIVE") && rec.get('totalParticipant') > 0;
    	                });
    	                
    	                // Determine if all selected records have isAnonymized as either true or false (not mixed)
    	                var isAllSelectedAnymizedSame = true; // Assume it's true initially
    	                var firstIsAnonymized = null;

    	                Ext.Array.each(records, function (rec) {
    	                    var isAnonymized = rec.get('isAnonymized') === null ? false : rec.get('isAnonymized');  // Treat null as false

    	                    if (firstIsAnonymized === null) {
    	                        firstIsAnonymized = isAnonymized; // Set the first value
    	                    } else if (firstIsAnonymized !== isAnonymized) {
    	                        isAllSelectedAnymizedSame = false; // Set to false if there's any mismatch
    	                        return false; // Exit early since the condition is violated
    	                    }
    	                });
    	                
    	                // V2D-477568 - Check if all selected records have totalEmailSent === 0 and surveyStatus === "INACTIVE"
    	                var allInactiveAndNoEmailSent = true;
    	                Ext.each(records, function(rec) {
    	                    if (rec.get('surveyStatus') !== getCommonTranslation("INACTIVE") || rec.get('totalEmailSent') !== 0) {
    	                        allInactiveAndNoEmailSent = false;
    	                        return false; // Exit early
    	                    }
    	                });

    	                // Enable/disable buttons based on conditions
    	                if (allCreated && isAllSelectedAnymizedSame) {
    	                    activateSurveyBtn.enable();
    	                } 
    	                else if (allInactiveAndNoEmailSent && isAllSelectedAnymizedSame) {
    	                    // If all are INACTIVE and totalEmailSent is 0, enable the activate button
    	                    activateSurveyBtn.enable();
    	                }
    	                else {
    	                    activateSurveyBtn.disable();
    	                }

    	                if (allActiveAndSurveyRemaining && isAllSelectedAnymizedSame) {
    	                    getParticipantsBtn.enable();
    	                } else {
    	                    getParticipantsBtn.disable();
    	                }

    	                if (allParticipantsReady && isAllSelectedAnymizedSame) {
    	                    sendSurveyBtn.enable();
    	                } else {
    	                    sendSurveyBtn.disable();
    	                }
        	        } else {
        	            // Disable all buttons if no records are selected
        	            activateSurveyBtn.disable();
        	            getParticipantsBtn.disable();
        	            sendSurveyBtn.disable();
        	        }
        		}
        	},
            /* 07 --- END HERE --- PBS Level - Send Survey Tab ---*/
        });
    },
    
    applySendSurveyPBSGridPivileges :  function(grid,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var portalId = this.getCurrentLoggedPortalId();
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

		var createNewSurveyBtn = grid.down('#activateSurveyPBSBtn');
    	var activateSurveyBtn = grid.down('#activateSurveyPBSBtn');
    	var getParticipantsBtn = grid.down('#getParticipantsPBSBtn');
    	var sendSurveyBtn = grid.down('#sendSurveyPBSBtn');
    	var btnExportToPDF = grid.down('#btnExportToPDF');
    	var btnExportToExcel = grid.down('#btnExportToExcel');
    	
    	if(!isNullOrEmpty(createNewSurveyBtn)){
    		createNewSurveyBtn.setVisible(false);
    	}
    	if(!isNullOrEmpty(activateSurveyBtn)){
    		activateSurveyBtn.setVisible(false);
    	}
    	if(!isNullOrEmpty(getParticipantsBtn)){
    		getParticipantsBtn.setVisible(false);
    	}
    	if(!isNullOrEmpty(sendSurveyBtn)){
    		sendSurveyBtn.setVisible(false);
    	}
    	btnExportToPDF.setVisible(false);
    	btnExportToExcel.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'CREATE_NEW_SURVEY') {
        		if(!isNullOrEmpty(createNewSurveyBtn)){
        			setTimeout(function(){
        				createNewSurveyBtn.setVisible(true);
        			},300);
        		}  	     		
        	} else if (privilege === 'ACTIVATE_SURVEY') {
        		if(!isNullOrEmpty(activateSurveyBtn)){
        			setTimeout(function(){
        				activateSurveyBtn.setVisible(true);
        			},300);
        		}        		
        	}else if (privilege === 'GET_PARTICIPANTS') {
        		if(!isNullOrEmpty(getParticipantsBtn)){
        			setTimeout(function(){
        				getParticipantsBtn.setVisible(true);
        			},300);
        		}        		
        	}else if (privilege === 'SENDSURVEY') {
        		if(!isNullOrEmpty(sendSurveyBtn)){
        			setTimeout(function(){
        				sendSurveyBtn.setVisible(true);
        			},300);
        		}        		
        	}else if (privilege === 'EXPORT') {
        		if(!isNullOrEmpty(btnExportToPDF)){
        			setTimeout(function(){
        				btnExportToPDF.setVisible(true);
        				btnExportToExcel.setVisible(true);
        			},300);
        		}        		
        	}
    	});
    },
    
    applySendSurveyGridPivileges :  function(grid,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var portalId = this.getCurrentLoggedPortalId();
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

		var createNewSurveyBtn = grid.down('#createNewSurveyBtn');
    	var activateSurveyBtn = grid.down('#activateSurveyBtn');
    	var getParticipantsBtn = grid.down('#getParticipantsBtn');
    	var sendSurveyBtn = grid.down('#sendSurveyBtn');
    	var btnExportToPDF = grid.down('#btnExportToPDF');
    	var btnExportToExcel = grid.down('#btnExportToExcel');
    	
    	if(!isNullOrEmpty(createNewSurveyBtn)){
    		createNewSurveyBtn.setVisible(false);
    	}
    	if(!isNullOrEmpty(activateSurveyBtn)){
    		activateSurveyBtn.setVisible(false);
    	}
    	if(!isNullOrEmpty(getParticipantsBtn)){
    		getParticipantsBtn.setVisible(false);
    	}
    	if(!isNullOrEmpty(sendSurveyBtn)){
    		sendSurveyBtn.setVisible(false);
    	}
    	btnExportToPDF.setVisible(false);
    	btnExportToExcel.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'CREATE_NEW_SURVEY') {
        		if(!isNullOrEmpty(createNewSurveyBtn)){
        			setTimeout(function(){
        				createNewSurveyBtn.setVisible(true);
        			},300);
        		}  	     		
        	} else if (privilege === 'ACTIVATE_SURVEY') {
        		if(!isNullOrEmpty(activateSurveyBtn)){
        			setTimeout(function(){
        				activateSurveyBtn.setVisible(true);
        			},300);
        		}        		
        	}else if (privilege === 'GET_PARTICIPANTS') {
        		if(!isNullOrEmpty(getParticipantsBtn)){
        			setTimeout(function(){
        				getParticipantsBtn.setVisible(true);
        			},300);
        		}        		
        	}else if (privilege === 'SENDSURVEY') {
        		if(!isNullOrEmpty(sendSurveyBtn)){
        			setTimeout(function(){
        				sendSurveyBtn.setVisible(true);
        			},300);
        		}        		
        	}else if (privilege === 'EXPORT') {
        		if(!isNullOrEmpty(btnExportToPDF)){
        			setTimeout(function(){
        				btnExportToPDF.setVisible(true);
        				btnExportToExcel.setVisible(true);
        			},300);
        		}        		
        	}
    	});
    },
    
    // Function to handle sending survey now
    sendCourseSurveyNow: function(btn) {
        var me = this;
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        
        var grid = me.getSendsurveygridtwo();
        var selectedRecord = grid.getSelectionModel().getSelection();
        
        var submitValue = [];
        Ext.each(selectedRecord, function(currentRecord) {
            submitValue.push({
                "id": currentRecord.data.academiaLimeSurveyId,
                "code": currentRecord.data.surveyId
            });
        });
        
        // Check the isAnonymized value of the first selected record
        var firstRecord = selectedRecord[0];
        var submitUrl = SERVERURL.PATH_SEND_SURVEY;
        
        // Change the URL if the first record has isAnonymized === true
        if (firstRecord && firstRecord.get('isAnonymized') === true) {
            submitUrl = SERVERURL.PATH_SEND_SURVEY_COURSE_LEVEL_ANONYMIZED;
        }
        
        // Send the survey
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: submitValue,
            method: 'POST',
            success: function(form, action) {
                Ext.getBody().unmask();
                showSuccessMessage(getCommonTranslation('SEND_SURVEY'), getCommonTranslation('SUCCESS'));
                grid.getStore().reload();
            }
        });
    },

    // Function to handle scheduling the survey
    scheduleCourseSurvey: function(btn) {
        var me = this;
        var grid = me.getSendsurveygridtwo();
        var selectedRecord = grid.getSelectionModel().getSelection();
        
        // Create a date picker window
        var dateWindow = Ext.create('Ext.window.Window', {
            title: getCommonTranslation('SCHEDULE'),
            modal: true,
            layout: 'fit',
            items: [{
                xtype: 'form',
                items: [{
                    xtype: 'datefield',
                    fieldLabel: getCommonTranslation('DATE'),
                    name: 'scheduleDate',
                    allowBlank: false,
                    format: CONSTANTS.DATE_FORMAT,
                    minValue: new Date(),
                    listeners: {
                    	render: function(field) {
                    		return dateFormatRender(field);
                    	}
                    }
                }, {
                    xtype: 'timefield',
                    fieldLabel: getProgramandcourseTranslation('TIME'),
                    name: 'scheduleTime',
                    allowBlank: false,
                    format:'g:i A',
                    increment: 60,  // Set the increment to 60 minutes (1 hour)
        			listeners: {
        				render: function(field) {
        					return timeFormatRender(field);
        				}
        			}
                }, {
                    xtype: 'fieldcontainer',
                    width: '100%',
                    
                    items: [{
                        xtype: 'button',
                        text: getCommonTranslation('SCHEDULE'),
                        ui: 'CustomBtnSubmit',
                        scale: CONSTANTS.BUTTONSIZE,
                        formBind: true,
                        handler: function() {
                            var form = dateWindow.down('form').getForm();
                            if (form.isValid()) {
                                var values = form.getValues();
                                
                                // Convert scheduleDate and scheduleTime to Date objects
                                var scheduleDate = Ext.Date.parse(values.scheduleDate, 'Y-m-d'); // Convert to Date object
                                var scheduleTime = Ext.Date.parse(values.scheduleTime, 'g:i A'); // Convert to Date object
                                
                                if (scheduleDate && scheduleTime) {
                                    // Combine date and time into a single Date object
                                    scheduleDate.setHours(scheduleTime.getHours());
                                    scheduleDate.setMinutes(scheduleTime.getMinutes());
                                    scheduleDate.setSeconds(scheduleTime.getSeconds());
                                    
                                    var currentTime = new Date();
                                    if (scheduleDate < currentTime) {
                                        showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('SELECT_TIME_AFTER_CURRENT'));
                                        return;
                                    }
                                    
                                    // Format as "yyyy-MM-dd HH:mm:ss"
                                    var scheduleDateTime = Ext.Date.format(scheduleDate, 'Y-m-d H:i:s'); // Final formatted string
                                    
                                    // Submit the scheduling request
                                    me.submitScheduledCourseSurvey(grid, selectedRecord, scheduleDateTime);
                                    
                                    dateWindow.close();
                                }
                            }
                        }
                    },{
                        xtype: 'button',
                        text: getCommonTranslation('CANCEL'),
        				ui : 'CustomBtnCancel',
        				scale : CONSTANTS.BUTTONSIZE,
                        handler: function() {
                            dateWindow.close();
                        }
                    }]
                }]
            }]
        });

        dateWindow.show();
    },

    // Function to submit the survey with a scheduled time
    submitScheduledCourseSurvey: function(grid, selectedRecord, scheduleDateTime) {
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        
        // Create the submit value based on the new format
        var academiaSurveyIds = [];
        Ext.each(selectedRecord, function(currentRecord) {
            academiaSurveyIds.push(currentRecord.data.academiaLimeSurveyId); // Collect all survey IDs
        });
        
        // Construct the payload with the new data format
        var submitValue = {
            academiaSurveyIds: academiaSurveyIds, // Array of survey IDs
            isScheduled: true, // Mark the survey as scheduled
            scheduleDateTime: scheduleDateTime // Schedule DateTime (e.g., "2024-12-14 18:46:00")
        };

        // Send the scheduled survey
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.PATH_SCHEDULE_SURVEY_ON_SEND, // Updated URL for scheduling
            jsonData: submitValue,
            method: 'POST',
            success: function(form, action) {
                Ext.getBody().unmask();
                showSuccessMessage(getCommonTranslation('SCHEDULE'), getCommonTranslation('SUCCESS'));
                grid.getStore().reload();
            }
        });
    },
    
    // Function to handle sending survey now for PBS
    sendPBSSurveyNow: function(btn) {
    	var me = this;
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

    	var grid = this.getSendsurveypbsgridtwo();
    	var selectedRecord = grid.getSelectionModel().getSelection();

    	var submitValue = [];
    	Ext.each(selectedRecord, function(currentRecord){
    		submitValue.push({
    			"id": currentRecord.data.academiaLimeSurveyId,
    			"code": currentRecord.data.surveyId
    		});
    	});

    	// Check the isAnonymized value of the first selected record
    	var firstRecord = selectedRecord[0];
    	var	submitUrl=SERVERURL.PATH_SEND_SURVEY;

    	// Change the URL if the first record has isAnonymized === true
    	if (firstRecord && firstRecord.get('isAnonymized') === true) {
    		submitUrl = SERVERURL.PATH_SEND_SURVEY_COURSE_LEVEL_ANONYMIZED;
    	}

    	Ext.Ajax.request({
    		type : 'rest',
    		url : submitUrl,
    		jsonData : submitValue,
    		method : 'POST',
    		success : function(form, action) {
    			Ext.getBody().unmask();
    			showSuccessMessage(getExaminationTranslation('SEND_SURVEY'),getCommonTranslation('SUCCESS'));
    			grid.getStore().reload();
    		}
    	});
    },
    
    // Function to handle scheduling the pbs survey
    schedulePBSSurvey: function(btn) {
        var me = this;
        var grid = me.getSendsurveypbsgridtwo();
        var selectedRecord = grid.getSelectionModel().getSelection();
        
        // Create a date picker window
        var dateWindow = Ext.create('Ext.window.Window', {
            title: getCommonTranslation('SCHEDULE'),
            modal: true,
            layout: 'fit',
            items: [{
                xtype: 'form',
                items: [{
                    xtype: 'datefield',
                    fieldLabel: getCommonTranslation('DATE'),
                    name: 'scheduleDate',
                    allowBlank: false,
                    format: CONSTANTS.DATE_FORMAT,
                    minValue: new Date(),
                    listeners: {
                    	render: function(field) {
                    		return dateFormatRender(field);
                    	}
                    }
                }, {
                    xtype: 'timefield',
                    fieldLabel: getProgramandcourseTranslation('TIME'),
                    name: 'scheduleTime',
                    allowBlank: false,
                    format:'g:i A',
                    increment: 60,  // Set the increment to 60 minutes (1 hour)
        			listeners: {
        				render: function(field) {
        					return timeFormatRender(field);
        				}
        			}
                }, {
                    xtype: 'fieldcontainer',
                    width: '100%',
                    
                    items: [{
                        xtype: 'button',
                        text: getCommonTranslation('SCHEDULE'),
                        ui: 'CustomBtnSubmit',
                        scale: CONSTANTS.BUTTONSIZE,
                        formBind: true,
                        handler: function() {
                            var form = dateWindow.down('form').getForm();
                            if (form.isValid()) {
                                var values = form.getValues();
                                
                                // Convert scheduleDate and scheduleTime to Date objects
                                var scheduleDate = Ext.Date.parse(values.scheduleDate, 'Y-m-d'); // Convert to Date object
                                var scheduleTime = Ext.Date.parse(values.scheduleTime, 'g:i A'); // Convert to Date object
                                
                                if (scheduleDate && scheduleTime) {
                                    // Combine date and time into a single Date object
                                    scheduleDate.setHours(scheduleTime.getHours());
                                    scheduleDate.setMinutes(scheduleTime.getMinutes());
                                    scheduleDate.setSeconds(scheduleTime.getSeconds());
                                    
                                    var currentTime = new Date();
                                    if (scheduleDate < currentTime) {
                                        showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('SELECT_TIME_AFTER_CURRENT'));
                                        return;
                                    }
                                    
                                    // Format as "yyyy-MM-dd HH:mm:ss"
                                    var scheduleDateTime = Ext.Date.format(scheduleDate, 'Y-m-d H:i:s'); // Final formatted string
                                    
                                    // Submit the scheduling request
                                    me.submitScheduledPBSSurvey(grid, selectedRecord, scheduleDateTime);
                                    
                                    dateWindow.close();
                                }
                            }
                        }
                    },{
                        xtype: 'button',
                        text: getCommonTranslation('CANCEL'),
        				ui : 'CustomBtnCancel',
        				scale : CONSTANTS.BUTTONSIZE,
                        handler: function() {
                            dateWindow.close();
                        }
                    }]
                }]
            }]
        });

        dateWindow.show();
    },
    
    // Function to submit the pbs survey with a scheduled time
    submitScheduledPBSSurvey: function(grid, selectedRecord, scheduleDateTime) {
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        
        // Create the submit value based on the new format
        var academiaSurveyIds = [];
        Ext.each(selectedRecord, function(currentRecord) {
            academiaSurveyIds.push(currentRecord.data.academiaLimeSurveyId); // Collect all survey IDs
        });
        
        // Construct the payload with the new data format
        var submitValue = {
            academiaSurveyIds: academiaSurveyIds, // Array of survey IDs
            isScheduled: true, // Mark the survey as scheduled
            scheduleDateTime: scheduleDateTime // Schedule DateTime (e.g., "2024-12-14 18:46:00")
        };

        // Send the scheduled survey
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.PATH_SCHEDULE_SURVEY_ON_SEND, // Updated URL for scheduling
            jsonData: submitValue,
            method: 'POST',
            success: function(form, action) {
                Ext.getBody().unmask();
                showSuccessMessage(getCommonTranslation('SCHEDULE'), getCommonTranslation('SUCCESS'));
                grid.getStore().reload();
            }
        });
    },
    
    openSurveyRemainingWindow: function(grid, selectedRecord) {
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        var me = this;
        
        var academiaLimeSurveyId = selectedRecord.get('academiaLimeSurveyId');
        
        // Send the scheduled survey
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.PATH_GET_ALL_REMAINING_SURVEY_LIST, // Updated URL for scheduling
            params: {
                isSurveyRemaining: false,
                academiaLimeSurveyId: academiaLimeSurveyId
            },
            method: 'GET',
            success: function(response) {
                Ext.getBody().unmask();
                
                // Parse the response
                var responseData = Ext.decode(response.responseText);
                var rows = responseData.rows; // Data for the grid
                
                if (rows && rows.length > 0) {
                    // Create a grid to display the data
                    var gridPanel = Ext.create('Ext.grid.Panel', {
                        title: getCommonTranslation('SURVEY_REMAINING'),
                        border: true, 
                        store: {
                            fields: ['firstName', 'lastName', 'email', 'eamilSent'],
                            data: rows
                        },
                        columns: [
                            { text: getCommonTranslation('FIRST_NAME'), dataIndex: 'firstName', flex: 1 },
                            { text: getCommonTranslation('LAST_NAME'), dataIndex: 'lastName', flex: 1 },
                            { text: getCommonTranslation('EMAIL'), dataIndex: 'email', flex: 1 },
                            {
                                text: getCommonTranslation('EMAIL_SENT'),
                                dataIndex: 'eamilSent',
                                renderer: function(value) {
                                    return value ? getCommonTranslation('YES') : getCommonTranslation('NO');
                                },
                                flex: 1
                            }
                        ]
                    });

                    // Create a window to hold the grid
                    var window = Ext.create('Ext.window.Window', {
                        title: getCommonTranslation('SURVEY_REMAINING'),
                        layout: 'fit',
                        width: 620,
                        height: 450,
                        items: [gridPanel],
                        modal: true
                    });

                    window.show();
                } else {
                	showWarningMessage(getCommonTranslation('ALERT'), getAdmissionTranslation('EMPTY_GRID_MESSAGE'));
                }
            }
        });
    }
});