/*
 * @author Raghavendra.Soni   
 */
Ext.define('Academia.controller.survey.surveyReport.SurveyReportController', {
	extend: 'Academia.controller.base.BaseController',
    stores: [
    	'survey.ActiveSurveyListStore',
    	'survey.SurveyReportGridStore',
    	'survey.PBSSurveyReportGridStore'
    ],
    views: [
    	'survey.surveyReport.SurveyReportStructure',
    	'survey.surveyReport.SurveyReportFilter',
    	'survey.surveyReport.SurveyReportGrid',
    	'survey.surveyReport.CourseLevelSurveyReport',
    	'survey.surveyReport.PBSSurveyReport',
    	'survey.surveyReport.PBSSurveyReportFilter',
    	'survey.surveyReport.PBSSurveyReportGrid',
    	'survey.sendSurvey.AdHocSurveyReportFilter',
    	'survey.sendSurvey.AdHocSurveyReportGrid'
    ],
    refs: [{
        ref: 'contentPanel',
        selector: 'contentPanel'
    },{
        ref: 'surveyreportstructure',
        selector: 'surveyreportstructure'
    },{
        ref: 'surveyreportfilter',
        selector: 'surveyreportfilter'
    },{
    	ref: 'surveyreportgrid',
    	selector: 'surveyreportgrid'
    },{
    	ref: 'courselevelsurveyreport',
    	selector: 'courselevelsurveyreport'
    },{
    	ref: 'pbssurveyreport',
    	selector: 'pbssurveyreport'
    },{
    	ref: 'pbssurveyreportfilter',
    	selector: 'pbssurveyreportfilter'
    },{
    	ref: 'pbssurveyreportgrid',
    	selector: 'pbssurveyreportgrid'
    },{
    	ref: 'adhocsurveyreportfilter',
    	selector: 'adhocsurveyreportfilter'
    },{
    	ref: 'adhocsurveyreportgrid',
    	selector: 'adhocsurveyreportgrid'
    }],
    config: {
    	//CREATE_SURVEY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CREATE_SURVEY_PRIVILEGES')
    },
    init: function(application) {    
        this.control({
        	'surveyreportgrid':{
        		afterrender: function(grid){
        			//this.applyGridPivileges(grid, this.getCREATE_SURVEY_PERMISSIONS());
        		},
        		selectionchange:function(view,record){
        			var grid = this.getSurveyreportgrid()
        			var exportReport =grid.down('#exportReport');
        			if(record.length == 1){
        				exportReport.enable();
        			}else{
        				exportReport.disable();
        			}
        		},
        		cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
        			var grid = this.getSurveyreportgrid();
        			var columnName = grid.columnManager.columns[ColIdx].dataIndex;

        			if (columnName == 'noOfQuestions' && e.target.tagName == 'A') {
        			    Ext.Ajax.request({
        			        type: 'rest',
        			        url: SERVERURL.PATH_GET_SURVEY_REPORT_QUESTIONS + "?surveyId=" + record.data.id,
        			        method: 'GET',
        			        success: function (response) {
        			            var data = Ext.decode(response.responseText);

        			            // Process survey questions
        			            var questionItems = Ext.Array.map(data, function (question, index) {
        			                // Calculate total responses using a loop
        			                var totalResponses = 0;
        			                Ext.Array.each(question.options, function (option) {
        			                    totalResponses += option.responseCount;
        			                });

        			                // Construct options as a progress bar list
        			                var optionsHtml = Ext.Array.map(question.options, function (option, optionIndex) {
        			                    var percentage = totalResponses > 0 ? ((option.responseCount / totalResponses) * 100).toFixed(1) : 0;

        			                    return '' +
        			                        '<div style="margin-bottom: 10px;">' +
        			                        '    <div style="margin-bottom: 4px; font-weight: bold;">' +
        			                        '        ' + Ext.htmlEncode(option.option) + ' (' + getCommonTranslation('RESPONSE') + ': ' + option.responseCount + ')' +
        			                        '    </div>' +
        			                        '    <div style="height: 20px; background-color: #ddd; border-radius: 10px; overflow: hidden;">' +
        			                        '        <div style="' +
        			                        '            height: 100%;' +
        			                        '            width: ' + percentage + '%;' +
        			                        '            background-color: ' + getColorForOption(optionIndex) + ';' +
        			                        '            text-align: center;' +
        			                        '            color: #fff;' +
        			                        '            line-height: 20px;' +
        			                        '            font-size: 12px;">' +
        			                        '            ' + percentage + '%' +
        			                        '        </div>' +
        			                        '    </div>' +
        			                        '</div>';
        			                }).join('');

        			                // Return a panel for each question
        			                return {
        			                    xtype: 'panel',
        			                    border: false,
        			                    margin: '0 0 20 0',
        			                    html: '' +
        			                        '<div style="padding: 10px; border: 1px solid #ccc; border-radius: 5px;">' +
        			                        '    <h4>Question ' + (index + 1) + ': ' + Ext.htmlEncode(question.questionDescription) + '</h4>' +
        			                        '    ' + optionsHtml +
        			                        '</div>'
        			                };
        			            });

        			            // Function to get color for progress bars
        			            function getColorForOption(index) {
        			                var colors = ['#4caf50', '#2196f3', '#ff9800', '#f44336', '#9c27b0', '#00bcd4', '#8bc34a', '#ff5722', '#607d8b', '#795548'];
        			                return colors[index % colors.length];
        			            }

        			            // Create and show the window
        			            Ext.create('Ext.window.Window', {
        			                title: getCommonTranslation('SURVEY_QUESTIONS'),
        			                modal: true,
        			                width: 600,
        			                height: 500,
        			                autoScroll: true,
        			                layout: {
        			                    type: 'vbox',
        			                    align: 'stretch'
        			                },
        			                bodyPadding: 10,
        			                items: questionItems
        			            }).show();
        			        }
        			    });
        			}
        		}
        	},
        	'surveyreportgrid button[itemId=exportReport]':{
        	    click: function (btn) {
        	        var grid = btn.up('grid');
        	        var selectedRecord = grid.getSelectionModel().getSelection();

        	        if (selectedRecord.length === 0) {
        	        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        	            return;
        	        }

        	        Ext.Ajax.request({
        	            type: 'rest',
        	            url: SERVERURL.PATH_SURVEY_REPORT_EXPORT_PDF + "?surveyId=" + selectedRecord[0].data.id,
        	            method: 'GET',
        	            binary: true, // Let ExtJS know it's a binary response
        	            success: function (response) {
        	                // Use response.responseBytes or response.response to access binary content
        	                if (response.responseBytes || response.response) {
        	                	
        	                	// Extract the Content-Disposition header
        	                    var contentDisposition = response.getResponseHeader('Content-Disposition');
        	                    var filename = 'survey_report.pdf'; // Default filename

        	                    // Parse filename from Content-Disposition if available
        	                    if (contentDisposition && contentDisposition.indexOf('filename=') !== -1) {
        	                        filename = contentDisposition
        	                            .split('filename=')[1]
        	                            .replace(/["']/g, ''); // Remove quotes if any
        	                    }
        	                	
        	                    var blob = new Blob([response.responseBytes || response.response], { type: 'application/pdf' }); // Create Blob for PDF
        	                    var link = document.createElement('a'); // Create a link element
        	                    link.href = window.URL.createObjectURL(blob); // Create a download link for the Blob
        	                    link.download = filename // Set the file name
        	                    link.click(); // Trigger the download
        	                    window.URL.revokeObjectURL(link.href); // Clean up the object URL
        	                } else {
   							   showWarningMessage(getCommonTranslation('ALERT'),getTranslation('TEMPLATE_MAPPING_ERROR'));
        	                }
        	            }
        	        });
        	    }
        	},
        	'surveyreportfilter button[itemId=surveyReportSearchBtn]': {
                click: function(btn){
                	var filterForm = btn.up('surveyreportfilter');
        			var activeSurveyListCombo = filterForm.down('#activeSurveyListSurveyReportComboItemId');
        			
        			var surveyreportgrid = filterForm.up('surveyreportstructure').down('surveyreportgrid');
        			var surveyreportgridStore = surveyreportgrid.getStore();
        			
        			var activeSurveyId=activeSurveyListCombo.getValue();
        			
        			surveyreportgridStore.getProxy().extraParams = {
        				surveyId: activeSurveyId
        			}
        			
        			surveyreportgridStore.load();
                }
            },
            'surveyreportfilter button[itemId=surveyReportResetBtn]': {
                click: function(btn){
                	var filterForm = btn.up('surveyreportfilter');
        			filterForm.getForm().reset();
                }
            },
            
            
            'pbssurveyreportgrid':{
        		selectionchange:function(view,record){
        			var grid = this.getPbssurveyreportgrid()
        			var exportReport =grid.down('#exportReportPBS');
        			if(record.length == 1){
        				exportReport.enable();
        			}else{
        				exportReport.disable();
        			}
        		},
        		cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
        			var grid = this.getPbssurveyreportgrid();
        			var columnName = grid.columnManager.columns[ColIdx].dataIndex;

        			if (columnName == 'noOfQuestions' && e.target.tagName == 'A') {
        			    Ext.Ajax.request({
        			        type: 'rest',
        			        url: SERVERURL.PATH_GET_SURVEY_REPORT_QUESTIONS + "?surveyId=" + record.data.id,
        			        method: 'GET',
        			        success: function (response) {
        			            var data = Ext.decode(response.responseText);

        			            // Process survey questions
        			            var questionItems = Ext.Array.map(data, function (question, index) {
        			                // Calculate total responses using a loop
        			                var totalResponses = 0;
        			                Ext.Array.each(question.options, function (option) {
        			                    totalResponses += option.responseCount;
        			                });

        			                // Construct options as a progress bar list
        			                var optionsHtml = Ext.Array.map(question.options, function (option, optionIndex) {
        			                    var percentage = totalResponses > 0 ? ((option.responseCount / totalResponses) * 100).toFixed(1) : 0;

        			                    return '' +
        			                        '<div style="margin-bottom: 10px;">' +
        			                        '    <div style="margin-bottom: 4px; font-weight: bold;">' +
        			                        '        ' + Ext.htmlEncode(option.option) + ' (' + getCommonTranslation('RESPONSE') + ': ' + option.responseCount + ')' +
        			                        '    </div>' +
        			                        '    <div style="height: 20px; background-color: #ddd; border-radius: 10px; overflow: hidden;">' +
        			                        '        <div style="' +
        			                        '            height: 100%;' +
        			                        '            width: ' + percentage + '%;' +
        			                        '            background-color: ' + getColorForOption(optionIndex) + ';' +
        			                        '            text-align: center;' +
        			                        '            color: #fff;' +
        			                        '            line-height: 20px;' +
        			                        '            font-size: 12px;">' +
        			                        '            ' + percentage + '%' +
        			                        '        </div>' +
        			                        '    </div>' +
        			                        '</div>';
        			                }).join('');

        			                // Return a panel for each question
        			                return {
        			                    xtype: 'panel',
        			                    border: false,
        			                    margin: '0 0 20 0',
        			                    html: '' +
        			                        '<div style="padding: 10px; border: 1px solid #ccc; border-radius: 5px;">' +
        			                        '    <h4>Question ' + (index + 1) + ': ' + Ext.htmlEncode(question.questionDescription) + '</h4>' +
        			                        '    ' + optionsHtml +
        			                        '</div>'
        			                };
        			            });

        			            // Function to get color for progress bars
        			            function getColorForOption(index) {
        			                var colors = ['#4caf50', '#2196f3', '#ff9800', '#f44336', '#9c27b0', '#00bcd4', '#8bc34a', '#ff5722', '#607d8b', '#795548'];
        			                return colors[index % colors.length];
        			            }

        			            // Create and show the window
        			            Ext.create('Ext.window.Window', {
        			                title: getCommonTranslation('SURVEY_QUESTIONS'),
        			                modal: true,
        			                width: 600,
        			                height: 500,
        			                autoScroll: true,
        			                layout: {
        			                    type: 'vbox',
        			                    align: 'stretch'
        			                },
        			                bodyPadding: 10,
        			                items: questionItems
        			            }).show();
        			        }
        			    });
        			}
        		}
        	},
        	'pbssurveyreportgrid button[itemId=exportReportPBS]':{
        	    click: function (btn) {
        	        var grid = btn.up('grid');
        	        var selectedRecord = grid.getSelectionModel().getSelection();

        	        if (selectedRecord.length === 0) {
        	        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        	            return;
        	        }

        	        Ext.Ajax.request({
        	            type: 'rest',
        	            url: SERVERURL.PATH_SURVEY_REPORT_EXPORT_PDF + "?surveyId=" + selectedRecord[0].data.id,
        	            method: 'GET',
        	            binary: true, // Let ExtJS know it's a binary response
        	            success: function (response) {
        	                // Use response.responseBytes or response.response to access binary content
        	                if (response.responseBytes || response.response) {
        	                	
        	                	// Extract the Content-Disposition header
        	                    var contentDisposition = response.getResponseHeader('Content-Disposition');
        	                    var filename = 'survey_report.pdf'; // Default filename

        	                    // Parse filename from Content-Disposition if available
        	                    if (contentDisposition && contentDisposition.indexOf('filename=') !== -1) {
        	                        filename = contentDisposition
        	                            .split('filename=')[1]
        	                            .replace(/["']/g, ''); // Remove quotes if any
        	                    }
        	                	
        	                    var blob = new Blob([response.responseBytes || response.response], { type: 'application/pdf' }); // Create Blob for PDF
        	                    var link = document.createElement('a'); // Create a link element
        	                    link.href = window.URL.createObjectURL(blob); // Create a download link for the Blob
        	                    link.download = filename // Set the file name
        	                    link.click(); // Trigger the download
        	                    window.URL.revokeObjectURL(link.href); // Clean up the object URL
        	                } else {
   							   showWarningMessage(getCommonTranslation('ALERT'),getTranslation('TEMPLATE_MAPPING_ERROR'));
        	                }
        	            }
        	        });
        	    }
        	},
        	'pbssurveyreportfilter button[itemId=surveyReportPBSSearchBtn]': {
                click: function(btn){
                	var filterForm = btn.up('pbssurveyreportfilter');
        			var activeSurveyListCombo = filterForm.down('#activeSurveyListPBSSurveyReportComboItemId');
        			
        			var surveyreportgrid = filterForm.up('surveyreportstructure').down('pbssurveyreportgrid');
        			var surveyreportgridStore = surveyreportgrid.getStore();
        			
        			var activeSurveyId=activeSurveyListCombo.getValue();
        			
        			surveyreportgridStore.getProxy().extraParams = {
        				surveyId: activeSurveyId
        			}
        			
        			surveyreportgridStore.load();
                }
            },
            'pbssurveyreportfilter button[itemId=surveyReportPBSResetBtn]': {
                click: function(btn){
                	var filterForm = btn.up('pbssurveyreportfilter');
        			filterForm.getForm().reset();
                }
            },
            
            
            'adhocsurveyreportfilter button[itemId=searchAdHocSurveyReportBtn]':{
            	click: function(btn){
            		var me = this;
            		var form = btn.up('adhocsurveyreportfilter');
            		var surveyreportstructure = form.up('surveyreportstructure');
            		
            		var adhocsurveyreportgrid = surveyreportstructure.down('adhocsurveyreportgrid');
            		var adhocsurveyreportgridStore = adhocsurveyreportgrid.getStore();
            		
            		var surveyField = form.down('#activeSurveyListComboAdHocSurveyReportItemId');
            		
            		adhocsurveyreportgridStore.getProxy().extraParams = {
            			surveyId: surveyField.getValue()
            		};
            		
            		adhocsurveyreportgridStore.load();
            	}
            },

            'adhocsurveyreportfilter button[itemId=resetAdHocSurveyReportBtn]':{
            	click: function(btn){
            		var me = this;
            		var form = btn.up('adhocsurveyreportfilter');
            		
            		var surveyField = form.down('#activeSurveyListComboAdHocSurveyReportItemId');
            		
            		surveyField.reset();
            	}
            },
            
            'adhocsurveyreportgrid button[itemId=exportAdHocReport]':{
            	click: function(btn){
        	        var grid = btn.up('grid');
        	        var selectedRecord = grid.getSelectionModel().getSelection();

        	        if (selectedRecord.length === 0) {
        	        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        	            return;
        	        }

        	        Ext.Ajax.request({
        	            type: 'rest',
        	            url: SERVERURL.PATH_SURVEY_REPORT_EXPORT_PDF + "?surveyId=" + selectedRecord[0].data.sid,
        	            method: 'GET',
        	            binary: true, // Let ExtJS know it's a binary response
        	            success: function (response) {
        	                // Use response.responseBytes or response.response to access binary content
        	                if (response.responseBytes || response.response) {
        	                	
        	                	// Extract the Content-Disposition header
        	                    var contentDisposition = response.getResponseHeader('Content-Disposition');
        	                    var filename = 'survey_report.pdf'; // Default filename

        	                    // Parse filename from Content-Disposition if available
        	                    if (contentDisposition && contentDisposition.indexOf('filename=') !== -1) {
        	                        filename = contentDisposition
        	                            .split('filename=')[1]
        	                            .replace(/["']/g, ''); // Remove quotes if any
        	                    }
        	                	
        	                    var blob = new Blob([response.responseBytes || response.response], { type: 'application/pdf' }); // Create Blob for PDF
        	                    var link = document.createElement('a'); // Create a link element
        	                    link.href = window.URL.createObjectURL(blob); // Create a download link for the Blob
        	                    link.download = filename // Set the file name
        	                    link.click(); // Trigger the download
        	                    window.URL.revokeObjectURL(link.href); // Clean up the object URL
        	                } else {
   							   showWarningMessage(getCommonTranslation('ALERT'),getTranslation('TEMPLATE_MAPPING_ERROR'));
        	                }
        	            }
        	        });
        	    }
            },
            
            'adhocsurveyreportgrid':{
        		selectionchange:function(view,record){
        			var grid = this.getAdhocsurveyreportgrid()
        			var exportReport =grid.down('#exportAdHocReport');
        			if(record.length == 1){
        				exportReport.enable();
        			}else{
        				exportReport.disable();
        			}
        		},
        		
        		cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
        			var grid = this.getAdhocsurveyreportgrid();
        			var columnName = grid.columnManager.columns[ColIdx].dataIndex;

        			if (columnName == 'noOfQuestions' && e.target.tagName == 'A') {
        			    Ext.Ajax.request({
        			        type: 'rest',
        			        url: SERVERURL.PATH_GET_ADHOC_SURVEY_REPORT_QUESTIONS + "?surveyId=" + record.data.sid,
        			        method: 'GET',
        			        success: function (response) {
        			            var data = Ext.decode(response.responseText);

        			            // Process survey questions
        			            var questionItems = Ext.Array.map(data, function (question, index) {
        			                // Calculate total responses using a loop
        			                var totalResponses = 0;
        			                Ext.Array.each(question.options, function (option) {
        			                    totalResponses += option.responseCount;
        			                });

        			                // Construct options as a progress bar list
        			                var optionsHtml = Ext.Array.map(question.options, function (option, optionIndex) {
        			                    var percentage = totalResponses > 0 ? ((option.responseCount / totalResponses) * 100).toFixed(1) : 0;

        			                    return '' +
        			                        '<div style="margin-bottom: 10px;">' +
        			                        '    <div style="margin-bottom: 4px; font-weight: bold;">' +
        			                        '        ' + Ext.htmlEncode(option.option) + ' (' + getCommonTranslation('RESPONSE') + ': ' + option.responseCount + ')' +
        			                        '    </div>' +
        			                        '    <div style="height: 20px; background-color: #ddd; border-radius: 10px; overflow: hidden;">' +
        			                        '        <div style="' +
        			                        '            height: 100%;' +
        			                        '            width: ' + percentage + '%;' +
        			                        '            background-color: ' + getColorForOption(optionIndex) + ';' +
        			                        '            text-align: center;' +
        			                        '            color: #fff;' +
        			                        '            line-height: 20px;' +
        			                        '            font-size: 12px;">' +
        			                        '            ' + percentage + '%' +
        			                        '        </div>' +
        			                        '    </div>' +
        			                        '</div>';
        			                }).join('');

        			                // Return a panel for each question
        			                return {
        			                    xtype: 'panel',
        			                    border: false,
        			                    margin: '0 0 20 0',
        			                    html: '' +
        			                        '<div style="padding: 10px; border: 1px solid #ccc; border-radius: 5px;">' +
        			                        '    <h4>Question ' + (index + 1) + ': ' + Ext.htmlEncode(question.questionDescription) + '</h4>' +
        			                        '    ' + optionsHtml +
        			                        '</div>'
        			                };
        			            });

        			            // Function to get color for progress bars
        			            function getColorForOption(index) {
        			                var colors = ['#4caf50', '#2196f3', '#ff9800', '#f44336', '#9c27b0', '#00bcd4', '#8bc34a', '#ff5722', '#607d8b', '#795548'];
        			                return colors[index % colors.length];
        			            }

        			            // Create and show the window
        			            Ext.create('Ext.window.Window', {
        			                title: getCommonTranslation('SURVEY_QUESTIONS'),
        			                modal: true,
        			                width: 600,
        			                height: 500,
        			                autoScroll: true,
        			                layout: {
        			                    type: 'vbox',
        			                    align: 'stretch'
        			                },
        			                bodyPadding: 10,
        			                items: questionItems
        			            }).show();
        			        }
        			    });
        			}
        		}
            }
        });
    }
});