/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.controller.translation.TranslationController', {
    extend: 'Academia.controller.base.BaseController',
    views: [
    	'translation.TranslationStructure',
    	'translation.TranslationFilterForm',
    	'translation.FindAndReplaceTranslationWin'
    ],
    stores: [
    	'translation.TranslationStore',
    	'translation.TranslationObjectStore',
    	'translation.TranslationReplacePreviewStore'
    ],
    config: {
    	TRANSLATION_SETTINGS_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TRANSLATION_SETTINGS_PRIVILEGES'),
    },
    refs: [{
        ref: 'translationstructure',
        selector: 'translationstructure'
    },{
    	ref: 'findandreplacetranslationwin',
    	selector: 'findandreplacetranslationwin'
    }],
    init: function() {
        this.control({
            'translationstructure button[itemId=searchBtn]':{
            	click: function(obj, newValue, oldValue){
            		var grid = obj.up('translationstructure').down('grid');
            		var objCombo  = grid.up('translationstructure').down('#objectComboItemId');
            		var queryField = grid.up('translationstructure').down('#queryItemId');
            		
            		var languageCombo = grid.up('translationstructure').down('#languageComboItemId');
            		var languageDisplayValue = languageCombo.getDisplayValue();
            		var languageValue = languageCombo.getValue();
            		
            		Ext.each(grid.columns[3], function(currentColumn){
            			if(currentColumn.dataIndex=="customerDefineValue"){
            				currentColumn.setText(getCommonTranslation('CUSTOMER_DEFINE_VALUE')+" ("+languageDisplayValue+")");
            			}
            		});
            		
            		grid.down('#btnAdd').setDisabled(false);
            		grid.down('#replaceTranslation').setDisabled(false);
            		var gridStore = grid.getStore();
            		var objectNamesArray = [];
            		if(typeof objCombo.getValue()!="object"){
            			objectNamesArray.push(objCombo.getValue())
            		}
            		else{
            			try{
                    		Ext.each(objCombo.getValue(),function(currentObject){
                    			if(!isNullOrEmpty(currentObject.get('objectName'))){
                        			objectNamesArray.push(currentObject.get('objectName'));
                    			}
                    		});
            			}
            			catch(e){
            				objectNamesArray.push(objCombo.getValue()[0]);
            			}
            		}
            		if(languageDisplayValue=="English"){
            			languageDisplayValue="Default";
            		}
            		gridStore.getProxy().extraParams = {
                		limit: -1,
                		objectName: objectNamesArray.join(),
                		qry: queryField.getValue(),
                		code: languageDisplayValue.toUpperCase()
                	}
            		gridStore.clearFilter();
            		grid.getSelectionModel().deselectAll();
            		gridStore.removeAll();
                	gridStore.load();
            	}
            },
            'translationstructure button[itemId=resetBtn]':{
            	click: function(obj, newValue, oldValue){
            		//obj.up('form').getForm().reset();
            		var filterForm =obj.up('translationfilterform');
            		var translationstructure = filterForm.up('translationstructure');
            		filterForm.destroy();
            		translationstructure.insert(0,{xtype:'translationfilterform'});

            		var grid = translationstructure.down('grid');
            		var objCombo  = grid.up('translationstructure').down('#objectComboItemId');
            		var queryField = grid.up('translationstructure').down('#queryItemId');
            		grid.down('#btnAdd').setDisabled(true);
            		grid.down('#replaceTranslation').setDisabled(true);
            		var gridStore = grid.getStore();
            		var objectNamesArray = [];
            		if(typeof objCombo.getValue()!="object"){
            			objectNamesArray.push(objCombo.getValue())
            		}
            		else{
            			try{
                    		Ext.each(objCombo.getValue(),function(currentObject){
                    			if(!isNullOrEmpty(currentObject.get('objectName'))){
                        			objectNamesArray.push(currentObject.get('objectName'));
                    			}
                    		});
            			}
            			catch(e){
            				objectNamesArray.push(objCombo.getValue()[0]);
            			}
            		}
            		gridStore.getProxy().extraParams = {
                		limit: -1,
                		objectName: objectNamesArray.join(),
                		qry: queryField.getValue()
                	}
            		gridStore.clearFilter();
                	gridStore.removeAll();
            	}
            },
            'translationstructure button[itemId=btnAdd]': {
            	click: function(button) {
                	var me = this;
                	var grid = button.up('translationstructure').down('grid');
                	var gridStore = grid.getStore();
                	
                	var rowEditing = grid.getPlugin();
                	var objCombo  = button.up('translationstructure').down('#objectComboItemId');
                	
                	var objectName = '';
                	if(typeof objCombo.getValue()!="object"){
                		var objectName = objCombo.getValue()
            		}
            		else{
            			try{
                			var objectName = objCombo.getValue()[0].get('objectName');
            			}
            			catch(e){
            				var objectName =objCombo.getValue()[0];
            			}
            		}
                	
                	if(isNullOrEmpty(objectName)){
                		showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('exception_generic_error'));
                	}
                	else{
                    	var r = new gridStore.model({
                    		id:null,
                			objectName:objectName,
                			keyName:'',
                			defaultValue:'',
                			customerDefineValue:''
                        });
                    	gridStore.insert(0, r);
                        rowEditing.startEdit(0, 2);
                	}
            	}
            },
            'translationstructure button[itemId=saveTranslation]': {
                click: function(button) {
                	var me = this;
                	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'));
                	
                	var grid = button.up('translationstructure').down('grid');
                	var gridStore = grid.getStore();
                	
                	
                	var languageCombo = grid.up('translationstructure').down('#languageComboItemId');
            		var languageDisplayValue = languageCombo.getDisplayValue();
            		var languageValue = languageCombo.getValue();
            		if(languageValue=="AFRIKAANS"){
            			languageValue = "afrikaans"
            		}
            		
            		var languageStore = languageCombo.getStore();
            		languageStore.clearFilter();
            		
            		var allLanguageArray = [];
            		Ext.each(languageStore.data.items, function(currentLanguage){
            			allLanguageArray.push(currentLanguage.data.code);
            		});
            		var allLanguagesString = allLanguageArray.join();
            		languageStore.filter('visibility', true);
                	
                	var selectedRecords = grid.getSelectionModel().getSelection();
                	var formData = [];
                	var dataFlag = true;
                	Ext.each(selectedRecords, function(currentSelectedRecord){
                		if(isNullOrEmpty(currentSelectedRecord.get('objectName')) || isNullOrEmpty(currentSelectedRecord.get('keyName').trim()) || isNullOrEmpty(currentSelectedRecord.get('defaultValue'))){
                			dataFlag = false;
                		}
                		if(languageValue=="default"){
                    		var languageVariable = "customerDefineValue";
                		}
                		else{
                			var languageVariable = languageValue.substring(0,4)+"Language";
                			if(languageVariable = "georLanguage"){
                				languageVariable = "georgeLanguage";
                			}
                		}
                		var currentVal = {
                			id:currentSelectedRecord.get('id'),
                			objectName:currentSelectedRecord.get('objectName'),
                			keyName:currentSelectedRecord.get('keyName').trim(),
                			defaultValue:currentSelectedRecord.get('defaultValue')/*,//isNullOrEmpty(currentSelectedRecord.get('defaultValue'))?currentSelectedRecord.get('defaultValue'):(currentSelectedRecord.get('defaultValue').replaceAll("\"(.+)\"", "$1")),
                			languageVariable:currentSelectedRecord.get('customerDefineValue')*/
                		};
                		currentVal[languageVariable]=currentSelectedRecord.get('customerDefineValue');
                		formData.push(currentVal);
                	});
                	
                	if(dataFlag==false){
	                	Ext.getBody().unmask();
                		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_SAVE_EMPTY_DATA'));
	                	return false;
                	}
                	
                	Ext.Ajax.request({
						type: 'rest',
						url:SERVERURL.UI_TRANSLATION_UPDATE,
						jsonData: formData,
						method: 'POST',
						success: function(response) {
							if(response.responseText == "true"){
								var language = button.up('translationstructure').down('#languageComboItemId').getValue();
			                	
								Ext.each(selectedRecords, function(currentTranslationRecord){
									var keyValue = (!isNullOrEmpty(currentTranslationRecord.get('customerDefineValue')))?currentTranslationRecord.get('customerDefineValue'):currentTranslationRecord.get('defaultValue');
									window[currentTranslationRecord.get('objectName')][currentTranslationRecord.get('keyName')] = keyValue;
								});
								
								var mystring = '';
								Ext.each(Ext.getStore('translation.TranslationObjectStore').data.items, function(currentObject){
									var currentObjectName = currentObject.get('objectName');
									mystring = mystring + currentObjectName + " = "+ JSON.stringify(window[currentObjectName], null, "\t")+"; \n";
								});
			                	if(!isNullOrEmpty(Ext.String.trim(mystring))){
									var addTimeStamp = true; //for updating file name every time;
									
									if(addTimeStamp){
										var filePath = 'translations'+Ext.Date.format(new Date(),'_dmy_his')+'.js';
									}
									else{
										var filePath = 'translations.js';//'translations/'+language+'/translations.js'
									}
				                	
				                	var myblob = new Blob([mystring], {
				                	    type: 'text/plain'
				                	});
				                	var myFileObject = me.blobToFile(myblob,'translations.txt');
				                	
				                	var formData = new FormData();
				                	formData.append('file', myFileObject);
				                	formData.append('language', languageValue);
				                	formData.append('languages', allLanguagesString);
				                	var xhr = new XMLHttpRequest();
				                	xhr.open("POST", 'writeFile.php');
				                	xhr.onreadystatechange = function() { // Call a function when the state changes.
				                		setTimeout(function(){
				                	if (xhr.readyState == 4 && xhr.status == 200) {
				                	    	Ext.getBody().unmask();
						                	gridStore.load();
						                	var msg = '<span style="font-weight: 600;font-size: 16px;letter-spacing: 0.5px;color: black;">'+getMessagingModuleTranslation('SUCCESS')+'</span><br><span style="font-size: 12px;text-align: left;color: black;top: -3px;position: relative;">'+getCommonTranslation('SUCCESS_TRANSLATION_MSG')+'</span>';
					    					var box2 =Ext.Msg.show({
					    					//title: getCommonTranslation('TITLE_QUARTZ_DETAIL'),
											msg	: msg,
											buttons: Ext.Msg.YESNO,
			          				        buttonText: {
			          				            yes:getCommonTranslation('OK'),
			          				            no: getCommonTranslation('RELOAD')
			          				        },
			          						icon: Ext.Msg.INFO,
											cls: 'successMessageBox commonMsgBoxCls newClsMessageSuccessBox newClsMsg2',
											fn		: function(response){
			          							if(response=="no"){
			          								localStorage.setItem('defaultPage','STP_SETTINGS_AND_CONFIGURATION_TRANSLATION_SETTING-translationstructure');
			          								location.reload(true);
			          							}
			          						}
					    					});
					    					box2.removeCls('newClsMessageConfirmBox');
					    					box2.dockedItems.items[1].layout.pack = "end"; //items[0] is the header, [1] is the footer
					    					box2.doLayout();
					    					box2.dockedItems.items[1].items.items[1].setUI('CustomBtnSubmit');
					    					box2.dockedItems.items[1].items.items[2].setUI('CustomBtnCancel');
				                	    }
				            			},30000);
				                	}
				                	xhr.send(formData);
			                	}
			                	else{
			                		showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('exception_generic_error'));
				                	Ext.getBody().unmask();
			                	}
							}
							else{
								showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('exception_generic_error'));
			                	Ext.getBody().unmask();
							}
						}
                	});
                }
            },
            'translationstructure button[itemId=copyTranslation]':{
            	click: function(button) {
                	var me = this;
                	var grid = button.up('grid');
                	var gridStore = grid.getStore();
                	try{
                    	var isEditing = grid.plugins[0].editing;
                	}
                	catch(e){
                    	var isEditing = false;
                	}
                	var modifiedCount = gridStore.getModifiedRecords().length;
                	
                	if(isEditing==true || modifiedCount>0){
                		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SAVE_ALL_DATA_BEFORE_USING_THIS_FUNCTIONALITY'));
                	}
                	else{
                		var msg = '<span style="font-weight: 600;font-size: 16px;letter-spacing: 0.5px;color: black;">'+getCommonTranslation('COPY')+'</span><br><span style="font-size: 12px;text-align: left;color: black;top: -3px;position: relative;">'+getCommonTranslation('DO_YOU_WANT_TO_COPY')+'</span>';
    					var box2 =Ext.Msg.show({
    					//title: getCommonTranslation('TITLE_QUARTZ_DETAIL'),
						msg	: msg,
						buttons: Ext.Msg.YESNO,
            			buttonText: {
            				yes: getCommonTranslation('ALL_TRANSLATIONS'),
            				no: getCommonTranslation('BLANK_TRANSLATIONS')
            			},
            			width: 350,
            			icon: Ext.Msg.WARNING,
            			 cls: 'warningMessageBox commonMsgBoxCls newClsMessageConfirmBox newClsMsg',
            			fn		: function(response){
            				if(response=="yes"){
            					me.copyTranslations(true);
            				}
            				else if(response=="no"){
            					me.copyTranslations(false);
            				}
            			}
            		});
    					box2.removeCls('newClsMessageSuccessBox');
    					box2.doLayout();
    					box2.dockedItems.items[1].items.items[1].setUI('CustomBtnSubmit');
    					box2.dockedItems.items[1].items.items[2].setUI('CustomBtnCancel');
                	}
            	}
            },
            'translationstructure button[itemId=replaceTranslation]':{
            	click: function(button) {
            		var me = this;
            		var formWindow = me.getFindandreplacetranslationwin();
            		if (!formWindow) {
            			Ext.widget('findandreplacetranslationwin');
            			formWindow = me.getFindandreplacetranslationwin();
            		}
            		formWindow.show();
            	}
            },
            'translationstructure grid[itemId=translationGrid]':{
            	selectionchange: function(grid, selected) {
         			grid.view.up().down('#saveTranslation').setDisabled(!selected.length);
         			grid.view.up().down('#copyTranslation').setDisabled(!selected.length);
            	},
            	beforerender:function(cmp){
        			cmp.getStore().removeAll();
        		}
            },
            'translationstructure combobox[itemId=objectComboItemId]':{
            	afterrender: function(combo) {
            		combo.setValue('ADMISSION');
            		combo.getStore().load();
            	}
            },
            'findandreplacetranslationwin button[itemId=replaceAllWinBtnItemId]':{
            	click: function(button){
            		var me = this;
            		var grid = me.getTranslationstructure().down('grid');
            		var gridStore = grid.getStore();
            		var replaceWindow = button.up('findandreplacetranslationwin');
            		
            		replaceWindow.body.mask(getCommonTranslation('LOADING_MASK'));
            		
            		var checkedColumns = replaceWindow.down('#replaceColumnItemId').getValue();
            		var findFieldValue = me.escapeRegExp(replaceWindow.down('#findFieldWinItemId').getValue());
            		var replaceFieldValue = me.escapeRegExp(replaceWindow.down('#replaceWithWinItemId').getValue());
            		var isCaseSensitiveChecked = replaceWindow.down('#caseSensitiveItemId').getValue();
            		var wholeWordChecked = replaceWindow.down('#wholeWordItemId').getValue();
            		
        			var foundRecordsData = [];
        			var foundCustomerDefineValueRecords = [];
            		Ext.each(gridStore.data.items, function(currentStoreRecord){
            			/*if(Ext.isDefined(checkedColumns.defaultValue)){
            				if(isCaseSensitiveChecked && wholeWordChecked){
            					//--check for whole word + case sensitive
            					var regex1 = '\\b'+findFieldValue+'\\b';
            					var isFound = new RegExp(regex1, "g").test(currentStoreRecord.get('defaultValue'));
            					if(isFound){
            						foundRecordsData.push({
            							columnName: 'defaultValue',
        								recordId: currentStoreRecord.get('id'),
        								currentValue: currentStoreRecord.get('defaultValue'),
        								newValue: currentStoreRecord.get('defaultValue').replace(new RegExp(regex1, 'g'), replaceFieldValue)
        							});
            					}
            				}
            				else if(isCaseSensitiveChecked){
            					//--check for case sensitive
        						if(currentStoreRecord.get('defaultValue').indexOf(findFieldValue)>=0){
        							foundRecordsData.push({
            							columnName: 'defaultValue',
        								recordId: currentStoreRecord.get('id'),
        								currentValue: currentStoreRecord.get('defaultValue'),
        								newValue: currentStoreRecord.get('defaultValue').replace(new RegExp(findFieldValue, 'g'), replaceFieldValue)
        							});
        						}
            				}
            				else if(wholeWordChecked){
            					//--check for whole word
            					var regex1 = '\\b'+findFieldValue+'\\b';
            					var wholeWordFound = new RegExp(regex1, "i").test(currentStoreRecord.get('defaultValue'));
            					if(wholeWordFound){
            						foundRecordsData.push({
            							columnName: 'defaultValue',
        								recordId: currentStoreRecord.get('id'),
        								currentValue: currentStoreRecord.get('defaultValue'),
        								newValue: currentStoreRecord.get('defaultValue').replace(new RegExp(regex1, 'ig'), replaceFieldValue)
        							});
            					}
            				}
            				else{ //Any Match
            					if(new RegExp(findFieldValue, 'ig').test(currentStoreRecord.get('defaultValue'))){
            						foundRecordsData.push({
            							columnName: 'defaultValue',
        								recordId: currentStoreRecord.get('id'),
        								currentValue: currentStoreRecord.get('defaultValue'),
        								newValue: currentStoreRecord.get('defaultValue').replace(new RegExp(findFieldValue, 'ig'), replaceFieldValue)
        							});
            					}
            				}
            			}*/

            			//if(Ext.isDefined(checkedColumns.customerDefineValue)){
	            			if(!isNullOrEmpty(currentStoreRecord.get('customerDefineValue'))){
            				if(isCaseSensitiveChecked && wholeWordChecked){
            					//--check for whole word + case sensitive
            					var regex1 = '\\b'+findFieldValue+'\\b';
            					var isFound = new RegExp(regex1, "g").test(currentStoreRecord.get('customerDefineValue'));
            					if(isFound){
            						foundRecordsData.push({
            							columnName: 'customerDefineValue',
        								recordId: currentStoreRecord.get('id'),
        								currentValue: currentStoreRecord.get('customerDefineValue'),
        								newValue: currentStoreRecord.get('customerDefineValue').replace(new RegExp(regex1, 'g'), replaceFieldValue.replace(/\\\//g, "/"))
        							});
            					}
            				}
            				else if(isCaseSensitiveChecked){
            					//--check for case sensitive
        						if(currentStoreRecord.get('customerDefineValue').indexOf(findFieldValue)>=0){
        							foundRecordsData.push({
            							columnName: 'customerDefineValue',
        								recordId: currentStoreRecord.get('id'),
        								currentValue: currentStoreRecord.get('customerDefineValue'),
        								newValue: currentStoreRecord.get('customerDefineValue').replace(new RegExp(findFieldValue, 'g'), replaceFieldValue.replace(/\\\//g, "/"))
        							});
        						}
            				}
            				else if(wholeWordChecked){
            					//--check for whole word
            					var regex1 = '\\b'+findFieldValue+'\\b';
            					var wholeWordFound = new RegExp(regex1, "i").test(currentStoreRecord.get('customerDefineValue'));
            					if(wholeWordFound){
            						foundRecordsData.push({
            							columnName: 'customerDefineValue',
        								recordId: currentStoreRecord.get('id'),
        								currentValue: currentStoreRecord.get('customerDefineValue'),
        								newValue: currentStoreRecord.get('customerDefineValue').replace(new RegExp(regex1, 'ig'), replaceFieldValue.replace(/\\\//g, "/"))
        							});
            					}
            				}
            				else{ //Any Match
            					if(new RegExp(findFieldValue, 'ig').test(currentStoreRecord.get('customerDefineValue'))){
            						foundRecordsData.push({
            							columnName: 'customerDefineValue',
        								recordId: currentStoreRecord.get('id'),
        								currentValue: currentStoreRecord.get('customerDefineValue'),
        								newValue: currentStoreRecord.get('customerDefineValue').replace(new RegExp(findFieldValue, 'ig'), replaceFieldValue.replace(/\\\//g, "/"))
        							});
            					}
            				}
            			}
            			//}
            		});
            		
            		if(foundRecordsData.length){
            			var translationReplaceStore = Ext.getStore('translation.TranslationReplacePreviewStore');
            			translationReplaceStore.removeAll();
            			translationReplaceStore.loadData(foundRecordsData);
            			
                		replaceWindow.body.unmask();
                		replaceWindow.close();
                		
            			var replaceComfirmWindow = Ext.create('Ext.window.Window',{
            				modal: true,
            				autoScroll:true,
            				title: getCommonTranslation('CONFIRM_REPLACE'),
            				width: 500,
            				height:500,
            				layout: 'vbox',
            				resizable: false,
            				items: [{
            					xtype: 'grid',
            					store: translationReplaceStore,
            					frame: false,
            					border:true,
            					autoScroll: true,
            					width: '100%',
            					height: 350,
            					viewConfig : {
            						stripeRows : CONSTANTS.STRIPEROWS
            					},
            					columns:[
            						//{ header: getCommonTranslation('COLUMN_NAME'), dataIndex: 'columnName', flex:1},
            						{ header: getCommonTranslation('CURRENT_VALUE'), dataIndex: 'currentValue', flex:2},
            						{ header: getCommonTranslation('NEW_VALUE'), dataIndex: 'newValue', flex:2}
            					]
            				},{
            					xtype: 'fieldcontainer',
            					width: '100%',
            					items: [{
            						xtype: 'button',
            						text: getCommonTranslation('CONFIRM'),
            						buttonAlign: 'right',
            						ui: 'CustomBtnSubmit',
            						scale: CONSTANTS.BUTTONSIZE,
            						handler: function(btn){
            	    					me.confirmReplaceTranslations(btn,false);
            	    				}
            					},{
            						xtype: 'button',
            						text: getCommonTranslation('CONFIRM_SAVE'),
            						buttonAlign: 'right',
            						ui: 'CustomBtnSubmit',
            						scale: CONSTANTS.BUTTONSIZE,
            						handler: function(btn){
            	    					me.confirmReplaceTranslations(btn,true);
            	    				}
            					}, {
            						xtype: 'button',
            						text: getCommonTranslation('CANCEL'),
            						handler: function(btn){
            							btn.up('window').close();
            	    				},
            	    				ui: 'CustomBtnCancel',
            	    				scale: CONSTANTS.BUTTONSIZE
            					}]
            				}]
            			});
            			replaceComfirmWindow.show();
            		}
            		else{
            			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_RECORDS_FOUND'));
                		replaceWindow.body.unmask();
            		}
            		
            	}
            },
            'findandreplacetranslationwin button[itemId=closeWinBtnItemId]':{
            	click: function(button){
            		button.up('findandreplacetranslationwin').close();
            	}
            }
        });
    },
    blobToFile: function(theBlob, fileName){
        theBlob.lastModifiedDate = new Date();
        theBlob.name = fileName;
        return theBlob;
    },
    escapeRegExp: function(string){
    	return string.replace(/([.*+?^=!:${}()|\[\]\/\\])/g, "\\$1");
    },
    confirmReplaceTranslations: function(button,isSave){
    	var me = this;
    	button.up('window').body.mask(getCommonTranslation('LOADING_MASK'));
    	
    	var grid = me.getTranslationstructure().down('grid');
		var gridStore = grid.getStore();
		
		var translationReplaceStore = Ext.getStore('translation.TranslationReplacePreviewStore');
		
		Ext.each(translationReplaceStore.data.items, function(currentReplaceRecord){
			try{
				var gridRecord = gridStore.getAt(gridStore.findExact('id',currentReplaceRecord.get('recordId')));
				if(currentReplaceRecord.get('columnName')=='defaultValue'){
					gridRecord.set('defaultValue',currentReplaceRecord.get('newValue'));
				}
				if(currentReplaceRecord.get('columnName')=='customerDefineValue'){
					gridRecord.set('customerDefineValue',currentReplaceRecord.get('newValue'));
				}
			}
			catch(e){
				
			}
		}); 
		
		if(isSave){
			grid.getSelectionModel().deselectAll();
			grid.getSelectionModel().selectAll();
			setTimeout(function(){
				var saveTranslationBtn = grid.down('#saveTranslation');
				saveTranslationBtn.fireEvent('click',saveTranslationBtn);
				button.up('window').body.unmask();
		    	button.up('window').close();
			},500);
		}
		else{
			grid.getSelectionModel().deselectAll();
			showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getCommonTranslation('SUCCESS_TRANSLATION_MSG'));
			button.up('window').body.unmask();
	    	button.up('window').close();
		}
		
    },
    copyTranslations: function(copyAll){
    	var me = this;
    	
    	var grid = me.getTranslationstructure().down('grid');
		var gridStore = grid.getStore();
		
    	grid.body.mask(getCommonTranslation('LOADING_MASK'));
		
		var selectedRecords = grid.getSelectionModel().getSelection();
		
		Ext.each(selectedRecords, function(currentRecord){
			var storeCurrentRecord = gridStore.getAt(currentRecord.index);
			
			var defaultValue = storeCurrentRecord.get('defaultValue');
			var customerDefineValue = storeCurrentRecord.get('customerDefineValue');
			
			if(copyAll){
				storeCurrentRecord.set('customerDefineValue',defaultValue);
			}
			else if(isNullOrEmpty(customerDefineValue)){
				storeCurrentRecord.set('customerDefineValue',defaultValue);
			}
		});

		showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getCommonTranslation('SUCCESS_TRANSLATION_COPY_MSG'));
		grid.body.unmask();
    }
});