/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.controller.transport.vehicle.VehicleController', {
	extend: 'Academia.controller.personinfo.common.PersonInfoController',
	models: ['transport.vehicle.VehicleDetailData','transport.vehicle.VehicleDetailData',
	         'transport.vehicle.InsuranceHistorySubmitData','transport.vehicle.EmissionHistorySubmitData',
	         'transport.vehicle.RoadTaxHistorySubmitData','transport.vehicle.VehicleRecord',
	         'transport.vehicle.JourneyAssignmentSubmitData', 'transport.vehicle.FuelConsumptionGridDataModel',
	         'transport.vehicle.ServiceHistoryGridDataModel','transport.vehicle.VehiclePermitGridDataModel','transport.vehicle.FitnessCertificateGridDataModel'],
	stores: ['transport.vehicle.VehicleGridData','transport.vehicle.VehicleVendor','transport.vehicle.VehicleSubType',
	         'transport.vehicle.VehicleNo','transport.vehicle.VehicleModel','transport.vehicle.VehicleServicedBy',
	         'transport.vehicle.VehicleYesNoEnum','transport.vehicle.InsuranceHistoryGridData',
	         'transport.vehicle.EmissionHistoryGridData','transport.vehicle.RoadTaxHistoryGridData',
	         'transport.vehicle.InsuranceDocument','transport.vehicle.RoadTaxDocument','transport.route.RouteName',
	         'transport.vehicle.EmissionDocument','transport.vehicle.JourneyAssignment','transport.serviceRoute.ServiceRouteName',
	         'transport.serviceRoute.VehicleStatus','transport.serviceRoute.PeopleCoveredGrid',
	         'transport.vehicle.JourneyAssignmentUserCount','transport.vehicle.CompletionStatus',
	         'transport.vehicle.PresentAbsentEnum','transport.vehicle.TransServiceRouteUser',
	         'organization.BaseCurrencyStore','transport.vehicleType.VehicleTypeStore','transport.stopLocation.StopLocationStore',
	         'transport.vehicle.MonthlyAnnualStore','common.CountryStore', 'transport.vehicle.LicenceHistoryGridDataStore',
	         'transport.vehicle.LicenceRegistrationDocumentStore', 'transport.vehicle.VehicleRoadTaxRoadTaxAuthorStore',
	         'transport.vehicle.VehicleInsuranceInsuredByStore', 'transport.vehicle.FuelConsumptionGridDataStore','hostel.roomallocation.UserSmartSearchByUserType',
	         'transport.vehicle.ServiceHistoryGridDataStore','transport.vehicle.VehiclePermitGridDataStore','transport.vehicle.FitnessCertificateGridDataStore'],
	views: ['transport.vehicle.VehicleSearch','transport.vehicle.VehicleList',
	        'transport.vehicle.VehicleStructure','transport.vehicle.VehicleDetailForm',
	        'transport.vehicle.InsuranceHistoryStructure','transport.vehicle.InsuranceHistoryList',
	        'transport.vehicle.InsuranceHistoryDetailWin','transport.vehicle.EmissionHistoryList',
	        'transport.vehicle.EmissionHistoryStructure','transport.vehicle.EmissionHistoryDetailWin',
	        'transport.vehicle.RoadTaxHistoryStructure','transport.vehicle.RoadTaxHistoryList',
	        'transport.vehicle.RoadTaxHistoryDetailWin','organization.addresses.AddressFormWindow',
	        'transport.vehicle.VehicleInsuranceDocumentGrid','transport.vehicle.VehicleEmissionDocumentGrid',
	        'transport.vehicle.VehicleRoadTaxDocumentGrid','transport.vehicle.JourneyAssignmentDetailWin',
	        'transport.vehicle.JourneyAssignmentList','transport.vehicle.JourneyAssignmentStructure',
	        'transport.vehicle.NumberOfUserCoveredGridWindow','transport.vehicleType.VehicleTypeStructure',
	        'transport.vehicleType.VehicleTypeGrid','transport.vehicleType.VehicleTypeFormWindow',
	        'transport.stopLocation.StopLocationStructure','transport.stopLocation.StopLocationGrid',
	        'transport.stopLocation.StopLocationFormWindow', 'transport.vehicle.LicenceHistoryStructure',
	        'transport.vehicle.LicenceHistoryList', 'transport.vehicle.LicenceHistoryDetailWin',
	        'transport.vehicle.VehicleLicenceRegistrationDocumentGridWin','transport.vehicle.FuelConsumptionStructure',
	        'transport.vehicle.FuelConsumptionGrid','transport.vehicle.FuelConsumptionDetailWin',
	        'transport.vehicle.ServiceHistoryForVehicleStructure','transport.vehicle.ServiceHistoryGrid','transport.vehicle.ServiceHistoryDetailWin',
	        'transport.vehicle.VehiclePermitStructure','transport.vehicle.VehiclePermitGrid','transport.vehicle.VehiclePermitDetailWin','transport.vehicle.VehicleFitnessCertificateStructure',
	        'transport.vehicle.FitnessCertificateGrid','transport.vehicle.FitnessCertificateWin'],
	 config:{
		 		TRANSPORT_VEHICLE_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TRANSPORT_VEHICLE_PRIVILEGES'),
		 		JOURNEY_ASSIGNMENT_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('JOURNEY_ASSIGNMENT_PRIVILEGES'),
		 		TRANSPORT_VEHICLE_TYPE_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TRANSPORT_VEHICLE_TYPE_PRIVILEGES'),
		 		TRANSPORT_STOP_LOCATION_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TRANSPORT_STOP_LOCATION_PRIVILEGES'),
		 		TRANSPORT_VEHICLE_LICENCE_HISTORY_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TRANSPORT_VEHICLE_LICENCE_HISTORY_PRIVILEGES'),
		 		TRANSPORT_VEHICLE_INSURANCE_HISTORY_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TRANSPORT_VEHICLE_INSURANCE_HISTORY_PRIVILEGES'),
		 		TRANSPORT_VEHICLE_EMISSION_HISTORY_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TRANSPORT_VEHICLE_EMISSION_HISTORY_PRIVILEGES'),
		 		TRANSPORT_VEHICLE_ROAD_TAX_HISTORY_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TRANSPORT_VEHICLE_ROAD_TAX_HISTORY_PRIVILEGES'),
		 		TRANSPORT_VEHICLE_PERMIT_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TRANSPORT_VEHICLE_PERMIT_PRIVILEGES'),
		 		TRANSPORT_VEHICLE_FITNESS_CERTIFICATE_PRIVILEGES_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TRANSPORT_VEHICLE_FITNESS_CERTIFICATE_PRIVILEGES')

	 },         
    refs: [{
    	ref : 'contentPanel',
    	selector : 'contentpanel' 
    },{
    	ref: 'vehicleStructure',
    	selector: 'vehiclestructure'
    },{
    	ref: 'vehicleList',
    	selector: 'vehiclelist'
    },{
    	ref:'vehicleSearch',
    	selector:'vehiclesearch'
    },{
    	ref :'vehicleDetailForm',
    	selector :'vehicledetailform'
    },{
    	ref :'licencehistorystructure',
    	selector :'licencehistorystructure'
    },{
    	ref :'licencehistorydetailwin',
    	selector :'licencehistorydetailwin'
    },{
    	ref : 'licencehistorylist',
    	selector : 'licencehistorylist'
    },{
    	ref :'fuelconsumptionstructure',
    	selector :'fuelconsumptionstructure'
    },{
    	ref : 'fuelconsumptiongrid',
    	selector : 'fuelconsumptiongrid'
    },{
    	ref : 'insuranceHistoryList',
    	selector : 'insurancehistorylist'
    },{
    	ref :'insuranceHistoryStructure',
    	selector :'insurancehistorystructure'
    },{
    	ref :'insuranceHistoryDetailwin',
    	selector :'insurancehistorydetailwin'
    },{
    	ref :'insuranceHistoryDetailWin',
    	selector :'insurancehistorydetailwin form'
    },{
    	ref :'emissionHistoryStructure',
    	selector :'emissionhistorystructure'
    },{
    	ref :'emissionHistoryList',
    	selector :'emissionhistorylist'
    },{
    	ref :'emissionHistoryStructure',
    	selector :'emissionhistorystructure'
    },{
    	ref :'emissionHistoryDetailwin',
    	selector :'emissionhistorydetailwin'
    },{
    	ref :'emissionHistoryDetailWin',
    	selector :'emissionhistorydetailwin form'
    },{
    	ref :'roadTaxHistoryStructure',
    	selector :'roadtaxhistorystructure'
    },{
    	ref :'roadTaxHistoryDetailwin',
    	selector :'roadtaxhistorydetailwin'
    },{
    	ref :'roadTaxHistoryDetailWin',
    	selector :'roadtaxhistorydetailwin form'
    },{
    	ref :'roadTaxHistoryList',
    	selector :'roadtaxhistorylist'
    },{
        ref: 'vehicleAddressFormWindow',
        selector: 'addressformwindow[itemId=vehicleAddressFormWindow]'
    },{
    	  ref: 'vehicleAddressFormWindowForHistory',
          selector: 'addressformwindow[itemId=vehicleAddressFormWindowForHistory]'
      },{
        ref: 'personAddressFieldsForm',
        selector: 'addressfieldsform[itemId=personAddressFieldsForm]'
    },{
    	ref:'vehiclelicenceregistrationdocumentgridwin',
    	selector:'vehiclelicenceregistrationdocumentgridwin'
    },{
    	ref:'vehicleInsuranceDocumentGridWin',
    	selector:'vehicleinsurancedocumentgrid'
    },{
    	ref:'vehicleInsuranceDocumentGrid',
    	selector:'vehicleinsurancedocumentgrid grid'
    },{
    	ref:'vehicleEmissionDocumentGridWin',
    	selector:'vehicleemissiondocumentgrid'
    },{
    	ref:'vehicleEmissionDocumentGrid',
    	selector:'vehicleemissiondocumentgrid grid'
    },{
    	ref:'vehicleRoadTaxDocumentGridWin',
    	selector:'vehicleroadtaxdocumentgrid'
    },{
    	ref:'vehicleRoadTaxDocumentGrid',
    	selector:'vehicleroadtaxdocumentgrid grid'
    },{
    	ref : 'journeyAssignmentStructure',
    	selector : 'journeyassignmentstructure'
    },{
    	ref : 'journeyAssignmentDetailWin',
    	selector : 'journeyassignmentdetailwin'
    },{
    	ref : 'journeyAssignmentDetailForm',
    	selector : 'journeyassignmentdetailwin form'
    },{
    	ref : 'journeyAssignmentList',
    	selector : 'journeyassignmentlist'
    },{
    	ref : 'numberOfUserCoveredGridWindow',
    	selector : 'numberofusercoveredgridwindow'
    },{
    	ref : 'numberOfUserCoveredGrid',
    	selector : 'numberofusercoveredgridwindow grid'
    },{
    	ref : 'vehicleLocationStatusWin',
    	selector : 'vehiclelocationstatuswin'		
    },{
    	ref : 'vehicletypestructure',
    	selector : 'vehicletypestructure'
    },{
    	ref : 'vehicletypegrid',
    	selector : 'vehicletypegrid'
    },{
    	ref : 'vehicletypeformwindow',
    	selector : 'vehicletypeformwindow'
    },{
    	ref : 'stoplocationstructure',
    	selector : 'stoplocationstructure'
    },{
    	ref : 'stoplocationgrid',
    	selector : 'stoplocationgrid'
    },{
    	ref : 'stoplocationformwindow',
    	selector : 'stoplocationformwindow'
    },{
    	ref : 'fuelconsumptiondetailwin',
    	selector : 'fuelconsumptiondetailwin'
    },{
    	ref : 'servicehistoryforvehiclestructure',
    	selector : 'servicehistoryforvehiclestructure'
    },{
    	ref : 'servicehistorygrid',
    	selector : 'servicehistorygrid'
    },{
    	ref : 'servicehistorydetailwin',
    	selector : 'servicehistorydetailwin'
    },{
    	ref : 'vehiclepermitgrid',
    	selector : 'vehiclepermitgrid'
    },{
    	ref : 'vehiclepermitstructure',
    	selector : 'vehiclepermitstructure'
    },{
    	ref : 'vehiclepermitdetailwin',
    	selector : 'vehiclepermitdetailwin'
    },{
    	ref : 'vehiclefitnesscertificatestructure',
    	selector : 'vehiclefitnesscertificatestructure'
    },{
    	ref : 'fitnesscertificategrid',
    	selector : 'fitnesscertificategrid'
    },{
    	ref : 'fitnesscertificatewin',
    	selector : 'fitnesscertificatewin'
    }],
    init: function(application) {
    	this.control({
    		'vehiclelist button[itemId=btnAdd]':{
    			click : this.getOpenVehicleDetailForm
    		},
    		'vehiclelist button[itemId=btnEdit]':{
    			click : this.getEditVehicleDetails
    		},
    		'vehiclelist button[itemId=btnView]':{
    			click : this.getViewVehicleDetailForm
    		},
    		'vehiclelist button[itemId=btnDelete]':{
    			click : this.getDeleteVehicleDetail
    		},
    		'vehiclesearch button[itemId=SearchBtn]':{
    			click : this.getSearchVehicleDetails
    		},
    		'vehiclesearch fieldset[itemId=fldMoreFilter]':{
    			expand : this.expandSearchVehicleMoreFilter
    		},
    		
    		'vehiclesearch' :{
    			render : this.getRenderVehicleSearchForm
    		},
    		'vehicledetailform button[itemId=SubmitBtn]' :{
    			click : this.getSaveVehicleDetails
    		},
    		'licencehistorylist':{
    			render : function(grid){
    				this.getRenderLicenceRegistrationDetailHistory(grid);
    				this.doAccessControlValidation(grid, this.getTRANSPORT_VEHICLE_LICENCE_HISTORY_PERMISSION());
    				var itemIdPrivilegeNameArray = [{"#spBtnMoreActions" : "MOREACTIONS" , "#uploadLicenceAndRegistrationDocumentLink" : "UPLOAD_DOCUMENT"}];
  	        		this.disableRadioGroupAndOtherPivileges(grid, this.getTRANSPORT_VEHICLE_LICENCE_HISTORY_PERMISSION(), itemIdPrivilegeNameArray);
    			},
    			cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    				if (e.target.tagName == 'A') {    						
    					this.getViewLicenceRegistrationDocument(record);
    				}
    			} 
    		},
    		'licencehistorylist button[itemId=btnAdd]' :{
    			click : this.getShowLicenceHistoryWin
    		},
    		'licencehistorylist button[itemId=btnEdit]':{
    			click : this.getEditLicenceHistory
    		},
    		'licencehistorylist button[itemId=btnView]':{
    			click : this.getViewLicenceHistory
    		},
    		'licencehistorylist button[itemId=btnDelete]':{
    			click : this.getDeleteLicenceHistory
    		},
    		'licencehistorydetailwin button[itemId=SubmitBtn]' :{
    			click : this.getSaveLicenceRegistrationDetail
    		},
    		'licencehistorydetailwin button[itemId=CancelBtn]' :{
    			click : this.getCloseLicenceHistoryWin
    		},
    		'licencehistorylist menuitem[itemId=uploadLicenceAndRegistrationDocumentLink]':{
    			click:function(){
    				var grid = this.getLicencehistorylist();
    				if(grid.getSelectionModel().getCount()>0){
    					this.getDocumentController().showDocumentFormWindow('licenceRegistrationDocumentId', 'DOCUMENT');
    				}else{
    					showWarningMessage(getTransportTranslation('TRANS_LICENCE_AND_REGISTRATION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
    				}
    			}
    		},
    		'fuelconsumptiongrid':{
    			render : function(grid){
    				this.getRenderFuelConsumption(grid);
    			},
    			selectionchange: function(column, selected) {
    				var grid = this.getFuelconsumptiongrid();
            		if(selected.length== 1 && selected[0].data.isEditable == false){ 
            			grid.down('#btnEdit').setDisabled(true);
            			grid.down('#btnDelete').setDisabled(true);
            		} else {
            			grid.down('#btnEdit').setDisabled(false);
            			grid.down('#btnDelete').setDisabled(false);
            		}
            	}
    		},
    		'servicehistorygrid':{
    			render : function(grid){
    				this.getRenderServiceHistory(grid);
    			},
    			selectionchange: function(column, selected) {
    				var grid = this.getServicehistorygrid();
            		if(selected.length== 1 && selected[0].data.isEditable == false){ 
            			grid.down('#btnEdit').setDisabled(true);
            			
            		} else {
            			grid.down('#btnEdit').setDisabled(false);
            			
            		}
            	}
    		},
    		'servicehistorygrid button[itemId=btnAdd]' :{
    			click : this.getShowserviceHistoryWin
    		},
    		'fuelconsumptiongrid button[itemId=btnAdd]' :{
    			click : this.getShowFuelConsumptionWin
    		},
    		'fuelconsumptiongrid button[itemId=btnEdit]' :{
    			click : this.getEditFuelConsumption
    		},
    		'fuelconsumptiongrid button[itemId=btnView]' :{
    			click : this.getViewFuelConsumption
    		},
    		'fuelconsumptiongrid button[itemId=btnDelete]' :{
    			click : this.getDeleteFuelConsumption
    		},
    		'fuelconsumptiondetailwin button[itemId=SubmitBtnFuelConsumption]' :{
    			click : this.getSaveFuelConsumptionDetail
    		},
    		'fuelconsumptiondetailwin button[itemId=CancelBtnFuelConsumption]' :{
    			click : this.getCloseFuelConsumptionWin
    		},
    		'servicehistorydetailwin button[itemId=SubmitBtnServiceHistory]' :{
    			click : this.getSaveServiceHistoryDetail
    		},
    		'servicehistorydetailwin button[itemId=CancelBtnServiceHistory]' :{
    			click : this.getCloseServiceHistoryWin
    		},
    		'fuelconsumptiondetailwin numberfield[itemId=odometerReading]' :{
    			 blur:function(field){
    				 var me=this;
    			var structure = this.getFuelconsumptionstructure();
     			var vehicleId = structure.down('#vehicleId').getValue();
     			var odometerReadingValue;
     			var editUrl = SERVERURL.VEHICLE_FUEL_CONSUMPTION_FIND_BY__MAXVALUE_ODOMETERREADING;
        		Ext.Ajax.request({
        			method: "GET",
        			type: 'rest',
        			url: editUrl,
        			params: {
        				vehicleId: vehicleId
        			},
        			success: function(f, action) {
        				odometerReadingValue =f.responseText;
        				var odometerReading = field.getValue();
         				  if(odometerReading!=null){
         				 var win = me.getFuelconsumptiondetailwin();
      			         var odometerReadingwin = win.down('#odometerReading');
      			    
      			    if(odometerReadingValue>= odometerReading){
         		     		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ODOMETERREADING_VALIDATION'));
         	        		odometerReadingwin.reset();
         	        		
         		     		}
     
         	        	}
        			}
        			});
        			
   				  
   			  }
    		},
    		'fuelconsumptionstructure button[itemId=searchFuelConsumptionItemId]' :{
    			click : function(){
    				var structure = this.getFuelconsumptionstructure();
    				var vehicleId = structure.down('#vehicleId').getValue();
    				var dateFrom = structure.down('#dateFrom').getValue();
    				var dateTill = structure.down('#dateTill').getValue();
    				var grid = this.getFuelconsumptiongrid();
    				var store = grid.getStore();
    				store.getProxy().extraParams = {
                        vehicleId: vehicleId,
                        fromDate: dateFrom,
                        tillDate: dateTill
                    };
    				store.load();
    				grid.getSelectionModel().deselectAll(true);
    			}
    		},
    		'fuelconsumptionstructure button[itemId=resetFuelConsumptionItemId]' :{
    			click : function(btn){
    				var form = btn.up('form');
    				form.down('#dateTill').reset();
    				form.down('#dateFrom').reset();
    				form.down('#dateTill').setMinValue(null);
    				form.down('#dateFrom').setMaxValue(null);
    			}
    		},
    		'servicehistoryforvehiclestructure button[itemId=searchServiceHistoryItemId]' :{
    			click : function(){
    				var structure = this.getServicehistoryforvehiclestructure();
    				var vehicleId = structure.down('#vehicleId').getValue();
    				var dateFrom = structure.down('#dateFrom').getValue();
    				var dateTill = structure.down('#dateTill').getValue();
    				var grid = this.getServicehistorygrid();
    				var store = grid.getStore();
    				store.getProxy().extraParams = {
                        vehicleId: vehicleId,
                        fromDate: dateFrom,
                        tillDate: dateTill
                    };
    				store.load();
    				grid.getSelectionModel().deselectAll(true);
    			}
    		},
    		'servicehistoryforvehiclestructure button[itemId=resetServiceHistoryItemId]' :{
    			click : function(btn){
    				var form = btn.up('form');
    				form.down('#dateTill').reset();
    				form.down('#dateFrom').reset();
    				form.down('#dateTill').setMinValue(null);
    				form.down('#dateFrom').setMaxValue(null);
    			}
    		},
    		'servicehistorygrid button[itemId=btnEdit]' :{
    			click : this.getEditServiceHistory
    		},
    		'servicehistorygrid button[itemId=btnView]' :{
    			click : this.getViewServiceHistory
    		},
    		'documentformwindow[itemId=licenceRegistrationDocumentId] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]':{
    			click: function(){
    				var grid = this.getLicencehistorylist();
    				var module = 'licenceHistory';
    		   		var entityType = 'licenceHistory';
    		   		var createDocUrl = SERVERURL.PATH_VEHICLE_LICENSE_REGISTRATION_DOCUMENT_CREATE;
    		   		var historyTypeParams = 'LICENCEREGISTRATION';
    				this.getUploadDocument(grid,module,entityType,createDocUrl,historyTypeParams);
    			}
    		},
    		'documentformwindow[itemId=licenceRegistrationDocumentId] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentCancelButtonId]':{
    			click:function(){
    				this.getDocumentController().closeDocumentFormWindow();
    			}
    		},
    		'insurancehistorylist':{
    			render : function(grid){
    				this.getRenderInstrumentHistory(grid);
    				this.doAccessControlValidation(grid, this.getTRANSPORT_VEHICLE_INSURANCE_HISTORY_PERMISSION());
    				var itemIdPrivilegeNameArray = [{"#spBtnMoreActions" : "MOREACTIONS" }, {"#uploadInsurancePolicyDocumentLink" : "UPLOAD_DOCUMENT"} ,{ "#addAddressInsurancePolicy" : "ADD_ADDRESS"}];
  	        		this.disableRadioGroupAndOtherPivileges(grid, this.getTRANSPORT_VEHICLE_INSURANCE_HISTORY_PERMISSION(), itemIdPrivilegeNameArray);
    			},
    			cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    				if (e.target.tagName == 'A') {
    						//this.getCommonAddressDetailsForHistory(record);
    					this.getViewInsuranceDocument(record);
    				}
    			}  
    		},
    		'vehiclelist menuitem[itemId=licenceHistoryLink]':{
    			click : this.getopenLicenceHistory
    		},
    		'vehiclelist menuitem[itemId=insuranceHistoryLink]':{
    			click : this.getopenInsuranceHistory
    		},
    		'vehiclelist menuitem[itemId=emissionHistoryLink]':{
    			click : this.getopenEmissionHistory
    		},
    		'vehiclelist menuitem[itemId=fuelConsumptionLink]':{
    			click : this.getopenFuelConsumption
    		},
    		'vehiclelist menuitem[itemId=serviceHistoryLink]':{
    			click : this.getOpenServiceHistory
    		},
    		'vehiclelist menuitem[itemId=roadTaxHistoryLink]':{
    			click : this.getopenRoadTaxHistory
    		},
    		'vehiclelist menuitem[itemId=journeyAssignmentLink]':{
    			click : this.getopenJourneyAssignment
    		},
    		'vehiclelist menuitem[itemId=viewVehicleLocationStatusLink]':{
    			click : this.getopenVehicleLocation
    		},
    		'vehiclelist menuitem[itemId=vehiclePermit]':{
    			click : this.getOpenVehiclePermit
    		},
    		'vehiclelist menuitem[itemId=fitnessCertificateLink]':{
    			click : this.getOpenFitnessCertificate
    		},
    		'vehiclelist': {
   			 render: function(grid){
   				 this.doAccessControlValidation(grid, this.getTRANSPORT_VEHICLE_PERMISSION());
   				 this.disableMoreActionPivileges(grid,this.getTRANSPORT_VEHICLE_PERMISSION());
   			 },
   			afterrender:function(grid){
				var me = this;
				setTimeout(function(){
					me.addDataGridConfigButton(grid,me.getTRANSPORT_VEHICLE_PERMISSION());
				},1500);
			 }
    		},
    		'insurancehistorylist button[itemId=btnAdd]' :{
    			click : this.getShowInsuranceHistoryWin
    		},
    		'insurancehistorylist button[itemId=btnEdit]':{
    			click : this.getEditInsuranceHistory
    		},
    		'insurancehistorylist button[itemId=btnView]' :{
    			click : this.getViewInsuranceHistory
    		},
    		'insurancehistorylist button[itemId=btnDelete]' :{
    			click : this.getDeleteInsuranceHistory
    		},
    		'insurancehistorydetailwin button[itemId=SubmitBtn]' :{
    			click : this.getSaveInsuranceHistory
    		},
    		'insurancehistorydetailwin button[itemId=CancelBtn]' :{
    			click : this.getCloseInsuranceHistoryWin
    		},
    		'emissionhistorylist':{
    			render : function(grid){
    				this.getRenderEmissionHistory(grid);
    				this.doAccessControlValidation(grid, this.getTRANSPORT_VEHICLE_EMISSION_HISTORY_PERMISSION());
    				var itemIdPrivilegeNameArray = [{"#spBtnMoreActions" : "MOREACTIONS" }, {"#uploadEmissionPolicyDocumentLink" : "UPLOAD_DOCUMENT"} ,{ "#addAddressEmissionPolicy" : "ADD_ADDRESS"}];
  	        		this.disableRadioGroupAndOtherPivileges(grid, this.getTRANSPORT_VEHICLE_EMISSION_HISTORY_PERMISSION(), itemIdPrivilegeNameArray);
    			},
    			cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    				if (e.target.tagName == 'A') {
    					//this.getCommonAddressDetailsForHistory(record);
    					this.getViewEmissionDocument(record);
    				}
    			} 
    		},
    		'emissionhistorylist button[itemId=btnAdd]':{
    			click :this.getShowEmissionHistoryWin
    		},
    		'emissionhistorylist button[itemId=btnView]':{
    			click :this.getViewEmissionHistory
    		},
    		'emissionhistorylist button[itemId=btnEdit]':{
    			click : this.getEditEmissionHistory
    		},
    		'emissionhistorylist button[itemId=btnDelete]' :{
    			click : this.getDeleteEmissionHistory
    		},
    		'emissionhistorydetailwin button[itemId=SubmitBtn]' :{
    			click : this.getSaveEmissionHistory
    		},
    		'emissionhistorydetailwin button[itemId=CancelBtn]' :{
    			click : this.getCloseEmissionHistoryWin
    		},
    		'roadtaxhistorylist':{
    			render : function(grid){
    				this.getRoadTaxEmissionHistory(grid);
    				this.doAccessControlValidation(grid, this.getTRANSPORT_VEHICLE_ROAD_TAX_HISTORY_PERMISSION());
    				var itemIdPrivilegeNameArray = [{"#spBtnMoreActions" : "MOREACTIONS" }, {"#uploadRoadTaxPolicyDocumentLink" : "UPLOAD_DOCUMENT"} ,{ "#addAddressRoadTaxPolicy" : "ADD_ADDRESS"}];
  	        		this.disableRadioGroupAndOtherPivileges(grid, this.getTRANSPORT_VEHICLE_ROAD_TAX_HISTORY_PERMISSION(), itemIdPrivilegeNameArray);
    			},
    			cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    				if (e.target.tagName == 'A') {
    					this.getViewRoadTaxDocument(record);
    					//this.getCommonAddressDetailsForHistory(record);
    				}
    			} 
    		},
    		'roadtaxhistorylist button[itemId=btnAdd]':{
    			click :this.getShowRoadTaxHistoryWin
    		},
    		'roadtaxhistorylist button[itemId=btnEdit]':{
    			click :this.getEditRoadTaxHistory
    		},
    		'roadtaxhistorylist button[itemId=btnView]':{
    			click :this.getViewRoadTaxHistory
    		},
    		'roadtaxhistorylist button[itemId=btnDelete]' :{
    			click : this.getDeleteRoadTaxHistory
    		},
    		'roadtaxhistorydetailwin button[itemId=SubmitBtn]':{
    			click :this.getSaveRoadTaxHistory
    		},
    		'roadtaxhistorydetailwin button[itemId=CancelBtn]':{
    			click :this.getCloseRoadTaxHistoryWin
    		},
    		'vehicledetailform button[itemId=purchasedFromAddress]':{
    			click : function(obj){
    				var buttonId = obj.itemId;
    				var form = obj.up('form');
    				var addressId = form.down("#purchaseFromAddressId").getValue();
    				this.getCommonAddressDetails(buttonId,addressId);
    			}
    		},
    		'vehicledetailform button[itemId=serviceByAddress]':{
    			click : function(obj){
    				var buttonId = obj.itemId;
    				var form = obj.up('form');
    				var addressId = form.down("#serviceFromAddressId").getValue();
    				this.getCommonAddressDetails(buttonId,addressId);
    			}
    		},
    		'vehicledetailform button[itemId=insuranceAddress]':{
    			click : function(obj){
    				var buttonId = obj.itemId;
    				var form = obj.up('form');
    				var addressId = form.down("#insuranceAddressId").getValue();
    				this.getCommonAddressDetails(buttonId,addressId);
    			}
    		},
    		'vehicledetailform button[itemId=emissionAddress]':{
    			click : function(obj){
    				var buttonId = obj.itemId;
    				var form = obj.up('form');
    				var addressId = form.down("#emissionAddressId").getValue();
    				this.getCommonAddressDetails(buttonId,addressId);
    			}
    		},
    		'vehicledetailform button[itemId=roadTaxAddress]':{
    			click : function(obj){
    				var buttonId = obj.itemId;
    				var form = obj.up('form');
    				var addressId = form.down("#roadTaxAddressId").getValue();
    				this.getCommonAddressDetails(buttonId,addressId);
    			}
    		},
    		'addressformwindow[itemId=vehicleAddressFormWindow] button[itemId=submitButtonId]':{
    			click : this.getSaveAddressDetail
    		},
    		'addressformwindow[itemId=vehicleAddressFormWindow] button[itemId=cancelButtonId]':{
    			click : this.getCloseAddressDetail
    		},
    		'addressformwindow[itemId=vehicleAddressFormWindowForHistory] button[itemId=submitButtonId]':{
    			click : this.getSaveAddressDetailForHistory
    		},
    		'addressformwindow[itemId=vehicleAddressFormWindowForHistory] button[itemId=cancelButtonId]':{
    			click : this.getCloseAddressDetailForHistory
    		},
    		'insurancehistorylist menuitem[itemId=uploadInsurancePolicyDocumentLink]':{
    			click:function(){
    				var grid = this.getInsuranceHistoryList();
    				if(grid.getSelectionModel().getCount()>0){
    					this.getDocumentController().showDocumentFormWindow('insuranceDocumentId', 'DOCUMENT');
    				}else{
    					showWarningMessage(getTransportTranslation('INSURANCE_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
    				}
    			}
    		},
    		/*'insurancehistorylist menuitem[itemId=viewInsurancePolicyDocumentLink]':{
    			click:function(){
    				var grid = this.getInsuranceHistoryList();
    				if(grid.getSelectionModel().getCount()>0){
    					var records=grid.getSelectionModel().getSelection()[0];
    					this.getViewInsuranceDocument(records);
    				}else{
    					showWarningMessage(getTransportTranslation('INSURANCE_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
    				}
    			}
    		},*/
    		'insurancehistorylist menuitem[itemId=addAddressInsurancePolicy]':{
    			click:function(){
    				var grid = this.getInsuranceHistoryList();
    				if(grid.getSelectionModel().getCount()>0){
    					var records=grid.getSelectionModel().getSelection()[0];
    					this.getCommonAddressDetailsForHistory(records);
    				}else{
    					showWarningMessage(getTransportTranslation('INSURANCE_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
    				}
    			}
    		},
    		'documentformwindow[itemId=insuranceDocumentId] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]':{
    			click: function(){
    				var grid = this.getInsuranceHistoryList();
    				var module = 'insuranceHistory';
    		   		var entityType = 'insuranceHistory';
    		   		var createDocUrl = SERVERURL.VEHICLE_INSURANCE_DOCUMENT_CREATE;
    		   		var historyTypeParams = 'INSURANCE';
    				this.getUploadDocument(grid,module,entityType,createDocUrl,historyTypeParams);
    			}
    		},
    		'documentformwindow[itemId=insuranceDocumentId] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentCancelButtonId]':{
    			click:function(){
    				this.getDocumentController().closeDocumentFormWindow();
    			}
    		},
    		'vehiclelicenceregistrationdocumentgridwin grid[itemId=vehiclelicenceregistrationdocumentgridwinId]':{
    			render : function(grid){
    				var itemIdPrivilegeNameArray = [{"#btnDelete" : "DELETE_DOCUMENT"}];
  	        		this.disableRadioGroupAndOtherPivileges(grid, this.getTRANSPORT_VEHICLE_LICENCE_HISTORY_PERMISSION(), itemIdPrivilegeNameArray);
    			},    			
    			cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    				if (e.target.tagName == 'A') {
    					var documentId = record.raw.encryptedDocId;
    					if (!isNullOrEmpty(documentId)) {
    						this.getDownloadFile(documentId);
    					}
    				}
    			}  
    		},
    		'vehiclelicenceregistrationdocumentgridwin grid[itemId=vehiclelicenceregistrationdocumentgridwinId] button[itemId=btnDelete]' : {
    			click : function() {
    				var gridWin = this.getVehiclelicenceregistrationdocumentgridwin();
    				var grid = gridWin.down('grid');
    				var url = SERVERURL.PATH_VEHICLE_LICENSE_REGISTRATION_DOCUMENT_DELETE;
    				var parentGrid= this.getLicencehistorylist();
    				this.getDeleteDocuments(grid,url, parentGrid);	
    			}
    		},
    		
    		'vehicleinsurancedocumentgrid grid[itemId=vehicleinsurancedocumentgridId]':{
    			render : function(grid){
    				var itemIdPrivilegeNameArray = [{"#btnDelete" : "DELETE_DOCUMENT"}];
    				this.disableRadioGroupAndOtherPivileges(grid, this.getTRANSPORT_VEHICLE_INSURANCE_HISTORY_PERMISSION(), itemIdPrivilegeNameArray);
    			},
    			cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    				if (e.target.tagName == 'A') {
    					var documentId = record.raw.encryptedDocId;
    					if (!isNullOrEmpty(documentId)) {
    						this.getDownloadFile(documentId);
    					}
    				}
    			}  
    		},
    		'vehicleinsurancedocumentgrid grid[itemId=vehicleinsurancedocumentgridId] button[itemId=btnDelete]' : {
    			click : function() {
    				var grid = this.getVehicleInsuranceDocumentGrid();
    				var url = SERVERURL.VEHICLE_INSURANCE_DOCUMENT_DELETE;
    				var parentGrid= this.getInsuranceHistoryList();
    				this.getDeleteDocuments(grid,url, parentGrid);	
    			}
    		},
    		
    		'emissionhistorylist menuitem[itemId=addAddressEmissionPolicy]':{
    			click:function(){
    				var grid = this.getEmissionHistoryList();
    				if(grid.getSelectionModel().getCount()>0){
    					var records=grid.getSelectionModel().getSelection()[0];
    					this.getCommonAddressDetailsForHistory(records);
    				}else{
    					showWarningMessage(getTransportTranslation('EMISSION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
    				}
    			}
    		},
    		
    		'emissionhistorylist menuitem[itemId=uploadEmissionPolicyDocumentLink]':{
    			click:function(){
    				var grid = this.getEmissionHistoryList();
    				if(grid.getSelectionModel().getCount()>0){
    					this.getDocumentController().showDocumentFormWindow('emissionDocumentId', 'DOCUMENT');
    				}else{
    					showWarningMessage(getTransportTranslation('EMISSION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
    				}
    			}
    		},
    		/*'emissionhistorylist menuitem[itemId=viewEmissionPolicyDocumentLink]':{
    			click:function(){
    				var grid = this.getEmissionHistoryList();
    				if(grid.getSelectionModel().getCount()>0){
    					var records=grid.getSelectionModel().getSelection()[0];
    					this.getViewEmissionDocument(records);
    				}
    			}
    		},*/
    		'documentformwindow[itemId=emissionDocumentId] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]':{
    			click: function(){
    				var grid = this.getEmissionHistoryList();
    				var module = 'emissionHistory';
    		   		var entityType = 'emissionHistory';
    		   		var createDocUrl = SERVERURL.VEHICLE_EMISSION_DOCUMENT_CREATE;
    		   		var historyTypeParams = 'EMISSION';
    				this.getUploadDocument(grid,module,entityType,createDocUrl,historyTypeParams);
    			}
    		},
    		'documentformwindow[itemId=emissionDocumentId] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentCancelButtonId]':{
    			click:function(){
    				this.getDocumentController().closeDocumentFormWindow();
    			}
    		},
    		'vehicleemissiondocumentgrid grid[itemId=vehicleemissiondocumentgridId]':{
    			render : function(grid){
    				var itemIdPrivilegeNameArray = [{"#btnDelete" : "DELETE_DOCUMENT"}];
  	        		this.disableRadioGroupAndOtherPivileges(grid, this.getTRANSPORT_VEHICLE_EMISSION_HISTORY_PERMISSION(), itemIdPrivilegeNameArray);
    			},
    			cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    				if (e.target.tagName == 'A') {
    					var documentId = record.raw.encryptedDocId;
    					if (!isNullOrEmpty(documentId)) {
    						this.getDownloadFile(documentId);
    					}
    				}
    			}  
    		},
    		'vehicleemissiondocumentgrid grid[itemId=vehicleemissiondocumentgridId] button[itemId=btnDelete]' : {
    			click : function() {
    				var grid = this.getVehicleEmissionDocumentGrid();
    				var url = SERVERURL.VEHICLE_EMISSION_DOCUMENT_DELETE;
    				var parentGrid= this.getEmissionHistoryList();
    				this.getDeleteDocuments(grid,url, parentGrid);
    			}
    		},
    		'roadtaxhistorylist menuitem[itemId=addAddressRoadTaxPolicy]':{
    			click:function(){
    				var grid = this.getRoadTaxHistoryList();
    				if(grid.getSelectionModel().getCount()>0){
    					var record=grid.getSelectionModel().getSelection()[0];
    					this.getCommonAddressDetailsForHistory(record);
    					//this.getDocumentController().showDocumentFormWindow('roadTaxDocumentId', 'DOCUMENT');
    				}else{
    					showWarningMessage(getTransportTranslation('ROAD_TAX_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
    				}
    			}
    		},
    		'roadtaxhistorylist menuitem[itemId=uploadRoadTaxPolicyDocumentLink]':{
    			click:function(){
    				var grid = this.getRoadTaxHistoryList();
    				if(grid.getSelectionModel().getCount()>0){
    					this.getDocumentController().showDocumentFormWindow('roadTaxDocumentId', 'DOCUMENT');
    				}else{
    					showWarningMessage(getTransportTranslation('ROAD_TAX_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
    				}
    			}
    		},
    		/*'roadtaxhistorylist menuitem[itemId=viewRoadTaxPolicyDocumentLink]':{
    			click:function(){
    				var grid = this.getRoadTaxHistoryList();
    				if(grid.getSelectionModel().getCount()>0){
    					var records=grid.getSelectionModel().getSelection()[0];
    					this.getViewRoadTaxDocument(records);
    				}
    			}
    		},*/
    		'documentformwindow[itemId=roadTaxDocumentId] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]':{
    			click: function(){
    				var grid = this.getRoadTaxHistoryList();
    				var module = 'roadTaxHistory';
    		   		var entityType = 'roadTaxHistory';
    		   		var createDocUrl = SERVERURL.VEHICLE_ROAD_TAX_DOCUMENT_CREATE;
    		   		var historyTypeParams = 'ROADTAX';
    				this.getUploadDocument(grid,module,entityType,createDocUrl,historyTypeParams);
    			}
    		},
    		'documentformwindow[itemId=roadTaxDocumentId] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentCancelButtonId]':{
    			click:function(){
    				this.getDocumentController().closeDocumentFormWindow();
    			}
    		},
    		'vehicleroadtaxdocumentgrid grid[itemId=vehicleroadtaxdocumentgridId]':{
    			render : function(grid){
    				var itemIdPrivilegeNameArray = [{"#btnDelete" : "DELETE_DOCUMENT"}];
  	        		this.disableRadioGroupAndOtherPivileges(grid, this.getTRANSPORT_VEHICLE_ROAD_TAX_HISTORY_PERMISSION(), itemIdPrivilegeNameArray);
    			},
    			cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    				if (e.target.tagName == 'A') {
    					var documentId = record.raw.encryptedDocId;
    					if (!isNullOrEmpty(documentId)) {
    						this.getDownloadFile(documentId);
    					}
    				}
    			}  
    		},
    		'vehicleroadtaxdocumentgrid grid[itemId=vehicleroadtaxdocumentgridId] button[itemId=btnDelete]' : {
    			click : function() {
    				var grid = this.getVehicleRoadTaxDocumentGrid();
    				var url = SERVERURL.VEHICLE_ROAD_TAX_DOCUMENT_DELETE;
    				var parentGrid= this.getRoadTaxHistoryList();
    				this.getDeleteDocuments(grid,url, parentGrid);
    			}
    		},
    	    'addressformwindow[itemId=vehicleAddressFormWindow] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#genericFieldId1': {
                select: function(combo, record) {
                    this.onSelectionGenericField(combo, record, this.getPersonAddressFieldsForm());
                }
            },
            'addressformwindow[itemId=vehicleAddressFormWindow] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#countryId': {
                select: function(combo, record) {
                    this.onSelectionCountry(combo, record, this.getPersonAddressFieldsForm());
                },

                change: function(combo, newValue) {
                    this.onChangeCountry(combo, newValue, this.getPersonAddressFieldsForm());
                }
            },
            'addressformwindow[itemId=vehicleAddressFormWindow] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#parentCountryRegionId': {
                select: function(obj1, record) {
                    var cityComboBox = obj1.up('form').down('customcombobox#cityId');
                    cityComboBox.reset();

                    var countryRegion1 = record[0].get("id");
//                    var store = this.getStore('organization.CountryRegionStore1');
                    var store = this.getStore('organization.CityByCountryRegion');
//                    store.getProxy().api.read = SERVERURL.COUNTRY_FINDALL;
                    store.getProxy().extraParams = {
                        id: countryRegion1
                    };
                    store.reload();
                }
            },
            'addressformwindow[itemId=vehicleAddressFormWindowForHistory] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#parentCountryRegionId': {
                select: function(obj1, record) {
                    var cityComboBox = obj1.up('form').down('customcombobox#cityId');
                    cityComboBox.reset();

                    var countryRegion1 = record[0].get("id");
//                    var store = this.getStore('organization.CountryRegionStore1');
                    var store = this.getStore('organization.CityByCountryRegion');
//                    store.getProxy().api.read = SERVERURL.COUNTRY_FINDALL;
                    store.getProxy().extraParams = {
                        id: countryRegion1
                    };
                    store.reload();
                }
            },
            'addressformwindow[itemId=vehicleAddressFormWindowForHistory] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#genericFieldId1': {
                select: function(combo, record) {
                    this.onSelectionGenericField(combo, record, this.getPersonAddressFieldsForm());
                }
            },
            'addressformwindow[itemId=vehicleAddressFormWindowForHistory] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#countryId': {
                select: function(combo, record) {
                    this.onSelectionCountry(combo, record, this.getPersonAddressFieldsForm());
                },

                change: function(combo, newValue) {
                    this.onChangeCountry(combo, newValue, this.getPersonAddressFieldsForm());
                }
            },
            'journeyassignmentlist':{
    			render : function(grid){
    				// this.doAccessControlValidation(grid, this.getJOURNEY_ASSIGNMENT_PERMISSION());
    				this.getJourneyAssignmentDetails(grid);
    			},
    			cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    				if (e.target.tagName == 'A') {
    						this.getNumberOfUserServicedWin(record);
    				}
    			} 
    		},
    		'journeyassignmentlist button[itemId=btnAdd]':{
    			click :this.getShowJourneyAssignmentWin
    		},
            'journeyassignmentlist button[itemId=btnEdit]':{
    			click : this.getEditJourneyAssignment
    		},
    		'journeyassignmentlist button[itemId=btnView]' :{
    			click : this.getViewJourneyAssignment
    		},
    		'journeyassignmentdetailwin button[itemId=SubmitBtn]' :{
    			click : this.getSaveJourneyAssignmentDetails
    		},
    		'journeyassignmentdetailwin button[itemId=CancelBtn]' :{
    			click : this.getCloseJourneyAssignmentWin
    		},
    		'numberofusercoveredgridwindow button[itemId=btnAdd]':{
    			click : this.getUpdateServicedUser
    		},
    		'journeyassignmentstructure button[itemId=SearchBtn]' :{
    			click : this.getSearchJourneyAssignment
    		},
    		'journeyassignmentstructure button[itemId=cancelBtn]' :{
    			click : this.getResetJourneyAssignment
    		},
    		'vehiclestructure':{
	        	afterrender : function(structure){
	        		var container = structure.items.items[0];
	        		var grid = container.down('vehiclelist');
	        	    //this.getGridHeaderFreeze(grid,structure);
	        	}
    		},
    		'vehicletypegrid[itemId=vehicletypegridItemId]': {
    			render: function(grid){
    				var store = grid.getStore();
    				this.resetPageSetting(store);
    				store.getProxy().extraParams = {
    		        	limit : CONSTANTS.DEFAULT_PAGESIZE
    		    	}
    				store.load();
    				this.doAccessControlValidation(grid, this.getTRANSPORT_VEHICLE_TYPE_PERMISSION());
    			},
    			afterlayout: function(grid){
    				grid.up().up().scrollBy(0,-1);
    				grid.up().up().scrollBy(0,1);
    			}
    		},
    		'vehicletypegrid button[itemId=btnAdd]':{
    			click: this.addVehicleType
    		},
            'vehicletypegrid button[itemId=btnEdit]': {
    			click: function() {
    				this.editVehicleType(false);
    			}
    		},
    		'vehicletypegrid button[itemId=btnView]': {
    			click: function() {
    				this.editVehicleType(true);
    			}
    		},
    		'vehicletypegrid button[itemId=btnDelete]': {
    			click: function() {
    				this.deleteVehicleType();
    			}
    		},
    		'vehicletypeformwindow button[itemId=btnCancelVehicleTypeForm]': {
                click: this.cancelVehicleTypeForm
            },
            'vehicletypeformwindow button[itemId=btnSaveVehicleTypeForm]': {
                click: this.saveVehicleTypeForm
            },
            'stoplocationgrid[itemId=stopLocationgridItemId]': {
    			render: function(grid){
    				var store = grid.getStore();
    				this.resetPageSetting(store);
    				store.getProxy().extraParams = {
    		        	limit : CONSTANTS.DEFAULT_PAGESIZE
    		    	}
    				store.load();
    				this.doAccessControlValidation(grid, this.getTRANSPORT_STOP_LOCATION_PERMISSION());
    			}
    		},
    		'stoplocationgrid button[itemId=btnAdd]':{
    			click: this.addStopLocation
    		},
            'stoplocationgrid button[itemId=btnEdit]': {
    			click: function() {
    				this.editStopLocation(false);
    			}
    		},
    		'stoplocationgrid button[itemId=btnView]': {
    			click: function() {
    				this.editStopLocation(true);
    			}
    		},
    		'stoplocationformwindow button[itemId=btnCancelStopLocationForm]': {
                click: this.cancelStopLocationForm
            },
            'stoplocationformwindow button[itemId=btnSaveStopLocationForm]': {
                click: this.saveStopLocationForm
            },
            'vehiclepermitgrid':{
    			render : function(grid){
    				this.getRenderVehiclePermit(grid);
    				this.doAccessControlValidation(grid, this.getTRANSPORT_VEHICLE_PERMIT_PERMISSION());
    			},
    			cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
					 	if(columnName == "permitDocumentId"){
							if(e.target.tagName=='A'){
									var whetherFile = false;
									var documentId = record.raw.encryptedDocId;
									if(!isNullOrEmpty(documentId)){
										Ext.Ajax.request({
											type: 'rest',
											url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
											method: 'GET',
											callback : function(opt, success, response){
												if(response.responseText == 'true') {
													var csvForm = Ext.create('Ext.form.Panel'); 
													csvForm.getForm().submit({
														target: '_blank',
														method:'GET',
														params :{
															access_token : Ext.Ajax.defaultHeaders.access_token
														},
														headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
														url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
														standardSubmit :true
													});
												} else {
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
												}
											}
										});
									}
							}
						}
				 }
    		},
    
    		'vehiclepermitgrid button[itemId=btnAdd]' :{
    			click : this.getShowVehiclePermitWin
    		},
    		
    		'vehiclepermitgrid button[itemId=btnDelete]' :{
    			click : this.deleteVehiclePermitGridData
    		},
    		'vehiclepermitgrid button[itemId=btnEdit]' :{
    			click : function(){
    				this.editVehiclePermitData('EDIT');
    			}
    		},
    		'vehiclepermitgrid button[itemId=btnView]' :{
    			click : this.viewVehiclePermitData
    		},
    		'vehiclepermitdetailwin button[itemId=SubmitBtnVehiclePermit]' :{
    			click : this.saveVehiclePermitForm
    		},
    		'vehiclepermitdetailwin button[itemId=CancelBtnVehiclePermit]' :{
    			click : this.closeVehiclePermitWin
    		},
    		'vehiclepermitdetailwin filefield[itemId=vehiclePermitUploadFile]' : {
    			change: function(DocFile, value, eOpts) {
    				value = value.replace('C:\\fakepath\\', '');
    				var newValue = value.replace(/ +/g, " ").split(' ').join('_');
    				DocFile.setRawValue(newValue);
    			}
    		},
   		 'fitnesscertificategrid':{
  			render : function(grid){
  				this.getRenderFitnessCertificate(grid);
 				this.doAccessControlValidation(grid, this.getTRANSPORT_VEHICLE_FITNESS_CERTIFICATE_PRIVILEGES_PERMISSION());

  			},
  			cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
					 	if(columnName == "fitnessDocumentId"){
							if(e.target.tagName=='A'){
									var whetherFile = false;
									var documentId = record.raw.encryptedDocId;
									if(!isNullOrEmpty(documentId)){
										Ext.Ajax.request({
											type: 'rest',
											url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
											method: 'GET',
											callback : function(opt, success, response){
												if(response.responseText == 'true') {
													var csvForm = Ext.create('Ext.form.Panel'); 
													csvForm.getForm().submit({
														target: '_blank',
														method:'GET',
														params :{
															access_token : Ext.Ajax.defaultHeaders.access_token
														},
														headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
														url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
														standardSubmit :true
													});
												} else {
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
												}
											}
										});
									}
							}
						}
				 }
 		
  		},
    		
    		'fitnesscertificategrid button[itemId=btnAdd]' :{
    			click : this.getShowVehicleFitnessCertificateWin
    		},
    		'fitnesscertificategrid button[itemId=btnEdit]' :{
    			click : function(){
    				this.editVehicleFitnessCertificateRecords('EDIT');
    			}
    		},
    		'fitnesscertificategrid button[itemId=btnView]' :{
    			click : this.viewVehicleFitnessCertificateRecords
    		},
    		'fitnesscertificategrid button[itemId=btnDelete]' :{
    			click : this.deleteVehicleFitnessCertificateGridData
    		},
    		
    		'fitnesscertificatewin button[itemId=SubmitBtnVehicleFitCertificate]' :{
    			click : this.saveVehicleFitCertificateForm
    		},
    		'fitnesscertificatewin button[itemId=CancelBtnVehicleFitCertificate]' :{
    			click : this.closeVehicleFitnessCertificateWin
    		},
    		'fitnesscertificatewin filefield[itemId=vehicleFitCertificateUploadFile]' : {
    			change: function(DocFile, value, eOpts) {
    				value = value.replace('C:\\fakepath\\', '');
    				var newValue = value.replace(/ +/g, " ").split(' ').join('_');
    				DocFile.setRawValue(newValue);
    			}
    		},
    	});
    	this.callParent(arguments);
    },
    /**
     * when search form render, vehicleNo , vender,model,serviceBy store will load .
     * @Params academyLocationId 
     */
    getRenderVehicleSearchForm : function(form){
    	
    	var academyLocationId = this.getCurrentAcademyLocation();
    	var vehicleNoStore = form.down("#vehicleNo").getStore();
        vehicleNoStore.getProxy().extraParams = {
        	academyLocationId : academyLocationId
    	},
    	vehicleNoStore.load();
        
        var vehicleVenderStore = form.down("#vender").getStore();
        vehicleVenderStore.getProxy().extraParams = {
        	academyLocationId : academyLocationId
    	},
    	vehicleVenderStore.load();
        
        var vehicleModelStore = form.down("#model").getStore();
        vehicleModelStore.getProxy().extraParams = {
        	academyLocationId : academyLocationId
    	},
    	vehicleModelStore.load();
        
        var vehicleServicebyStore = form.down("#servicedBy").getStore();
        vehicleServicebyStore.getProxy().extraParams = {
        	academyLocationId : academyLocationId
    	},
    	vehicleServicebyStore.load();
        
        var routeNameStore = form.down("#routeName").getStore();
        routeNameStore.getProxy().extraParams = {
        	academyLocationIds : academyLocationId
    	},
    	routeNameStore.load();
        var roadTaxAuthorityStore = form.down("#roadTaxAuthority").getStore();
        roadTaxAuthorityStore.getProxy().extraParams = {
        	alId : academyLocationId
    	};    	
    	var insuredByStore = form.down("#insuredBy").getStore();
        insuredByStore.getProxy().extraParams = {
        	alId : academyLocationId
    	};
    },
    /**
     * common function for open vehicle detail form 
     */
    getOpenVehicleDetailForm : function(){
    	
     var contentpanel = this.getContentPanel();
   	 var structure = Ext.widget('vehicledetailform');
   	 var tabName = getTransportTranslation('VEHICLE_DETAILS');

   	 var getcontroller=this.getController('menu.CoreERPNavigationController');
   	 var getTab=getcontroller.getTab(tabName);
   	 if(getTab!=null){
   		 contentpanel.remove(getTab, true);
   	 }
   	 openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_ELEVEN);
    },
    
    /**
     * Apply Filters for vehicle detail search
     */
    getSearchVehicleDetails : function(obj){
    	var $this=this;
    	var academyLocationId = this.getCurrentAcademyLocation();
    	var form = obj.up('form');
    	var values = form.getForm().getValues();
    	var grid = this.getVehicleList();
    	var gridStore = grid.getStore();
    	
    	gridStore.getProxy().extraParams = {
            academyLocationId : academyLocationId,
    		vehicleNumber:form.down("#vehicleNo").getRawValue(),
    		vehicleSubType:values.subType,//form.down("#subType").getRawValue(),
    		modelName : form.down("#model").getRawValue(),
    		vendorName: form.down("#vender").getRawValue(),
    		serviceByName : form.down("#servicedBy").getRawValue(),
    		MinCapacity : values.minCapacity,
    		MaxCapacity : values.maxCapacity,
    	    roadTaxAuthority : values.roadTaxAuthority,
    	    event:values.event,
    	    insuredBy:values.insuredBy,
    	    periodFrom : values.periodFrom,
    	    periodTill : values.periodTill,
    	    insuranceExpiryOn:values.insuranceExpiryBy,
    	    emissionExpiryOn:values.emissionExpiryBy,
    	    roadTaxExpiryOn :values.roadTaxExpiryBy,
    	    licenseExpiryDate: values.licenseExpiryDate
    	};
    	$this.resetPageSetting(gridStore);
    	gridStore.load();
    	grid.getSelectionModel().deselectAll();
    },
    /**
     * edit vehicle detail based on vehiucle id.
     * @param vehicleId
     */
    getEditVehicleDetails : function(){
    	var this$ = this;
    	var grid = this$.getVehicleList();
    	if (grid.getSelectionModel().getCount() > 0) {
    		this$.getOpenVehicleDetailForm();
    		var form = this$.getVehicleDetailForm();
    		var record = grid.getSelectionModel().getSelection()[0];
    		var id = record.get("id");
    		var editUrl = SERVERURL.VEHICLE_DETAILS_FIND_BY_ID;
    		Ext.Ajax.request({
    			method: "GET",
    			type: 'rest',
    			url: editUrl,
    			params: {
    				vehicleId: id
    			},
    			success: function(f, action) {
    				var data = Ext.JSON.decode(f.responseText);
    				if(!isNullOrEmpty(data.wsVehicleEmissionDetail)) {
    					if(!isNullOrEmpty(data.wsVehicleEmissionDetail.emissionCheckOn))
    						data.wsVehicleEmissionDetail.emissionCheckOn = new Date(data.wsVehicleEmissionDetail.emissionCheckOn);
    					if(!isNullOrEmpty(data.wsVehicleEmissionDetail.emissionToBeCheckOn))
    						data.wsVehicleEmissionDetail.emissionToBeCheckOn = new Date(data.wsVehicleEmissionDetail.emissionToBeCheckOn);
    				}
    				if(!isNullOrEmpty(data.wsVehicleInsuranceDetail)) {
    					if(!isNullOrEmpty(data.wsVehicleInsuranceDetail.validFrom))
    						data.wsVehicleInsuranceDetail.validFrom = new Date(data.wsVehicleInsuranceDetail.validFrom);
    					if(!isNullOrEmpty(data.wsVehicleInsuranceDetail.validTill))
    						data.wsVehicleInsuranceDetail.validTill = new Date(data.wsVehicleInsuranceDetail.validTill);
    					if(!isNullOrEmpty(data.wsVehicleInsuranceDetail.insurancePaidOn))
    						data.wsVehicleInsuranceDetail.insurancePaidOn = new Date(data.wsVehicleInsuranceDetail.insurancePaidOn);
    				}
    				if(!isNullOrEmpty(data.wsVehicleRoadTaxDetail)) {
    					if(!isNullOrEmpty(data.wsVehicleRoadTaxDetail.roadTaxPaidOn))
    						data.wsVehicleRoadTaxDetail.roadTaxPaidOn = new Date(data.wsVehicleRoadTaxDetail.roadTaxPaidOn);
    					if(!isNullOrEmpty(data.wsVehicleRoadTaxDetail.validFrom))
    						data.wsVehicleRoadTaxDetail.validFrom = new Date(data.wsVehicleRoadTaxDetail.validFrom);
    					if(!isNullOrEmpty(data.wsVehicleRoadTaxDetail.validTill))
    						data.wsVehicleRoadTaxDetail.validTill = new Date(data.wsVehicleRoadTaxDetail.validTill);
    				}
    				var vehicleDetailModel = new Academia.model.transport.vehicle.VehicleDetailData(data);
    				form.loadRecord(vehicleDetailModel);
    				form.down("#vehicleCode").setValue(vehicleDetailModel.get("resourceCode"));
    				if(!isNullOrEmpty(vehicleDetailModel.data)){
    					form.down('#transVehicleDescriptionId').setValue(vehicleDetailModel.data.vehicleDescription);
    					if(!isNullOrEmpty(vehicleDetailModel.data.lastServiced)) {
    						form.down('#lastServiced').setValue(dateRender(vehicleDetailModel.data.lastServiced))
    					}	
    				}
    				var subtype = form.down("#subType");
    				subtype.getStore().load({
    					callback : function(rec,operation,success){
    						subtype.setValue(parseInt(data.vehicleSubTypeId));
    					}
    				});
    				
    				var route = form.down("#hasARegularRoute");
    				route.getStore().load({
    					callback : function(res,operation,success){
    						if(data.whetherRouteApplicable){
    							route.setValue('YES');
    						}else{
    							route.setValue('NO');
    						}
    					}
    				});
    				
    				if(data.wsVehicleInsuranceDetail){
    					var wsVehicleInsuranceDetail = data.wsVehicleInsuranceDetail;
    					
    					form.down("#insuranceId").setValue(wsVehicleInsuranceDetail.id);
    					form.down("#insuredBy").setValue(wsVehicleInsuranceDetail.insuranceVendor);
    					form.down("#insuranceValidFrom").setValue(wsVehicleInsuranceDetail.validFrom);
    					form.down("#insuranceValidTill").setValue(wsVehicleInsuranceDetail.validTill);
    					
    					form.down("#insurancePolicyWith").setValue(wsVehicleInsuranceDetail.insurancePolicyWith);
    					form.down("#policyNumber").setValue(wsVehicleInsuranceDetail.policyNumber);
    					form.down("#insuranceCost").setValue(wsVehicleInsuranceDetail.insuranceCost);
    					form.down("#insurancePaidOn").setValue(wsVehicleInsuranceDetail.insurancePaidOn);
    					form.down("#insuranceAddressId").setValue(wsVehicleInsuranceDetail.addressId);
    				//	form.down("#insuranceAlertModel").setValue(wsVehicleInsuranceDetail.insuranceAlertModel);
    					form.down("#insuranceAlertBeforeNdays").setValue(wsVehicleInsuranceDetail.insuranceAlertBeforeNdays);
    					form.down("#policyHolderName").setValue(wsVehicleInsuranceDetail.policyHolderName);
    					form.down("#inceptionDate").setValue(dateRender(wsVehicleInsuranceDetail.inceptionDate));
    					form.down("#premiumPaymentCycle").setValue(wsVehicleInsuranceDetail.premiumPaymentCycle);
    					form.down("#brokerMobileNumber").setValue(wsVehicleInsuranceDetail.brokerMobileNumber);
    					
    					if(!isNullOrEmpty(wsVehicleInsuranceDetail.validTill)){
    						if (wsVehicleInsuranceDetail.validTill >= new Date()) {
    							form.down("#insuranceValidFrom").setMaxValue(new Date());
    						} else {
    							form.down("#insuranceValidFrom").setMaxValue(wsVehicleInsuranceDetail.validTill);
    						}
    					}
    					
    					var countryCode = form.down("#brokerMobileCountryCode");
    					var countryCodeStore = countryCode.getStore();
    					countryCodeStore.load({
 							 callback: function(rec, operation, success) {
 								 if (success) {
 									countryCode.setValue(wsVehicleInsuranceDetail.brokerMobileCountryCode);
 								 }
 							 }
 						 });
    					
    					var insurancyCurrency = form.down("#insuranceCurrency");
    					var currncyStore = insurancyCurrency.getStore();
 						currncyStore.load({
 							 callback: function(rec, operation, success) {
 								 if (success) {
 										insurancyCurrency.setValue(wsVehicleInsuranceDetail.currencyId);
 								 }
 							 }
 						 });
    				}
    				if(data.wsVehicleEmissionDetail){
    					var wsVehicleEmissionDetail = data.wsVehicleEmissionDetail;
    					
    					form.down("#emissionId").setValue(wsVehicleEmissionDetail.id);
    					form.down("#emissionAddressId").setValue(wsVehicleEmissionDetail.addressId);
    					form.down("#emissionChkedOn").setValue(wsVehicleEmissionDetail.emissionCheckOn);
    					form.down("#emissionToBeCheckedOn").setValue(wsVehicleEmissionDetail.emissionToBeCheckOn);
    					form.down("#emissionDocumentWith").setValue(wsVehicleEmissionDetail.emissionPolicyWith);
    					form.down("#emissionVender").setValue(wsVehicleEmissionDetail.emissionVendor);
    					form.down("#emissionCheckCost").setValue(wsVehicleEmissionDetail.emissionCost);
    					//form.down("#emissionAlertModel").setValue(wsVehicleEmissionDetail.emissionAlertModel);
    					form.down("#emissionAlertBeforeNdays").setValue(wsVehicleEmissionDetail.emissionAlertBeforeNdays);
    					
    					var emissionCurrency = form.down("#emissionCurrency");
    					var currncyStore = emissionCurrency.getStore();
 						currncyStore.load({
 							 callback: function(rec, operation, success) {
 								 if (success) {
 									emissionCurrency.setValue(wsVehicleEmissionDetail.currencyId);
 								 }
 							 }
 						 });
    				}
    				
    				if(data.wsVehicleRoadTaxDetail){
    					var wsVehicleRoadTaxDetail = data.wsVehicleRoadTaxDetail;
    					
    					form.down("#roadTaxId").setValue(wsVehicleRoadTaxDetail.id);
    					form.down("#roadTaxAddressId").setValue(wsVehicleRoadTaxDetail.addressId);
    					form.down("#roadTaxValidFrom").setValue(wsVehicleRoadTaxDetail.validFrom);
    					form.down("#roadTaxValidTill").setValue(wsVehicleRoadTaxDetail.validTill);
    					form.down("#roadTaxVender").setValue(wsVehicleRoadTaxDetail.roadTaxVendor);
    					form.down("#roadTaxCost").setValue(wsVehicleRoadTaxDetail.roadTaxCost);
    					form.down("#roadTaxPaidOn").setValue(wsVehicleRoadTaxDetail.roadTaxPaidOn);
    					form.down("#roadTaxDocumentWith").setValue(wsVehicleRoadTaxDetail.roadTaxWith);
    				   // form.down("#roadTaxAlertModel").setValue(wsVehicleRoadTaxDetail.roadTaxAlertModel);
    					form.down("#roadTaxAlertBeforeNdays").setValue(wsVehicleRoadTaxDetail.roadTaxAlertBeforeNdays);
    					
    					if(!isNullOrEmpty(wsVehicleRoadTaxDetail.validTill)){
    						if (wsVehicleRoadTaxDetail.validTill >= new Date()) {
    							form.down("#roadTaxValidFrom").setMaxValue(new Date());
    						} else {
    							form.down("#roadTaxValidFrom").setMaxValue(wsVehicleRoadTaxDetail.validTill);
    						}
    					}
    					
    					var roadTaxCurrency = form.down("#roadTaxCurrency");
    					var currncyStore = roadTaxCurrency.getStore();
 						currncyStore.load({
 							 callback: function(rec, operation, success) {
 								 if (success) {
 									roadTaxCurrency.setValue(wsVehicleRoadTaxDetail.currencyId);
 								 }
 							 }
 						 });
    				}
    					
    				if(data.wsVehicleLicenseRegistrationDetail){
        					var wsVehicleLicenseRegistrationDetail = data.wsVehicleLicenseRegistrationDetail;
        					
        					form.down("#licenceRegistrationId").setValue(wsVehicleLicenseRegistrationDetail.id);
        					form.down("#transLicenceDiskNo").setValue(wsVehicleLicenseRegistrationDetail.licenceDiskNumber);
        					form.down("#transLicenceNo").setValue(wsVehicleLicenseRegistrationDetail.licenceNumber);
        					form.down("#transVehicleLicenceNo").setValue(wsVehicleLicenseRegistrationDetail.vehicleLicenseNumber);
        					form.down("#transVin").setValue(wsVehicleLicenseRegistrationDetail.vin);
        					form.down("#transEngineNo").setValue(wsVehicleLicenseRegistrationDetail.engineNumber);
        					form.down("#transFees").setValue(wsVehicleLicenseRegistrationDetail.fees);
        					form.down("#transGVM").setValue(wsVehicleLicenseRegistrationDetail.gvm);
        				    form.down("#transTARE").setValue(wsVehicleLicenseRegistrationDetail.tare);
        					form.down("#transDateOfExpiry").setValue(dateRender(wsVehicleLicenseRegistrationDetail.expiryDate));
        					form.down("#transDateOfTest").setValue(dateRender(wsVehicleLicenseRegistrationDetail.testDate));
        					form.down("#transExpiryAlertBeforeNdays").setValue(wsVehicleLicenseRegistrationDetail.expiryAlertBeforeNdays);
        					
        			}
    			}
    		 });
    		}else{
    			 showWarningMessage(getTransportTranslation('VEHICLE_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    		}
       },
       /**
        * view vehicle details
        */
       getViewVehicleDetailForm : function(obj){
    	   this.getEditVehicleDetails();
    		var form =this.getVehicleDetailForm();
    		if (form) {
    			var buttonId = obj.itemId;
				form.down("#listButtonId").setValue(buttonId);
    			form.down('#SubmitBtn').setVisible(false);
    			form = form.getForm();
    		    toggleReadOnlyFormItems(form,true);
    		}
       },
       /**
        */
       getSaveVehicleDetails : function(){
    	   var this$ = this;
    	   
    	   var grid = this$.getVehicleList();
       	   var gridStore = grid.getStore();
    	   
    	   var form = this$.getVehicleDetailForm();
    	   var values = form.getForm().getValues();
    	   var vehicleDetailData =  new Academia.model.transport.vehicle.VehicleDetailData();
    	   vehicleDetailData.set("id",values.id);
    	   vehicleDetailData.set("resourceId",values.resourceId);
    	   vehicleDetailData.set("vehicleCode",values.vehicleCode);
    	   vehicleDetailData.set("resourceCode",values.vehicleCode);
    	   vehicleDetailData.set("vehicleNumber",values.vehicleNumber);
    	   vehicleDetailData.set("capacity",values.capacity);
    	   vehicleDetailData.set("model",values.model);
    	   vehicleDetailData.set("purchaseFrom",values.purchaseFrom);
    	   vehicleDetailData.set("serviceBy",values.serviceBy);
    	   vehicleDetailData.set("status","ACTIVE");
    	   vehicleDetailData.set("purchaseFromAddressId",values.purchaseFromAddressId);
    	   vehicleDetailData.set("serviceFromAddressId",values.serviceFromAddressId);
    	   vehicleDetailData.set("lastServiced",values.lastServiced);
    	   vehicleDetailData.set("vehicleDescription",values.transVehicleDescriptionId);
    	   if (values.hasARegularRoute == 'YES') {
        	   vehicleDetailData.set("whetherRouteApplicable", true);
    	   } else {
		    	   vehicleDetailData.set("whetherRouteApplicable", false);
    	   }
    	   
    	   var vehicleDetailMsg;
    	   if((! isNullOrEmpty(values.licenceRegistrationId) || ! isNullOrEmpty(values.transLicenceDiskNo) || 
    			   ! isNullOrEmpty(values.transLicenceNo) || ! isNullOrEmpty(values.transVehicleLicenceNo) || 
    			   ! isNullOrEmpty(values.transVin) || ! isNullOrEmpty(values.transEngineNo) || 
    			   ! isNullOrEmpty(values.transFees) || ! isNullOrEmpty(values.transGVM) || 
    			   ! isNullOrEmpty(values.transTARE) || ! isNullOrEmpty(values.transDateOfTest) ||
    			   ! isNullOrEmpty(values.transExpiryAlertBeforeNdays) ) && (isNullOrEmpty(values.transDateOfExpiry))) {
    		   vehicleDetailMsg = 'LICENCE_REGISTRATION_DETAIL_MSG';
    	   } else if((! isNullOrEmpty(values.insuranceId) || ! isNullOrEmpty(values.insuranceCurrency) || 
    			   ! isNullOrEmpty(values.insuranceAddressId) || ! isNullOrEmpty(values.insuredBy) || 
    			   ! isNullOrEmpty(values.policyNumber) || ! isNullOrEmpty(values.insurancePolicyWith) || 
    			   ! isNullOrEmpty(values.insuranceCost) || ! isNullOrEmpty(values.insurancePaidOn) || 
    			   ! isNullOrEmpty(values.insuranceAlertBeforeNdays) || ! isNullOrEmpty(values.policyHolderName) ||
    			   ! isNullOrEmpty(values.inceptionDate) || ! isNullOrEmpty(values.premiumPaymentCycle) ||
    			   ! isNullOrEmpty(values.brokerMobileCountryCode) || ! isNullOrEmpty(values.brokerMobileNumber) || !isNullOrEmpty(values.insuranceValidFrom) || !isNullOrEmpty(values.insuranceValidTill)) && (isNullOrEmpty(values.insuranceValidFrom) || isNullOrEmpty(values.insuranceValidTill))) {
    		   vehicleDetailMsg = 'INSURANCE_DETAIL_MSG';
    	   } else if((! isNullOrEmpty(values.emissionId) || ! isNullOrEmpty(values.emissionCurrency) || 
    			   ! isNullOrEmpty(values.emissionAddressId) || ! isNullOrEmpty(values.emissionVender) || 
    			   ! isNullOrEmpty(values.emissionChkedOn) || ! isNullOrEmpty(values.emissionDocumentWith) || 
    			   ! isNullOrEmpty(values.emissionCheckCost) || ! isNullOrEmpty(values.emissionAlertBeforeNdays) ) && 
    			   isNullOrEmpty(values.emissionToBeCheckedOn)) {
    		   vehicleDetailMsg = 'EMISSION_CHECK_DETAIL_MSG';
    	   } else if((! isNullOrEmpty(values.roadTaxId) || ! isNullOrEmpty(values.roadTaxCurrency) || 
    			   ! isNullOrEmpty(values.roadTaxAddressId) || ! isNullOrEmpty(values.roadTaxVender) || 
    			   ! isNullOrEmpty(values.roadTaxDocumentWith) || ! isNullOrEmpty(values.roadTaxCost) || 
    			   ! isNullOrEmpty(values.roadTaxPaidOn) || ! isNullOrEmpty(values.roadTaxAlertBeforeNdays) || !isNullOrEmpty(values.roadTaxValidFrom) || !isNullOrEmpty(values.roadTaxValidTill)) && 
    			   (isNullOrEmpty(values.roadTaxValidFrom) || isNullOrEmpty(values.roadTaxValidTill))) {
    		   vehicleDetailMsg = 'ROAD_TAX_DETAIL_MSG';
    	   }
    	   if(! isNullOrEmpty(vehicleDetailMsg)) {
    		   if(vehicleDetailMsg == 'LICENCE_REGISTRATION_DETAIL_MSG') {
    			   showWarningMessage(getTransportTranslation('TRANS_LICENCE_AND_REGISTRATION_DETAILS'), getTransportTranslation('LICENCE_REGISTRATION_DETAIL_MSG'));
    		   } else if(vehicleDetailMsg == 'INSURANCE_DETAIL_MSG') {
    			   showWarningMessage(getTransportTranslation('INSURANCE_DETAILS'), getTransportTranslation('INSURANCE_DETAIL_MSG'));
    		   }else if(vehicleDetailMsg == 'EMISSION_CHECK_DETAIL_MSG') {
    			   showWarningMessage(getTransportTranslation('EMISSION_DETAILS'), getTransportTranslation('EMISSION_CHECK_DETAIL_MSG'));
    		   }else if(vehicleDetailMsg == 'ROAD_TAX_DETAIL_MSG') {
    			   showWarningMessage(getTransportTranslation('ROAD_TAX_DETAILS'), getTransportTranslation('ROAD_TAX_DETAIL_MSG'));
    		   }
    	   } else {
    	   var wsVehicleLicenseRegistrationDetail = {
        	       "id": values.licenceRegistrationId,
        	       "vehicle": this$.getIdValueJson(values.id),
        	       "licenceDiskNumber": values.transLicenceDiskNo,
        	       "licenceNumber": values.transLicenceNo,
        	       "vehicleLicenseNumber": values.transVehicleLicenceNo,
        	       "vin": values.transVin,
        	       "engineNumber": values.transEngineNo,
        	       "fees": values.transFees,
        	       "gvm": values.transGVM,
        	       "tare": values.transTARE,
        	       "expiryDate": values.transDateOfExpiry,
        	       "testDate": values.transDateOfTest,
        	       "expiryAlertBeforeNdays": values.transExpiryAlertBeforeNdays,
        	   };
    	   
    	   
    	   var wsVehicleInsuranceDetail = {
    	       "id": values.insuranceId,
    	       "vehicle": this$.getIdValueJson(values.id),
    	       "currencyId": values.insuranceCurrency,
    	       "addressId": values.insuranceAddressId,
    	       "insuranceVendor": values.insuredBy,
    	       "validFrom": values.insuranceValidFrom,
    	       "validTill": values.insuranceValidTill,
    	       "policyNumber": values.policyNumber,
    	       "insurancePolicyWith": values.insurancePolicyWith,
    	       "insuranceCost": values.insuranceCost,
    	       "insurancePaidOn": values.insurancePaidOn,
    	      // "insuranceAlertModel": values.insuranceAlertModel,
    	       "insuranceAlertBeforeNdays": values.insuranceAlertBeforeNdays,
    	       "policyHolderName": values.policyHolderName,
    	       "inceptionDate": values.inceptionDate,
    	       "premiumPaymentCycle": values.premiumPaymentCycle,
    	       "brokerMobileCountryCode": values.brokerMobileCountryCode,
    	       "brokerMobileNumber": values.brokerMobileNumber
    	   };
    	   
    	   var wsVehicleEmissionDetail = {
        	       "id": values.emissionId,
        	       "vehicle": this$.getIdValueJson(values.id),
        	       "currencyId": values.emissionCurrency,
        	       "addressId": values.emissionAddressId,
        	       "emissionVendor": values.emissionVender,
        	       "emissionCheckOn": values.emissionChkedOn,
        	       "emissionToBeCheckOn": values.emissionToBeCheckedOn,
        	       "emissionPolicyWith": values.emissionDocumentWith,
        	       "emissionCost": values.emissionCheckCost,
        	       //"emissionAlertModel": values.emissionAlertModel,
        	       "emissionAlertBeforeNdays": values.emissionAlertBeforeNdays
        	   };
    	   var wsVehicleRoadTaxDetail = {
        	       "id": values.roadTaxId,
        	       "vehicle": this$.getIdValueJson(values.id),
        	       "currencyId": values.roadTaxCurrency,
        	       "addressId": values.roadTaxAddressId,
        	       "roadTaxVendor": values.roadTaxVender,
        	       "validFrom": values.roadTaxValidFrom,
        	       "validTill": values.roadTaxValidTill,
        	       "roadTaxWith": values.roadTaxDocumentWith,
        	       "roadTaxCost": values.roadTaxCost,
        	       "roadTaxPaidOn": values.roadTaxPaidOn,
        	     //  "roadTaxAlertModel": values.roadTaxAlertModel,
        	       "roadTaxAlertBeforeNdays": values.roadTaxAlertBeforeNdays
        	   };
    	   vehicleDetailData.set("wsVehicleInsuranceDetail",wsVehicleInsuranceDetail);
    	   vehicleDetailData.set("wsVehicleEmissionDetail",wsVehicleEmissionDetail);
    	   vehicleDetailData.set("wsVehicleRoadTaxDetail",wsVehicleRoadTaxDetail);
    	   vehicleDetailData.set("wsVehicleLicenseRegistrationDetail",wsVehicleLicenseRegistrationDetail);
    	   
    	   delete vehicleDetailData.data.resourceCode;
    	   delete vehicleDetailData.data.vehicleSubTypeId;
    	   
    	   var submitData = Ext.encode(vehicleDetailData.data);
    	   var submitUrl = SERVERURL.VEHICLE_DETAILS_UPDATE; 
    	   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

    	   Ext.Ajax.request({
    		   url: submitUrl,
    		   jsonData: submitData,
    		   method: 'POST',
    		   success: function(response) {
    	    	   Ext.getBody().unmask();
    	    	   var contentpanel = this$.getContentPanel();
                   var getcontroller = this$.getController('menu.CoreERPNavigationController');
                   var getTab = getcontroller.getTab(getTransportTranslation('VEHICLE_DETAILS'));
                   if (getTab != null) {
                       contentPanel.remove(getTab, true);
                   }
    			   gridStore.reload();
    			   grid.getSelectionModel().deselectAll(true);
    			   showSuccessMessage(getTransportTranslation('VEHICLE_DETAILS'),getTransportTranslation('VEHICLE_DETAILS_ADDED_SUCCESSFULLY'));
    		   }
   		});
      }
   	},
   	getopenLicenceHistory : function(){
   		var grid = this.getVehicleList();
   		if (grid.getSelectionModel().getCount() > 0) {
   			var contentpanel = this.getContentPanel();
   			var structure = Ext.widget('licencehistorystructure');
   			var tabName = getTransportTranslation('LICENCE_HISTORY');
   			var getcontroller=this.getController('menu.CoreERPNavigationController');
   			var getTab=getcontroller.getTab(tabName);
   			if(getTab!=null){
   				contentpanel.remove(getTab, true);
   			}
   			openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_ELEVEN);
   		}else{
   			showWarningMessage(getTransportTranslation('VEHICLE_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
   		}
   	},
   	getopenFuelConsumption : function(){
   		var grid = this.getVehicleList();
   		if (grid.getSelectionModel().getCount() > 0) {
   			var contentpanel = this.getContentPanel();
   			var structure = Ext.widget('fuelconsumptionstructure');
   			var tabName = getTransportTranslation('FUEL_CONSUMPTION');
   			var getcontroller=this.getController('menu.CoreERPNavigationController');
   			var getTab=getcontroller.getTab(tabName);
   			if(getTab!=null){
   				contentpanel.remove(getTab, true);
   			}
   			openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_ELEVEN);
   		}else{
   			showWarningMessage(getTransportTranslation('VEHICLE_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
   		}
   	},
   	getOpenServiceHistory : function(){
   		var grid = this.getVehicleList();
   		if (grid.getSelectionModel().getCount() > 0) {
   			var contentpanel = this.getContentPanel();
   			var structure = Ext.widget('servicehistoryforvehiclestructure');
   			var tabName = getPersonModuleTranslation('SERVICE_HISTORY');
   			var getcontroller=this.getController('menu.CoreERPNavigationController');
   			var getTab=getcontroller.getTab(tabName);
   			if(getTab!=null){
   				contentpanel.remove(getTab, true);
   			}
   			openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_ELEVEN);
   		}else{
   			showWarningMessage(getTransportTranslation('VEHICLE_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
   		}
   	},
   	getopenInsuranceHistory : function(){
   		var grid = this.getVehicleList();
   		if (grid.getSelectionModel().getCount() > 0) {
   			var contentpanel = this.getContentPanel();
   			var structure = Ext.widget('insurancehistorystructure');
   			var tabName = getTransportTranslation('INSURANCE_HISTORY');
   			var getcontroller=this.getController('menu.CoreERPNavigationController');
   			var getTab=getcontroller.getTab(tabName);
   			if(getTab!=null){
   				contentpanel.remove(getTab, true);
   			}
   			openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_ELEVEN);
   		}else{
   			showWarningMessage(getTransportTranslation('VEHICLE_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
   		}
   	},
   	getopenEmissionHistory : function(){
   		var grid = this.getVehicleList();
   		if (grid.getSelectionModel().getCount() > 0) {
   			var contentpanel = this.getContentPanel();
   			var structure = Ext.widget('emissionhistorystructure');
   			var tabName = getTransportTranslation('EMISSION_HISTORY');
   			var getcontroller=this.getController('menu.CoreERPNavigationController');
   			var getTab=getcontroller.getTab(tabName);
   			if(getTab!=null){
   				contentpanel.remove(getTab, true);
   			}
   			openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_ELEVEN);
   		}else{
   			showWarningMessage(getTransportTranslation('VEHICLE_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
   		}
   	},
	getopenRoadTaxHistory : function(){
   		var grid = this.getVehicleList();
   		if (grid.getSelectionModel().getCount() > 0) {
   			var contentpanel = this.getContentPanel();
   			var structure = Ext.widget('roadtaxhistorystructure');
   			var tabName = getTransportTranslation('ROAD_TAX_HISTORY');
   			var getcontroller=this.getController('menu.CoreERPNavigationController');
   			var getTab=getcontroller.getTab(tabName);
   			if(getTab!=null){
   				contentpanel.remove(getTab, true);
   			}
   			openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_ELEVEN);
   		}else{
   			showWarningMessage(getTransportTranslation('VEHICLE_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
   		}
   	},
   	getopenJourneyAssignment : function(){
   		var grid = this.getVehicleList();
   		if (grid.getSelectionModel().getCount() > 0) {
   			var contentpanel = this.getContentPanel();
   			var structure = Ext.widget('journeyassignmentstructure');
   			var tabName = getTransportTranslation('JOURNEY_ASSIGNMENT');
   			var getcontroller=this.getController('menu.CoreERPNavigationController');
   			var getTab=getcontroller.getTab(tabName);
   			if(getTab!=null){
   				contentpanel.remove(getTab, true);
   			}
   			openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_ELEVEN);
   		}else{
   			showWarningMessage(getTransportTranslation('VEHICLE_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
   		}
   	},
   	getVehicleLocationWin : function(){
   		var frmWin = this.getVehicleLocationStatusWin();
   		if(!frmWin){
   			Ext.widget('vehiclelocationstatuswin');
   			frmWin = this.getVehicleLocationStatusWin();
   		}
   		frmWin.show();
   	},
 /*  	getopenVehicleLocation : function(){
   		var this$ = this;
   		var grid = this.getVehicleList();
   	//	if (grid.getSelectionModel().getCount() > 0) {
   		//	this$.getVehicleLocationWin();
   		//	var record = grid.getSelectionModel().getSelection()[0];
   		//	console.log(record);
//   			var id = record.get("id");
   			Ext.Ajax.request({
   				method: "GET",
   				type: 'rest',
   				url: SERVERURL.VEHICLE_LATEST_LOCATION_INFO,
   				params: {
   					vehicleRoadTaxDetailId: id
   				},
   				success: function(response,action) {
   					if(!isNullOrEmpty(response.responseText)){
   						var mapData = Ext.JSON.decode(response.responseText);	
   						console.log('mapData',mapData);
   						var options = {
   							    lat:mapData.lat,
   							    lng:mapData.longs,
   							    marker: {title:"Serosoft Solutions"},
   							    listeners: {
   							     click: function(e){
                                        console.log('e',e);
   							     }
   							    }                
   							   }
   					    var gm = Ext.getCmp('vehicle_gmappanel');
   				        var mpoint = new google.maps.LatLng(mapData.lat, mapData.longs);
   				        gm.addMarker(mpoint,options.marker,false,false, options.listeners);
   				        gm.center.marker.title="Testing";
   				        console.log(gm.center)
   					}
   				}
   			});
   		//}else{
   		//	showWarningMessage(getTransportTranslation('VEHICLE_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
   		//}
   	},*/
   	getopenVehicleLocation : function(){
   		var this$ = this;
   		Ext.Ajax.request({
   			method: "GET",
   			type: 'rest',
   			url: SERVERURL.VEHICLE_LATEST_LOCATION_INFO,
   			success: function(response,action) {
   				if(!isNullOrEmpty(response.responseText)){
   					var mapData = Ext.JSON.decode(response.responseText);	
   					console.log('mapData',mapData);
   					var lat = mapData.lat;
   					var lng = mapData.longs;
   					var location = mapData.location;
   					var vehicleNo = mapData.vehicleNo;
   					var mapwin;
   					if(!mapwin){
   						mapwin = new Ext.Window({
   							title: getTransportTranslation('VIEW_VEHICLE_LOCATION_STATUS'),
   							width:'60%',
   							height:'60%',
   							layout: 'fit',
   							modal:true,
   							border: false,
   							style:{margin:'0!important'}, 
   							items: {
   								xtype: 'gmappanel',
   								zoomLevel: 14,
   								gmapType : 'map',
   								center: {
   									geoCodeAddr: location,
   								    //lat: lat,
                                   // lng: lng,
   									marker: {
   										title: vehicleNo
   									}
   								},
   								mapOptions : {
   									mapTypeId: google.maps.MapTypeId.HYBRID
   								},
   							 markers: [{
   								  lat: lat,
                                  lng: lng,
   		                          title: 'Rajkumar Patidar',
   		                        listeners: {
   		                            click: function(e){
   		                                Ext.Msg.alert('RichmondRichmond Police Station');
   		                            }
   		                        }
   		                    }]
   							}
   						});
   					}
   					mapwin.show();
   				}
   			}
   		});
   	},
   	
   	getRenderLicenceRegistrationDetailHistory : function(grid){
   		var this$ = this;
   		var structure = this$.getLicencehistorystructure();
        var vehicleList = this$.getVehicleList();
        var record = vehicleList.getSelectionModel().getSelection()[0];
        structure.down("#vehicleCode").setValue(record.get("vehicleCode"));
        structure.down("#vehicleType").setValue(record.get("vehicleSubTypeName"));
        structure.down("#vehicleNo").setValue(record.get("vehicleNumber"));
        structure.down("#vehicleId").setValue(record.get("id"));
   		var store = grid.getStore();
   	    store.getProxy().extraParams = {
   			vehicleNumber : record.get("vehicleNumber"),
   			vehicleId : record.get("id")
   		};
   	    store.sorters.clear();
   	    store.load();
   	},
   	
   	getRenderFuelConsumption : function(grid){
   		var this$ = this;
   		var structure = this$.getFuelconsumptionstructure();
        var vehicleList = this$.getVehicleList();
        var record = vehicleList.getSelectionModel().getSelection()[0];
        structure.down("#vehicleCode").setValue(record.get("vehicleCode"));
        structure.down("#vehicleType").setValue(record.get("vehicleSubTypeName"));
        structure.down("#vehicleNo").setValue(record.get("vehicleNumber"));
        structure.down("#vehicleId").setValue(record.get("id"));
        var store = grid.getStore();
   	    store.getProxy().extraParams = {
   			vehicleId : record.get("id")
   		};
   	    store.sorters.clear();
   	    store.load();
   	},
   	
   	getRenderServiceHistory : function(grid){
   		var this$ = this;
   		var structure = this$.getServicehistoryforvehiclestructure();
        var vehicleList = this$.getVehicleList();
        var record = vehicleList.getSelectionModel().getSelection()[0];
        structure.down("#vehicleCode").setValue(record.get("vehicleCode"));
        structure.down("#vehicleType").setValue(record.get("vehicleSubTypeName"));
        structure.down("#vehicleNo").setValue(record.get("vehicleNumber"));
        structure.down("#vehicleId").setValue(record.get("id"));
        var store = grid.getStore();
   	    store.getProxy().extraParams = {
   			vehicleId : record.get("id")
   		};
   	    store.sorters.clear();
   	    store.load();
   	},
   	getRenderInstrumentHistory : function(grid){
   		var this$ = this;
   		var structure = this$.getInsuranceHistoryStructure();
        var vehicleList = this$.getVehicleList();
        var record = vehicleList.getSelectionModel().getSelection()[0];
        structure.down("#vehicleCode").setValue(record.get("vehicleCode"));
        structure.down("#vehicleType").setValue(record.get("vehicleSubTypeName"));
        structure.down("#vehicleNo").setValue(record.get("vehicleNumber"));
        structure.down("#vehicleId").setValue(record.get("id"));
   		var store = grid.getStore();
   	    store.getProxy().extraParams = {
   			vehicleNumber : record.get("vehicleNumber"),
   			vehicleId : record.get("id")
   		};
   	    store.sorters.clear();
   	    store.load();
   	},
   	getRenderEmissionHistory : function(grid){
   		var this$ = this;
   		var structure = this$.getEmissionHistoryStructure();
        var vehicleList = this$.getVehicleList();
        var record = vehicleList.getSelectionModel().getSelection()[0];
        structure.down("#vehicleCode").setValue(record.get("vehicleCode"));
        structure.down("#vehicleType").setValue(record.get("vehicleSubTypeName"));
        structure.down("#vehicleNo").setValue(record.get("vehicleNumber"));
        structure.down("#vehicleId").setValue(record.get("id"));
   		var store = grid.getStore();
   	    store.getProxy().extraParams = {
   			vehicleNumber : record.get("vehicleNumber"),
   			vehicleId : record.get("id")
   		};
   	    store.sorters.clear();
   	    store.load();
   	},
   	getRoadTaxEmissionHistory : function(grid){
   		var this$ = this;
   		var structure = this$.getRoadTaxHistoryStructure();
        var vehicleList = this$.getVehicleList();
        var record = vehicleList.getSelectionModel().getSelection()[0];
        structure.down("#vehicleCode").setValue(record.get("vehicleCode"));
        structure.down("#vehicleType").setValue(record.get("vehicleSubTypeName"));
        structure.down("#vehicleNo").setValue(record.get("vehicleNumber"));
        structure.down("#vehicleId").setValue(record.get("id"));
   		var store = grid.getStore();
   	    store.getProxy().extraParams = {
   			vehicleNumber : record.get("vehicleNumber"),
   			vehicleId : record.get("id")
   		};
   	    store.sorters.clear();
   	    store.load();
   	},
 	getJourneyAssignmentDetails : function(grid){
   		var this$ = this;
   		var structure = this$.getJourneyAssignmentStructure();
        var vehicleList = this$.getVehicleList();
        var record = vehicleList.getSelectionModel().getSelection()[0];
        structure.down("#vehicleCode").setValue(record.get("vehicleCode"));
        structure.down("#vehicleType").setValue(record.get("vehicleSubTypeName"));
        structure.down("#vehicleNo").setValue(record.get("vehicleNumber"));
        structure.down("#vehicleId").setValue(record.get("id"));
        
        var fromDate = Ext.Date.add (new Date(),Ext.Date.DAY,-3);
        var tillDate = Ext.Date.add (new Date(),Ext.Date.DAY,3);
        var transServiceRouteUserId=null;
        
        structure.down("#startDate").setValue(fromDate);
        structure.down("#tillDate").setValue(tillDate);
        
        if(fromDate != null){
            fromDate= new Date(fromDate);
            fromDate = Ext.Date.format(fromDate, 'Y-m-d');
           }
        
        if(tillDate != null){
            tillDate= new Date(tillDate);
            tillDate = Ext.Date.format(tillDate, 'Y-m-d');
           }
        
        var store = grid.getStore();
   	    store.getProxy().extraParams = {
   			vehicleId : record.get("id"),
   			fromDate : fromDate,
   			tillDate : tillDate,
   			transServiceRouteUserId : transServiceRouteUserId
   		};
   	    store.sorters.clear();
   	    store.load();
        
   	},
   	getSearchJourneyAssignment : function(obj){
   		var form = obj.up('form');
   		var fromDate =  form.down("#startDate").getValue();
        var tillDate = form.down("#tillDate").getValue();
        var transServiceRouteUserId = form.down("#transServiceRouteUserId").getValue();
        
        var vehicleList = this.getVehicleList();
        var record = vehicleList.getSelectionModel().getSelection()[0];

		if (fromDate != null) {
			fromDate = new Date(fromDate);
			fromDate = Ext.Date.format(fromDate, 'Y-m-d');
		}

		if (tillDate != null) {
			tillDate = new Date(tillDate);
			tillDate = Ext.Date.format(tillDate, 'Y-m-d');
		}
       
        var grid = form.down("#journeyassignmentlist");
        var store = grid.getStore();
   	    store.getProxy().extraParams = {
   			vehicleId : record.get("id"),
   			fromDate : fromDate,
   			tillDate : tillDate,
   			transServiceRouteUserId : transServiceRouteUserId
   		};
   	    store.sorters.clear();
   	    store.load();
   	},
   	getResetJourneyAssignment : function(obj){
   		var form = obj.up('form');
   		form.down("#transServiceRouteUserId").reset();
   	},
   	
   	/**
   	 * it will provide id value pair format
   	 */
       getIdValueJson: function(id, value) {
   		if (id) return {
   			id: id,
   			value: value
   		};
   	},
   	
	/**
   	 * get open Licence detail window
   	 */
   	getShowLicenceHistoryWin:function(){
   		var frmWin = this.getLicencehistorydetailwin();
   		if(!frmWin){
   			Ext.widget('licencehistorydetailwin');
   			frmWin = this.getLicencehistorydetailwin();
   		}
   		frmWin.show();
   	},
   	getCloseLicenceHistoryWin : function(){
   		this.getLicencehistorydetailwin().close();
   	},
   	
   	/**
   	 * get open insurance detail window
   	 */
   	getShowInsuranceHistoryWin:function(){
   		var frmWin = this.getInsuranceHistoryDetailwin();
   		if(!frmWin){
   			Ext.widget('insurancehistorydetailwin');
   			frmWin = this.getInsuranceHistoryDetailwin();
   		}
   		frmWin.show();
   	},
   	getCloseInsuranceHistoryWin : function(){
   		this.getInsuranceHistoryDetailwin().close();
   	},

   	/**
   	 * get open emission detail window
   	 */
   	getShowEmissionHistoryWin:function(){
   		var frmWin = this.getEmissionHistoryDetailwin();
   		if(!frmWin){
   			Ext.widget('emissionhistorydetailwin');
   			frmWin = this.getEmissionHistoryDetailwin();
   		}
   		frmWin.show();
   	},
   	getCloseEmissionHistoryWin : function(){
   		this.getEmissionHistoryDetailwin().close();
   	},
   	/**
   	 * get open emission detail window
   	 */
   	getShowRoadTaxHistoryWin:function(){
   		var frmWin = this.getRoadTaxHistoryDetailwin();
   		if(!frmWin){
   			Ext.widget('roadtaxhistorydetailwin');
   			frmWin = this.getRoadTaxHistoryDetailwin();
   		}
   		frmWin.show();
   	},
   	getCloseRoadTaxHistoryWin : function(){
   		this.getRoadTaxHistoryDetailwin().close();
   	},
   	getShowserviceHistoryWin:function(){
   		var frmWin = this.getServicehistorydetailwin();
   		if(!frmWin){
   			Ext.widget('servicehistorydetailwin');
   			frmWin = this.getServicehistorydetailwin();
   		}
   		frmWin.show();
   	},
   	getShowFuelConsumptionWin:function(){
   		var frmWin = this.getFuelconsumptiondetailwin();
   		if(!frmWin){
   			Ext.widget('fuelconsumptiondetailwin');
   			frmWin = this.getFuelconsumptiondetailwin();
   		}
   		frmWin.show();
   	},
   	getCloseFuelConsumptionWin : function(){
   		this.getFuelconsumptiondetailwin().close();
   	},
   	getSaveFuelConsumptionDetail : function(){
   		var this$ = this;
   		var grid = this$.getFuelconsumptiongrid();
   		var gridStore = grid.getStore();
   		var win = this$.getFuelconsumptiondetailwin();
   		var form = win.down('form');
   		var values = form.getForm().getValues();
   		if(isNullOrEmpty(values.refillDate)) {
   			values.refillDate = form.down('#refillDateId').getValue();
   		}
   		if(isNullOrEmpty(values.odometerReading)) {
   			values.odometerReading = form.down('#odometerReading').getValue();
   		}
   		var structure = this$.getFuelconsumptionstructure();
   		var vehicleId = structure.down("#vehicleId").getValue();
   		var record = grid.getSelectionModel().getSelection()[0];
   		var fuelConsumptionModel = new Academia.model.transport.vehicle.FuelConsumptionGridDataModel();
   		fuelConsumptionModel.set("id",values.id);
   		fuelConsumptionModel.set("vehicle",this$.getIdValueJson(vehicleId));
   		fuelConsumptionModel.set("refillDate",values.refillDate);
   		fuelConsumptionModel.set("amount",values.amount);
   		fuelConsumptionModel.set("odometerReading",values.odometerReading);
   		fuelConsumptionModel.set("approximateAvailableFuel",values.approximateAvailableFuel);
   		fuelConsumptionModel.set("currentRefill",values.currentRefill);
   		fuelConsumptionModel.set("refillBy",values.refillBy);
   		fuelConsumptionModel.set("refillStation",values.refillStation);
   		fuelConsumptionModel.set("totalFuel",values.totalFuel);
   		fuelConsumptionModel.set("fuelConsumptionAverage",values.fuelConsumptionAverage);

   		var submitUrl = SERVERURL.VEHICLE_FUEL_CONSUMPTION_CREATE; 

   		var id = values.id;
   		if(!isNullOrEmpty(values.id)) {
   			submitUrl = SERVERURL.VEHICLE_FUEL_CONSUMPTION_UPDATE;
   		}
   		var submitData = Ext.encode(fuelConsumptionModel.data);
   		this$.applyWindowMask(); 

   		Ext.Ajax.request({
   			url: submitUrl,
   			jsonData: submitData,
   			method: 'POST',
   			success: function(response) {
   				this$.hideWindowMask();
   				this$.getCloseFuelConsumptionWin();
   				gridStore.reload();
   				grid.getSelectionModel().deselectAll(true);
   				if(!isNullOrEmpty(id)) {
   					showSuccessMessage(getTransportTranslation('FUEL_CONSUMPTION_DETAIL'),getTransportTranslation('FUEL_CONSUMPTION_UPDATED_SUCCESSFULLY'));
   				} else {
   					showSuccessMessage(getTransportTranslation('FUEL_CONSUMPTION_DETAIL'),getTransportTranslation('FUEL_CONSUMPTION_CREATED_SUCCESSFULLY'));
   				}
   			}
   		});
   	},
   	
	getEditFuelConsumption : function(){
   		var this$ = this;
   		var grid = this$.getFuelconsumptiongrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		this$.getShowFuelConsumptionWin();
    		var win = this$.getFuelconsumptiondetailwin();
       		var form = win.down('form');
    		var record = grid.getSelectionModel().getSelection()[0];
    		var id = record.get("id");
    		form.down("#odometerReading").setDisabled(true);
    		form.down("#refillDateId").setDisabled(true);
    		
    		if(!isNullOrEmpty(record.data.refillDate))
    			record.data.refillDate = new Date(record.data.refillDate);
		
			var fuelConsumptionModel = new Academia.model.transport.vehicle.FuelConsumptionGridDataModel(record.data);
			form.loadRecord(fuelConsumptionModel);
    		}else{
    			 showWarningMessage(getTransportTranslation('FUEL_CONSUMPTION_DETAIL'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    		}
   	},
	getViewFuelConsumption : function(){
   		this.getEditFuelConsumption();
 		var win = this.getFuelconsumptiondetailwin();
 		if (win) {
 			var form = win.down('form');
 			form.down('#SubmitBtnFuelConsumption').setVisible(false);
 			form = form.getForm();
 			toggleReadOnlyFormItems(form,true);
 			win.doLayout()
 		}
   	},
   	getCloseServiceHistoryWin : function(){
   		this.getServicehistorydetailwin().close();
   	},
   	getDeleteFuelConsumption: function(){
        var this$ = this;
        var grid = this$.getFuelconsumptiongrid();
    	var grdStore = grid.getStore();
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getTransportTranslation('FUEL_CONSUMPTION_DETAIL'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
    			if (btn == 'yes') {
					var records = grid.getSelectionModel().getSelection();
					var id = records[0].data.id;
					Ext.Ajax.request({
						type: 'rest',
						method: 'DELETE',
						url: SERVERURL.VEHICLE_FUEL_CONSUMPTION_DELETE,
						headers: {
							'Content-Type': 'application/json'
						},
						params: {
							id: id
						},
						success: function(form, action) {
							if (form.responseText == 0) {
								showWarningMessage(getTransportTranslation('FUEL_CONSUMPTION_DETAIL'), getTransportTranslation('FUEL_CONSUMPTION_DETAIL_DEPENDENCY_EXIST_ON_DELETE'));
							} else {
								showSuccessMessage(getTransportTranslation('FUEL_CONSUMPTION_DETAIL'), getTransportTranslation('FUEL_CONSUMPTION_DETAIL_DELETE_MSG'));
								this$.resetPageSetting(grdStore);
								grdStore.reload();
							}
						},
						failure: function(form, action) {
							showWarningMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
						}
					});
				}
    		});
    	} else {
    		showWarningMessage(getTransportTranslation('FUEL_CONSUMPTION_DETAIL'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    getSaveServiceHistoryDetail : function(){
   		var this$ = this;
   		var grid = this$.getServicehistorygrid();
   		var gridStore = grid.getStore();
   		var win = this$.getServicehistorydetailwin();
   		var form = win.down('form');
   		var values = form.getForm().getValues();

   		var structure = this$.getServicehistoryforvehiclestructure();
   		var vehicleId = structure.down("#vehicleId").getValue();
   		var record = grid.getSelectionModel().getSelection()[0];
   		var serviceHistoryModel = new Academia.model.transport.vehicle.ServiceHistoryGridDataModel();
   		serviceHistoryModel.set("id",values.id);
   		serviceHistoryModel.set("vehicle",this$.getIdValueJson(vehicleId));
   		serviceHistoryModel.set("serviceDate",values.serviceDate);
   		serviceHistoryModel.set("amount",values.amount);
   		serviceHistoryModel.set("odometerReading",values.odometerReading);
   		serviceHistoryModel.set("nextServiceDueDate",values.nextServiceDueDate);
   		serviceHistoryModel.set("servicedBy",values.servicedBy);
   		serviceHistoryModel.set("remark",values.remark);
   		serviceHistoryModel.set("user",this$.getIdValueJson(values.person));
   		
   		var submitUrl = SERVERURL.VEHICLE_SERVICE_HISTORY_CREATE; 

   		var id = values.id;
   		if(!isNullOrEmpty(values.id)) {
   			submitUrl = SERVERURL.VEHICLE_SERVICE_HISTORY_UPDATE;
   		}
   		var submitData = Ext.encode(serviceHistoryModel.data);
   		this$.applyWindowMask(); 

   		Ext.Ajax.request({
   			url: submitUrl,
   			jsonData: submitData,
   			method: 'POST',
   			success: function(response) {
   				this$.hideWindowMask();
   				this$.getCloseServiceHistoryWin();
   				gridStore.reload();
   				grid.getSelectionModel().deselectAll(true);
   				if(!isNullOrEmpty(id)) {
   					showSuccessMessage(getPersonModuleTranslation('SERVICE_HISTORY'),getCommonTranslation('RECORD_UPDATE_SUCCESS'));
   				} else {
   					showSuccessMessage(getPersonModuleTranslation('SERVICE_HISTORY'),getCommonTranslation('RECORD_ADD_SUCCESS'));
   				}
   			}
   		});
   	},
	getEditServiceHistory : function(){
   		var this$ = this;
   		var grid = this$.getServicehistorygrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		this$.getShowserviceHistoryWin();
    		var win = this$.getServicehistorydetailwin();
       		var form = win.down('form');
    		var record = grid.getSelectionModel().getSelection()[0];
    		var id = record.get("id");
    		if(!isNullOrEmpty(record.data.person))
    			{
    			record.data.person.code=record.data.code;
    			record.data.person.value=record.data.printName;
    			
    			}
    			
    		 form.down("#person").setValue(record.data.person);
    		if(!isNullOrEmpty(record.data.serviceDate))
    			record.data.serviceDate = new Date(record.data.serviceDate);
		
    		if(!isNullOrEmpty(record.data.nextServiceDueDate))
    			record.data.nextServiceDueDate = new Date(record.data.nextServiceDueDate);
    		
			var ServiceHistoryModel = new Academia.model.transport.vehicle.ServiceHistoryGridDataModel(record.data);
			form.loadRecord(ServiceHistoryModel);
			var transportcharger=form.down("#person");
			transportcharger.getStore().load({
					callback : function(rec,operation,success){
						transportcharger.setValue(record.data.userId);		      							
					}
				});
    		}else{
    			 showWarningMessage(getPersonModuleTranslation('SERVICE_HISTORY'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    		}
   	},
   	getViewServiceHistory : function(){
   		this.getEditServiceHistory();
 		var win = this.getServicehistorydetailwin();
 		if (win) {
 			var form = win.down('form');
 			form.down('#SubmitBtnServiceHistory').setVisible(false);
 			form = form.getForm();
 			toggleReadOnlyFormItems(form,true);
 			win.doLayout()
 		}
   	},
	/**
   	 * save insurance history detail
   	 */
   	getSaveInsuranceHistory : function(){
   		var this$ = this;
   		var grid = this$.getInsuranceHistoryList();
   		var gridStore = grid.getStore();
   		var form = this$.getInsuranceHistoryDetailWin();
   		var values = form.getForm().getValues();
   		
   		var structure = this$.getInsuranceHistoryStructure();
        var vehicleId = structure.down("#vehicleId").getValue();
        var record = grid.getSelectionModel().getSelection()[0];
   		var insurancModel = new Academia.model.transport.vehicle.InsuranceHistorySubmitData();
   		insurancModel.set("id",values.id);
   		insurancModel.set("vehicle",this$.getIdValueJson(vehicleId));
   		insurancModel.set("currencyId",values.insuranceCurrency);
   		insurancModel.set("insuranceVendor",values.insuredBy);
   		insurancModel.set("policyNumber",values.policyNumber);
   		insurancModel.set("validFrom",values.validFrom);
   		insurancModel.set("validTill",values.validTill);
   		insurancModel.set("insurancePolicyWith",values.insurancePolicyWith);
   		insurancModel.set("insuranceCost",values.insuranceCost);
   		insurancModel.set("policyHolderName",values.policyHolderName);
   		insurancModel.set("inceptionDate",values.inceptionDate);
   		insurancModel.set("premiumPaymentCycle",values.premiumPaymentCycle);
   		insurancModel.set("brokerMobileCountryCode",values.brokerMobileCountryCode);
   		insurancModel.set("brokerMobileNumber",values.brokerMobileNumber);
   		   		
        var submitUrl = SERVERURL.VEHICLE_INSURANCE_HISTORY_CREATE; 
        
        var id = values.id;
        if(!isNullOrEmpty(values.id)) {
          insurancModel.set("insuranceAlertBeforeNdays",record.raw.insuranceAlertBeforeNdays);
          insurancModel.set("insurancePaidOn",record.data.insurancePaidOn);
          insurancModel.set("addressId",record.data.addressId);
          submitUrl = SERVERURL.VEHICLE_INSURANCE_HISTORY_UPDATE;
        }
        var submitData = Ext.encode(insurancModel.data);
        this$.applyWindowMask(); 
        
		Ext.Ajax.request({
			url: submitUrl,
			jsonData: submitData,
			method: 'POST',
			success: function(response) {
				this$.hideWindowMask();
				this$.getCloseInsuranceHistoryWin();
				gridStore.reload();
				grid.getSelectionModel().deselectAll(true);
				if(!isNullOrEmpty(id)) {
   					showSuccessMessage(getTransportTranslation('INSURANCE_DETAILS'),getTransportTranslation('INSURANCE_HISTORY_UPDATED_SUCCESSFULLY'));
   				} else {
   					showSuccessMessage(getTransportTranslation('INSURANCE_DETAILS'),getTransportTranslation('INSURANCE_HISTORY_CREATED_SUCCESSFULLY'));
   				}
			}
   	});
   	},
	/**
   	 * view emission history detail
   	 */
   	getEditInsuranceHistory : function(){
   		var this$ = this;
   		var grid = this$.getInsuranceHistoryList();
    	
    	if (grid.getSelectionModel().getCount() > 0) {
    		this$.getShowInsuranceHistoryWin();
    		var form = this$.getInsuranceHistoryDetailWin();
    		var record = grid.getSelectionModel().getSelection()[0];
    		var id = record.get("id");
    		var editUrl = SERVERURL.VEHICLE_INSURANCE_HISTORY_FIND_BY_ID;
    		this$.applyWindowMask(); 
    		  
    		Ext.Ajax.request({
    			method: "GET",
    			type: 'rest',
    			url: editUrl,
    			params: {
    				vehicleInsuranceDetailId: id
    			},
    			success: function(f, action) {
    				this$.hideWindowMask();
    				var data = Ext.JSON.decode(f.responseText);
    				if(!isNullOrEmpty(data.insurancePaidOn))
    					data.insurancePaidOn = new Date(data.insurancePaidOn);
    				if(!isNullOrEmpty(data.validFrom))
    					data.validFrom = new Date(data.validFrom);
    				if(!isNullOrEmpty(data.validTill))
    					data.validTill = new Date(data.validTill);
    				if(!isNullOrEmpty(data.inceptionDate))
    					data.inceptionDate = new Date(data.inceptionDate);
    				
    				var insuranceHistoryModel = new Academia.model.transport.vehicle.InsuranceHistoryGridData(data);
    				form.loadRecord(insuranceHistoryModel);
    				form.down("#insuredBy").setValue(data.insuranceVendor);
    				var currency = form.down("#insuranceCurrency");
    				currency.getStore().load({
    					callback : function(rec,operation,success){
    						currency.setValue(data.currencyId);
    					}
    				});
    				form.down('#premiumPaymentCycle').setValue(data.premiumPaymentCycle);
    				form.down('#brokerMobileNumber').setValue(data.brokerMobileNumber);
    				var countryCode = form.down('#brokerMobileCountryCode');
    				countryCode.getStore().load({
    					callback : function(rec,operation,success){
    						countryCode.setValue(data.brokerMobileCountryCode);
    					}
    				});
    			}
    		 });
    		}else{
    			this$.hideWindowMask();
    			 showWarningMessage(getTransportTranslation('INSURANCE_DETAIL'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    		}
   	},
   	/**
   	 * view insurance history detail
   	 */
   	getViewInsuranceHistory : function(){
   		this.getEditInsuranceHistory();
 		var form =this.getInsuranceHistoryDetailWin();
 		if (form) {
 			form.down('#SubmitBtn').setVisible(false);
 			form = form.getForm();
 		    toggleReadOnlyFormItems(form,true);
 		}
   	},
   	/**
   	 * edit emission history details
   	 */
	getEditEmissionHistory : function(){
   		var this$ = this;
   		var grid = this$.getEmissionHistoryList();
    	
    	if (grid.getSelectionModel().getCount() > 0) {
    		this$.getShowEmissionHistoryWin();
    		var form = this$.getEmissionHistoryDetailWin();
    		var record = grid.getSelectionModel().getSelection()[0];
    		var id = record.get("id");
    		var editUrl = SERVERURL.VEHICLE_EMISSION_HISTORY_FIND_BY_ID;
    		Ext.Ajax.request({
    			method: "GET",
    			type: 'rest',
    			url: editUrl,
    			params: {
    				vehicleEmissionDetailId: id
    			},
    			success: function(f, action) {
    				var data = Ext.JSON.decode(f.responseText);
    				if(!isNullOrEmpty(data.emissionCheckOn))
    					data.emissionCheckOn = new Date(data.emissionCheckOn);
    				if(!isNullOrEmpty(data.emissionToBeCheckOn))
    					data.emissionToBeCheckOn = new Date(data.emissionToBeCheckOn);
    				var insuranceHistoryModel = new Academia.model.transport.vehicle.InsuranceHistoryGridData(data);
    				var emissionHistoryModel = new Academia.model.transport.vehicle.EmissionHistoryGridData(data);
    				form.loadRecord(emissionHistoryModel);
    				form.down("#emissionCheckDate").setValue(data.emissionCheckOn);
    				form.down("#emissionToBeCheckOn").setValue(data.emissionToBeCheckOn);
    				var currency = form.down("#emissionCurrency");
    				currency.getStore().load({
    					callback : function(rec,operation,success){
    						currency.setValue(data.currencyId);
    					}
    				});
    			}
    		 });
    		}else{
    			 showWarningMessage(getTransportTranslation('EMISSION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    		}
   	},
   	/**
   	 * view emission history details
   	 */
   	getViewEmissionHistory : function(){
   		this.getEditEmissionHistory();
 		var form =this.getEmissionHistoryDetailWin();
 		if (form) {
 			form.down('#SubmitBtn').setVisible(false);
 			form = form.getForm();
 		    toggleReadOnlyFormItems(form,true);
 		}
   	},
   	/**
   	 * save emission history details
   	 */
   	getSaveEmissionHistory : function(){
   		var this$ = this;
   		var grid = this$.getEmissionHistoryList();
   		var gridStore = grid.getStore();
   		var form = this$.getEmissionHistoryDetailWin();
   		var values = form.getForm().getValues();

   		var structure = this$.getEmissionHistoryStructure();
   		var vehicleId = structure.down("#vehicleId").getValue();
   		var record = grid.getSelectionModel().getSelection()[0];
   		
   		var emissionModel = new Academia.model.transport.vehicle.EmissionHistorySubmitData();
   		emissionModel.set("id",values.id);
   		emissionModel.set("vehicle",this$.getIdValueJson(vehicleId));
   		emissionModel.set("currencyId",values.emissionCurrency);
   		emissionModel.set("emissionVendor",values.emissionVendor);
   		emissionModel.set("emissionCheckOn",values.emissionCheckDate);
   		emissionModel.set("emissionToBeCheckOn",values.emissionToBeCheckOn);
   		emissionModel.set("emissionCost",values.emissionCost);
   		emissionModel.set("emissionPolicyWith",values.emissionPolicyWith);
   		
   		var submitUrl = SERVERURL.VEHICLE_EMISSION_HISTORY_CREATE; 
   		
   		var id = values.id
   		if(!isNullOrEmpty(values.id)) {
   			emissionModel.set("addressId",record.data.addressId);
   	   		emissionModel.set("emissionAlertBeforeNdays",record.raw.emissionAlertBeforeNdays);
            submitUrl = SERVERURL.VEHICLE_EMISSION_HISTORY_UPDATE;
          }
   		var submitData = Ext.encode(emissionModel.data);
   		this$.applyWindowMask(); 
   	  
   		Ext.Ajax.request({
   			url: submitUrl,
   			jsonData: submitData,
   			method: 'POST',
   			success: function(response) {
   				this$.hideWindowMask();
   				this$.getCloseEmissionHistoryWin();
   				gridStore.reload();
   				grid.getSelectionModel().deselectAll(true);
   				if(!isNullOrEmpty(id)) {
   					showSuccessMessage(getTransportTranslation('EMISSION_DETAILS'),getTransportTranslation('EMISSION_HISTORY_UPDATED_SUCCESSFULLY'));
   				} else {
   					showSuccessMessage(getTransportTranslation('EMISSION_DETAILS'),getTransportTranslation('EMISSION_HISTORY_CREATED_SUCCESSFULLY'));
   				}
   			}
   		});
   	},
   	
   	/**
   	 * save road tax history detail
   	 */
   	getSaveRoadTaxHistory : function(){
   		var this$ = this;
   		var grid = this$.getRoadTaxHistoryList();
   		var gridStore = grid.getStore();
   		var form = this$.getRoadTaxHistoryDetailWin();
   		var values = form.getForm().getValues();
   		
   		var structure = this$.getRoadTaxHistoryStructure();
        var vehicleId = structure.down("#vehicleId").getValue();
        var record = grid.getSelectionModel().getSelection()[0];
        
   		var roadTaxModel = new Academia.model.transport.vehicle.RoadTaxHistorySubmitData();
   		roadTaxModel.set("id",values.id);
   		roadTaxModel.set("vehicle",this$.getIdValueJson(vehicleId));
   		roadTaxModel.set("currencyId",values.roadTaxCurrency);
   		roadTaxModel.set("validFrom",values.validFrom);
   		roadTaxModel.set("validTill",values.validTill);
   		roadTaxModel.set("roadTaxCost",values.roadTaxCost);
   		roadTaxModel.set("roadTaxPaidOn",values.roadTaxPaidOn);
   		roadTaxModel.set("roadTaxVendor",values.roadTaxVendor);
   		roadTaxModel.set("roadTaxWith",values.roadTaxWith);

   		var submitUrl = SERVERURL.VEHICLE_ROAD_TAX_HISTORY_CREATE; 
        var id = values.id
   		if(!isNullOrEmpty(values.id)) {
   			roadTaxModel.set("addressId",record.data.addressId);
   			roadTaxModel.set("roadTaxAlertBeforeNdays",record.raw.roadTaxAlertBeforeNdays);
            submitUrl = SERVERURL.VEHICLE_ROAD_TAX_HISTORY_UPDATE;
          }
        var submitData = Ext.encode(roadTaxModel.data);
        this$.applyWindowMask(); 
      
		Ext.Ajax.request({
			url: submitUrl,
			jsonData: submitData,
			method: 'POST',
			success: function(response) {
				  this$.hideWindowMask();
				this$.getCloseRoadTaxHistoryWin();
				gridStore.reload();
				grid.getSelectionModel().deselectAll(true);
   				if(!isNullOrEmpty(id)) {
   					showSuccessMessage(getTransportTranslation('ROAD_TAX_DETAILS'),getTransportTranslation('ROAD_TAX_HISTORY_UPDATED_SUCCESSFULLY'));
   				} else {
   					showSuccessMessage(getTransportTranslation('ROAD_TAX_DETAILS'),getTransportTranslation('ROAD_TAX_HISTORY_CREATED_SUCCESSFULLY'));
   				}
			}
   	});
   	},
	/**
   	 * view emission history detail
   	 */
   	getEditRoadTaxHistory : function(){
   		var this$ = this;
   		var grid = this$.getRoadTaxHistoryList();
    	
    	if (grid.getSelectionModel().getCount() > 0) {
    		this$.getShowRoadTaxHistoryWin();
    		var form = this$.getRoadTaxHistoryDetailWin();
    		var record = grid.getSelectionModel().getSelection()[0];
    		var id = record.get("id");
    		var editUrl = SERVERURL.VEHICLE_ROAD_TAX_HISTORY_FIND_BY_ID;
    		Ext.Ajax.request({
    			method: "GET",
    			type: 'rest',
    			url: editUrl,
    			params: {
    				vehicleRoadTaxDetailId: id
    			},
    			success: function(f, action) {
    				var data = Ext.JSON.decode(f.responseText);
    				if(!isNullOrEmpty(data.roadTaxPaidOn))
    					data.roadTaxPaidOn = new Date(data.roadTaxPaidOn);
    				if(!isNullOrEmpty(data.validFrom))
    					data.validFrom = new Date(data.validFrom);
    				if(!isNullOrEmpty(data.validTill))
    					data.validTill = new Date(data.validTill);
    				var roadTaxHistoryModel = new Academia.model.transport.vehicle.RoadTaxHistoryGridData(data);
    				form.loadRecord(roadTaxHistoryModel);
    				var currency = form.down("#roadTaxCurrency");
    				currency.getStore().load({
    					callback : function(rec,operation,success){
    						currency.setValue(data.currencyId);
    					}
    				});
    			}
    		 });
    		}else{
    			 showWarningMessage(getTransportTranslation('ROAD_TAX_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    		}
   	},
   	/**
   	 * view road Tax history detail
   	 */
   	getViewRoadTaxHistory : function(){
   		this.getEditRoadTaxHistory();
 		var form =this.getRoadTaxHistoryDetailWin();
 		if (form) {
 			form.down('#SubmitBtn').setVisible(false);
 			form = form.getForm();
 		    toggleReadOnlyFormItems(form,true);
 		}
   	},
   	/**
   	 * vehicle details will soft delete here
   	 */
   	getDeleteVehicleDetail : function(){
   		var this$ = this;
   		var grid = this$.getVehicleList();
   		var gridStore = grid.getStore();
   		if (grid.getSelectionModel().getCount() > 0) {
   			showConfirmMessage(getTransportTranslation('VEHICLE_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
   				if (btn == 'yes') {
   					var deleteurl = SERVERURL.VEHICLE_DETAILS_DELETE;
   					var records = grid.getSelectionModel().getSelection();
   					var id = records[0].get("id");
   					Ext.Ajax.request({
   						method: "DELETE",
   						type: 'rest',
   						url: deleteurl+'?id='+id,
   						headers: {
   							'Content-Type': 'application/json'
   						},
   						success: function(form, action) {
   							gridStore.reload();
   							showSuccessMessage(getTransportTranslation('VEHICLE_DETAILS'), getTransportTranslation('VEHICLE_DETAILS_DELETED_SUCCESSFULLY'));
   						}
   					});
   				}
   			});
   		} else {
   			showWarningMessage(getTransportTranslation('VEHICLE_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
   		}
   	},
   	getCommonAddressDetails :function(buttonId,addressId){
   		var this$ = this;

   		var addressWindowItemId ="vehicleAddressFormWindow";
   		var addressFormWindow = Ext.widget('addressformwindow', {
   			itemId: addressWindowItemId
   		});
   		addressFormWindow.show();

   		var addressDetailsform = addressFormWindow.down('#personAddressFieldsForm');
   		addressDetailsform.add(Ext.create("Ext.form.field.Text", {name:'addressButtonId',hidden: true})); //
   		var form = addressDetailsform.getForm();
   		form.findField('addressButtonId').setValue(buttonId);
   		var listButtonId = this$.getVehicleDetailForm().getForm().findField("listButtonId").getValue();
   		if(listButtonId=='btnView'){
   			addressFormWindow.down("#submitButtonId").setVisible(false);
   			toggleReadOnlyFormItems(form,true);
   		}

   		if(!isNullOrEmpty(addressId)) {

   			var url = SERVERURL.VEHICLE_ADDRESS_FIND_BY_ID;
   			if (!isNullOrEmpty(addressId)) {
   				var params = {
   						id : addressId	
   				}; 
   			 //this$.applyWindowMask(); 
   
   				this$.sendGetAjaxRequest(url, 'GET', params, function(option, success, response) {
   				  
   					if(success){
   						var data = Ext.decode(response.responseText);
   						form.setValues(data);
   						form.findField('addressText').setValue(data.addressText);
   						form.findField('phoneAreaCode').setValue(data.phoneAreaCode);
   						form.findField('phoneNo').setValue(data.phoneNo);
   						form.findField('cellNo').setValue(data.cellNo);
   						form.findField('primaryeEmailId').setValue(data.primaryeEmailId);
   						form.findField('alternateEmailId').setValue(data.alternateEmailId);

   						var country = form.findField('country');
   						var city = form.findField('city');
   						var parentCountryRegion = form.findField('parentCountryRegion');
   						var countryRegion = form.findField('countryRegion');

   						if(data.country){

   							country.getStore().load({
   								callback : function(rec,operation,success){
   									country.setValue(data.country.id);
   								}
   							});	

   							var cityStore = city.getStore();
   							cityStore.getProxy().extraParams = {
   								id: data.parentCountryRegion.id
   							};
   							cityStore.load({
   								callback : function(rec,operation,success){
   									city.setValue(data.city.id);
   								}
   							});

   							var pcrStore = parentCountryRegion.getStore();
   							pcrStore.getProxy().extraParams = {
   								cid:data.country.id
   							};
   							pcrStore.load({
   								callback : function(rec,operation,success){
   									parentCountryRegion.setValue(data.parentCountryRegion.id);
   								}
   							});

   							if(data.countryRegion){
   								var crStore = countryRegion.getStore();
   								crStore.getProxy().extraParams = {
   									pid:data.parentCountryRegion.id
   								};
   								crStore.load({
   									callback : function(rec,operation,success){
   										countryRegion.setValue(data.countryRegion.id);
   									}
   								});
   							}
   						}
   					}
   					//this$.hideWindowMask();
   				});
   			}
   		}
   	},
   	getDocumentController : function() {
   		var this$ = this;
   		return this$.getController('Academia.controller.document.DocumentController');
   	},
   	getUploadDocument : function(grid,moduleName,entityTypeName,createDocUrl,historyTypeParams){
   		var $this=this;
   		//var grid = this.getInsuranceHistoryList();
   		var isTransient = true;
   		var module = moduleName;
   		var entityId ;
   		var entityType = entityTypeName;
   		$this.applyWindowMask(); 
   		$this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient){
   			if (grid.getSelectionModel().getCount() > 0) {
   				var record = grid.getSelectionModel().getSelection()[0];
   				var id = record.get("id");
   				var docUrl = SERVERURL.DOCUMENT_FORM_SAVE;
   				var params = {
   						"createdBy": $this.getIdValueJson(response.createdBy.id),
   						"name": response.name,
   						"path": response.path,
   						"type": response.type
   				};	
   			};
   			
   			Ext.Ajax.request({
   				type : 'rest',
   				url : docUrl,
   				jsonData : params,
   				method : 'POST',
   				success : function(res, action) {
   					var documentId = Ext.JSON.decode(res.responseText);
   					var data;
   					switch (historyTypeParams) {
   					case 'INSURANCE':{
   						data ={
   								documentId : documentId,
   								vehicleInsuranceDetailId : id
   						};
   						break;
   					}
   					case 'EMISSION':{
   						data ={
   								documentId : documentId,
   								vehicleEmissionDetailId : id
   						};
   						break;
   					}
   					case 'ROADTAX':{
   						data ={
   								documentId : documentId,
   								vehicleRoadTaxDetailId : id
   						};
   						break;
   					}
   					case 'LICENCEREGISTRATION':{
   						data ={
   								documentId : documentId,
   								vehicleLicenseRegistrationDetailId : id
   						};
   						break;
   					}
   					}
   					Ext.Ajax.request({
   						type : 'rest',
   						url : createDocUrl,
   						jsonData : data,
   						method : 'POST',
   						success : function(res, action) {
   							$this.getDocumentController().closeDocumentFormWindow();
   							$this.hideWindowMask();
   							grid.getStore().reload();
   							grid.getSelectionModel().deselectAll(true);  
   							showSuccessMessage(getTransportTranslation('DOCUMENT'), getTransportTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
   						}
   					
   					});
   					
   				}
   			
   			});
   			
   		}, isTransient);
   	},
   	getCloseAddressDetail : function(){
   		this.getVehicleAddressFormWindow().close();
   	},
   	getSaveAddressDetail : function(){

   		var this$ = this;
   		var addressFormWindow = this.getVehicleAddressFormWindow();
   		var form = addressFormWindow.down('#personAddressFieldsForm');
   		var vehicleForm = this.getVehicleDetailForm();
   		var values = form.getValues();
   		
//   		if (this$.validatePhone(values)) {
   			var address = new Academia.model.organization.Address();

   			address.set('version', values.version);
   			address.set('addressText', values.addressText);
   			address.set('country', this.getIdValueJson(values.country));
   			address.set('parentCountryRegion', this$.getIdValueJson(values.parentCountryRegion));
   			address.set('countryRegion', this$.getIdValueJson(values.countryRegion));
   			address.set('city', this$.getIdValueJson(values.city));
   			address.set('pincode', values.pincode);
   			address.set('cellCountryCode',values.cellCountryCode);
   			address.set('cellNo', values.cellNo);
   			address.set('phoneCountryCode', values.phoneCountryCode);
   			address.set('phoneAreaCode', values.phoneAreaCode);
   			address.set('phoneNo', values.phoneNo);
   			address.set('primaryeEmailId', values.primaryeEmailId);
   			address.set('alternateEmailId', values.alternateEmailId);
   			address.set('addressType', null);
   			if(values.customData!=undefined && values.customData!=null){
   			address.set('customData', values.customData);
   			}else{
   				address.set('customData', []);
   			}
   			var submitUrl;
   			var message;
   			if (values.id == null || values.id == "") {
   				submitUrl = SERVERURL.VEHICLE_ADDRESS_CREATE;
   				message = getCommonTranslation('ADDRESS_ADD_SUCCESS');
   			} else {
   				address.set('id', values.id);
   				submitUrl = SERVERURL.VEHICLE_ADDRESS_UPDATE;
   				message = getCommonTranslation('ADDRESS_UPDATE_SUCCESS');
   			}

   			var formData = Ext.encode(address.data);

   			Ext.Ajax.request({
   				type: 'rest',
   				url: submitUrl,
   				jsonData: formData,
   				method: 'POST',
   				success: function(response, action) {
   					var addressId = Ext.JSON.decode(response.responseText);
   					if(values.addressButtonId=='purchasedFromAddress'){
   						vehicleForm.down("#purchaseFromAddressId").setValue(addressId);
   					}else if(values.addressButtonId=='serviceByAddress'){
   						vehicleForm.down("#serviceFromAddressId").setValue(addressId);
   					}else if(values.addressButtonId=='insuranceAddress'){
   						vehicleForm.down("#insuranceAddressId").setValue(addressId);
   					}else if(values.addressButtonId=='roadTaxAddress'){
   						vehicleForm.down("#roadTaxAddressId").setValue(addressId);
   					}else if(values.addressButtonId=='emissionAddress'){
   						vehicleForm.down("#emissionAddressId").setValue(addressId);
   					}
   					showSuccessMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'),message);
   					this$.getCloseAddressDetail();
   				}
   			});
//   		}
   		
   		
   	},
   	
   	/**
   	 * view Licence Registration uploaded documents
   	 */
	getViewLicenceRegistrationDocument : function(record){
   	    var $this = this;
   		var gridWindow = $this.getVehiclelicenceregistrationdocumentgridwin();
   		if (!gridWindow) {
   			Ext.widget('vehiclelicenceregistrationdocumentgridwin');
   			gridWindow = $this.getVehiclelicenceregistrationdocumentgridwin();
   		}
   		
   		var grid = gridWindow.down('grid');
   		var store = grid.getStore();
   		store.getProxy().extraParams = {
   			vehicleLicenseRegistrationDetailId: record.get("id")
   		};
   		store.load();
   		
   		gridWindow.show();
   	},
   	
	/**
   	 * view insurance uploaded documents
   	 */
   	getViewInsuranceDocument : function(record){
   	    var $this = this;
   		var gridWindow = $this.getVehicleInsuranceDocumentGridWin();
   		if (!gridWindow) {
   			Ext.widget('vehicleinsurancedocumentgrid');
   			gridWindow = $this.getVehicleInsuranceDocumentGridWin();
   		}
   		
   		var grid = $this.getVehicleInsuranceDocumentGrid();
   		var store = grid.getStore();
   		store.getProxy().extraParams = {
   			vehicleInsuranceDetailId: record.get("id")
   		};
   		store.load();
   		
   		gridWindow.show();
   	},
	/**
   	 * view emission uploaded documents
   	 */
   	getViewEmissionDocument : function(record){
   	    var $this = this;
   		var gridWindow = $this.getVehicleEmissionDocumentGridWin();
   		if (!gridWindow) {
   			Ext.widget('vehicleemissiondocumentgrid');
   			gridWindow = $this.getVehicleEmissionDocumentGridWin();
   		}
   		
   		var grid = $this.getVehicleEmissionDocumentGrid();
   		var store = grid.getStore();
   		store.getProxy().extraParams = {
   			vehicleEmissionDetailId: record.get("id")
   		};
   		store.load();
   		
   		gridWindow.show();
   	},
   	/**
   	 * view road tax uploaded documents
   	 */
 	getViewRoadTaxDocument : function(record){
   	    var $this = this;
   		var gridWindow = $this.getVehicleRoadTaxDocumentGridWin();
   		if (!gridWindow) {
   			Ext.widget('vehicleroadtaxdocumentgrid');
   			gridWindow = $this.getVehicleRoadTaxDocumentGridWin();
   		}
   		
   		var grid = $this.getVehicleRoadTaxDocumentGrid();
   		var store = grid.getStore();
   		store.getProxy().extraParams = {
   			vehicleRoadTaxDetailId: record.get("id")
   		};
   		store.load();
   		
   		gridWindow.show();
   	},
   	/**
   	 * Common function for document download
   	 */
    getDownloadFile : function(documentId){
    	if(!isNullOrEmpty(documentId)){
    		var csvForm = Ext.create('Ext.form.Panel'); 
    		csvForm.getForm().submit({
    			target: '_blank',
    			method:'GET',
    			params :{
    				access_token : Ext.Ajax.defaultHeaders.access_token
    			},
    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
    			url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
    			standardSubmit :true
    		});
    	}
    },
    /**
     * get delete documents
     */
    getDeleteDocuments : function(grid,url, parentGrid){
    	var $this = this;
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getTransportTranslation('DOCUMENT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
    				function(btn,text) {
    			if (btn == 'yes') {
    				$this.applyWindowMask(); 
    				var records = grid.getSelectionModel().getSelection();
    				var id = records[0].get("id");
    				Ext.Ajax.request({
    					method : "DELETE",
    					type : 'rest',
    					url : url+ '?id='+ id,
    					headers : {
    						'Content-Type' : 'application/json'
    					},
    					success : function(form,action) {
    						$this.hideWindowMask();
    						grid.getStore().reload();
    						parentGrid.getStore().reload();
    						parentGrid.getSelectionModel().deselectAll(true);
    						showSuccessMessage(getTransportTranslation('DOCUMENT'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
    					}
    				});
    			}
    		});
    	} else {
    		showWarningMessage(getTransportTranslation('DOCUMENT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please
    	}
    },
    getCommonAddressDetailsForHistory :function(records){
    	var this$ = this;
    	var addressWindowForHistoryItemId ="vehicleAddressFormWindowForHistory";
    	var addressFormWindow = Ext.widget('addressformwindow', {
    		itemId: addressWindowForHistoryItemId
    	});
    	addressFormWindow.show();

    	var addressDetailsform = addressFormWindow.down('#personAddressFieldsForm');
    	//addressDetailsform.add(Ext.create("Ext.form.field.Text", {name:'record',hidden: true}));
    	var form = addressDetailsform.getForm();
    	var addressId = records.get("addressId");

    	if(!isNullOrEmpty(addressId)) {
    		var url = SERVERURL.VEHICLE_ADDRESS_FIND_BY_ID;
    		if (!isNullOrEmpty(addressId)) {
    			var params = {
    					id : addressId	
    			}; 
    			this$.sendGetAjaxRequest(url, 'GET', params, function(option, success, response) {
    				if(success){
    					var data = Ext.decode(response.responseText);
    					form.setValues(data);
    					form.findField('addressText').setValue(data.addressText);
    					form.findField('phoneAreaCode').setValue(data.phoneAreaCode);
    					form.findField('phoneNo').setValue(data.phoneNo);
    					form.findField('cellNo').setValue(data.cellNo);
    					form.findField('primaryeEmailId').setValue(data.primaryeEmailId);
    					form.findField('alternateEmailId').setValue(data.alternateEmailId);

    					var country = form.findField('country');
    					var city = form.findField('city');
    					var parentCountryRegion = form.findField('parentCountryRegion');
    					var countryRegion = form.findField('countryRegion');

    					if(data.country){
    						
    						country.getStore().load({
    							callback : function(rec,operation,success){
    								country.setValue(data.country.id);
    							}
    						});	

    						var cityStore = city.getStore();
    						cityStore.getProxy().extraParams = {
    							id: data.parentCountryRegion.id
    						};
    						cityStore.load({
    							callback : function(rec,operation,success){
    								city.setValue(data.city.id);
    							}
    						});

    						var pcrStore = parentCountryRegion.getStore();
    						pcrStore.getProxy().extraParams = {
    							cid:data.country.id
    						};
    						pcrStore.load({
    							callback : function(rec,operation,success){
    								parentCountryRegion.setValue(data.parentCountryRegion.id);
    							}
    						});

    						if(data.countryRegion){
    							var crStore = countryRegion.getStore();
    							crStore.getProxy().extraParams = {
    								pid:data.parentCountryRegion.id
    							};
    							crStore.load({
    								callback : function(rec,operation,success){
    									countryRegion.setValue(data.countryRegion.id);
    								}
    							});
    						}
    					}
    				}
    			});
    		}
    	}
    	/**
    	 * set vehicle history record (insurance/emission/roadtax)
    	 */
    	var vehicleInfo = Academia.model.transport.vehicle.VehicleRecord;
    	vehicleInfo.set("records", records);
    },
   	getCloseAddressDetailForHistory : function(){
   		this.getVehicleAddressFormWindowForHistory().close();
   	},
   	getSaveAddressDetailForHistory : function(){
   		var this$ = this;
   		var addressFormWindow = this.getVehicleAddressFormWindowForHistory();
   		var form = addressFormWindow.down('#personAddressFieldsForm');
   		var values = form.getValues();
   		/**
   		 * get vehicle history record (insurance/emission/roadtax)
   		 */
//   		if (this$.validatePhone(values)) {
   			var vehicleHistoryInfo = Academia.model.transport.vehicle.VehicleRecord;
   			var vehicleHistoryRecord = vehicleHistoryInfo.get("records");
   	   		
   	   		var address = new Academia.model.organization.Address();
   	   		var arr=[];
   	   		address.set('version', values.version);
   	   		address.set('addressText', values.addressText);
   	   		address.set('country', this.getIdValueJson(values.country));
   	   		address.set('parentCountryRegion', this$.getIdValueJson(values.parentCountryRegion));
   	   		address.set('countryRegion', this$.getIdValueJson(values.countryRegion));
   	   		address.set('city', this$.getIdValueJson(values.city));
   	   		address.set('pincode', values.pincode);
   	   		address.set('cellCountryCode',values.cellCountryCode);
   	   		address.set('cellNo', values.cellNo);
   	   		address.set('phoneCountryCode', values.phoneCountryCode);
   	   		address.set('phoneAreaCode', values.phoneAreaCode);
   	   		address.set('phoneNo', values.phoneNo);
   	   		address.set('primaryeEmailId', values.primaryeEmailId);
   	   		address.set('alternateEmailId', values.alternateEmailId);
   	   		address.set('addressType', null);
   	   	   
   	   	if (!isNullOrEmpty(values.customData)) {
   	   	 address.set('customData', values.customData);
   	   	
   	   	}else
   	   	address.set('customData', arr);
   	   	
   	   	   var submitUrl;
   	   	   var message;
   		  if (values.id == null || values.id == "") {
   			  submitUrl = SERVERURL.VEHICLE_ADDRESS_CREATE;
   			  message = getCommonTranslation('ADDRESS_ADD_SUCCESS');
   		  } else {
   			  address.set('id', values.id);
   			  submitUrl = SERVERURL.VEHICLE_ADDRESS_UPDATE;
   			  message = getCommonTranslation('ADDRESS_UPDATE_SUCCESS');
   		  }

   	   		var formData = Ext.encode(address.data);

   	   		Ext.Ajax.request({
   	   			type: 'rest',
   	   			url: submitUrl,
   	   			jsonData: formData,
   	   			method: 'POST',
   	   			success: function(response, action) {
   	   				var addressId = Ext.JSON.decode(response.responseText);
   	   				if (!isNullOrEmpty(addressId)) {
   	   					/*if(isNullOrEmpty(vehicleHistoryRecord.get("addressId"))){
   	   						this$.getUpdateVehicleHistory(addressId,vehicleHistoryRecord);   						
   	   					}*/
   	   				this$.getUpdateVehicleHistory(addressId,vehicleHistoryRecord); 
   	   				}
   	   				showSuccessMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'),message);
   	   				this$.getCloseAddressDetailForHistory();
   	   			}
   	   		});
//   		}
   	},
   	/**
   	 * if addressId will not  exist than history data will upadte
   	 */
   	getUpdateVehicleHistory : function(addressId,vehicleHistoryRecord){
   		var val = vehicleHistoryRecord.getData();
   		var submitData;
		var submitUrl;
		var gridStore;
		var grid;
		var contentPnl = this.getContentPanel();
		var activeTabGrid = contentPnl.getActiveTab().down('grid');
		
   		if(Ext.isDefined(activeTabGrid) && activeTabGrid.xtype == "insurancehistorylist"){
   			grid = this.getInsuranceHistoryList();
   			gridStore = grid.getStore();
   			var insurancModel = new Academia.model.transport.vehicle.InsuranceHistorySubmitData();
   			insurancModel.set("id",val["id"]);
   			insurancModel.set("vehicle",this.getIdValueJson(val["vehicle"].id));
   			insurancModel.set("currencyId",val["currencyId"]);
   			insurancModel.set("addressId",addressId);
   			
   			insurancModel.set("policyHolderName",val["policyHolderName"]);
   			insurancModel.set("inceptionDate",val["inceptionDate"]);
   			insurancModel.set("premiumPaymentCycle",val["premiumPaymentCycle"]);
   			insurancModel.set("brokerMobileCountryCode",vehicleHistoryRecord.raw.brokerMobileCountryCode);
   			insurancModel.set("brokerMobileNumber", vehicleHistoryRecord.raw.brokerMobileNumber);
   			
   			insurancModel.set("insuranceVendor",val["insuranceVendor"]);
   			insurancModel.set("policyNumber",val["policyNumber"]);
   			insurancModel.set("validFrom",val["validFrom"]);
   			insurancModel.set("validTill",val["validTill"]);
   			insurancModel.set("insuranceCost",val["insuranceCost"]);
   			insurancModel.set("insurancePaidOn",val["insurancePaidOn"]);
   			insurancModel.set("insurancePolicyWith",val["insurancePolicyWith"]);
   			insurancModel.set("insuranceAlertBeforeNdays",vehicleHistoryRecord.raw.insuranceAlertBeforeNdays);
   			
   			 submitData = Ext.encode(insurancModel.data);
   			 submitUrl = SERVERURL.VEHICLE_INSURANCE_HISTORY_UPDATE; 

   		}
   		if(Ext.isDefined(activeTabGrid) && activeTabGrid.xtype == "emissionhistorylist"){
   	   		grid = this.getEmissionHistoryList();
   	   		gridStore = grid.getStore();

   	   		var emissionModel = new Academia.model.transport.vehicle.EmissionHistorySubmitData();
   	 	    emissionModel.set("id",val["id"]);
   	   		emissionModel.set("vehicle",this.getIdValueJson(val["vehicle"].id));
   	   		emissionModel.set("currencyId",val["currencyId"]);
   	   		emissionModel.set("addressId",addressId);
   	   		emissionModel.set("emissionVendor",val["emissionVendor"]);
   	   		emissionModel.set("emissionCheckOn",val["emissionCheckOn"]);
   	   	    emissionModel.set("emissionToBeCheckOn",val["emissionToBeCheckOn"]);
   	   		emissionModel.set("emissionCost",val["emissionCost"]);
   	   	    emissionModel.set("emissionPolicyWith",val["emissionPolicyWith"]);
   	   	    emissionModel.set("emissionAlertBeforeNdays",vehicleHistoryRecord.raw.emissionAlertBeforeNdays);

   	   	    submitData = Ext.encode(emissionModel.data);
   	   		submitUrl = SERVERURL.VEHICLE_EMISSION_HISTORY_UPDATE;
   			
   		}
   		if(Ext.isDefined(activeTabGrid) && activeTabGrid.xtype == "roadtaxhistorylist"){
   	   		grid = this.getRoadTaxHistoryList();
   	   	    gridStore = grid.getStore();
   	   		
   	   		var roadTaxModel = new Academia.model.transport.vehicle.RoadTaxHistorySubmitData();
   	   		roadTaxModel.set("id",val["id"]);
   	   		roadTaxModel.set("vehicle",this.getIdValueJson(val["vehicle"].id));
   	   		roadTaxModel.set("currencyId",val["currencyId"]);
   	   	    roadTaxModel.set("addressId",addressId);
   	   		roadTaxModel.set("validFrom",val["validFrom"]);
   	   		roadTaxModel.set("validTill",val["validTill"]);
   	   		roadTaxModel.set("roadTaxCost",val["roadTaxCost"]);
   	   		roadTaxModel.set("roadTaxPaidOn",val["roadTaxPaidOn"]);
   	   	    roadTaxModel.set("roadTaxWith",val["roadTaxWith"]);
   	   	    roadTaxModel.set("roadTaxVendor",val["roadTaxVendor"]);
   	     	roadTaxModel.set("roadTaxAlertBeforeNdays",vehicleHistoryRecord.raw.roadTaxAlertBeforeNdays);
   	   	     submitData = Ext.encode(roadTaxModel.data);
   	         submitUrl = SERVERURL.VEHICLE_ROAD_TAX_HISTORY_UPDATE; 
   		}
        
   		Ext.Ajax.request({
   			url: submitUrl,
   			jsonData: submitData,
   			method: 'POST',
   			success: function(response) {
   				gridStore.reload();
   				grid.getSelectionModel().deselectAll(true);  
   			}
   		});
   	},
	/**
   	 * get open journey assignment window
   	 */
   	getShowJourneyAssignmentWin:function(){
   		var frmWin = this.getJourneyAssignmentDetailWin();
   		if(!frmWin){
   			Ext.widget('journeyassignmentdetailwin');
   			frmWin = this.getJourneyAssignmentDetailWin();
   		}
   		frmWin.show();
   		var academyLocationId = this.getCurrentAcademyLocation();
   		
   		var form = this.getJourneyAssignmentDetailForm();
   		var serviceName = form.down("#serviceName");
   		serviceName.getStore().getProxy().extraParams = {
			academyLocationIds : academyLocationId
		};
   	},
   	getCloseJourneyAssignmentWin : function(){
   		this.getJourneyAssignmentDetailWin().close();
   	},
	/**
   	 * save journey assignment detail
   	 */
   	getSaveJourneyAssignmentDetails : function(){
   		var this$ = this;
   		var grid = this$.getJourneyAssignmentList();
   		var gridStore = grid.getStore();
   		var form = this$.getJourneyAssignmentDetailForm();
   		var values = form.getForm().getValues();
   		
   		var structure = this$.getJourneyAssignmentStructure();
        var vehicleId = structure.down("#vehicleId").getValue();
   		
   		var jounerAssignmentModel = new Academia.model.transport.vehicle.JourneyAssignmentSubmitData();
   		jounerAssignmentModel.set("id",values.id);
   		jounerAssignmentModel.set("vehicle",this$.getIdValueJson(vehicleId));
   		jounerAssignmentModel.set("dateOfJourney",values.dateOfJourney);
   		jounerAssignmentModel.set("assignStatus",values.assignStatus);
   		jounerAssignmentModel.set("completionStatus",values.completionStatus);
   		jounerAssignmentModel.set("transServiceRoute",this$.getIdValueJson(values.serviceName));
   		
   		
   		var submitUrl;
    	var message;
    	if (values.id == null || values.id == "") {
    		submitUrl = SERVERURL.VEHICLE_JOURNEY_ASSIGNMENT_CREATE; 
    		message = getTransportTranslation('JOURNEY_ASSIGNMENT_CREATED_SUCCESSFULLY');
    	} else {
    		submitUrl = SERVERURL.VEHICLE_JOURNEY_ASSIGNMENT_UPDATE; 
    		message = getTransportTranslation('JOURNEY_ASSIGNMENT_UPDATED_SUCCESSFULLY');
    	}
   		var submitData = Ext.encode(jounerAssignmentModel.data);
		Ext.Ajax.request({
			url: submitUrl,
			jsonData: submitData,
			method: 'POST',
			success: function(response) {
				this$.getCloseJourneyAssignmentWin();
				gridStore.reload();
				showSuccessMessage(getTransportTranslation('JOURNEY_ASSIGNMENT_DETAILS'),message);
			}
   	});
   	},
   	/**
   	 * view emission history detail
   	 */
   	getEditJourneyAssignment : function(){
   		var this$ = this;
   		var grid = this$.getJourneyAssignmentList();
    	if (grid.getSelectionModel().getCount() > 0) {
    		this$.getShowJourneyAssignmentWin();
       		var form = this$.getJourneyAssignmentDetailForm();
    		var record = grid.getSelectionModel().getSelection()[0];
    		var id = record.get("id");
    		var editUrl = SERVERURL.VEHICLE_JOURNEY_ASSIGNMENT_FINDBYID;
    		Ext.Ajax.request({
    			method: "GET",
    			type: 'rest',
    			url: editUrl,
    			params: {
    				id: id
    			},
    			success: function(f, action) {
    				var recordNew = record;
    				var data = Ext.JSON.decode(f.responseText);
    				if(!isNullOrEmpty(data.dateOfJourney))
    					data.dateOfJourney = new Date(data.dateOfJourney);
    				var journeyAssignmentModel = new Academia.model.transport.vehicle.JourneyAssignmentSubmitData(data);
    				form.loadRecord(journeyAssignmentModel);
    				
    				var serviceName = form.down("#serviceName");
    				serviceName.getStore().load({
    					callback : function(rec,operation,success){
    						serviceName.setValue(journeyAssignmentModel.get("transServiceRoute").id);
    					}
    				});
    				
    				var assignStatus = form.down("#assignStatus");
    				assignStatus.getStore().load({
      					callback : function(rec,operation,success){
      						assignStatus.setValue(journeyAssignmentModel.get("assignStatus"));
      					}
      				});
      				
      				var completionStatus = form.down("#completionStatus");
      				completionStatus.getStore().load({
      					callback : function(res,operation,success){
      						completionStatus.setValue(journeyAssignmentModel.get("completionStatus"));
      					}
      				});
      				
      				var noOfUsersServiced = form.down("#noOfUsersServiced");
      				noOfUsersServiced.setValue(recordNew.data.noOfUsers);
    			}
    		 });
    		}else{
    			 showWarningMessage(getTransportTranslation('JOURNEY_ASSIGNMENT_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    		}
   	},
   	/**
   	 * view journey Assignment detail
   	 */
   	getViewJourneyAssignment : function(){
   		this.getEditJourneyAssignment();
 		var form =this.getJourneyAssignmentDetailForm();
 		if (form) {
 			form.down('#SubmitBtn').setVisible(false);
 			form.down('#noOfUsersServiced').setVisible(true);
 			form = form.getForm();
 		    toggleReadOnlyFormItems(form,true);
 		}
   	},
   	getNumberOfUserServicedWin : function(record){
   			var $this=this;
	    	var transJourneyAssignmentId = record.get("id");
	    	var formWindow = this.getNumberOfUserCoveredGridWindow();
	    	if (!formWindow) {
	    		Ext.widget('numberofusercoveredgridwindow');
	    		formWindow = this.getNumberOfUserCoveredGridWindow();
	    	}
	    	formWindow.show();	
	    	this.getStore('transport.vehicle.PresentAbsentEnum').load();
	    	var grid = this.getNumberOfUserCoveredGrid();
	    	var store = grid.getStore();
	    	store.getProxy().extraParams = {
	    		transJourneyAssignmentId: transJourneyAssignmentId
	    	};
	    	$this.resetPageSetting(store);
	    	store.load();	    	
   	},
	getCloseNumberOfUserServicedWin : function(record){
    	 this.getNumberOfUserCoveredGridWindow().close();
	},
   	getUpdateServicedUser : function(){
	  var $this=this;
   		var grid = this.getNumberOfUserCoveredGrid();
   		var store = grid.getStore();
	    var records = grid.selModel.getSelection();
	    if(records.length>0){
	    var submitJson=[];
	    for(var i in records){
	    	submitJson.push({
	    		"id":records[i].get("id"),
	    		"serviceRouteUser":records[i].get("serviceRouteUser"),
	    		"transJourneyAssignment":records[i].get("transJourneyAssignment"),
	    		"attendance":records[i].get("attendance")
	    	});
 	   }
	    var submitUrl = SERVERURL.USER_ATTENDANCE_UPDATE;
		   Ext.Ajax.request({
			   type : 'rest',
			   url : submitUrl,
			   jsonData : submitJson,
			   method : 'POST',
			   success : function(response, action) {
				   store.reload();
				   showSuccessMessage(getTransportTranslation('NO_OF_USERS_SERVICED'), getTransportTranslation('USER_UPDATE_SUCCESSFULLY'));
				   grid.getSelectionModel().deselectAll(true);  
	               var formWindow = $this.getNumberOfUserCoveredGridWindow();
                    formWindow.close();
	               
			   }
		   });
	    }else{
	    	showWarningMessage(getTransportTranslation('NO_OF_USERS_SERVICED'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	    }
   	},
    //************ disableMoreActionPivileges****************  
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
    	
    	var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	buttonsToolBar = gridReference.query('toolbar')[0];
    	var splitbuttons = buttonsToolBar.query('splitbutton')[0];
    	Ext.each(splitbuttons.menu.items.items, function(menuItems) {
			menuItems.setVisible(false);
    	});
    	//TODO temp
    	//buttonsToolBar.query('#viewVehicleLocationStatusLink')[0].setVisible(true);
    	 		
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'MOREACTION') {
        		var button = buttonsToolBar.query('#spBtnMoreActions')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}        		
        	}
    		if (privilege === 'INSURANCEHISTORY') {
        		var button = buttonsToolBar.query('#insuranceHistoryLink')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}        		
        	}
    		if (privilege === 'EMISSIONHISTORY') {
        		var button = buttonsToolBar.query('#emissionHistoryLink')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}        		
        	}
    		if (privilege === 'ROADTAXHISTORY') {
        		var button = buttonsToolBar.query('#roadTaxHistoryLink')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}        		
        	}
    		if (privilege === 'JOURNEYASSIGNMENT') {
        		var button = buttonsToolBar.query('#journeyAssignmentLink')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}        		
        	}
    		if (privilege === 'VIEWVEHICLELOCATIONSTATUS') {
        		var button = buttonsToolBar.query('#viewVehicleLocationStatusLink')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}        		
        	}
    		if (privilege === 'LICENCEHISTORY') {
        		var button = buttonsToolBar.query('#licenceHistoryLink')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}        		
        	}
    		if (privilege === 'FUELCONSUMPTION') {
        		var button = buttonsToolBar.query('#fuelConsumptionLink')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}        		
        	}
    		if (privilege === 'SERVICEHISTORY') {
        		var button = buttonsToolBar.query('#serviceHistoryLink')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}    
        	}
    		
    		if (privilege === 'VEHICLEPERMIT') {
        		var button = buttonsToolBar.query('#vehiclePermit')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}        		
        	}
    		if (privilege === 'FITNESS_CERTIFICATE') {
        		var button = buttonsToolBar.query('#fitnessCertificateLink')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}        		
        	}
    	});
    },
    validatePhone:function(data){
    	var isValid;
    	if(!(data.phoneNo && data.phoneCountryCode && data.phoneAreaCode) && !(data.cellNo && data.cellCountryCode)){
    		//showErrorMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'),getCommonTranslation('ADD_PHONE_NO'));
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ADD_PHONE_NO'));
    		isValid= false;
    	}
    	else{
    		isValid=true;
    	}
    	return isValid;
    },
    addVehicleType: function() {
        var winVehicleTypeFormWindow = Ext.widget('vehicletypeformwindow');
        winVehicleTypeFormWindow.show();
    },
    editVehicleType: function(isView){
        var me = this;
        var grid = me.getVehicletypegrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            me.showVehicleTypeForm();
            if (records != "" && records != null && records != undefined) {
                var vehicleTypeFormWin = me.getVehicletypeformwindow();
                var formPnl = vehicleTypeFormWin.down('form');
                var rec = new Academia.model.transport.vehicleType.VehicleTypeModel(
                records[0].data);
                formPnl.loadRecord(rec);
                grid.getStore().reload();
                if (isView) {
                	vehicleTypeFormWin.down('#btnSaveVehicleTypeForm').setVisible(false);
                    toggleReadOnlyFormItems(formPnl.getForm(), true);
                }
            }
        } else {
        	showWarningMessage(getCommonTranslation('VEHICLE_TYPE'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
        }
    },
    showVehicleTypeForm: function() {
        var vehicleTypeFormWin = this.getVehicletypeformwindow();
        if (isEmpty(vehicleTypeFormWin)) {
        	vehicleTypeFormWin = Ext.widget('vehicletypeformwindow');
        }
        vehicleTypeFormWin.show();
    },
    cancelVehicleTypeForm: function(){
    	this.getVehicletypeformwindow().close();
    },
    saveVehicleTypeForm: function(){
    	var this$ = this,
    	vehicleTypeFormWin = this$.getVehicletypeformwindow(),
    	grid = this$.getVehicletypegrid(),
    	submitUrl, isUpdate = false,
    	winVehicleTypeFormPnl = vehicleTypeFormWin.down('form'),
    	winVehicleTypeFormPnlValues = winVehicleTypeFormPnl.getForm().getFieldValues(),
    	vehicleTypeFld = vehicleTypeFormWin.down('#hidVehicleTypeId');
    	if (vehicleTypeFld.getSubmitValue() == null || vehicleTypeFld.getSubmitValue() == "" || vehicleTypeFld.getSubmitValue() === undefined) {
    		submitUrl = SERVERURL.VEHICLE_SUB_TYPE_CREATE,
    		isUpdate = false;
    	} else {
    		submitUrl = SERVERURL.VEHICLE_SUB_TYPE_UPDATE,
    		isUpdate = true;
    	}
    	var jsonFormatFormData = Ext.encode(winVehicleTypeFormPnlValues);

    	Ext.Ajax.request({
    		type: 'rest',
    		url: submitUrl,
    		jsonData: jsonFormatFormData,
    		method: 'POST',
    		success: function(form, action) {
    			if (!isNullOrEmpty(form.responseText) && form.responseText.length > 0) {
    				showWarningMessage(getCommonTranslation('VEHICLE_TYPE'), getErrorTranslation(form.responseText));
    			} else {
    				vehicleTypeFormWin.close();
    				this$.resetPageSetting(grid.getStore());
    				grid.getStore().load();
    				grid.getSelectionModel().deselectAll();
    				if (isUpdate) {
    					showSuccessMessage(getCommonTranslation('VEHICLE_TYPE'), getCommonTranslation('UPDATE_VEHICLE_TYPE_MSG'));
    				} else {
    					showSuccessMessage(getCommonTranslation('VEHICLE_TYPE'), getCommonTranslation('ADD_VEHICLE_TYPE_MSG'));
    				}
    			}
    		}
    	});
    },
    deleteVehicleType: function() {
    	var grid = this.getVehicletypegrid();
    	var grdStore = grid.getStore();
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getCommonTranslation('VEHICLE_TYPE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
    			if (btn == 'yes') {
    				if (grid.getSelectionModel().getCount() > 0) {
    					var records = grid.getSelectionModel().getSelection();
    					for (var count = 0; count < records.length; count++) {
    						var id = "";
    						if (records[count].get("id") != "" && records[count].get("id") != undefined && records[count].get("id") != null) {
    							id = records[count].get("id");
    						}
    						Ext.Ajax.request({
    							type: 'rest',
    							method: 'DELETE',
    							url: SERVERURL.VEHICLE_SUB_TYPE_DELETE  + '?id=' + id,
    							headers: {
    								'Content-Type': 'application/json'
    							},
    							params: {
    								id: id
    							},
    							success: function(form, action) {
    								if (form.responseText == 0) {
    									showWarningMessage(getCommonTranslation('VEHICLE_TYPE'), getCommonTranslation('VEHICLE_TYPE_DEPENDENCY_EXIST_ON_DELETE'));
    								} else {
    									showSuccessMessage(getCommonTranslation('VEHICLE_TYPE'), getCommonTranslation('DELETE_VEHICLE_TYPE_MSG'));
    									grdStore.reload();
    									grid.getStore().reload();
    								}

    							},
    							failure: function(form, action) {
    								showWarningMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
    							}
    						});
    					}
    				}
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('VEHICLE_TYPE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    addStopLocation: function() {
        var winStopLocationFormWindow = Ext.widget('stoplocationformwindow');
        winStopLocationFormWindow.show();
    },
    editStopLocation: function(isView){
        var me = this;
        var grid = me.getStoplocationgrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            me.showStopLocationForm();
            if (records != "" && records != null && records != undefined) {
                var stopLocationFormWin = me.getStoplocationformwindow();
                var formPnl = stopLocationFormWin.down('form');
                var rec = new Academia.model.transport.stopLocation.StopLocationModel(
                records[0].data);
                formPnl.loadRecord(rec);
                grid.getStore().reload();
                if (isView) {
                	stopLocationFormWin.down('#btnSaveStopLocationForm').setVisible(false);
                    toggleReadOnlyFormItems(formPnl.getForm(), true);
                }
            }
        } else {
        	showWarningMessage(getCommonTranslation('STOP_LOCATION'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
        }
    },
    showStopLocationForm: function() {
        var stopLocationFormWin = this.getStoplocationformwindow();
        if (isEmpty(stopLocationFormWin)) {
        	stopLocationFormWin = Ext.widget('stoplocationformwindow');
        }
        stopLocationFormWin.show();
    },
    cancelStopLocationForm: function(){
    	this.getStoplocationformwindow().close();
    },
    saveStopLocationForm: function(){
    	var this$ = this,
    	stopLocationFormWin = this$.getStoplocationformwindow(),
    	grid = this$.getStoplocationgrid(),
    	submitUrl, isUpdate = false,
    	winStopLocationFormPnl = stopLocationFormWin.down('form'),
    	winStopLocationFormPnlValues = winStopLocationFormPnl.getForm().getFieldValues(),
    	hidStopLocationFld = stopLocationFormWin.down('#hidStopLocationId');
    	if (hidStopLocationFld.getSubmitValue() == null || hidStopLocationFld.getSubmitValue() == "" || hidStopLocationFld.getSubmitValue() === undefined) {
    		submitUrl = SERVERURL.ROUTE_LOCATION_CREATE,
    		isUpdate = false;
    	} else {
    		submitUrl = SERVERURL.ROUTE_LOCATION_UPDATE,
    		isUpdate = true;
    	}
    	var jsonFormatFormData = Ext.encode(winStopLocationFormPnlValues);
    	
    	stopLocationFormWin.down('#btnSaveStopLocationForm').setDisabled(true);
    	Ext.Ajax.request({
    		type: 'rest',
    		url: submitUrl,
    		jsonData: jsonFormatFormData,
    		method: 'POST',
    		success: function(form, action) {
    			if (!isNullOrEmpty(form.responseText) && form.responseText.length > 0) {
    				showWarningMessage(getCommonTranslation('STOP_LOCATION'), getErrorTranslation(form.responseText));
    			} else {
    				stopLocationFormWin.close();
    				this$.resetPageSetting(grid.getStore());
    				grid.getStore().load();
    				grid.getSelectionModel().deselectAll();
    				if (isUpdate) {
    					showSuccessMessage(getCommonTranslation('STOP_LOCATION'), getCommonTranslation('UPDATE_STOP_LOCATION_MSG'));
    				} else {
    					showSuccessMessage(getCommonTranslation('STOP_LOCATION'), getCommonTranslation('ADD_STOP_LOCATION_MSG'));
    				}
    			}
    		}
    	});
    },
    
    getDeleteInsuranceHistory : function(){
        var this$ = this;
        var grid = this$.getInsuranceHistoryList();
    	var grdStore = grid.getStore();
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getTransportTranslation('INSURANCE_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
    			if (btn == 'yes') {
					var records = grid.getSelectionModel().getSelection();
					var id = records[0].data.id;
					Ext.Ajax.request({
						type: 'rest',
						method: 'DELETE',
						url: SERVERURL.VEHICLE_INSURANCE_HISTORY_DELETE,
						headers: {
							'Content-Type': 'application/json'
						},
						params: {
							id: id
						},
						success: function(form, action) {
							if (form.responseText == 0) {
								showWarningMessage(getTransportTranslation('INSURANCE_DETAILS'), getTransportTranslation('INSURANCE_DETAIL_DEPENDENCY_EXIST_ON_DELETE'));
							} else {
								showSuccessMessage(getTransportTranslation('INSURANCE_DETAILS'), getTransportTranslation('INSURANCE_DETAIL_DELETE_MSG'));
								this$.resetPageSetting(grdStore);
								grdStore.reload();
							}
						},
						failure: function(form, action) {
							showWarningMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
						}
					});
				}
    		});
    	} else {
    		showWarningMessage(getTransportTranslation('INSURANCE_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    getDeleteEmissionHistory : function(){
        var this$ = this;
        var grid = this$.getEmissionHistoryList();
    	var grdStore = grid.getStore();
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getTransportTranslation('EMISSION_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
    			if (btn == 'yes') {
					var records = grid.getSelectionModel().getSelection();
					var id = records[0].data.id;
					Ext.Ajax.request({
						type: 'rest',
						method: 'DELETE',
						url: SERVERURL.VEHICLE_EMISSION_HISTORY_DELETE,
						headers: {
							'Content-Type': 'application/json'
						},
						params: {
							id: id
						},
						success: function(form, action) {
							if (form.responseText == 0) {
								showWarningMessage(getTransportTranslation('EMISSION_DETAILS'), getTransportTranslation('EMISSION_DETAIL_DEPENDENCY_EXIST_ON_DELETE'));
							} else {
								showSuccessMessage(getTransportTranslation('EMISSION_DETAILS'), getTransportTranslation('EMISSION_HISTORY_DELETED_SUCCESSFULLY'));
								this$.resetPageSetting(grdStore);
								grdStore.reload();
							}
						},
						failure: function(form, action) {
							showWarningMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
						}
					});
				}
    		});
    	} else {
    		showWarningMessage(getTransportTranslation('EMISSION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    getDeleteRoadTaxHistory : function(){
        var this$ = this;
        var grid = this$.getRoadTaxHistoryList();
    	var grdStore = grid.getStore();
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getTransportTranslation('ROAD_TAX_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
    			if (btn == 'yes') {
					var records = grid.getSelectionModel().getSelection();
					var id = records[0].data.id;
					Ext.Ajax.request({
						type: 'rest',
						method: 'DELETE',
						url: SERVERURL.VEHICLE_ROAD_TAX_HISTORY_DELETE,
						headers: {
							'Content-Type': 'application/json'
						},
						params: {
							id: id
						},
						success: function(form, action) {
							if (form.responseText == 0) {
								showWarningMessage(getTransportTranslation('ROAD_TAX_DETAILS'), getTransportTranslation('ROAD_TAX_DETAIL_DEPENDENCY_EXIST_ON_DELETE'));
							} else {
								showSuccessMessage(getTransportTranslation('ROAD_TAX_DETAILS'), getTransportTranslation('ROAD_TAX_HISTORY_DELETED_SUCCESSFULLY'));
								this$.resetPageSetting(grdStore);
								grdStore.reload();
							}
						},
						failure: function(form, action) {
							showWarningMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
						}
					});
				}
    		});
    	} else {
    		showWarningMessage(getTransportTranslation('ROAD_TAX_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    getSaveLicenceRegistrationDetail :function() {
   		var this$ = this;
   		var grid = this$.getLicencehistorylist();
   		var gridStore = grid.getStore();
   		var form = this$.getLicencehistorydetailwin();
   		var values = form.down('form').getForm().getValues();
   		
   		var structure = this$.getLicencehistorystructure();
        var vehicleId = structure.down("#vehicleId").getValue();
        var record = grid.getSelectionModel().getSelection()[0];
        
   		var licenceHistoryGridDataModel = new Academia.model.transport.vehicle.LicenceHistoryGridDataModel();
   		licenceHistoryGridDataModel.set("id",values.id);
   		licenceHistoryGridDataModel.set("vehicle",this$.getIdValueJson(vehicleId));
   		licenceHistoryGridDataModel.set("licenceDiskNumber",values.transLicenceDiskNo);
   		licenceHistoryGridDataModel.set("licenceNumber",values.transLicenceNo);
   		licenceHistoryGridDataModel.set("vehicleLicenseNumber",values.transVehicleLicenceNo);
   		licenceHistoryGridDataModel.set("vin",values.transVin);
   		licenceHistoryGridDataModel.set("engineNumber",values.transEngineNo);
   		licenceHistoryGridDataModel.set("fees",values.transFees);
   		licenceHistoryGridDataModel.set("gvm",values.transGVM);
   		licenceHistoryGridDataModel.set("tare",values.transTARE);
   		licenceHistoryGridDataModel.set("expiryDate",values.transDateOfExpiry);
   		licenceHistoryGridDataModel.set("testDate",values.transDateOfTest);
   		
        var submitUrl = SERVERURL.PATH_VEHICLE_LICENSE_REGISTRATION_DETAIL_CREATE; 
        var id = values.id;
        if(!isNullOrEmpty(values.id)) {
          licenceHistoryGridDataModel.set("addressId",record.data.addressId);
          licenceHistoryGridDataModel.set("expiryAlertBeforeNdays",record.data.expiryAlertBeforeNdays);
          submitUrl = SERVERURL.PATH_VEHICLE_LICENSE_REGISTRATION_DETAIL_UPDATE;
        }
        var submitData = Ext.encode(licenceHistoryGridDataModel.data);
        this$.applyWindowMask(); 
        
		Ext.Ajax.request({
			url: submitUrl,
			jsonData: submitData,
			method: 'POST',
			success: function(response) {
				this$.hideWindowMask();
				this$.getCloseLicenceHistoryWin();
				gridStore.reload();
				grid.getSelectionModel().deselectAll(true);
				if(!isNullOrEmpty(id)) {
   					showSuccessMessage(getTransportTranslation('TRANS_LICENCE_AND_REGISTRATION_DETAILS'),getTransportTranslation('LICENCE_AND_REGISTRATION_DETAIL_UPDATED_SUCCESSFULLY'));
   				} else {
   					showSuccessMessage(getTransportTranslation('TRANS_LICENCE_AND_REGISTRATION_DETAILS'),getTransportTranslation('LICENCE_AND_REGISTRATION_DETAIL_CREATED_SUCCESSFULLY'));
   				}
			}
   	});
   	},
 	
   	/**
   	 * view insurance history detail
   	 */
   	getViewLicenceHistory : function(){
   		this.getEditLicenceHistory();
 		var form =this.getLicencehistorydetailwin();
 		if (form) {
 			form.down('#SubmitBtn').setVisible(false);
 			form = form.down('form').getForm();
 		    toggleReadOnlyFormItems(form,true);
 		}
   	},
   	
   	getEditLicenceHistory : function(){
   		var this$ = this;
   		var grid = this$.getLicencehistorylist();
    	
    	if (grid.getSelectionModel().getCount() > 0) {
    		this$.getShowLicenceHistoryWin();
    		var form = this$.getLicencehistorydetailwin();
    		var record = grid.getSelectionModel().getSelection()[0];
    		var id = record.get("id");
    		var editUrl = SERVERURL.PATH_VEHICLE_LICENSE_REGISTRATION_DETAIL_FIND_BY_ID;
    		this$.applyWindowMask(); 
    		  
    		Ext.Ajax.request({
    			method: "GET",
    			type: 'rest',
    			url: editUrl,
    			params: {
    				licenceRegistrationId : id
    			},
    			success: function(f, action) {
    				this$.hideWindowMask();
    				var data = Ext.JSON.decode(f.responseText);
    				form.down("#id").setValue(data.id);
    				form.down("#transLicenceDiskNo").setValue(data.licenceDiskNumber);
    				form.down("#transLicenceNo").setValue(data.licenceNumber);
    				form.down("#transVehicleLicenceNo").setValue(data.vehicleLicenseNumber);
    				form.down("#transVin").setValue(data.vin);
    				form.down("#transEngineNo").setValue(data.engineNumber);
    				form.down("#transFees").setValue(data.fees);
    				form.down("#transGVM").setValue(data.gvm);
    				form.down("#transTARE").setValue(data.tare);
    				
    				if(!isNullOrEmpty(data.expiryDate))
    					form.down("#transDateOfExpiry").setValue(dateRender(data.expiryDate));
    				if(!isNullOrEmpty(data.testDate))
    					form.down("#transDateOfTest").setValue(dateRender(data.testDate));
    			}
    		 });
    		}else{
    			this$.hideWindowMask();
    			 showWarningMessage(getTransportTranslation('TRANS_LICENCE_AND_REGISTRATION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    		}
   	},
   	
    getDeleteLicenceHistory : function(){
        var this$ = this;
        var grid = this$.getLicencehistorylist();
    	var grdStore = grid.getStore();
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getTransportTranslation('TRANS_LICENCE_AND_REGISTRATION_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
    			if (btn == 'yes') {
					var records = grid.getSelectionModel().getSelection();
					var id = records[0].data.id;
					Ext.Ajax.request({
						type: 'rest',
						method: 'DELETE',
						url: SERVERURL.PATH_VEHICLE_LICENSE_REGISTRATION_DETAIL_DELETE,
						headers: {
							'Content-Type': 'application/json'
						},
						params: {
							id: id
						},
						success: function(form, action) {
							if (form.responseText == 0) {
								showWarningMessage(getTransportTranslation('TRANS_LICENCE_AND_REGISTRATION_DETAILS'), getTransportTranslation('LICENCE_AND_REGISTRATION_DETAIL_DEPENDENCY_EXIST_ON_DELETE'));
							} else {
								showSuccessMessage(getTransportTranslation('TRANS_LICENCE_AND_REGISTRATION_DETAILS'), getTransportTranslation('LICENCE_AND_REGISTRATION_DETAIL_DELETED_SUCCESSFULLY'));
								this$.resetPageSetting(grdStore);
								grdStore.reload();
							}
						},
						failure: function(form, action) {
							showWarningMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
						}
					});
				}
    		});
    	} else {
    		showWarningMessage(getTransportTranslation('TRANS_LICENCE_AND_REGISTRATION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /*add workaround code for datefield not showing picker in fieldset after second time*/
    expandSearchVehicleMoreFilter: function(fld,eOpts){
    	var fldConFirstDateRow = fld.down('#fldConFirstDateRow');
    	var fldConSecondDateRow = fld.down('#fldConSecondDateRow');
    	
    	fldConFirstDateRow.removeAll();
    	fldConSecondDateRow.removeAll();
    	
    	fldConFirstDateRow.add([{
    		xtype: 'datefield',
    		name:'licenseExpiryDate',
    		itemId:'licenseExpiryDateItemId',
    		fieldLabel:getTransportTranslation('LICENCE_DATE_OF_EXPIRY'),
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		}
    	}, {
    		xtype: 'datefield',
    		name:'insuranceExpiryBy',
    		itemId:'insuranceExpiryBy',
    		fieldLabel:getTransportTranslation('INSURANCE_TILL'),
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		}
    	}]);
    	
    	fldConSecondDateRow.add({
    		xtype: 'datefield',
			name:'emissionExpiryBy',
			itemId:'emissionExpiryBy',
			fieldLabel:getTransportTranslation('EMISSION_CHECK_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}, {
			xtype: 'datefield',
			name:'roadTaxExpiryBy',
			itemId:'roadTaxExpiryBy',
			fieldLabel:getTransportTranslation('ROAD_TAX_TILL'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		})
    },
    getOpenVehiclePermit : function(){
   		var grid = this.getVehicleList();
   		if (grid.getSelectionModel().getCount() > 0) {
   			var contentpanel = this.getContentPanel();
   			var structure = Ext.widget('vehiclepermitstructure');
   			var tabName = getTransportTranslation('VEHICLE_PERMIT');
   			var getcontroller=this.getController('menu.CoreERPNavigationController');
   			var getTab=getcontroller.getTab(tabName);
   			if(getTab!=null){
   				contentpanel.remove(getTab, true);
   			}
   			openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_ELEVEN);
   		}else{
   			showWarningMessage(getTransportTranslation('VEHICLE_PERMIT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
   		}
   	},
   	getRenderVehiclePermit : function(grid){
   		var this$ = this;
   		
   		var structure = this$.getVehiclepermitstructure();
        var vehicleList = this$.getVehicleList();
        var record = vehicleList.getSelectionModel().getSelection()[0];
        structure.down("#vehiclePermitCode").setValue(record.get("vehicleCode"));
        structure.down("#vehiclePermitType").setValue(record.get("vehicleSubTypeName"));
        structure.down("#vehiclePermitNo").setValue(record.get("vehicleNumber"));
        structure.down("#vehiclePermitId").setValue(record.get("id"));
        var store = grid.getStore();
   	    store.getProxy().extraParams = {
   			vehicleId : record.get("id")
   		};
   	    store.sorters.clear();
   	    store.load();
   	},
	getShowVehiclePermitWin:function(formMode){
   		var frmWin = this.getVehiclepermitdetailwin();
   		if(!frmWin){
   			Ext.widget('vehiclepermitdetailwin');
   			frmWin = this.getVehiclepermitdetailwin();
   		}
   		if(formMode == 'VIEW'){
   			var form =frmWin.down('form');
   			var submitBtn = form.down('#SubmitBtnVehiclePermit');
   			submitBtn.setVisible(false);
   			form = form.getForm();
   			toggleReadOnlyFormItems(form, true);
   			frmWin.doLayout()
   		}
   		frmWin.show();
   	},
   	
	getShowVehicleFitnessCertificateWin:function(formMode){
   		var frmWin = this.getFitnesscertificatewin();
   		if(!frmWin){
   			Ext.widget('fitnesscertificatewin');
   			frmWin = this.getFitnesscertificatewin();
   		}
   		if(formMode == 'VIEW'){
   			var form =frmWin.down('form');
   			var submitBtn = form.down('#SubmitBtnVehicleFitCertificate');
   			submitBtn.setVisible(false);
   			form = form.getForm();
   			toggleReadOnlyFormItems(form, true);
   			frmWin.doLayout()
   		}
   		frmWin.show();
   	},
   	
   	closeVehiclePermitWin:function(){
   		var frmWin = this.getVehiclepermitdetailwin();
   		frmWin.close();
   	},
   	saveVehiclePermitForm:function(){
   		var $this= this;
   		var grid = $this.getVehiclepermitgrid();
   		var win = $this.getVehiclepermitdetailwin();
		form =win.down('form');
		permitFormData = form.getValues();
   		
   		var structure = $this.getVehiclepermitstructure();
        var vehicleList = $this.getVehicleList();
        var record = vehicleList.getSelectionModel().getSelection()[0];
        var vehicleId = record.get("id");
        var submitUrl;
        if(isNullOrEmpty(permitFormData.id)){
        	submitUrl = SERVERURL.VEHICLE_PERMIT_CREATE;
        }else{
        	submitUrl = SERVERURL.VEHICLE_PERMIT_UPDATE;
        }
        
        var data = new Object();
      	
        data.entityId = null;
      	data.module = 'TRANSPORT';
      	data.entityType = 'DOCUMENT';
      	var uplaodUrl = SERVERURL.DOCUMENT_FILE_ADD;
      	form.getForm().submit({
      		method: 'POST',
      		async:false,
      		url: uplaodUrl,
      		success: function(form1, action) {
      			var responseData = Ext.decode(action.response.responseText);
      			var path = responseData.path;
      			
      			 var formData = new Object();
      			 formData.type ='DOCUMENT';
    			 formData.name = permitFormData.vehiclePermitDocument;
    			
      			$this.getDocumentController().saveDocumentFormValue(false, 'DOCUMENT', false, formData, path, function(success, response, isCallBackTransient){
      				if(success){
      				  var documentId = Ext.decode(response.responseText);
      				   var saveJson = new Object();
      				   var document = new Object();
      				   document.id = documentId;
      				   var vehicle = new Object();
      				   vehicle.id = vehicleId;
      				   saveJson.expirationDate =  permitFormData.expirationDate;
      				   saveJson.issuedBy = permitFormData.issuedBy;
      				   saveJson.permitNumber = permitFormData.permitNumber;
      				   saveJson.issueDate = permitFormData.issueDate;
      				   saveJson.permitDocument = document;
      				   saveJson.vehicle = vehicle;
      				    if(!isNullOrEmpty(permitFormData.id)){
      				    	saveJson.id=permitFormData.id;
      				    }
      				    
      				  var submitData = Ext.encode(saveJson);
      				    Ext.Ajax.request({
      				    	type : 'rest',
      				    	url : submitUrl,
      				    	jsonData: submitData,
      				    	method : 'POST',
      				    	success : function(response, action) {

      				    		this$.hideWindowMask();
      				    		$this.getVehiclepermitdetailwin().close();
      				    		grid.getStore().reload();
      				    		grid.getSelectionModel().deselectAll(true);
      				    		if(!isNullOrEmpty(permitFormData.id)) {
      				    			showSuccessMessage(getTransportTranslation('VEHICEL_PERMIT_DETAIL'),getTransportTranslation('VEHICLE_PERMIT_UPDATED_SUCCESSFULLY'));
      				    		} else {
      				    			showSuccessMessage(getTransportTranslation('VEHICEL_PERMIT_DETAIL'),getTransportTranslation('VEHICE_PERMIT_CREATED_SUCCESSFULLY'));
      				    		}
      				    	}
      				    });
      				}
      			});
      		}
      	});
   	},
   	deleteVehiclePermitGridData: function() {

		var this$ = this;
		var grid = this$.getVehiclepermitgrid();
		if (grid.getSelectionModel().getCount() > 0) {
			showConfirmMessage(getTransportTranslation('VEHICEL_PERMIT_DETAIL'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				if (btn == 'yes') {
					if (grid.getSelectionModel().getCount() > 0) {
						var records = grid.getSelectionModel().getSelection();
							var id = records[0].data.id;
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.VEHICLE_PERMIT_DELETE +"?id="+id,
								method: 'DELETE',
								headers: {
									'Content-Type': 'application/json'
								},
								success: function(form, action) {
									showSuccessMessage(getTransportTranslation('VEHICEL_PERMIT_DETAIL'), getTransportTranslation('VEHICLE_PERMIT_DELETE_SUCCESS'));
									grid.getStore().reload();
									this$.resetPageSetting(grid.getStore());
								}
							});
						
					}
				}
			});
		} else {
			showWarningMessage(getTransportTranslation('VEHICEL_PERMIT_DETAIL'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	editVehiclePermitData: function(formMode) {
		var this$ = this;
		var grid = this$.getVehiclepermitgrid();
		var records = grid.getSelectionModel().getSelection()[0];
		if(grid.getSelectionModel().getCount()>0){

			this$.getShowVehiclePermitWin(formMode);
			var win = this$.getVehiclepermitdetailwin();
			var form =win.down('form');
			var id = form.down('#id');
			var permitNumber = form.down('#permitNumber');
			var issueDate = form.down('#issueDate');
			var expirationDate = form.down('#expirationDate');
			var issuedBy = form.down('#issuedBy');
			var vehiclePermitDocument = form.down('#vehiclePermitDocument');
			permitNumber.setValue(records.data.permitNumber);
			issueDate.setValue(dateRender(records.data.issueDate));
			expirationDate.setValue(dateRender(records.data.expirationDate));
			issuedBy.setValue(records.data.issuedBy);
			vehiclePermitDocument.setValue(records.data.permitDocumentName);
			id.setValue(records.data.id);
		}else{
			showWarningMessage(getTransportTranslation('VEHICEL_PERMIT_DETAIL'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	viewVehiclePermitData:function(){
		var this$ = this;
		var grid = this$.getVehiclepermitgrid();
		var records = grid.getSelectionModel().getSelection()[0];
		if(grid.getSelectionModel().getCount()>0){
			this$.editVehiclePermitData('VIEW');
		}else{
			showWarningMessage(getTransportTranslation('VEHICEL_PERMIT_DETAIL'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	
	getOpenFitnessCertificate : function(){
		var grid = this.getVehicleList();
		if (grid.getSelectionModel().getCount() > 0) {
			var contentpanel = this.getContentPanel();
			var structure = Ext.widget('vehiclefitnesscertificatestructure');
			var tabName = getTransportTranslation('VEHICLE_FITNESS_CERTIFICATE');
			var getcontroller=this.getController('menu.CoreERPNavigationController');
			var getTab=getcontroller.getTab(tabName);
			if(getTab!=null){
				contentpanel.remove(getTab, true);
			}
			openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_ELEVEN);
		}else{
			showWarningMessage(getTransportTranslation('VEHICLE_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
		}
	},
	getRenderFitnessCertificate : function(grid){
		var this$ = this;
		var structure = this$.getVehiclefitnesscertificatestructure();
		var vehicleList = this$.getVehicleList();
		var record = vehicleList.getSelectionModel().getSelection()[0];
		structure.down("#vehiclePermitCode").setValue(record.get("vehicleCode"));
		structure.down("#vehiclePermitType").setValue(record.get("vehicleSubTypeName"));
		structure.down("#vehiclePermitNo").setValue(record.get("vehicleNumber"));
		structure.down("#vehiclePermitId").setValue(record.get("id"));
		var store = grid.getStore();
		store.getProxy().extraParams = {
			vehicleId : record.get("id")
		};
		store.sorters.clear();
		store.load();
	},
	saveVehicleFitCertificateForm:function(){
		var $this= this;
		var grid = $this.getFitnesscertificategrid();
		var win = $this.getFitnesscertificatewin();
		form =win.down('form');
		permitFormData = form.getValues();

		var structure = $this.getVehiclefitnesscertificatestructure();
		var vehicleList = $this.getVehicleList();
		var record = vehicleList.getSelectionModel().getSelection()[0];
		var vehicleId = record.get("id");
		var submitUrl;
		if(isNullOrEmpty(permitFormData.id)){
			submitUrl = SERVERURL.VEHICLE_FITNESS_CERTIFICATE_CREATE;
		}else{
			submitUrl = SERVERURL.VEHICLE_FITNESS_CERTIFICATE_UPDATE;
		}

		var data = new Object();

		data.entityId = null;
		data.module = 'TRANSPORT';
		data.entityType = 'DOCUMENT';
		var uplaodUrl = SERVERURL.DOCUMENT_FILE_ADD;
		form.getForm().submit({
			method: 'POST',
			async:false,
			url: uplaodUrl,
			success: function(form1, action) {
				var responseData = Ext.decode(action.response.responseText);
				var path = responseData.path;

				var formData = new Object();
				formData.type ='DOCUMENT';
				formData.name = permitFormData.vehicleFitCertificateDocument;

				$this.getDocumentController().saveDocumentFormValue(false, 'DOCUMENT', false, formData, path, function(success, response, isCallBackTransient){
					if(success){
						var documentId = Ext.decode(response.responseText);
						var saveJson = new Object();
						var document = new Object();
						document.id = documentId;
						var vehicle = new Object();
						vehicle.id = vehicleId;
						saveJson.expiryDate =  permitFormData.expirationDate;
						saveJson.issuedBy = permitFormData.issuedBy;
						saveJson.certifiedBy = permitFormData.certifiedBy;
						saveJson.issueDate = permitFormData.issueDate;
						saveJson.fitnessDocument = document;
						saveJson.vehicle = vehicle;
						if(!isNullOrEmpty(permitFormData.id)){
							saveJson.id=permitFormData.id;
						}

						var submitData = Ext.encode(saveJson);
						Ext.Ajax.request({
							type : 'rest',
							url : submitUrl,
							jsonData: submitData,
							method : 'POST',
							success : function(response, action) {

								this$.hideWindowMask();
								$this.getFitnesscertificatewin().close();
								grid.getStore().reload();
								grid.getSelectionModel().deselectAll(true);
								if(!isNullOrEmpty(permitFormData.id)) {
									showSuccessMessage(getTransportTranslation('VEHICEL_FITNESS_CERTIFICATE_DETAIL'),getTransportTranslation('VEHICLE_FITNESS_CERTIFICATE_UPDATED_SUCCESSFULLY'));
								} else {
									showSuccessMessage(getTransportTranslation('VEHICEL_FITNESS_CERTIFICATE_DETAIL'),getTransportTranslation('VEHICE_FITNESS_CERTIFICATE_CREATED_SUCCESSFULLY'));
								}
							}
						});
					}
				});
			}
		});
	},
	closeVehicleFitnessCertificateWin:function(){
		var frmWin = this.getFitnesscertificatewin();
		frmWin.close();
	},

	editVehicleFitnessCertificateRecords: function(formMode) {
		var this$ = this;
		var grid = this$.getFitnesscertificategrid();
		var records = grid.getSelectionModel().getSelection()[0];
		if(grid.getSelectionModel().getCount()>0){

			this$.getShowVehicleFitnessCertificateWin(formMode);
			var win = this$.getFitnesscertificatewin();
			var form =win.down('form');
			var id = form.down('#id');
			var certifiedBy = form.down('#certifiedBy');
			var issueDate = form.down('#issueDate');
			var expirationDate = form.down('#expirationDate');
			var vehicleFitCertificateDocument = form.down('#vehicleFitCertificateDocument');

			certifiedBy.setValue(records.data.certifiedBy);

			issueDate.setValue(dateRender(records.data.issueDate));
			expirationDate.setValue(dateRender(records.data.expiryDate));
			vehicleFitCertificateDocument.setValue(records.data.fitnessDocumentName);
			id.setValue(records.data.id);
		}else{
			showWarningMessage(getTransportTranslation('VEHICEL_FITNESS_CERTIFICATE_DETAIL'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},

	viewVehicleFitnessCertificateRecords:function(){
		var this$ = this;
		var grid = this$.getFitnesscertificategrid();
		var records = grid.getSelectionModel().getSelection()[0];
		if(grid.getSelectionModel().getCount()>0){
			this$.editVehicleFitnessCertificateRecords('VIEW');
		}else{
			showWarningMessage(getTransportTranslation('VEHICEL_FITNESS_CERTIFICATE_DETAIL'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},

	deleteVehicleFitnessCertificateGridData: function() {

		var this$ = this;
		var grid = this$.getFitnesscertificategrid();
		if (grid.getSelectionModel().getCount() > 0) {
			showConfirmMessage(getTransportTranslation('VEHICEL_FITNESS_CERTIFICATE_DETAIL'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				if (btn == 'yes') {
					if (grid.getSelectionModel().getCount() > 0) {
						var records = grid.getSelectionModel().getSelection();
						var id = records[0].data.id;
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.VEHICLE_FITNESS_CERTIFICATE_DELETE +"?id="+id,
							method: 'DELETE',
							headers: {
								'Content-Type': 'application/json'
							},
							success: function(form, action) {
								showSuccessMessage(getTransportTranslation('VEHICEL_FITNESS_CERTIFICATE_DETAIL'), getTransportTranslation('VEHICLE_FITNESS_CERTIFICATE_DELETE_SUCCESS'));
								grid.getStore().reload();
								this$.resetPageSetting(grid.getStore());
							}
						});

					}
				}
			});
		} else {
			showWarningMessage(getTransportTranslation('VEHICEL_FITNESS_CERTIFICATE_DETAIL'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},

});
