Ext.define('Academia.model.admission.applicationFormSale.AddProgramGridModel', {
	extend: 'Ext.data.Model',
	fields: ['id', 'version', 'programBatchSeatConfigurationId', 'academy', 'academy.value', 'location', 'location.value', 'program', 'program.value',
		'batch', 'batch.value', 'seatType', 'seatType.value', 'priority', 'feeAmount', 'programGroupId', 'academyLocationId', 'currentStatus', 'distancetoTravel',
		'whetherHostelApplicable', 'whetherTransportApplicable', 'academicTerm',
		{
			name: 'schoolAttendanceStartDate',
			type: 'date',
			convert: function(v, record) {

				if (!v) {
					return null;
				}

				if (Ext.isDate(v)) {
					return v;
				}

				if (Ext.isNumber(v)) {
					return new Date(v); // ⭐ handle timestamp
				}

				var str = record.raw && record.raw.schoolAttendanceStartDateString;
				if (!str) {
					return null;
				}

				var parts = str.split('-');
				return new Date(parts[0], parts[1] - 1, parts[2]);
			}
		},
		'deliveryMode', 'registrationType', 'programPriority',
		{
			name: 'isAdmissionDone',
			type: 'boolean',
			defaultValue: false
		}, {

			name: 'disabled',
			type: 'boolean',
			defaultValue: false
		}, 'programStageDetails', 'stageStatus', 'stageName', 'selectionProcess', 'selectionProcess.value', 'offerLetterIssuedFileName',
		'applicationProgramDetailId', 'modeOfDelivery', 'modeOfDelivery.value', 'batchPartTime', 'programGroupName', 'applicationCode', 'applicationId',
		'isCurrentApplication', 'applicantPersonId', 'programGroupName', 'provisionalOfferLetterIssuedFileName', 'applicationProgramDetailIdForProvisional',
		'provisionalOfferLetter', 'idtype', 'nationalID', 'offerLetterExpiryDate', 'admissionStatus', 'preserveStatus', 'eligibilityStatus']
});