/**
 * This model is used for work time slot
 */
Ext.define('Academia.model.calendar.WorkTimeSlotModel', {
	 extend : 'Academia.model.VersionableDataModel',
	 fields: ['dbId','slotPurpose',{name: 'startTime'},
	          {name: 'endTime'},
	          'parentId', 'wsCalendarId', 'wsCalendarWeekDayId', 'period', 'weekday','breakName','calendar',
	          {name: 'sortStartTime',
	        	  convert : function (v, rec) {
	        		  if(!isNullOrEmpty(rec.get('startTime')) && typeof rec.get('startTime') != "object") {
	        			  return new Date("01/01/1970 "+rec.get('startTime'));
	        		  } else {
	        			  return rec.get('startTime');
	        		  }
	              },
	        	  },{
	        		  name: 'sortEndTime',
		        	  convert : function (v, rec) {
		        		  if(!isNullOrEmpty(rec.get('endTime')) && typeof rec.get('endTime') != "object") {
		        			  return new Date("01/01/1970 "+rec.get('endTime'));
		        		  } else {
		        			  return rec.get('endTime');
		        		  }
		              }
	        	  }]
});