Ext.define('Academia.model.feeandpayment.StudentPaymentPlanEnrollmentModel', {
	extend : 'Ext.data.Model',
	fields : [ 'id','value','code','isCurrentPeriodOfProgram','whetherCurrentAcademicTerm','academicTermId','whetherAllowed',{
        name    : 'valueCode', 
        convert : function (v, rec) {
           return rec.get('code') + ' / ' + rec.get('value');
        }
    },{
        name    : 'displayValue', 
        convert : function (v, rec) {
        	if(!isNullOrEmpty(rec.get('value'))){
				return Ext.String.trim(rec.get('value'));
        	}else{
        		 return null;
        	}
          
        },
        
    },{
        name    : 'camelCaseValue', 
        convert : function (v, rec) {
        	if(!isNullOrEmpty(rec.get('value'))){
        		 return rec.get('value').replace(/(?:^\w|[A-Z]|\b\w|\s+)/g, function(match, index) {
         		    if (+match === 0) return "";
         		    return index == 0 ? match.toUpperCase() : match.toLowerCase();
         	 });
        	} else {
        		 return null;
        	}
        }
    },{
        name    : 'codeValue', 
        convert : function (v, rec) {
           return rec.get('value') + ' / ' + rec.get('code');
        }
    },{
        name    : 'valueSecondValue', 
        convert : function (v, rec) {
           return rec.get('value') + ' / ' + rec.get('secondValue');
        }
    }, 'secondValue', 'doubleValue', 'check', 'secondCode','secondCheck','sequence','sectionAtComponentLevel','courseId',
    'parentCourseId', 'componentId', 'activeStatus','secondId'
    ,'uiDisplayCode' 
    ]
});