//DMSSiteStore
/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.store.DMSStore.DMSSiteUserListStore', {
	extend : 'Ext.data.Store',
	fields:[
		'userActivityId',
		{
			name: 'authorityType',
			convert: function(value, record){
				try{
					return record.raw.authority.authorityType
				}
				catch(e){
					return value;
				}
			}
		},
		{
			name: 'firstName',
			convert: function(value, record){
				try{
					return record.raw.authority.firstName
				}
				catch(e){
					return value;
				}
			}
		},
		{
			name: 'fullName',
			convert: function(value, record){
				try{
					return record.raw.authority.fullName
				}
				catch(e){
					return value;
				}
			}
		},
		{
			name: 'lastName',
			convert: function(value, record){
				try{
					return record.raw.authority.lastName
				}
				catch(e){
					return value;
				}
			}
		},
		{
			name: 'authorityUrl',
			convert: function(value, record){
				try{
					return record.raw.authority.url
				}
				catch(e){
					return value;
				}
			}
		},
		{
			name: 'userName',
			convert: function(value, record){
				try{
					return record.raw.authority.userName
				}
				catch(e){
					return value;
				}
			}
		},
		'isMemberOfGroup',
		{
			name: 'role',
			convert: function(value, record){
				var idValueArray = {
					SiteManager: 'Manager',
					SiteCollaborator: 'Collaborator',
					SiteContributor: 'Contributor',
					SiteConsumer: 'Consumer'
				};
				if(!isNullOrEmpty(idValueArray[value])){
					return idValueArray[value];
				}
				else{
					return value;
				}
			}
		},
		'url',
		'isEditable'
	],
	autoLoad : false,
	proxy : {
		type : 'rest',
		api : {
			read : SERVERURL.PATH_GET_SITE_USERS
		},
        reader: {
            type: 'json'
        }
	}
});
