/**
 * This store is used for student fee and payment dashboard report tree panel
 * @author Bhanu Pratap Singh
 * @author Rajkumar Patidar
 * 
 */

Ext.define('Academia.store.admission.reports.AdmissionReportTreeStore', {
	extend : 'Ext.data.TreeStore',
	alias: 'widget.admissionreporttreestore',
	itemId:'admissionreporttreestoreId',
	fields: ['reportXtype', 'reportXtypeItemId', 'text','permissionKey'],
	root: {
		success: true,
		children: [/*Removed OKR-2214*//*{
			text : getAdmissionTranslation('ADMISSION_STATISTICS'),
			reportXtype: 'admissionstatisticsview',
			reportXtypeItemId: 'admissionStatisticsView',
			permissionKey: 'ADMISSION_STATISTICS_REPORT',
			expanded: true,
			id:1,
			leaf: false
		},{
			text : getAdmissionTranslation('APPLICATION_STATISTICS'),
			reportXtype: 'applicationstatisticsview',
			reportXtypeItemId: 'applicationStatisticsView',
			permissionKey: 'APPLICATION_STATISTICS_REPORT',
			expanded: true,
			id:2,
			leaf: false
		},*/{
			text : getAdmissionTranslation('ADMISSION_REJECTION_ANALYSIS'),
			reportXtype: 'admissionrejectionanalysisview',
			reportXtypeItemId: 'admissionRejectionAnalysisView',
			permissionKey: 'ADMISSION_REJECTION_ANALYSIS_REPORT',
			leaf: false,
			id:1,
			expanded: true
		},{
			text : getAdmissionTranslation('SELECTION_PROCESS_OVERVIEW'),
			reportXtype: 'selectionprocessoverviewview',
			reportXtypeItemId: 'selectionProcessOverviewView',
			permissionKey: 'SELECTION_PROCESS_OVERVIEW_REPORT',
			leaf: false,
			id:2,
			expanded: true
			/* },{
		    	text: getEnquiryTranslation('CLOSUR_RATE'),
		    	reportXtype: 'admissiondemographicsview',
		    	reportXtypeItemId: 'admissionDemographicsView',
		        leaf: false,
		        expanded: true*/
		},{
			text : getAdmissionTranslation('ADDMISSION_DASHBOARD_APPLICATION_SUMMARY'),
			reportXtype: 'applicationsummarystructure',
			reportXtypeItemId: 'applicationsummarystructure',
			permissionKey: 'APPLICATION_SUMMARY_REPORT',
			leaf: false,
			id:3,
			expanded: true
		},{
			text : getAdmissionTranslation('ADMISSIONS_SUMMARY_BY_ADMISSIONS_DATE'),
			reportXtype: 'admissionsummarystructure',
			reportXtypeItemId: 'admissionsummarystructure',
			permissionKey: 'ADMISSION_SUMMARY_BY_DATE_REPORT',
			leaf: false,
			id:4,
			expanded: true
		},{
			text : getAdmissionTranslation('ADMISSIONS_SUMMARY_BY_APPROVED_DATE'),
			reportXtype: 'admissionsummaryapprovedstructure',
			reportXtypeItemId: 'admissionsummaryapprovedstructure',
			permissionKey: 'ADMISSION_SUMMARY_BYAPPROVE_DATE_REPORT',
			leaf: false,
			id:5,
			expanded: true
		},{
			text : getAdmissionTranslation('APPLICATION_COMMENTS'),
			reportXtype: 'applicationcommentsstructure',
			reportXtypeItemId: 'applicationcommentsstructure',
			permissionKey: 'APPLICATION_COMMENTS_REPORT',
			leaf: false,
			id:6,
			expanded: true
		}]
	}
});

