/**
 * Live search combo details store
 */
Ext.define('Academia.store.common.LiveSearchCombos',{
	extend:'Ext.data.Store',
	alias : 'livesearchcombos',
	model : 'Academia.model.common.LiveSearchComboModel',	
	pageSize : 5,	
	autoLoad : false,
	proxy : {
		type : 'rest',
		api : {
			read : SERVERURL.APPROVAR_DATA 

		},
		reader : {
			type : 'json'
			
		}
	},
	sorters: [{
        property:   'printName',
        direction:  'ASC',
        transform:  function (displayName) { return displayName.toLowerCase(); }
    }],
	
    listeners: {
    	beforeload:{
    		 element: 'el',
             fn: function(store, records, successful, eOpts) {
                 var academyLocationId = Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue();
                 store.getProxy().extraParams = {
                	 academyLocationId:academyLocationId
                 };   
             } 
    	},
        load: {
            element: 'el',
            fn: function(store, records, successful, eOpts) {
                var me = this;
                for (var count = 0; count < records.length; count++) {
                    var record = records[count];
                    var concatValue = "";
                    concatValue = record.get('code') + ' / '+  record.get('printName');

                    //  concatValue = me.concatValue(concatValue, record, 'salutation.value');
                    /*concatValue = me.concatValue(concatValue, record, 'code');
                    concatValue = me.concatValue(concatValue, record, 'printName');*/
                    //concatValue = me.concatValue(concatValue, record, 'lastName');
                   // concatValue = me.concatBracketWithValue(concatValue, record, 'department');
                    records[count].set('value', concatValue);
                }
                /*store.sort('value');*/
                store.commitChanges();
            }
        } 
     
    },
    concatValue: function(concatValue, record, key) {
        var value = record.get(key);
        if (!isNullOrEmpty(value)) {
            concatValue = concatValue.concat(" / " + value);
            return concatValue;
        } else {
            return concatValue;
        }
    },
    concatBracketWithValue : function (concatValue, record, key){
    	var value = record.get(key);
        if (!isNullOrEmpty(value)) {
            concatValue = concatValue.concat("["+value+"]");
            return concatValue;
        } else {
            return concatValue;
        }
    }

});
