/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.store.facilitiesresources.managegallery.ShareAlbumStore', {
    extend: 'Ext.data.Store',
    fields: [
        { name:'id', type:'string' },
        { name:'batchId', type:'string' },
        { name:'academyLocationName', type:'string' },
        { name:'programName', type:'string' },
        { name:'batchName', type:'string' },
        { name:'sectionName', type:'string' },
        { name:'academicTerm', type:'string' },
        { name:'coursePrintName', type:'string' },
        { name:'courseVariant', type:'string' },
        { 
        	name:'isSharedWithFaculty', 
        	convert : function (v, rec) {
        		if(!isNullOrEmpty(v)){
        			try{
            			return (v==true) ? 'Yes' : 'No';
        			}
        			catch(e){
            			return 'No';
        			}
        		}else{
        			return 'No';
        		}
        	}
        },
        { 
        	name:'isSharedWithStudent', 
        	convert : function (v, rec) {
        		if(!isNullOrEmpty(v)){
        			try{
            			return (v==true) ? 'Yes' : 'No';
        			}
        			catch(e){
            			return 'No';
        			}
        		}else{
        			return 'No';
        		}
        	}
        },
        { 
        	name:'isSharedWithParent', 
        	convert : function (v, rec) {
        		if(!isNullOrEmpty(v)){
        			try{
            			return (v==true) ? 'Yes' : 'No';
        			}
        			catch(e){
            			return 'No';
        			}
        		}else{
        			return 'No';
        		}
        	}
        },{ 
        	name:'isSharedWithAlumni', 
        	convert : function (v, rec) {
        		if(!isNullOrEmpty(v)){
        			try{
            			return (v==true) ? 'Yes' : 'No';
        			}
        			catch(e){
            			return 'No';
        			}
        		}else{
        			return 'No';
        		}
        	}
        }
    ],
    autoLoad: false,
    remoteSort: false,
    proxy: {
        type: 'rest',
        method: 'GET',
        api: {
            read: SERVERURL.PATH_GRID_SHARED_BATCH_MAPPING
        },
        reader: {
            type: 'json',
            root: 'rows',
            totalProperty: 'records'
        }
    }
});
