/**
 * @author Dharmendra.p
 */
Ext.define('Academia.store.hostel.hostelattendance.HostelMarkAttendanceGridStr', {
	extend : 'Ext.data.Store',
	model : 'Academia.model.hostel.hostelattendance.HostelMarkAttendanceGridMdl',
	autoLoad : false,
	proxy : {
		type : 'rest',
		api:{
			read:SERVERURL.HOSTEL_ATTENDANCE_OCCUPANT_LIST
		},
		reader: {
			type:'json',
			root: 'rows',
			totalProperty: 'records'
				
		}
	},
	listeners: {
		load: {
			fn: function(store, records, successful, eOpts) {                 
				for (var count = 0; count < records.length; count++) {
					var record = records[count];
					var key=record.get('attendanceStatus');
					if(!isNullOrEmpty(key)){
						records[count].set('attendanceStatus', getCommonTranslation(key));
					}
					records[count].set('rawObj', record);
				}
				store.commitChanges();
			}
		}
	}

});