/**
 * This store is used for student request dashboard report tree panel
 * @author Sachin.Bangar
 */
Ext.define('Academia.store.reports.servicerequest.FacultyRequestReportTreeStore', {
	extend : 'Ext.data.TreeStore',
	fields: ['reportXtype', 'reportXtypeItemId', 'text'],
	root: {
        success: true,
        children: [{
        	text: getServiceRequestTranslation('EMPLOYEE_REQUEST'),
        	reportXtype: '',
        	reportXtypeItemId: '',
            leaf: false,
            expanded: true,
            children: [{
            	text: getServiceRequestTranslation('UNASSIGNED_REQUESTS'),
            	reportXtype: 'facultyunassignedrequestview',
            	reportXtypeItemId: 'facultyUnassignedRequestView',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('FOLLOW_UP_SCHEDULED'),
            	reportXtype: 'facultyfollowupscheduledview',
            	reportXtypeItemId: 'facultyFollowUpScheduledView',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('REQUEST_CLOSURE_RATE'),
            	reportXtype: 'facultyrequestclosurerateview',
            	reportXtypeItemId: 'facultyRequestClosureRateView',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('COUNT_OF_REQUEST'),
            	reportXtype: 'facultycountrequestview',
            	reportXtypeItemId: 'facultyCountOfRequestView',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('SERVICE_LEVEL_GRAPH'),
            	reportXtype: 'facultyservicelevelview',
            	reportXtypeItemId: 'facultyServiceLevelView',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('CLOSURE_REASON'),
            	reportXtype: 'facultyclosurereasonview',
            	reportXtypeItemId: 'facultyClosureReasonView',
                leaf: true
            }]
        }]
    }
});