Ext.define('Academia.store.securitysetup.ActiveLockedAndUnLockedRolesStore',{
	extend:'Ext.data.Store',
	model : 'Academia.model.common.IdValueDataModel',
	autoLoad : false,
	proxy : {
		type : 'rest',
		api : {
			read : SERVERURL.ROLE_FIND_ALL_ACTIVE_ROLE
		},
		reader : {
			type : 'json'
		}
	},
	listeners: {
    load: {
        element: 'el',
        fn: function(store, records, successful, eOpts) {
            for (var count = 0; count < records.length; count++) {
                records[count].set('value', getCommonTranslation(records[count].get("value")));
            }
            store.commitChanges();
            
            store.clearFilter(true);
            if(!isNullOrEmpty(store.lastOptions.params)){
            	if(!isNullOrEmpty(store.lastOptions.params.roleName)){
            		var queryVal = store.lastOptions.params.roleName.replace(/%/g, '');
                	store.filter({
                		property: 'value',
                		value: queryVal,
                		anyMatch: true,
                		caseSensitive: false
                	});
                	store.commitChanges();
            	}
            	else if(!isNullOrEmpty(store.lastOptions.params.query)){
            		var queryVal = store.lastOptions.params.query.replace(/%/g, '');
                	store.filter({
                		property: 'value',
                		value: queryVal,
                		anyMatch: true,
                		caseSensitive: false
                	});
                	store.commitChanges();
            	}
            	
            }
        }
    }
}
});

