/**

 * @author Ravi Choudhary
 * code changed to set date format of date value same as in organization settings
 * @param val(i.e. must be of type java.util.Date)
 * @returns date (formatted date)
 */
//function dateRender(val){         
//    var date="";
//    var displayFormatMap = Academia.utilities.DisplayFormatMap;
//    var orgModel = Academia.model.common.OrgSettingDateTimeModel;
//    var currentDateFormat = orgModel.get('dateFormat');
//	var format = displayFormatMap.getDisplayFormat(currentDateFormat);
//    if(val instanceof Date){
//    	date=Ext.Date.format(val, format);
//    } else if(!isNullOrEmpty(val)){
//    	var dateToFormat = new Date(val);
//    	date=Ext.Date.format(dateToFormat, format);
//    }
//    return date;
//};

function dateRender(val) {
    var date = "";
    var displayFormatMap = Academia.utilities.DisplayFormatMap;
    var orgModel = Academia.model.common.OrgSettingDateTimeModel;
    var currentDateFormat = orgModel.get('dateFormat');
    var format = displayFormatMap.getDisplayFormat(currentDateFormat);

    try{
        if (val instanceof Date) {
            date = Ext.Date.format(val, format);
        } else if (!isNullOrEmpty(val)) {
            // Check if val is already in d-m-y format using regex
            var dmyRegex = /^\d{1,2}-\d{1,2}-\d{4}$/;
            if (dmyRegex.test(val)) {
                date = val; // Already in correct format, return as-is
            } else {
                // Try to parse and format
                var dateToFormat = new Date(val);
                if (!isNaN(dateToFormat.getTime())) {
                    date = Ext.Date.format(dateToFormat, format);
                } else {
                    date = val; // If date parsing fails, return the original
                }
            }
        }
    }
    catch(e){
    	//-
    }
    return date;
}


/**
 * @author Ravi Choudhary
 * used to set date format of date field same as in organization settings
 * @param val as date field (i.e. which have xtype=datefield)
 * @returns date format
 */
function dateFormatRender(val) {
	var displayFormatMap = Academia.utilities.DisplayFormatMap;
	var orgModel = Academia.model.common.OrgSettingDateTimeModel;
	var currentDateFormat = orgModel.get('dateFormat');
	var format = displayFormatMap.getDisplayFormat(currentDateFormat);
	val.format = format;
	return val;
};

/**
 * @author Ravi Choudhary
 * used to set date format of time field same as in organization settings
 * @param val as time field (i.e. which have xtype=timefield)
 * @returns time
 */
function timeFormatRender(val) {
	var displayFormatMap = Academia.utilities.DisplayFormatMap;
	var orgModel = Academia.model.common.OrgSettingDateTimeModel;
	var currentTimeFormat = orgModel.get('timeFormat');
	var format = displayFormatMap.getDisplayFormat(currentTimeFormat);
	val.format = format;
	return val;
};
function statusRender(value){       
	if (value) {
	    return value = 'Active';
	} else {
	    return value = 'Inactive';
	}
};

function statusYesNoRender(value){       
	if (value) {
	    return value = 'Yes';
	} else {
	    return value = 'No';
	}
};

function publishMarsheetStatusRender(value){       
	if (value) {
	    return value = 'Published';
	} else {
	    return value = 'Not Published';
	}
};

/**
This function is used to render currency value
*/
function currencyRender(value){     
	var currency="";	
    if(value){
    	currency=Ext.util.Format.number(value,'0,0.00');
    	return currency;   
    }else{
    	return value;
    }
    //CONSTANTS.CURRENCY_SIGN,CONSTANTS.CURRENCY_PRECISION
};

/**
This function is used to render combo object value
*/
function comboRender(object,type){         
	var returnValue=" ";	
	if(object instanceof Object){
		if(!isNullOrEmpty(object[type])){			
			returnValue=object[type];
		}		
		return returnValue; 
	}else{
		return returnValue;
	}
};

/**
This function is used to render column data index object value
*/
function columnObjRender(object,type){         
	var returnValue="";
	if(object instanceof Object){
		if(!isNullOrEmpty(object[type])){			
			returnValue=object[type];
		}		
		return returnValue; 
	}else{
		return returnValue;
	}
};

/**
This function is used to render column data index object value
*/
function twoLevelObjRender(object, firstLevelType, type){
	var returnValue="";
	if(object instanceof Object){
		if(!isNullOrEmpty(object[firstLevelType])){
			if(!isNullOrEmpty((object[firstLevelType])[type])){			
				returnValue=(object[firstLevelType])[type];
			}		
		}		
		return returnValue; 
	}else{
		return returnValue;
	}
};

function isArray(object)
{
	if (object.constructor === Array) 
    	return true;
    else 
    	return false;
}

/**
 * @author Ravi Choudhary
 * used to set time format of time same as in organization settings
 * @param val as time in date time-stamp format
 * @returns time
 */
function timeRender(val){         
	var time="";
	var displayFormatMap = Academia.utilities.DisplayFormatMap;
	var orgModel = Academia.model.common.OrgSettingDateTimeModel;
	var timeFormat = orgModel.get('timeFormat');
	var format = displayFormatMap.getDisplayFormat(timeFormat);
	if(val instanceof Date){
		time=Ext.Date.format(val, format);
	} else if(!isNullOrEmpty(val)) {
		var timeToFormat = new Date(val);
		time=Ext.Date.format(timeToFormat, format);
	}
	return time;
};

function minuteToTimeRender(obj) {
	var v1 = parseFloat(obj);
	var hr=v1/60,min=v1%60;
	hr=parseInt(hr);
	var sec = min - Math.floor(min);
	sec=parseInt(sec*100);
	min=parseInt(min);
	if(sec>60)
		min=min+1;
//	min=min.toFixed(2);
	return hr+" : "+min; 
}


function minuteToHour(obj) {
	var v1 = parseFloat(obj);
	var hr=v1/60;
	return hr; 
}

/**
This function is used to set all items of form to read only mode.
@param {view} form: is the form that has to be changed to a readOnly mode,
@param {boolean} readOnly: is the boolean value, true to make readOnly,
 false for setting the readOnly property to false.
*/
function toggleReadOnlyFormItems (form,readOnly) {
	Ext.suspendLayouts();

	try{
		// Apply or remove the read-only class to the form
		var formPanel = form.owner; // Assuming 'form' is form.getForm()
		if (readOnly) {
			formPanel.addCls('readonly-form');  // Add the read-only class
		} else {
			formPanel.removeCls('readonly-form');  // Remove the read-only class
		}
	}
	catch(e){
		//---
	}

	form.getFields().each(function(field) {    	
		if(field.xtype !== 'itemselector' && field.xtype != 'multiselectfield' && field.xtype != 'filefield') {
			field.setReadOnly(readOnly);
			if(field.xtype == 'multiselectcombofield') {
				try {
					Ext.defer(function() {
						if(!isNullOrEmpty(field.el.dom.querySelector('input'))){
							field.el.dom.querySelector('input').readOnly = true;
						}
					}, 500);
				}
				catch(e) {
					console.log(e);
				}
			}
			if(field.editable == false && field.xtype == 'datefield') {
				field.el.dom.querySelector('input').setAttribute('readOnly', true);
				field.on('writeablechange', function(cmp, read) {
					if(!read) {
						cmp.el.dom.querySelector('input').setAttribute('readOnly', true);
					}
				});
			}
		} else {
			field.setDisabled(true);
		}
	});
	Ext.resumeLayouts();
};
  
  /*
   * This Function is used for to open tab on main content panel.
   * 
   * parameters-:
   * contentPanel=Pass reference of main content panel
   * tabName=pass string value as tab name
   * childItem=pass object/string which contain inside tab
   * 
   * */
  function openTab(contentPanel,tabName,childItem,menuColorcls){	
  	if(contentPanel!=undefined){
  		var newTab = contentPanel.items.findBy( function(tab) {
  			return tab.title === tabName;
  		 });
  		
  		if(!newTab){
  			if(childItem.xtype=="studentvoteinelectionstructure"){
  				newTab =Ext.create('Ext.panel.Panel',{
 	  				 closable:true,										 
 	  				 title: tabName,
 	  				 autoScroll:true,
 	  				 menuColorCls: menuColorcls,
 	  				 items:[childItem],
 	  				 scrollable: false
 	  			}); 
	  		} else if(childItem.xtype=="courseReportCourseVariantsAssociatedStructure" || childItem.xtype=="courseReportTopicsCreatedStructure" || childItem.xtype=="courseReportCourseComponentAssociatedStructure"){
	  			newTab =Ext.create('Ext.panel.Panel',{
	  				 closable:true,										 
	  				 title: tabName,
	  				 autoScroll:false,
	  				 menuColorCls: menuColorcls,
	  				 items:[childItem]
	  			}); 
	  		} else if(childItem.xtype=="businessruleform" || childItem.xtype=="homeworkstructure" || childItem.xtype=="programperiodtermgrid") {
	  			newTab =Ext.create('Ext.panel.Panel',{
 	  				 closable:true,										 
 	  				 title: tabName,
 	  				 menuColorCls: menuColorcls,
 	  				 overflowY: 'auto',
 	  				 overflowX: 'hidden',
 	  				 layout: 'vbox',
 	  				 defaults: {
 	  					 width: '100%'
 	  				 },
 	  				 items:[childItem]
 	  			});
	  		} else if(childItem.xtype=="evaluationdetailtabstructure" || childItem.xtype=="businessruleapplytoproceedstructure" || childItem.xtype=="businessruleapplytocourseaddstructure" || childItem.xtype=="businessruleapplytostudentgroupstructure" || childItem.xtype=="businessruleapplytostudentgroupaddstructure") {
	  			newTab =Ext.create('Ext.panel.Panel',{
	  				 closable:true,										 
	  				 title: tabName,
	  				 menuColorCls: menuColorcls,
	  				 layout: 'vbox',
	  				 defaults: {
	  					 width: '100%',
	  					 flex: 1
	  				 },
	  				 items:[childItem]
	  			});
	  		} else if(childItem.xtype=="periodactivitydateslist") {
	  			newTab =Ext.create('Ext.panel.Panel',{
	  				 closable:true,										 
	  				 title: tabName,
	  				 menuColorCls: menuColorcls,
	  				 layout: 'vbox',
	  				 defaults: {
	  					 width: '100%',
	  					 flex: 1
	  				 },
	  				 items:[childItem, {
	  			    	xtype: 'fieldcontainer',
	  			    	width: 'auto',
	  			    	items: [{
	  			    		xtype: 'button',
	  			    		text: getCommonTranslation('SAVE'),
	  			    		itemId: 'activityGridSaveBtn',
	  			    		buttonAlign: 'left',
	  			    		ui: 'CustomBtnSubmit',
	  			    		scale: CONSTANTS.BUTTONSIZE,
	  			    		style: {
	  	    	    			'margin-left': '7px !important;'
	  	    	    		},
	  			    	},{
	  			    		xtype: 'button',
	  			    		itemId: 'activityGridResetBtn',
	  			    		text: getCommonTranslation('RESET'),
	  			    		ui:'CustomBtnCancel',
	  			    		scale: CONSTANTS.BUTTONSIZE
	  			    	}]
	  			    }]
	  			});
	  		}else if(childItem.xtype=="servicerequestsetupdateslist"){

	  			newTab =Ext.create('Ext.panel.Panel',{
	  				 closable:true,										 
	  				 title: tabName,
	  				 menuColorCls: menuColorcls,
	  				 layout: 'vbox',
	  				 defaults: {
	  					 width: '100%',
	  					 flex: 1
	  				 },
	  				 items:[childItem, {
	  			    	xtype: 'fieldcontainer',
	  			    	width: 'auto',
	  			    	items: [{
	  			    		xtype: 'button',
	  			    		text: getCommonTranslation('SAVE'),
	  			    		itemId: 'serviceRequestSetupGridSaveBtn',
	  			    		buttonAlign: 'left',
	  			    		ui: 'CustomBtnSubmit',
	  			    		scale: CONSTANTS.BUTTONSIZE,
	  			    		style: {
	  	    	    			'margin-left': '7px !important;'
	  	    	    		},
	  			    	},{
	  			    		xtype: 'button',
	  			    		itemId: 'serviceRequestSetupGridResetBtn',
	  			    		text: getCommonTranslation('RESET'),
	  			    		ui:'CustomBtnCancel',
	  			    		scale: CONSTANTS.BUTTONSIZE
	  			    	}]
	  			    }]
	  			});
	  		
	  		}
	  		else if(childItem.xtype=="manageevalgrouptabstructure") {
	  			newTab =Ext.create('Ext.panel.Panel',{
 	  				 closable:true,										 
 	  				 title: tabName,
 	  				 overflowX: 'hidden',
 	  				 overflowY: 'auto',
 	  				 menuColorCls: menuColorcls,
 	  				 items:[childItem]
 	  			}); 
	  		}
	  		else if(childItem.xtype == "questionpaperbankdetails" || childItem.xtype == "alumnicommitteapplytotabstructure") {
	  			newTab =Ext.create('Ext.panel.Panel',{
 	  				 closable:true,										 
 	  				 title: tabName,
 	  				 menuColorCls: menuColorcls,
 	  				 layout: 'fit',
 	  				 items:[childItem]
 	  			});
	  		}
	  		else if(childItem.xtype == "managequestionandeventstructure") {
	  			newTab =Ext.create('Ext.panel.Panel',{
 	  				 closable:true,										 
 	  				 title: tabName,
 	  				 overflowY: 'auto',
 	  				 menuColorCls: menuColorcls,
 	  				 items:[childItem]
 	  			}); 
	  		}
	  		else {
  	  			newTab =Ext.create('Ext.panel.Panel',{
  	  				 closable:true,										 
  	  				 title: tabName,
  	  				 autoScroll:true,
  	  				 menuColorCls: menuColorcls,
  	  				 items:[childItem]
  	  			}); 
  			}
  			contentPanel.add(newTab);
  		}																	
  		contentPanel.setActiveTab(newTab);
  		contentPanel.doLayout();		
  	}		
  }

  /**
  *
  *This function is used to  check string value is null or empty or undefined.
  *@param: stringValue is string to test 
  *
  */
  function isNullOrEmpty(stringValue){	
	  if(stringValue==undefined  || stringValue==null || stringValue===""){
		  return true;
	  }else{
		  return false;
	  }
  }
  
  /**
  *
  *This function is used to  check object is null or empty or undefined.
  *@param: obj is object to test
  *
  */
  function isEmpty(obj) {	
	  	if (obj === undefined) return true;
	    if (obj == null) return true;
	    if (obj.length > 0)    return false;
	    if (obj.length === 0)  return true;

	    // Otherwise, does it have any properties of its own?
	    // Note that this doesn't handle
	    // toString and valueOf enumeration bugs in IE < 9
	    for (var key in obj) {
	        if (hasOwnProperty.call(obj, key)) return false;
	    }

	    return true;
	}
  
  
  /*
	 *This function is used for to get response data
	 *	 
	 */
  function getObjectValue(object,key){	  
	  var returnValue="";
		if(object instanceof Object){
			if(!isNullOrEmpty(object[key])){			
				returnValue=object[key];
			}		
			return returnValue; 
		}else{
			return returnValue;
		}		
  }
  
  /**
   * Below function is used for capitalize first latter in passed string
   * @param string is type of string
   */
  function capitaliseEnumValue(string) {
	  var str = string.replace("_", " ");
	  var wordArr = new Array();
	  wordArr = str.split(" ");
	  var newWord = '';
	  for(var i=0; i<wordArr.length; i++) {
		  newWord += " " + wordArr[i].charAt(0).toUpperCase() + wordArr[i].slice(1).toLowerCase();
	  }
      return newWord.slice(1);
  }
	
  /**
   * This function is used to set the color for the status to green and status text to Active if value is true.
   * and color to red and status text to Inactive if the value of the status is false.
   * @param {Boolean} status which will be true or false.  
   */
	var activeInactiveRenderer = function(status) {
		if(typeof status === 'boolean') {
			if(status){
	        	return '<div style="color:green;">'+getCommonTranslation('ACTIVE')+'</div>';
	        }else {
	        	return '<div style="color:red;">'+getCommonTranslation('INACTIVE')+'</div>';
	        }
		} else {
			if(status === 'true' || status === 'TRUE'){
	        	return '<div style="color:green;">'+getCommonTranslation('ACTIVE')+'</div>';
	        }else {
	        	return '<div style="color:red;">'+getCommonTranslation('INACTIVE')+'</div>';
	        }
		}
    	         	            
    };
    
    /**
     * This function is used to set the translated value of the enum which is passed from
     * the server side.
     * value will be taken from the common translation file of the selected language.
     * @param {Boolean} status which will be true or false.  
     */
  	var enumTranslation = function(enumKey) {
        	return getCommonTranslation(enumKey);
    };
    
    function currencyRenderer(amount, currencyVal) {
        var locale='US';
        var currency= '';
        //var code = Academia.utilities.currency.CurrencyManager.getCurrencyCodeByCurrencyId(1);
        var currencyCount = Academia.utilities.currency.CurrencyManager.currencyMasterData;
        var code = Academia.utilities.currency.CurrencyManager.getCurrencyCodeByCurrencyId(currencyVal);       
        
        if(!isNullOrEmpty(currencyVal)) {
        	currency=code;
        } else {
        	var orgModel = Academia.model.common.OrgSettingDateTimeModel;
        	var currencyCode= orgModel.get('currencyFormat');
        	currency = currencyCode;
        }
  
    	var currencyMap =  Academia.utilities.CurrencyFormatMap;
    	var currencyFormat = currencyMap.getCurrencyFormatConstant(currency);
    	//console.log(currencyFormat)
    	//var currencySettings = currencyFormat[currency];
    	if(currencyFormat){
    		Ext.util.Format.thousandSeparator = currencyFormat.thousandSeparator;
        	Ext.util.Format.decimalSeparator=currencyFormat.decimalSeparator;    	
        	
        	Ext.util.Format.currencySign=currencyFormat.currencySign;
        	Ext.util.Format.currencyAtEnd = currencyFormat.currencyAtEnd; 
    	}
    	  	
        var formatted = Ext.util.Format.currency(amount);
        
        
        var returnValue = [];
        if(currencyCount.length==1) {
    		returnValue = formatted.split(" ");
    		return returnValue[1] ? returnValue[1] : returnValue[0];
    	}
        return formatted;
    }
    
    function randomString(len, charSet) {
        charSet = charSet || 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        var randomString = '';
        for (var i = 0; i < len; i++) {
            var randomPoz = Math.floor(Math.random() * charSet.length);
            randomString += charSet.substring(randomPoz,randomPoz+1);
        }
        return randomString;
    }
    
    function saveExportedPNGFile(fileName, fileContents)
    {
    	var link = Ext.query('#dynamicLink')[0];
    	link.setAttribute('download',fileName);
        link.setAttribute('href',fileContents);
        link.click();
    }
    
    function timer(admissionId,periodIds,batchId) {
    	if(Ext.isDefined(Ext.ComponentQuery.query("#timerItemId")[0])){
    		var hoursLeft   = Math.floor((responseSeconds)/3600);
    		var minutesLeft = Math.floor(responseSeconds % 3600 / 60);
    		var remainingSeconds = Math.floor(responseSeconds % 3600 % 60);
    		if (remainingSeconds < 10) {
    			remainingSeconds = "0" + remainingSeconds; 
    		}
    		if (hoursLeft < 10) {
    			hoursLeft = "0" + hoursLeft; 
    		}
    		if (minutesLeft < 10) {
    			minutesLeft = "0" + minutesLeft; 
    		}
    		var responseDiv = Ext.ComponentQuery.query("#timerItemId")[0];
    		responseDiv.setValue(hoursLeft + ":" + minutesLeft + ":" + remainingSeconds);
    		if (responseSeconds == 0) {
    			clearInterval(countdownTimer);
    			responseDiv.setValue('');
    			var studentPortalCourseRegistrationController = Academia.app.getController('Academia.controller.coursetransaction.studentcourseenrollment.StudentPortalCourseRegistrationController');
				studentPortalCourseRegistrationController.startStudentEnrollmentTimer('',admissionId,periodIds,batchId);
    		} else {
    			responseSeconds--;
    		}
    	}
    	else {
    		clearInterval(countdownTimer);
    	}
    }
    
    function openSAR(){
    	//-- getting controller
    	var $this = Academia.app.getController('Academia.controller.examinationcenters.studentportal.SPStudentAssessmentReportController');
    	var notificationalertwindow = Ext.getCmp("NotificationAlertWindow");
    	
    	//-- checking for the permission
    	var isViewPermission = false;
    	if($this.getCurrentLoggedPortalId()==7){
    		var pm = $this.getPARENT_PORTAL_EXAM_STUDENT_ASSESSMENT_REPORT_PRIVILEGES();
    	}else{
    		var pm = $this.getSTUDENT_PORTAL_EXAM_STUDENT_ASSESSMENT_REPORT_PRIVILEGES();
    	}
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push($this.getCurrentAcademyLocation()); 
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, pm);

    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			isViewPermission = true;
    		}
    	});
  	   	
  	   	//--
    	if(isViewPermission){
    		var tabName = getExaminationTranslation('STUDENT_ASSESSMENT_REPORT');
    		var contentPanel = $this.getContentPanel();
        	var newTab = contentPanel.items.findBy(function(tab) {
    			return tab.title === tabName;
    		});
    		if (!newTab) {
    			contentPanel.add({
    				title: tabName,
    				closable : true,
    				autoScroll:true,
    				xtype : 'spstudentassessmentreportstructure'
    			}).show();
    		}
    		contentPanel.setActiveTab(newTab);
    		contentPanel.doLayout();
    		
    		//-- closing notification window
    		if(Ext.isDefined(notificationalertwindow)){
        		notificationalertwindow.close();
    		}
    		
    		//-- fire search btn click event
    		setTimeout(function(){
    			var searchreportfilter = $this.getSpstudentassessmentreportfilter();
    			var searchBtn = searchreportfilter.down('button[itemId=searchBtn]');
    			searchBtn.fireEvent('click', searchBtn);
    		},300);
    	}
    	else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NOT_HAVING_PERMISSION_SCREEN'));
    	}
    }
    
    function dateTimeRender(val){         
        var date="";
        var displayFormatMap = Academia.utilities.DisplayFormatMap;
        var orgModel = Academia.model.common.OrgSettingDateTimeModel;
        var currentDateFormat = orgModel.get('dateFormat');
        var currentTimeFormat = orgModel.get('timeFormat');
    	var format = displayFormatMap.getDisplayFormat(currentDateFormat)+' <b>'+displayFormatMap.getDisplayFormat(currentTimeFormat)+'</b>';
        if(val instanceof Date){
        	date=Ext.Date.format(val, format);
        } else if(!isNullOrEmpty(val)){
        	var dateToFormat = new Date(val);
        	date=Ext.Date.format(dateToFormat, format);
        }
        return date;
    };
    
    function dateTimeRender1(val){         
        var date="";
        var displayFormatMap = Academia.utilities.DisplayFormatMap;
        var orgModel = Academia.model.common.OrgSettingDateTimeModel;
        var currentDateFormat = orgModel.get('dateFormat');
        var currentTimeFormat = orgModel.get('timeFormat');
    	var format = displayFormatMap.getDisplayFormat(currentDateFormat)+' '+displayFormatMap.getDisplayFormat(currentTimeFormat);
        if(val instanceof Date){
        	date=Ext.Date.format(val, format);
        } else if(!isNullOrEmpty(val)){
        	var dateToFormat = new Date(val);
        	date=Ext.Date.format(dateToFormat, format);
        }
        return date;
    };
    
    function openLinkedTagWin(){
    	var contentPanel = Ext.ComponentQuery.query('contentpanel')[0];
    	var currentTab = contentPanel.getActiveTab();
    	
    	var field = currentTab.down('linkedtagfield');
    	var winTitle = !isNullOrEmpty(field.moreWindowTitle)?field.moreWindowTitle:field.fieldLabel;
    	var totalItems = field.getValue().length;
    	var maxItems = field.maxItems;
    	var showAll = field.showAllInWindow;
    	var winGridPageSize = field.winGridPageSize;
    	
		var itemsToShow = [];
    	if(showAll==false){
    		for(i=0;i<field.getValue().length;i++){    			
    			if(i>=maxItems){
    				//value,display,isVisible
    				var currentItem = {
    						value:field.getValue()[i],
    						display:field.getStore().findRecord(field.valueField,field.getValue()[i]).get(field.displayField),
    						isVisible:true
    				};
        			itemsToShow.push(currentItem);
    			}
    			/*else {
    				//value,display,isVisible
    				var currentItem = {
    						value:field.getValue()[i],
    						display:field.getStore().findRecord(field.valueField,field.getValue()[i]).get(field.displayField),
    						isVisible:false
    				};
    			}*/
    		}
    	}
    	else{
    		for(i=0;i<field.getValue().length;i++){    	
				//value,display,isVisible
    			var currentItem = {
    					value:field.getValue()[i],
    					display:field.getStore().findRecord(field.valueField,field.getValue()[i]).get(field.displayField),
    					isVisible:true
    			};
    			itemsToShow.push(currentItem);
    		}
    	}
    	
    	var newTagLinkWindowStore = Ext.create('Ext.data.Store', {
    		constructor: function(){
    	        this.callParent(arguments);
    	        this.model.prototype.idProperty = 'value';
    	    },
        	fields : [{
        		name : 'value'
        	}, {
        		name : 'display'
        	}, {
        		name : 'isVisible'
        	}],
        	autoLoad: false,
            pageSize: winGridPageSize,
        	proxy: {
                type: 'pagingmemory',
                data:itemsToShow,
                idProperty: 'value'
            }
        });
    	
    	var newTagLinkWindow = Ext.create('Ext.window.Window', {
    	    title: winTitle,
    	    height: 515,
    	    width: 700,
    	    layout: 'fit',
    	    resizable:false,
    		border:true,
    		autoScroll : false,
    		modal : true,
    		closeAction: 'destroy',
    	    items: {  // Let's put an empty grid in just to illustrate fit layout
    	        xtype: 'grid',
    	        border: true,
    	        columns: [
    	        	{
    	        		header: field.fieldLabel,
    	        		xtype: 'templatecolumn',
    	        		sortable: false,
    	            	flex: 1,
    	            	dataIndex: 'display',
    	            	tpl: '{display}<span class="columnClose">X</span>'
    	        	}
    	        ],
    	        store: newTagLinkWindowStore,
    	        bbar: {
    	            xtype: 'pagingtoolbar',
    	            store: newTagLinkWindowStore,
    	            displayInfo: true,
    	            //plugins:['pagesize'],
    	            emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
    	        },
    	        listeners: {
    	        	cellclick: function(gridView, td, cellIndex, record, tr, rowIndex, e, eOpts){
    	        		if(e.target.className == "columnClose"){
    	        			var proxyData = gridView.up('grid').getStore().proxy.data;
    	        			var newBlankArray = [];
    	        			Ext.each(proxyData,function(currentProxyRecord){
    	        				if(record.get('value')!=currentProxyRecord.value){
        	        				newBlankArray.push(currentProxyRecord);
    	        				};
    	        			});
    	        			gridView.up('grid').getStore().proxy.data = newBlankArray;
    	        			if(gridView.up('grid').store.proxy.data.length==(record.index) && rowIndex==0 && gridView.up('grid').store.currentPage!=1){
        	        			gridView.up('grid').getStore().loadPage((gridView.up('grid').store.currentPage-1));
    	        			}
    	        			else {
        	        			gridView.up('grid').getStore().load();
    	        			}
    	        			//gridView.up('grid').getStore().remove(record);
    	        		}
    	        	}
    	        }
    	    },
    	    listeners: {
    	    	beforeclose: function(panel, eOpts){
    	    		panel.down('grid').getStore().clearFilter();
    	    		var newFieldValues = []
    	    		Ext.each(panel.down('grid').getStore().proxy.data, function(currentRecordValue){
    	    			newFieldValues.push(currentRecordValue.value);
    	    		});
    	    		var fieldVisibleValues = [];
    	    		for(i=0;i<maxItems;i++){
    	    			fieldVisibleValues.push(field.getValue()[i]);
    	    		}
    	    		var totalFieldValues = fieldVisibleValues.concat(newFieldValues);
    	    		field.setValue(totalFieldValues);
    	    	}
    	    }
    	}).show();
    	
    	newTagLinkWindowStore.load();
    	
    	/*setTimeout(function(){
    		newTagLinkWindowStore.filterBy(function(record, id){
                return record.get('isVisible');
            });
    	},300);*/
    }
    String.prototype.replaceAll = function(search, replacement) {
        var target = this;
        return target.replace(new RegExp(search, 'g'), replacement);
    };
     function hideGallery(){
    	$('#galleryCarousal').hide();
    }
     
     function changeGalleryImage(direction){
    	 var dataViewStore;
    	 /*code added for open carousal from grid list from Academia Drive*/
    	 if(Ext.ComponentQuery.query('#galleryDataView').length>0){
    		 dataViewStore = Ext.ComponentQuery.query('#galleryDataView')[0].getStore();
    	 }else if(Ext.ComponentQuery.query('myfolderfilegrid')){
    		 dataViewStore = Ext.ComponentQuery.query('myfolderfilegrid')[0].getStore();
    	 }
    	
    	 var currentRecordId = $('#galleryCarousal')[0].currentImage;
    	 var currentRecordIndex = dataViewStore.findExact('id',currentRecordId);
    	 if(direction=="previous"){
        	 var imageRecord = dataViewStore.getAt(currentRecordIndex-1);
    	 }
    	 else{
    		 var imageRecord = dataViewStore.getAt(currentRecordIndex+1);
    	 }

    	 var backgroundImgPath = 'url(resources/images/uploads'+imageRecord.get('path')+')';
    	 var fileType = imageRecord.data.fileType.toLowerCase();
    	 var backgroundImgSize = 'contain';
    	 if(fileType == "odt"){
    		 backgroundImgPath = "url(resources/images/driveToolImages/odt.png)";
    		 backgroundImgSize = "auto";
    	 }
    	 else if(fileType == "doc" || fileType == "docx"){
    		 backgroundImgPath = "url(resources/images/driveToolImages/doc.png)";
    		 backgroundImgSize = "auto";
    	 }
    	 else if(fileType == "pdf"){
    		 backgroundImgPath = "url(resources/images/driveToolImages/pdf.png)";
    		 backgroundImgSize = "auto";
    	 }
    	 else if(fileType == "ppt" || fileType == "pptx"){
    		 backgroundImgPath = "url(resources/images/driveToolImages/ppt.png)";
    		 backgroundImgSize = "auto";
    	 }
    	 else if(fileType == "txt"){
    		 backgroundImgPath = "url(resources/images/driveToolImages/txt.png)";
    		 backgroundImgSize = "auto";
    	 }
    	 else if(fileType == "xls" || fileType == "xlsx"){
    		 backgroundImgPath = "url(resources/images/driveToolImages/xls.png)";
    		 backgroundImgSize = "auto";
    	 }
    	 
    	 $('#galleryCarousal')[0].style.backgroundImage = backgroundImgPath;
    	 $('#galleryCarousal')[0].currentImage = imageRecord.get('id');
    	 $('#galleryCarousal')[0].style.backgroundSize = backgroundImgSize;//(window.innerWidth-250)+'px'+(window.innerHeight-250)+'px';

    	 var currentRecordId = $('#galleryCarousal')[0].currentImage;
    	 var currentRecordIndex = dataViewStore.findExact('id',currentRecordId);
    	 var previousRecord = dataViewStore.getAt(currentRecordIndex-1);
    	 var nextRecord = dataViewStore.getAt(currentRecordIndex+1);

    	 if(Ext.isDefined(previousRecord)){
    		 $('.previousGalleryCarousal')[0].style.display = '';
    	 }
    	 else{
    		 $('.previousGalleryCarousal')[0].style.display = 'none';
    	 }

    	 if(Ext.isDefined(nextRecord)){
    		 $('.nextGalleryCarousal')[0].style.display = '';
    	 }
    	 else{
    		 $('.nextGalleryCarousal')[0].style.display = 'none';
    	 }
     }
    
    function changeDeleteBtnState(hyperLinkId){
    	var structure;
    	if(portalId ==1){
    		structure=Ext.ComponentQuery.query('managegallerystructure')[0];
    	}else{
    		structure=Ext.ComponentQuery.query('viewgallerystructure')[0];
    	}
    	var imageIDs = $("[name=imageId]:checked").map(function(){
			return $(this).val();
		}).get();
    	
    	if(imageIDs.length){
    		if(portalId == 1){
    			structure.down('#btnDeleteImage').setDisabled(false);
    			if(imageIDs.length==1){
    				structure.down('#btnEditImage').setDisabled(false);
    			}else{
    				structure.down('#btnEditImage').setDisabled(true);
    			}
    		}
    		else{
    			if(imageIDs.length==1){
    				structure.down('#btnEditImage').setDisabled(false);
     			}else{
     				structure.down('#btnEditImage').setDisabled(true);
     			}
    			structure.down('#btnDeleteImage').setDisabled(false);
    		}
    	}
    	else {
    		if(portalId == 1){
    			structure.down('#btnDeleteImage').setDisabled(true);
    			structure.down('#btnEditImage').setDisabled(true);
    		}
    		else{
    			structure.down('#btnDeleteImage').setDisabled(true);
    			structure.down('#btnEditImage').setDisabled(true);
    		}
    	}
    	
    	/*code start to manage edit button , i.e enable only in case of hyperLink*/
    	var managGalleryStore = Ext.create('Academia.store.facilitiesresources.managegallery.ManageGalleryStore');
    	var albumId;
    	albumId = structure.down('#btnEditImage').config.albumId;
    	
		managGalleryStore.getProxy().extraParams = {
			galleryId : albumId
		};
		managGalleryStore.load({
			callback: function(records, operation, success){
				if(records.length>0){
					var whetherLinkSelected=0;
					var whetherImageSelected=0;
					for(var i=0;i<records.length;i++){
						var checkBox = document.getElementById(records[i].data.id);
						if(checkBox.checked && records[i].data.imageName=="link"){
							whetherLinkSelected++;
						}else if(checkBox.checked){
							whetherImageSelected++;
						}
					}
					if(whetherLinkSelected==1 && whetherImageSelected<1){
						structure.down('#btnEditImage').setDisabled(false);
					}else{
						structure.down('#btnEditImage').setDisabled(true);
					}
				}
			}
		});
    }
    function thesisManagementApproveRejectSelectionChange(){
    	var imageIDs = $("[name=thesisImageId]:checked").map(function(){
    		return $(this).val();
    	}).get();

    	if(imageIDs.length){
    		Ext.ComponentQuery.query('thesismanagementapproverejectwin')[0].down('#btnAcceptDocumentDeleteImage').setDisabled(false);
    	}
    	else {
    		Ext.ComponentQuery.query('thesismanagementapproverejectwin')[0].down('#btnAcceptDocumentDeleteImage').setDisabled(true);
    	}
    }
    
    function facultyThesisManagementApproveRejectSelectionChange(){
    	var imageIDs = $("[name=thesisImageId]:checked").map(function(){
    		return $(this).val();
    	}).get();

    	if(imageIDs.length){
    		Ext.ComponentQuery.query('facultythesismanagementapproverejectwin')[0].down('#btnAcceptDocumentDeleteImage').setDisabled(false);
    	}
    	else {
    		Ext.ComponentQuery.query('facultythesismanagementapproverejectwin')[0].down('#btnAcceptDocumentDeleteImage').setDisabled(true);
    	}
    }
    
    function thesisDocumentSelectionChange(imageIdName, btnName){
    	var imageIDs = $("[name="+imageIdName+"]:checked").map(function(){
    		return $(this).val();
    	}).get();

    	if(imageIDs.length){
    		Ext.ComponentQuery.query('thesismanagementsubmitdocumentwindow')[0].down('#'+btnName).setDisabled(false);
    	}
    	else {
    		Ext.ComponentQuery.query('thesismanagementsubmitdocumentwindow')[0].down('#'+btnName).setDisabled(true);
    	}
    }
    function thesisStatusDocumentSelectionChange(imageIdName, btnName){
    	var imageIDs = $("[name="+imageIdName+"]:checked").map(function(){
    		return $(this).val();
    	}).get();

    	if(imageIDs.length){
    		Ext.ComponentQuery.query('thesismangementstatusdetailwin')[0].down('#'+btnName).setDisabled(false);
    	}
    	else {
    		Ext.ComponentQuery.query('thesismangementstatusdetailwin')[0].down('#'+btnName).setDisabled(true);
    	}
    }
    function facultyThesisDocumentSelectionChange(imageIdName, btnName){
    	var imageIDs = $("[name="+imageIdName+"]:checked").map(function(){
    		return $(this).val();
    	}).get();

    	if(imageIDs.length){
    		Ext.ComponentQuery.query('facultythesismanagementsubmitdocumentwindow')[0].down('#'+btnName).setDisabled(false);
    	}
    	else {
    		Ext.ComponentQuery.query('facultythesismanagementsubmitdocumentwindow')[0].down('#'+btnName).setDisabled(true);
    	}
    }
    
    function changePaymentPlanDeleteBtnState(){
    	var imageIDs = $("[name=imageId]:checked").map(function(){
			return $(this).val();
		}).get();
    	
    	if(imageIDs.length){
    		if(portalId == 1){
    			Ext.ComponentQuery.query('fnppaymentplansettingsdocumentsview')[0].down('#btnDelete').setDisabled(false);
    		}
    		else{
    			Ext.ComponentQuery.query('fnppaymentplansettingsdocumentsview')[0].down('#btnDelete').setDisabled(false);
    		}
    	}
    	else {
    		if(portalId == 1){
    			Ext.ComponentQuery.query('fnppaymentplansettingsdocumentsview')[0].down('#btnDelete').setDisabled(true);
    		}
    		else{
    			Ext.ComponentQuery.query('fnppaymentplansettingsdocumentsview')[0].down('#btnDelete').setDisabled(true);
    		}
    	}
    }
    
    function roundToPrecision(subject, precision) {
        return +((+subject).toFixed(precision));
    }
    
    /*function getBackgroundSize(imgSrc){
    	var img = new Image();
    	img.onload = function() {
    	  var imageWidth = this.width;
    	  var imageHeight = this.height;
    	  var windowWidth = window.innerWidth();
    	  var windowHeight = window.innerHeight();
    	  if(imageWidth<windowWidth && imageHeight<windowHeight){
    		  return 'auto';
    	  }
    	  else{
    		  return 'contain';
    	  }
    	}
    	img.src = imgSrc;
    }*/
    
    //--Start Here--Code for multiple tabs functionality @raghavendra.soni
    
	    function setTabId() {
	    	var newTabId = randomString(10);
	    	var isSafari = navigator.vendor.match(/apple/i) && !navigator.userAgent.match(/crios/i) && !navigator.userAgent.match(/fxios/i) && !navigator.userAgent.match(/Opera|OPT\//);
	    	if(!isNullOrEmpty(isSafari) && isSafari == true){
	    		newTabId = "safari"
	    	}
	    	if(isNullOrEmpty(window.name)){
	    		window.name = newTabId;
	    	}
	    
	    }
	
	    function getTabId() {
	    	if(isNullOrEmpty(window.name)){
	    		setTabId();
	    	}
	    	return window.name;
	    }
	
	    Storage.prototype._setItem = Storage.prototype.setItem;
	    Storage.prototype.setItem = function(key, value)
	    {
	    	this._setItem(getTabId()+'_'+key, JSON.stringify(value));
	    }
	
	    Storage.prototype._getItem = Storage.prototype.getItem;
	    Storage.prototype.getItem = function(key)
	    { 
	    	try
	    	{
	    		return JSON.parse(this._getItem(getTabId()+'_'+key));
	    	}
	    	catch(e)
	    	{
	    		return this._getItem(getTabId()+'_'+key);
	    	}
	    }
	    
    //--End Here--Code for multiple tabs functionality @raghavendra.soni
	    
	//--Start Here--Code for generic grid header fix functionality @raghavendra.soni
	    function freezeCurrentGrid(grid, structure){
	    	if(this$.getActiveTabfromContentPanel().xtype==structure){
	    		var newStructure=this$.getActiveTabfromContentPanel();
	    	}
	    	else{
	    		var newStructure=this$.getActiveTabfromContentPanel().down(structure);
	    	}
	    	if(isNullOrEmpty(newStructure)){
	    		try{
	    			var newStructure=Ext.ComponentQuery.query(structure)[0];
	    		}
	    		catch(e){
	    			//--
	    		}
	    	}
	    	if(!isNullOrEmpty(newStructure)){
		    	newStructure.body.on('scroll',function(){
		    		try{
						if(grid && grid.down('splitbutton') && grid.down('splitbutton').menu && grid.down('splitbutton').menu.isVisible()){
					          grid.down('splitbutton').menu.hide();
					     }
			    		var part2 = '';
			    		var structurePosition = newStructure.getPosition()[1];
			    		var gridPosition = grid.getPosition()[1];
			    		var part1 = Ext.isDefined(grid.getHeader()) ? grid.getHeader() : '';
			    		Ext.each(grid.dockedItems.items, function(currentDockedItem){
			    			if(currentDockedItem.xtype=="toolbar" && currentDockedItem.dock=="top"){
			    				part2=currentDockedItem;
			    				return;
			    			}
			    		});
			    		var part3 = Ext.isDefined(grid.columnManager.headerCt) ? grid.columnManager.headerCt : '';
			    		if(gridPosition<=structurePosition){
			    			switchHeaderFreezeCSS('add',structurePosition,part1,part2,part3);
			    		}
			    		else{
			    			switchHeaderFreezeCSS('remove',structurePosition,part1,part2,part3);
			    		}
		    		}
		    		catch(e){
		    			//--
		    		}
		    	});
	    	}
	    	try{
		    	newStructure.on('resize',function(newSt, width, height, oldWidth, oldHeight, eOpts){
		    		newSt.scrollBy(0,1);
		    		newSt.scrollBy(0,-1);
		    	});
	    	}
	    	catch(e){
	    		
	    	}
	    	try{
		    	newStructure.on('activate',function(newSt, eOpts){
		    		newSt.scrollBy(0,1);
		    		newSt.scrollBy(0,-1);
		    	});
		    	
		    	if(this$.getActiveTabfromContentPanel().xtype!=structure){
		    		this$.getActiveTabfromContentPanel().on('activate',function(newSt, eOpts){
		    			newStructure.scrollBy(0,1);
		    			newStructure.scrollBy(0,-1);
			    	});
		    	}
	    	}
	    	catch(e){
	    		
	    	}
	    	
	    	//-- Start Here - Added by @Raghavendra.Soni for Inner TabPanel Scroll Issue
	    	try{
		    	if(grid.up('tabpanel').xtype!=structure){
		    		grid.up('tabpanel').getActiveTab().on('activate',function(newSt, eOpts){
		    			try{
		    				newStructure.scrollBy(0,1);
			    			newStructure.scrollBy(0,-1);
		    			}catch(e){}
			    	});
		    	}
	    	}
	    	catch(e){}
	    	//-- End Here - Added by @Raghavendra.Soni for Inner TabPanel Scroll Issue
	    	
	    	try{
	    		grid.down('custompagingtoolbar').on('change',function(pbar, pageData, eOpts){
	    			refreshHeader(pbar.up('grid'));
	    		});
	    	}
	    	catch(e){
	    		
	    	}
	    	try{
	    		grid.on('show',function(currentGrid){
	    			var currentActiveTab = currentGrid.up('contentpanel').getActiveTab();
	    			currentActiveTab.scrollBy(0,1);
	    			currentActiveTab.scrollBy(0,-1);
	    		});
	    	}
	    	catch(e){

	    	}
	    	try{
	    		grid.on('hide',function(currentGrid){
	    			var currentActiveTab = currentGrid.up('contentpanel').getActiveTab();
	    			currentActiveTab.scrollBy(0,1);
	    			currentActiveTab.scrollBy(0,-1);
	    		});
	    	}
	    	catch(e){

	    	}
	    }
	    
	    function refreshHeader(fGrid){
	    	try{
		    	var currentPortalId = localStorage.getItem('portalId');
				Ext.each(fGrid.headerFix.portalIdsWithStructure, function(name){
					var structureName = Object.keys(name)[0];
					var structurePortalId = Object.values(name)[0];
					if(currentPortalId==structurePortalId){
						var activeTab = this$.getActiveTabfromContentPanel();
						if(activeTab.xtype==structureName && activeTab.xtype != 'coursesectionmanagementstructure' && !isNullOrEmpty(activeTab.down()) && activeTab.down().xtype != 'examtimetable'){
				    		this$.getActiveTabfromContentPanel().scrollBy(0,1);
				    		this$.getActiveTabfromContentPanel().scrollBy(0,-1);
				    	}
				    	else{
				    		if(fGrid.xtype != 'coursesectionmanagementstructure' && fGrid.xtype != 'evaluationstatusmastergrid') {
					    		this$.getActiveTabfromContentPanel().down(structureName).scrollBy(0,1);
					    		this$.getActiveTabfromContentPanel().down(structureName).scrollBy(0,-1);
				    		}
				    	}
					}
				});
	    	}
	    	catch(e){
	    		
	    	}
	    }
	    
	    function resetGridHeaderFix(me){
	    	if(Ext.isDefined(me) && Ext.isDefined(me.headerFix) && Ext.isDefined(me.headerFix.headerFix) && Ext.isDefined(me.headerFix.portalIdsWithStructure) && me.headerFix.headerFix==true && Ext.Object.getSize(me.headerFix.portalIdsWithStructure)>0){
 				var currentGrid = me;
 				var currentPortalId = localStorage.getItem('portalId');
 				Ext.each(currentGrid.headerFix.portalIdsWithStructure, function(name){
 					var structureName = Object.keys(name)[0];
 					var structurePortalId = Object.values(name)[0];
 					if(currentPortalId==structurePortalId && this$.getActiveTabfromContentPanel()){
 						if(this$.getActiveTabfromContentPanel().xtype==structureName){
 				    		var newStructure=this$.getActiveTabfromContentPanel();
 				    	}
 				    	else{
 				    		var newStructure=this$.getActiveTabfromContentPanel().down(structureName);
 				    	}
 				    	if(isNullOrEmpty(newStructure)){
 				    		try{
 				    			var newStructure=Ext.ComponentQuery.query(structureName)[0];
 				    		}
 				    		catch(e){
 				    			//--
 				    		}
 				    	}
 				    	
 				    	if(!isNullOrEmpty(newStructure)  && newStructure.xtype != 'coursesectionmanagementstructure' && newStructure.up() && newStructure.up().xtype != 'evaluationstatusmasterstructure' && newStructure.xtype != 'studentcoursemastersearchstructure' && newStructure.xtype != "dashboardmainstructure"){
 				    		if(!isNullOrEmpty(newStructure.down()) && newStructure.down().xtype != 'examtimetable' && newStructure.xtype != 'timetablestructure' && newStructure.xtype != 'managespecialgradesearch') {
 				    			newStructure.scrollBy(0,1);
 				    			newStructure.scrollBy(0,-1);
 				    		}
 				    	}
 					}
 				});
        	 }
	    }
	    
	    function switchHeaderFreezeCSS(type,structurePosition,part1,part2,part3){
	    	if(type=="add"){
	    		if(!isNullOrEmpty(part1)){
		    		part1.removeCls('x-docked');
		    		part1.addCls('gridFixHeader');
		    		part1.el.dom.style.top = structurePosition+"px";
	    		}
	    		if(!isNullOrEmpty(part2)){
		    		part2.removeCls('x-docked');
		    		part2.addCls('gridFixHeader');
		    		if(!isNullOrEmpty(part1)){
		    			var part2Position = part1.getHeight() + structurePosition;
		    		}
		    		else{
		    			var part2Position = structurePosition;
		    		}
		    		part2.el.dom.style.top = part2Position+"px";
	    		}
	    		if(!isNullOrEmpty(part3)){
	    			part3.removeCls('x-docked');
	    			part3.addCls('gridFixHeader');
	    			if(!isNullOrEmpty(part1) && !isNullOrEmpty(part2)){
		    			var part3Position = part1.getHeight() + part2.getHeight() + structurePosition;
		    		}
	    			else if(!isNullOrEmpty(part1)){
	    				var part3Position = part1.getHeight() + structurePosition;
	    			}
	    			else if(!isNullOrEmpty(part2)){
	    				var part3Position = part2.getHeight() + structurePosition;
	    			}
		    		else{
		    			var part3Position = structurePosition;
		    		}
	    			part3.el.dom.style.top = part3Position+"px";
	    		}
	    	}
	    	else{
	    		if(!isNullOrEmpty(part1)){
		    		part1.addCls('x-docked');
		    		part1.removeCls('gridFixHeader');
		    		part1.el.dom.style.top = "0px";
	    		}
	    		if(!isNullOrEmpty(part2)){
		    		part2.addCls('x-docked');
		    		part2.removeCls('gridFixHeader');
		    		if(!isNullOrEmpty(part1)){
		    			var part2Position = part1.getHeight() + 0;
		    		}
		    		else{
		    			var part2Position = 0;
		    		}
		    		part2.el.dom.style.top = part2Position+"px";
	    		}
	    		if(!isNullOrEmpty(part3)){
	    			part3.addCls('x-docked');
	    			part3.removeCls('gridFixHeader');
	    			if(!isNullOrEmpty(part1) && !isNullOrEmpty(part2)){
		    			var part3Position = part1.getHeight() + part2.getHeight() + 0;
		    		}
	    			else if(!isNullOrEmpty(part1)){
	    				var part3Position = part1.getHeight() + 0;
	    			}
	    			else if(!isNullOrEmpty(part2)){
	    				var part3Position = part2.getHeight() + 0;
	    			}
		    		else{
		    			var part3Position = 0;
		    		}
	    			part3.el.dom.style.top = part3Position+"px";
	    		}
	    	}
	    }
	//--End Here--Code for generic grid header fix functionality @raghavendra.soni
	    
	//--Start Here--Code for adding demo text on header @raghavendra.soni
	    function checkAndAddDemoHeader(){
	    	if(isDemoInstance()){
	    		setTimeout(function(){
		    		var organizationNameComponent = Ext.ComponentQuery.query('#organizationName')[0];
		    		var organizationName = organizationNameComponent.el.dom.innerHTML;
		    		var isHTML = RegExp.prototype.test.bind(/(<([^>]+)>)/i);
		    		if(!isHTML(organizationName)){
			    		var demoText = '<p class="x-unselectable" title="'+location.host+' is a demo instance." style="cursor:help;margin: 0;font-size: 12px;background-color: orange;padding: 1px 3px;width: 43px;font-weight: bold;border-radius: 3px;">DEMO</p>';
			    		organizationNameComponent.el.dom.innerHTML = organizationName+demoText;
			    		organizationNameComponent.el.dom.style.setProperty("padding-top", "0px", "important");
		    		}
	    		},1500);
	    	}
	    	if(isTrainingInstance()){
	    		setTimeout(function(){
		    		var organizationNameComponent = Ext.ComponentQuery.query('#organizationName')[0];
		    		var organizationName = organizationNameComponent.el.dom.innerHTML;
		    		var isHTML = RegExp.prototype.test.bind(/(<([^>]+)>)/i);
		    		if(!isHTML(organizationName)){
			    		var demoText = '<p class="x-unselectable" title="'+location.host+' is a training instance." style="cursor:help;margin: 0;font-size: 10px;background-color: orange;padding: 0px 3px;width:60px;font-weight: bold;border-radius: 3px;">TRAINING</p>';
			    		organizationNameComponent.el.dom.innerHTML = organizationName+demoText;
			    		organizationNameComponent.el.dom.style.setProperty("padding-top", "0px", "important");
		    		}
	    		},1500);
	    	}
	    }
	//--End Here--Code for adding demo text on header @raghavendra.soni
	    
	//--Start Here--Code for checking demo instance @raghavendra.soni
	    function isDemoInstance(){
	    	var demoInstanceURL = [
	    		'localhost',
	    		'1c',
	    		'1b',
	    		'demo',
	    		'staging',
	    		'accra',
	    		'bengaluru',
	    		'test'
	    	];
	    	var inArray = demoInstanceURL.some(function(el) {
	    	    return ~location.href.indexOf(el);
	    	});
	    	return inArray;
	    }
	    function isTrainingInstance(){
	    	var trainingInstanceURL = [
	    		'training'
	    	];
	    	var inArray = trainingInstanceURL.some(function(el) {
	    	    return ~location.href.indexOf(el);
	    	});
	    	return inArray;
	    }
	    
	//--End Here--Code for checking demo instance @raghavendra.soni
	    
	//--Start Here--Code for stopping console log in production environment @raghavendra.soni
	    	try{
	    		if(environment == "Production"){
	    			console.log=function(){}
	    		}
	    	}
	    	catch(e){}
	/*--Stop Here--Code for stopping console log in production environment @raghavendra.soni
	    String.prototype.toCapitalize = function() {
    	   return this.charAt(0).toUpperCase() + this.slice(1).toLowerCase();
    	};*/
   
    //--  Search value in array
    	function findInArray(arr, value){
    		var found = arr.find(function(element) {
    		  return element == value;
    		});
    		if(Ext.isDefined(found)){
    			return true;
    		}else{
    			return false;
    		}
    	}
	    
    //-- Binding body click event
    	function loadApisFunction(){
    		$(".x-body").on("click", function(){
    			if(Ext.app.autoCallAPIs){
    				setTimeout(function(){
    					console.log('called');
    					Academia.app.getController("Academia.controller.authentication.AuthenticationController").loadDataAfterLogin();
    				},100);
    			}
    			Ext.app.autoCallAPIs = false;
    		});
    	}
    	    	
    	function getMenuDisplayName(displayCode)
    	{
    		if(displayCode.indexOf("POWER_BI_")==0)
    		{
    			return getAnalyticsTranslation(displayCode);
    		}else{
    			return getMegaMenuTranslation(displayCode);
    		}	
    	}
    	
    	function getAccessToken(id)
    	{
    		var report;
    		if(id!=null)
    		{
    			report=powerbi.get($('#'+id)[0]);
    		}
    		Ext.Ajax.request({
    			type : 'rest',
    			url :  SERVERURL.PATH_POWERBI_ACCESS_TOKEN,
    			method : 'GET',
    			async: false,
    			success : function(response) {
    				Academia.app.powerBIToken=response.responseText;
    				report.setAccessToken(response.responseText);
    			}	
    		});
    	}
    	function getDayDifference(day){
    		var date1 = new Date(new Date(day).getFullYear(), new Date(day).getMonth(), new Date(day).getDate());
    		var date2 = new Date(new Date().getFullYear(), new Date().getMonth(), new Date().getDate());
    		var diffTime = Math.abs(date2 - date1);
    		var diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24)); 
    		if(diffDays== 0){
    			return "Today";
    		}
    		else if(diffDays == 1){
    			return "Yesterday";
    		}
    		else if(diffDays<=(new Date().getDay())){
    			return "Earlier this week";
    		}
    		else if(diffDays<=(new Date().getDay()+7)){
    			return "Last week";
    		}
    		else if(new Date(day).getMonth()==new Date().getMonth()){
    			return "This month";
    		}
    		else if(new Date(day).getMonth()==(new Date().getMonth()-1)){
    			return "Last month";
    		}
    		else if(new Date(day).getFullYear()==new Date().getFullYear()){
    			return "Months ago";
    		}
    		else if(new Date(day).getFullYear()==(new Date().getFullYear()-1)){
    			return "Last year";
    		}
    		else if(new Date(day).getFullYear()<(new Date().getFullYear()-1)){
    			return "Years ago";
    		}
    	}
    	
    	function getTimeDifference(dateTime) {
    		var Day = new Date(dateTime).getTime();
    		var seconds = (Date.now()-Day)/ 1000;

    		var interval = Math.floor(seconds / 31536000);

    		if (interval > 1) {
    			return interval + " years";
    		}
    		else if(interval == 1) {
    			return interval + " year";
    		}
    		
    		interval = Math.floor(seconds / 2592000);
    		if (interval > 1) {
    			return interval + " months";
    		}
    		else if (interval == 1) {
    			return interval + " month";
    		}
    		
    		interval = Math.floor(seconds / 86400);
    		if (interval > 1) {
    			return interval + " days";
    		}
    		else if (interval == 1) {
    			return "a day";
    		}
    		
    		interval = Math.floor(seconds / 3600);
    		if (interval > 1) {
    			return interval + " hours";
    		}
    		else if (interval == 1) {
    			return interval + " hour";
    		}
    		
    		interval = Math.floor(seconds / 60);
    		if (interval > 1) {
    			return interval + " minutes";
    		}
    		else if (interval == 1) {
    			return interval + " minute";
    		}
    		
    		return Math.floor(seconds) + " seconds";
    	}
    	//-- create window for column
    	function createColumnWindow(gridClass, id, dataGridId, defaultColumns, userDefinedColumns, isWindow,gridName){
    		try
    		{
    			var cPanel = Ext.ComponentQuery.query('contentpanel')[0];
    			var paymentGrid = cPanel.getActiveTab().down('paymentreceivedhistorygrid');
    			var isIndexRemoved=[];
    			if(!isNullOrEmpty(paymentGrid))
    			{
    				if(paymentGrid.personType=="USER")
    				{
    					for(i=0;i<defaultColumns.length;i++)
    					{
    						if(defaultColumns[i].dataIndex!="paymentDate" && defaultColumns[i].dataIndex!="feeAmount" && defaultColumns[i].dataIndex!="pendingAmount")
    						{
    							isIndexRemoved.push(defaultColumns[i]);
    						}
    					}
    				}
    				else
    				{
    					for(i=0;i<defaultColumns.length;i++)
    					{
    						if(defaultColumns[i].dataIndex!="transactionDate" && defaultColumns[i].dataIndex!="amount" && defaultColumns[i].dataIndex!="adjustedAmount")
    						{
    							isIndexRemoved.push(defaultColumns[i]);
    						}
    					}
    				}
    				defaultColumns=isIndexRemoved;
    			}
    		}
    		catch (e) {
    			console.log(e);
    		}
    		var isCBGrid = false;
			
			if(gridClass.indexOf("SearchResultGrid")!=-1){
				isCBGrid = true;
			}
    		
    		var gridStoreData = [];
    		Ext.each(defaultColumns, function(currentDefaultColumn){
    			currentDefaultColumn.keyName = currentDefaultColumn.columnName;
    			if(!isCBGrid){
        			currentDefaultColumn.columnName = getCommonTranslation(currentDefaultColumn.columnName);
    			}
    			if(currentDefaultColumn.columnVisibility!="REMOVE"){ //--not showing removed columns in column window
    				gridStoreData.push(currentDefaultColumn);
    			}
    		});
    		
    		var columnWindow = Ext.create('Ext.window.Window', {
        	    alias: 'widget.columnWindow',
        	    itemId: 'columnWindowItemId',
        	    modal: true,
        	    resizable: true,
        	    autoScroll: false,
        	    frame: true,
        	    border: true,
        	    width: 700,
        	    height: 520,
        	    cls:'columnWindowCls',
        	   title: getCommonTranslation('COLUMNS'),
        	    recordId: id,
        	    dataGridId: dataGridId,
        	    items: [{
    	    		xtype: 'grid',
    	    		height: 420,
    	    		width: '100%',
    	    		cls:'columnsGridCls',
    	    		reserveScrollbar:true,
    	    		itemId: 'studentDisciplinaryCountWindowGrid',
    	    		store: Ext.create('Ext.data.Store', {
    	    			fields: ['id', 'columnName', 'dataIndex', 'columnVisibility', 'mandatory','keyName'],
    	        		data: gridStoreData
    	        	}),
    	    		style: {
    	    			'margin-bottom': '10px !important',
        	             'padding-bottom': '5px !important'
    	    		},
    	    		selType:'checkboxmodel',
    	    		selModel: {
    	    			checkOnly : true,
    	    			showHeaderCheckbox: false,
    	    			allowDeselect: false
    	    		},
    	    		margin:0,
    	    		padding:0,
    	    		border: true,
    	    	    viewConfig: {
    	    	        stripeRows: true
    	    	    },
    	    	    columns: [{
    	    			header: getCommonTranslation('COLUMN_NAME'),
    	    			dataIndex: 'columnName',
    	    	        sortable: true,
    	    	        flex: 1
    	    		}],
        	    	listeners: {
        	    		afterrender: function(grid){
        	    			setTimeout(function(){
        	    				//-- selecting all columns
        	    				grid.getSelectionModel().selectAll();
        	    				// Get the store associated with the grid
        	    				var store = grid.getStore();        	    			
        	    				grid.view.el.setScrollTop(0);        	    					
        	    				// Retrieve all records from the store
        	    				var allRecords = store.getRange();        	    				

        	    				var view = grid.getView();
        	    				var rawEmpty = []
        	    				var gridStore = grid.getStore();
        	    				//-- deselecting hidden columns on the basis of default/user Data
        	    				Ext.each(defaultColumns, function(currentDefaultColumn){
        	    					if(currentDefaultColumn.mandatory==true){
        	    						rawEmpty.push(currentDefaultColumn.dataIndex)        	    						
        	    						var defaultColumnVisible = "SHOW";
            	    					var userDefinedColumnVisible = "SHOW";
            	    					
            	    					if(currentDefaultColumn.columnVisibility=="HIDE"){
            	    						//findRecord( fieldName, value, [startIndex], [anyMatch], [caseSensitive], [exactMatch] ) 
                	    					var gridRecord = gridStore.findRecord('dataIndex',currentDefaultColumn.dataIndex,0,false,true,true);
                	    					if(!isNullOrEmpty(gridRecord)){
                	    						//gridRecord.config.isHideMand = true;
                	    						grid.getSelectionModel().deselect(gridRecord);
                	    					}
                	    					
            	    					}
                	    				Ext.each(allRecords, function(allRecord,index){
            	    						Ext.each(rawEmpty, function(rawEm,index){
            	    							if(allRecord.data.dataIndex == rawEm){
            	    								view.addRowCls(allRecord.index, 'custom-row-class'); 
            	    								if(allRecord.data.columnVisibility=="SHOW"){                	    								
                	    								view.addRowCls(allRecord.index, 'custom-row-class-show');
                	    							}
            	    							}            	    							
                	    					})
            	    					})
        	    					}
        	    					else{
        	    						var defaultColumnVisible = currentDefaultColumn.columnVisibility;
            	    					var userDefinedColumnVisible = defaultColumnVisible;
            	    					Ext.each(userDefinedColumns, function(currentUserColumn){
            	    						if(currentUserColumn.dataIndex==currentDefaultColumn.dataIndex){
            	    							userDefinedColumnVisible = currentUserColumn.columnVisibility;
            	    						}
            	    					});
        	    					}
        	    					        	    					
        	    					if(userDefinedColumnVisible=="HIDE"){
        	    						//findRecord( fieldName, value, [startIndex], [anyMatch], [caseSensitive], [exactMatch] ) 
            	    					var gridRecord = gridStore.findRecord('dataIndex',currentDefaultColumn.dataIndex,0,false,true,true);
            	    					if(!isNullOrEmpty(gridRecord)){
            	    						//gridRecord.config.isHideMand = false;
            	    						grid.getSelectionModel().deselect(gridRecord);
            	    					}
        	    					}
        	    				});
        	    				
        	    			
        	    				
        	    				//-- selecting/deselecting columns on the basis of user Data
        	    				/*Ext.each(userDefinedColumns, function(currentUserColumn){
        	    					var gridRecord = gridStore.findRecord('dataIndex',currentUserColumn.dataIndex);
        	    					if(!isNullOrEmpty(gridRecord)){
        	    						if(currentUserColumn.columnVisibility=="HIDE"){
            	    						grid.getSelectionModel().deselect(gridRecord);
            	    					}
        	    					}
        	    				});*/
        	    			},600);
        	    		},
        	    		beforedeselect: function( grid, record, index, eOpts ){
        	    			if(record.get('mandatory')){
        	    				return false;
        	    			}
        	    		},
        	    		beforeselect: function( grid, record, index, eOpts ){
        	    			if(record.get('mandatory')){
        	    				if(record.get('columnVisibility') == "HIDE"){
        	    					return false;	
        	    				}
        	    			}
        	    		},sortchange: function(grid){
        	    			setTimeout(function(){
        	    				grid = grid.grid;
        	    				//-- selecting all columns
        	    				grid.getSelectionModel().selectAll();
        	    				// Get the store associated with the grid
        	    				var store = grid.getStore();        	    			
        	    				grid.view.el.setScrollTop(0);        	    					
        	    				// Retrieve all records from the store
        	    				var allRecords = store.getRange();        	    				

        	    				var view = grid.getView();
        	    				var rawEmpty = []
        	    				var gridStore = grid.getStore();
        	    				//-- deselecting hidden columns on the basis of default/user Data
        	    				Ext.each(defaultColumns, function(currentDefaultColumn){
        	    					if(currentDefaultColumn.mandatory==true){
        	    						rawEmpty.push(currentDefaultColumn.dataIndex)        	    						
        	    						var defaultColumnVisible = "SHOW";
            	    					var userDefinedColumnVisible = "SHOW";
            	    					
            	    					if(currentDefaultColumn.columnVisibility=="HIDE"){
            	    						//findRecord( fieldName, value, [startIndex], [anyMatch], [caseSensitive], [exactMatch] ) 
                	    					var gridRecord = gridStore.findRecord('dataIndex',currentDefaultColumn.dataIndex,0,false,true,true);
                	    					if(!isNullOrEmpty(gridRecord)){
                	    						//gridRecord.config.isHideMand = true;
                	    						grid.getSelectionModel().deselect(gridRecord);
                	    					}
                	    					
            	    					}
                	    				Ext.each(allRecords, function(allRecord,index){
            	    						Ext.each(rawEmpty, function(rawEm,index){
            	    							if(allRecord.data.dataIndex == rawEm){
            	    								view.addRowCls(allRecord.index, 'custom-row-class'); 
            	    								if(allRecord.data.columnVisibility=="SHOW"){                	    								
                	    								view.addRowCls(allRecord.index, 'custom-row-class-show');
                	    							}
            	    							}            	    							
                	    					})
            	    					})
        	    					}
        	    					else{
        	    						var defaultColumnVisible = currentDefaultColumn.columnVisibility;
            	    					var userDefinedColumnVisible = defaultColumnVisible;
            	    					Ext.each(userDefinedColumns, function(currentUserColumn){
            	    						if(currentUserColumn.dataIndex==currentDefaultColumn.dataIndex){
            	    							userDefinedColumnVisible = currentUserColumn.columnVisibility;
            	    						}
            	    					});
        	    					}
        	    					        	    					
        	    					if(userDefinedColumnVisible=="HIDE"){
        	    						//findRecord( fieldName, value, [startIndex], [anyMatch], [caseSensitive], [exactMatch] ) 
            	    					var gridRecord = gridStore.findRecord('dataIndex',currentDefaultColumn.dataIndex,0,false,true,true);
            	    					if(!isNullOrEmpty(gridRecord)){
            	    						//gridRecord.config.isHideMand = false;
            	    						grid.getSelectionModel().deselect(gridRecord);
            	    					}
        	    					}
        	    				});
        	    				
        	    			
        	    				
        	    				//-- selecting/deselecting columns on the basis of user Data
        	    				/*Ext.each(userDefinedColumns, function(currentUserColumn){
        	    					var gridRecord = gridStore.findRecord('dataIndex',currentUserColumn.dataIndex);
        	    					if(!isNullOrEmpty(gridRecord)){
        	    						if(currentUserColumn.columnVisibility=="HIDE"){
            	    						grid.getSelectionModel().deselect(gridRecord);
            	    					}
        	    					}
        	    				});*/
        	    			},100);
        	    		}
        	    	}
    	    	}],
    	    	buttons:[{
    	    			xtype: 'button',
    	    			text: getCommonTranslation('APPLY'),
    	    			itemId: 'applyBtn',


    	    			ui: 'CustomBtnSubmit',
    	    			scale: CONSTANTS.BUTTONSIZE,
    	    			formBind:true,
    	    			handler: function(btn){
    	    				var me = this;
    	        			var grid = btn.up('window').down('grid');
    	        			
    	        			var baseController = Academia.app.getController('Academia.controller.base.BaseController');
    	        			var userInfo = Academia.model.authentication.UserInfoModel;
    	    				if(userInfo.data.portalId == 7) {
    	    					var userId = localStorage.getItem('parentUserId');
    	    				}
    	    				else {
    	    					var userId = baseController.getCurrentlyLoggedInUser().id;	
    	    				}
    	        			
    	        			var submitValue = [];
    	        			var recordId = btn.up('window').recordId;
    	        			var dataGridId = btn.up('window').dataGridId;
    	        			
    	        			var selectedItems = grid.getSelectionModel().selected;
    	        			
    	        			var sequence = 0;
    	        			Ext.each(grid.getStore().data.items, function(currentRecord){
    	        				sequence = sequence+1;
    	        				
    	        				var userColumnVisibility = "HIDE";
    	        				
    	        				Ext.each(selectedItems.items, function(currentSelectedItem){
    	        					if(currentSelectedItem.data.dataIndex==currentRecord.data.dataIndex){
    	        						userColumnVisibility = "SHOW";
    	        						return;
    	        					}
    	        				});
    	        				
    	        				var currentRecordValue = {
    	        						id: currentRecord.data.id,
    	                				columnName: currentRecord.data.keyName,
    	            					dataIndex: currentRecord.data.dataIndex,
    	            					columnVisibility: userColumnVisibility,
    	            					mandatory: currentRecord.data.mandatory,
    	                				sequence: sequence
    	        				};
    	        				
    	        				submitValue.push(currentRecordValue);
    	        			});

    	        			var jsonData = {};
    	        			var isApplicant = false;
    	        			if (portalId == 6) {
    	        				isApplicant = true;
							}
    	        			if(isNullOrEmpty(dataGridId)){
    	        				var dataGridId = recordId;
    	        				var jsonData = {
     	  							dataGridId:{
     	  								id:dataGridId
 	  								},
 	  								userId:{
 	  									id: userId
   									},
     	  							jsonObjectList: submitValue,
     	  							isApplicant: isApplicant
     	  							
     	  						}
    	        			}
    	        			else{
    	        				var jsonData = {
     	  							id: recordId,
     	  							dataGridId:{
     	  								id:dataGridId
 	  								},
 	  								userId:{
 	  									id: userId
   									},
     	  							jsonObjectList: submitValue,
     	  							isApplicant: isApplicant
     	  						}
    	        			}
    	        			
    	        			Ext.Ajax.request({
    	  						type : 'rest',
    	  						url : SERVERURL.PATH_UPDATE_GRID_COLUMN_CONFIGURATION_BY_USERID,
    	  						jsonData : jsonData,
    	  						method : 'POST',
    	  						success : function(form, action) {
    	  							try{
    	  								Ext.getBody().unmask();
    	  								showSuccessMessage(getCommonTranslation('GRID_CONFIGURATION'),getCommonTranslation('GRID_CONFIGURE_SUCCESS_MESSAGE'));
    	  								btn.up('window').close();
    	  								try {
    	  									Ext.ComponentQuery.query('changeprogramwindow')[0].close();
    	  								} catch (e) {
    	  								}
    	  								
    	  								var isALreadyClosed =false;
    	  								if(isNullOrEmpty(isWindow)){
    	  									var isSnapshotGRid = gridName;
    	  									if ((portalId == 6) && isSnapshotGRid == 'Academia.view.admission.applications.applicantProfileBase.SelectionSnapshotGrid'){
    	  										
    	  									}else{
    	  										Ext.ComponentQuery.query('contentPanel')[0].getActiveTab().close();
    	  									}
    	  									isALreadyClosed = true;
    	  								}else{
    	  									isWindow.close();		
    	  								}
    	  								if (portalId == 6) {
    	  									var isSnapshotGRid = gridName;
    	  									if (isSnapshotGRid == 'Academia.view.admission.applications.applicantProfileBase.SelectionSnapshotGrid') {
    	  										showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('CONFIRM_MSG_WANTTO_RELOAD'),
    	  												function(btn, text) {
    	  											if (btn == 'yes'){
    	  												window.location.reload()
    	  											}else{}
    	  											});
											}
										}else{
    	  								if (portalId == 6) {
    	  									var isSnapshotGRid = gridName;
    	  									if (isSnapshotGRid == 'Academia.view.admission.applications.applicantProfileBase.SelectionSnapshotGrid') {
    	  										showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('CONFIRM_MSG_WANTTO_RELOAD'),
    	  												function(btn, text) {
    	  											if (btn == 'yes'){
    	  												window.location.reload()
    	  											}else{}
    	  											});
											}
										}else if(isALreadyClosed==false){
											Ext.ComponentQuery.query('contentPanel')[0].getActiveTab().close();
										}
    	  							}
    	  							}
    	  							catch(e){}
    	  						}
    			  			});
    	    			}
    	    		},{
    	    			xtype: 'button',
    	    			itemId: 'resetBtn',
    	    			text: getCommonTranslation('RESETTODEFAULT'),
    	    			ui:'CustomBtnCancel',
    	    			scale: CONSTANTS.BUTTONSIZE,
    	    			handler: function(btn){
    	    				var me = this;
    	        			var grid = btn.up('window').down('grid');
    	        			
    	        			var submitValue = [];
    	        			var recordId = btn.up('window').recordId;
    	        			var dataGridId = btn.up('window').dataGridId;
    	        			if(!isNullOrEmpty(recordId)){
        	        			Ext.Ajax.request({
       	    						type: 'rest',
       	    						url: SERVERURL.PATH_RESET_GRID_COLUMN_CONFIGURATION+"?id="+recordId,
       	    						method: 'DELETE',
       	    						headers: {
       	    							'Content-Type': 'application/json'
       	    						},
       	    						success: function(form, action) {
       	    							try{
           	    							showSuccessMessage(getCommonTranslation('GRID_CONFIGURATION'),getCommonTranslation('GRID_CONFIGURE_SUCCESS_MESSAGE'));
           	    							btn.up('window').close();
           	    							try {
        	  									Ext.ComponentQuery.query('changeprogramwindow')[0].close();
        	  								} catch (e) {
        	  								}
        	  								if(isNullOrEmpty(isWindow)){
        	  									var isSnapshotGRid = gridName;
        	  									if ((portalId == 6) && isSnapshotGRid == 'Academia.view.admission.applications.applicantProfileBase.SelectionSnapshotGrid'){
            	  									var isSnapshotGRid = gridName;
            	  									if (isSnapshotGRid == 'Academia.view.admission.applications.applicantProfileBase.SelectionSnapshotGrid') {
            	  										showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('CONFIRM_MSG_WANTTO_RELOAD'),
            	  												function(btn, text) {
            	  											if (btn == 'yes'){
            	  												window.location.reload()
            	  											}else{}
            	  											});
        											}
        	  									}else{
        	  										Ext.ComponentQuery.query('contentPanel')[0].getActiveTab().close();
        	  									}	
           	    							
        	  								}else{
        	  									isWindow.close();	
        	  								}
       	    							}
       	    							catch(e){}
       	    						}
       	    					});
    	        			}
    	    			}
    	    		}],
    	    		buttonAlign:'right'
        	});
        	columnWindow.show();
        	Ext.defer(function() {
        		columnWindow.center();
        	}, 1000);
    	}
    	    	function changeState(recordId,currentRecord){
    		//getting data view here
    		//getting data view store here
    		//finding record in data  view store by record id
    		//getting tempstore
    		//if unchecked then remove record from tempstore 
    		//if checked then add record in tempstore from data view store
    		var checkedRecArray = [];
    		dataView = Ext.ComponentQuery.query('#galleryDataViewElection');
    		var dataViewStore = dataView[0].getStore();
    		var dataViewRecord = dataViewStore.findRecord('electionCandidateId',recordId);
    		var tempStore = Ext.getStore('electionTempStore');
    		var electionListStructure = Ext.ComponentQuery.query('studentvoteinelectionliststructure')[0];
    		var submittBtn = electionListStructure.down('#searchBtnElec');
		    var listPanel = electionListStructure.down('#listPanel');
    			/*var imageId = $("[name=imageId]:checked").map(function(){
    				return $(this).val();
    			}).get();
        		*/
		    var listPanel = electionListStructure.down('#listPanel');
			var NoOfchecked = Ext.query('#'+dataView[0].id+' input:checked');

			 if(NoOfchecked.length==1 && currentRecord.checked){
                 	 electionListStructure.config.temp=electionListStructure.config.temp+1;
                 electionListStructure.config.checkedInCurrentList = electionListStructure.config.temp;
                 }

             if(NoOfchecked.length==0){
             	 electionListStructure.config.temp=electionListStructure.config.temp-1;
             	  electionListStructure.config.checkedInCurrentList = electionListStructure.config.temp;
             }
                if(listPanel.items.length-1 == electionListStructure.config.checkedInCurrentList) {
                	submittBtn.setDisabled(false);

                }else{
                	submittBtn.setDisabled(true);
                }
				/*var electionAlbum = Ext.ComponentQuery.query('studentvoteinelectionalbumstructure')[0];
				var NoOfchecked = Ext.query('#'+dataView[0].id+' input:checked');

				
				 if(NoOfchecked.length==1){
					 electionListStructure.config.temp=electionListStructure.config.temp+1;
	                 electionListStructure.config.checkedInCurrentList = electionListStructure.config.temp;
	                 }
				if(NoOfchecked>0){
					submittBtn.setDisabled(false);
				}*/
				
				if(currentRecord.checked){
				if(NoOfchecked.length > dataViewRecord.data.maximumVoteInList){
					currentRecord.checked=false;
		    			var rowIndex = tempStore.find('electionCandidateId', recordId);
		    			tempStore.removeAt(rowIndex);
			        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('YOU_CANNOT_VOTE_FOR_MAXIMUM')+" "+dataViewRecord.raw.maximumVoteInWord+" ("+dataViewRecord.data.maximumVoteInList+") "+getCommonTranslation('CANDIDATE'));

				}else{
					tempStore.add(dataViewRecord.data);
				}
				}else{
					var rowIndex = tempStore.find('electionCandidateId', recordId);
	    			tempStore.removeAt(rowIndex);
				}
				
				/*if(currentRecord.checked){
	    			tempStore.add(dataViewRecord.data);
	    		}else{
	    			var rowIndex = tempStore.find('electionCandidateId', recordId);
	    			tempStore.removeAt(rowIndex);
	    		}*/

				/*if(currentRecord.checked && flag==1){
					canListStore.add(dataViewRecord.data);
	    		}else{
	    			var rowIndex = canListStore.find('electionCandidateId', recordId);
	    			canListStore.removeAt(rowIndex);
	    		}*/
    		}
    	function candidateDetail(recordId,candidateListName){
    		
    		dataView = Ext.ComponentQuery.query('#galleryDataViewElection');
    		var dataViewStore = dataView[0].getStore();
    		var dataViewRecord = dataViewStore.findRecord('electionCandidateId',recordId);
    		var electionListStructure = Ext.ComponentQuery.query('studentvoteinelectionliststructure')[0];
    		var candidateInfoWindow = Ext.create('Ext.window.Window', {
				alias: 'widget.candidatealbuminfowindow',
				itemId: 'candidatealbuminfowindowItemId',
				modal: true,
				resizable: true,
				frame: true,
				border: true,
				autoScroll:true,
				width: 450,
				height: 270,
				title: getCommonTranslation('CANDIDATES_INFORMATION'),
				items: [{
					xtype: 'fieldcontainer',
					layout: 'vbox',
					width:'100%',
					defaults: {
						width: 400,
						labelWidth: 120,
						labelAlign: 'left',
						xtype: 'displayfield',
						//cls:'electionDisplayFieldCls'
					},
					items:[{
						name: 'candidateListwin',
						itemId: 'candidateListwin',
						fieldLabel: getCommonTranslation('CANDIDATE_LIST'),
						readOnly:true,
					},{
						name: 'candidateTypewin',
						itemId: 'candidateTypewin',
						fieldLabel: getCommonTranslation('CANDIDATES_TYPE'),
						readOnly:true,
					},{
						name: 'candidateNamewin',
						itemId: 'candidateNamewin',
						fieldLabel: getCommonTranslation('CANDIDATES_NAME'),
						readOnly:true,
					},{
						name: 'departmentwin',
						itemId: 'departmentwin',
						fieldLabel: getCommonTranslation('DEPARTMENT'),
						readOnly:true,
					},{
						name: 'missionStatement',
						itemId:'missionStatement',
						readOnly:true,
						fieldLabel:getCommonTranslation('MISSION_STATEMENT')
					}]
				}]		
			});
    		candidateInfoWindow.show();
    		var candidateListwin = candidateInfoWindow.down('#candidateListwin');
    		var candidateTypewin = candidateInfoWindow.down('#candidateTypewin');
    		var candidateNamewin = candidateInfoWindow.down('#candidateNamewin');
    		var departmentwin = candidateInfoWindow.down('#departmentwin');
    		var missionStatement = candidateInfoWindow.down('#missionStatement');
    		candidateListwin.setValue(electionListStructure.config.candidateListName);
    		if(dataViewRecord.data.candidateType == "STUDENTS"){
    			candidateTypewin.setValue(getCommonTranslation('STUDENT'));
    			departmentwin.setFieldLabel(getCommonTranslation('PROGRAM'));
    			departmentwin.setValue(dataViewRecord.data.programOrDepartmentName);
    		}else if(dataViewRecord.data.candidateType == "STAFF_USERS"){
    			candidateTypewin.setValue(getCommonTranslation('STAFF_USERS'));
    			departmentwin.setValue(dataViewRecord.data.programOrDepartmentName);
    		}else{
    			candidateTypewin.setValue(getCommonTranslation('EXTERNAL_USERS'));
    			departmentwin.setFieldLabel(getCommonTranslation('EMAIL'));
    			departmentwin.setValue(dataViewRecord.raw.emailId);
    		}
    		
    		candidateNamewin.setValue(dataViewRecord.data.candidateName);
            missionStatement.setValue(dataViewRecord.data.candidateStatement);
                     
    	}
    	
    	function isValidFile(fileName){
    		var disAllowExt = ["php","config","htaccess","asp","jsp","js","exe","zip","webp"];
    		var splitFileName = fileName.split(".");
    		var disallowed = false;
    		if(splitFileName.length>2){
    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MULTIPLE_EXTENSION_FILE_ERROR'));
    			return false;
    		}
    		else{
    			Ext.each(disAllowExt, function(ext) {
    	    		if (ext === splitFileName[1]) {
    	    			disallowed = true;
    	    		}
    	    	});
    		}
    		
    		if(disallowed==true){
    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_UPLOAD_EXTENSION_NOT_ALLOWED'));
    			return false;
    		}
    		else{
    			return true;
    		}
    		
    	}
    	
    	$.ajaxSetup({
    	    beforeSend: function(xhr) {
    	    	secMe('','','',this,xhr);
    	    }
    	}); 
    	
    	Date.prototype.toISOString = function () {
    	    return moment(this).format("YYYY-MM-DDTHH:mm:ss");
    	};
    	
    	function getFormDataJson(form){
    		var unindexed_array = form.serializeArray();
    	    var indexed_array = {};

    	    $.map(unindexed_array, function(n, i){
    	        indexed_array[n['name']] = n['value'];
    	    });

    	    return indexed_array;
    	}
    	function isNumberValidate(str) {
    		 var code, i, len;

    		 for (i = 0, len = str.length; i < len; i++) {
    		   code = str.charCodeAt(i);
    		   if (!(code > 47 && code < 58)) { // lower alpha (a-z)
    		     return false;
    		   }
    		 }
    		 return true;
    	}
    	
    	function preRegAcceptCheck(checkbox){
    		var acceptBtn = Ext.ComponentQuery.query('#btnContinue')[0];
    		if(checkbox.checked){
    			acceptBtn.setDisabled(false);
    		}
    		else{
    			acceptBtn.setDisabled(true);
    		}
    	}
    	
    	function regContractAcceptCheck(checkbox){
    		if($('[name=check1]').length==0){
    			var check1Checked = true;
    		}
    		else{
        		var check1Checked = $('[name=check1]')[0].checked;
    		}
    		if($('[name=check2]').length==0){
    			var check2Checked = true;
    		}
    		else{
    			var check2Checked = $('[name=check2]')[0].checked;
    		}
    		if($('[name=check3]').length==0){
    			var check3Checked = true;
    		}
    		else{
    			var check3Checked = $('[name=check3]')[0].checked;
    		}
    		var btnWinSubmit = Ext.ComponentQuery.query('#btnWinSubmit')[0];
    		if(check1Checked && check2Checked && check3Checked){
    			btnWinSubmit.setDisabled(false);
    		}
    		else{
    			btnWinSubmit.setDisabled(true);
    		}
    	}
    	
    	function downloadBase64File(contentType, base64Data, fileName) {
    	     var linkSource = 'data:'+contentType+';base64,'+base64Data;
    	     var downloadLink = document.createElement("a");
    	     downloadLink.href = linkSource;
    	     downloadLink.download = fileName;
    	     downloadLink.click();
    	}
    	
    	function getd365Date(dt){
    		if(typeof dt == "object"){
    			var nDt = dt;
    		}
    		else{
    			var nDt = new Date(dt);
    		}
    		var txtDt = dt.getFullYear()+"-"+((dt.getMonth()+1)<10?"0"+(dt.getMonth()+1):(dt.getMonth()+1))+"-"+((dt.getDate())<10?"0"+(dt.getDate()):(dt.getDate()))+"T"+((dt.getHours())<10?"0"+(dt.getHours()):(dt.getHours()))+":"+((dt.getMinutes())<10?"0"+(dt.getMinutes()):(dt.getMinutes()))+"Z";
    		return txtDt;
    	}
    	
    	function isImageOrPDFDocument(documentName){
    		if(documentName.match(/.(jpg|jpeg|png|gif|pdf)$/i)){
    			return true;
    		}
    		else{
    			return false;
    		}
    	}
    	function generateQr(data, title, subtitle) {
			var qrCodeImg = new QRCode(document.getElementById("qrcode"), {
				text: data,
				width: 180,
				height: 180,
				colorDark: "#000000",
				colorLight: "#ffffff",

				title: title,
				titleFont: "bold 18px Arial",
				titleColor: "#004284",
				titleBgColor: "#fff",
				titleHeight: 70,
				titleTop: 25,

				subTitle: subtitle,
				subTitleFont: "14px Arial",
				subTitleColor: "#004284",
				subTitleTop: 40,

				logo:"resources/images/qrLogo.jpg",
				logoBgColor:'#ffffff',
				logoBgTransparent:false,

				correctLevel: QRCode.CorrectLevel.H
			});
			
			setTimeout(function(){
				document.getElementById("qrcode").title = 'Attendance QR Code by Academia';
				document.getElementById("qrcode").children[1].setAttribute("style","margin:auto;display:block;");
			},500);
			
			return qrCodeImg;
		}
    	function isAlreadyMasked(){
    		var isActiveWindowMasked = false;
    		var isContentPanelMasked = false;
    		var isBodyMasked = false;
    		
    		//--START - checking for active window mask
    		try{
        		var activeWindow= Ext.WindowMgr.getActive( ).getMaskTarget();
        		isActiveWindowMasked = activeWindow.isMasked();
    		}
    		catch(e){
    			isActiveWindowMasked = false;
    		}
    		//--END - checking for active window mask
    		
    		//--START - checking for active content panel mask
    		try{
        		var contentPanelEl= Ext.ComponentQuery.query('contentpanel')[0].el;
        		isContentPanelMasked = contentPanelEl.isMasked();
    		}
    		catch(e){
    			isContentPanelMasked = false;
    		}
    		//--END - checking for active content panel mask
    		
    		//--START - checking for body mask
    		try{
        		var bodyEl= Ext.getBody();
        		isBodyMasked = bodyEl.isMasked();
    		}
    		catch(e){
    			isBodyMasked = false;
    		}
    		//--END - checking for body mask
    		
    		if(isActiveWindowMasked == true || isContentPanelMasked == true || isBodyMasked == true){
    			return true;
    		}
    		else{
    			return false;
    		}
    	}
    	
    	function applyMenuBottomBorder(){
    		if($('#menuHolder-body .group1Cls').length){
        		$('#menuHolder-body .group1Cls').last().addClass("bottomBorderCls");
    		}
			if($('#menuHolder-body .group2Cls').length){
				$('#menuHolder-body .group2Cls').last().addClass("bottomBorderCls");
			}
			if($('#menuHolder-body .group3Cls').length){
				$('#menuHolder-body .group3Cls').last().addClass("bottomBorderCls");
			}
			if($('#menuHolder-body .group4Cls').length){
				$('#menuHolder-body .group4Cls').last().addClass("bottomBorderCls");
			}
			if($('#menuHolder-body .group5Cls').length){
				$('#menuHolder-body .group5Cls').last().addClass("bottomBorderCls");
			}
			if($('#menuHolder-body .group6Cls').length){
				$('#menuHolder-body .group6Cls').last().addClass("bottomBorderCls");
			}
			
			if($('#placeholderLbar-body .group1Cls').length){
        		$('#placeholderLbar-body .group1Cls').last().addClass("bottomBorderCls");
    		}
			if($('#placeholderLbar-body .group2Cls').length){
				$('#placeholderLbar-body .group2Cls').last().addClass("bottomBorderCls");
			}
			if($('#placeholderLbar-body .group3Cls').length){
				$('#placeholderLbar-body .group3Cls').last().addClass("bottomBorderCls");
			}
			if($('#placeholderLbar-body .group4Cls').length){
				$('#placeholderLbar-body .group4Cls').last().addClass("bottomBorderCls");
			}
			if($('#placeholderLbar-body .group5Cls').length){
				$('#placeholderLbar-body .group5Cls').last().addClass("bottomBorderCls");
			}
			if($('#placeholderLbar-body .group6Cls').length){
				$('#placeholderLbar-body .group6Cls').last().addClass("bottomBorderCls");
			}
    	}
    	function hasDuplicates(arr) {
    	    var counts = [];

    	    for (var i = 0; i <= arr.length; i++) {
    	        if (counts[arr[i]] === undefined) {
    	            counts[arr[i]] = 1;
    	        } else {
    	            return true;
    	        }
    	    }
    	    return false;
    	}
    	
    	function searchInArray(nameKey, myArray){
    	    for (var i=0; i < myArray.length; i++) {
    	        if (myArray[i].dependentFieldName === nameKey) {
    	            return myArray[i];
    	        }
    	    }
    	}
    	
    	function onlyUnique(value, index, array) {
		  return array.indexOf(value) === index;
		}
    	
    	function hasDuplicates(arr) {
    	    var counts = [];

    	    for (var i = 0; i <= arr.length; i++) {
    	        if (counts[arr[i]] === undefined) {
    	            counts[arr[i]] = 1;
    	        } else {
    	            return true;
    	        }
    	    }
    	    return false;
    	}
    	
    	function typeWriter(field, txt, i) {
    		if (i < txt.length) {
    			field.setValue(field.getValue()+txt.charAt(i));
    			i++;
    			setTimeout(function() {
    				typeWriter(field, txt, i);
    			}, 10);
    		}
    		else {
    			field.up('window').down('button[itemId=saveBtnWin]').setDisabled(false);
    			field.up('window').down('button[itemId=generateBtnWin]').setDisabled(false);
    		}
    	}
    	function typeWriterEvaluationGenericRemark(field, txt, i) {
    		if (i < txt.length) {
    			field.setValue(field.getValue()+txt.charAt(i));
    			i++;
    			setTimeout(function() {
    				typeWriterEvaluationGenericRemark(field, txt, i);
    			}, 10);
    		}
    		else {
    			field.up('window').down('button[itemId=submitBtnWin]').setDisabled(false);
    			field.up('window').down('button[itemId=generateGenericBtnRemark]').setDisabled(false);
    		}
    	}
    	
    	function typeWriterAssignment(field, txt, i) {
    		if (i < txt.length) {
    			field.setValue(field.getValue()+txt.charAt(i));
    			i++;
    			setTimeout(function() {
    				typeWriterAssignment(field, txt, i);
    			}, 10);
    		}else{
    			field.up('assignmentdetails').down('button[itemId=generateBtnAssignment]').setDisabled(false);
    		}
    	}
    	//***************** Placeholder Type suggesstion Code**************************
    	// Add something to given element placeholder
    	function addToPlaceholder(toAdd, el,shortDescription) {
    	    //el.attr('placeholder', shortDescription.getEl().dom.setAttribute('placeholder') + toAdd);
    		//shortDescription.getEl().dom.setAttribute('placeholder',toAdd);
    		//this.setFieldPlaceHolder(shortDescription,toAdd);
    		if(!isNullOrEmpty(shortDescription.inputEl)){
    			
    			shortDescription.inputEl.dom.placeholder=shortDescription.inputEl.dom.placeholder+toAdd;
    		}
    	    // Delay between symbols "typing" 
    	    return new Promise(function (resolve) {
    	    	  return setTimeout(resolve, 100);
    	    });
    	}
    	// Cleare placeholder attribute in given element
    	function clearPlaceholder(shortDescription) {
    		if(!isNullOrEmpty(shortDescription.inputEl)){
    		shortDescription.inputEl.dom.placeholder='';
    		}
    	}
    	// Print one phrase
    	function printPhrase(phrase, el,shortDescription) {
    	    return new Promise(function (resolve) {
    	    	  // Clear placeholder before typing next phrase
    	    	  clearPlaceholder(shortDescription);
    	    	  var letters = phrase.split('');
    	    	  // For each letter in phrase
    	    	  letters.reduce(function (promise, letter, index) {
    	    	    return promise.then(function () {
    	    	      // Resolve promise when all letters are typed
    	    	      if (index === letters.length - 1) {
    	    	        // Delay before start next phrase "typing"
    	    	        setTimeout(resolve, 1000);
    	    	      }
    	    	      return addToPlaceholder(letter, el, shortDescription);
    	    	    });
    	    	  }, Promise.resolve());
    	    	});
    	} 
    	// Print given phrases to element
    	function printPhrases(phrases, el,shortDescription) {
    	    // For each phrase
    	    // wait for phrase to be typed
    	    // before start typing next
    		phrases.reduce(function (promise, phrase) {
    			  return promise.then(function () {
    			    return printPhrase(phrase, el, shortDescription);
    			  });
    			}, Promise.resolve());
    	}
    	// Start typing
    	function runPlaceHolderTypeWriting(shortDescription,screen) {
    		if(screen =='Assignmentdetails'){
    			 var phrases = [
    	    	        "e.g. Engage in a brief assessment to test your knowledge on the recent lessons.",
    	    	        "Prepare a comprehensive analysis of the given topic, demonstrating critical thinking and research skills.",
    	    	        "Describe the assignment requirements here.",
    	    	        "Describe the quiz or assignment you need."
    	    	    ];
    		}else{
    			var phrases = [
        	        "e.g. Publish research findings in academic journals.",
        	        "Manage office operations and administrative tasks.",
        	        "Support staff and assist with HR-related tasks.",
        	        "Develop lesson plans and educational materials."
        	    ];
    		}
    	    printPhrases(phrases, $('#search'),shortDescription);
    	}
    	
    	function isValidJson(json) {
    	    try {
    	        JSON.parse(json);
    	        return true;
    	    } catch (e) {
    	        return false;
    	    }
    	}
    	
    	function searchColumnInArray(dataIndex, columns, byDataIndex){
    	    for (var i=0; i < columns.length; i++) {
    	    	if(byDataIndex) {
    	    		if (columns[i].dataIndex === dataIndex) {
        	            return columns[i];
        	        }
        		}
    	        if (columns[i].name === dataIndex) {
    	            return columns[i];
    	        }
    	    }
    	}
    	
  //-START HERE--Please Do Not Remove or Uncomment This Code--- Author: Raghavendra.Soni  - Updated By Jay Soni Added Dynamic RSA Keys
    	/*function sumAscVal(jsonString) {
    	    if (!jsonString) return 0;
    	    
    	    // Step 1: unescape only Unicode sequences if present
    	    
    	    if (jsonString.indexOf("\\u") !== -1) {
    	        jsonString = jsonString.replace(/\\u([0-9a-fA-F]{4})/g, function(match, hex) {
    	            return String.fromCharCode(parseInt(hex, 16));
    	        });
    	    }
    	    
    	    // Step 2: sum over code points
    	    var sum = 0;
    	    for (var i = 0; i < jsonString.length; i++) {
    	        var code = jsonString.charCodeAt(i);
    	        
    	        // handle surrogate pairs
    	        if (code >= 0xD800 && code <= 0xDBFF && i + 1 < jsonString.length) {
    	            var low = jsonString.charCodeAt(i + 1);
    	            if (low >= 0xDC00 && low <= 0xDFFF) {
    	                code = ((code - 0xD800) << 10) + (low - 0xDC00) + 0x10000;
    	                i++; // skip low surrogate
    	            }
    	        }
    	        sum += code;
    	    }
    	    return sum;
    	}

    	function convertValuesToString(obj) {
    		for (var key in obj) {
    			if (obj.hasOwnProperty(key)) {
    				if (obj[key] === null || typeof obj[key] == "undefined") {
    					obj[key] = ""; // Convert null to empty string
    				} else if (typeof obj[key] === 'number') {
    					obj[key] = obj[key].toString();
    				} else if (typeof obj[key] === 'object') {
    					// If the value is an object, recursively convert its values to strings
    					obj[key] = convertValuesToString(obj[key]);
    				}
    			}
    		}
    		return obj;
    	}
    	function getUrlParams(url) {
    		var params = {};
    		var urlParts = url.split('?');
    		if (urlParts.length > 1) {
    			var queryString = urlParts[1];
    			var paramPairs = queryString.split('&');
    			for (var i = 0; i < paramPairs.length; i++) {
    				var pair = paramPairs[i].split('=');
    				var key = decodeURIComponent(pair[0]);
    				var value = decodeURIComponent(pair[1] || '');
    				params[key] = value;
    			}
    		}
    		return params;
    	}

    	function genFLink(baseUrl, params) {
    		var url = baseUrl;
    		var queryString = '';
    		var existingParams = {};

    		var urlParts = url.split('?');
    		if (urlParts.length > 1) {
    			var pairs = urlParts[1].split('&');
    			pairs.forEach(function(pair) {
    				var keyValue = pair.split('=');
    				existingParams[decodeURIComponent(keyValue[0])] = decodeURIComponent(keyValue[1]);
    			});
    		}
    		if (params) {
    			var queryParams = [];
    			for ( var key in params) {
    				if (params.hasOwnProperty(key) && !(key in existingParams)) {
					if ((/\s\d{2}:\d{2}:\d{2}/.test(params[key]) || /date/i.test(key)) && !isNullOrEmpty(params[key])) {
    						var dateValue = new Date(params[key]);
    						if (typeof (params[key]) == 'number') {
    							paramValue = Date.parse(dateValue);
    						} else if(!/\d{2}:\d{2}:\d{2}/.test(params[key])){
    							//queryParams.push(encodeURIComponent(key) + '=' + (isNullOrEmpty(params[key]) ? '' : encodeURIComponent(params[key])));
    							paramValue=params[key];
    						}  else {
    							paramValue = dateValue.toISOString().split('.')[0];
    						}
    						if(paramValue.includes('T') && key != 'batchendDate' && key != 'attendanceDate' && (baseUrl.indexOf("getStudentListBySectionId") == -1)){
								paramValue = paramValue.replace('T', ' ');
							}
    						queryParams.push(encodeURIComponent(key) + '=' + (isNullOrEmpty(paramValue) ? '' : encodeURIComponent(paramValue)));
    					} else if (Array.isArray(params[key])
    							&& params[key].length === 0) {
    						// In case of Blank Array this parameter is not part of
    						// server request so leaving here to skip
    						// as if added UI request query string and server request
    						// query string will be different and we got Invalid Request
    						// 400

    						// queryParams.push(encodeURIComponent(key) + '=' + ('') );
    					} else {
    						queryParams.push(encodeURIComponent(key) + '=' + (isNullOrEmpty(params[key]) ? '' : encodeURIComponent(params[key])));
    					}
    				}
    			}
    			queryString = queryParams.join('&');
    		}

    		var dcRegex = /[\?&]_dc=[^&]+/;
    		url = url.replace(dcRegex, '');

    		queryString=decodeURIComponent(queryString);
    		if (queryString) {
    			url += ((url.indexOf('?') != -1) ? ('&' + queryString) : ('?' + queryString));
    		}
    		var parts = url.split('?');
    		return parts.length > 1 ? parts[1] : '';
    	}

    	function tkn(conn, options, eOpts, jReq, xhr) {
    		var encrypt = new JSEncrypt();
    		encrypt.setPublicKey(gtk());
    		var encrypted = '';
    		if (!isNullOrEmpty(jReq)) {
    			try {
    				var tkn = xhr.getRequestHeader('access_token');
    				var tknHash = genHs(tkn);
    				var tknPramHash32 = (tknHash > 16) ? tknHash.substr(0, 16) : tknHash;
    			}
    			catch (e) {
    				var encrypted = '';
    			}
    		} else if (conn && conn.defaultHeaders && conn.defaultHeaders.access_token && !isNullOrEmpty(conn.defaultHeaders.access_token)) {
    			try {
    				var tkn = conn.defaultHeaders.access_token;
    				var tknHash = genHs(tkn);
    				var tknPramHash32 = (tknHash.length > 16) ? tknHash.substr(0, 16) : tknHash; //Part1

    				var performanceMilliseconds = new Date().getTime();
    				var nanoseconds = performanceMilliseconds * 1e6;
    				var nanoHash = genHs(nanoseconds);
    				var nanoPramHash32 = (nanoHash.length > 16) ? nanoHash.substr(0, 16) : nanoHash; //Part2

    				if (options && options.url && !isNullOrEmpty(options.url)) {
    				
    				var fullURL = genFLink(options.url, options.params);
					
					if (!fullURL || fullURL.length === 0) {
						var urlParams = "BLANK";
						}
					else {
						urlParams = sumAscVal(fullURL);
						}
    				}
    				else {
    					var urlParams = "BLANK";
    				}
    				var urlParamHash = genHs(urlParams);
    				var urlPramHash32 = (urlParamHash.length > 16) ? urlParamHash.substr(0, 16) : urlParamHash; //Part3

    				var jsonData = options.jsonData;
    				var bodyData = options.bodyData;
    				var formData = options.formData;

    				var bodyJsonObj = {};
    				if (jsonData) {
    					bodyJsonObj = jsonData;
    				} else if (bodyData) {
    					bodyJsonObj = Ext.decode(bodyData);
    				} else if (formData) {
    					formData.each(function(key, value) {
    						bodyJsonObj[key] = value;
    					});
    				}

    				bodyJsonObj = isNullOrEmpty(bodyJsonObj) ? {} : bodyJsonObj;

    				if (Object.keys(bodyJsonObj).length === 0) {
    					var bodyParams = "BLANK";
    				}
    				else {
    					if (typeof bodyJsonObj == "object") {
    						var bodyParams = JSON.stringify(bodyJsonObj);
    					}
    					else {
    						var bodyParams = bodyJsonObj;
    					}
    					bodyParams = sumAscVal(bodyParams);
    				}
    				var bodyParamHash = genHs(bodyParams);
    				var bodyParamHash32 = (bodyParamHash.length > 16) ? bodyParamHash.substr(0, 16) : bodyParamHash; //Part4

    				var finalHashString = tknPramHash32 + nanoPramHash32 + urlPramHash32 + bodyParamHash32;

    				var encrypted = encrypt.encrypt(finalHashString);
    			}
    			catch (e) {
    				var encrypted = '';
    			}
    		}

    		if (!isNullOrEmpty(encrypted)) {
    			if (isNullOrEmpty(jReq)) {
    				Ext.Ajax.defaultHeaders.nonce = encrypted;
    			}
    			else {
    				xhr.setRequestHeader('nonce', encrypted);
    			}
    		}
    	}

    	function secMe(conn, options, eOpts, jReq, xhr) {

    		if (conn && isNullOrEmpty(conn.defaultHeaders)) {
    			var tokenApiResponse = Ext.decode(localStorage.getItem('tokenApiResponse'));
    			var academylocationid = Ext.decode(localStorage.getItem('academylocationid'));
    			var wheatherSchool = Ext.decode(localStorage.getItem('wheatherSchool'));

    			if (!isNullOrEmpty(tokenApiResponse) && !isNullOrEmpty(tokenApiResponse.Authorization) && !isNullOrEmpty(academylocationid)) {
    				Ext.Ajax.defaultHeaders = {
    						Authorization: "Bearer " + tokenApiResponse.access_token,
    						expires_in: tokenApiResponse.expires_in,
    						access_token: tokenApiResponse.access_token,
    						refresh_token: tokenApiResponse.refresh_token
    				};
    				var userInfo = Academia.model.authentication.UserInfoModel;

    				userInfo.set("accessToken", tokenApiResponse.access_token);
    				userInfo.set("refreshToken", tokenApiResponse.refresh_token);
    				userInfo.set("expiryTimeForAccessToken", tokenApiResponse.expires_in);

    				conn.defaultHeaders = Ext.Ajax.defaultHeaders;
    			}
    		}

    		tkn(conn, options, eOpts, jReq, xhr);
    	}

    	function genHs(plainText) {
    		var md = forge.md.sha256.create();
    		md.start();
    		md.update(plainText, "utf8");
    		var hashText = md.digest().toHex();
    		return hashText;
    	}

    	function gtk() {
    		if(!isNullOrEmpty(localStorage.getItem('nonsec'))){
    			return localStorage.getItem('nonsec');
    		}
    		else {
    			return CONST.PUBLIC_KEY_FOR_AUTENTICATION;
    		}
    	}*/
	    //-END HERE--Please Do Not Remove or Uncomment This Code--- Author: Raghavendra.Soni
    	  	
//********************************End Code **************************************/  
    	
    	/*---------- START - Analytics related function--------*/
	    	/*function getReport(structure, $this){
				var isData=false;
				var obj;
				var id=$this.structureId(structure);
				if(id=="COURSE_GROUP_REPORT" && localStorage.getItem('portalId') != "1"){
					var idParam = "COURSE_GROUP_STUDENT_REPORT";
				} else{
					var idParam = id;
				}
				Ext.Ajax.request({
					type : 'rest',
					url :  "rest/analytics/findReport"+"?key="+idParam,
					method : 'GET',
					async: false,
					success : function(response) {
						obj=JSON.parse(response.responseText);
						isData=true
					},
					failure:function(response){
						try{
							structure.down('#refreshdset').setVisible(false);
							structure.down('#printBtn').setVisible(false);
							structure.down('#editbtn').setVisible(false);
							structure.down('#reload').setVisible(false);
							var responseData = Ext.decode(response.responseText);
							if(isNullOrEmpty(responseData[0].key)){
								if(responseData[0].key == 'NO_REPORT_MAPPING'){
									showWarningMessage(getCommonTranslation('ALERT'),getAnalyticsTranslation('NO_REPORT_MAPPING'));
								}else{
									showWarningMessage(getCommonTranslation('ALERT'),getAnalyticsTranslation('POWER_BI_REPORT_MAPPING_ERROR'));
								}
							}
						}
						catch(e){
						}
					}
				});
				if(isData){
					var reportId=obj.reportId;
					Academia.app.powerBIToken=obj.token;
					var navContentPaneEnabled=(obj.navContentPaneEnabled=='true');
					var filterArray = new Array();
					Ext.each(obj.filter,function(data){
						var objectArray = new Array();
						var columnName=data.columnName;
						var tableName=data.tableName;
						if(data.filterName=='AC_AL'){
							Ext.each(Academia.utilities.accessControl.AccessControlManager.allocatedAcademyLocations,function(data1){
								objectArray.push(data1.id);
							});
							var filter= filters(tableName,columnName,objectArray);
							filterArray.push(filter);
						} else if(data.filterName=='AC_PRG'){
							objectArray=obj.accessiblePrograms;
							var filter= filters(tableName,columnName,objectArray);
							filterArray.push(filter);
						} else if(data.filterName=='STUDENT_CODE'){
							var portalInfo = Academia.model.authentication.PortalInfoModel;
							var student = portalInfo.get('student')
							objectArray.push(student.code);
							var filter= filters(tableName,columnName,objectArray);
							filterArray.push(filter);
	
						}else if(data.filterName=='FACULTY_CODE'){
							var currentLoggedUser=$this.getCurrentlyLoggedInUser();
							var code = currentLoggedUser.code;
							objectArray.push(code);
							var filter= filters(tableName,columnName,objectArray);
							filterArray.push(filter);
	
						}
	
						else if(data.filterName=='AC_AL_FACULTY'){
							var currentLoggedUser=$this.getCurrentlyLoggedInUser();
							var url = SERVERURL.FIND_AL_BY_USER_ID;
							var alIds = [];
							Ext.Ajax.request({
								type : 'rest',
								url : url,
								method : 'GET',
								params: {
									id : currentLoggedUser.id
								},
								success : function(form, action) {
									var response = Ext.decode(form.responseText);
									for(var index in response) {
										alIds.push(response[index].id);
									}
									objectArray.push(alIds);
									var filter= filters(tableName,columnName,objectArray);
									filterArray.push(filter);
									var models = window['powerbi-client'].models;
									var embedConfiguration = {
											type: 'report',
											accessToken: Academia.app.powerBIToken,
											persmissions:models.Permissions.All,
											id:reportId,
											embedUrl: SERVERURL.PATH_POWER_BI_EMBED_REPORT,
											settings: {
												filterPaneEnabled: false,
												navContentPaneEnabled: navContentPaneEnabled
											}
									}; 
									loadReportPowerBi(id,embedConfiguration,filterArray,navContentPaneEnabled);
									structure.on('activate',function(){
										var id=$this.structureId(structure);
										getAccessToken(id);
									});
								}
							});
							
							
						}else if(data.filterName=='AC_AL_FACULTY_PROGRAM'){
							var currentLoggedUser=$this.getCurrentlyLoggedInUser();
							var url = SERVERURL.FIND_AL_PROGRAMS_OR_COURSES_BY_USER_ID;
							var alIds = [];
							Ext.Ajax.request({
								type : 'rest',
								url : url,
								method : 'GET',
								params: {
									
									isCourseData : false
								},
								success : function(form, action) {
									var response = Ext.decode(form.responseText);
									for(var index in response) {
										objectArray.push(response[index]);
									}
									var filter= filters(tableName,columnName,objectArray);
									filterArray.push(filter);
									var models = window['powerbi-client'].models;
									var embedConfiguration = {
											type: 'report',
											accessToken: Academia.app.powerBIToken,
											persmissions:models.Permissions.All,
											id:reportId,
											embedUrl: SERVERURL.PATH_POWER_BI_EMBED_REPORT,
											settings: {
												filterPaneEnabled: false,
												navContentPaneEnabled: navContentPaneEnabled
											}
									}; 
									loadReportPowerBi(id,embedConfiguration,filterArray,navContentPaneEnabled);
									structure.on('activate',function(){
										var id=$this.structureId(structure);
										getAccessToken(id);
									});
								}
							});
							
							
						}else if(data.filterName=='AC_AL_FACULTY_COURSE'){
							var currentLoggedUser=$this.getCurrentlyLoggedInUser();
							var url = SERVERURL.FIND_AL_PROGRAMS_OR_COURSES_BY_USER_ID;
							var alIds = [];
							Ext.Ajax.request({
								type : 'rest',
								url : url,
								method : 'GET',
								params: { 
									isCourseData : true
								},
								success : function(form, action) {
									var response = Ext.decode(form.responseText);
									for(var index in response) {
										objectArray.push(response[index]);
									}
									var filter= filters(tableName,columnName,objectArray);
									filterArray.push(filter);
									var models = window['powerbi-client'].models;
									var embedConfiguration = {
											type: 'report',
											accessToken: Academia.app.powerBIToken,
											persmissions:models.Permissions.All,
											id:reportId,
											embedUrl: SERVERURL.PATH_POWER_BI_EMBED_REPORT,
											settings: {
												filterPaneEnabled: false,
												navContentPaneEnabled: navContentPaneEnabled
											}
									}; 
									loadReportPowerBi(id,embedConfiguration,filterArray,navContentPaneEnabled);
									structure.on('activate',function(){
										var id=$this.structureId(structure);
										getAccessToken(id);
									});
								}
							});
							
							
						}
						
						 if(data.filterName !='AC_AL_FACULTY' && data.filterName != 'AC_AL_FACULTY_COURSE' && data.filterName != 'AC_AL_FACULTY_PROGRAM'){
								var models = window['powerbi-client'].models;
								var embedConfiguration = {
										type: 'report',
										accessToken: Academia.app.powerBIToken,
										persmissions:models.Permissions.All,
										id:reportId,
										embedUrl: SERVERURL.PATH_POWER_BI_EMBED_REPORT,
										settings: {
											filterPaneEnabled: false,
											navContentPaneEnabled: navContentPaneEnabled
										}
								}; 
								loadReportPowerBi(id,embedConfiguration,filterArray,navContentPaneEnabled);
								structure.on('activate',function(){
									var id=$this.structureId(structure);
									getAccessToken(id);
								});
							}
						
					});
				}
	    	}
	    	
	    	function filters(tableName,columnName,objectArray)
			{
	
				var filter= {
						$schema: SERVERURL.PATH_POWER_BI_FILTER,
						target: {
							table: tableName,
							column:columnName
						},
						operator: "in",
						values:objectArray
				}
				return filter;
			}
	    	
	    	function loadReportPowerBi(id,embedConfiguration,filterArray,navContentPaneEnabled){
				var $reportContainer = $('#'+id);
				var report = powerbi.embed($reportContainer.get(0), embedConfiguration);
	
				report.off("loaded");
				report.on("loaded", function () {
					report.setFilters(filterArray);
				});
	
				if(navContentPaneEnabled){
					report.off("pageChanged");
	
					report.on("pageChanged", function (event) {
						var page = event.detail.newPage;
					    page.setFilters(filterArray);
					});
				}
			}*/
    	/*---------- END - Analytics related function--------*/
    	function preventMultipleCalls(btn){
    		if(Ext.isDefined(btn.isClicked) && btn.isClicked == true){
        		return false;
        	}
        	btn.isClicked = true;
        	setTimeout(function(){
        		btn.isClicked = false;
        	},3000);
        	return true;
    	}
    	
    	/**
    	 * @author Rohit Sharma
    	 * 
    	 * below function is to find the indexes of all occurrences of an element in array
    	 */
    	function getAllIndexes(arr, val) {
    	    var indexes = [], i = -1;
    	    while ((i = arr.indexOf(val, i+1)) != -1){
    	        indexes.push(i);
    	    }
    	    return indexes;
    	}

		function dateObjFromString(str) {
			if (Ext.isDate(str)) {
				return str;
			}
			var orgModel = Academia.model.common.OrgSettingDateTimeModel;
			var currentDateFormat = orgModel.get('dateFormat');
			var displayFormatMap = Academia.utilities.DisplayFormatMap;
			var format = displayFormatMap.getDisplayFormat(currentDateFormat);
			if (currentDateFormat == 'DMY_SLASH') {
				return moment(str, 'DD/MM/YYYY')._d;
			}else if(currentDateFormat == 'DMY_DESH'){
				return moment(str, 'DD-MM-YYYY')._d;
			}else if(currentDateFormat == 'MDY_DESH'){
				return moment(str, 'MM-DD-YYYY')._d;
			}else if(currentDateFormat == 'MDY_SLASH'){
				return moment(str, 'MM/DD/YYYY')._d;
			}else if(currentDateFormat == 'DMY_DESH_MONTH'){
				if(format == 'd-M-Y') {
					return moment(str, 'D-M-Y')._d;
				}
				return moment(str, 'DD-MMM-YYYY')._d;
			}
		}
		
		function loadPRNMRByALAT(al, at){
			if(!isNullOrEmpty(al) && !isNullOrEmpty(at) && Ext.ComponentQuery.query('prereqnotmetreportgrid').length){
				var grid = Ext.ComponentQuery.query('prereqnotmetreportgrid')[0];
				var gridStore = grid.getStore();

				gridStore.removeAll();
				
				gridStore.getProxy().extraParams = {
					isInvalidOnly : false,
					alIds: al+"",
					academicTermId: at
				};
				
				gridStore.load();
			}
			
		}
		function downloadAttachedFile(cmp){
			var docPath = cmp.getAttribute('link')
			var csvForm = Ext.create('Ext.form.Panel'); 
			   csvForm.getForm().submit({
				   target: '_blank',
				   method:'POST',
				   params :{
					   access_token : Ext.Ajax.defaultHeaders.access_token,
					   path:docPath
				   },
				   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				   url: SERVERURL.PATH_FILE_DOWNLOAD_TEMP_API ,
				   standardSubmit :true
			   });
		}
		function programPeriodExpand(cmp){
			if (!cmp) {
		        //console.error('Component is null or undefined.');
		        return;
		    }
			if(!cmp.rendered){
		        //console.error('Component is not rendered.');
		        return;
			}
			cmp.collapse();
	        Ext.defer(function(){
	        	cmp.expand();
	        },700);	
		}
		/**
    	 * @author Pankaj Sisodiya
    	 * 
    	 * below function is to find the date is passed current date.
    	 */
		function isCurrentDatePassed(val){
			// Get today's date
		    var today = new Date();
		    
		    // Remove the time part for an accurate comparison
		    today.setHours(0, 0, 0, 0);

		    // Convert the given date to a Date object
		    var inputDate = new Date(val);

		    // Compare the dates
		    return inputDate < today;
		}
		
		/**
		 * @author Rohit Sharma
		 * Below function asserts the timefield's value
		 */
		function assertTimeValue(cmp) {
			var me = cmp,
			value = me.getRawValue(),
			rec, currentValue;

			// For single-select, match the displayed value to a record and select it,
			// if it does not match a record then revert to the most recent selection.
			rec = me.findRecordByDisplay(value);
			if (rec) {
				currentValue = me.value;
				// Prevent an issue where we have duplicate display values with
				// different underlying values.
				if (!me.findRecordByValue(currentValue)) {
					me.select(rec, true);
				}
			} else {
				me.setValue(me.lastSelection);
			}
			me.collapse();
			me.clearInvalid();
		}
		function downloadDocumentByDocId(documentId) {
	    	var documentController =  Academia.app.getController('Academia.controller.document.DocumentController');
	    	documentController.downloadDocumentFile(documentId);
    	}
		
		function generateInitialsImage(firstName, middleName, lastName) {
		    var initials = "";

		    if (firstName && lastName) {
		        initials = firstName.charAt(0).toUpperCase() + lastName.charAt(0).toUpperCase();
		    } else if (firstName && middleName) {
		        initials = firstName.charAt(0).toUpperCase() + middleName.charAt(0).toUpperCase();
		    } else if (firstName) {
		        initials = firstName.charAt(0).toUpperCase();
		    }

		    if (!initials) return ""; // Return empty if no initials

		    var colors = [
		        '#f94049', '#c8af39', '#00a7b1', '#4B0082', '#228B22', 
		        '#c2880b', '#333333', '#BF5733', '#191970', '#A52A2A', 
		        '#556B2F', '#483D8B', '#8B008B', '#2A3439', '#004C4C'
		    ];
		    var bgColor = colors[Math.floor(Math.random() * colors.length)];

		    var svg = '<svg width="50" height="50" xmlns="http://www.w3.org/2000/svg">' +
		                '<rect width="50" height="50" fill="' + bgColor + '" rx="50%" ry="50%" />' +
		                '<text x="50%" y="50%" font-family="Arial, sans-serif" font-size="20" fill="white" text-anchor="middle" alignment-baseline="central">' + initials + '</text>' +
		              '</svg>';

		    var encodedSvg = encodeURIComponent(svg);
		    var dataUri = 'data:image/svg+xml;charset=UTF-8,' + encodedSvg;

		    return dataUri;
		    //return '<img src="' + dataUri + '" width="50" height="50" alt="' + initials + '">';
		}
		
		function splitFullName(fullName) {
		    if (!fullName || typeof fullName !== "string") {
		        return { firstName: "", middleName: "", lastName: "" };
		    }

		    // Trim and split the name by one or more spaces
		    var nameParts = fullName.replace(/^\s+|\s+$/g, "").split(/\s+/);

		    var firstName = "";
		    var middleName = "";
		    var lastName = "";

		    if (nameParts.length === 1) {
		        // Only first name
		        firstName = nameParts[0];
		    } else if (nameParts.length === 2) {
		        // First and last name
		        firstName = nameParts[0];
		        lastName = nameParts[1];
		    } else if (nameParts.length >= 3) {
		        // First, middle, and last name(s)
		        firstName = nameParts[0];
		        lastName = nameParts[nameParts.length - 1];
		        middleName = nameParts.slice(1, nameParts.length - 1).join(" ");
		    }

		    return { firstName: firstName, middleName: middleName, lastName: lastName };
		}
		
		function isValidDuration(duration) {
		    // Case 1: Check if duration is "00:00:00" or empty/null
		    if (duration == "00:00:00" || isNullOrEmpty(duration)) {
		        return false;
		    }
		    
		    // Split the duration into hours, minutes, and seconds
		    var timeParts = duration.split(":");
		    if (timeParts.length !== 3) {
		        return false;
		    }

		    var hours = parseInt(timeParts[0], 10);
		    var minutes = parseInt(timeParts[1], 10);
		    var seconds = parseInt(timeParts[2], 10);

		    // Case 2: Validate hours, minutes, and seconds directly
		    if (isNaN(hours) || isNaN(minutes) || isNaN(seconds)) {
		        return false;  // If any part is NaN, return false
		    }
		    
		    // Case 3: Hours should be between 0 and 23
		    if (hours < 0 || hours > 23) {
		        return false;
		    }

		    // Case 4: Minutes should be between 0 and 59
		    if (minutes < 0 || minutes > 59) {
		        return false;
		    }

		    // Case 5: Seconds should be between 0 and 59
		    if (seconds < 0 || seconds > 59) {
		        return false;
		    }
		    
		    // Case 6: Duration cannot be "00:00:00"
		    if (hours === 0 && minutes === 0 && seconds === 0) {
		        return false;
		    }
		    
		    // All checks passed, duration is valid
		    return true;
		}
		
		// Convert base64 to Blob
		function base64ToBlob(base64Data, contentType) {
		    contentType = contentType || '';
		    var sliceSize = 512;
		    var byteCharacters = atob(base64Data.split(',')[1]); // Remove data URL prefix
		    var byteArrays = [];

		    for (var offset = 0; offset < byteCharacters.length; offset += sliceSize) {
		        var slice = byteCharacters.slice(offset, offset + sliceSize);
		        var byteNumbers = new Array(slice.length);
		        for (var i = 0; i < slice.length; i++) {
		            byteNumbers[i] = slice.charCodeAt(i);
		        }
		        var byteArray = new Uint8Array(byteNumbers);
		        byteArrays.push(byteArray);
		    }

		    return new Blob(byteArrays, { type: contentType });
		}
		
		function onItemSelectorChange(selector, newValue, oldValue) {
    var rightStore = selector.toField.store;
    var leftStore  = selector.fromField.store;

    // Find all newly added ids
     if (!Ext.isArray(oldValue)) {
        oldValue = [];    
    } 
    
    var added = [];

    Ext.Array.each(newValue, function(id) {
        if (!Ext.Array.contains(oldValue, id)) {
            added.push(id);
        }
    });

    if (!added.length) return;

    Ext.each(added, function(id) {
        var rec = rightStore.getById(id);
        if (rec) {
            moveChildren(rec, selector);
            moveChildrenBack(rec, selector);
        }
    });
}

function moveChildren(parentRec, selector) {
     var leftStore  = selector.fromField.store;
    var rightStore = selector.toField.store;

    var children = [];
    leftStore.each(function(childRec) {
        if (!childRec) return;
        if (childRec.get('pbstId') == parentRec.get('id')) {
            children.push(childRec);
        }
    });

    Ext.each(children, function(childRec) {
        rightStore.add(childRec);
        leftStore.remove(childRec);

        moveChildren(childRec, selector);
    });
    
    var allIds = [];
    rightStore.each(function(rec) {
        allIds.push(rec.getId());
    });
    selector.setValue(allIds);
}

function moveChildrenBack(parentRec, selector) {
     var leftStore  = selector.fromField.store;
    var rightStore = selector.toField.store;

    var children = [];
    rightStore.each(function(childRec) {
        if (!childRec) return; 
        if (childRec.get('pbstId') == parentRec.get('id')) {
            children.push(childRec);
        }
    });

    Ext.each(children, function(childRec) {
        leftStore.add(childRec);
        rightStore.remove(childRec);

        moveChildrenBack(childRec, selector);
    });
}
Ext.define('Academia.utilities.CommonUtil',{});