/*
 * Class for date validations.
 */
Ext.define('Academia.utilities.date.DateHelper', {

    statics: {
        /*
         * @method
         * validates the dates of parent and child start and end dates.
         */
        validateDate: function(parentStartDate, parentTillDate, childStartDate, childTillDate) {
            var pStartDate = this.getDate(parentStartDate);
            var cStartDate = this.getDate(childStartDate);
            var pTillDate = this.getDate(parentTillDate);
            var cTillDate = this.getDate(childTillDate);

            if (pStartDate <= cStartDate) {
                if (pTillDate !== null) {
                    if (cTillDate == null) {
                    	showErrorMessage(getCommonTranslation('VALIDATION'),getErrorTranslation('CHILDTILLDATENOTEMPTY'));
                        return false;
                    } else if (pTillDate < cTillDate) {
                    	showErrorMessage(getCommonTranslation('VALIDATION'),getErrorTranslation('CHILDDATETOBELESS'));
                        return false;
                    }
                }
            } else {
            	showErrorMessage(getCommonTranslation('VALIDATION'),getErrorTranslation('CHILDDATETOBEGREATER'));
                return false;
            }
            if(!isNullOrEmpty(cTillDate)){
            	if (cTillDate < cStartDate) {
            		showErrorMessage(getCommonTranslation('VALIDATION'),getErrorTranslation('CHILDDATES'));
            		return false;
            	}
            }
            return true;
        },
        getDate: function(date) {
        	/**
    		 * @author Ravi Choudhary
    		 * to manage organization date format
    		 */
            if (date !== null && date !== '' && date instanceof Date) {
            	return date;
            } if (date !== null && date !== '' && typeof(date) == "number") {
            	return new Date(date);
            } else if (date !== null && date !== '' && !isNullOrEmpty(date)) {
            	var baseController = Academia.app.getController('Academia.controller.base.BaseController');
            	return baseController.getDateFromDMYdate(date);
            } else {
            	return null;
            }
        },
        /*
         * @method
         * This function validates the date recieved in the parameter with the dates of all the children in the children array.
         * 
         * #param childArray is the array of child elements which have to be iterated.
         * #param changedValue is the changed value of the date field from the form.
         * #param fieldName is the name of the field with which the changedValue should be compared with. eg: startdate/EndDate 
         * #return Boolean
         */
        validateParentDateWithChildDates: function(childArray, changedValue, fieldName) {
            /*
             * set the error flag true when the udpdated value is wrong
             */
            errorFlag = false;
            Ext.each(childArray, function(obj) {
                if (changedValue < obj.raw.model.tillDate) {
                    errorFlag = true;
                }
            });
            return errorFlag;
        },
        /*
		*method to format the date that is passed in the parameter.
		*converts it to dd-mm-YYYY format.
		*/
        formatDate: function(dateToBeFormatted) {
        	if (dateToBeFormatted !== null && dateToBeFormatted !== '') {
        	  function pad(s) { return (s < 10) ? '0' + s : s; }
        	  return [pad(dateToBeFormatted.getDate()), pad(dateToBeFormatted.getMonth()+1), dateToBeFormatted.getFullYear()].join('-');
        	}
        },
        
        /*
		*method to format the date that is passed in the parameter.
		*converts it to YYYY-mm-dd format.
		*/
        formatDateYMD: function(dateToBeFormatted) {
        	if (dateToBeFormatted !== null && dateToBeFormatted !== '') {
        	  function pad(s) { return (s < 10) ? '0' + s : s; }
        	  return [pad(dateToBeFormatted.getFullYear()), pad(dateToBeFormatted.getMonth()+1), dateToBeFormatted.getDate()].join('-');
        	}
        },
        /*  V2D-1284  */
        validateDateForISU: function(parentStartDate, parentTillDate, childStartDate, childTillDate) {
            var pStartDate = this.getDate(parentStartDate);
            var cStartDate = this.getDate(childStartDate);
            var pTillDate = this.getDate(parentTillDate);
            var cTillDate = this.getDate(childTillDate);

            if (pStartDate <= cStartDate) {
                if (pTillDate !== null) {
                    if (cTillDate == null) {
                    	showErrorMessage(getCommonTranslation('VALIDATION'),getErrorTranslation('CHILDTILLDATENOTEMPTY'));
                        return false;
                    } else if (pTillDate < cTillDate) {
                    	showErrorMessage(getCommonTranslation('VALIDATION'),getErrorTranslation('CHILDDATETOBELESS'));
                        return false;
                    }
                }
            } else {
            	showErrorMessage(getCommonTranslation('VALIDATION'),getErrorTranslation('CHILDDATETOBEGREATER'));
                return false;
            }
           /* if (cTillDate < cStartDate) {
            	showErrorMessage(getCommonTranslation('VALIDATION'),getErrorTranslation('CHILDDATES'));
                return false;
            }*/
            return true;
        },
    }

});