/**
 * @author sachin.bangar
 * This is rest cached data proxy for store to store data on local storage
 */

Ext.define('Academia.utilities.reader.CacheRest', {
    extend: 'Ext.data.proxy.Rest',
    alias : 'proxy.cacherest',

    useLocalStorage: true,

    read: function(operation, callback, scope) {
        var cachedResponse = this.getCachedResponse();

        if (!cachedResponse) {
            this.callParent(arguments);
        } else {
            this.processResponse(true, operation, null, cachedResponse, callback, scope, true);
        }
    },
    getCachedResponse: function() {
    	var response;
    	if(Academia.enumStore != undefined && this.cacheName!=undefined && this.isEnum== true){
    		response = Academia.enumStore[this.cacheName];
    	    if (response) {
    	    	return this.getEnumTranslations(response);
    	        //return Ext.decode(response);
    	    }
    	}else if(Academia.dataStore != undefined && this.cacheName!=undefined && this.isEnum==false){
    		response = Academia.dataStore[this.cacheName];
    	    if (response) {
    	        return Ext.decode(response);
    	    }
    	}else{
    		return response;
    	}
	    
	},
    setCachedResponse: function(response) {
    	if(this.isEnum==true){
    		if(Academia.enumStore == undefined && this.cacheName!=undefined){
        		Academia.enumStore = {};
        		Academia.enumStore[this.cacheName] = response;
        	}else if(this.cacheName!=undefined && Academia.enumStore !=undefined){
        		Academia.enumStore[this.cacheName] = response;
        	}
    	}else if(this.isEnum==false){
    		if(Academia.dataStore == undefined && this.cacheName!=undefined){
        		Academia.dataStore = {};
        		Academia.dataStore[this.cacheName] = response;
        	}else if(this.cacheName!=undefined && Academia.dataStore !=undefined){
        		Academia.dataStore[this.cacheName] = response;
        	}
    	}
    	
	    
	},
    
    processResponse: function(success, operation, request, response, callback, scope, isCached) {
        // Only cache successful responses that didn't come from the cache
        if (success === true && !isCached) {
        	
        	if(this.isEnum){
        		this.getEnumTranslations(response);
        	}else{
        		this.setCachedResponse(response.responseText);
        	}
        }

        this.callParent(arguments);
    },
    
    getEnumTranslations: function(response){
    	var data, error;
		 
        try {
            data = Ext.decode(response.responseText);
            var result = [];
            for (var i=0;i<data.length;i++)
            { 
    	      var dataValue = new Object();
    	      translatedValue = getCommonTranslation(data[i]);
    	      dataValue.id = data[i];
    	      dataValue.value = translatedValue;
    	      result.push(dataValue);
            }
            this.setCachedResponse(Ext.encode(result));
        } catch (ex) {
            error = new Ext.data.ResultSet({
                total  : 0,
                count  : 0,
                records: [],
                success: false,
                message: ex.message
            });

            this.fireEvent('exception', this, response, error);

            Ext.Logger.warn('Unable to parse the JSON returned by the server');

            return error;
        }
    }
});
