/**
 * @Author Bhartendu Bhaskar
 */
Ext.define('Academia.utilities.reader.EventMeetingMinuteCustomArrayReader', {
    extend: 'Ext.data.reader.Json',
    alias: 'reader.eventmeetingminutecustomarrayreader',
    constructor: function(cnfg) {
        if (!cnfg)
            cnfg = {};
        this.callParent(arguments);
        this.initConfig(cnfg);
    },
    getResponseData: function(response) {
        var data, error;
        try {
            data = Ext.decode(response.responseText);
            var result = [];
            for (var i = 0; i < data.length; i++) {
                var dataValue = new Object();
                translatedValue = getCommonTranslation(data[i]);
                dataValue.id = data[i];
                dataValue.value = translatedValue;
                if (data[i] == 'AGENDA') {
                    dataValue.colorValue = "<span style = 'color:#2b78e4;'>" + translatedValue + "</span>";
                } else if (data[i] == 'IDEA') {
                    dataValue.colorValue = "<span style = 'color:#ff9900;'>" + translatedValue + "</span>";
                } else if (data[i] == 'DECISION') {
                    dataValue.colorValue = "<span style = 'color:#cc0000;'>" + translatedValue + "</span>";
                } else if (data[i] == 'INFO') {
                    dataValue.colorValue = "<span style = 'color:#009e0f;'>" + translatedValue + "</span>";
                } else if (data[i] == 'TASK') {
                    dataValue.colorValue = "<span style = 'color:#9900ff;'>" + translatedValue + "</span>";
                } else if (data[i] == 'PENDING') {
                    dataValue.colorValue = "<span style = 'color:#cc0000;'>" + translatedValue + "</span>";
                } else if (data[i] == 'COMPLETED') {
                    dataValue.colorValue = "<span style = 'color:#009e0f;'>" + translatedValue + "</span>";
                }
                result.push(dataValue);
            }
            return this.readRecords(result);
        } catch (ex) {
            error = new Ext.data.ResultSet({
                total: 0,
                count: 0,
                records: [],
                success: false,
                message: ex.message
            });
            this.fireEvent('exception', this, response, error);
            Ext.Logger.warn('Unable to parse the JSON returned by the server');
            return error;
        }
    }
});