Ext.define('Academia.view.DMSView.DocumentLibrarySidePanel', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.documentlibrarysidepanel',
    margin: 0,
    border:  true,
    frame: true,
    defaults: {
        bodyStyle: 'padding:0px',
        header:{
        	titlePosition:1
        }
    },
    layout: {
        type: 'accordion',
        titleCollapse: false,
        animate: true,
        activeOnTop: false,
        collapseFirst: true	
    },
    items: [{
        title: getDMSTranslation("DOCUMENTS"),
        height: 'auto',
        collapsed: true,
        items:[{
        	xtype: 'treepanel',
        	rootVisible: false,
        	border: false,
        	store:Ext.create('Ext.data.TreeStore', {
        	    root: {
        	        expanded: true,
        	        children: [
        	            { text: "All Documents", code:"all", leaf: true },
        	            { text: "I'm Editing", code:"editingMe", leaf: true },
        	            { text: "Others are Editing", code:"editingOthers", leaf: true },
        	            { text: "Recently Modified", code:"recentlyModified", leaf: true },
        	            { text: "Recently Added", code:"recentlyAdded", leaf: true },
        	            { text: "My Favorites", code:"favourites", leaf: true }
        	        ]
        	    }
        	})
        }]
    },{
        title: getDMSTranslation("LIBRARY"),
        itemId: 'libraryDocument',
        height: 'auto',
        collapsed: false,
        items:[{
        	xtype: 'treepanel',
        	itemId: 'libraryDocumentTreePanel',
        	rootVisible: true,
        	border: false,
        	store:Ext.create('Ext.data.TreeStore', {
        	    root: {
        	        expanded: true,
        	        text: 'Documents',
        	        leaf: false,
        	        children: []
        	    }
        	})
        }]
    },{
        title: getDMSTranslation("CATEGORIES"),
        html: 'Panel content!',
        height: 'auto',
        collapsed: true
    },{
        title: getDMSTranslation("TAGS"),
        html: 'Panel content!',
        height: 'auto',
        collapsed: true
    }]
});