Ext.define('Academia.view.DMSView.SiteDocumentUploadWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.sitedocumentuploadwindow',
	title:getDMSTranslation('UPLOAD_DOCUMENT'),
	frame: true,
	autoScroll:false,
	modal:true,
	method: 'POST',
	height: 280,
	width: 510,
	items:[{
		xtype: 'form',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: 'vbox',
			width:440,
			height: 170,
			defaults: {
				labelAlign: 'top',
				width:226
			},
			items: [{
				xtype     : 'component',
				width: '100%',
			    autoEl    : {
			      html : '<form enctype="multipart/form-data" method="post">'+
			      			'<div class="form-group file-area">'+
			      				'<input type="file" name="siteDocuments[]" required="required" multiple="multiple" accept="*/*" />'+
			      				'<div class="file-dummy">'+
			      					'<div class="success">Your files are selected.</div>'+
			      					'<div class="default" style="font-weight:bold;">'+getDMSTranslation('SITE_DRAG_DOCUMENT')+'</div>'+
			      					'</div>'+
			      				'</div>'+
			      			'</form>'
			    },
			    listeners : {
			        el : {
			            delegate : 'input',
			            change: function(component, fileField, eOpts) {
			            	//-- check selected files and extensions
			            	if(fileField.checkValidity()){
			            		//--enable file upload button
		            			Ext.ComponentQuery.query('sitedocumentuploadwindow')[0].down('#submitImageBtnWin').setDisabled(false);
			            	}
			            	else if(fileField.files.length==0){
			            		fileField.value='';
		            			Ext.ComponentQuery.query('sitedocumentuploadwindow')[0].down('#submitImageBtnWin').setDisabled(true);
			            	}
			            	else {
			            		fileField.value='';
			            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('INVALID_FILE_FORMAT'));
		            			Ext.ComponentQuery.query('sitedocumentuploadwindow')[0].down('#submitImageBtnWin').setDisabled(true);
			            	}
			            }
			        }
			    }
			}
			]},{ 	
				xtype:'fieldcontainer',
				width:'auto',
				items: [{
					xtype: 'button',
					action: 'Submit',
					text: getFeeAndPaymentCommonTranslation('SAVE'),
					itemId: 'submitImageBtnWin',
					ui: 'CustomBtnSubmit',
					disabled: true,
					scale: CONSTANTS.BUTTONSIZE
				},{
					xtype: 'button',
					text: getFeeAndPaymentCommonTranslation('CANCEL'),
					ui: 'CustomBtnCancel',
					itemId: 'cancelImageBtnWin',
					scale: CONSTANTS.BUTTONSIZE
				}]
		}]
	}]
});