/**
 * @author Amit G
 */
Ext.define('Academia.view.admission.admissionActivityReport.AdmissionActivityReportFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.admissionactivityreportfilter',
    autoScroll: true,
    frame: false,
	cls:'customSearchPanel',
    layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    plugins:"formlabelrequired",
    items: [{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top'
		},
		items:[{
			xtype : 'radiogroup',
			itemId : 'admissionActivityReportRadiogroupUnitId',
			width:'100%',
			column:4,
			layout: 'hbox',
			items : [{
				boxLabel : getAdmissionTranslation('USER_ACTIVITY_REPORT'),
				name : 'admissionActivityReportRadioUnit',
				itemId : 'admissionUserActivityReportRadioUnitId',
				inputValue: true,
				checked : true	
					
			},{
				boxLabel : getAdmissionTranslation('SALES_AND_ADMISSION_ENROLMENT_SUMMARY_REPORT'),
				name : 'admissionActivityReportRadioUnit',
				itemId : 'admissionSaleActivityReportRadioUnitId',
				inputValue: false
				
			}]
		}]
	},{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        itemId:'salesEnrolmentViewByID',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [ {
                xtype: 'customcombobox',
                name: ' viewTargetByAdm',
                itemId: 'viewTargetByAdm',
                allowBlank:false,
                fieldLabel: getAdmissionTranslation('VIEW_BY'),
                store: Ext.create('Academia.store.admission.admissionActivityReport.ViewTargetByAdmissionActivityStore'),
                valueField: 'id',
                displayField: 'value',
                hidden:true,
                editable: false
            },{
                xtype: 'multiselectcombofield',
                name: 'saleIntakeYearAdmId',
                itemId: 'saleIntakeYearAdmItemId',
                allowBlank:false,
                fieldLabel: getCommonTranslation('INTAKE_YEAR'),
                store: Ext.create('Academia.store.common.IntakeYearStore'),
                valueField: 'id',
                displayField: 'value',
                forceSelection: true,
                width:460,
                hidden:true,
                editable: false,
                cls:'commonAutoHeightMultiselectField'
            }]
        },{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'multiselectcombofield',
			width: 695,
			name: 'multiselectAcademy',
			itemId: 'multiselectAcademyId',
			allowBlank : false,
			fieldLabel : getCommonTranslation('ACADEMY_LOCATION'),
			displayField:'value',
			valueField:'id',
			matchFieldWidth:true,
			maxLength:15000,
			autoloadStore: false,
			queryParam:'qry',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			cls:'commonAutoHeightMultiselectField',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			},
        	listeners  :{
        		render : function(combo){
        			var store=Ext.create('Academia.store.common.AcademyLocationNameSeparated');
        			combo.bindStore(store)
        		}
        	}
		},{
			xtype: 'multiselectcombofield',
			width: 686,
			name: 'multiselectAcademyWiseAdm',
			itemId: 'multiselectAcademyWiseAdmId',
			fieldLabel : getCommonTranslation('ACADEMY'),
			displayField:'value',
			valueField:'id',
			matchFieldWidth:true,
			maxLength:15000,
			autoloadStore: false,
			cls:'commonAutoHeightMultiselectField',
			hidden:true,
			queryParam:'qry',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			},
        	listeners  :{
        		render : function(combo){
        			var store=Ext.create('Academia.store.common.AcademyByUserStore');
        			combo.bindStore(store)
        		}
        	}
        }]
		},{
	        xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            labelAlign: 'top',
	            width: 226
	        },
	        items: [{
	            xtype: 'customcombobox',
	            name: ' programGroupAdmId',
	            itemId: 'programGroupAdmItemId',
	            fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
	            store: Ext.create('Academia.store.committee.committee.CommitteeProgramGroupSmartComboStore'),
	            valueField: 'id',
	            displayField: 'value',
	            forceSelection: true,
	        	hidden:true,
	            editable: false,
	        },{
				xtype: 'multiselectcombofield',
				width: 960,
				height:58,
				name: 'programGroupWiseAdm',
				itemId: 'programGroupWiseAdmId',
				fieldLabel : getCommonTranslation('PROGRAM_GROUP'),
				displayField:'value',
				valueField:'id',
				matchFieldWidth:true,
				hidden:true,
				maxLength:15000,
				autoloadStore: false,
				cls:'commonAutoHeightMultiselectField',
				queryParam:'qry',
				minChars:3,
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				},
	        	listeners  :{
	        		render : function(combo){
	        			var store=Ext.create('Academia.store.committee.committee.CommitteeProgramGroupSmartComboStore');
	        			combo.bindStore(store)
	        		}
	        	}
	        },{
	            xtype: 'customcombobox',
	            name: ' programAdmId',
	            itemId: 'programAdmItemId',
	            fieldLabel: getCommonTranslation('PROGRAM'),
	            valueField: 'id',
	            displayField: 'value',
	            forceSelection: true,
	            editable: false,
	            disabled: true,
	            hidden:true,
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.program.ProgramByGroupIdStore');
                        combo.bindStore(store);
                    }
                }
	        },{
	            xtype: 'customcombobox',
	            name: 'batchAdmId',
	            itemId: 'batchAdmItemId',
	            fieldLabel: getCommonTranslation('BATCH'),
	            valueField: 'id',
	            displayField: 'value',
	            forceSelection: true,
	            editable: false,
	            disabled: true,
	            hidden:true,
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.common.BatchesByProgramId');
                        combo.bindStore(store);
                    }
                }
	        },{
				xtype : 'multiselectcombofield',
				cls:'commonAutoHeightMultiselectField',
				fieldLabel: getCommonTranslation('SEAT_TYPE'),
				name: 'seatTypeId',
				itemId:'seatTypeAdmItemId',
				displayField: 'value',
				valueField: 'id',
				typeAhead : true,
				forceSelection : true,
				editable: false,
				disableKeyFilter: false,
				disabled: true,
	            hidden:true,
				store:'enquiry.SeatTypeStore',
				listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
				return '<div class="search-item">' +
							'{code}'  + '{value}' +
					        '</div>';
				}
				}
			}]
	    },{
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
            	xtype : 'customcombobox',
            	fieldLabel : getCommonTranslation('INTAKE_YEAR'),
            	name : 'intakeYear',
            	itemId : 'intakeYear',
            	displayField:'value',
            	valueField:'id',
            	typeAhead:true,
            	forceSelection:true,
            	minChars:3,
    			matchFieldWidth:true,
            	listConfig: {
            		listeners: {
            			beforeshow: function(picker) {
            				picker.minWidth = picker.up('combobox').getSize().width;
            			}
            		},
            		loadingText: getCommonTranslation('SEARCHING'),
            		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            		getInnerTpl: function() {
            			return '<div class="search-item">' +
            			'{code}'  +
            			'</div>';
            		}
            	},
            	listeners  :{
            		render : function(combo){
            			var store=Ext.create('Academia.store.common.IntakeYearStore');
            			combo.bindStore(store)
            		}
            	}
            },{
    			xtype: 'multiselectcombofield',
    			width: 460,
    			name: 'users',
    			itemId: 'usersId',
    			fieldLabel : getEnquiryTranslation('USERS'),
    			displayField:'value',
    			valueField:'id',
    			matchFieldWidth:true,
    			disabled:true,
    			maxLength:15000,
    			autoloadStore: false,
    			queryMode:'local',
				cls:'commonAutoHeightMultiselectField',
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.width = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}' +
    					'</div>';
    				}
    			},
            	listeners  :{
            		render : function(combo){
            			var store=Ext.create('Academia.store.admission.admissionActivityReport.UserWiseActivityReportStore');
            			combo.bindStore(store)
            		}
            	}
    		}]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: '',
            name: 'startDate',
            itemId :'startDate',
            //allowBlank : false,
            vtype: 'daterange',
			endDateField: 'endDate',
			listeners: {
				render: function(obj) {
					var filterForm = obj.up('admissionactivityreportfilter');
					var radioGroupSelectedvalue = filterForm.down('#admissionActivityReportRadiogroupUnitId').getValue();
					if(radioGroupSelectedvalue.admissionActivityReportRadioUnit==true){
						obj.setFieldLabel(getCommonTranslation('START_DATE'));
						obj.allowBlank=false;
						obj = dateFormatRender(obj);
						obj.setValue(Ext.Date.add (new Date(),Ext.Date.DAY,-6));
					}else{
						obj.setFieldLabel(getCommonTranslation('FROM_DATE'));
						obj.allowBlank=true;
						obj = dateFormatRender(obj);
					}
				}
			}
        },{
            xtype: 'datefield',
            fieldLabel: '',
            name: 'endDate',
            itemId: 'endDate',
            vtype: 'daterange',
           // allowBlank : false,
			startDateField: 'startDate',
            listeners: {
            	render: function(obj) {
            		var filterForm = obj.up('admissionactivityreportfilter');
            		var radioGroupSelectedvalue = filterForm.down('#admissionActivityReportRadiogroupUnitId').getValue();
            		if(radioGroupSelectedvalue.admissionActivityReportRadioUnit==true){
            			obj.setFieldLabel(getCommonTranslation('END_DATE'));
            			obj.allowBlank=false;
            			obj = dateFormatRender(obj);
                		obj.setValue(new Date());
            		}else{
            			obj.setFieldLabel(getCommonTranslation('TO_DATE'));
            			obj.allowBlank=true;
            			obj = dateFormatRender(obj);
            		}
            		
            	}
              }
        },{
			xtype : 'multiselectcombofield',
			cls:'commonAutoHeightMultiselectField',
			fieldLabel: getCommonTranslation('SEAT_TYPE'),
			name: 'seatType',
			itemId:'seatType',
			displayField: 'value',
			valueField: 'id',
			typeAhead : true,
			forceSelection : true,
			editable: false,
			disableKeyFilter: false,
			store:Ext.create('Academia.store.common.AllSeatTypeListStore'),
			listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
			return '<div class="search-item">' +
						'{code}'  + '{value}' +
				        '</div>';
			}
			}
		}]
    },{
	    xtype: 'fieldcontainer',
        width:'100%',
        cls:'windowBtnPos',
        items: [{
            xtype: 'button',
            itemId:'searchBtn',
            text: getCommonTranslation('SEARCH'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId:'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
}]
});
