/**
 * This Grid is used for Program Groups Grid of the Admission Cycle setup
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.admissionCycle.ProgramGroupCombinationsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.programgroupcombinationsgrid',
	title: getAdmissionTranslation('PROGRAM_BATCH_COMBINATION_GRID'),
	border : true,
	selType: 'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	store: 'Academia.store.admission.admissionCycle.ProgramGroupCombinations',
	refreshStoreData:true,
	columns : [/*{
		hidden: true,
		dataIndex: 'id'
	},*/  {
		text : getAdmissionTranslation('ACADEMY'),
		dataIndex: 'academy',
		sortable : true,
		flex: 1
	},  {
		text : getAdmissionTranslation('LOCATION'),
		dataIndex: 'location',
		sortable : true,
		flex: 1
	}, {
		text : getAdmissionTranslation('PROGRAM'),
		dataIndex : 'program',
		sortable : true,
		flex: 1
	},{
		text : getAdmissionTranslation('PROGRAM_CODE'),
		dataIndex : 'programCode',
		sortable : true,
		flex: 1,
		hidden:true
	},	
	{
		text : getAdmissionTranslation('SEAT_TYPE'),
		dataIndex: 'seatType',
		sortable : true,
		flex: 1
	}, {
		text : getAdmissionTranslation('BATCH'),
		dataIndex : 'batch',
		flex: 1,
		sortable : true
	},  {
		text : getAdmissionTranslation('SELECTION_PROCESS'),
		dataIndex: 'selectionProcessValue',
		sortable : true,
		flex: 1
	},{
		text : getAdmissionTranslation('FORM_SALE_STATUS'),
		dataIndex : 'formSaleStaus',
		flex: 1,
		sortable : true,
		renderer: function(value){
			if(value == null) {
				return "";
			} else if(value == false){
				return getCommonTranslation('Closed')
			}else{
				return getCommonTranslation('Open');
			}
		}
	},{
		text : getAdmissionTranslation('FORM_SUBMISSION_STATUS'),
		dataIndex : 'formSubmissionStatus',
		itemId:'formSubmissionStatusId',
		flex: 1.5,
		sortable : true,
		hidden:true,
		renderer: function(value){
			if(value == null) {
				return "";
			} else if(value == false){
				return getCommonTranslation('Closed')
			}else{
				return getCommonTranslation('Open');
			}
		}
	},{
		text : getAdmissionTranslation('ADMISSION_OFFER_STATUS'),
		dataIndex : 'admissionOfferStatus',
		flex: 1,
		sortable : true,
		hidden:true,
		renderer: function(value){
			if(value == null) {
				return "";
			} else if(value == false){
				return getCommonTranslation('Closed')
			}else{
				return getCommonTranslation('Open');
			}
		}
	},{
		text : getAdmissionTranslation('ADMISSION_CYCLE_STATUS'),
		dataIndex : 'whetherAdmissionOpen',
		itemId:'admissionCycleStatusId',
		sortable : true,
		flex: 1,
		renderer: function(value){
			if(value == null) {
				return "";
			} else if(value == false){
				return getCommonTranslation('Closed')
			}else{
				return getCommonTranslation('Open');
			}
		}
	}],
	dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
        	xtype: 'custompagingtoolbar',
	        plugins:['pagesize'],
        	displayInfo : true,		 
        	 emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
        	store: 'Academia.store.admission.admissionCycle.ProgramGroupCombinations'
        }]
    }],
    tbar : [ {
		xtype: 'button',
		itemId: 'viewConfigureCombination',
		tooltip : getAdmissionTranslation('CONFIGURE_COMBINATION'),
		text:  getAdmissionTranslation('CONFIGURE_COMBINATION')
	}, {
		xtype: 'button',
		disabled:true,
		itemId: 'copyConfigureCombination',
		tooltip : getAdmissionTranslation('COPY_CONFIGURE_COMBINATION'),
		text:  getAdmissionTranslation('COPY_CONFIGURE_COMBINATION')
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	}
});