/**
 * This Grid is used for Selection Process StagesGrid in Selection Process
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.admissionCycle.QuotaSettingGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.quotasettinggrid',
	border : true,
	autoScroll: false,

	title : getAdmissionTranslation('QUOTA_SETTING'),
	cls:'panelNoSpace',
	store: 'Academia.store.admission.admissionCycle.QuotaSelectionStages',
	
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	
	columns: [ {
		header : getAdmissionTranslation('SELECTION_STAGE'),
		dataIndex: 'programSelectionProcessStage',
		flex: 0.3,
		sortable : false,
		renderer: function(obj) {
			return columnObjRender(obj, 'value');
		}
	},{
		header : getAdmissionTranslation('QUOTA'),
		dataIndex : 'quotaValue',
		flex: 0.3
	}, {
		header : getAdmissionTranslation('MINIMUM_SEATS'),
		dataIndex : 'minSeat',
		flex: 0.2,
		sortable : false,
		/*
		 * Give the editor for cell editing
		 */
		editor: {
			 xtype: 'numberfield',
			 editable: true,
			 minValue:0
		},
		renderer : function(value){
			if(value){
				return value;
			}else{
				return  getAdmissionTranslation('ENTER_MIN_SEATS');
			}
		}
	}, {
		header : getAdmissionTranslation('MAXIMUM_SEATS'),
		dataIndex : 'maxSeat',
		flex: 0.2,
		sortable : false,
		/*
		 * Give the editor for cell editing
		 */
		editor: {
			 xtype: 'numberfield',
			 editable: true,
			 minValue:0
		},
		renderer : function(value){
			if(value){
				return value;
			}else{
				return  getAdmissionTranslation('ENTER_MAX_SEATS');
			}
			
		}
	}],
    
    /*
     * required for cell editing plugin
     * selType: selection type -> cellModel ie: only a single cell from the row to be selected.
     */
    selType: 'cellmodel',
    plugins: [
        Ext.create('Ext.grid.plugin.CellEditing', {
            clicksToEdit: 1
        })
    ],
  
/*	defectId:36790 Commented code for defect raised --
     dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
        	xtype: 'custompagingtoolbar',
	        plugins:['pagesize'],
        	displayInfo : true,		 
        	emptyMsg :getAdmissionTranslation('EMPTY_GRID_MESSAGE'),
			store : 'Academia.store.admission.admissionCycle.QuotaSelectionStages'
        }]
    }],*/
    tbar : [{
    	xtype: 'nestedJsonCombo',
		name : 'quotaType',
		itemId: 'quotaTypeCombo',
		width: 350,
		fieldLabel : getAdmissionTranslation('QUOTA_TYPE'),
		store: 'Academia.store.admission.admissionCycle.QuotaTypePickList',
		displayField : 'quotaType',
		editable:false,
		autoload: false,
	    queryMode: 'local',
		valueField : 'id'
    },{
    	xtype: 'button',
    	itemId: 'saveQuotaSettingEditing',
        scale: CONSTANTS.BUTTONSIZE,
    	text: getCommonTranslation('SAVE')
    }]
});
