/**
 * @author Rajkumar.patidar
 * 
 * This component is used for to add admission Dialog box.
 */
Ext.define('Academia.view.admission.applicantFormSaleDirectSubmission.AddAdmissionDetailWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.addadmissiondetailwindow',
	modal: true,
	resizable: false,
	autoScroll: true,
	height: (Ext.isIE8) ? 600 : '60%',
			width: (Ext.isIE8) ? 620 : '82%',
					title: getAdmissionTranslation('FORM_SUBMISSION'), //Form Submission
					items: [{
						xtype: 'form',
						layout: 'fit',
						itemId: 'admissionTypeForm',
						items: [{
							xtype:'panel',
							layout:'hbox',
							cls: 'panelNoSpace',
							items:[{
								xtype: 'panel',
								itemId: 'studentPanel',
								cls: 'panelNoSpace',
								hidden : true,
								items: [{
									xtype: 'fieldcontainer',
									layout: {
										type: 'hbox'
									},
									defaults: {
										labelAlign: 'top'
									},
									items: [{
										xtype: 'customcombobox',
										name: 'admStudentIAppName',
										itemId: 'admStudentIAppNameItemId',
										store :Ext.create('Academia.store.admission.manageForm.StudentWithOutAL'),
										fieldLabel: getCommonTranslation('STUDENTID_STUDENTNAME'), //StudentId/Name
										valueField: 'id',
										displayField: 'valueCode',
										queryParam:'studentNameOrCode',
										minChars:3,
										width:460,
										forceSelection:true,
										emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
										listConfig: {
											listeners: {
												beforeshow: function(picker) {
													picker.minWidth = picker.up('combobox').getSize().width;
												}
											},
											loadingText: getCommonTranslation('SEARCHING'),
											emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
											getInnerTpl: function() {
												return '<div class="search-item">' +
												'{studentCode} / {studentName}' +
												'</div>';
											}
										},
							            listeners: {
							            	change: function(obj, newValue, oldValue, eOpts) {
							            		if(!Ext.isNumber(newValue) && newValue && newValue.match(/%/)){
							            			obj.setValue('');
							            		
							            	  }else{
							            		    var stc =  obj.up('addadmissiondetailwindow');
								            		var admContactNoItemId = stc.down('#admContactNoItemId');
								            		var admContactNoItemIdValue = admContactNoItemId.getValue();
								            		var admSTDEmailIdItemId = stc.down('#admSTDEmailIdItemId');
								            		var admSTDEmailIdItemIdValue = admSTDEmailIdItemId.getValue();
								            		var searchButton = stc.down('#searchButton');
								            		var admNationalIDItemIdItemId = stc.down('#admNationalIDItemId');
								            		var admNationalIDItemIdItemIdValue = admNationalIDItemIdItemId.getValue();
								            		
								            		if (!isNullOrEmpty(admNationalIDItemIdItemIdValue) || newValue || !isNullOrEmpty(admContactNoItemIdValue) || !isNullOrEmpty(admSTDEmailIdItemIdValue)) {
								            			searchButton.setDisabled(false);
								            		} else {
								            			searchButton.setDisabled(true);
								            		}
							            	  }
							            	}
							            }
									}, {
										xtype: 'textfield',
										name: 'admNationalIDName',
										width:226,
										maxLength: 20,
										minLength: 0,
										itemId: 'admNationalIDItemId',
										fieldLabel: getCommonTranslation('ADM_EXISUSER_NATIONAL_ID'),
										maxLength: 50,
							            listeners: {
							            	change: function(obj, newValue, oldValue, eOpts) {
							            		var stc =  obj.up('addadmissiondetailwindow');
							            		var admContactNoItemId = stc.down('#admContactNoItemId');
							            		var admContactNoItemIdValue = admContactNoItemId.getValue();
							            		var admSTDEmailIdItemId = stc.down('#admSTDEmailIdItemId');
							            		var admSTDEmailIdItemIdValue = admSTDEmailIdItemId.getValue();
							            		var searchButton = stc.down('#searchButton');
							            		var admStudentIAppNameItemId = stc.down('#admStudentIAppNameItemId');
							            		var admStudentIAppNameItemIdValue = admStudentIAppNameItemId.getValue();
							            		
							            		if (!isNullOrEmpty(admStudentIAppNameItemIdValue) || newValue || !isNullOrEmpty(admContactNoItemIdValue) || !isNullOrEmpty(admSTDEmailIdItemIdValue)) {
							            			searchButton.setDisabled(false);
							            		} else {
							            			searchButton.setDisabled(true);
							            		}
							            	}
							            }
									}]
								},{
									xtype: 'fieldcontainer',
									layout: {
										type: 'hbox'
									},
									defaults: {
										labelAlign: 'top'
									},
									items: [{
										xtype: 'numberfield',
										name: 'admContactNoName',
										width:226,
										maxLength: 15,
										minLength: 0,
										itemId: 'admContactNoItemId',
										hideTrigger: true,
										fieldLabel : getAdmissionTranslation('CONTACT_NO'),
							            listeners: {
							            	change: function(obj, newValue, oldValue, eOpts) {
							            		var stc =  obj.up('addadmissiondetailwindow');
							            		var admNationalIDItemId = stc.down('#admNationalIDItemId');
							            		var admNationalIDItemIdValue = admNationalIDItemId.getValue();
							            		var admSTDEmailIdItemId = stc.down('#admSTDEmailIdItemId');
							            		var admSTDEmailIdItemIdValue = admSTDEmailIdItemId.getValue();
							            		var searchButton = stc.down('#searchButton');
							            		var admStudentIAppNameItemId = stc.down('#admStudentIAppNameItemId');
							            		var admStudentIAppNameItemIdValue = admStudentIAppNameItemId.getValue();
							            		
							            		if (!isNullOrEmpty(admStudentIAppNameItemIdValue) || !isNullOrEmpty(admNationalIDItemIdValue) || newValue || !isNullOrEmpty(admSTDEmailIdItemIdValue)) {
							            			searchButton.setDisabled(false);
							            		} else {
							            			searchButton.setDisabled(true);
							            		}
							            	}
							            }
									}, {
										xtype: 'textfield',
										name: 'admSTDEmailIdName',
										width:226,
										vtype: 'email',
										itemId: 'admSTDEmailIdItemId',
										fieldLabel : getAdmissionTranslation('EMAIL_ID'),
										listeners: {
							            	change: function(obj, newValue, oldValue, eOpts) {
							            		var stc =  obj.up('addadmissiondetailwindow');
							            		var admNationalIDItemId = stc.down('#admNationalIDItemId');
							            		var admNationalIDItemIdValue = admNationalIDItemId.getValue();
							            		var admContactNoItemId = stc.down('#admContactNoItemId');
							            		var admContactNoItemIdValue = admContactNoItemId.getValue();
							            		var searchButton = stc.down('#searchButton');
							            		var admStudentIAppNameItemId = stc.down('#admStudentIAppNameItemId');
							            		var admStudentIAppNameItemIdValue = admStudentIAppNameItemId.getValue();
							            		if (!isNullOrEmpty(admStudentIAppNameItemIdValue) || !isNullOrEmpty(admNationalIDItemIdValue) || newValue || !isNullOrEmpty(admContactNoItemIdValue)) {
							            			searchButton.setDisabled(false);
							            		}else {
							            			searchButton.setDisabled(true);
							            		}
							            	}
							            }
									}]
								}]
							},{
								xtype: 'panel',
								itemId: 'enquiryPanel',
								cls: 'panelNoSpace',
								hidden : true,
								items: [{
									xtype: 'fieldcontainer',
									layout: {
										type: 'hbox'
									},
									defaults: {
										labelAlign: 'top'
									},
									items: [{
										xtype: 'customcombobox',
										name: 'enqId',  //Enquiry ID	
										itemId: 'enqId',
										store :Ext.create('Academia.store.enquiry.OpenEnquiryCodeSearchAccessibleALStore'),
										fieldLabel: getAdmissionTranslation('ENQUIRY_ID'),
										valueField: 'id',
										displayField: 'code',
										queryParam:'codeOrName',
										width:226,
										minChars:3,
										typeAhead:false,
										triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
										enableKeyEvents  : 'true',
										hideTrigger:false,
										forceSelection:true,
										emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
										listConfig: {
											listeners: {
												beforeshow: function(picker) {
													picker.minWidth = picker.up('combobox').getSize().width;
												}
											},
											loadingText: getCommonTranslation('SEARCHING'),
											emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
											getInnerTpl: function() {
												return '<div class="search-item">' +
												'{code}' +
												'</div>';
											}
										}
									}, {
										xtype: 'customcombobox',
										name: 'enqName',
										itemId: 'enqName',
										store :Ext.create('Academia.store.enquiry.EnquiryStudentSmartSearchAccessibleALStore'),
										fieldLabel: getAdmissionTranslation('STUDENT_NAME'), //Enquirer Name 	
										valueField: 'id',
										displayField: 'value',
										queryParam:'codeOrName',
										minChars:3,
										width:460,
										typeAhead:false,
										triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
										enableKeyEvents  : 'true',
										hideTrigger:false,
										forceSelection:true,
										emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
										listConfig: {
											listeners: {
												beforeshow: function(picker) {
													picker.minWidth = picker.up('combobox').getSize().width;
												}
											},
											loadingText: getCommonTranslation('SEARCHING'),
											emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
											getInnerTpl: function() {
												return '<div class="search-item">' +
												'{value}' +
												'</div>';
											}
										}

									}]
								},{
									xtype: 'fieldcontainer',
									layout: {
										type: 'hbox'
									},
									defaults: {
										labelAlign: 'top'
									},
									items: [{
									xtype: 'numberfield',
									name: 'enqContactNo',
									itemId: 'enqContactNo',
									maxLength: 15,
									minLength: 0,
									width:226,
									hideTrigger: true,
									fieldLabel : getAdmissionTranslation('CONTACT_NO')//Contact No.
								}, {
									xtype: 'textfield',
									name: 'enqEmailId',
									itemId: 'enqEmailId',
									vtype: 'email',
									width:226,
									fieldLabel : getAdmissionTranslation('EMAIL_ID')//Email ID,
								}]
								}]	
							}, {
								xtype: 'fieldcontainer',
								itemId: 'applicantPanel',
								layout: {
									type: 'hbox'
								},
								hidden : true,
								defaults: {
									labelAlign: 'top',
									width: 226
								},
								items:[{
									xtype: 'customcombobox',
									name: 'appId',
									itemId: 'appId',
									fieldLabel : getAdmissionTranslation('APPLICANT_ID'),//Application Id 
									store:'feeandpayment.managebill.Applicant',
									width:226,
									valueField: 'code',
									displayField: 'code',
									queryParam:'codeOrName',
									minChars:3,
									typeAhead:false,
						            hideTrigger:true,
						            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						            triggerAction: '',
						            forceSelection:true,
									  listConfig: {
										  listeners: {
												beforeshow: function(picker) {
													picker.minWidth = picker.up('combobox').getSize().width;
												}
											},
							                loadingText: getCommonTranslation('SEARCHING'),
							                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							                getInnerTpl: function() {
							                    return '<div class="search-item">' +
							                    '{code}'  +
							                    '</div>';
							                }
							            }
								},{
									xtype: 'customcombobox',
									name: 'appName',
									itemId: 'appName',
									fieldLabel : getAdmissionTranslation('APPLICANT_NAME'),//Application Name
									store:'feeandpayment.managebill.Applicant',
									width:226,
									valueField: 'printName',
									displayField: 'printName',
									queryParam:'codeOrName',
									minChars:3,
									typeAhead:false,
						            hideTrigger:true,
						            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						            triggerAction: '',
						            forceSelection:true,
									  listConfig: {
										  listeners: {
												beforeshow: function(picker) {
													picker.minWidth = picker.up('combobox').getSize().width;
												}
											},
							                loadingText: getCommonTranslation('SEARCHING'),
							                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							                getInnerTpl: function() {
							                    return '<div class="search-item">' +
							                    '{code}/{printName}'  +
							                    '</div>';
							                }
							            }
								}]
							}, {
								xtype: 'textfield',
								name: 'studentId',
								itemId: 'studentId',
								hidden: true,
								labelAlign: 'top',
								width: 226,
								fieldLabel : getAdmissionTranslation('STUDENT_ID')
							},{
								xtype: 'button',
								text: getAdmissionTranslation('FETCH_DETAIL'), //Search                
								itemId: 'searchButton',
								hidden: true,
								formBind: true,
								style : {
									marginLeft : '10px !important',
									marginTop : '135px'
								},
								ui: 'CustomBtnSubmit',
								cls:'fatchBtnClsAdmWindow',
								scale: CONSTANTS.BUTTONSIZE
								}]
						}]
					}, {
							xtype: 'datefield',
							fieldLabel: getCommonTranslation('SCHOOL_ATTENDANCE_START_DATE'),
							itemId: "schoolAttendanceStartDate",
							name: 'schoolAttendanceStartDate',
							allowBlank: true,
							minValue: new Date(),
							hidden: true,
							labelAlign: 'top',
							editable: false,
							width: 226,
							style: {
								marginLeft: '8px !important',
								marginTop: '0px'
							},
							listeners: {
								render: function(field) {
									return dateFormatRender(field);
								}
							}
						}, {
						xtype: 'grid',
						layout: 'fit',
						hidden:true,
						itemId: 'searchGrid',
						title: getAdmissionTranslation('SEARCH_RESULT'), //Search Result
						viewConfig: {
							stripeRows: CONSTANTS.STRIPEROWS
						},
						border: true,
						autoScroll: true,
						columns: []
					},{
						xtype: 'fieldcontainer',
						width: '100%',
						hidden:true,
						itemId:'importDetailPanel',
						style :{marginLeft: '8px'},
						items: [{
							xtype: 'button',
							text: getAdmissionTranslation('IMPORT'), //Import
							itemId: 'importBtn',
							ui: 'CustomBtnSubmit',
							scale: CONSTANTS.BUTTONSIZE,
							formBind: true
						}, {
							xtype: 'button',
							text: getCommonTranslation('CANCEL'),
							action: 'cancel',
							ui: 'CustomBtnCancel',
							itemId: 'cancelBtn',
							scale: CONSTANTS.BUTTONSIZE
						}]
					}]
});
