/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show selected program details in grid
 *  
 */
var ProgramTabGridStore = Ext.create('Academia.store.admission.applicationFormSale.ProgramTabGridStore');
Ext.define('Academia.view.admission.applicationFormSale.AddProgramTabGrid', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.addprogramtabgrid',
	applicationProgramType:'',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	border: true,
	isGridConfigurable: true,
	enableColumnHide: false,
	initComponent: function() {
		var grid=this;      
		var store = this.buildStore();
		var columns =new Array();
		if (!isNullOrEmpty(grid.applicationProgramType) && grid.applicationProgramType === 'APPLICANT_PROFILE_APPLICATION_PROGRAMS') {    		
			var columnArray=new Array();
			columnArray=columnArray.concat(grid.getFixedColumns());
			columnArray=columnArray.concat(grid.getExtraColumns());
			columnArray=columnArray.concat(grid.getPriorityColumn());
			columns=columnArray;        	         	        	
		} else if (!isNullOrEmpty(grid.applicationProgramType) &&  grid.applicationProgramType === 'APPLICATION_FORM_SALE_APPLICATION_PROGRAMS') {
			var columnArray=new Array();
			columnArray=columnArray.concat(grid.getFixedColumns());				
			columnArray=columnArray.concat(grid.getPriorityColumn());
			columns=columnArray;
		}
		this.doLayout();        
		Ext.apply(this, {
			store: store,
			columns: columns
		});
		this.callParent(arguments);
		var custompagingtoolbar=grid.down('custompagingtoolbar');
		if(custompagingtoolbar){
			custompagingtoolbar.bindStore(store);        	
		}
	},
	columns: [],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode:true
	},  {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		text: getAdmissionTranslation('UPDATE_PRIORITY'),
		name: 'savePriority',
		itemId: 'savePriority',
		tooltip: getAdmissionTranslation('UPDATE_PRIORITY'),
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		text: getAdmissionTranslation('SEND_OFFER_LETTER'),
		itemId: 'sendOfferLetter',
		tooltip: getAdmissionTranslation('SEND_OFFER_LETTER'),
		hasDisableForProfileViewMode:true
	}, 
	{
		xtype: 'button',
		text: getAdmissionTranslation('RESEND_OFFER_LETTER'),
		itemId: 'resendOfferLetter',
		tooltip: getAdmissionTranslation('RESEND_OFFER_LETTER'),
		hasDisableForProfileViewMode:true
	}, 
	{
		xtype: 'button',
		text: getAdmissionTranslation('UPDATE_OFFER_STATUS'),
		itemId: 'updateOfferStatus',
		tooltip: getAdmissionTranslation('UPDATE_OFFER_STATUS'),
		hasDisableForProfileViewMode:true
	}],
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			displayInfo: true,
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') 
		}]
	}],
	getPriorityColumn:function(){
		var priorityColumn={
				xtype: 'actioncolumn',
				text: getCommonTranslation('PRIORITY'),
				dataIndex: 'priority', 
				width: 'auto',
				items: [{
					xtype: 'button',
					itemId: 'upButton',
					iconCls: Ext.baseCSSPrefix + 'form-itemselector-up', // Use a URL in the icon config
					tooltip: 'UP',
					handler: function(grid, rowIndex, colIndex) {
						if (rowIndex != 0) {
							var record = grid.getStore().getAt(rowIndex);
							var previousRecord = grid.getStore().getAt(rowIndex - 1);
							previousRecord.set('priority', (previousRecord.get('priority')) + 1);
							record.set('priority', (record.get('priority')) - 1);
							grid.getStore().sort();
							grid.getStore().remove(record, true);
							grid.getStore().insert(rowIndex - 1, record);
							grid.getStore().remove(previousRecord, true);
							grid.getStore().insert(rowIndex, previousRecord);
						} else {
							showErrorMessage(getAdmissionTranslation('PRIORITY'), getErrorTranslation('UPERRORMESSAGE'));
						}
					}
				}, {
					xtype: 'button',
					itemId: 'downButton',
					iconCls: Ext.baseCSSPrefix + 'form-itemselector-down',
					tooltip: 'DOWN',
					handler: function(grid, rowIndex, colIndex) {
						lastRowIndex = grid.getStore().getCount() - 1;
						if (rowIndex != lastRowIndex) {
							var record = grid.getStore().getAt(rowIndex);
							var nextRecord = grid.getStore().getAt(rowIndex + 1);
							nextRecord.set('priority', (nextRecord.get('priority')) - 1);
							record.set('priority', (record.get('priority')) + 1);
							grid.getStore().remove(record, true);
							grid.getStore().insert(rowIndex + 1, record);
							grid.getStore().remove(nextRecord, true);
							grid.getStore().insert(rowIndex, nextRecord);
						} else {
							showErrorMessage(getAdmissionTranslation('PRIORITY'), getErrorTranslation('DOWNERRORMESSAGE'));
						}
					}
				}]
		};

		return priorityColumn;
	},
	getExtraColumns:function(){
		var extraColumns=[/*{
    		header: getAdmissionTranslation('HOSTEL'), //Hostel        
    		dataIndex: 'whetherHostelApplicable',        
    		flex: .2,
    		hidden:true,
   		 	renderer: function(value) {
				 if(value==true){
					 return 'YES';
				 }else{
					 return 'NO';
				 }    			 
   		 	}            
    	},*/{
    		header: getCommonTranslation('DISTANCE_TO_TRAVEL'), //Distance  to Travel        
    		dataIndex: 'distancetoTravel',        
    		flex: .2,
    		hidden:true
    	},{
    		header: getCommonTranslation('TRANSPORT'), //Transport        
    		dataIndex: 'whetherTransportApplicable',        
    		flex: .2,
    		hidden:true,
    		renderer: function(value) {
    			if(value==true){
    				return 'YES';
    			}else{
    				return 'NO';
    			}    			 
    		}
    	}];

		return extraColumns;
	},
	getFixedColumns:function(){
		var fixedColumns=[{
			header: getCommonTranslation('ACADEMY'), //Academy 
			dataIndex: 'academy.value',
			flex: .2,
			sortable: true
		}, {
			header: getCommonTranslation('LOCATION'), //Location
			dataIndex: 'location.value',
			flex: .2,
			sortable: true
		}, {
			header: getAdmissionTranslation('PROGRAM'), 
			dataIndex: 'program.value',
			flex: .2,
			sortable: true
		}, {
			header: getAdmissionTranslation('BATCH'),
			dataIndex: 'batch.value',
			flex: .2,
			sortable: true
		}, {
			header: getAdmissionTranslation('SEAT_TYPE'), 
			dataIndex: 'seatType.value',
			flex: .2,
			sortable: true
		}, {
			header: getCommonTranslation('SCHOOL_ATTENDANCE_START_DATE'),
			dataIndex: 'schoolAttendanceStartDate',
			flex: .2,
			sortable: true,
			renderer: function(val) {
				if (!isNullOrEmpty(val)) {
					return dateRender(val);
				}
			}
	    }, {
			header : getCommonTranslation('MODE_OF_DELIVERY'),
			dataIndex : 'deliveryMode',
			hidden : true,
			flex : .2
		}, {
			header : getCommonTranslation('REGISTRATION_TYPE'),
			dataIndex : 'registrationType',
			hidden : true,
			flex : .2,
			sortable : true,
			renderer : function(value) {
				if (!isNullOrEmpty(value)) {
					if (value == false) {
						return 'Full Time';
					} else {
						return 'Part Time';
					}

				}
			}
		},{
			header: getCommonTranslation('PROGRAM_PRIORITY'), 
			dataIndex: 'programPriority',
			flex: .2,
			sortable: true
		},{
			header : getCommonTranslation('ACADEMIC_TERM'),
			dataIndex : 'academicTerm',
			hidden : false,
			flex : .2
		},{
			header : getCommonTranslation('ELIGIBILITY_STATUS'),
			dataIndex : 'eligibilityStatus',
			hidden : true,
			flex : .2
		}];


		return fixedColumns;
	},
	buildStore: function() {
		return Ext.create('Academia.store.admission.applicationFormSale.ProgramTabGridStore');
	}
});
