/**
 * @author Rajkumar.patidar
 * 
 * This component is used for to show list of program in Dialog box
 */
Ext.define('Academia.view.admission.applicationFormSale.ChangeProgramWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.changeprogramwindow',
	modal: true,
	resizable: false,
	autoScroll: true,
	height: (Ext.isIE8) ? 850 : '73%',
			width: (Ext.isIE8) ? 750 : '75%',
					title:getAdmissionTranslation('CHANGE_APPLICATION_PROGRAM'),
					cls : 'panelNoSpace',
					items: [{
						xtype: 'changeprogramwindowcurrentgrid',
						itemId: 'changeprogramwindowcurrentgrid',
					},{
						xtype: 'dynamicfieldformwin',
						itemId:'applicantChangeProgramFilter',
						plugins : "formlabelrequired",
						title:getAdmissionTranslation('SELECT_NEW_APPLICATION_PROGRAM'),
						border:true,
						bodyPadding:'10px',
						layout:{
							type:'vbox'
						},
						items:[{
							xtype: 'fieldcontainer',
							layout: 'hbox',
							defaults: {
								width: 200,
								labelAlign: 'top'
							},
							items: [{
								xtype: 'customcombobox',
								fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
								name: 'academyLocation',
								itemId:'academyLocation',
								store: 'user.UserAcademyLocationStore',
								displayField: 'value',
								valueField: 'id',
								typeAhead : false,
								forceSelection:true,
								hideTrigger:false,
								queryMode: 'remote',
								queryParam: 'qry',
								triggerAction: 'all',
								allowBlank: false,
								minChars:3,
								emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
								listConfig: {
									listeners: {
										beforeshow: function(picker) {
											picker.minWidth = picker.up('combobox').getSize().width;
										}
									},
									loadingText: getCommonTranslation('SEARCHING'),
									emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
									getInnerTpl: function() {
										return '<div class="search-item">' +
										'{value}'  +
										'</div>';
									}
								}
							}, {
								xtype: 'customcombobox',
								fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
								itemId: 'programGroup',
								name: 'programGroup', 
								//store: Ext.create('Academia.store.admission.applicationFormSale.ActiveProgramGroupComboStore'),
								store: Ext.create('Academia.store.admission.applicationFormSale.ProgramGroupByAcademyLocationStore'),
								valueField:'id',
								displayField:'value',
								allowBlank: false,
								disabled:true,
								editable: false
							},{
								xtype: 'customcombobox',
								name: 'modeofDelivery',
								itemId: 'modeDeliveryId',
								fieldLabel: getCommonTranslation('MODE_OF_DELIVERY'),
								store: 'common.ModeOfDeliveryStore',
								valueField: 'id',
								displayField: 'value',
								forceSelection: true,
								disabled:true,
							},{
								xtype: 'customcombobox',
								name: 'registrationType',
								itemId: 'registrationTypeId',
								fieldLabel: getCommonTranslation('REGISTRATION_TYPE'),
								store: 'campaignnew.RegistrationTypeStore',
								valueField: 'id',
								displayField: 'value',
								forceSelection: true,
								disabled:true,
							}]
						}, {
							xtype: 'fieldcontainer',
							layout: 'hbox',
							defaults: {
								width: 200,
								labelAlign: 'top'
							},
							items: [{
								xtype: 'customcombobox',
								fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'), //Program
								name: 'program',
								itemId: 'program',
								autoload: false,
								//store: 'program.ProgramByGroupIdStore',
								store: Ext.create('Academia.store.program.ProgramConfigured'),
								valueField: 'id',
								displayField: 'valueCode',  
								allowBlank: false,
								queryParam:'qry',
								typeAhead : false,
								forceSelection:true,
								hideTrigger:false,
								triggerAction: 'all',
								disabled:true,
								minChars:3,
								emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
								listConfig: {
									listeners: {
										beforeshow: function(picker) {
											picker.minWidth = picker.up('combobox').getSize().width;
										}
									},
									loadingText: getCommonTranslation('SEARCHING'),
									emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
									getInnerTpl: function() {
										return '<div class="search-item">' +
										 '{code} / {value}'+ 
										'</div>';
									}
								}
							},{
								xtype: 'customcombobox',
								fieldLabel: getAdmissionTranslation('BATCH'),   //Batch
								name: 'batch',
								itemId: 'batch',
								editable: false,
								autoload: false,
								allowBlank: false,
								store: Ext.create('Academia.store.program.BatchConfigured'),
								disabled:true,
								valueField: 'id',
								displayField: 'value',
								queryMode : 'local'
							},{
								xtype: 'customcombobox',
								fieldLabel: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
								name: 'seatType',
								itemId: 'seatType',
								editable: false,
								allowBlank: false,
								autoload: false,
								store: Ext.create('Academia.store.program.ConfiguredSeatType'),
								disabled:true,
								valueField: 'sequence',
								displayField: 'value',
								queryMode : 'local'
							},{
								xtype: 'datefield',
								fieldLabel: getCommonTranslation('SCHOOL_ATTENDANCE_START_DATE'),
								itemId: "schoolAttendanceStartDate",
								name: 'schoolAttendanceStartDate',
								allowBlank: true,
								minValue: new Date(),
								labelAlign: 'top',
								editable: false,
								listeners: {
									render: function(field) {
										return dateFormatRender(field);
									}
								}
						  }]
						},{
							xtype: 'fieldcontainer',
							width: '100%',
							style :{marginTop: '10px'},
							items: [{
								xtype: 'button',
								text: getAdmissionTranslation('ADD_PROGRAM'), //Add Program
								itemId: 'btnChangeProgram',
								ui: 'CustomBtnSubmit',
								scale : CONSTANTS.BUTTONSIZE,
								formBind: true
							}, {
								xtype: 'button',
								text: getCommonTranslation('CANCEL'), //Cancel Program
								ui: 'CustomBtnCancel',
								itemId: 'btnCancle',
								scale: CONSTANTS.BUTTONSIZE
							}]
						}]    	
					}]
});