/**
 * @author Amit G
 */
Ext.define('Academia.view.admission.applicationOwnerSetup.VWAdmApplicationOwnerSetupResultGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.vwadmapplicationownersetupresultgrid',
	store: 'admission.applicationOwnerSetup.StoAdmApplicationOwnerMappingGridStore',
	title: getCommonTranslation('APPLICATION_OWNER_SETUP_LIST'),
	border: true,
	autoScroll: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'admission.applicationOwnerSetup.StoAdmApplicationOwnerMappingGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'admBtnAddAppOwnerItemId',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
        xtype: 'button',
        itemId: 'admBtnEditAppOwnerItemId',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'admBtnDeleteAppOwnerItemId',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header:  getCommonTranslation('USER_CODE_NAME'),
		dataIndex: 'printName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocationName',
		flex:1,
		sortable:true
	}/*,{
		header:  getCommonTranslation('LOCATION'),
		dataIndex: 'locationName',
		flex:1,
		sortable:true
		
	}*/,{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('SEAT_TYPE'),
		dataIndex: 'seatName',
		flex:1,
		sortable:true
	}]
});
