/**
 * @author Abhishek Chouhan
 * 
 * This component is used for to show list of offer letter accepted program in Dialog box
 * 
 */
Ext.define('Academia.view.admission.applications.admissionAndMidTermAdmission.AddDirectAdmissionProgramWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.adddirectadmissionprogramwindow',
	modal: true,
	frame: true,
	title:getAdmissionTranslation('ADD_PROGRAMS'),
	items: [{
		xtype: 'dynamicfieldformwin',
		formCode:'formId',
		itemId:'formId',
		defaults:{
			labelAlign:'top',
			width:226
		},
		standardSubmit: false,
		plugins:"formlabelrequired",    
		items:[{
			xtype : 'fieldcontainer',
			width : '100%',
			itemId:'academyLocationForm',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
				name: 'academyLocation',
				itemId:'academyLocationCombo',
				queryMode : 'remote',
				store: 'user.UserAcademyLocationStore',
				displayField: 'value',
				valueField: 'id',
				width:226,
				typeAhead: false,
				forceSelection: true,
				triggerAction: 'all',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				allowBlank: false,
				queryParam: 'qry',
                listConfig: {
    				  listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                    '{value}'  +
    	                    '</div>';
    	                }
    	            }
			},{
             	xtype: 'customcombobox',
                name: 'PROGRAM_GROUP',
                itemId:'cmbPgmGroup',
                fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
                store:'program.ProgramGroupByProgramIdStore',
                displayField:'value',
                valueField:'id',
                forceSelection:true,
                allowBlank: false,
                disabled:true,
            },{
                xtype: 'customcombobox',
                name: 'PROGRAM_NAME',
                itemId: 'program',
                fieldLabel: getPersonModuleTranslation('PROGRAM'),
                editable: false,
                valueField: 'id',
                displayField: 'value',
                forceSelection:true,
                disabled:true,
                allowBlank: false,
                //store:'admission.applicationFormSale.ProgramGroupComboConfiguredStore',
                store: 'program.ProgramByGroupIdStore',
               /*listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.admission.applicationFormSale.ProgramComboConfiguredStore');
                        combo.bindStore(store);
                    }
                }*/
            }]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
                xtype: 'customcombobox',
                name: 'BATCH_NAME',
                itemId: 'batch',
                fieldLabel: getPersonModuleTranslation('BATCH'),
                //disabled:true,
                store:'program.programbatchdetail.BatchStore',
                editable: false,
                queryMode: 'local',
                displayField: 'value',
                disabled:true,
                valueField: 'id',
                allowBlank: false,
                /*listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.admission.applicationFormSale.ProgramComboConfiguredStore');
                        combo.bindStore(store);
                    }
                }*/
            }, {/*
                xtype: 'customcombobox',
                itemId:'period',
                //disabled:true,
                editable: false,
                displayField: 'value',
                valueField: 'id',
                queryMode: 'local',
                fieldLabel: getPersonModuleTranslation('PERIOD'),
                name: 'PERIOD_NAME',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
                        combo.bindStore(store);
                    }
                }
            */
				xtype: 'customcombobox',
				name: 'PERIOD_NAME',
				itemId: 'cmbPeriod',
				fieldLabel: getAdmissionTranslation('SELECT_PERIOD'),//+' <span class="required" style="color:black"> :</span>'+' <span class="required" style="color:red"> *</span>', //Select Period
				//store: 'admission.applications.admissionAndMidTermAdmission.PeriodComboStore',
				valueField: 'id',
				displayField: 'value',
				editable: false,
				//disabled:true,
				queryMode: 'local',
				triggerAction: 'all',
				forceSelection: true,
				allowBlank: false,
				 listeners: {
	                    render: function(combo) {
	                        var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
	                        combo.bindStore(store);
	                    }
	                }
			},{
    			xtype: 'customcombobox',
    			fieldLabel: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
    			name: 'SEAT_TYPE',
    			itemId: 'seatType',
    			editable: false,
    			//autoload: false,
    			//Seat Type
    			//store:'admission.applicationFormSale.BatchComboConfiguredStore',
    			store:'Academia.store.common.SeatTypesByBatchId',
    			//disabled:true,
    			valueField: 'seatTypeId',
    			displayField: 'seatTypeName',
    			queryMode : 'local',
    			allowBlank: false,
    			/*listeners: {
	                    render: function(combo) {
	                        var store = Ext.create('Academia.store.admission.applicationFormSale.BatchComboConfiguredStore');
	                        combo.bindStore(store);
	                    }
	                }*/
    		}]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
                xtype: 'customcombobox',
                name: 'SECTION',
                itemId: 'section',
                fieldLabel: getPersonModuleTranslation('SECTION'),
                editable: false,
                queryMode: 'local',
                disabled:true,
                valueField: 'id',
                displayField: 'value',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionsStore');
                        combo.bindStore(store);
                    }
                }
            },{
				xtype: 'datefield',
				fieldLabel: getAdmissionTranslation('ADMISSION_DATE'),   //Type Of Admission
				name: 'admissiondate',
				itemId: 'admissiondate',      
				//valueField: 'id',
				//displayField: 'value',
				editable: false,
				allowBlank: false,
				//--submitFormat: CONSTANTS.DATE_FORMAT,
//				value: new Date(),
//				minValue:new Date(),
                listeners: {
                	render: function(obj) {
                		obj = dateFormatRender(obj);						
                		obj.setValue(new Date());
                	}
                }
			},{
				fieldLabel: getAdmissionTranslation('ASSIGN_ADVISOR'),  //Assign Advisor
				xtype: 'customcombobox',
				name: 'advisiorId',
				itemId: 'advisior',                    
				store: 'common.ActiveUserStore',
				valueField: 'id',
				displayField: 'valueCode',
				editable: false,                                       
				triggerAction: 'all',
				forceSelection: true
//				allowBlank: false,
			}]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('TYPE_OF_ADMISSION'),   //Type Of Admission
				//Type Of Admission
				name: 'admissionType',
				itemId: 'typeOfAdmission',      
				store: 'admission.applications.admissionAndMidTermAdmission.TypeOfAdmissionComboStore',
				valueField: 'id',
				displayField: 'value',
				editable: false,
				allowBlank: false,
				renderer: function(value) {
					return getAdmissionTranslation(value);
				}
			}, {
					xtype: 'datefield',
					fieldLabel: getCommonTranslation('SCHOOL_ATTENDANCE_START_DATE'),
					itemId: "schoolAttendanceStartDate",
					name: 'schoolAttendanceStartDate',
					allowBlank: true,
					editable: false,
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					}
				}]
		},{
			xtype: 'fieldcontainer',                
			width: '100%',
			itemId: 'provisionalAdmissionPanel',
			hidden: true,
			layout: {
				type: 'vbox'
			},
			defaults: {
				labelAlign: 'top'
			},
			items: [{
				xtype: 'fieldcontainer',                                 
				itemId: 'trialAdmissionDateContainer',
				//hidden: true,
				layout: {
					type: 'hbox'
				},
				defaults: {
					labelAlign: 'top',
					width: 226                        
				},
				items: [{
					fieldLabel: getAdmissionTranslation('REASON_PROVISIONAL_ADMISSION'), //Reason for Provisional  Admission
					xtype: 'customcombobox',                        
					store:'admission.admissionCommon.ProvisionalAdmissionReasonStore',
					width: 226,
					itemId: 'provisionalAdmissionClosureReason',
					name: 'provisionalAdmissionClosureReason',
					allowBlank: false,
					valueField: 'value',
					displayField: 'value'
				}, {
				xtype: 'datefield',
				fieldLabel: getAdmissionTranslation('PROVISIONAL_LAST_DATE'), //Last Date for Provisional Confirmation 
				//Select Date
				name: 'provisionalLastDate',
				itemId: 'provisionalLastDate',
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				allowBlank: false,
				minValue : new Date(),
				width: 226,
				labelWidth:'auto',
				//vtype: 'daterange',
				//endDateField: 'endDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]}, {
				xtype: 'radiogroup',
				fieldLabel: getAdmissionTranslation('NO_CONCLUSION_LAST_DATE'), //If no conclusion by last date, assume following decision
				name: 'RADIO_Btn',     
				width: 336,
				layout: {
					type: 'hbox'
				},
				items: [{
					boxLabel: getAdmissionTranslation('CONFIRMED'),  //Confirmed
					name: 'conclusion',
					inputValue: 'CONFIRMED',
					checked: true
				}, {
					boxLabel:getAdmissionTranslation('DENIED'),  //Denied
					name: 'conclusion',
					inputValue: 'DENIED'
				}]
			}]            
		},{

		xtype: 'fieldcontainer',
		width: '100%',
		itemId: 'trialAdmissionContainer',
		hidden: true,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top'
		},           
		items: [{
			xtype: 'fieldcontainer',                                 
			itemId: 'trialAdmissionDateContainer',
			//hidden: true,
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226                        
			},           
			items: [{
				xtype: 'datefield',
				fieldLabel: getAdmissionTranslation('TRIAL_START_DATE'), //Trial Start Date
				//Trial Start Date
				name: 'trialStartDate',
				itemId: 'trialStartDate',                        
				//--submitFormat: CONSTANTS.DATE_FORMAT,                        
				vtype: 'daterange',
				endDateField: 'trialEndDate',
				allowBlank: false,
				minvalue : new Date(),
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setMinValue(new Date());						
					}
				}
			}, {
				xtype: 'datefield',
				fieldLabel: getAdmissionTranslation('TRIAL_END_DATE'),  //Trial End Date
				//Trial End Date
				name: 'trialEndDate',                        
				itemId: 'trialEndDate',
				//--submitFormat: CONSTANTS.DATE_FORMAT,                                                
				vtype: 'daterange',
				startDateField: 'trialStartDate',
				allowBlank: false,     
				minvalue : new Date(),
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setMinValue(new Date());
					}
				}
			}]
		},{
			xtype: 'radiogroup',                    
			fieldLabel: getAdmissionTranslation('NO_CONCLUSION_TRIAL_END_DATE'),  //If no conclusion by trial end date, assume following decision                    
			name: 'RADIO_Btn',
			width: 336,
			layout: {
				type: 'hbox'
			},
			items: [{
				boxLabel: getAdmissionTranslation('CONFIRMED'),  //Confirmed
				name: 'conclusion',
				inputValue: 'CONFIRMED',
				checked: true
			}, {
				boxLabel: getAdmissionTranslation('WITHDRAWN'),  //Withdrawn
				name: 'conclusion',
				inputValue: 'WITHDRAWN'
			}]
		}]                       
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			items: [{
				xtype: 'button',
				text: getAdmissionTranslation('PROGRAM_ADD'), //Add Admission
				itemId: 'addAdmissionBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'), //Cancel Admission
				action: 'cancel',
				ui: 'CustomBtnCancel',
				itemId: 'cancelAdmissionBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
	}]
});