/**
 * @author vidhi.shah
 */
Ext.define('Academia.view.admission.applications.applicantProfileBase.ApproveAdmissionProgramForm', {
extend:'Academia.view.common.IdGeneratorCustomForm',
alias : 'widget.approveadmissionprogramform',

plugins : "formlabelrequired",
	items: [{
            	xtype: 'fieldcontainer',
                layout:'hbox',
                width: '100%',
                items: [{
                	xtype: 'customcombobox',
                	name: 'installmentRule',
                	itemId:'installmentRuleItemId',
                	store:'feeandpayment.managebill.InstallmentRuleStore',
                	displayField:'value',
                	valueField:'id',
                	forceSelection:true,
                	labelAlign: 'top',
                	width:226,
                	hidden:true,
                	style: {
                		marginLeft: '10px'
                	},
                	disabled:true,
                	editable:false,
                	typeAhead:true,
                	fieldLabel:getCommonTranslation('FEEPLAN_RULE'),
                },{
                	fieldLabel: getCommonTranslation('BILLING_START_DATE'),
        			xtype: 'datefield',
        			name: 'billingStartDate',
        			itemId:'billingStartDateId',
        			labelAlign: 'top',
                	width:226,
                	hidden:true,
                	style: {
                		marginLeft: '10px'
                	},
                	//disabled:true,
                	//editable:false,
                	typeAhead:true,
        			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			},
        			editable:false,
        			allowBlank:true,
        		
                },{
					xtype: 'datefield',
					fieldLabel: getAdmissionTranslation('ADMISSION_APPROVED_ON'),   
					name: 'admissionApprovedOn',
					itemId: 'admissionApprovedOn',      
					valueField: 'name',
					displayField: 'value',
					readOnly: true,
					editable: false,
					allowBlank: true,
					width: 226,
					labelAlign: 'top',
					style: {
                        marginLeft: '10px'
                    },
	                listeners: {
	                	render: function(obj) {
	                		obj = dateFormatRender(obj);						
	                		obj.setValue(new Date());
	                	}
	                }
				}]
            },//end first row 
            {

            	xtype: 'fieldcontainer',
                layout:'hbox',
                width: '100%',
                items: [{
                    xtype: 'customcombobox',
                    name: 'allSectionsVerified',
                    itemId: 'allSectionsVerifiedItemId',
                    fieldLabel: getAdmissionTranslation('ALL_SECTIONS_VERIFIED'),
                    store: 'common.YesNoClientSideComboStore',
                    valueField: 'name',
                    displayField: 'value',
                    hidden:true,
                    editable: false,
                    width: 226,
                    style: {
                        marginLeft: '10px'
                    },
                    labelAlign: 'top',
                    allowBlank: true
                },{
                    xtype: 'customcombobox',
                    name: 'allDocumentsVerified',
                    itemId: 'allDocumentsVerifiedItemId',
                    fieldLabel: getAdmissionTranslation('ALL_DCOUMENTS_VERIFIED'),
                    store: 'common.YesNoClientSideComboStore',
                    valueField: 'name',
                    displayField: 'value',
                    hidden:true,
                    editable: false,
                    width: 226,
                    style: {
                        marginLeft: '10px'
                    },
                    labelAlign: 'top',
                    allowBlank: true
                   }]
            
            },//end second row
            {
                xtype: 'fieldcontainer',
                layout:'hbox',
                width: '100%',
				items: [{
					xtype: 'textareafield',
					name: 'remark',
					itemId: 'remarkItemId',
					fieldLabel: getAdmissionTranslation('ADMISSION_APPROVAL_REMARKS'), //Approval Remarks
					//Approval Remarks                
					labelAlign: 'top',
					width: 226,
					style: {
						marginLeft: '10px'
					},
					maxLength: 250
				}, {
					xtype: 'datefield',
					fieldLabel: getCommonTranslation('SCHOOL_ATTENDANCE_START_DATE'),
					itemId: "schoolAttendanceStartDate",
					name: 'schoolAttendanceStartDate',
					allowBlank: true,
					labelAlign: 'top',
					editable: false,
					width: 226,
					style: {
						marginLeft: '10px'
					},
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					}
				}]
            
            },{
            	xtype: 'fieldcontainer',
            	width: '100%',
            	style: {
            		marginLeft: '8px'
            	},
            	items: [{
            		xtype: 'button',
            		text: getAdmissionTranslation('APPROVE'), 
            		itemId: 'submitBtn',
            		ui: 'CustomBtnSubmit',
            		scale: CONSTANTS.BUTTONSIZE,
            		hasDisableForProfileViewMode:true,
            		formBind: true
            	}, {
            		xtype: 'button',
            		text: getAdmissionTranslation('WITHDRAW_FROM_PROGRAM'), 
            		itemId: 'withdrawFromProgramBtn',
            		ui: 'CustomBtnSubmit',
            		scale: CONSTANTS.BUTTONSIZE,
            		hasDisableForProfileViewMode:true,
            		disabled:true,
            		hidden:true
            	},{
            		xtype : 'customcombobox',
            		fieldLabel : getServiceRequestTranslation('REQUEST_TYPE'),
            		store:Ext.create('Academia.store.servicerequest.ServiceRequests'),
            		itemId : 'serviceRequestCombo',
            		displayField : 'value',
            		valueField : 'id',
            		queryMode : 'local',
            		emptyText :getServiceRequestTranslation('REQUEST_TYPE_EMPTY_TEXT'),
            		disabled : true,
            		hidden:true,
            	},{
            		xtype: 'button',
            		text: getCommonTranslation('CANCEL'),
            		action: 'cancel',
            		ui: 'CustomBtnCancel',
            		itemId: 'cancelBtn',
            		scale: CONSTANTS.BUTTONSIZE
            }]
    }]
});