/**
 * @author Amit G
 */
Ext.define('Academia.view.admission.applications.applicationBase.ApplicantListOfApplicableConditionsAdmGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.applicantlistofapplicableconditionsadmgrid',
    title: getAdmissionTranslation('LIST_OF_APPLICABLE_CONDITIONS'),
    border: true,
    columnLines : true,
    cls:'centerAlignTitle',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    columns: [ {
    	xtype: 'rownumberer',
        header: getCommonTranslation('SNO'),
        dataIndex: 'sNO',
        sortable: true,
        align: 'center',
        flex: 1
    }, {
        header: getCommonTranslation('CONDITIONS'),
        dataIndex: 'admissionConditionValue',
        sortable: true,
        flex: 1.5,
        renderer : function(value, metadata, record){
        	if(record.data.offerType=='PROVISIONAL'){
        		return value+'<span class="required" style="color:red"> *</span>';
        	}else{
        		return value;
        	}
			
		}
    }, {
		xtype:'checkcolumn',
		header:getCommonTranslation('CONDITIONS_MET'),
		flex:1.5,
		sortable:false,
		dataIndex : 'conditionCheck',
		listeners: {
			beforecheckchange: function(checkcolumn, rowIndex, checked, eOpts){
				if(portalId == 6){
					return false;
				}
			}
		}			
	}, {
		header:getCommonTranslation('SAQA_TRACKING_NUMBER'),
		flex:1.5,
		sortable:true,
		dataIndex : 'saqaTrackingNumber',
		editor : {
			xtype : 'textfield',
			 itemId:'saqaTrackingNumber',
	         name:'saqaTrackingNumber',
			
		}
	}, {
        header: getCommonTranslation('MANDATORY'),
        dataIndex: 'offerType',
        sortable: true,
        flex: 1,
        renderer : function(value, metadata, record){
        	if(value == "PROVISIONAL"){
        		return 'Yes';
        	}else{
        		return 'No';
        	}
			
		}
    }, {
		header: getCommonTranslation('DATE_OF_SATISFACTION'), 
		dataIndex: 'conditionSatisfactionDate',
	    name:'conditionSatisfactionDate',
	    itemId:'conditionSatisfactionDate',
	    sortable: true,
	    flex: 1.5,
	        editor: {
	            xtype: 'datefield',
	            itemId:'conditionSatisfactionDate',
	            name:'conditionSatisfactionDate',
	            minValue: new Date(),
	    	    vtype: 'daterange',
	            listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
	        },
	        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
	        	var grid = view.up();
	        	var store = grid.getStore();
                var models = grid.getStore().getRange();
                if (!isNullOrEmpty(val)) {

                } else if (!isNullOrEmpty(record.data.datePrefillValue)) {
                    val = record.data.datePrefillValue;
                }
                models[rowIndex].set("conditionSatisfactionDate", val);
                models[rowIndex].set("datePrefillValue", val);
                return dateRender(val);
			}
	}],
	plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1,

    },
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.admission.applicationFormSale.ApplicationApplicableConditionsStore');
    }
});