/**
 * Review Details
 */
Ext.define('Academia.view.admission.applications.applicationBase.ApplicationReviewDetails', {
    //extend: 'Ext.form.Panel',
	extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.applicationreviewdetails',
    listeners:{
    	beforeRender: function(){
    		    Ext.apply(this,{
    		    	customFieldEntity:CONSTANTS.APPLICATION_REVIEWER,
        		    columns: 1
    		    });
    	}
    },
    layout: {
        type: 'vbox'
    },   
    items: [{
        xtype: 'form',
        itemId: 'reviewdetails',
        frame: false,
        width: '100%',
        defaults: {
			labelAlign: 'top',
			width: 226
		},
        layout: {
			type: 'hbox'
		},
        items: [{
			xtype: 'hidden',
			name: 'id',
			itemId: 'Id'
		},
		{
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('Reviewer'),
            valueField: 'id',
			displayField: 'userName',
			name: 'reviewer',
			itemId:'reviewerId',
			typeAhead:true,
			forceSelection:true,
			queryParam:'qry',
			hideTrigger:false,
			triggerAction: 'all',
            minChars: 3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			},
			listeners:{
				render:function(cmp){
					cmp.bindStore(Ext.create('Academia.store.admission.applications.applicationReviewer.ApplicationReviewerComboStore'));
				}
			}
        },
        {
   	   	 xtype : 'radiogroup',
   	   	 fieldLabel: getAdmissionTranslation('WILLING_TO_SUPERWISE_IF_ADMITTED'),
   		 itemId:'willingToSuperwise',
   		 name:'willingToSuperwise',
   		style: {
            marginLeft: '30px'
        },
   	   	 items : [{
   	   		 boxLabel : getCommonTranslation('YES'),
   	   		 itemId:'willingToSuperwiseYes',   	   		 
   	   		 name : 'willingToSuperwise',
   	   		 inputValue : true
   	   		
   	   		 
   	   	 },{
   	   		 boxLabel : getCommonTranslation('NO'),
   	   		 name : 'willingToSuperwise',
   	   		 itemId : 'willingToSuperwiseNo',
   	   		 inputValue : false,
   	   		 checked : true
   	   	 }]
   	   }]
    },{
		 xtype: 'panel',
		 width:'100%',
		 cls: 'panelNoSpace',
		 items: [{
			 xtype : 'reviewdetailspanel',
			 itemId: 'ReviewDetailsPanel',
			 hidden:false,
			 margin: '8 0 25 0'
		 }]
	 
  },{
		xtype: 'button',
		text: getTransportTranslation('SAVE'),
		formBind: true,
		itemId: 'SubmitBtn',
		hidden: true,
		ui: 'CustomBtnSubmit',
		scale: CONSTANTS.BUTTONSIZE
		}]
});