/**
 * @Author Vyabha Thakur
 */
Ext.define('Academia.view.admission.applications.applicationBase.DocumentAndNotesForm', {
	extend: 'Ext.form.Panel',
	extend: 'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.documentandnotesform',
	plugins: "formlabelrequired",
	itemId: 'documentAndNotesForm',
	items: [{
        xtype: 'hidden',
        itemId: 'documentAndNotesFormHiddenId',
        name: 'id'
    	},{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 226
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
    		xtype: 'customcombobox',
    		name: 'academicTopicId',
            itemId: 'academicTopicItemId',
            fieldLabel: getCommonTranslation('CATEGORY'),
            editable: false,
            allowBlank: false,
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.student.studentprofile.AcademicTopicUserIdStore');
                    combo.bindStore(store);
                }
            }
    	}, {
            xtype: 'customcombobox',
            name: 'academicSubTopicId',
            itemId: 'academicSubTopicItemId',
            fieldLabel: getCommonTranslation('SUB_CATEGORY'),
            editable: false,
            allowBlank: false,
            disabled:true,
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.student.studentprofile.AcademicSubTopicStore');
                    combo.bindStore(store);
                }
            }
        },{
	        xtype: 'customcombobox',
	        name: 'programId',
	        itemId: 'programItemId',
	        fieldLabel: getPersonModuleTranslation('PROGRAM'),
	        allowBlank: false,
	        valueField: 'id',
	        displayField: 'value',
	        store : Ext.create('Academia.store.common.ApplicantProgramByApplicationIdStore'),
	        forceSelection: true
        }]
    }, {
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 226
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
            xtype: 'customcombobox',
            name: 'batch',
            itemId: 'batchCombo',
            displayField: 'value',
            valueField: 'id',
            allowBlank:false,
            disabled: true,
           // store : Ext.create('Academia.store.common.ApplicantBatchByProgramIdStore'),
            fieldLabel: getPersonModuleTranslation('BATCH'),
            forceSelection: true,
            listeners: {
                render: function(combo) {
                	var store = Ext.create('Academia.store.common.ApplicantBatchByProgramIdStore');
                	store.setProxy({
						type : 'rest',
						api : {
							read : SERVERURL.GET_APPLICANT_ALL_BATCHES_BY_APPLICATIONID
						},
						reader : {
							type : 'json'
						}
					})
                    combo.bindStore(store);
                }
            }
        },{
            xtype: 'customcombobox',
            name: 'period',
            itemId: 'periodId',
            fieldLabel: getPersonModuleTranslation('PERIOD'),
            editable: false,
            disabled:true,
            allowBlank:false,
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                	var store = Ext.create('Academia.store.common.ApplicantPeriodByBatchIdStore');
                	store.setProxy({
						type : 'rest',
						api : {
							read : SERVERURL.GET_APPLICANT_ALL_PERIOD_BY_APPLICATIONID
						},
						reader : {
							type : 'json'
						}
					})
                    combo.bindStore(store);
                }
            }
        },{
			xtype : 'customcombobox',
			fieldLabel : getPersonModuleTranslation('STATUS'),
			name : 'status',
			itemId:'status',
			store: Ext.create('Academia.store.student.studentprofile.AcademicTopicStatusStore'),
			displayField: 'value',
			valueField: 'code'
		}]
    	},{
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            labelAlign: 'top',
	            width: 226
	        },
	    items: [{
        	xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('CREATED_DATE'),
            itemId: 'createdDate',
            name: 'createdDate',
            editable : false,
            startDateField : 'createdDate',
            readOnly : true,
            listeners: {
            	render: function(obj) {
            		obj = dateFormatRender(obj);
            		obj.setValue(new Date());
            	}
            },
            allowBlank: true,
            vtype : 'daterange'
        },{
        	xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('CREATED_BY'),            
            itemId: 'createdById',
            name: 'createdById',
            readOnly : true,
            allowBlank: true
        },{
			xtype : 'datefield',
			anchor : '100%',
			fieldLabel : getCommonTranslation('DATE'),
			name : 'date',
			itemId:'dateId',
			maxValue: new Date(),
			value: new Date(),
			editable:false,
			disabled:true,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
					 setTimeout(function() { 
						 field.setValue(new Date());
					 }, 1000);
				}
			},
			vtype : 'daterange',
			allowBlank:true
        }]
	},{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
    items: [{
    	xtype: 'datefield',
        fieldLabel: getPersonModuleTranslation('UPDATED_DATE'),
        itemId: 'updatedDate',
        name: 'updatedDate',
        editable : false,
        startDateField : 'updatedDate',
        readOnly : true,
        listeners: {
        	render: function(obj) {
        		obj = dateFormatRender(obj);
        		obj.setValue(new Date());
        	}
        },
        allowBlank: true,
        vtype : 'daterange'
    },{
    	xtype: 'textfield',
        fieldLabel: getPersonModuleTranslation('UPDATED_BY'),            
        itemId: 'updatedById',
        name: 'updatedById',
        readOnly : true,
        allowBlank: true
    }]
	},{
	xtype: 'fieldcontainer',
	width: 'auto',
	defaults: {
		labelAlign: 'top',
		width: 934,
		height: 150
	},
	layout: {
		type: 'fit'
	},
	items: [{
		xtype : 'textareafield',
		grow : true,
		name : 'description',
		itemId: 'descriptionId',
		allowBlank:false,
		fieldLabel: getCommonTranslation('DESCRIPTION'),
		maxLength:64000,
		allowOnlyWhitespace: false,
		listeners: {
			blur: function(combo) {
			}
		}
	}]
	},{
	xtype: 'fieldcontainer',
	hidden: true,
	items:[{
		xtype:'checkboxfield',
		boxLabel  : getCommonTranslation('UPLOAD_DOCUMENT'),
        name      : 'uploadDocument',
        itemId:'uploadDocumentItemId',
        inputValue: true,
        uncheckedValue:false,
        hidden: true
	}]
	},{
	xtype: 'fieldcontainer',
	width: 'auto',
	defaults: {
		labelAlign: 'top',
		width: 452
	},
	layout: {
		type: 'hbox'
	},
	items: [{
			xtype:'checkboxfield',
			boxLabel  : getPersonModuleTranslation('PUBLISH_ON_STUDENT_OR_PARENT_PORTAL'), 
            name      : 'isPublished',
            itemId:'public',
			checked: true,
			inputValue: true
	}]
		},{
	    	xtype: 'fieldcontainer',
	    	items: [{
	    		xtype:'documentandnotesdocumentgrid',
	    		hidden:true,
	    		width:600,
	    		style:{
	    			marginLeft:'5px'
	    		}
	    	}, {
	    		xtype:'documentandnotesurlgrid',
	    		hidden:true,
	    		width:600,
	    		style:{
	    			marginLeft:'5px'
	    		}
	    	}]
    	},{
    	xtype: 'fieldcontainer',
    	items: [{
    		xtype: 'button',
    		text: getCommonTranslation('SUBMIT'),
    		itemId: 'submitButtonId',
    		buttonAlign: 'right',
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    		formBind: true
    	}, {
    		xtype: 'button',
    		text: getCommonTranslation('CANCEL'),
    		ui: 'CustomBtnCancel',
    		itemId: 'cancelButtonId',
    		scale: CONSTANTS.BUTTONSIZE
    	},{
			 xtype: 'button',
			 name: 'academicTopicDocument',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'academicTopicDocument',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		},{
			 xtype: 'button',
			 name: 'academicTopicDocumentUrl',
			 text:getCommonTranslation('UPLOAD_URL'),
			 itemId: 'academicTopicDocumentUrl',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});