/**
 * @author Vyabha Thakur
 * 
 */
Ext.define('Academia.view.admission.applications.applicationBase.ImportApplicantRelationshipDownloadForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.importapplicantrelationshipdownloadform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype:'fieldcontainer',
		itemId:'programBatchContainerId',
		items:[{
			xtype : 'fieldcontainer',
			width: '100%',
			itemId:'programBatchContainer',
			layout : 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items : [{			
				xtype : 'multiselectcombofield',
				cls:'commonAutoHeightMultiselectField',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				autoloadStore: false,
				name : 'PROGRAM_NAME',
				itemId : 'program',      	   
				displayField : 'valueCode',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank : true,
				maxLength:25000,
				width:300,
				hidden : false,
				queryMode:'local',
				matchFieldWidth:true,
				listeners: {
					render: function(combo) {
						var store = Ext.create('Academia.store.program.ProgramConfigured');
						combo.bindStore(store);
					}
						},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'+ 
						'</div>';
					}
				},
			},{
				xtype : 'multiselectcombofield',
				cls:'commonAutoHeightMultiselectField',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				autoloadStore: false,
				name : 'BATCH_NAME',
				itemId : 'batch',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank : true,
				maxLength:25000,
				hidden : false,
				width:300,
				queryMode:'local',
				disabled:true,
				editable: false,
				matchFieldWidth:true,
				listeners: {
					render: function(combo) {
						var store = Ext.create('Academia.store.program.ConfiguredBatchListStore');
						combo.bindStore(store);
					}
						},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'+ 
						'</div>';
					}
				},
			},{
				xtype : 'multiselectcombofield',
				cls:'commonAutoHeightMultiselectField',
				fieldLabel: getEnquiryTranslation('SEAT_TYPE'),
				autoloadStore: false,
				name: 'SEAT_TYPE',
				itemId:'seatType',
				displayField: 'value',
				valueField: 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank : true,
				maxLength:25000,
				hidden : false,
				width:300,
				queryMode: 'local',
				disabled:true,
				editable: false,
				matchFieldWidth:true,
				listeners: {
					render: function(combo) {
						var store = Ext.create('Academia.store.program.ConfiguredSeatTypeListStore');
						combo.bindStore(store);
					}
						},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'+ 
						'</div>';
					}
				},
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('APPLICATION_STATUS'),
				name: 'applicationstatus',
				itemId: 'applicationstatus',
				store: 'admission.applications.applicationBase.ApplicationStatusRelationshipLoaderStore',                 
				valueField: 'name',
				displayField: 'value',
				queryMode : 'local',
				matchFieldWidth:true
			}]
		}]
	},{
					xtype:'fieldcontainer',
					layout : 'hbox',
					items:[{
						xtype: 'fieldcontainer',
						width: 'auto',
					items: [{
			           	 xtype: 'button',
			        	 text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
			             itemId: 'downoladBtnId',
			             hidden:false,
			             ui: 'CustomBtnSubmit'
			        },{
		                xtype: 'button',
		                text: getCourseTxCommonTranslation('RESET'),
		                itemId: 'resetBtn',
		                buttonAlign: 'left',
		                ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
		            }]
	}]
	}]
});
