/**
 * @author Pravin.Surve
 */
Ext.define('Academia.view.admission.replacement.CloseReplacementGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.closereplacementgrid',
    title: getAdmissionTranslation('CLOSE_REPLACEMENT'),
    border: true,
    autoScroll: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel:Ext.create('Ext.selection.CheckboxModel',{
		checkOnly: true,
	    mode: 'multi',
    	showHeaderCheckbox : false
    }),
    plugins: [{
        ptype: 'rowexpander',
        pluginId: 'CloseReplacementRowExpander',
        rowBodyTpl: [ '<tpl for="."><tpl if="!Ext.isEmpty(programStageDetails)">',
		               	'<table style="width: 108%;text-align:right;margin-right: 10px">',

		                '<thead>',
		                '<tr>',
		                        //'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'+getAdmissionTranslation('SELECTION_PROCESS')+'</th>',
		                '</tr>',
		                '</thead>',
		               		'<tpl for="programStageDetails">',
		               			'<tr>',
		               				'<td style="width: 53%;text-align:right;margin-right: 10px">{stageStatus}</td>',
		               				'<td style="width: 10%;text-align:right;margin-right: 10px">{startDate}</td>',
		               				'<td style="width: 8%;text-align:right;margin-right: 10px">{endDate}</td>',
		               			'</tr>',
		               		'</tpl>',
		               	'</table></tpl>',
		               '</tpl>' ]
    }],
    initComponent: function() {
    	var grid=this;                
    	var store=Ext.create('Academia.store.admission.replacement.CloseReplacementStore');
    	var columns =new Array();
    	var columnArray=new Array();
    	var toolBarItems=new Array();
    	   	columnArray=columnArray.concat(grid.getFixedColumns());				    	   		    	   		
			columns=columnArray;
			toolBarItems=grid.getToolBarItems();
			grid.selModel=Ext.create('Ext.selection.CheckboxModel',{    		    	
    				checkOnly: true,
    			    mode: 'single'
    		  });
       
        this.doLayout();
        Ext.apply(this, {
            store: store,
            columns: columns,
            tbar:toolBarItems,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    displayInfo: true,
                    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE')      
                }]
            }]
        });
        this.callParent(arguments);
    },
    columns: [],
    
    getFixedColumns:function(){
    	var fixedColumns=[{
            header: getAdmissionTranslation('ACADEMY'), //Academy 
            dataIndex: 'academy.value',
            flex: .2,
            sortable: true
        }, {
            header: getAdmissionTranslation('LOCATION'), //Location
            dataIndex: 'location.value',
            flex: .2,
            sortable: true
        }, {
            header: getAdmissionTranslation('PROGRAM'), //Program
            dataIndex: 'program.value',
            flex: .2,
            sortable: true
        }, {
            header: getAdmissionTranslation('BATCH'), //Batch
            dataIndex: 'batch.value',
            flex: .2,
            sortable: true
        }, {
            header: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
            dataIndex: 'seatType.value',
            flex: .2,
            sortable: true
        },{
            header: getAdmissionTranslation('SELECTION_PROCESS'), //Seat Type
            dataIndex: 'selectionProcess.value',
            flex: .2,
            sortable: true
        },{
            header: getAdmissionTranslation('START_DATE'), //Seat Type
            dataIndex: 'startDate',
            flex: .2,
            sortable: true,
    		renderer:function(value) {
    			return dateRender(value);
    		}
        },{
            header: getAdmissionTranslation('END_DATE'), //Seat Type
            dataIndex: 'endDate',
            flex: .2,
            sortable: true,
    		renderer:function(value) {
    			return dateRender(value);
    		}
        }];
    	
    	return fixedColumns;
    },
    getToolBarItems:function(){
    	var items=[{
            xtype: 'button',
            text: getAdmissionTranslation('CLOSE_REPLACEMENT'), 
            itemId: 'closeReplacementBtn',
            disabled: true
        }];
    	
    	return items;
    }  
});
