/**
 * @author Pravin.Surve
 */
Ext.define('Academia.view.admission.replacement.StudentToBeReplaceGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.studenttobereplacegrid',
    title: getAdmissionTranslation('STUDENT_TO_BE_REPLACED'),
    border: true,
    autoScroll: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    tbar: [{
        xtype: 'customcombobox',
        width: 320,
        itemId: 'studentReplaceSelectionStageCombo',
        name: 'programSelectionProcessStageId',
        fieldLabel: getAdmissionTranslation('REPLACE_CANDIDATES_IN'),
        labelWidth:140,
        displayField: 'value',
        valueField: 'id',
        queryMode: 'local',
        autoload: false,
        listeners: {
            render: function(combo) {
                var store = Ext.create('Academia.store.admission.selectionStage.SelectionStageFromSeatType');
                combo.bindStore(store);
            }
        }
    },{
        xtype: 'button',
        disabled: true,
        text: getAdmissionTranslation('SELECTION_STATISTIC'),
        itemId: 'replaceStudentSelectionStatistic',
        //buttonAlign: 'left',
        //ui: 'CustomBtnCancel',
        scale: CONSTANTS.BUTTONSIZE
    }],
    columns: [{
        header: getAdmissionTranslation('REPLACE_TO_APPLICATION_ID'),
        dataIndex: 'replacedToBeAppId',
        sortable: true,
        flex: 0.5,
        renderer: function(value) {
            return '<a href="#">' + value + '</a>';
        }
    }, {
        header: getAdmissionTranslation('STUDENT_NAME'),
        dataIndex: 'replacedToBeAppName',
        sortable: true,
        flex: 1
    }, {
        header: getAdmissionTranslation('RANK'),
        dataIndex: 'rank',
        sortable: true,
        flex: 0.5
    }, {
        header: getAdmissionTranslation('QUOTA_RANK'),
        dataIndex: 'quotaRank',
        sortable: true,
        flex: 0.5
    }, {
        header: getAdmissionTranslation('STATUS'),
        dataIndex: 'replacedToBeStageStatus',
        sortable: true,
        flex: 1

    }, {
        header: getAdmissionTranslation('OFFER_LETTER_SENT_DATE'),
        dataIndex: 'offerLetterSentDate',
        sortable: true,
        flex: 1,
		renderer:function(value) {
			return dateRender(value);
		}
    }],

    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.admission.replacement.StudentToBeReplaceStore');
    }

});