/**
 * This Grid is used for Documents grid in the documents tab of the configure stage of the
 * Selection process.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.selectionProcess.DocumentsGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.documentsgrid',
	title : getAdmissionTranslation('STAGE_DOCUMENTS'),
	border : true,
	store: 'admission.selectionProcess.DocumentGridRecords',
	
	columns : [ {
		text : getAdmissionTranslation('DOCUMENT_NAME'),
		dataIndex: 'documentType',
		sortable : true,
		flex: .4,
		renderer: function(obj) {
			return columnObjRender(obj, 'value');
		}
	}, {
		text : getAdmissionTranslation('APPLICABILITY'),
		dataIndex : 'documentFor',
		sortable : true,
		flex: .3,
		renderer: function(obj) {
			return getAdmissionTranslation(obj);
		}
	}, {
		text : getAdmissionTranslation('REMARKS'),
		dataIndex : 'remark',
		sortable : true,
		flex: .3
	}],
	dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
        	xtype: 'custompagingtoolbar',
	        plugins:['pagesize'],
        	displayInfo : true,		 
        	emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			store : 'admission.selectionProcess.DocumentGridRecords'
        }]
    }],
    tbar : [{
		xtype : 'button',				
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}]
});