/**
 * Reset Password Form
 * @author Niklesh Tiwane
 */
Ext.define('Academia.view.alumniSystem.alumniCommon.widget.AlumniResetPassword',{
	extend : 'Ext.window.Window',
	alias : 'widget.alumniresetpassword',
	title:getCommonTranslation('RESET_PASSWORD'),
	modal: true,
	y: 100,
	style:{
    	height:'auto'
    },
    resizable: false,
    bodyCls: 'resetPwdCls',
	items : [{
		xtype : 'form',
		height: 'auto',
		standardSubmit: false,
	    plugins: "formlabelrequired",
	    defaults:{
			labelAlign: 'top',
			width: 226
		},
	items : [{
		xtype:'hidden',
		name: 'resetPasswordFilterdata',
		ItemId:'resetPasswordFilterdataItemId'
	},{
		xtype:'hidden',
		name: 'isForAll',
		ItemId:'isForAllItemId'
	},{
	    xtype : 'textfield',
	    allowBlank: false,
	    inputType : 'password',
	    name: 'resetPassword',
	    itemId: 'resetPassword',
	    invalidCls:Ext.baseCSSPrefix + 'form-invalid',
   	    msgTarget:'under',
   	    enforceMaxLength:true,
	    fieldLabel : getCommonTranslation('NEW_PASSWORD')
	}, {
	    xtype : 'textfield',
	    allowBlank: false,
	    inputType : 'password',
	    name: 'confirmedPassword',
	    itemId : 'confirmedPassword',
	    enforceMaxLength:true,
	    fieldLabel : getCommonTranslation('CONFIRM_PASSWORD'),
	    vtype: 'passwordAndPolicyMatch',
	    initialPassField: 'resetPassword'
	},{
    	xtype:'fieldcontainer',
    	style:{
    		marginTop : '31px!important',
    		marginLeft : '46% !important'    		
        },
        items: [{
				xtype: 'button',
				formBind: true,
				text : getCommonTranslation('SUBMIT'),
				itemId: 'submitBtn',
				ui: 'CustomBtnSubmit',
			//	cls:'submitBtnPassword',
				scale: CONSTANTS.BUTTONSIZE    			
        	},{
				xtype: 'button',				
				text : getCommonTranslation('CANCEL'),
				itemId: 'cancelBtn',
				ui: 'CustomBtnCancel',
			//	cls:'resetBtnPassword',
				scale: CONSTANTS.BUTTONSIZE,
				handler: function(btn){
					btn.up().up().up().hide()
				}
				
        	}]
		}]
    }]
});