/**
 *  @author Amit Gupta
 */

/*@author: Amit Gupta*/
Ext.define('Academia.view.alumniSystem.alumniCommunicationHistory.AlumniCommunicationHistoryGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.alumnicommunicationhistorygrid',
    store: 'alumni.alumniCommunicationHistory.AlumniCommunicationHistoryGridStore',
    title: getAlumni('COMMUNICATION_HISTORY'),
    border: true,
	autoScroll: false,
    selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
	},
    refreshStoreData: true,
    isGridConfigurable: true, 
    enableColumnHide: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
    },
    headerFix: {
    	headerFix: true,
    	portalIdsWithStructure: {
			'alumninewsandfeedsstructure':1
		}
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'alumni.alumniCommunicationHistory.AlumniCommunicationHistoryGridStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true,
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: [],
    columns: [{
        header: getAlumni('ALUMNIID'),
        dataIndex: 'alumniCode',
        flex: 1
    },{
        header: getAlumni('ALUMNI_NAME'),
        dataIndex: 'alumniName',
        flex: 1
    }, {
        header: getAlumni('NOTIFICATION_TYPE'),
        dataIndex: 'notificationType',
        flex: 1,
        renderer:function(value) {
           if(value == 'RESET_PASSWORD'){
				return 'Reset Password'
			}else if(value == 'FORGOT_PASSWORD'){
				return 'Forgot Password'
			}else if(value == 'NEWS_AND_FEEDS'){
				return 'News And Feeds'
			}else if(value == 'DONATION'){
				return 'Donation'
			}else if(value == 'EVENTS'){
				return 'Events'
			}else{
				return 'Gallery'
			}
        }
    }, {
        header: getAlumni('EMAIL_ID'),
        dataIndex: 'emailId',
        flex: 1
    }, {
        header: getAlumni('SENT_DATE'),
        dataIndex: 'createdDate',
        flex: 1,
        renderer:function(value) {
            return dateRender(value);
        }
    }, {
        header: getAlumni('MESSAGE'),
        dataIndex: 'contentPath',
        flex: 1,
        renderer: function(value) {
            if (!isNullOrEmpty(value)) {
                return '<a href="#">view</a>';
            } else {
                return null;
            }
        }
    }/*, {
        header: getAlumni('SENT_BY'),
        dataIndex: 'sentBy',
        flex: 1
    }*/,{
        header: getAlumni('STATUS'),
        dataIndex: 'messageStatus',
        flex: 1,
        renderer:function(value) {
           if(value == 'SUCCESS'){
				return 'Success'
			}else if(value == 'FAILURE'){
				return 'Failure'
			}else{
				return 'Pending'
			}
        }
    }]
});
