/**
 *  @author Harshit Satya
 */
Ext.define('Academia.view.alumniSystem.alumniFundsRaising.AlumniFundsRaisingAddRaiseFund', {
    extend: 'Ext.form.Panel',
    alias: 'widget.alumnifundsraisingaddraisefund',
    autoScroll: false,
    frame: false,
    plugins: "formlabelrequired",
    style: {
        marginLeft: CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    defaults: {
        labelAlign: 'top',
    },
    items: [{
    	xtype: 'hidden',
    	itemId: 'recordId',
    	name: 'recordId'
    },{
    	xtype: 'hidden',
    	itemId: 'hiddenImageItemId',
    	name: 'hiddenImage'
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getAlumni('FUND_ID'),
            name: 'fundsCode',
            itemId: 'fundsCodeItemId',
            readOnly: true,
            emptyText: 'ID will be Auto Generated'
        }, {
            xtype: 'textfield',
            fieldLabel: getAlumni('TITLE'),
            name: 'title', 
            maxLength: 100,
            itemId: 'titleItemId',
            allowBlank: false
        }, {
            xtype: 'customcombobox',
            fieldLabel: getAlumni('CURRENCY'),
            name: 'currency',
            itemId: 'currencyItemId',
            store: 'alumni.alumniFundsRaising.AlumniFundsCurrencyStore',
            displayField: 'name',
            valueField: 'id',
            forceSelection: true,
//            queryMode: 'local',
            editable: false,
            allowBlank: false,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.width = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND')	
            },
            listeners: {
                afterrender: function (combo) {
                    combo.getStore().load();  // Trigger store load on combobox render
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'numberfield',
            fieldLabel: getAlumni('DONATION_GOAL'),
            name: 'donationGoal',
            itemId: 'donationGoalItemId',
            allowBlank: false,
            minValue: 1,
            allowExponential: false,
        },{
            xtype: 'datefield',
            fieldLabel: getAlumni('START_DATE'),
            name: 'startDate',
            itemId: 'startDateItemId',
            minValue: new Date(),  // Prevents selecting dates before today
            listeners: {
                change: function(field, newValue) {
                    var endDateField = field.up('form').down('#endDateItemId');
                    if (newValue && endDateField) {
                        endDateField.setMinValue(newValue);  // Set the end date's minimum value based on start date
                    }
                },
				render: function(field) {
					return dateFormatRender(field);
				}
            }
        }, {
            xtype: 'datefield',
            fieldLabel: getAlumni('END_DATE'),
            name: 'endDate',
            itemId: 'endDateItemId',
            listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
            },
            minValue: new Date()  // Prevents selecting dates before today
        }
]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'multiselectcombofield',
            width: 465,
            name: 'academyLocations',
            itemId: 'multiselectTargetByStaffAcademyId',
            allowBlank: false,
            fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
            store: Ext.create('Academia.store.organization.academylocations.AcademyLocationStore'),
            displayField: 'value',
            valueField: 'id',
            matchFieldWidth: true,
            maxLength: 15000,
            autoloadStore: false,
            editable: false,
            //queryMode: 'local',
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.width = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">{value}</div>';
                }
            },
            listeners: {
                afterrender: function(field) {
                    field.getEl().on('keydown', function(e) {
                        e.stopEvent(); 
                    });
                }
            }
        }]
    }, {
    	xtype: 'panel',
        itemId: 'dynamicMainPanel',
        layout: 'vbox',
        style: {
            marginTop: '20px',
            marginLeft: '0',
        },
        items: [{
            xtype: 'container',
            html: '<h4>' + getAlumni('DONATION_RANGE') + '</h4>',
            style: {
                marginBottom: '10px'
            }
        }, {
            xtype: 'fieldcontainer',
            title: getAlumni('DONATION_RANGE'),
            layout: {
                type: 'hbox',
            },
            defaults: {
                labelAlign: 'top',
                allowBlank: false,
                allowExponential: false
            },
            items: [{
                xtype: 'numberfield',
                fieldLabel: getAlumni('MINIMUM_AMOUNT'),
                name: 'minAmt',
                itemId: 'minAmt',
                minValue: 1,
                width: 226,
                allowExponential: false,
                listeners: {
                    change: function(field, newValue) {
                        var maxAmtField = field.up().down('numberfield[name=maxAmt]');
                        if (maxAmtField) {
                            maxAmtField.setMinValue(newValue + 1);
                            var maxAmtValue = maxAmtField.getValue();
                            if (maxAmtValue <= newValue) {
                                maxAmtField.setValue(newValue + 1);  
                            }
                        }
                    }
                }
            }, {
                xtype: 'numberfield',
                fieldLabel: getAlumni('MAXIMUM_AMOUNT'),
                name: 'maxAmt',
                itemId: 'maxAmt',
                width: 226,
                minValue: 1,
                allowExponential: false
            }, {
            	xtype: 'button',
                itemId: 'btnAddRange',
                cls: 'CustomBodyBtnSettings',
                text: getAlumni('+'),
                style: {
                    marginTop: '30px',
                },
                width: 30,
                height: 28,
                disabled: true
            }]
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top'
        },
        items: [{ 
        	xtype: 'photouploadform',
            name: 'alumniRaiseFunduploadImage',
            itemId: 'alumniRaiseFunduploadImageItemId',
        }, {
            xtype: 'combobox',
            fieldLabel: getAlumni('STATUS'),
            name: 'status',
            itemId: 'statusItemId',
            store: Ext.create('Academia.store.alumni.alumniList.AlumniStatusStore'),
            style: {
            	marginTop: '3px',
            	marginLeft: '9px'
            },
            width: 226,
            displayField: 'value',
            valueField: 'id',
            forceSelection: true,
            value: 'active',
            allowBlank: false
        }]
    }, {
        xtype: 'textareafield',
        fieldLabel: getAlumni('DESCRIPTION'),
        name: 'description',
        itemId: 'descriptionItemId',
        maxLength: 512,
        width: 560,
        height: 150,
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SAVE'),
            name: 'btnSave',
            itemId: 'btnSaveItemId',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            name: 'btnReset',
            itemId: 'btnResetItemId',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }],
});
