/**
 *  @author Harshit Satya
 */
Ext.define('Academia.view.alumniSystem.alumniNewsAndFeeds.AlumniAddNewsAndFeeds', {
    extend: 'Ext.form.Panel',
    alias: 'widget.alumniaddnewsandfeeds',
    autoScroll: false,
    plugins: "formlabelrequired",
    style: {
        marginLeft: CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    defaults: {
        labelAlign: 'top',
    },
    items: [{
            xtype: 'hidden',
            itemId: 'recordId',
            name: 'recordId'
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top'
            },
            items: [{
                xtype: 'textfield',
                fieldLabel: getAlumni('NEWS_ID'),
                name: 'newsId',
                itemId: 'newsIdItemId',
                readOnly: true,
                width: 226,
                emptyText: 'ID will be Auto Generated'
            }, {
                xtype: 'textfield',
                fieldLabel: getAlumni('NEWS_TITLE'),
                name: 'newsTitle',
                itemId: 'newsTitleItemId',
                allowBlank: false,
                maxLength: 100,
                width: 462
            }],
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top'
            },
            items: [{
            	 xtype: 'multiselectcombofield',
            	    width: 462,
            	    name: 'academyLocations',
            	    itemId: 'multiselectTargetByStaffAcademyId',
            	    allowBlank: false,
            	    fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
            	    store: Ext.create('Academia.store.organization.academylocations.AcademyLocationStore'),
            	    displayField: 'value',
            	    valueField: 'id',
            	    matchFieldWidth: true,
            	    maxLength: 15000,
            	    autoloadStore: false,
            	    editable: false,
            	    listConfig: {
            	        listeners: {
            	            beforeshow: function (picker) {
            	                picker.width = picker.up('combobox').getSize().width;
            	            }
            	        },
            	        loadingText: getCommonTranslation('SEARCHING'),
            	        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            	        getInnerTpl: function () {
            	            return '<div class="search-item">{value}</div>';
            	        }
            	    },
            	    listeners: {
            	        afterrender: function(field) {
            	            field.getEl().on('keydown', function(e) {
            	                e.stopEvent();
            	            });
            	        },
            	    }
            }, {
            	xtype: 'customcombobox',
                fieldLabel: getAlumni('PROGRAM'),
                name: 'alumniProgram',
                itemId: 'alumniProgramItemId',
                store: Ext.create("Academia.store.common.ProgramStore"),
                forceSelection: true,
                valueField: 'id',
                displayField: 'value',
                editable: false,
                disabled: true, 
                minChars: 3,
                width: 226,
                listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                },
            }],
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 226,
            },
            items: [{
            	 xtype: 'customcombobox',
            	    fieldLabel: getAlumni('BATCH'),
            	    store: Ext.create('Academia.store.alumni.alumniList.AlumniBatchStore'),
            	    name: 'alumniBatch',
            	    itemId: 'alumniBatchItemId',
            	    forceSelection: true,
            	    valueField: 'id',
            	    displayField: 'value',
            	    editable: false,
            	    disabled: true, 
            	    width: 226,
            	    listConfig: {
            	        listeners: {
            	            beforeshow: function(picker) {
            	                picker.minWidth = picker.up('combobox').getSize().width;
            	            }
            	        },
            	        loadingText: getCommonTranslation('SEARCHING'),
            	        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            	    }
            }, {
                xtype: 'customcombobox',
                fieldLabel: getAlumni('PASSOUT_YEAR'),
                name: 'passoutYear',
                itemId: 'passoutYearItemId',
                store: 'alumni.alumniNewsAndFeeds.AlumniPassOutYearStore',
                displayField: 'year',
                valueField: 'year',
                forceSelection: true,
                editable: false,
                editable: false,
                listConfig: {
                    listeners: {
                        beforeshow: function (picker) {
                            picker.width = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND')
                },
                listeners: {
    			    afterrender: function (combo) {
    			        combo.getStore().load(); 
    			    }
    			}
            }],
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 226,
            },
            items: [{
            	xtype: 'datefield',
                fieldLabel: getAlumni('START_DATE'),
                name: 'startDate',
                itemId: 'startDateItemId',
                minValue: new Date(),
                listeners: {
                    change: function(field, newValue) {
                        var endDateField = field.up('form').down('#endDateItemId');
                        var startTimeField = field.up('form').down('#startTimeItemId');
                        
                        // Enable startTime field only if startDate is selected
                        if (newValue) {
                            if (startTimeField) {
                                startTimeField.setDisabled(false);
                            }
                            if (endDateField) {
                                endDateField.setMinValue(newValue);  // Set the end date's minimum value based on start date
                            }
                        } else {
                            if (startTimeField) {
                                startTimeField.setDisabled(true); // Disable startTime field if no startDate is selected
                            }
                        }
                    },
                    render: function(field) {
    					return dateFormatRender(field);
    				}
                }
            }, {
            	xtype: 'timefield',
        	    name: 'startTime',
        	    itemId: 'startTimeItemId',
        	    fieldLabel: getAlumni('START_TIME'),
        	    vtype: 'timerange',
        	    submitFormat: 'g:i A',
        	    endTimeField: 'outTimeId',
        	    listeners: {
        	        render: function(field) {
        	            field.setDisabled(true); // Initially disable the startTime field
        	            return timeFormatRender(field);
        	        }
        	    },
        	    editable: false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 226,
            },
            items: [{
            	xtype: 'datefield',
                fieldLabel: getAlumni('END_DATE'),
                name: 'endDate',
                itemId: 'endDateItemId',
                minValue: new Date(),
                listeners: {
                    change: function(field, newValue) {
                        var endTimeField = field.up('form').down('#endTimeItemId');
                        
                        // Enable endTime field only if endDate is selected
                        if (newValue) {
                            if (endTimeField) {
                                endTimeField.setDisabled(false);
                            }
                        } else {
                            if (endTimeField) {
                                endTimeField.setDisabled(true); // Disable endTime field if no endDate is selected
                            }
                        }
                    },render: function(field) {
    					return dateFormatRender(field);
    				}
                }
            }, {
            	xtype: 'timefield',
        	    name: 'endTime',
        	    itemId: 'endTimeItemId',
        	    fieldLabel: getAlumni('END_TIME'),
        	    vtype: 'timerange',
        	    submitFormat: 'g:i A',
        	    endTimeField: 'outTimeId',
        	    listeners: {
        	        render: function(field) {
        	            field.setDisabled(true); // Initially disable the endTime field
        	            return timeFormatRender(field);
        	        }
        	    },
        	    editable: false
            }]
        }, {
        	xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox',
            },
            defaults: {
                labelAlign: 'top',   
            },
            items: [{
                xtype: 'textareafield',
                fieldLabel: getAlumni('DESCRIPTION'),
                name: 'description',
                itemId: 'descriptionItemId',
                maxLength: 512,
                width: 463,
//                height: 150,
            },{ 
            	xtype: 'alumniphotouploadform',
                name: 'alumniNewsAndFeedsUploadImage',
                itemId: 'alumniNewsAndFeedsUploadImageItemId',
            },{
            	xtype: 'textareafield',
            	fieldLabel: 'Uploaded Image',
            	name: 'imagePathDisplay',
            	itemId: 'imagePathDisplayItemId',
            	width: 226,
            	height: '50%',
//            	style: {
//            		marginTop: "20px",
//            	},
            	hidden: true
            }]
        },{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',  
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                name: 'btnSave',
                itemId: 'btnSaveItemId',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('RESET'),
                name: 'btnReset',
                itemId: 'btnResetItemId',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }],
        
        setMode: function(mode) {
            var me = this;
            
            var startDateField = me.down('#startDateItemId');
            if (mode === 'add') {
                me.getForm().reset(); 
                me.down('#btnSaveItemId').show();
                me.down('#btnResetItemId').show();
            }

            if (mode === 'edit') {
            	me.down('#btnSaveItemId').show();
                me.down('#btnResetItemId').hide();
                if (startDateField) {
                    startDateField.setMinValue(null); 
                }
            }

            if (mode === 'view') {
                me.getForm().getFields().each(function(field) {
                    field.setReadOnly(true);  
                });
                me.down('#btnSaveItemId').hide();
                me.down('#btnResetItemId').hide();
                
                var uploadField = me.down('#alumniNewsAndFeedsUploadImageItemId');
                if (uploadField) {
                    uploadField.hide(); 
                }
                
                var imagePathField = me.down('#imagePathDisplayItemId');
                if (imagePathField) {
                    imagePathField.show(); 
                }
                
            }
        }
});
